/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ImplementedMethods {
    private Map interfaces = new HashMap();
    private List methlist = new ArrayList();
    private Configuration configuration;
    private final ClassDoc classdoc;
    private final MethodDoc method;

    public ImplementedMethods(MethodDoc methodDoc, Configuration configuration) {
        this.method = methodDoc;
        this.configuration = configuration;
        this.classdoc = methodDoc.containingClass();
    }

    public MethodDoc[] build() {
        this.buildImplementedMethodList();
        return this.methlist.toArray(new MethodDoc[this.methlist.size()]);
    }

    public Type getMethodHolder(MethodDoc methodDoc) {
        return (Type)this.interfaces.get(methodDoc);
    }

    private void buildImplementedMethodList() {
        List list = Util.getAllInterfaces(this.classdoc, this.configuration);
        for (Type type : list) {
            MethodDoc methodDoc = Util.findMethod(type.asClassDoc(), this.method);
            if (methodDoc == null) continue;
            this.removeOverriddenMethod(methodDoc);
            if (this.overridingMethodFound(methodDoc)) continue;
            this.methlist.add(methodDoc);
            this.interfaces.put(methodDoc, type);
        }
    }

    private void removeOverriddenMethod(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.overriddenClass();
        if (classDoc != null) {
            for (int i = 0; i < this.methlist.size(); ++i) {
                ClassDoc classDoc2 = ((MethodDoc)this.methlist.get(i)).containingClass();
                if (classDoc2 != classDoc && !classDoc.subclassOf(classDoc2)) continue;
                this.methlist.remove(i);
                return;
            }
        }
    }

    private boolean overridingMethodFound(MethodDoc methodDoc) {
        ClassDoc classDoc = methodDoc.containingClass();
        for (int i = 0; i < this.methlist.size(); ++i) {
            MethodDoc methodDoc2 = (MethodDoc)this.methlist.get(i);
            if (classDoc == methodDoc2.containingClass()) {
                return true;
            }
            ClassDoc classDoc2 = methodDoc2.overriddenClass();
            if (classDoc2 == null || classDoc2 != classDoc && !classDoc2.subclassOf(classDoc)) continue;
            return true;
        }
        return false;
    }
}

