/*
 * Decompiled with CFR 0.152.
 */
package sun.security.rsa;

import java.math.BigInteger;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Map;
import java.util.WeakHashMap;
import javax.crypto.BadPaddingException;
import sun.security.jca.JCAUtil;

public final class RSACore {
    private static final boolean ENABLE_BLINDING = true;
    private static final int BLINDING_MAX_REUSE = 50;
    private static final Map blindingCache = new WeakHashMap();

    private RSACore() {
    }

    public static int getByteLength(BigInteger bigInteger) {
        int n2 = bigInteger.bitLength();
        return n2 + 7 >> 3;
    }

    public static int getByteLength(RSAKey rSAKey) {
        return RSACore.getByteLength(rSAKey.getModulus());
    }

    public static byte[] convert(byte[] byArray, int n2, int n3) {
        if (n2 == 0 && n3 == byArray.length) {
            return byArray;
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        return byArray2;
    }

    public static byte[] rsa(byte[] byArray, RSAPublicKey rSAPublicKey) throws BadPaddingException {
        return RSACore.crypt(byArray, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    public static byte[] rsa(byte[] byArray, RSAPrivateKey rSAPrivateKey) throws BadPaddingException {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            return RSACore.crtCrypt(byArray, (RSAPrivateCrtKey)rSAPrivateKey);
        }
        return RSACore.crypt(byArray, rSAPrivateKey.getModulus(), rSAPrivateKey.getPrivateExponent());
    }

    private static byte[] crypt(byte[] byArray, BigInteger bigInteger, BigInteger bigInteger2) throws BadPaddingException {
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        return RSACore.toByteArray(bigInteger4, RSACore.getByteLength(bigInteger));
    }

    private static byte[] crtCrypt(byte[] byArray, RSAPrivateCrtKey rSAPrivateCrtKey) throws BadPaddingException {
        BigInteger bigInteger;
        BigInteger bigInteger2 = rSAPrivateCrtKey.getModulus();
        BigInteger bigInteger3 = RSACore.parseMsg(byArray, bigInteger2);
        BigInteger bigInteger4 = rSAPrivateCrtKey.getPrimeP();
        BigInteger bigInteger5 = rSAPrivateCrtKey.getPrimeQ();
        BigInteger bigInteger6 = rSAPrivateCrtKey.getPrimeExponentP();
        BigInteger bigInteger7 = rSAPrivateCrtKey.getPrimeExponentQ();
        BigInteger bigInteger8 = rSAPrivateCrtKey.getCrtCoefficient();
        BlindingParameters blindingParameters = RSACore.getBlindingParameters(rSAPrivateCrtKey);
        BigInteger bigInteger9 = (bigInteger3 = bigInteger3.multiply(blindingParameters.re).mod(bigInteger2)).modPow(bigInteger6, bigInteger4);
        BigInteger bigInteger10 = bigInteger9.subtract(bigInteger = bigInteger3.modPow(bigInteger7, bigInteger5));
        if (bigInteger10.signum() < 0) {
            bigInteger10 = bigInteger10.add(bigInteger4);
        }
        BigInteger bigInteger11 = bigInteger10.multiply(bigInteger8).mod(bigInteger4);
        BigInteger bigInteger12 = bigInteger11.multiply(bigInteger5).add(bigInteger);
        if (blindingParameters != null) {
            bigInteger12 = bigInteger12.multiply(blindingParameters.rInv).mod(bigInteger2);
        }
        return RSACore.toByteArray(bigInteger12, RSACore.getByteLength(bigInteger2));
    }

    private static BigInteger parseMsg(byte[] byArray, BigInteger bigInteger) throws BadPaddingException {
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        if (bigInteger2.compareTo(bigInteger) >= 0) {
            throw new BadPaddingException("Message is larger than modulus");
        }
        return bigInteger2;
    }

    private static byte[] toByteArray(BigInteger bigInteger, int n2) {
        byte[] byArray = bigInteger.toByteArray();
        int n3 = byArray.length;
        if (n3 == n2) {
            return byArray;
        }
        if (n3 == n2 + 1 && byArray[0] == 0) {
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, 1, byArray2, 0, n2);
            return byArray2;
        }
        assert (n3 < n2);
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, n2 - n3, n3);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BlindingParameters getBlindingParameters(RSAPrivateCrtKey rSAPrivateCrtKey) {
        BlindingParameters blindingParameters;
        BigInteger bigInteger = rSAPrivateCrtKey.getModulus();
        BigInteger bigInteger2 = rSAPrivateCrtKey.getPublicExponent();
        Map map = blindingCache;
        synchronized (map) {
            blindingParameters = (BlindingParameters)blindingCache.get(bigInteger);
        }
        if (blindingParameters != null && blindingParameters.valid(bigInteger2)) {
            return blindingParameters;
        }
        int n2 = bigInteger.bitLength();
        SecureRandom secureRandom = JCAUtil.getSecureRandom();
        BigInteger bigInteger3 = new BigInteger(n2, secureRandom).mod(bigInteger);
        BigInteger bigInteger4 = bigInteger3.modPow(bigInteger2, bigInteger);
        BigInteger bigInteger5 = bigInteger3.modInverse(bigInteger);
        blindingParameters = new BlindingParameters(bigInteger2, bigInteger4, bigInteger5);
        Map map2 = blindingCache;
        synchronized (map2) {
            blindingCache.put(bigInteger, blindingParameters);
        }
        return blindingParameters;
    }

    private static final class BlindingParameters {
        final BigInteger e;
        final BigInteger re;
        final BigInteger rInv;
        private volatile int remainingUses;

        BlindingParameters(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            this.e = bigInteger;
            this.re = bigInteger2;
            this.rInv = bigInteger3;
            this.remainingUses = 49;
        }

        boolean valid(BigInteger bigInteger) {
            int n2;
            return (n2 = this.remainingUses--) > 0 && this.e.equals(bigInteger);
        }
    }
}

