/*
 * Decompiled with CFR 0.152.
 */
package sun.management.snmp.jvmmib;

import com.sun.jmx.snmp.SnmpCounter;
import com.sun.jmx.snmp.SnmpCounter64;
import com.sun.jmx.snmp.SnmpGauge;
import com.sun.jmx.snmp.SnmpInt;
import com.sun.jmx.snmp.SnmpStatusException;
import com.sun.jmx.snmp.SnmpValue;
import com.sun.jmx.snmp.agent.SnmpMib;
import com.sun.jmx.snmp.agent.SnmpMibGroup;
import com.sun.jmx.snmp.agent.SnmpMibSubRequest;
import com.sun.jmx.snmp.agent.SnmpMibTable;
import com.sun.jmx.snmp.agent.SnmpStandardMetaServer;
import com.sun.jmx.snmp.agent.SnmpStandardObjectServer;
import java.io.Serializable;
import javax.management.MBeanServer;
import sun.management.snmp.jvmmib.EnumJvmThreadContentionMonitoring;
import sun.management.snmp.jvmmib.EnumJvmThreadCpuTimeMonitoring;
import sun.management.snmp.jvmmib.JvmThreadInstanceTableMeta;
import sun.management.snmp.jvmmib.JvmThreadingMBean;

public class JvmThreadingMeta
extends SnmpMibGroup
implements Serializable,
SnmpStandardMetaServer {
    protected JvmThreadingMBean node;
    protected SnmpStandardObjectServer objectserver = null;
    protected JvmThreadInstanceTableMeta tableJvmThreadInstanceTable = null;

    public JvmThreadingMeta(SnmpMib snmpMib, SnmpStandardObjectServer snmpStandardObjectServer) {
        this.objectserver = snmpStandardObjectServer;
        try {
            this.registerObject(6L);
            this.registerObject(5L);
            this.registerObject(4L);
            this.registerObject(3L);
            this.registerObject(2L);
            this.registerObject(1L);
            this.registerObject(10L);
            this.registerObject(7L);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage());
        }
    }

    public SnmpValue get(long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 6: {
                return new SnmpInt(this.node.getJvmThreadCpuTimeMonitoring());
            }
            case 5: {
                return new SnmpInt(this.node.getJvmThreadContentionMonitoring());
            }
            case 4: {
                return new SnmpCounter64(this.node.getJvmThreadTotalStartedCount());
            }
            case 3: {
                return new SnmpCounter(this.node.getJvmThreadPeakCount());
            }
            case 2: {
                return new SnmpGauge(this.node.getJvmThreadDaemonCount());
            }
            case 1: {
                return new SnmpGauge(this.node.getJvmThreadCount());
            }
            case 10: {
                throw new SnmpStatusException(224);
            }
            case 7: {
                return new SnmpCounter64(this.node.getJvmThreadPeakCountReset());
            }
        }
        throw new SnmpStatusException(225);
    }

    public SnmpValue set(SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 6: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setJvmThreadCpuTimeMonitoring(new EnumJvmThreadCpuTimeMonitoring(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmThreadCpuTimeMonitoring());
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.setJvmThreadContentionMonitoring(new EnumJvmThreadContentionMonitoring(((SnmpInt)snmpValue).toInteger()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                    return new SnmpInt(this.node.getJvmThreadContentionMonitoring());
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                if (snmpValue instanceof SnmpCounter64) {
                    this.node.setJvmThreadPeakCountReset(((SnmpCounter64)snmpValue).toLong());
                    return new SnmpCounter64(this.node.getJvmThreadPeakCountReset());
                }
                throw new SnmpStatusException(7);
            }
        }
        throw new SnmpStatusException(17);
    }

    public void check(SnmpValue snmpValue, long l2, Object object) throws SnmpStatusException {
        switch ((int)l2) {
            case 6: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkJvmThreadCpuTimeMonitoring(new EnumJvmThreadCpuTimeMonitoring(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 5: {
                if (snmpValue instanceof SnmpInt) {
                    try {
                        this.node.checkJvmThreadContentionMonitoring(new EnumJvmThreadContentionMonitoring(((SnmpInt)snmpValue).toInteger()));
                        break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new SnmpStatusException(10);
                    }
                }
                throw new SnmpStatusException(7);
            }
            case 4: {
                throw new SnmpStatusException(17);
            }
            case 3: {
                throw new SnmpStatusException(17);
            }
            case 2: {
                throw new SnmpStatusException(17);
            }
            case 1: {
                throw new SnmpStatusException(17);
            }
            case 10: {
                throw new SnmpStatusException(17);
            }
            case 7: {
                if (snmpValue instanceof SnmpCounter64) {
                    this.node.checkJvmThreadPeakCountReset(((SnmpCounter64)snmpValue).toLong());
                    break;
                }
                throw new SnmpStatusException(7);
            }
            default: {
                throw new SnmpStatusException(17);
            }
        }
    }

    protected void setInstance(JvmThreadingMBean jvmThreadingMBean) {
        this.node = jvmThreadingMBean;
    }

    public void get(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.get(this, snmpMibSubRequest, n2);
    }

    public void set(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.set(this, snmpMibSubRequest, n2);
    }

    public void check(SnmpMibSubRequest snmpMibSubRequest, int n2) throws SnmpStatusException {
        this.objectserver.check(this, snmpMibSubRequest, n2);
    }

    public boolean isVariable(long l2) {
        switch ((int)l2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean isReadable(long l2) {
        switch ((int)l2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return true;
            }
        }
        return false;
    }

    public boolean skipVariable(long l2, Object object, int n2) {
        switch ((int)l2) {
            case 4: 
            case 7: {
                if (n2 != 0) break;
                return true;
            }
        }
        return super.skipVariable(l2, object, n2);
    }

    public String getAttributeName(long l2) throws SnmpStatusException {
        switch ((int)l2) {
            case 6: {
                return "JvmThreadCpuTimeMonitoring";
            }
            case 5: {
                return "JvmThreadContentionMonitoring";
            }
            case 4: {
                return "JvmThreadTotalStartedCount";
            }
            case 3: {
                return "JvmThreadPeakCount";
            }
            case 2: {
                return "JvmThreadDaemonCount";
            }
            case 1: {
                return "JvmThreadCount";
            }
            case 10: {
                throw new SnmpStatusException(224);
            }
            case 7: {
                return "JvmThreadPeakCountReset";
            }
        }
        throw new SnmpStatusException(225);
    }

    public boolean isTable(long l2) {
        switch ((int)l2) {
            case 10: {
                return true;
            }
        }
        return false;
    }

    public SnmpMibTable getTable(long l2) {
        switch ((int)l2) {
            case 10: {
                return this.tableJvmThreadInstanceTable;
            }
        }
        return null;
    }

    public void registerTableNodes(SnmpMib snmpMib, MBeanServer mBeanServer) {
        this.tableJvmThreadInstanceTable = this.createJvmThreadInstanceTableMetaNode("JvmThreadInstanceTable", "JvmThreading", snmpMib, mBeanServer);
        if (this.tableJvmThreadInstanceTable != null) {
            this.tableJvmThreadInstanceTable.registerEntryNode(snmpMib, mBeanServer);
            snmpMib.registerTableMeta("JvmThreadInstanceTable", this.tableJvmThreadInstanceTable);
        }
    }

    protected JvmThreadInstanceTableMeta createJvmThreadInstanceTableMetaNode(String string, String string2, SnmpMib snmpMib, MBeanServer mBeanServer) {
        return new JvmThreadInstanceTableMeta(snmpMib, this.objectserver);
    }
}

