/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import com.sun.java.swing.SwingUtilities2;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.geom.AffineTransform;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ProgressBarUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.swing.DefaultLookup;

public class BasicProgressBarUI
extends ProgressBarUI {
    private int cachedPercent;
    private int cellLength;
    private int cellSpacing;
    private Color selectionForeground;
    private Color selectionBackground;
    private Animator animator;
    protected JProgressBar progressBar;
    protected ChangeListener changeListener;
    private Handler handler;
    private int animationIndex = 0;
    private int numFrames;
    private int repaintInterval;
    private int cycleTime;
    private static boolean ADJUSTTIMER = true;
    protected Rectangle boxRect;
    private Rectangle nextPaintRect;
    private Rectangle componentInnards;
    private Rectangle oldComponentInnards;
    private double delta = 0.0;
    private int maxPosition = 0;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicProgressBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.progressBar = (JProgressBar)jComponent;
        this.installDefaults();
        this.installListeners();
        if (this.progressBar.isIndeterminate()) {
            this.initIndeterminateValues();
        }
    }

    public void uninstallUI(JComponent jComponent) {
        if (this.progressBar.isIndeterminate()) {
            this.cleanUpIndeterminateValues();
        }
        this.uninstallDefaults();
        this.uninstallListeners();
        this.progressBar = null;
    }

    protected void installDefaults() {
        LookAndFeel.installProperty(this.progressBar, "opaque", Boolean.TRUE);
        LookAndFeel.installBorder(this.progressBar, "ProgressBar.border");
        LookAndFeel.installColorsAndFont(this.progressBar, "ProgressBar.background", "ProgressBar.foreground", "ProgressBar.font");
        this.cellLength = UIManager.getInt("ProgressBar.cellLength");
        this.cellSpacing = UIManager.getInt("ProgressBar.cellSpacing");
        this.selectionForeground = UIManager.getColor("ProgressBar.selectionForeground");
        this.selectionBackground = UIManager.getColor("ProgressBar.selectionBackground");
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.progressBar);
    }

    protected void installListeners() {
        this.changeListener = this.getHandler();
        this.progressBar.addChangeListener(this.changeListener);
        this.progressBar.addPropertyChangeListener(this.getHandler());
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void startAnimationTimer() {
        if (this.animator == null) {
            this.animator = new Animator();
        }
        this.animator.start(this.getRepaintInterval());
    }

    protected void stopAnimationTimer() {
        if (this.animator != null) {
            this.animator.stop();
        }
    }

    protected void uninstallListeners() {
        this.progressBar.removeChangeListener(this.changeListener);
        this.progressBar.removePropertyChangeListener(this.getHandler());
        this.handler = null;
    }

    protected Dimension getPreferredInnerHorizontal() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.progressBar, this, "ProgressBar.horizontalSize");
        if (dimension == null) {
            dimension = new Dimension(146, 12);
        }
        return dimension;
    }

    protected Dimension getPreferredInnerVertical() {
        Dimension dimension = (Dimension)DefaultLookup.get(this.progressBar, this, "ProgressBar.vertictalSize");
        if (dimension == null) {
            dimension = new Dimension(12, 146);
        }
        return dimension;
    }

    protected Color getSelectionForeground() {
        return this.selectionForeground;
    }

    protected Color getSelectionBackground() {
        return this.selectionBackground;
    }

    private int getCachedPercent() {
        return this.cachedPercent;
    }

    private void setCachedPercent(int n2) {
        this.cachedPercent = n2;
    }

    protected int getCellLength() {
        if (this.progressBar.isStringPainted()) {
            return 1;
        }
        return this.cellLength;
    }

    protected void setCellLength(int n2) {
        this.cellLength = n2;
    }

    protected int getCellSpacing() {
        if (this.progressBar.isStringPainted()) {
            return 0;
        }
        return this.cellSpacing;
    }

    protected void setCellSpacing(int n2) {
        this.cellSpacing = n2;
    }

    protected int getAmountFull(Insets insets, int n2, int n3) {
        int n4 = 0;
        BoundedRangeModel boundedRangeModel = this.progressBar.getModel();
        if (boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum() != 0) {
            n4 = this.progressBar.getOrientation() == 0 ? (int)Math.round((double)n2 * this.progressBar.getPercentComplete()) : (int)Math.round((double)n3 * this.progressBar.getPercentComplete());
        }
        return n4;
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.progressBar.isIndeterminate()) {
            this.paintIndeterminate(graphics, jComponent);
        } else {
            this.paintDeterminate(graphics, jComponent);
        }
    }

    protected Rectangle getBox(Rectangle rectangle) {
        int n2 = this.getAnimationIndex();
        int n3 = this.numFrames / 2;
        if (this.sizeChanged() || this.delta == 0.0 || (double)this.maxPosition == 0.0) {
            this.updateSizes();
        }
        if ((rectangle = this.getGenericBox(rectangle)) == null) {
            return null;
        }
        if (n3 <= 0) {
            return null;
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.x = n2 < n3 ? this.componentInnards.x + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        } else {
            rectangle.y = n2 < n3 ? this.componentInnards.y + (int)Math.round(this.delta * (double)n2) : this.maxPosition - (int)Math.round(this.delta * (double)(n2 - n3));
        }
        return rectangle;
    }

    private void updateSizes() {
        int n2 = 0;
        if (this.progressBar.getOrientation() == 0) {
            n2 = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            this.maxPosition = this.componentInnards.x + this.componentInnards.width - n2;
        } else {
            n2 = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            this.maxPosition = this.componentInnards.y + this.componentInnards.height - n2;
        }
        this.delta = 2.0 * (double)this.maxPosition / (double)this.numFrames;
    }

    private Rectangle getGenericBox(Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        if (this.progressBar.getOrientation() == 0) {
            rectangle.width = this.getBoxLength(this.componentInnards.width, this.componentInnards.height);
            if (rectangle.width < 0) {
                rectangle = null;
            } else {
                rectangle.height = this.componentInnards.height;
                rectangle.y = this.componentInnards.y;
            }
        } else {
            rectangle.height = this.getBoxLength(this.componentInnards.height, this.componentInnards.width);
            if (rectangle.height < 0) {
                rectangle = null;
            } else {
                rectangle.width = this.componentInnards.width;
                rectangle.x = this.componentInnards.x;
            }
        }
        return rectangle;
    }

    protected int getBoxLength(int n2, int n3) {
        return (int)Math.round((double)n2 / 6.0);
    }

    protected void paintIndeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.boxRect = this.getBox(this.boxRect);
        if (this.boxRect != null) {
            graphics2D.setColor(this.progressBar.getForeground());
            graphics2D.fillRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height);
        }
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.x, this.boxRect.width, insets);
            } else {
                this.paintString(graphics2D, insets.left, insets.top, n2, n3, this.boxRect.y, this.boxRect.height, insets);
            }
        }
    }

    protected void paintDeterminate(Graphics graphics, JComponent jComponent) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Insets insets = this.progressBar.getInsets();
        int n2 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n3 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        int n4 = this.getCellLength();
        int n5 = this.getCellSpacing();
        int n6 = this.getAmountFull(insets, n2, n3);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setColor(this.progressBar.getForeground());
        if (this.progressBar.getOrientation() == 0) {
            if (n5 == 0 && n6 > 0) {
                graphics2D.setStroke(new BasicStroke(n3, 0, 2));
            } else {
                graphics2D.setStroke(new BasicStroke(n3, 0, 2, 0.0f, new float[]{n4, n5}, 0.0f));
            }
            if (BasicGraphicsUtils.isLeftToRight(jComponent)) {
                graphics2D.drawLine(insets.left, n3 / 2 + insets.top, n6 + insets.left, n3 / 2 + insets.top);
            } else {
                graphics2D.drawLine(n2 + insets.left, n3 / 2 + insets.top, n2 + insets.left - n6, n3 / 2 + insets.top);
            }
        } else {
            if (n5 == 0 && n6 > 0) {
                graphics2D.setStroke(new BasicStroke(n2, 0, 2));
            } else {
                graphics2D.setStroke(new BasicStroke(n2, 0, 2, 0.0f, new float[]{n4, n5}, 0.0f));
            }
            graphics2D.drawLine(n2 / 2 + insets.left, insets.top + n3, n2 / 2 + insets.left, insets.top + n3 - n6);
        }
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, insets.left, insets.top, n2, n3, n6, insets);
        }
    }

    protected void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        if (this.progressBar.getOrientation() == 0) {
            if (BasicGraphicsUtils.isLeftToRight(this.progressBar)) {
                if (this.progressBar.isIndeterminate()) {
                    this.boxRect = this.getBox(this.boxRect);
                    this.paintString(graphics, n2, n3, n4, n5, this.boxRect.x, this.boxRect.width, insets);
                } else {
                    this.paintString(graphics, n2, n3, n4, n5, n2, n6, insets);
                }
            } else {
                this.paintString(graphics, n2, n3, n4, n5, n2 + n4 - n6, n6, insets);
            }
        } else if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            this.paintString(graphics, n2, n3, n4, n5, this.boxRect.y, this.boxRect.height, insets);
        } else {
            this.paintString(graphics, n2, n3, n4, n5, n3 + n5 - n6, n6, insets);
        }
    }

    private void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, Insets insets) {
        if (!(graphics instanceof Graphics2D)) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        String string = this.progressBar.getString();
        graphics2D.setFont(this.progressBar.getFont());
        Point point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            graphics2D.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n6, n3, n7, n5);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)graphics2D, string, point.x, point.y);
        } else {
            graphics2D.setColor(this.getSelectionBackground());
            AffineTransform affineTransform = AffineTransform.getRotateInstance(1.5707963267948966);
            graphics2D.setFont(this.progressBar.getFont().deriveFont(affineTransform));
            point = this.getStringPlacement(graphics2D, string, n2, n3, n4, n5);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)graphics2D, string, point.x, point.y);
            graphics2D.setColor(this.getSelectionForeground());
            graphics2D.clipRect(n2, n6, n4, n7);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)graphics2D, string, point.x, point.y);
        }
        graphics2D.setClip(rectangle);
    }

    protected Point getStringPlacement(Graphics graphics, String string, int n2, int n3, int n4, int n5) {
        FontMetrics fontMetrics = SwingUtilities2.getFontMetrics(this.progressBar, graphics, this.progressBar.getFont());
        int n6 = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string);
        if (this.progressBar.getOrientation() == 0) {
            return new Point(n2 + Math.round(n4 / 2 - n6 / 2), n3 + (n5 + fontMetrics.getAscent() - fontMetrics.getLeading() - fontMetrics.getDescent()) / 2);
        }
        return new Point(n2 + (n4 - fontMetrics.getAscent() + fontMetrics.getLeading() + fontMetrics.getDescent()) / 2, n3 + Math.round(n5 / 2 - n6 / 2));
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension;
        Insets insets = this.progressBar.getInsets();
        FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
        if (this.progressBar.getOrientation() == 0) {
            dimension = new Dimension(this.getPreferredInnerHorizontal());
            if (this.progressBar.isStringPainted()) {
                int n2;
                String string = this.progressBar.getString();
                int n3 = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string);
                if (n3 > dimension.width) {
                    dimension.width = n3;
                }
                if ((n2 = fontMetrics.getHeight() + fontMetrics.getDescent()) > dimension.height) {
                    dimension.height = n2;
                }
            }
        } else {
            dimension = new Dimension(this.getPreferredInnerVertical());
            if (this.progressBar.isStringPainted()) {
                int n4;
                String string = this.progressBar.getString();
                int n5 = fontMetrics.getHeight() + fontMetrics.getDescent();
                if (n5 > dimension.width) {
                    dimension.width = n5;
                }
                if ((n4 = SwingUtilities2.stringWidth(this.progressBar, fontMetrics, string)) > dimension.height) {
                    dimension.height = n4;
                }
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = 10;
        } else {
            dimension.height = 10;
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(this.progressBar);
        if (this.progressBar.getOrientation() == 0) {
            dimension.width = Short.MAX_VALUE;
        } else {
            dimension.height = Short.MAX_VALUE;
        }
        return dimension;
    }

    protected int getAnimationIndex() {
        return this.animationIndex;
    }

    protected void setAnimationIndex(int n2) {
        if (this.animationIndex != n2) {
            if (this.sizeChanged()) {
                this.animationIndex = n2;
                this.maxPosition = 0;
                this.delta = 0.0;
                this.progressBar.repaint();
                return;
            }
            this.nextPaintRect = this.getBox(this.nextPaintRect);
            this.animationIndex = n2;
            if (this.nextPaintRect != null) {
                this.boxRect = this.getBox(this.boxRect);
                if (this.boxRect != null) {
                    this.nextPaintRect.add(this.boxRect);
                }
            }
        } else {
            return;
        }
        if (this.nextPaintRect != null) {
            this.progressBar.repaint(this.nextPaintRect);
        } else {
            this.progressBar.repaint();
        }
    }

    private boolean sizeChanged() {
        if (this.oldComponentInnards == null || this.componentInnards == null) {
            return true;
        }
        this.oldComponentInnards.setRect(this.componentInnards);
        this.componentInnards = SwingUtilities.calculateInnerArea(this.progressBar, this.componentInnards);
        return !this.oldComponentInnards.equals(this.componentInnards);
    }

    protected void incrementAnimationIndex() {
        int n2 = this.getAnimationIndex() + 1;
        if (n2 < this.numFrames) {
            this.setAnimationIndex(n2);
        } else {
            this.setAnimationIndex(0);
        }
    }

    private int getRepaintInterval() {
        return this.repaintInterval;
    }

    private int initRepaintInterval() {
        this.repaintInterval = DefaultLookup.getInt(this.progressBar, this, "ProgressBar.repaintInterval", 50);
        return this.repaintInterval;
    }

    private int getCycleTime() {
        return this.cycleTime;
    }

    private int initCycleTime() {
        this.cycleTime = DefaultLookup.getInt(this.progressBar, this, "ProgressBar.cycleTime", 3000);
        return this.cycleTime;
    }

    private void initIndeterminateDefaults() {
        this.initRepaintInterval();
        this.initCycleTime();
        if (this.repaintInterval <= 0) {
            this.repaintInterval = 100;
        }
        if (this.repaintInterval > this.cycleTime) {
            this.cycleTime = this.repaintInterval * 20;
        } else {
            int n2 = (int)Math.ceil((double)this.cycleTime / ((double)this.repaintInterval * 2.0));
            this.cycleTime = this.repaintInterval * n2 * 2;
        }
    }

    private void initIndeterminateValues() {
        this.initIndeterminateDefaults();
        this.numFrames = this.cycleTime / this.repaintInterval;
        this.initAnimationIndex();
        this.boxRect = new Rectangle();
        this.nextPaintRect = new Rectangle();
        this.componentInnards = new Rectangle();
        this.oldComponentInnards = new Rectangle();
        this.progressBar.addHierarchyListener(this.getHandler());
        if (this.progressBar.isDisplayable()) {
            this.startAnimationTimer();
        }
    }

    private void cleanUpIndeterminateValues() {
        if (this.progressBar.isDisplayable()) {
            this.stopAnimationTimer();
        }
        this.repaintInterval = 0;
        this.cycleTime = 0;
        this.animationIndex = 0;
        this.numFrames = 0;
        this.maxPosition = 0;
        this.delta = 0.0;
        this.nextPaintRect = null;
        this.boxRect = null;
        this.oldComponentInnards = null;
        this.componentInnards = null;
        this.progressBar.removeHierarchyListener(this.getHandler());
    }

    private void initAnimationIndex() {
        if (this.progressBar.getOrientation() == 0 && BasicGraphicsUtils.isLeftToRight(this.progressBar)) {
            this.setAnimationIndex(0);
        } else {
            this.setAnimationIndex(this.numFrames / 2);
        }
    }

    private class Animator
    implements ActionListener {
        private Timer timer;
        private long previousDelay;
        private int interval;
        private long lastCall;
        private int MINIMUM_DELAY = 5;

        private Animator() {
        }

        private void start(int n2) {
            this.previousDelay = n2;
            this.lastCall = 0L;
            if (this.timer == null) {
                this.timer = new Timer(n2, this);
            } else {
                this.timer.setDelay(n2);
            }
            if (ADJUSTTIMER) {
                this.timer.setRepeats(false);
                this.timer.setCoalesce(false);
            }
            this.timer.start();
        }

        private void stop() {
            this.timer.stop();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ADJUSTTIMER) {
                long l2 = System.currentTimeMillis();
                if (this.lastCall > 0L) {
                    int n2 = (int)(this.previousDelay - l2 + this.lastCall + (long)BasicProgressBarUI.this.getRepaintInterval());
                    if (n2 < this.MINIMUM_DELAY) {
                        n2 = this.MINIMUM_DELAY;
                    }
                    this.timer.setInitialDelay(n2);
                    this.previousDelay = n2;
                }
                this.timer.start();
                this.lastCall = l2;
            }
            BasicProgressBarUI.this.incrementAnimationIndex();
        }
    }

    public class ChangeHandler
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            BasicProgressBarUI.this.getHandler().stateChanged(changeEvent);
        }
    }

    private class Handler
    implements ChangeListener,
    PropertyChangeListener,
    HierarchyListener {
        private Handler() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            int n2;
            BoundedRangeModel boundedRangeModel = BasicProgressBarUI.this.progressBar.getModel();
            int n3 = boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum();
            int n4 = n3 > 0 ? (int)(100L * (long)boundedRangeModel.getValue() / (long)n3) : 0;
            if (n4 != (n2 = BasicProgressBarUI.this.getCachedPercent())) {
                BasicProgressBarUI.this.setCachedPercent(n4);
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("indeterminate" == string) {
                if (BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                    BasicProgressBarUI.this.initIndeterminateValues();
                } else {
                    BasicProgressBarUI.this.cleanUpIndeterminateValues();
                }
                BasicProgressBarUI.this.progressBar.repaint();
            }
        }

        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            if ((hierarchyEvent.getChangeFlags() & 2L) != 0L && BasicProgressBarUI.this.progressBar.isIndeterminate()) {
                if (BasicProgressBarUI.this.progressBar.isDisplayable()) {
                    BasicProgressBarUI.this.startAnimationTimer();
                } else {
                    BasicProgressBarUI.this.stopAnimationTimer();
                }
            }
        }
    }
}

