/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.ldap;

import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;
import javax.naming.ldap.BasicControl;
import javax.naming.ldap.SortKey;

public final class SortControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.473";
    private static final long serialVersionUID = -1965961680233330744L;

    public SortControl(String string, boolean bl2) throws IOException {
        super(OID, bl2, null);
        this.value = this.setEncodedValue(new SortKey[]{new SortKey(string)});
    }

    public SortControl(String[] stringArray, boolean bl2) throws IOException {
        super(OID, bl2, null);
        SortKey[] sortKeyArray = new SortKey[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            sortKeyArray[i2] = new SortKey(stringArray[i2]);
        }
        this.value = this.setEncodedValue(sortKeyArray);
    }

    public SortControl(SortKey[] sortKeyArray, boolean bl2) throws IOException {
        super(OID, bl2, null);
        this.value = this.setEncodedValue(sortKeyArray);
    }

    private byte[] setEncodedValue(SortKey[] sortKeyArray) throws IOException {
        BerEncoder berEncoder = new BerEncoder(30 * sortKeyArray.length + 10);
        berEncoder.beginSeq(48);
        for (int i2 = 0; i2 < sortKeyArray.length; ++i2) {
            berEncoder.beginSeq(48);
            berEncoder.encodeString(sortKeyArray[i2].getAttributeID(), true);
            String string = sortKeyArray[i2].getMatchingRuleID();
            if (string != null) {
                berEncoder.encodeString(string, 128, true);
            }
            if (!sortKeyArray[i2].isAscending()) {
                berEncoder.encodeBoolean(true, 129);
            }
            berEncoder.endSeq();
        }
        berEncoder.endSeq();
        return berEncoder.getTrimmedBuf();
    }
}

