/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.MetaData;
import java.beans.PersistenceDelegate;
import java.beans.Statement;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encoder {
    private Map bindings = new IdentityHashMap();
    private ExceptionListener exceptionListener;
    boolean executeStatements = true;
    private Map attributes;

    protected void writeObject(Object object) {
        if (object == this) {
            return;
        }
        PersistenceDelegate persistenceDelegate = this.getPersistenceDelegate(object == null ? null : object.getClass());
        persistenceDelegate.writeObject(object, this);
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public ExceptionListener getExceptionListener() {
        return this.exceptionListener != null ? this.exceptionListener : Statement.defaultExceptionListener;
    }

    Object getValue(Expression expression) {
        try {
            return expression == null ? null : expression.getValue();
        }
        catch (Exception exception) {
            this.getExceptionListener().exceptionThrown(exception);
            throw new RuntimeException("failed to evaluate: " + expression.toString());
        }
    }

    public PersistenceDelegate getPersistenceDelegate(Class<?> clazz) {
        return MetaData.getPersistenceDelegate(clazz);
    }

    public void setPersistenceDelegate(Class<?> clazz, PersistenceDelegate persistenceDelegate) {
        MetaData.setPersistenceDelegate(clazz, persistenceDelegate);
    }

    public Object remove(Object object) {
        Expression expression = (Expression)this.bindings.remove(object);
        return this.getValue(expression);
    }

    public Object get(Object object) {
        if (object == null || object == this || object.getClass() == String.class) {
            return object;
        }
        Expression expression = (Expression)this.bindings.get(object);
        return this.getValue(expression);
    }

    private Object writeObject1(Object object) {
        Object object2 = this.get(object);
        if (object2 == null) {
            this.writeObject(object);
            object2 = this.get(object);
        }
        return object2;
    }

    private Statement cloneStatement(Statement statement) {
        Object object = statement.getTarget();
        Object object2 = this.writeObject1(object);
        Object[] objectArray = statement.getArguments();
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            objectArray2[i2] = this.writeObject1(objectArray[i2]);
        }
        if (statement.getClass() == Statement.class) {
            return new Statement(object2, statement.getMethodName(), objectArray2);
        }
        return new Expression(object2, statement.getMethodName(), objectArray2);
    }

    public void writeStatement(Statement statement) {
        Statement statement2 = this.cloneStatement(statement);
        if (statement.getTarget() != this && this.executeStatements) {
            try {
                statement2.execute();
            }
            catch (Exception exception) {
                this.getExceptionListener().exceptionThrown(new Exception("Encoder: discarding statement " + statement2, exception));
            }
        }
    }

    public void writeExpression(Expression expression) {
        Object object = this.getValue(expression);
        if (this.get(object) != null) {
            return;
        }
        this.bindings.put(object, (Expression)this.cloneStatement(expression));
        this.writeObject(object);
    }

    void clear() {
        this.bindings.clear();
    }

    void setAttribute(Object object, Object object2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(object, object2);
    }

    Object getAttribute(Object object) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(object);
    }
}

