/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Conditional;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.security.AccessController;
import javax.swing.JInternalFrame;
import sun.awt.AWTAutoShutdown;
import sun.awt.DebugHelper;
import sun.awt.ModalExclude;
import sun.awt.SunToolkit;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.security.action.GetPropertyAction;

class EventDispatchThread
extends Thread {
    private static final DebugHelper dbg = DebugHelper.create(EventDispatchThread.class);
    private EventQueue theQueue;
    private boolean doDispatch = true;
    private static final int ANY_EVENT = -1;
    private static final String handlerPropName = "sun.awt.exception.handler";
    private static String handlerClassName = null;
    private static String NO_HANDLER = new String();

    EventDispatchThread(ThreadGroup threadGroup, String string, EventQueue eventQueue) {
        super(threadGroup, string);
        this.theQueue = eventQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopDispatchingImpl(boolean bl2) {
        StopDispatchEvent stopDispatchEvent = new StopDispatchEvent();
        if (Thread.currentThread() != this) {
            this.theQueue.postEventPrivate(stopDispatchEvent);
            if (bl2) {
                try {
                    this.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            stopDispatchEvent.dispatch();
        }
        EventQueue eventQueue = this.theQueue;
        synchronized (eventQueue) {
            if (this.theQueue.getDispatchThread() == this) {
                this.theQueue.detachDispatchThread();
            }
        }
    }

    public void stopDispatching() {
        this.stopDispatchingImpl(true);
    }

    public void stopDispatchingLater() {
        this.stopDispatchingImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pumpEvents(new Conditional(){

                public boolean evaluate() {
                    return true;
                }
            });
        }
        finally {
            EventQueue eventQueue = this.theQueue;
            synchronized (eventQueue) {
                if (this.theQueue.getDispatchThread() == this) {
                    this.theQueue.detachDispatchThread();
                }
                if (this.theQueue.peekEvent() != null || !SunToolkit.isPostEventQueueEmpty()) {
                    this.theQueue.initDispatchThread();
                }
                AWTAutoShutdown.getInstance().notifyThreadFree(this);
            }
        }
    }

    void pumpEvents(Conditional conditional) {
        this.pumpEvents(-1, conditional);
    }

    void pumpEventsForHierarchy(Conditional conditional, Component component) {
        this.pumpEventsForHierarchy(-1, conditional, component);
    }

    void pumpEvents(int n2, Conditional conditional) {
        this.pumpEventsForHierarchy(n2, conditional, null);
    }

    void pumpEventsForHierarchy(int n2, Conditional conditional, Component component) {
        while (this.doDispatch && conditional.evaluate()) {
            if (!this.isInterrupted() && this.pumpOneEventForHierarchy(n2, component)) continue;
            this.doDispatch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean checkMouseEventForModalJInternalFrame(MouseEvent mouseEvent, Component component) {
        if (component instanceof JInternalFrame) {
            Container container;
            Object object = component.getTreeLock();
            synchronized (object) {
                container = ((Container)component).getHeavyweightContainer();
            }
            if (mouseEvent.getSource() == container) {
                return true;
            }
        }
        return false;
    }

    boolean pumpOneEventForHierarchy(int n2, Component component) {
        try {
            AWTEvent aWTEvent;
            boolean bl2;
            do {
                Object object;
                int n3;
                aWTEvent = n2 == -1 ? this.theQueue.getNextEvent() : this.theQueue.getNextEvent(n2);
                bl2 = true;
                if (component != null && ((n3 = aWTEvent.getID()) >= 500 && n3 <= 507 && !this.checkMouseEventForModalJInternalFrame((MouseEvent)aWTEvent, component) || n3 >= 1001 && n3 <= 1001 || n3 == 201) && !((object = aWTEvent.getSource()) instanceof ModalExclude) && object instanceof Component) {
                    Component component2;
                    if (component instanceof Container) {
                        for (component2 = (Component)object; component2 != component && component2 != null; component2 = component2.getParent()) {
                        }
                    }
                    if (component2 != component) {
                        bl2 = false;
                    }
                }
                boolean bl3 = bl2 = bl2 && SunDragSourceContextPeer.checkEvent(aWTEvent);
                if (bl2) continue;
                aWTEvent.consume();
            } while (!bl2);
            this.theQueue.dispatchEvent(aWTEvent);
            return true;
        }
        catch (ThreadDeath threadDeath) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (RuntimeException runtimeException) {
            this.processException(runtimeException, component != null);
        }
        catch (Error error) {
            this.processException(error, component != null);
        }
        return true;
    }

    private void processException(Throwable throwable, boolean bl2) {
        if (!this.handleException(throwable)) {
            if (bl2) {
                System.err.println("Exception occurred during event dispatching:");
                throwable.printStackTrace();
            } else {
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
            }
        }
    }

    private boolean handleException(Throwable throwable) {
        try {
            Object obj;
            Method method;
            if (handlerClassName == NO_HANDLER) {
                return false;
            }
            if (handlerClassName == null && (handlerClassName = (String)AccessController.doPrivileged(new GetPropertyAction(handlerPropName))) == null) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = Class.forName(handlerClassName, true, classLoader);
                method = clazz.getMethod("handle", Throwable.class);
                obj = clazz.newInstance();
            }
            catch (Throwable throwable2) {
                handlerClassName = NO_HANDLER;
                return false;
            }
            method.invoke(obj, throwable);
        }
        catch (Throwable throwable3) {
            return false;
        }
        return true;
    }

    boolean isDispatching(EventQueue eventQueue) {
        return this.theQueue.equals(eventQueue);
    }

    EventQueue getEventQueue() {
        return this.theQueue;
    }

    class StopDispatchEvent
    extends AWTEvent
    implements ActiveEvent {
        public StopDispatchEvent() {
            super(EventDispatchThread.this, 0);
        }

        public void dispatch() {
            EventDispatchThread.this.doDispatch = false;
        }
    }
}

