/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rowset;

import com.sun.rowset.WebRowSetImpl;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;

public class FilteredRowSetImpl
extends WebRowSetImpl
implements Serializable,
Cloneable,
FilteredRowSet {
    private Predicate p;
    private boolean onInsertRow = false;

    public FilteredRowSetImpl() throws SQLException {
    }

    public FilteredRowSetImpl(Hashtable hashtable) throws SQLException {
        super(hashtable);
    }

    public void setFilter(Predicate predicate) throws SQLException {
        this.p = predicate;
    }

    public Predicate getFilter() {
        return this.p;
    }

    protected boolean internalNext() throws SQLException {
        boolean bl2 = false;
        for (int i2 = this.getRow(); i2 <= this.size(); ++i2) {
            bl2 = super.internalNext();
            if (this.p == null) {
                return bl2;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl2;
    }

    protected boolean internalPrevious() throws SQLException {
        boolean bl2 = false;
        for (int i2 = this.getRow(); i2 > 0; --i2) {
            bl2 = super.internalPrevious();
            if (this.p == null) {
                return bl2;
            }
            if (this.p.evaluate(this)) break;
        }
        return bl2;
    }

    protected boolean internalFirst() throws SQLException {
        boolean bl2 = super.internalFirst();
        if (this.p == null) {
            return bl2;
        }
        while (bl2 && !this.p.evaluate(this)) {
            bl2 = super.internalNext();
        }
        return bl2;
    }

    protected boolean internalLast() throws SQLException {
        boolean bl2 = super.internalLast();
        if (this.p == null) {
            return bl2;
        }
        while (bl2 && !this.p.evaluate(this)) {
            bl2 = super.internalPrevious();
        }
        return bl2;
    }

    public boolean relative(int n2) throws SQLException {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.getType() == 1003) {
            throw new SQLException("Relative: Invalid cursor operation");
        }
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl3 = this.internalNext();
            }
            bl2 = bl3;
        } else {
            for (int i3 = n2; i3 < 0; ++i3) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl4 = this.internalPrevious();
            }
            bl2 = bl4;
        }
        return bl2;
    }

    public boolean absolute(int n2) throws SQLException {
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 == 0 || this.getType() == 1003) {
            throw new SQLException("Absolute:Invalid cursor operation");
        }
        if (n2 > 0) {
            this.internalFirst();
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                if (this.isAfterLast()) {
                    return false;
                }
                bl3 = this.internalNext();
            }
            bl2 = bl3;
        } else {
            this.internalLast();
            int n3 = n2;
            while (n3 + 1 < 0) {
                if (this.isBeforeFirst()) {
                    return false;
                }
                bl4 = this.internalPrevious();
                ++n3;
            }
            bl2 = bl4;
        }
        return bl2;
    }

    public void moveToInsertRow() throws SQLException {
        this.onInsertRow = true;
        super.moveToInsertRow();
    }

    public void updateInt(int n2, int n3) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Integer(n3), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateInt(n2, n3);
    }

    public void updateInt(String string, int n2) throws SQLException {
        this.updateInt(this.findColumn(string), n2);
    }

    public void updateBoolean(int n2, boolean bl2) throws SQLException {
        boolean bl3;
        if (this.onInsertRow && !(bl3 = this.p.evaluate((Object)new Boolean(bl2), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateBoolean(n2, bl2);
    }

    public void updateBoolean(String string, boolean bl2) throws SQLException {
        this.updateBoolean(this.findColumn(string), bl2);
    }

    public void updateByte(int n2, byte by) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Byte(by), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateByte(n2, by);
    }

    public void updateByte(String string, byte by) throws SQLException {
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(int n2, short s2) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Short(s2), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateShort(n2, s2);
    }

    public void updateShort(String string, short s2) throws SQLException {
        this.updateShort(this.findColumn(string), s2);
    }

    public void updateLong(int n2, long l2) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Long(l2), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateLong(n2, l2);
    }

    public void updateLong(String string, long l2) throws SQLException {
        this.updateLong(this.findColumn(string), l2);
    }

    public void updateFloat(int n2, float f2) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Float(f2), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateFloat(n2, f2);
    }

    public void updateFloat(String string, float f2) throws SQLException {
        this.updateFloat(this.findColumn(string), f2);
    }

    public void updateDouble(int n2, double d2) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)new Double(d2), n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateDouble(n2, d2);
    }

    public void updateDouble(String string, double d2) throws SQLException {
        this.updateDouble(this.findColumn(string), d2);
    }

    public void updateBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)bigDecimal, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateBigDecimal(n2, bigDecimal);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(int n2, String string) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)string, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateString(n2, string);
    }

    public void updateString(String string, String string2) throws SQLException {
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(int n2, byte[] byArray) throws SQLException {
        boolean bl2;
        String string = new String();
        Byte[] byteArray = new Byte[byArray.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byteArray[i2] = new Byte(byArray[i2]);
            string = string.concat(byteArray[i2].toString());
        }
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)string, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateBytes(n2, byArray);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLException {
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(int n2, Date date) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)date, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateDate(n2, date);
    }

    public void updateDate(String string, Date date) throws SQLException {
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(int n2, Time time) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)time, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateTime(n2, time);
    }

    public void updateTime(String string, Time time) throws SQLException {
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(int n2, Timestamp timestamp) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)timestamp, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateTimestamp(n2, timestamp);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)inputStream, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateAsciiStream(n2, inputStream, n3);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateAsciiStream(this.findColumn(string), inputStream, n2);
    }

    public void updateCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)reader, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateCharacterStream(n2, reader, n3);
    }

    public void updateCharacterStream(String string, Reader reader, int n2) throws SQLException {
        this.updateCharacterStream(this.findColumn(string), reader, n2);
    }

    public void updateBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate((Object)inputStream, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateBinaryStream(n2, inputStream, n3);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        this.updateBinaryStream(this.findColumn(string), inputStream, n2);
    }

    public void updateObject(int n2, Object object) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate(object, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateObject(n2, object);
    }

    public void updateObject(String string, Object object) throws SQLException {
        this.updateObject(this.findColumn(string), object);
    }

    public void updateObject(int n2, Object object, int n3) throws SQLException {
        boolean bl2;
        if (this.onInsertRow && !(bl2 = this.p.evaluate(object, n2))) {
            throw new SQLException("This value is not allowed through the filter");
        }
        super.updateObject(n2, object, n3);
    }

    public void updateObject(String string, Object object, int n2) throws SQLException {
        this.updateObject(this.findColumn(string), object, n2);
    }

    public void insertRow() throws SQLException {
        this.onInsertRow = false;
        super.insertRow();
    }
}

