/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger;

import java.util.ConcurrentModificationException;

public class LongHashMap {
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    transient int modCount = 0;

    public LongHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + initialCapacity);
        }
        if (loadFactor <= 0.0f || Float.isNaN(loadFactor)) {
            throw new IllegalArgumentException("Illegal Load factor: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.loadFactor = loadFactor;
        this.table = new Entry[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public LongHashMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public LongHashMap() {
        this(11, 0.75f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object get(long key) {
        Entry e = this.getEntry(key);
        return e == null ? null : e.value;
    }

    public boolean containsKey(long key) {
        return this.getEntry(key) != null;
    }

    Entry getEntry(long key) {
        Entry[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    public boolean containsValue(Object value) {
        Entry[] tab = this.table;
        if (value == null) {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.value == null) {
                        return true;
                    }
                    e = e.next;
                }
            }
        } else {
            int i = tab.length;
            while (i-- > 0) {
                Entry e = tab[i];
                while (e != null) {
                    if (value.equals(e.value)) {
                        return true;
                    }
                    e = e.next;
                }
            }
        }
        return false;
    }

    public Object put(long key, Object value) {
        Entry[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                Object oldValue = e.value;
                e.value = value;
                return oldValue;
            }
            e = e.next;
        }
        ++this.modCount;
        if (this.size >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        ++this.size;
        tab[index] = this.newEntry(hash, key, value, tab[index]);
        return null;
    }

    public Object remove(long key) {
        Entry e = this.removeEntryForKey(key);
        return e == null ? null : e.value;
    }

    Entry removeEntryForKey(long key) {
        Entry[] tab = this.table;
        int hash = (int)key;
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.hash == hash && e.key == key) {
                ++this.modCount;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                --this.size;
                return e;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    void removeEntry(Entry doomed) {
        Entry[] tab = this.table;
        int index = (doomed.hash & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e == doomed) {
                ++this.modCount;
                if (prev == null) {
                    tab[index] = e.next;
                } else {
                    prev.next = e.next;
                }
                --this.size;
                return;
            }
            prev = e;
            e = e.next;
        }
        throw new ConcurrentModificationException();
    }

    public void clear() {
        Entry[] tab = this.table;
        ++this.modCount;
        int index = tab.length;
        while (--index >= 0) {
            tab[index] = null;
        }
        this.size = 0;
    }

    void rehash() {
        Entry[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newTable = new Entry[newCapacity];
        ++this.modCount;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newTable;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldTable[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.hash & Integer.MAX_VALUE) % newCapacity;
                e.next = newTable[index];
                newTable[index] = e;
            }
        }
    }

    static boolean eq(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    Entry newEntry(int hash, long key, Object value, Entry next) {
        return new Entry(hash, key, value, next);
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    static class Entry {
        private int hash;
        private long key;
        private Object value;
        private Entry next;

        Entry(int hash, long key, Object value, Entry next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        long getKey() {
            return this.key;
        }

        Object getValue() {
            return this.value;
        }

        Object setValue(Object value) {
            Object oldValue = this.value;
            this.value = value;
            return oldValue;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key == e.getKey() && LongHashMap.eq(this.value, e.getValue());
        }

        public int hashCode() {
            return this.hash ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }
}

