/*
 * Copyright (c) 2003 Benedikt Meurer (benedikt.meurer@unix-ag.uni-siegen.de)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	__XFPRINT_PRINTDLG_H__
#define	__XFPRINT_PRINTDLG_H__

#include <gtk/gtk.h>
#include <xfprinter.h>
#include <xfprintsettings.h>

#ifdef	__cplusplus
extern "C" {
#endif	/* !__cplusplus */

#define PRINT_DLG(obj)							\
	G_TYPE_CHECK_INSTANCE_CAST(obj, printdlg_get_type(), PrintDlg)
#define PRINT_DLG_CLASS(klass)						\
	G_TYPE_CHECK_CLASS_CAST(klass, printdlg_get_type(), PrintDlg)
#define PRINT_IS_DLG(obj)						\
	G_TYPE_CHECK_INSTANCE_TYPE(obj, printdlg_get_type())

typedef struct _PrintDlg	PrintDlg;
typedef struct _PrintDlgClass	PrintDlgClass;

struct _PrintDlg
{
	GtkDialog	dialog;

	GtkWidget	*save;

	GtkWidget	*toname;	/* (*) Name: */
	GtkWidget	*tofile;	/* ( ) Print to file: */
	GtkWidget	*printer;	/* printer combo */
	GtkWidget	*file;		/* file entry */
	GtkWidget	*select;	/* file selection button */
	GtkWidget	*image;

	GtkWidget	*notebook;

	GtkWidget	*sheets;
	GtkWidget	*vpages;
	GtkWidget	*pprint;
	GtkWidget	*input;
	GtkWidget	*head;

	GtkWidget	*copies;

	/* currently selected printer (or NULL) */
	XfPrinter	*pr;
};

struct _PrintDlgClass
{
	GtkDialogClass	parent_class;
};

extern GtkType		printdlg_get_type(void);
extern GtkWidget	*printdlg_new(const XfPrintSettings *);
extern void		printdlg_get_settings(PrintDlg *, XfPrintSettings *);
extern XfPrinter	*printdlg_get_printer(PrintDlg *);
extern const gchar	*printdlg_get_file(PrintDlg *);

#ifdef	__cplusplus
}
#endif	/* !__cplusplus */

#endif	/* !__XFPRINT_PRINTDLG_H__ */
