.TH sane-u12 5 "23 Apr 2004" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane-u12
.SH NAME
sane-u12 \- SANE backend for Plustek USB flatbed scanners,
based on older parport designs
.SH DESCRIPTION
The
.B sane-u12
library implements a SANE (Scanner Access Now Easy) backend that
provides access to USB flatbed scanners based on Plusteks' ASIC
98003 (parallel-port ASIC) and a GeneSys Logics' USB-parport
bridge chip.

.SH "SUPPORTED DEVICES"
The backend is able to support some early Plustek USB scanner based
their old parport design around the ASIC 98003 and other rebadged
Plustek devices. The following tables will give you a short overview.

If your Plustek scanner has another Product ID, then the device is
.B NOT
supported by this backend.
.br

Vendor Plustek - ID: 0x07B3
.br
----------------------------------------------------------
.br
Model:                   Vendor-ID:       Product-ID:
.br
----------------------------------------------------------
.br
OpticPro U12             0x07B3           0x0001
.br
OpticPro U1212           0x07B3           0x0001
.br
OpticPro UT12            0x07B3           0x0001
.PP

Vendor KYE/Genius
.br
--------------------------------------------------------
.br
USB Model:               Vendor-ID:       Product-ID:
.br
--------------------------------------------------------
.br
ColorPage Vivid III USB  0x07B3           0x0001
.br
ColorPage HR6 V1         0x0458           0x2004
.PP

.SH "CONFIGURATION"
To use your scanner with this backend, you need at least two
entries in the configuration file
.br
.I @CONFIGDIR@/u12.conf
.TP
.I [usb] vendor-id product-id
.TP
.I device /dev/usbscanner
.PP
.I [usb]
tells the backend, that the following devicename (here
.I /dev/usbscanner
) has to be interpreted as USB scanner device. If vendor- and
product-id has not been specified, the backend tries to
detect this by its own. If device ist set to
.I auto
 then the next matching device is used.
.PP
.B
The Options:
.PP
option warmup t
.RS
.I t
specifies the warmup period in seconds
.RE
.PP
option lampOff t
.RS
.I t
is the time in seconds for switching off the lamps in
standby mode
.RE
.PP
option lOffonEnd b
.RS
.I b
specifies the behaviour when closing the backend, 1 --> switch
lamps off, 0 --> do not change lamp status
.RE

.PP
See the u12.conf file for examples.
.PP
.B Note:
.br
You have to make sure, that the USB subsystem is loaded
correctly and you have access to the device-node. For
more details see
.B sane-usb (5)
manpage. You might use
.B sane-find-scanner
to check that you have access to your device.
.PP
.B Note:
.br
If there's no configuration file, the backend defaults to
.B device auto

.SH FILES
.TP
.I @CONFIGDIR@/u12.conf
The backend configuration file
.TP
.I @LIBDIR@/libsane-u12.a
The static library implementing this backend.
.TP
.I @LIBDIR@/libsane-u12.so
The shared library implementing this backend (present on systems that
support dynamic loading).

.SH ENVIRONMENT
.TP
.B SANE_CONFIG_DIR
This environment variable specifies the list of directories that may
contain the configuration file.  Under UNIX, the directories are
separated by a colon (`:'), under OS/2, they are separated by a
semi-colon (`;').  If this variable is not set, the configuration file
is searched in two default directories: first, the current working
directory (".") and then in @CONFIGDIR@.  If the value of the
environment variable ends with the directory separator character, then
the default directories are searched after the explicitly specified
directories.  For example, setting
.B SANE_CONFIG_DIR
to "/tmp/config:" would result in directories "tmp/config", ".", and
"@CONFIGDIR@" being searched (in this order).
.TP
.B SANE_DEBUG_U12
If the library was compiled with debug support enabled, this
environment variable controls the debug level for this backend.  Higher
debug levels increase the verbosity of the output.

Example:
export SANE_DEBUG_U12=10

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-usb (5),
.BR sane\-plustek (5),
.br
.I @DOCDIR@/u12/U12.changes
.br
.I http://www.gjaeger.de/scanner/u12.html

.SH "CONTACT AND BUG-REPORTS"
Please send any information and bug-reports to:
.br
.B SANE Mailing List
.PP
Additional info and hints can be obtained from our
.br
Mailing-List archive at:
.br
.B http://www.sane-project.org/mailing-lists.html
.PP
or directly from the projects' homepage at:
.br
.B http://www.gjaeger.de/scanner/u12.html
.PP
To obtain debug messages from the backend, please set the
environment-variable
.I SANE_DEBUG_U12
before calling your favorite scan-frontend (i.e. xscanimage).
.br
.B i.e.: export SANE_DEBUG_U12=20 ; xscanimage
.PP
The value controls the verbosity of the backend.

.SH "KNOWN BUGS & RESTRICTIONS"
* The driver is in alpha state, so please don't expect too
  much!!!
.br
* When using libusb, it might be, that the backend hangs. 
  In that case, reconnect the scanner.
