/*
 * FIG : Facility for Interactive Generation of figures
 * Copyright (c) 1985-1988 by Supoj Sutanthavibul
 * Parts Copyright (c) 1989-2000 by Brian V. Smith
 * Parts Copyright (c) 1991 by Paul King
 *
 * Any party obtaining a copy of these files is granted, free of charge, a
 * full and unrestricted irrevocable, world-wide, paid up, royalty-free,
 * nonexclusive right and license to deal in this software and
 * documentation files (the "Software"), including without limitation the
 * rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons who receive
 * copies from any such party to do so, with the only requirement being
 * that this copyright notice remain intact.
 *
 */

#include "fig.h"
#include "resources.h"
#include "w_icons.h"

/*********** icons for mode panel *****************/

#ifdef USE_SMALL_ICONS

#define addpt_width 22
#define addpt_height 22
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x1f,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x44,0x00,0x40,0x4e,0x00,
0x20,0x95,0x00,0x20,0x84,0x00,0x10,0x04,0x01,0x10,0x04,0x01,
0x08,0x04,0x02,0x08,0x00,0x02,0x04,0x00,0x04,0x54,0x55,0x05,
0x00,0x00,0x00,0x00,0x00,0x00};
#define align_width 22
#define align_height 22
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x8f,0x03,0x10,0x49,0x04,
0x10,0x29,0x08,0x28,0x29,0x08,0x28,0x29,0x08,0x44,0x49,0x04,
0x7c,0x8f,0x03,0xa8,0xaa,0x0a,0x00,0x00,0x00,0x98,0x00,0x00,
0xa4,0x00,0x00,0xa4,0x02,0x00,0xa4,0x30,0x07,0xbc,0x4a,0x09,
0xa4,0x4a,0x09,0xa4,0x72,0x09,0xa4,0x42,0x09,0x00,0x38,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_width 22
#define arc_height 22
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x90,0x03,0x00,0x90,0x0d,0x00,
0x10,0x10,0x00,0x10,0x20,0x00,0x00,0x20,0x00,0x00,0x40,0x00,
0x00,0x80,0x0c,0x00,0x80,0x08,0x00,0x80,0x0d,0x00,0x80,0x05,
0x00,0x80,0x0c,0x00,0x80,0x00,0x00,0x40,0x00,0x18,0x20,0x00,
0x10,0x20,0x00,0x08,0x10,0x00,0x90,0x0d,0x00,0x98,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define arc_box_width 22
#define arc_box_height 22
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xe0,0xff,0x01,0x10,0x00,0x02,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x10,0x00,0x02,0xe0,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define autoarrow_width 22
#define autoarrow_height 22
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x0a,0x00,0x00,0x0a,0x00,0x00,0x11,0x00,0x00,0x11,0x00,
0x80,0x20,0x00,0x80,0x20,0x00,0x40,0x40,0x00,0x40,0x40,0x00,
0xc0,0x7f,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define box_width 22
#define box_height 22
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x07,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,0x08,0x00,0x04,
0xf8,0xff,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define break_width 22
#define break_height 22
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x55,0x05,0x00,0x00,0x08,
0xe4,0xe0,0x00,0x10,0x11,0x09,0x34,0x08,0x02,0xc0,0x08,0x0a,
0x14,0x11,0x01,0xe0,0xe0,0x08,0x04,0x00,0x00,0x00,0x00,0x09,
0x04,0x7c,0x02,0xf0,0x11,0x0a,0x14,0x11,0x02,0x10,0x11,0x0a,
0xf4,0x11,0x01,0x00,0x90,0x08,0x04,0x00,0x00,0xa8,0xaa,0x0a,
0x00,0x00,0x00,0x00,0x00,0x00};
#define open_comp_width 22
#define open_comp_height 22
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x1f,0x00,0x04,0x10,0x00,
0xf4,0x10,0x00,0x54,0x10,0x00,0x34,0x10,0x00,0x94,0x17,0x00,
0x84,0x14,0x00,0x84,0x17,0x00,0x04,0x10,0x00,0xfc,0x1f,0x00,
0x00,0x00,0x00,0x00,0xf0,0x00,0x00,0x50,0x00,0x00,0x30,0x00,
0x00,0x90,0x07,0x00,0x80,0x04,0x00,0x80,0x07,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define join_split_width 22
#define join_split_height 22
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x08,0x00,0x04,0x14,0x00,
0x88,0x23,0x08,0x88,0x43,0x04,0x90,0x83,0x02,0x50,0x00,0x01,
0x20,0x00,0x00,0x80,0x00,0x00,0xc0,0x01,0x00,0xa0,0x02,0x00,
0x80,0x00,0x00,0x84,0x00,0x00,0xa4,0x12,0x00,0xc8,0x21,0x08,
0x88,0x40,0x04,0x10,0x80,0x02,0x10,0x00,0x01,0x20,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_intspl_width 22
#define c_intspl_height 22
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x10,0x00,
0xc0,0x1f,0x00,0xa0,0x18,0x00,0x10,0x20,0x00,0x10,0x24,0x00,
0x20,0x1c,0x00,0x40,0x0e,0x00,0x80,0x41,0x00,0x68,0x7e,0x00,
0x18,0xe0,0x00,0x18,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x03,0x28,0x10,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define c_spl_width 22
#define c_spl_height 22
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x20,0x00,0x20,0x18,0x00,
0x40,0x06,0x00,0x80,0x01,0x00,0x60,0x3e,0x00,0x10,0xc0,0x00,
0x08,0x00,0x01,0x08,0x00,0x02,0x08,0x00,0x02,0x08,0x00,0x02,
0x08,0x00,0x01,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirdia_width 22
#define cirdia_height 22
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define cirrad_width 22
#define cirrad_height 22
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0xc0,0x60,0x00,0x30,0x80,0x01,0x10,0x00,0x01,0x08,0x00,0x02,
0x08,0x00,0x02,0x04,0x00,0x04,0x04,0x04,0x04,0x04,0x56,0x05,
0x04,0x04,0x04,0x04,0x00,0x04,0x08,0x00,0x02,0x08,0x00,0x02,
0x10,0x00,0x01,0x30,0x80,0x01,0xc0,0x60,0x00,0x00,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define convert_width 22
#define convert_height 22
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x40,0x00,0x40,0x80,0x00,
0x40,0x22,0x01,0x40,0x7f,0x02,0x20,0x22,0x04,0x30,0x00,0x02,
0x08,0x00,0x01,0x08,0x80,0x00,0x08,0x00,0x01,0x70,0x00,0x02,
0x00,0x00,0x00,0xfc,0xe3,0x07,0x04,0x12,0x08,0x44,0x92,0x08,
0xe4,0xff,0x09,0x44,0x92,0x08,0x04,0x12,0x08,0xfc,0xe3,0x07,
0x00,0x00,0x00,0x00,0x00,0x00};
#define copy_width 22
#define copy_height 22
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x80,0x03,0xe8,0x80,0x0e,
0x8c,0xc0,0x08,0x84,0x48,0x08,0x84,0x5e,0x08,0x84,0x48,0x08,
0x8c,0xc0,0x08,0x98,0x80,0x09,0xf0,0x00,0x0f,0x60,0x00,0x06,
0x00,0x00,0x00,0x38,0x00,0x00,0x44,0x00,0x00,0x04,0x32,0x05,
0x04,0x55,0x05,0x44,0x35,0x07,0x38,0x12,0x04,0x00,0x10,0x03,
0x00,0x00,0x00,0x00,0x00,0x00};
#define delete_width 22
#define delete_height 22
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x80,0x3f,0x00,
0x80,0x3f,0x00,0xc0,0x64,0x00,0xc0,0x7f,0x00,0x80,0x3f,0x00,
0x00,0x0e,0x00,0x00,0x0a,0x00,0x10,0x00,0x02,0xf8,0xe0,0x07,
0x00,0x1f,0x00,0xf8,0xe0,0x07,0x10,0x00,0x02,0x00,0x00,0x00,
0x46,0x92,0x08,0xaa,0xaa,0x15,0x6a,0x9a,0x0c,0xc6,0xb2,0x18,
0x00,0x00,0x00,0x00,0x00,0x00};
#define deletept_width 22
#define deletept_height 22
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x70,0x00,0x00,
0xe0,0x00,0x00,0xd8,0x01,0x07,0x98,0x83,0x0f,0x20,0x87,0x08,
0xac,0xff,0x08,0x58,0xff,0x0f,0x40,0x30,0x07,0x88,0x70,0x00,
0x88,0xd0,0x00,0x08,0x91,0x01,0x08,0x11,0x03,0x08,0x62,0x03,
0x08,0xc2,0x01,0x08,0x04,0x00,0x08,0x04,0x00,0x08,0x08,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define edit_width 22
#define edit_height 22
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf4,0x0f,0x80,0x10,0x08,
0x38,0x50,0x0b,0x28,0x10,0x08,0x64,0xd0,0x0b,0x4c,0x10,0x08,
0x68,0xd0,0x08,0x38,0x10,0x08,0x80,0xd0,0x08,0x00,0x14,0x08,
0x00,0xf0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xa8,0x00,
0x20,0x88,0x01,0x60,0xae,0x00,0x20,0xaa,0x00,0xe0,0x2e,0x01,
0x00,0x00,0x00,0x00,0x00,0x00};
#define elldia_width 22
#define elldia_height 22
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0xac,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define ellrad_width 22
#define ellrad_height 22
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x1f,0x00,0xe0,0xe0,0x00,0x10,0x00,0x01,
0x08,0x00,0x02,0x08,0x00,0x02,0x04,0x04,0x04,0x04,0xae,0x06,
0x04,0x04,0x04,0x08,0x00,0x02,0x08,0x00,0x02,0x10,0x00,0x01,
0xe0,0xe0,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_x_width 22
#define flip_x_height 22
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xe4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0x10,0x11,0x01,0xe0,0xe4,0x00,
0x40,0x40,0x00,0x48,0x44,0x02,0xb8,0xbb,0x03,0xa0,0xa4,0x00,
0x10,0x11,0x01,0x10,0x15,0x01,0xf8,0xfb,0x03,0xa0,0xa4,0x00,
0xa0,0xa0,0x00,0xa0,0xa4,0x00,0xb0,0xb1,0x01,0x00,0x04,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define flip_y_width 22
#define flip_y_height 22
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,
0x00,0x0c,0x00,0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x21,0x00,
0x00,0x21,0x00,0x80,0x7f,0x00,0x00,0x00,0x00,0xf8,0xff,0x07,
0x00,0x00,0x00,0x80,0x7f,0x00,0x00,0x21,0x00,0x00,0x21,0x00,
0x00,0x12,0x00,0x00,0x12,0x00,0x00,0x0c,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define glue_width 22
#define glue_height 22
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x0f,0x0c,0x00,0x0c,
0xe4,0xe0,0x08,0x14,0x11,0x09,0x34,0x08,0x0a,0xc4,0x08,0x0a,
0x14,0x11,0x09,0xe4,0xe0,0x08,0x04,0x00,0x08,0x04,0x00,0x09,
0x04,0x7c,0x0a,0xf4,0x11,0x0a,0x14,0x11,0x0a,0x14,0x11,0x0a,
0xf4,0x11,0x09,0x04,0x90,0x08,0x0c,0x00,0x0c,0xfc,0xff,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00};
#define intspl_width 22
#define intspl_height 22
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0xc0,0x1f,0x00,
0xe0,0x30,0x00,0x10,0x30,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x7e,0x00,0x00,0xe0,0x00,
0x00,0x60,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x07,
0x00,0x00,0x07,0x30,0xf0,0x00,0xf0,0x3f,0x00,0x30,0x30,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define line_width 22
#define line_height 22
static unsigned char line_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x04,
0x80,0x00,0x04,0x40,0x01,0x04,0x40,0x01,0x02,0x20,0x01,0x02,
0x20,0x02,0x02,0x20,0x02,0x02,0x10,0x04,0x02,0x10,0x04,0x01,
0x08,0x04,0x01,0x08,0x08,0x01,0x00,0x08,0x01,0x00,0x04,0x01,
0x00,0x84,0x01,0x00,0x7a,0x00,0x00,0x06,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define move_width 22
#define move_height 22
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x80,0x03,0x40,0x80,0x0e,
0x88,0xc0,0x08,0x00,0x48,0x08,0x84,0x5e,0x08,0x00,0x48,0x08,
0x84,0xc0,0x08,0x08,0x80,0x09,0xa0,0x00,0x0f,0x40,0x00,0x06,
0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x00,0x00,0x6c,0x00,0x00,
0x54,0x52,0x03,0x44,0x55,0x05,0x44,0x55,0x03,0x44,0x22,0x06,
0x00,0x00,0x00,0x00,0x00,0x00};
#define movept_width 22
#define movept_height 22
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x1c,0x10,0x0e,
0x1c,0x3f,0x0e,0x3c,0x10,0x0e,0x00,0x08,0x05,0x88,0x80,0x04,
0x08,0x40,0x04,0x00,0x22,0x04,0x08,0x10,0x04,0x08,0x08,0x04,
0x00,0x08,0x04,0x08,0x04,0x04,0x08,0x22,0x04,0x00,0x01,0x04,
0x88,0x80,0x04,0x48,0x00,0x04,0x20,0x00,0x06,0x18,0x00,0x04,
0x00,0x00,0x00,0x00,0x00,0x00};
#define picobj_width 22
#define picobj_height 22
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x00,0xc0,0x45,0x00,
0x20,0x42,0x00,0x20,0x7e,0x00,0x20,0x87,0x00,0xc0,0x8f,0x00,
0x20,0xf2,0x00,0x20,0x13,0x00,0xc0,0x12,0x00,0x00,0x0c,0x00,
0x1c,0x00,0x00,0x14,0x02,0x00,0x1c,0x07,0x00,0x84,0x52,0x0b,
0x54,0x52,0x15,0x54,0x52,0x0d,0x94,0x74,0x19,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define library_width 45
#define library_height 22
static unsigned char library_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x00,0xde,0x03,0x00,
0x00,0x9e,0x1c,0x52,0x02,0x00,0x00,0x92,0xf7,0x52,0x0e,0x00,
0x80,0x93,0x94,0x53,0x0a,0x00,0x80,0x92,0x94,0x52,0x7a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0x80,0x92,0x94,0x52,0x4a,0x00,0x80,0x92,0x94,0x52,0x4a,0x00,
0xe0,0xff,0xff,0xff,0xff,0x01,0x20,0x00,0x00,0x00,0x00,0x01,
0xe0,0xff,0xff,0xff,0xff,0x01,0x80,0x01,0x00,0x00,0x60,0x00,
0x80,0x01,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define polygon_width 22
#define polygon_height 22
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x3f,0x00,
0x10,0x40,0x00,0x10,0x80,0x00,0x10,0x00,0x01,0x10,0x00,0x01,
0x10,0x00,0x01,0x10,0x80,0x00,0x10,0x40,0x00,0x10,0x3e,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,0x10,0x02,0x00,
0x10,0x02,0x00,0x10,0x02,0x00,0xf0,0x03,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define regpoly_width 22
#define regpoly_height 22
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xff,0x00,0x20,0x00,0x01,
0x20,0x00,0x01,0x10,0x00,0x02,0x10,0x00,0x02,0x08,0x01,0x04,
0x08,0x01,0x04,0x04,0x0d,0x08,0x04,0x0d,0x08,0x08,0x00,0x04,
0x08,0x00,0x04,0x10,0x00,0x02,0x10,0x00,0x02,0x20,0x00,0x01,
0x20,0x80,0x0d,0xc0,0xff,0x09,0x00,0x00,0x04,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCCW_width 22
#define rotCCW_height 22
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xc0,0x00,0x00,
0xa0,0x3f,0x00,0x10,0x40,0x00,0x10,0x80,0x00,0xa0,0x1f,0x01,
0xc0,0x20,0x01,0x80,0x40,0x02,0x00,0x40,0x02,0x00,0x40,0x02,
0x00,0x40,0x02,0x60,0x40,0x02,0x90,0x20,0x01,0x10,0x1f,0x01,
0x20,0x80,0x00,0xc0,0x60,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define rotCW_width 22
#define rotCW_height 22
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,
0x00,0x7f,0x01,0x80,0x00,0x02,0x40,0x00,0x02,0x20,0x7e,0x01,
0x20,0xc1,0x00,0x90,0x40,0x00,0x90,0x00,0x00,0x90,0x00,0x00,
0x90,0x00,0x00,0x90,0x80,0x01,0x20,0x41,0x02,0x20,0x3e,0x02,
0x40,0x00,0x01,0x80,0xc1,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define scale_width 22
#define scale_height 22
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0a,0x01,0x10,0x11,0x01,
0x90,0xbf,0x02,0x28,0x91,0x02,0x28,0x4a,0x04,0x7c,0x40,0x04,
0x00,0xe0,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x80,0x00,
0x24,0x80,0x00,0x04,0x80,0x00,0x08,0x9b,0x04,0xb0,0xa0,0x0a,
0xa0,0xb8,0x0e,0xa4,0xa8,0x02,0x18,0xb3,0x0c,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define spl_width 22
#define spl_height 22
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0x0f,0x00,
0x20,0x10,0x00,0x10,0x20,0x00,0x10,0x00,0x00,0x20,0x00,0x00,
0x40,0x00,0x00,0x80,0x01,0x00,0x00,0x3e,0x00,0x00,0xc0,0x00,
0x00,0x00,0x01,0x00,0x00,0x02,0x00,0x00,0x02,0x00,0x00,0x02,
0x00,0x00,0x03,0x10,0xe0,0x00,0xe0,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define text_width 22
#define text_height 22
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x07,
0xfc,0xff,0x07,0x0c,0x1f,0x06,0x04,0x0e,0x04,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,0x00,0x0e,0x00,
0x00,0x0e,0x00,0x00,0x3f,0x00,0xe0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};
#define update_width 22
#define update_height 22
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x48,0x00,0x00,
0x48,0x00,0x00,0x48,0x00,0x00,0x48,0x07,0x00,0x48,0xe5,0x00,
0x78,0x07,0x00,0x00,0x01,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x40,0x23,0x00,0x70,0x64,0x02,0x48,0x27,0x05,
0x48,0x25,0x03,0x70,0x4b,0x06,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#else /* USE_SMALL_ICONS */

#define regpoly_width 36
#define regpoly_height 32
static unsigned char regpoly_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x00,0x00,0x00,0x04,
0x00,0x01,0x00,0x00,0x04,0x00,0x01,0x00,0x00,0x02,0x00,
0x02,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,
0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,0x00,
0x40,0x10,0x00,0x10,0x00,0x20,0x18,0x00,0x20,0x00,0x20,
0x10,0x07,0x20,0x00,0x10,0x10,0x07,0x40,0x00,0x20,0x10,
0x07,0x20,0x00,0x20,0x10,0x00,0x20,0x00,0x40,0x38,0x00,
0x10,0x00,0x80,0x00,0x00,0x08,0x00,0x80,0x00,0x00,0x08,
0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,
0x00,0x02,0x00,0x62,0x00,0x00,0x04,0x00,0x91,0x00,0x00,
0x04,0xc0,0x81,0x00,0x00,0xf8,0xff,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define addpt_width 36
#define addpt_height 32
static unsigned char addpt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0x80,0x1f,
0x00,0x00,0x00,0x80,0x19,0x00,0x00,0x00,0x80,0x19,0x00,
0x00,0x00,0x80,0x1f,0x00,0x00,0x00,0xc0,0x3f,0x00,0x00,
0x00,0x60,0x60,0x00,0x00,0x00,0x30,0xc0,0x00,0x00,0x00,
0x18,0x80,0x01,0x00,0x00,0x0c,0x02,0x03,0x00,0x00,0x06,
0x07,0x06,0x00,0x00,0x83,0x0a,0x0c,0x00,0x80,0x01,0x02,
0x18,0x00,0xc0,0x00,0x02,0x30,0x00,0x60,0x00,0x02,0x60,
0x00,0x30,0x00,0x02,0xc0,0x00,0x18,0x00,0x02,0x80,0x01,
0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xa8,0xaa,0xaa,0xaa,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define align_width 36
#define align_height 32
static unsigned char align_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0xc0,0x60,
0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,
0x00,0x10,0x00,0x01,0x00,0x01,0x10,0x00,0x01,0x00,0xc1,0x13,
0x00,0x01,0x80,0x42,0x12,0x00,0x01,0x80,0x42,0x12,0x00,0x01,
0x40,0x44,0x22,0x80,0x00,0x40,0x44,0x22,0x80,0x00,0x20,0x48,
0xc2,0x60,0x00,0xe0,0xcf,0x03,0x1f,0x00,0x54,0x55,0x55,0x55,
0x01,0x00,0x00,0x00,0x00,0x00,0x80,0x31,0x00,0x00,0x00,0x40,
0x22,0x02,0x00,0x00,0x20,0x24,0x00,0x00,0x00,0x20,0x24,0x63,
0x35,0x00,0x20,0x24,0x92,0x4c,0x00,0xe0,0x27,0x92,0x44,0x00,
0x20,0x24,0x62,0x44,0x00,0x20,0x24,0x12,0x44,0x00,0x20,0x74,
0xe7,0x44,0x00,0x00,0x00,0x10,0x01,0x00,0x00,0x00,0xe0,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define arc_width 36
#define arc_height 32
static unsigned char arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x38,0x00,0x00,0x00,0xc0,0xf8,
0x00,0x00,0x00,0x80,0x38,0x03,0x00,0x00,0x80,0x00,0x0c,
0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x80,0x00,0x20,0x00,
0x00,0xc0,0x01,0x20,0x00,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x80,0x30,0x00,0x00,
0x00,0x80,0x48,0x00,0x00,0x00,0xc0,0x41,0x00,0x00,0x00,
0xc0,0x21,0x00,0x00,0x00,0xc0,0x11,0x00,0x00,0x00,0x80,
0x08,0x00,0x00,0x00,0x80,0x78,0x00,0x00,0x00,0x40,0x00,
0x00,0x00,0x00,0x40,0x00,0x00,0xc0,0x00,0x20,0x00,0x00,
0x20,0x01,0x20,0x00,0x00,0x00,0x01,0x10,0x00,0x00,0xc0,
0x00,0x0c,0x00,0x00,0x00,0x39,0x03,0x00,0x00,0x20,0xf9,
0x00,0x00,0x00,0xc0,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define autoarrow_width 36
#define autoarrow_height 32
static unsigned char autoarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x02,
0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x0e,0x08,0x87,0x00,0x00,
0x0a,0x10,0x45,0x00,0x00,0x0a,0x10,0x45,0x00,0x00,0x11,0xa0,
0x28,0x00,0x00,0x11,0xa0,0x28,0x00,0x00,0x11,0xc0,0x18,0x00,
0x80,0x20,0xc0,0x18,0x00,0x80,0x20,0xc0,0x18,0x00,0x80,0x20,
0x40,0x15,0x00,0x40,0x40,0x20,0x22,0x00,0x40,0x40,0x20,0x25,
0x00,0x40,0x40,0x20,0x25,0x00,0xe0,0xff,0xf0,0x7f,0x00,0x00,
0x04,0x40,0x12,0x00,0x00,0x04,0x40,0x12,0x00,0x00,0x04,0x20,
0x22,0x00,0x00,0x04,0x20,0x22,0x00,0x00,0x04,0x10,0x42,0x00,
0x00,0x04,0x10,0x42,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x04,
0x00,0x02,0x00,0x00,0x04,0x00,0x02,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define box_width 36
#define box_height 32
static unsigned char box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,0x1f,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,
0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,
0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x80,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define arc_box_width 36
#define arc_box_height 32
static unsigned char arc_box_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0xff,0x03,0x00,0x00,0x03,0x00,0x0c,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x10,0x00,
0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,
0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,
0x00,0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x40,0x00,0x00,0x20,0x00,0x80,0x00,0x00,0x10,0x00,
0x80,0x00,0x00,0x10,0x00,0x00,0x03,0x00,0x0c,0x00,0x00,
0xfc,0xff,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define cirdia_width 36
#define cirdia_height 32
static unsigned char cirdia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define cirrad_width 36
#define cirrad_height 32
static unsigned char cirrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x78,0xc0,0x03,
0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,
0x01,0x00,0x10,0x00,0x80,0x01,0x00,0x30,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,
0x60,0x00,0x00,0xc0,0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x20,0x00,0x04,0x80,0x00,0x20,0x00,0x00,0x80,0x00,0x40,
0x00,0x00,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x00,
0x40,0x00,0x80,0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,
0x00,0x01,0x00,0x10,0x00,0x00,0x06,0x00,0x0c,0x00,0x00,0x08,
0x00,0x02,0x00,0x00,0x70,0xc0,0x01,0x00,0x00,0x80,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define convert_width 36
#define convert_height 32
static unsigned char convert_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0x00,0x00,0x80,0x00,0x10,0x00,0x00,0x40,
0x00,0x08,0x00,0x00,0x20,0x00,0x08,0x00,0x00,0x10,0x00,0x08,
0x00,0x00,0x08,0x00,0x10,0x10,0x40,0x04,0x00,0x60,0x08,0x80,
0x08,0x00,0x80,0xfc,0xff,0x11,0x00,0x00,0x09,0x80,0x20,0x00,
0x00,0x11,0x40,0x40,0x00,0x00,0x01,0x00,0x20,0x00,0x80,0x00,
0x00,0x10,0x00,0x70,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x08,
0x40,0x40,0x80,0x00,0x08,0x48,0x20,0x01,0x01,0x08,0x44,0x20,
0x02,0x01,0x08,0xfe,0xff,0x07,0x01,0x08,0x44,0x20,0x02,0x01,
0x08,0x48,0x20,0x01,0x01,0x08,0x40,0x20,0x00,0x01,0x08,0x40,
0x40,0x80,0x00,0xf8,0x7f,0x80,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define c_spl_width 36
#define c_spl_height 32
static unsigned char c_spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0x60,0x00,0x00,0x00,0x02,0x80,
0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x0c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x80,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x20,0x00,0x40,0x00,0x00,0x20,
0x00,0x20,0x00,0x00,0x20,0x00,0x20,0x00,0x00,0x20,0x00,
0x20,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0x07,
0xf0,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define copy_width 36
#define copy_height 32
static unsigned char copy_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x03,
0x00,0x1c,0x00,0xc0,0x07,0x00,0x3e,0x00,0x60,0x0c,0x00,0x63,
0x00,0x30,0x0c,0x80,0x61,0x00,0x30,0x0c,0x80,0x61,0x00,0x30,
0x0c,0x80,0x61,0x00,0x30,0x18,0x88,0xc1,0x00,0x30,0x18,0x90,
0xc1,0x00,0x30,0xd8,0xbf,0xc1,0x00,0x30,0x18,0x90,0xc1,0x00,
0x30,0x18,0x88,0xc1,0x00,0x30,0x0c,0x80,0x61,0x00,0x60,0x0c,
0x00,0x63,0x00,0xc0,0x0c,0x00,0x66,0x00,0x80,0x0f,0x00,0x7c,
0x00,0x00,0x07,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,0x40,0x00,0x00,
0x00,0x00,0x40,0xe0,0x34,0x11,0x00,0x40,0x10,0x4d,0x11,0x00,
0x40,0x10,0x45,0x11,0x00,0x40,0x14,0x4d,0x19,0x00,0x80,0xe3,
0x34,0x16,0x00,0x00,0x00,0x04,0x10,0x00,0x00,0x00,0x04,0x0f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define glue_width 36
#define glue_height 32
static unsigned char glue_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,
0xff,0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x10,0x00,0xe0,
0x40,0x00,0x10,0x3c,0x18,0x43,0x00,0x10,0x42,0x04,0x44,
0x00,0x10,0x81,0x04,0x44,0x00,0x10,0x01,0x04,0x44,0x00,
0x10,0x02,0x18,0x43,0x00,0x10,0x3c,0xe0,0x40,0x00,0x10,
0x40,0x00,0x40,0x00,0x10,0x80,0x00,0x40,0x00,0x10,0x81,
0x00,0x41,0x00,0x10,0x42,0x00,0x42,0x00,0x10,0x3c,0x00,
0x44,0x00,0x10,0x00,0xfe,0x48,0x00,0x10,0x00,0x10,0x48,
0x00,0x10,0x00,0x10,0x48,0x00,0x10,0xff,0x10,0x48,0x00,
0x10,0x81,0x10,0x48,0x00,0x10,0x81,0x10,0x44,0x00,0x10,
0x81,0x10,0x42,0x00,0x10,0xff,0x10,0x41,0x00,0x10,0x00,
0x00,0x40,0x00,0x38,0x00,0x00,0xe0,0x00,0xf8,0xff,0xff,
0xff,0x00,0x38,0x00,0x00,0xe0,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define break_width 36
#define break_height 32
static unsigned char break_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,
0x55,0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0xe0,
0x40,0x00,0x00,0x3c,0x18,0x03,0x00,0x10,0x42,0x04,0x44,
0x00,0x00,0x81,0x04,0x04,0x00,0x10,0x01,0x04,0x44,0x00,
0x00,0x02,0x18,0x03,0x00,0x10,0x3c,0xe0,0x40,0x00,0x00,
0x40,0x00,0x00,0x00,0x10,0x80,0x00,0x40,0x00,0x00,0x81,
0x00,0x01,0x00,0x10,0x42,0x00,0x42,0x00,0x00,0x3c,0x00,
0x04,0x00,0x10,0x00,0xfe,0x48,0x00,0x00,0x00,0x10,0x08,
0x00,0x10,0x00,0x10,0x48,0x00,0x00,0xff,0x10,0x08,0x00,
0x10,0x81,0x10,0x48,0x00,0x00,0x81,0x10,0x04,0x00,0x10,
0x81,0x10,0x42,0x00,0x00,0xff,0x10,0x01,0x00,0x10,0x00,
0x00,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x55,0x55,
0x55,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define open_comp_width 36
#define open_comp_height 32
static unsigned char open_comp_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x0c,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x10,
0x00,0x04,0x00,0x00,0x10,0x00,0x04,0x00,0x00,0x90,0x01,0x04,
0x00,0x00,0x50,0x02,0x04,0x00,0x00,0x50,0x82,0x04,0x00,0x00,
0x90,0xe1,0x04,0x00,0x00,0x10,0x98,0x04,0x00,0x00,0x10,0x8c,
0x04,0x00,0x00,0x10,0xb0,0x04,0x00,0x00,0x10,0xc0,0x04,0x00,
0x00,0x10,0x00,0x04,0x00,0x00,0xf8,0xff,0x0f,0x00,0x00,0x18,
0x00,0x0c,0x00,0x00,0x00,0x00,0xc0,0x00,0x00,0x00,0x00,0x20,
0x01,0x00,0x00,0x00,0x20,0x41,0x00,0x00,0x00,0xc0,0x70,0x00,
0x00,0x00,0x00,0x4c,0x00,0x00,0x00,0x00,0x46,0x00,0x00,0x00,
0x00,0x58,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define join_split_width 36
#define join_split_height 32
static unsigned char join_split_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x08,0x80,0x00,0x00,0x01,0x10,0x40,0x03,0x00,
0x01,0x10,0x40,0x04,0x80,0x00,0x20,0x78,0x18,0x80,0x00,0x40,
0x78,0x20,0x40,0x00,0x40,0x78,0x40,0x20,0x00,0x80,0x78,0x80,
0x21,0x00,0x00,0x0d,0x04,0x12,0x00,0x00,0x05,0x0e,0x0c,0x00,
0x00,0x02,0x15,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,
0x04,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x15,0x00,
0x00,0x00,0x00,0x0e,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x08,
0x00,0x00,0x00,0x00,0x10,0x80,0x00,0x00,0x01,0x10,0x00,0x03,
0x00,0x01,0x20,0x00,0x04,0x80,0x00,0x40,0x00,0x18,0x80,0x00,
0x40,0x00,0x20,0x40,0x00,0x80,0x00,0x40,0x20,0x00,0x00,0x01,
0x80,0x21,0x00,0x00,0x01,0x00,0x12,0x00,0x00,0x00,0x00,0x0c,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00};

#define delete_width 36
#define delete_height 32
static unsigned char delete_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0xc0,
0x0f,0x00,0x00,0x00,0xe0,0x1f,0x00,0x00,0x00,0x30,0x33,
0x00,0x00,0x00,0x30,0x33,0x00,0x00,0x00,0xe0,0x1f,0x00,
0x00,0x00,0xc0,0x0f,0x00,0x00,0x00,0x80,0x07,0x00,0x00,
0x00,0x84,0x87,0x00,0x00,0x00,0x84,0x87,0x01,0x00,0x00,
0x08,0x43,0x00,0x00,0x00,0x70,0x38,0x00,0x00,0x00,0x80,
0x07,0x00,0x00,0x00,0xe0,0x1f,0x01,0x00,0x00,0x3c,0xf0,
0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0xc0,0x00,0x02,0x00,
0x48,0x80,0x00,0x07,0x00,0x48,0x8e,0x38,0xc2,0x01,0x48,
0x91,0x44,0x22,0x02,0x48,0x9f,0x7c,0xe2,0x03,0x48,0x81,
0x04,0x22,0x00,0x48,0x91,0x44,0x2a,0x02,0x3c,0xce,0x39,
0xc4,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define deletept_width 36
#define deletept_height 32
static unsigned char deletept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xc0,0x01,0x00,0x00,0x00,0x40,0x01,0x00,
0x00,0x00,0xc0,0x01,0x00,0x00,0x80,0xc7,0x00,0x00,0x00,0x00,
0xa9,0x00,0x00,0x00,0x00,0xb2,0x00,0x00,0x00,0x00,0xa4,0x00,
0x00,0x00,0x00,0xc8,0x00,0x00,0x00,0x10,0x98,0x00,0x00,0x00,
0x70,0x28,0x01,0x00,0x00,0x90,0x45,0x02,0x00,0x00,0x30,0x86,
0x04,0x00,0x00,0xc0,0x9a,0x09,0x00,0x00,0x00,0xe3,0x12,0x00,
0x00,0x00,0x8d,0x25,0x00,0x00,0x00,0xb1,0x4e,0x00,0x00,0x80,
0xc0,0x58,0x38,0x00,0x80,0x80,0xe3,0x7c,0x00,0x40,0x80,0xfe,
0xcf,0x00,0x20,0x80,0x80,0x9d,0x00,0x20,0x80,0xc0,0xf3,0x00,
0x10,0x80,0xc0,0x66,0x00,0x10,0x80,0xc0,0x0c,0x00,0x00,0x80,
0x80,0x09,0x00,0x00,0x80,0x00,0x0b,0x00,0x00,0x80,0x00,0x0e,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define elldia_width 36
#define elldia_height 32
static unsigned char elldia_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x60,0x55,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x04,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc4,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define ellrad_width 36
#define ellrad_height 32
static unsigned char ellrad_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,
0x70,0xc4,0x01,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x02,0x04,
0x08,0x00,0x00,0x01,0x00,0x10,0x00,0x80,0x00,0x04,0x20,0x00,
0x40,0x00,0x00,0x40,0x00,0x40,0x00,0x04,0x40,0x00,0x20,0x00,
0x04,0x80,0x00,0x20,0x00,0x5f,0xd5,0x00,0x20,0x00,0x04,0x80,
0x00,0x40,0x00,0x04,0x40,0x00,0x40,0x00,0x00,0x40,0x00,0x80,
0x00,0x00,0x20,0x00,0x00,0x01,0x00,0x10,0x00,0x00,0x02,0x00,
0x08,0x00,0x00,0x0c,0x00,0x06,0x00,0x00,0x70,0xc0,0x01,0x00,
0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define flip_x_width 36
#define flip_x_height 32
static unsigned char flip_x_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x1c,0xc0,0x01,0x00,0x00,0x22,
0x22,0x02,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x41,0x12,
0x04,0x00,0x00,0x41,0x10,0x04,0x00,0x00,0x22,0x22,0x02,
0x00,0x00,0x14,0x40,0x01,0x00,0x00,0x14,0x42,0x01,0x00,
0x80,0xe3,0x38,0x0e,0x00,0x40,0x00,0x07,0x10,0x00,0x20,
0xc3,0x18,0x24,0x00,0x90,0x22,0x27,0x4a,0x00,0x50,0x22,
0x22,0x52,0x00,0x30,0x41,0x10,0x64,0x00,0x00,0x41,0x12,
0x04,0x00,0x80,0x80,0x08,0x08,0x00,0x80,0x80,0x0a,0x08,
0x00,0x40,0x00,0x05,0x10,0x00,0xc0,0xeb,0xbf,0x1e,0x00,
0x00,0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,
0x2a,0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x2a,
0xa0,0x02,0x00,0x00,0x2a,0xa2,0x02,0x00,0x00,0x3e,0xe0,
0x03,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define flip_y_width 36
#define flip_y_height 32
static unsigned char flip_y_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0xa0,0x00,
0x00,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,0x10,0x01,0x02,
0x00,0x00,0x10,0x01,0x0f,0x00,0x00,0x08,0x02,0x32,0x00,
0x00,0x08,0x02,0x44,0x00,0x00,0x04,0x04,0x40,0x00,0x00,
0xfc,0x07,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x50,0x55,
0x55,0x81,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0xfc,0x07,
0x80,0x00,0x00,0x04,0x04,0x40,0x00,0x00,0x08,0x02,0x44,
0x00,0x00,0x08,0x02,0x32,0x00,0x00,0x10,0x01,0x0f,0x00,
0x00,0x10,0x01,0x02,0x00,0x00,0xa0,0x00,0x04,0x00,0x00,
0xa0,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x40,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define intspl_width 36
#define intspl_height 32
static unsigned char intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x1c,0xe7,0x03,0x00,0x00,0x02,0x80,
0x03,0x00,0x00,0x01,0x80,0x03,0x00,0x80,0x03,0x00,0x00,
0x00,0x80,0x03,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,
0x00,0x02,0x00,0x00,0x00,0x00,0x3c,0x0e,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x00,0x8e,0x07,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,
0x20,0x00,0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x0c,0x00,0x00,
0x01,0x00,0x03,0x00,0x00,0x8e,0xe3,0x00,0x00,0x00,0xf0,
0x1f,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define c_intspl_width 36
#define c_intspl_height 32
static unsigned char c_intspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xe0,
0x1f,0x00,0x00,0x00,0x9c,0x63,0x00,0x00,0x00,0x02,0xc0,
0x01,0x00,0x80,0x03,0xc0,0x01,0x00,0x80,0x03,0xc0,0x01,
0x00,0x80,0x03,0x80,0x00,0x00,0x00,0x01,0x40,0x00,0x00,
0x00,0x02,0x30,0x00,0x00,0x00,0x3c,0x1c,0x00,0x00,0x00,
0xc0,0x7f,0x00,0x00,0x00,0x30,0x9c,0x07,0x00,0x00,0x0c,
0x00,0x08,0x00,0x00,0x03,0x00,0x10,0x00,0x80,0x00,0x00,
0x20,0x00,0x40,0x00,0x00,0x70,0x00,0x40,0x00,0x00,0x70,
0x00,0xe0,0x00,0x00,0x70,0x00,0xe0,0x00,0x00,0x20,0x00,
0xe0,0x00,0x00,0x10,0x00,0x40,0x00,0x00,0x08,0x00,0x40,
0x00,0x00,0x04,0x00,0x80,0x00,0x00,0x03,0x00,0x00,0xc7,
0xf1,0x00,0x00,0x00,0xf8,0x0f,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define line_width 36
#define line_height 32
static unsigned char line_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x20,0x00,0x04,0x00,0x00,0x30,0x00,
0x0c,0x00,0x00,0x50,0x00,0x0c,0x00,0x00,0x48,0x00,0x14,
0x00,0x00,0x88,0x00,0x14,0x00,0x00,0x84,0x00,0x14,0x00,
0x00,0x04,0x01,0x22,0x00,0x00,0x02,0x01,0x22,0x00,0x00,
0x02,0x02,0x22,0x00,0x00,0x01,0x02,0x42,0x00,0x00,0x01,
0x04,0x42,0x00,0x80,0x00,0x04,0x42,0x00,0x80,0x00,0x02,
0x01,0x00,0x40,0x00,0x01,0x01,0x00,0x40,0x80,0x00,0x01,
0x00,0x20,0x40,0x00,0x01,0x00,0x20,0x20,0x00,0x01,0x00,
0x00,0x10,0x00,0x01,0x00,0x00,0x08,0x80,0x00,0x00,0x00,
0x30,0x40,0x00,0x00,0x00,0xc0,0x20,0x00,0x00,0x00,0x00,
0x13,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define library_width 73
#define library_height 32
static unsigned char library_bits[]={
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xb0,0x01,0x00,
0x00,0x00,0x00,0x00,0xf8,0x07,0x00,0x5f,0x1f,0x00,0x00,0x00,
0x00,0x00,0xa8,0x04,0xe0,0xb9,0x13,0x00,0x00,0x00,0x00,0x00,
0x98,0x04,0xa0,0x59,0x13,0x00,0x00,0x00,0x00,0xc0,0xcf,0x04,
0x7f,0xb9,0x13,0x00,0x00,0x00,0x00,0xc0,0xae,0x04,0x3b,0xb9,
0x13,0x00,0x00,0x00,0x00,0x40,0x9d,0xfc,0xb5,0x59,0xf3,0x03,
0x00,0x00,0x00,0xc0,0xce,0xdc,0x7b,0xb9,0x73,0x03,0x00,0x00,
0x00,0x40,0xad,0xac,0x35,0x59,0xb3,0x02,0x00,0x00,0x00,0xc0,
0x9e,0xdc,0xbb,0xb9,0x73,0x03,0x00,0x00,0x00,0x60,0xcd,0xac,
0x75,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,0xae,0xdc,0x3b,0x59,
0x73,0x0f,0x00,0x00,0x00,0x60,0x9d,0xac,0xb5,0xb9,0xb3,0x0e,
0x00,0x00,0x00,0xe0,0xce,0xdc,0x7b,0x59,0x73,0x0f,0x00,0x00,
0x00,0x60,0xad,0xac,0x35,0xb9,0xb3,0x0e,0x00,0x00,0x00,0xe0,
0x9e,0xdc,0xbb,0xb9,0x73,0x0f,0x00,0x00,0x00,0x78,0xcd,0xac,
0x75,0x59,0xb3,0x0e,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,
0xff,0x3f,0x00,0x00,0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,
0x00,0xf8,0xff,0xff,0xff,0xff,0xff,0x3f,0x00,0x00,0x00,0x80,
0x02,0x00,0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x01,0x00,0x00,0x00,0x80,0x02,0x00,0x00,0x00,
0x40,0x01,0x00,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0xc0,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define move_width 36
#define move_height 32
static unsigned char move_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x02,0x00,0x1c,0x00,0x20,0x00,
0x00,0x3e,0x00,0x10,0x04,0x00,0x63,0x00,0x00,0x00,0x80,
0x61,0x00,0x10,0x04,0x80,0x61,0x00,0x00,0x08,0x80,0x61,
0x00,0x10,0x00,0x88,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,
0x10,0xc0,0xbf,0xc1,0x00,0x00,0x08,0x90,0xc1,0x00,0x10,
0x00,0x88,0xc1,0x00,0x00,0x04,0x80,0x61,0x00,0x20,0x00,
0x00,0x63,0x00,0x00,0x04,0x00,0x66,0x00,0x80,0x02,0x00,
0x7c,0x00,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x04,0x00,0x00,0x00,
0xc0,0x06,0x00,0x00,0x00,0xc0,0xc6,0x89,0x1c,0x00,0x40,
0x25,0x8a,0x22,0x00,0x40,0x25,0x8a,0x3e,0x00,0x40,0x24,
0x52,0x02,0x00,0x40,0x24,0x52,0x22,0x00,0x40,0xc4,0x21,
0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define movept_width 36
#define movept_height 32
static unsigned char movept_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0xa0,0x02,
0x08,0x7e,0x00,0x00,0x00,0x10,0x66,0x00,0x20,0xe2,0x3f,
0x66,0x00,0x00,0x00,0x10,0x7e,0x00,0xa0,0x02,0x08,0x7e,
0x00,0x00,0x00,0x00,0x1c,0x00,0x80,0x02,0x00,0x1e,0x00,
0x00,0x00,0x00,0x1b,0x00,0x80,0x08,0x80,0x19,0x00,0x00,
0x00,0xc0,0x18,0x00,0x80,0x20,0x60,0x18,0x00,0x00,0x00,
0x30,0x18,0x00,0x80,0x80,0x18,0x18,0x00,0x00,0x00,0x0c,
0x18,0x00,0x80,0x00,0x06,0x18,0x00,0x00,0x00,0x03,0x18,
0x00,0x80,0x80,0x09,0x18,0x00,0x00,0xc0,0x00,0x18,0x00,
0x80,0x60,0x20,0x18,0x00,0x00,0x30,0x00,0x18,0x00,0x80,
0x18,0x80,0x18,0x00,0x00,0x0c,0x00,0x18,0x00,0x80,0x06,
0x00,0x1a,0x00,0x00,0x03,0x00,0x18,0x00,0x80,0x01,0x00,
0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define polygon_width 36
#define polygon_height 32
static unsigned char polygon_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,
0x7f,0x00,0x00,0x00,0x01,0x80,0x00,0x00,0x00,0x01,0x00,
0x01,0x00,0x00,0x01,0x00,0x02,0x00,0x00,0x01,0x00,0x04,
0x00,0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,
0x00,0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x08,0x00,0x00,
0x01,0x00,0x08,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x02,0x00,0x00,0x01,0x00,0x01,0x00,0x00,0x01,0x80,
0x00,0x00,0x00,0x01,0x7f,0x00,0x00,0x00,0x01,0x01,0x00,
0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,
0x00,0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,
0x01,0x01,0x00,0x00,0x00,0x01,0x01,0x00,0x00,0x00,0x01,
0x01,0x00,0x00,0x00,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define scale_width 36
#define scale_height 32
static unsigned char scale_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x0a,0x00,0x40,0x20,0x04,
0x0a,0x00,0x40,0x10,0x08,0x11,0x00,0xa0,0xf8,0x1f,0x11,
0x00,0xa0,0x10,0x88,0x20,0x00,0x10,0x21,0x84,0x20,0x00,
0xf0,0x01,0x40,0x40,0x00,0x00,0x00,0x40,0x40,0x00,0x00,
0x00,0x20,0x80,0x00,0x00,0x00,0x20,0x80,0x00,0x00,0x00,
0x10,0x00,0x01,0x00,0x00,0xf0,0xff,0x01,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xe0,0x00,0xc0,0x00,0x00,0x10,0x01,0x80,0x00,0x00,
0x10,0x00,0x80,0x00,0x00,0x10,0x38,0x8e,0x38,0x00,0xe0,
0x44,0x90,0x44,0x00,0x00,0x05,0x9e,0x7c,0x00,0x00,0x05,
0x91,0x04,0x00,0x10,0x45,0x99,0x44,0x00,0xe0,0x38,0xd6,
0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define spl_width 36
#define spl_height 32
static unsigned char spl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,
0x0f,0x00,0x00,0x00,0x0e,0x70,0x00,0x00,0x00,0x01,0x80,
0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x80,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x01,0x00,0x00,0x00,0x00,0x1e,0x00,0x00,0x00,0x00,
0xe0,0x3f,0x00,0x00,0x00,0x00,0xc0,0x03,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0x10,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x10,
0x00,0x80,0x00,0x00,0x10,0x00,0x80,0x00,0x00,0x08,0x00,
0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x02,0x00,0x00,
0x02,0x80,0x01,0x00,0x00,0x1c,0x78,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define text_width 36
#define text_height 32
static unsigned char text_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xff,0xff,
0x1f,0x00,0x80,0x83,0x1f,0x1c,0x00,0x80,0x01,0x0f,0x18,
0x00,0x80,0x00,0x0f,0x10,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,
0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,
0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,
0x00,0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,
0x00,0x00,0x0f,0x00,0x00,0x00,0x00,0x0f,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0xe0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define picobj_width 36
#define picobj_height 32
static unsigned char picobj_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x7f,0x00,
0x00,0xe0,0x9b,0xff,0x3c,0x00,0xe0,0xdb,0xff,0x3d,0x00,0xe0,
0xff,0xff,0x7f,0x00,0x30,0x00,0x00,0xc0,0x00,0xf0,0xff,0xbe,
0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,
0xf0,0xff,0x9c,0xff,0x00,0xf0,0x7f,0x22,0xff,0x00,0xf0,0x7f,
0x41,0xff,0x00,0xf0,0x7f,0x41,0xff,0x00,0xf0,0x7f,0x22,0xff,
0x00,0xf0,0xff,0x9c,0xff,0x00,0xf0,0xff,0xc1,0xff,0x00,0xf0,
0xff,0xff,0xff,0x00,0xf0,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
0x00,0x00,0x78,0x04,0x00,0x00,0x00,0x90,0x00,0x02,0x00,0x00,
0x90,0x66,0x97,0x9a,0x01,0x70,0x14,0x92,0x44,0x01,0x10,0x14,
0x92,0xc4,0x00,0x10,0x14,0x92,0x44,0x00,0x38,0x64,0x64,0x8e,
0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCCW_width 36
#define rotCCW_height 32
static unsigned char rotCCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x02,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x80,0x02,0x00,
0x00,0x00,0x40,0x1e,0x00,0x00,0x00,0x20,0x60,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x40,0x1e,0x01,0x00,0x00,0x80,0x22,
0x01,0x00,0x00,0x00,0x43,0x02,0x00,0x00,0x00,0x42,0x02,0x00,
0x00,0x78,0x40,0x02,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define rotCW_width 36
#define rotCW_height 32
static unsigned char rotCW_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x08,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x28,0x00,
0x00,0x00,0x00,0x4f,0x00,0x00,0x00,0xc0,0x80,0x00,0x00,0x00,
0x20,0x80,0x00,0x00,0x00,0x10,0x4f,0x00,0x00,0x00,0x90,0x28,
0x00,0x00,0x00,0x48,0x18,0x00,0x00,0x00,0x48,0x08,0x00,0x00,
0x00,0x48,0xc0,0x03,0x00,0x00,0x48,0x40,0x02,0x00,0x00,0x48,
0x40,0x02,0x00,0x00,0x90,0x20,0x01,0x00,0x00,0x10,0x1f,0x01,
0x00,0x00,0x20,0x80,0x00,0x00,0x00,0xc0,0x60,0x00,0x00,0x00,
0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x78,0x80,0x00,
0x02,0x00,0x88,0x80,0x00,0x02,0x00,0x88,0xcc,0x31,0xc7,0x00,
0x88,0x92,0x40,0x22,0x01,0x78,0x92,0x78,0xe2,0x01,0x88,0x92,
0x48,0x22,0x00,0x88,0x92,0x4a,0x2a,0x01,0x88,0x0c,0x71,0xc4,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define update_width 36
#define update_height 32
static unsigned char update_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xc0,0x07,0xff,0xff,0x01,0x60,0x0d,0x01,0x00,
0x01,0xb0,0x1a,0x01,0x3e,0x01,0x50,0x35,0x3d,0x2a,0x01,0xb0,
0x2a,0x01,0x36,0x01,0x50,0x35,0x7d,0x2a,0x01,0xb0,0x2a,0x01,
0x3e,0x01,0x60,0x35,0x01,0x00,0x01,0xc0,0x1f,0xff,0xff,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x01,0x00,0x80,0x03,
0x80,0x03,0x00,0x40,0x05,0x40,0x05,0x00,0x00,0x01,0x00,0x01,
0x00,0x00,0xff,0xff,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x48,
0x00,0x02,0x02,0x00,0x48,0x00,0x02,0x02,0x00,0x48,0x8d,0x32,
0xc7,0x00,0x48,0x53,0x43,0x22,0x01,0x48,0x51,0x7a,0xe2,0x01,
0x48,0x53,0x4a,0x22,0x00,0x48,0x4d,0x4b,0x2a,0x01,0x30,0x81,
0x72,0xc4,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,};

#define edit_width 36
#define edit_height 32
static unsigned char edit_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xc0,0xa7,
0xaa,0xff,0x00,0x60,0x0c,0x80,0x80,0x00,0x20,0x18,0x80,
0x8e,0x00,0x30,0x30,0x80,0x80,0x00,0x10,0x20,0x80,0x9e,
0x00,0x30,0x20,0x80,0x80,0x00,0x60,0x30,0x80,0x86,0x00,
0xc0,0x18,0x80,0x80,0x00,0x80,0x0f,0x80,0xbe,0x00,0x00,
0x20,0x80,0x80,0x00,0x00,0x80,0x80,0xbe,0x00,0x00,0x00,
0x82,0x80,0x00,0x00,0x00,0x88,0x80,0x00,0x00,0x00,0xa0,
0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x1f,0x04,0x00,0x00,0x00,0x01,0x44,0x04,0x00,
0x00,0x01,0x04,0x04,0x00,0x00,0x81,0x65,0x0e,0x00,0x00,
0x4f,0x46,0x04,0x00,0x00,0x41,0x44,0x04,0x00,0x00,0x41,
0x44,0x04,0x00,0x00,0x41,0x46,0x14,0x00,0x00,0x9f,0xe5,
0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#endif /* USE_SMALL_ICONS */

/********* special icon for X-Splines used in popup edit panel */

#define c_xspl_width 36
#define c_xspl_height 32
static unsigned char    c_xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x0f,0x00,0xfe,0x03,0x10,0x08,
0x00,0x02,0x01,0x10,0x08,0x00,0x81,0x00,0x20,0x08,0x80,
0x40,0x00,0x40,0x10,0x40,0x20,0x00,0x40,0x20,0x40,0x20,
0x00,0x80,0x20,0x20,0x10,0x00,0x80,0x40,0x10,0x08,0x00,
0x80,0x80,0x08,0x08,0x00,0x00,0x01,0x07,0x04,0x00,0x00,
0x01,0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,
0x00,0x04,0x00,0x00,0x01,0x00,0x04,0x00,0x00,0x01,0x00,
0x08,0x00,0x00,0x01,0x07,0x08,0x00,0x80,0x80,0x08,0x08,
0x00,0x80,0x40,0x10,0x10,0x00,0x40,0x40,0x20,0x10,0x00,
0x40,0x20,0x20,0x20,0x00,0x20,0x20,0x40,0x40,0x00,0x20,
0x10,0x40,0x80,0x00,0x10,0x08,0x80,0x00,0x01,0x08,0x08,
0x80,0x00,0x02,0xf8,0x0f,0x00,0xff,0x03,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

#define xspl_width 36
#define xspl_height 32
static unsigned char    xspl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x08,0x00,
0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,
0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,
0x00,0x08,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,
0xf8,0x0f,0x00,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,
0x01,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,
0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x01,0x00,
0x00,0x00,0x00,0x01,0x00,0x00,0x04,0x80,0x00,0x00,0x00,
0x38,0x40,0x00,0x00,0x00,0xc0,0x31,0x00,0x00,0x00,0x00,
0x0e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00};

/********* icons for indicator panel **********/


#define open_arc_width 32
#define open_arc_height 32
static unsigned char open_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x80,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x60,0x00,
0x00,0x00,0x60,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,
0x00,0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x18,0x00,
0x00,0x00,0x18,0x00,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x06,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define pie_wedge_arc_width 32
#define pie_wedge_arc_height 32
static unsigned char pie_wedge_arc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x03,0x00,0x00,0x80,0x07,0x00,0x00,0xc0,0x0c,0x00,
0x00,0x60,0x18,0x00,0x00,0x30,0x18,0x00,0x00,0x18,0x30,0x00,
0x00,0x0c,0x30,0x00,0x00,0x06,0x60,0x00,0x00,0x03,0x60,0x00,
0x80,0x01,0x60,0x00,0xc0,0x00,0x60,0x00,0x60,0x00,0xc0,0x00,
0x30,0x00,0xc0,0x00,0x18,0x00,0xc0,0x00,0x30,0x00,0xc0,0x00,
0x60,0x00,0xc0,0x00,0xc0,0x00,0x60,0x00,0x80,0x01,0x60,0x00,
0x00,0x03,0x60,0x00,0x00,0x06,0x60,0x00,0x00,0x0c,0x30,0x00,
0x00,0x18,0x30,0x00,0x00,0x30,0x18,0x00,0x00,0x60,0x18,0x00,
0x00,0xc0,0x0c,0x00,0x00,0x80,0x07,0x00,0x00,0x00,0x03,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartoff_width 32
#define smartoff_height 32
static unsigned char smartoff_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0xc0,0x3f,0x00,0x00,0x00,0x40,0x40,
0x08,0x00,0x00,0x00,0x08,0x00,0x40,0x55,0x08,0x00,0x00,
0x00,0x08,0x00,0xc0,0x7f,0x08,0x00,0x40,0x40,0x2a,0x00,
0x40,0x40,0x1c,0x00,0x40,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x80,0xe3,0xf3,0x01,0x40,0x24,0x10,0x00,0x40,0xe4,
0x70,0x00,0x40,0x24,0x10,0x00,0x80,0x23,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartmove_width 32
#define smartmove_height 32
static unsigned char smartmove_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x80,0x00,0x00,0x08,0x00,0x41,0x55,0x08,0x00,0x02,
0x00,0x08,0x00,0xc4,0x7f,0x08,0x00,0x48,0x40,0x2a,0x00,
0x50,0x40,0x1c,0x00,0x60,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x88,0x38,0x22,0x1f,0xd8,0x44,0x22,0x01,0xa8,0x44,
0x22,0x07,0x88,0x44,0x14,0x01,0x88,0x38,0x08,0x1f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define smartslide_width 32
#define smartslide_height 32
static unsigned char smartslide_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0x07,0x00,
0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,
0x00,0x00,0x04,0x04,0x00,0x00,0x04,0x04,0x00,0x00,0xfc,
0x07,0x00,0x00,0x40,0x40,0x55,0x00,0x40,0x00,0x00,0x00,
0x40,0x40,0x40,0x00,0x40,0x15,0x00,0x00,0x40,0x40,0x40,
0x08,0x40,0x00,0x00,0x08,0x40,0x40,0x55,0x08,0x40,0x00,
0x00,0x08,0x40,0xc0,0x7f,0x08,0x40,0x40,0x40,0x2a,0x40,
0x40,0x40,0x1c,0xc0,0x7f,0x40,0x08,0x00,0x40,0x40,0x00,
0x00,0x40,0x40,0x00,0x00,0xc0,0x7f,0x00,0x00,0x00,0x00,
0x00,0x70,0x82,0x73,0x1e,0x08,0x02,0x91,0x02,0x70,0x02,
0x91,0x0e,0x80,0x02,0x91,0x02,0x70,0x9e,0x73,0x1e,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinmiter_width 32
#define joinmiter_height 32
static unsigned char joinmiter_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x03,0xf0,0xff,0xff,0x00,
0xf0,0xff,0x3f,0x00,0x00,0xf8,0x0f,0x00,0x00,0xfe,0x03,0x00,
0x80,0xff,0x00,0x00,0xe0,0x3f,0x00,0x00,0xf0,0x0f,0x00,0x00,
0xf0,0x03,0x00,0x00,0xf0,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinround_width 32
#define joinround_height 32
static unsigned char joinround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x0f,
0xf0,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define joinbevel_width 32
#define joinbevel_height 32
static unsigned char joinbevel_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x00,0x80,0xff,0x03,
0x00,0xe0,0xff,0x00,0x00,0xf8,0x3f,0x00,0x00,0xfe,0x0f,0x00,
0x80,0xff,0x03,0x00,0xe0,0xff,0x00,0x00,0xc0,0x3f,0x00,0x00,
0xc0,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capbutt_width 32
#define capbutt_height 32
static unsigned char capbutt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,
0xc0,0xff,0xff,0x01,0xc0,0xff,0xff,0x01,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capround_width 32
#define capround_height 32
static unsigned char capround_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf8,0xff,0xff,0x0f,0xf8,0xff,0xff,0x0f,
0xf8,0xff,0xff,0x0f,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define capproject_width 32
#define capproject_height 32
static unsigned char capproject_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,
0xf0,0xff,0xff,0x07,0xf0,0xff,0xff,0x07,0x40,0x00,0x00,0x01,
0x40,0x00,0x00,0x01,0x40,0x00,0x00,0x01,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define solidline_width 32
#define solidline_height 32
static unsigned char solidline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashline_width 32
#define dashline_height 32
static unsigned char dashline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x7c,0x7c,0x7c,0x7c,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dottedline_width 32
#define dottedline_height 32
static unsigned char dottedline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x08,0x21,0x84,0x10,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dashdotline_width 32
#define dashdotline_height 32
static unsigned char dashdotline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0xe2,0x47,0xfc,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash2dotsline_width 32
#define dash2dotsline_height 32
static unsigned char dash2dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x12,0x3f,0x12,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define dash3dotsline_width 32
#define dash3dotsline_height 32
static unsigned char dash3dotsline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x3f,0x92,0xf8,0x91,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

/* fine grid (only used for point positioning) */

#define fine_grid_width 32
#define fine_grid_height 32
static unsigned char fine_grid_bits[]={
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0xff,0xff,0xff,0xff,0x48,0x92,0x24,0x09,
0x48,0x92,0x24,0x09,0x48,0x92,0x24,0x09};

#define grid1_width 32
#define grid1_height 32
static unsigned char grid1_bits[] = {
0x00,0x00,0x00,0x00,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0xfe,0xff,0xff,0x3f,0x20,0x22,0x22,0x02,
0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,0x20,0x22,0x22,0x02,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define grid2_width 32
#define grid2_height 32
static unsigned char	grid2_bits[] = {
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0xff,0xff,0xff,0xff,0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10,0xff,0xff,0xff,0xff,
0x08,0x21,0x84,0x10,0x08,0x21,0x84,0x10};

#define grid3_width 32
#define grid3_height 32
static unsigned char	grid3_bits[] = {
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0xff,0xff,0xff,0xff,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02,
0x20,0x80,0x00,0x02,0x20,0x80,0x00,0x02};

#define grid4_width 32
#define grid4_height 32
static unsigned char	grid4_bits[] = {
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0xff,0xff,0xff,0xff,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0xff,0xff,0xff,0xff,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04,
0x40,0x00,0x00,0x04,0x40,0x00,0x00,0x04};

#define unconstrained_width 32
#define unconstrained_height 32
static unsigned char unconstrained_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xa0,0xfa,0x01,0x00,0x08,0xf4,0x01,0x00,0x02,
0xe0,0x01,0x00,0x00,0xc4,0x02,0x80,0x00,0x00,0x06,0x00,
0x00,0x02,0x08,0x20,0x00,0x00,0x0c,0x00,0x00,0x02,0x16,
0x10,0x00,0x80,0x13,0x00,0x00,0xe2,0x10,0x08,0x00,0x70,
0x20,0x00,0x00,0x19,0xf8,0x08,0x00,0x0e,0x70,0x00,0x00,
0x03,0x70,0x08,0x00,0x14,0x70,0x00,0x00,0x42,0x20,0x08,
0x00,0x00,0x21,0x00,0x00,0x08,0x04,0x10,0x00,0x00,0x10,
0x00,0x00,0x10,0x00,0x20,0x00,0x00,0x08,0x00,0x00,0x20,
0x00,0x80,0x00,0x00,0x02,0x00,0x00,0x40,0x00,0x00,0x02,
0x80,0x00,0x00,0x08,0x20,0x00,0x00,0xa0,0x0a,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexline_width 32
#define latexline_height 32
static unsigned char latexline_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0e,
0x00,0x00,0xf8,0x01,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x00,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x00,0x00,0x10,0x01,0x01,0x00,0x10,0x01,0x06,0x00,
0x08,0x01,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define latexarrow_width 32
#define latexarrow_height 32
static unsigned char latexarrow_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x3c,0x00,0x00,0x00,0x1f,
0x00,0x00,0xf8,0x0c,0x00,0x00,0x0f,0x00,0x00,0x80,0xf7,
0x03,0x00,0x80,0x09,0xfc,0x06,0x40,0x31,0x00,0x0f,0x20,
0xc1,0x02,0x1f,0x98,0x03,0x03,0x00,0xb8,0x03,0x07,0x00,
0x18,0x01,0x0f,0x00,0x08,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x18,0xf0,0x83,0x61,0x18,0xf3,0x03,0x33,0x98,
0xc4,0x00,0x33,0x98,0xc4,0x00,0x1e,0x98,0xc7,0x3e,0x0c,
0x98,0xc4,0x06,0x0c,0x98,0xc4,0x06,0x1e,0x18,0xc0,0x06,
0x33,0xf8,0xc1,0x1e,0x33,0xf8,0xc1,0x86,0x61,0x00,0x00,
0x06,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x3e,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define mounthattan_width 32
#define mounthattan_height 32
static unsigned char mounthattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x01,0x00,0x00,
0x98,0x01,0x00,0x00,0x98,0x01,0x02,0x00,0x98,0x01,0x07,
0x00,0x98,0x81,0x0d,0x00,0x9c,0xc3,0x18,0x80,0x9c,0x63,
0x30,0xc0,0x0d,0x33,0x20,0x60,0x0f,0x1b,0x00,0x30,0x0e,
0x0f,0x00,0x18,0x0c,0x07,0x00,0x0c,0x0c,0x03,0x00,0x04,
0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x1f,0x00,
0x00,0x0c,0x1f,0x00,0x00,0x0c,0x00,0x00,0x00,0x0c,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define manhattan_width 32
#define manhattan_height 32
static unsigned char manhattan_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,
0xf8,0x01,0x00,0x00,0x98,0x01,0x00,0x00,0x98,0x01,0x00,
0x00,0x98,0x01,0x00,0x00,0x9c,0x03,0x00,0x00,0x9c,0x03,
0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,0x03,0x00,0x00,0x0c,
0x03,0x00,0x7c,0x0c,0xf3,0x01,0x7c,0x0c,0xf3,0x01,0x60,
0x0c,0xb3,0x01,0x60,0x0c,0xbf,0x01,0x60,0x0c,0xbf,0x01,
0xe0,0x0f,0x80,0x01,0xe0,0x0f,0x80,0x01,0x00,0x00,0x80,
0x3f,0x00,0x00,0x80,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define mountain_width 32
#define mountain_height 32
static unsigned char mountain_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,
0x00,0x00,0x00,0x70,0x00,0x00,0x00,0xd8,0x00,0x00,0x00,
0x8c,0x01,0x00,0x00,0x04,0x03,0x00,0x00,0x00,0x06,0x00,
0x00,0x00,0x0c,0x00,0x04,0x00,0x18,0x00,0x0e,0x00,0x30,
0x00,0x1b,0x00,0x60,0x80,0x31,0x00,0xc0,0xc0,0x20,0x00,
0x80,0x61,0x00,0x00,0x00,0x33,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0x0c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignl_width 32
#define halignl_height 32
static unsigned char halignl_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x68,0x00,
0x00,0x00,0x88,0x01,0x00,0x00,0x08,0x06,0x00,0x00,0x88,
0x01,0x00,0x00,0x68,0x00,0x00,0x00,0x18,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,
0x00,0x08,0x00,0x80,0x00,0x08,0x00,0x80,0x00,0x08,0x00,
0x80,0x00,0xf8,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignr_width 32
#define halignr_height 32
static unsigned char halignr_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfe,0x1f,0x00,0x00,0x02,0x10,0x00,0x00,
0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,
0x00,0x02,0x10,0x00,0x00,0x02,0x10,0x00,0x00,0x02,0x10,
0x00,0x00,0x02,0x10,0x00,0x00,0xfe,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,
0x00,0x16,0x00,0x00,0x80,0x11,0x00,0x00,0x60,0x10,0x00,
0x00,0x80,0x11,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x18,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x00,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignc_width 32
#define halignc_height 32
static unsigned char halignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x04,0x20,0x00,0x00,0x04,
0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,
0x04,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0x20,0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x80,
0x02,0x00,0x00,0x80,0x02,0x00,0x00,0x40,0x04,0x00,0x00,
0x40,0x04,0x00,0x00,0x20,0x08,0x00,0x00,0xe0,0x0f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,
0x07,0x20,0x00,0x00,0x04,0x20,0x00,0x00,0x04,0x20,0x00,
0x00,0x04,0xe0,0xff,0xff,0x07,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligndc_width 32
#define haligndc_height 32
static unsigned char haligndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,
0x00,0x00,0x08,0x10,0x00,0x00,0x88,0x11,0x00,0x00,0x88,
0x11,0x00,0x00,0x08,0x10,0x00,0x00,0x08,0x10,0x00,0x00,
0x08,0x10,0x00,0x00,0xf8,0x1f,0x00,0x1f,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x01,0x11,0x00,0x80,
0x02,0x11,0x00,0x40,0x04,0x11,0x00,0x20,0x09,0x11,0x00,
0x10,0x10,0x15,0x00,0xf8,0x3f,0x15,0x00,0x00,0x00,0x15,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define halignde_width 32
#define halignde_height 32
static unsigned char halignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x1f,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,
0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,
0x18,0x00,0x00,0x18,0x18,0x00,0x00,0x18,0x18,0x00,0x00,
0x18,0x18,0x00,0x00,0xf8,0x1f,0x02,0x1f,0x00,0x00,0x02,
0x1b,0x00,0x00,0x07,0x1b,0x00,0x00,0x05,0x1b,0x00,0x80,
0x0d,0x1b,0x00,0x80,0x08,0x1b,0x00,0xc0,0x18,0x1b,0x00,
0xc0,0x18,0x1b,0x00,0xc0,0x1f,0x1b,0x00,0x00,0x00,0x1b,
0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,
0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,0x00,0x1b,0x00,0x00,
0x00,0x1b,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define haligna_width 32
#define haligna_height 32
static unsigned char haligna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x0a,0x00,
0x00,0x00,0x0a,0x00,0xf8,0x1f,0x11,0x1f,0x08,0x10,0x11,
0x11,0x08,0x90,0x20,0x11,0x08,0x90,0x20,0x11,0x08,0x50,
0x40,0x11,0x08,0x50,0x40,0x11,0x08,0x30,0x80,0x11,0x08,
0xf0,0xff,0x11,0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignt_width 32
#define valignt_height 32
static unsigned char valignt_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x9f,0x3f,0x1f,0x08,0x90,0x20,0x11,0x08,0x10,
0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x0a,0x11,0x08,
0x10,0x0a,0x11,0x08,0x10,0x04,0x11,0x08,0x10,0x04,0x11,
0x08,0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignb_width 32
#define valignb_height 32
static unsigned char valignb_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,
0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0xf8,
0x1f,0x00,0x11,0x08,0x10,0x00,0x11,0x08,0x10,0x00,0x11,
0x08,0x10,0x04,0x11,0x08,0x10,0x0a,0x11,0x08,0x10,0x0a,
0x11,0x08,0x10,0x11,0x11,0x08,0x10,0x11,0x11,0x08,0x90,
0x20,0x11,0xf8,0x9f,0x3f,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignc_width 32
#define valignc_height 32
static unsigned char valignc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,
0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,
0xf8,0x1f,0x00,0x11,0x08,0x10,0x30,0x11,0x08,0x10,0x2c,
0x11,0x08,0x10,0x23,0x11,0x08,0x90,0x20,0x11,0x08,0x10,
0x23,0x11,0x08,0x10,0x2c,0x11,0x08,0x10,0x30,0x11,0x08,
0x10,0x00,0x11,0xf8,0x1f,0x00,0x11,0x00,0x00,0x00,0x11,
0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x11,0x00,0x00,0x00,
0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigndc_width 32
#define valigndc_height 32
static unsigned char valigndc_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x43,0x00,0x00,0x08,
0x43,0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,
0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x80,
0x08,0x00,0x00,0x40,0x12,0x00,0x00,0x20,0x20,0x00,0x00,
0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0x01,0x00,0x10,0x00,0x01,0x0e,0x10,0x00,0x01,
0x00,0x10,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valignde_width 32
#define valignde_height 32
static unsigned char valignde_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x7f,0x00,0x00,0xf8,0x7f,0x00,0x00,0x08,0x40,
0x00,0x00,0x08,0x40,0x00,0x00,0x08,0x40,0x00,0x00,0x08,
0x40,0x00,0x00,0x08,0x40,0x00,0x00,0xf8,0x7f,0x00,0x00,
0xf8,0x7f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
0x07,0x00,0x00,0x80,0x08,0x00,0x00,0x40,0x10,0x00,0x00,
0xe0,0x3f,0x00,0x00,0xf0,0x7f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,
0x1f,0x00,0xff,0xff,0x1f,0x00,0x01,0x00,0x10,0x00,0xff,
0xff,0x1f,0x00,0xff,0xff,0x1f,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define valigna_width 32
#define valigna_height 32
static unsigned char valigna_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xc0,0xff,0x03,0x00,0x40,0x00,0x02,0x00,0x40,0x00,
0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,
0x00,0x02,0x00,0x40,0x00,0x02,0x00,0x40,0x00,0x02,0x00,
0x40,0x00,0x02,0x00,0xc0,0xff,0x03,0x00,0x00,0x02,0x00,
0x00,0x00,0x02,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x05,
0x00,0x00,0x80,0x08,0x00,0x00,0x80,0x08,0x00,0x00,0x40,
0x10,0x00,0x00,0x40,0x10,0x00,0x00,0xe0,0x3f,0x00,0x00,
0x00,0xfe,0xff,0x3f,0x00,0x02,0x00,0x20,0x00,0x02,0x00,
0x20,0x00,0x02,0x00,0x20,0x00,0xfe,0xff,0x3f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define any_width 32
#define any_height 32
static unsigned char any_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x08,0x21,0x12,0x11,0x88,0x22,0x12,0x11,0x48,0x64,0xa2,
0x10,0x48,0x64,0xa2,0x10,0x48,0xa4,0x42,0x10,0xc8,0xa7,
0x42,0x10,0x48,0x24,0x43,0x10,0x48,0x24,0x43,0x10,0x48,
0x24,0x42,0x10,0x48,0x24,0x42,0x10,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define none_width 32
#define none_height 32
static unsigned char none_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0xff,0x1f,0x08,0x00,
0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,
0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,
0x28,0x32,0xd1,0x17,0x28,0x4a,0x51,0x10,0x68,0x4a,0x53,
0x10,0x68,0x4a,0x53,0x10,0xa8,0x4a,0xd5,0x11,0xa8,0x4a,
0x55,0x10,0x28,0x4b,0x59,0x10,0x28,0x4b,0x59,0x10,0x28,
0x4a,0x51,0x10,0x28,0x32,0xd1,0x17,0x08,0x00,0x00,0x10,
0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,
0x10,0x08,0x00,0x00,0x10,0x08,0x00,0x00,0x10,0xf8,0xff,
0xff,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fill_width 32
#define fill_height 32
static unsigned char fill_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,
0x03,0x00,0x00,0xac,0x06,0x00,0x00,0x54,0x0d,0x00,0x00,
0xae,0x1a,0x00,0x00,0x56,0x35,0x00,0x00,0xab,0x6a,0x00,
0x00,0x55,0xd5,0x00,0x00,0xab,0xaa,0x01,0x00,0x55,0x55,
0x01,0x00,0xab,0xaa,0x01,0x80,0x55,0x55,0x01,0x80,0xaa,
0xaa,0x01,0x80,0x55,0x55,0x03,0x80,0xaa,0xaa,0x02,0x80,
0x55,0x55,0x03,0x00,0xab,0xaa,0x02,0x00,0x5e,0x55,0x03,
0x00,0xb0,0xaa,0x02,0x00,0x60,0x55,0x03,0x00,0xc0,0xaa,
0x02,0x00,0x40,0x55,0x01,0x00,0x80,0xff,0x01,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define blank_width 32
#define blank_height 32
static unsigned char blank_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textL_width 32
#define textL_height 32
static unsigned char	textL_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x01,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0xff,0x3f,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xf8,0xff,0x01,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0xf8,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textC_width 32
#define textC_height 32
static unsigned char	textC_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,
0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xff,0xff,0x07,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xfc,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define textR_width 32
#define textR_height 32
static unsigned char	textR_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x80,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0x1f,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf8,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0xff,0x1f,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xfc,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define noarrows_width 32
#define noarrows_height 32
static unsigned char noarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,};

#define farrows_width 32
#define farrows_height 32
static unsigned char farrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x80,
0x03,0x00,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0x00,0x00,
0x80,0x0f,0x00,0x00,0x80,0x03,0x00,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define barrows_width 32
#define barrows_height 32
static unsigned char barrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0xe0,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x00,0x00,0xe0,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define fbarrows_width 32
#define fbarrows_height 32
static unsigned char fbarrows_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x80,0x00,0x80,0x00,0xe0,0x00,0x80,
0x03,0xf8,0x00,0x80,0x0f,0xfc,0xff,0xff,0x1f,0xf8,0x00,
0x80,0x0f,0xe0,0x00,0x80,0x03,0x80,0x00,0x80,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00};

/* create the data structures for them */

icon_struct	regpoly_ic = { regpoly_width, regpoly_height, 
				(char*)regpoly_bits };
icon_struct	addpt_ic = { addpt_width, addpt_height, 
				(char*)addpt_bits };
icon_struct	align_ic = { align_width, align_height, 
				(char*)align_bits };
icon_struct	arc_ic = { arc_width, arc_height, 
				(char*)arc_bits };
icon_struct	open_arc_ic = { open_arc_width, open_arc_height, 
				(char*)open_arc_bits };
icon_struct	pie_wedge_arc_ic = { pie_wedge_arc_width, pie_wedge_arc_height,
				     (char*)pie_wedge_arc_bits };
icon_struct	autoarrow_ic = { autoarrow_width, autoarrow_height, 
				 (char*)autoarrow_bits };
icon_struct	box_ic = { box_width, box_height, 
				(char*)box_bits };
icon_struct	arc_box_ic = { arc_box_width, arc_box_height, 
				(char*)arc_box_bits };
icon_struct	cirrad_ic = { cirrad_width, cirrad_height,
				(char*)cirrad_bits };
icon_struct	cirdia_ic = { cirdia_width, cirdia_height,
				(char*)cirdia_bits };
icon_struct	c_spl_ic = { c_spl_width, c_spl_height,
				(char*)c_spl_bits };
icon_struct	c_xspl_ic = { c_xspl_width, c_xspl_height,
				(char*)c_xspl_bits };
icon_struct	xspl_ic = { xspl_width, xspl_height,
				(char*)xspl_bits };
icon_struct	intspl_ic = { intspl_width, intspl_height,
				(char*)intspl_bits };
icon_struct	c_intspl_ic = { c_intspl_width, c_intspl_height,
				(char*)c_intspl_bits };
icon_struct	copy_ic = { copy_width, copy_height,
				(char*)copy_bits };
icon_struct	glue_ic = { glue_width, glue_height,
				(char*)glue_bits };
icon_struct	break_ic = { break_width, break_height,
				(char*)break_bits };
icon_struct	open_comp_ic = { open_comp_width, open_comp_height, 
				 (char*)open_comp_bits };
icon_struct	join_split_ic = { join_split_width, join_split_height, 
				 (char*)join_split_bits };
icon_struct	deletept_ic = { deletept_width, deletept_height, 
				(char*)deletept_bits };
icon_struct	ellrad_ic = { ellrad_width, ellrad_height,
				(char*)ellrad_bits };
icon_struct	elldia_ic = { elldia_width, elldia_height,
				(char*)elldia_bits };
icon_struct	flip_x_ic = { flip_x_width, flip_x_height,
				(char*)flip_x_bits };
icon_struct	flip_y_ic = { flip_y_width, flip_y_height,
				(char*)flip_y_bits };
icon_struct	line_ic = { line_width, line_height,
				(char*)line_bits };
icon_struct	library_ic = {library_width, library_height,
				    (char*)library_bits };
icon_struct	move_ic = { move_width, move_height,
				(char*)move_bits };
icon_struct	movept_ic = { movept_width, movept_height,
				(char*)movept_bits };
icon_struct	polygon_ic = { polygon_width, polygon_height,
				(char*)polygon_bits };
icon_struct	delete_ic = { delete_width, delete_height,
				(char*)delete_bits };
icon_struct	rotCCW_ic = { rotCCW_width, rotCCW_height,
				(char*)rotCCW_bits };
icon_struct	scale_ic = { scale_width, scale_height,
				(char*)scale_bits };
icon_struct	convert_ic = { convert_width, convert_height,
				(char*)convert_bits };
icon_struct	spl_ic = { spl_width, spl_height,
				(char*)spl_bits };
icon_struct	text_ic = { text_width, text_height,
				(char*)text_bits };
icon_struct	picobj_ic = { picobj_width, picobj_height,
				(char*)picobj_bits };
icon_struct	rotCW_ic = { rotCW_width, rotCW_height,
				(char*)rotCW_bits };
icon_struct	update_ic = { update_width, update_height,
				(char*)update_bits };
icon_struct	edit_ic = { edit_width, edit_height,
				(char*)edit_bits };
icon_struct	smartoff_ic = { smartoff_width, smartoff_height, 
				(char*)smartoff_bits };
icon_struct	smartmove_ic = { smartmove_width, smartmove_height, 
				 (char*)smartmove_bits };
icon_struct	smartslide_ic = { smartslide_width, smartslide_height, 
				  (char*)smartslide_bits };
icon_struct	joinmiter_ic = { joinmiter_width, joinmiter_height, 
				 (char*)joinmiter_bits };
icon_struct	joinround_ic = { joinround_width, joinround_height, 
				 (char*)joinround_bits };
icon_struct	joinbevel_ic = { joinbevel_width, joinbevel_height, 
				 (char*)joinbevel_bits };
icon_struct	capbutt_ic = { capbutt_width, capbutt_height,
				(char*)capbutt_bits };
icon_struct	capround_ic = { capround_width, capround_height, 
				(char*)capround_bits };
icon_struct	capproject_ic = { capproject_width, capproject_height, 
				  (char*)capproject_bits };
icon_struct	solidline_ic = { solidline_width, solidline_height, 
				 (char*)solidline_bits };
icon_struct	dashline_ic = { dashline_width, dashline_height, 
				(char*)dashline_bits };
icon_struct	dottedline_ic = { dottedline_width, dottedline_height, 
				  (char*)dottedline_bits };
icon_struct	dashdotline_ic = { dashdotline_width, dashdotline_height, 
				  (char*)dashdotline_bits };
icon_struct	dash2dotsline_ic = { dash2dotsline_width, dash2dotsline_height, 
				  (char*)dash2dotsline_bits };
icon_struct	dash3dotsline_ic = { dash3dotsline_width, dash3dotsline_height, 
				  (char*)dash3dotsline_bits };
icon_struct	grid1_ic = { grid1_width, grid1_height,
				(char*)grid1_bits };
icon_struct	grid2_ic = { grid2_width, grid2_height,
				(char*)grid2_bits };
icon_struct	grid3_ic = { grid3_width, grid3_height,
				(char*)grid3_bits };
icon_struct	grid4_ic = { grid4_width, grid4_height,
				(char*)grid4_bits };
icon_struct	fine_grid_ic = { fine_grid_width, fine_grid_height, 
				 (char*)fine_grid_bits };
icon_struct	unconstrained_ic = { unconstrained_width, unconstrained_height,
				     (char*)unconstrained_bits };
icon_struct	latexline_ic = { latexline_width, latexline_height, 
				 (char*)latexline_bits };
icon_struct	latexarrow_ic = { latexarrow_width, latexarrow_height, 
				  (char*)latexarrow_bits };
icon_struct	mounthattan_ic = { mounthattan_width, mounthattan_height, 
				   (char*)mounthattan_bits };
icon_struct	manhattan_ic = { manhattan_width, manhattan_height, 
				 (char*)manhattan_bits };
icon_struct	mountain_ic = { mountain_width, mountain_height,
				(char*)mountain_bits };
icon_struct	halignl_ic = { halignl_width, halignl_height, 
			       (char*)halignl_bits };
icon_struct	halignr_ic = { halignr_width, halignr_height, 
			       (char*)halignr_bits };
icon_struct	halignc_ic = { halignc_width, halignc_height, 
			       (char*)halignc_bits };
icon_struct	haligndc_ic = { haligndc_width, haligndc_height, 
				(char*)haligndc_bits };
icon_struct	halignde_ic = { halignde_width, halignde_height, 
				(char*)halignde_bits };
icon_struct	haligna_ic = { haligna_width, haligna_height, 
			       (char*)haligna_bits };
icon_struct	valignt_ic = { valignt_width, valignt_height, 
			       (char*)valignt_bits };
icon_struct	valignb_ic = { valignb_width, valignb_height, 
			       (char*)valignb_bits };
icon_struct	valignc_ic = { valignc_width, valignc_height, 
			       (char*)valignc_bits };
icon_struct	valigndc_ic = { valigndc_width, valigndc_height, 
				(char*)valigndc_bits };
icon_struct	valignde_ic = { valignde_width, valignde_height, 
				(char*)valignde_bits };
icon_struct	valigna_ic = { valigna_width, valigna_height, 
			       (char*)valigna_bits };
icon_struct	any_ic = { any_width, any_height,
				(char*)any_bits };
icon_struct	none_ic = { none_width, none_height,
				(char*)none_bits };
icon_struct	fill_ic = { fill_width, fill_height,
				(char*)fill_bits };
icon_struct	blank_ic = { blank_width, blank_height,
				(char*)blank_bits };
icon_struct	textL_ic = { textL_width, textL_height,
				(char*)textL_bits };
icon_struct	textC_ic = { textC_width, textC_height,
				(char*)textC_bits };
icon_struct	textR_ic = { textR_width, textR_height,
				(char*)textR_bits };
icon_struct	noarrows_ic = { noarrows_width, noarrows_height, 
				(char*)noarrows_bits };
icon_struct	farrows_ic = { farrows_width, farrows_height, 
			       (char*)farrows_bits };
icon_struct	barrows_ic = { barrows_width, barrows_height, 
			       (char*)barrows_bits };
icon_struct	fbarrows_ic = { fbarrows_width, fbarrows_height, 
				(char*)fbarrows_bits };

/*************** misc icons *************/

#define printer_width 54
#define printer_height 28
static unsigned char printer_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0xe0,0xff,0xff,0xff,0xff,0xff,0x0f,0x20,
0x00,0x00,0x00,0x00,0x00,0x08,0x20,0x00,0x00,0x00,0x00,
0x00,0x08,0x20,0x00,0x00,0x00,0x00,0x00,0x08,0xe0,0xff,
0xff,0xff,0xff,0xff,0x0f,0xa0,0x00,0x00,0x00,0x00,0x00,
0x08,0xa0,0x00,0x00,0xf8,0x03,0x00,0x08,0xa0,0x00,0x00,
0x08,0x02,0x00,0x08,0xa0,0x00,0x00,0xa8,0x02,0x00,0x04,
0xa0,0x00,0x00,0xf8,0x03,0x00,0x02,0xa0,0x00,0x00,0x00,
0x00,0x00,0x01,0xe0,0xff,0xff,0xff,0xff,0xff,0x00,0x80,
0x00,0x00,0x00,0x00,0x80,0x00,0xfc,0xf8,0xff,0xff,0xff,
0x9f,0x00,0x84,0x00,0x00,0x00,0x00,0x80,0x00,0x84,0xf8,
0xff,0xff,0xff,0x9f,0x00,0xfc,0x00,0x00,0x00,0x00,0x80,
0x00,0xe0,0xf8,0xff,0xff,0xff,0x9f,0x00,0xc0,0x00,0x00,
0x00,0x00,0x80,0x00,0x80,0xf8,0xff,0xff,0xff,0x9f,0x00,
0x00,0x01,0x00,0x00,0x00,0x80,0x00,0x00,0xfe,0xff,0xff,
0xff,0xff,0x00,0x00,0x7c,0x00,0x00,0x00,0x7c,0x00,0x00,
0x38,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};

#define kbd_width 56
#define kbd_height 19
static unsigned char kbd_bits[] = {
0xef,0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x29,0xa5,0x94,0x52,
0x4a,0x29,0x85,0x29,0xa5,0x94,0x52,0x4a,0x29,0x85,0xef,
0xbd,0xf7,0xde,0x7b,0xef,0xfd,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0xf7,0xa4,0x94,
0x52,0x4a,0x29,0xa5,0x94,0xa4,0x94,0x52,0x4a,0x29,0xa5,
0x94,0xbc,0xf7,0xde,0x7b,0xef,0xbd,0x97,0x00,0x00,0x00,
0x00,0x00,0x00,0x90,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0x9e,
0x90,0x52,0x4a,0x29,0xa5,0x94,0x82,0x90,0x52,0x4a,0x29,
0xa5,0x94,0x82,0xf0,0xde,0x7b,0xef,0xbd,0xf7,0xfe,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0xe0,0xef,0xbd,0xf7,0xde,
0x7b,0x7f,0x20,0x28,0xa5,0x94,0x52,0x4a,0x41,0x20,0x28,
0xa5,0x94,0x52,0x4a,0x41,0xe0,0xef,0xbd,0xf7,0xde,0x7b,
0x7f};

/* arrowhead bitmaps */

#define arrow0_width 32
#define arrow0_height 32
unsigned char	arrow0_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xe0,0x01,0x00,0x00,0x00,0x1e,0x00,
0x00,0x00,0xe0,0x01,0xf0,0xff,0xff,0x0f,0x00,0x00,0xc0,0x03,
0x00,0x00,0x3c,0x00,0x00,0xc0,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1o_width 32
#define arrow1o_height 32
unsigned char	arrow1o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x38,0x00,0x00,0x00,0xe8,0x03,0x00,0x00,0x08,0x3e,0x00,
0x00,0x08,0xe0,0x03,0xf8,0x0f,0x00,0x0f,0x00,0x08,0xf8,0x01,
0x00,0x08,0x1f,0x00,0x00,0xf8,0x01,0x00,0x00,0x18,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow1f_width 32
#define arrow1f_height 32
unsigned char	arrow1f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x18,0x00,0x00,0x00,0xf8,0x01,0x00,0x00,0xf8,0x1f,0x00,
0x00,0xf8,0xff,0x01,0xf8,0xff,0xff,0x0f,0x00,0xf8,0xff,0x03,
0x00,0xf8,0x3f,0x00,0x00,0xf8,0x03,0x00,0x00,0x38,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2o_width 32
#define arrow2o_height 32
unsigned char	arrow2o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0x10,0x0f,0x00,0x00,0x20,0x70,0x00,
0x00,0x40,0x80,0x07,0xfc,0xff,0x00,0x1c,0x00,0x40,0x00,0x06,
0x00,0x20,0xe0,0x01,0x00,0x10,0x1e,0x00,0x00,0xe8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow2f_width 32
#define arrow2f_height 32
unsigned char	arrow2f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x00,0x00,
0x00,0xf8,0x00,0x00,0x00,0xf0,0x0f,0x00,0x00,0xe0,0x7f,0x00,
0x00,0xc0,0xff,0x07,0xfc,0xff,0xff,0x1f,0x00,0xc0,0xff,0x07,
0x00,0xe0,0xff,0x01,0x00,0xf0,0x1f,0x00,0x00,0xf8,0x01,0x00,
0x00,0x1c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3o_width 32
#define arrow3o_height 32
unsigned char	arrow3o_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0x40,0x0e,0x00,0x00,0x40,0xf0,0x00,
0x00,0x20,0x00,0x07,0xf8,0x1f,0x00,0x18,0x00,0x20,0x00,0x07,
0x00,0x40,0xf0,0x00,0x00,0x40,0x0e,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow3f_width 32
#define arrow3f_height 32
unsigned char	arrow3f_bits[] = {
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x80,0x01,0x00,0x00,0xc0,0x0f,0x00,0x00,0xc0,0xff,0x00,
0x00,0xe0,0xff,0x07,0xf8,0xff,0xff,0x1f,0x00,0xe0,0xff,0x07,
0x00,0xc0,0xff,0x00,0x00,0xc0,0x0f,0x00,0x00,0x80,0x01,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};
#define arrow4o_width 32
#define arrow4o_height 32
unsigned char	arrow4o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x80, 0x83, 0x03,
0x00, 0x60, 0x00, 0x0c, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x60, 0x00, 0x0c,
0x00, 0x80, 0x83, 0x03, 0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow4f_width 32
#define arrow4f_height 32
unsigned char	arrow4f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x80, 0xff, 0x03,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5o_width 32
#define arrow5o_height 32
unsigned char	arrow5o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x6c, 0x00, 0x00, 0x00, 0x83, 0x01, 0x00, 0x80, 0x00, 0x02,
0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0xf8, 0x1f, 0x00, 0x10, 0x00, 0x20, 0x00, 0x08,
0x00, 0x20, 0x00, 0x08, 0x00, 0x40, 0x00, 0x04, 0x00, 0x40, 0x00, 0x04,
0x00, 0x80, 0x00, 0x02, 0x00, 0x00, 0x83, 0x01, 0x00, 0x00, 0x6c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow5f_width 32
#define arrow5f_height 32
unsigned char	arrow5f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00,
0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0xff, 0x01, 0x00, 0x80, 0xff, 0x03,
0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0xf8, 0xff, 0xff, 0x1f, 0x00, 0xe0, 0xff, 0x0f,
0x00, 0xe0, 0xff, 0x0f, 0x00, 0xc0, 0xff, 0x07, 0x00, 0xc0, 0xff, 0x07,
0x00, 0x80, 0xff, 0x03, 0x00, 0x00, 0xff, 0x01, 0x00, 0x00, 0x7c, 0x00,
0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, };

#define arrow6o_width 32
#define arrow6o_height 32
unsigned char arrow6o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x07, 0x00,
0x00, 0x80, 0x01, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0xc0, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0xc0, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00,
0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow6f_width 32
#define arrow6f_height 32
unsigned char arrow6f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x3f, 0x00,
0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0xc0, 0x3f, 0x00,
0x00, 0xc0, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00, 0x00, 0x80, 0x3f, 0x00,
0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow7o_width 32
#define arrow7o_height 32
unsigned char arrow7o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0xf8, 0x7f, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00,
0x00, 0x40, 0x40, 0x00, 0x00, 0x40, 0x40, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define arrow7f_width 32
#define arrow7f_height 32
unsigned char arrow7f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8o_width 32
#define arrow8o_height 32
unsigned char arrow8o_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x43, 0x00,
0x00, 0xc0, 0x40, 0x00, 0xf8, 0x3f, 0x40, 0x00, 0x00, 0xc0, 0x40, 0x00,
0x00, 0x00, 0x43, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow8f_width 32
#define arrow8f_height 32
unsigned char arrow8f_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40, 0x00,
0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x7f, 0x00,
0x00, 0xc0, 0x7f, 0x00, 0xf8, 0xff, 0x7f, 0x00, 0x00, 0xc0, 0x7f, 0x00,
0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x70, 0x00,
0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9a_width 32
#define arrow9a_height 32
unsigned char arrow9a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x08, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x01, 0x00,
0x00, 0x80, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x80, 0x00, 0x00,
0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x04, 0x00,
0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x10, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow9b_width 32
#define arrow9b_height 32
unsigned char arrow9b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow10a_width 32
#define arrow10a_height 32
unsigned char arrow10a_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0xf8, 0x7f, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00,
0x00, 0x40, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
#define arrow10b_width 32
#define arrow10b_height 32
unsigned char arrow10b_bits[] = {
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0xf8, 0xff, 0x3f, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00, 0x00, 0x00, 0x20, 0x00,
0x00, 0x00, 0x20, 0x00, 0x00, 0xc0, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

icon_struct	arrow0_ic = { arrow0_width, arrow0_height, 
			      (char*)arrow0_bits };
icon_struct	arrow1o_ic = { arrow1o_width, arrow1o_height, 
			      (char*)arrow1o_bits };
icon_struct	arrow1f_ic = { arrow1f_width, arrow1f_height, 
			      (char*)arrow1f_bits };
icon_struct	arrow2o_ic = { arrow2o_width, arrow2o_height, 
			      (char*)arrow2o_bits };
icon_struct	arrow2f_ic = { arrow2f_width, arrow2f_height, 
			      (char*)arrow2f_bits };
icon_struct	arrow3o_ic = { arrow3o_width, arrow3o_height, 
			      (char*)arrow3o_bits };
icon_struct	arrow3f_ic = { arrow3f_width, arrow3f_height, 
			      (char*)arrow3f_bits };
icon_struct	arrow4o_ic = { arrow4o_width, arrow4o_height, 
			      (char*)arrow4o_bits };
icon_struct	arrow4f_ic = { arrow4f_width, arrow4f_height, 
			      (char*)arrow4f_bits };
icon_struct	arrow5o_ic = { arrow5o_width, arrow5o_height, 
			      (char*)arrow5o_bits };
icon_struct	arrow5f_ic = { arrow5f_width, arrow5f_height, 
			      (char*)arrow5f_bits };
icon_struct	arrow6o_ic = { arrow6o_width, arrow6o_height, 
			      (char*)arrow6o_bits };
icon_struct	arrow6f_ic = { arrow6f_width, arrow6f_height, 
			      (char*)arrow6f_bits };
icon_struct	arrow7o_ic = { arrow7o_width, arrow7o_height, 
			      (char*)arrow7o_bits };
icon_struct	arrow7f_ic = { arrow7f_width, arrow7f_height, 
			      (char*)arrow7f_bits };
icon_struct	arrow8o_ic = { arrow8o_width, arrow8o_height, 
			      (char*)arrow8o_bits };
icon_struct	arrow8f_ic = { arrow8f_width, arrow8f_height, 
			      (char*)arrow8f_bits };
icon_struct	arrow9a_ic = { arrow9a_width, arrow9a_height, 
			      (char*)arrow9a_bits };
icon_struct	arrow9b_ic = { arrow9b_width, arrow9b_height, 
			      (char*)arrow9b_bits };
icon_struct	arrow10a_ic = { arrow10a_width, arrow10a_height, 
			      (char*)arrow10a_bits };
icon_struct	arrow10b_ic = { arrow10b_width, arrow10b_height, 
			      (char*)arrow10b_bits };

icon_struct	printer_ic = { printer_width, printer_height, 
			       (char*)printer_bits };
icon_struct	kbd_ic = { kbd_width, kbd_height,
				(char*)kbd_bits };

/* The following XBM image is used for the icon on a monochrome display */

#define fig_width 64
#define fig_height 64
static unsigned char fig_bits[] = {
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x01, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x80, 0xe1, 0x4f, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80,
   0x41, 0x48, 0x00, 0x00, 0x00, 0x60, 0x03, 0x80, 0x41, 0x08, 0x60, 0x00,
   0x00, 0x10, 0x04, 0x80, 0x41, 0x62, 0x1c, 0x00, 0x00, 0x18, 0x08, 0x80,
   0xc1, 0x43, 0x22, 0x00, 0x00, 0x04, 0x08, 0x80, 0x41, 0x42, 0x22, 0x00,
   0x00, 0x04, 0x10, 0x80, 0x41, 0x40, 0x1c, 0x00, 0x00, 0x03, 0x10, 0x80,
   0x41, 0x40, 0x04, 0x00, 0x00, 0x01, 0x10, 0x80, 0xe1, 0xe0, 0x3c, 0x00,
   0x80, 0x00, 0x10, 0x80, 0x01, 0x00, 0x42, 0x00, 0x80, 0x00, 0x08, 0x83,
   0x01, 0x00, 0x42, 0x00, 0x40, 0x00, 0x88, 0x8c, 0x61, 0x00, 0x3c, 0x00,
   0x40, 0x00, 0x48, 0xf0, 0x81, 0x07, 0x00, 0x00, 0x40, 0x40, 0x38, 0xc0,
   0x01, 0x78, 0x00, 0x00, 0x38, 0x20, 0x00, 0x80, 0x01, 0x80, 0x07, 0xfc,
   0x47, 0x20, 0x00, 0x80, 0xe1, 0x00, 0xf8, 0x03, 0x40, 0x10, 0x00, 0x81,
   0x01, 0x0f, 0x00, 0x00, 0x0e, 0x0c, 0xd0, 0x80, 0x01, 0xf0, 0xe0, 0xe0,
   0x87, 0x00, 0x06, 0x80, 0x01, 0x00, 0xbf, 0xff, 0x40, 0xf1, 0x00, 0x80,
   0x01, 0x00, 0x90, 0x38, 0xa0, 0x06, 0x00, 0x80, 0x01, 0x00, 0x58, 0x08,
   0x80, 0x08, 0x00, 0x80, 0x01, 0x00, 0x48, 0x08, 0x18, 0x11, 0x00, 0x80,
   0x01, 0x00, 0x4c, 0x08, 0x04, 0x21, 0xe0, 0x83, 0x01, 0x00, 0x22, 0x04,
   0x03, 0x41, 0x10, 0x82, 0x01, 0x00, 0x21, 0x02, 0x00, 0x01, 0x10, 0x84,
   0x01, 0x00, 0x11, 0x01, 0x00, 0x81, 0xe1, 0xe4, 0x01, 0x80, 0x90, 0x00,
   0x1c, 0x00, 0x01, 0x99, 0x01, 0x80, 0x90, 0x80, 0x23, 0x01, 0x02, 0x82,
   0x01, 0x40, 0x90, 0x81, 0x38, 0x01, 0x02, 0x82, 0x01, 0x20, 0x10, 0x7f,
   0x04, 0x01, 0x04, 0x84, 0x01, 0x10, 0x20, 0x00, 0x82, 0x00, 0x04, 0x84,
   0x01, 0x08, 0x20, 0x80, 0x81, 0x00, 0x00, 0x88, 0x01, 0x08, 0x40, 0x40,
   0x80, 0x00, 0x08, 0x90, 0x01, 0x04, 0x40, 0x40, 0x40, 0x00, 0x00, 0x90,
   0x01, 0x02, 0x80, 0x40, 0x20, 0x0c, 0x10, 0x90, 0x01, 0x01, 0x80, 0x20,
   0x10, 0x12, 0x10, 0xa0, 0x01, 0x01, 0x00, 0x21, 0x00, 0x11, 0x10, 0xa0,
   0x81, 0x20, 0x00, 0x31, 0x00, 0x09, 0x10, 0xa0, 0x81, 0x10, 0x00, 0x12,
   0x00, 0x09, 0x00, 0xa0, 0x41, 0x00, 0x00, 0x12, 0x00, 0x05, 0x20, 0xa0,
   0x41, 0x08, 0x00, 0x12, 0x80, 0x04, 0x00, 0xa0, 0x21, 0x00, 0x00, 0x12,
   0x40, 0x04, 0x20, 0xa0, 0x21, 0x04, 0x00, 0x14, 0x20, 0x04, 0x20, 0xa0,
   0x11, 0x00, 0x00, 0x24, 0x18, 0x04, 0x00, 0xa0, 0x11, 0x04, 0x00, 0xc4,
   0x07, 0x04, 0x00, 0xa0, 0x11, 0x00, 0x00, 0x04, 0x00, 0x04, 0x00, 0x90,
   0x09, 0x04, 0x00, 0x08, 0x00, 0x04, 0x00, 0x90, 0x09, 0x00, 0x00, 0x08,
   0x00, 0x04, 0x00, 0x98, 0x09, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x88,
   0x11, 0x00, 0x00, 0x08, 0x00, 0x18, 0x00, 0x88, 0x11, 0x00, 0x00, 0x08,
   0x00, 0x10, 0x00, 0x84, 0x11, 0x00, 0x00, 0x04, 0x00, 0x20, 0x00, 0x86,
   0x11, 0xe0, 0x00, 0x04, 0x00, 0x60, 0x00, 0x81, 0x21, 0x20, 0x01, 0x02,
   0x00, 0x80, 0x81, 0x80, 0x21, 0xc0, 0x00, 0x01, 0x00, 0x00, 0xc1, 0x80,
   0x41, 0x00, 0x80, 0x00, 0x00, 0x00, 0x62, 0x80, 0x81, 0x00, 0xc0, 0x00,
   0x00, 0x00, 0x1c, 0x80, 0x01, 0x01, 0x70, 0x00, 0x00, 0x00, 0x00, 0x80,
   0x01, 0x0e, 0x0f, 0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0xf8, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80,
   0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff};

/* for the whole figure edit panel */

icon_struct	figure_ic = { fig_width, fig_height, (char*) fig_bits };

#ifdef USE_XPM_ICON
/* The following XPM image is used for the icon on a color display */

/* XPM */
char * fig_c_icon_X[] = {
"68 64 6 1",
" 	c #000000000000",
".	c #4747BABAE1E1",
"X	c #9999CACA3131",
"o	c #A1A151512828",
"O	c #1E1E8E8E1A1A",
"+	c #FFFFFFFFFFFF",
"                                                                    ",
" .................................................................. ",
" ..............................................  .................. ",
" ........       .. ..........................  X  ................. ",
" ......... .... .. ......................... XXXXX ................ ",
" ......... .... .........  ................  XXXXXX ............... ",
" ......... .. ...  ...   ................. XXXXXXXX ............... ",
" .........    .... .. ... ................ XXXXXXXXX .............. ",
" ......... .. .... .. ... ..............  XXXXXXXXXX .............. ",
" ......... ....... ...   ............... XXXXXXXXXXX .............. ",
" ......... ....... ... ................ XXXXXXXXXXXX .............. ",
" ........   .....   ..    ............. XXXXXXXXXXX ....  ......... ",
" ...   .............. .... ........... XXXXXXXXXXXX ... XX  ....... ",
" ... oo   ........... .... ........... XXXXXXXXXXXX .. XXXXX   .... ",
" ... oooo  ...........    ............ XXXXXXX XXXX   XXXXXXXX .... ",
" ... oooooo    ....................   XXXXXXX XXXXXXXXXXXXXXXXX  .. ",
" ...  ooooooooo    .......         ooo XXXXXX XXXXXXXXXXXXXXXXXX  . ",
" ....   ooooooooooo       ooooooooooo  XXXXX XXXXXXXXXXX XXXXXXXX   ",
" .......    ooooooooooooooooooooo    XXXXX  XXXXXXXX X  XXXXXXXXXX  ",
" ...........    ooooo   ooooo      XXXX XXXXXXXXX  XXXXXXXXXXXXXXX  ",
" ...............      O         XXXXXX + XXX    XXXXXXXXXXXXXXXXXX  ",
" ................... OO ...   XXXXXXX X X  XXXXXXXXXXXXXXXXXXXXXXX  ",
" ..................  O .... XXXXXXXXXXX XXX XXXXXXXXXXXXXXXXXXXXXX  ",
" .................. OO .... XXXXXXX  XXX XXX XXXXXXXXXXXXXXXXXXXX . ",
" .................  OO .... XXXXXX XXXXX XXXX XXXXXXX     XXXXXX .. ",
" ................ OOO .... XXXXX  XXXXXX XXXXX XXXXX .... XXXXX  .. ",
" ............... OOOO ... XXXXXXXXXXXXXX XXXXXXXXXXX ..... XXXX ... ",
" ............... OOO ... XXXXXXXXXXXXXXX XXXXXX  XXXX   .. XX   ... ",
" .............. OOOO .. XXXXXXXXXX   XXXXXXXXXXX XXXXXXX ..  ...... ",
" .............. OOOO .. XXXXXXX   ... XX XXXXXXXX XXXXXXX ......... ",
" ............. OOOOO ..  XXXXXX ...   XX XXXXXXXX XXXXXXX ......... ",
" ............ OOOOOO ...       ... XXXXX XXXXXXXXX XXXXXXX ........ ",
" ........... OOOOOOOO ........... XXXXX XXXXXXXXXX XXXXXXX ........ ",
" .......... OOOOOOOOO .........  XXXXXX XXXXXXXXXXXXXXXXXXX ....... ",
" .......... OOOOOOOOOO ....... XXXXXXXX XXXXXXXXXXX XXXXXXXX ...... ",
" ......... OOOOOOOOOOO ....... XXXXXXX XXXXXXXXXXXXXXXXXXXXX ...... ",
" ........ OOOOOOOOOOOOO ...... XXXXXX XXXX  XXXXXXXX XXXXXXX ...... ",
" ....... OOOOOOOOOOOOOO ..... XXXXXX XXXX .. XXXXXXX XXXXXXXX ..... ",
" ....... OOOOOOOOOOOOOOO .... XXXXXXXXXX ... XXXXXXX XXXXXXXX ..... ",
" ...... OOOOO OOOOOOOOOO ...  XXXXXXXXXX .. XXXXXXXX XXXXXXXX ..... ",
" ...... OOOO OOOOOOOOOOOO .. XXXXXXXXXXX .. XXXXXXXXXXXXXXXXX ..... ",
" ..... OOOOOOOOOOOOOOOOOO .. XXXXXXXXXXX . XXXXXXXXXX XXXXXXX ..... ",
" ..... OOOO OOOOOOOOOOOOO .. XXXXXXXXXX .. XXXXXXXXXXXXXXXXXX ..... ",
" .... OOOOOOOOOOOOOOOOOOO .. XXXXXXXXX ... XXXXXXXXXX XXXXXXX ..... ",
" .... OOOO OOOOOOOOOOOOOOO . XXXXXXXX .... XXXXXXXXXX XXXXXXX ..... ",
" ... OOOOOOOOOOOOOOOOOOOOO .. XXXXX  ..... XXXXXXXXXXXXXXXXXX ..... ",
" ... OOOOO OOOOOOOOOOOOOOO ...     ....... XXXXXXXXXXXXXXXXXX ..... ",
" ... OOOOOOOOOOOOOOOOOOOOO ............... XXXXXXXXXXXXXXXXX ...... ",
" .. OOOOOO OOOOOOOOOOOOOOOO .............. XXXXXXXXXXXXXXXXX ...... ",
" .. OOOOOOOOOOOOOOOOOOOOOOO .............. XXXXXXXXXXXXXXXX  ...... ",
" .. OOOOOOO OOOOOOOOOOOOOOO ............... XXXXXXXXXXXXXXX ....... ",
" ... OOOOOOOOOOOOOOOOOOOOOO ...............  XXXXXXXXXXXXXX ....... ",
" ... OOOOOOOOOOOOOOOOOOOOOO ................ XXXXXXXXXXXXX ........ ",
" ... OOOOOOOOO  OOOOOOOOOO .................. XXXXXXXXXXX  ........ ",
" ... OOOOOOOO ++ OOOOOOOOO ..................  XXXXXXXXX .......... ",
" .... OOOOOOO ++ OOOOOOOO .....................  XXXXXX ........... ",
" .... OOOOOOOO  OOOOOOOO ....................... XXXXX  ........... ",
" ..... OOOOOOOOOOOOOOOO ......................... XXX  ............ ",
" ...... OOOOOOOOOOOOOO  ..........................   .............. ",
" ....... OOOOOOOOOOO   ............................................ ",
" ........   OOOO    ............................................... ",
" ..........      .................................................. ",
" .................................................................. ",
"                                                                    "};
#endif /* USE_XPM_ICON */
