//
//
// C++ Implementation: $MODULE$
//
// Description:
//
//
// Author: ian reinhart geiser <geiseri@yahoo.com>, (C) 2003
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "stationdatabase.h"

#include <qstringlist.h>
#include <qfile.h>

#include <kstandarddirs.h>

class StationInfo
{
	public:
		QString cityName;
		QString country;
		QString longitude;
		QString latitude;
		StationInfo () {}
};

StationDatabase::StationDatabase( QObject *parent, const char *name )
		: QObject ( parent, name )
{
}


StationDatabase::~StationDatabase()
{}

/*!
    \fn StationDatabase::loadDatabase()
 */
bool StationDatabase::loadDatabase()
{
	return true;
}

bool StationDatabase::loadStation( const QString & stationID )
{
	QString path = locate("data", "kweatherservice/stations.dat");
	QFile file( path );
	
	if ( !file.open( IO_ReadOnly ) )
		return false;

	QTextStream stream( &file );
	QString line;
	while ( !stream.eof() )
	{
		line = stream.readLine(); // line of text excluding '\n'
		QStringList data = QStringList::split( ";", line, true );

		if ( data[ 0 ] == stationID )
		{
			StationInfo station;
			station.cityName = data[ 3 ];
			station.country = data[ 5 ];
			station.latitude = data[ 7 ];
			station.longitude = data[ 8 ];

			theDB.insert( data[ 0 ], station );
		}
	}

	file.close();
	return true;
}

/*!
    \fn StationDatabase::stationNameFromID(const QString& id)
 */
QString StationDatabase::stationNameFromID( const QString & stationID )
{
	if ( theDB.find( stationID ) == theDB.end() )
		loadStation(stationID);

	return theDB[ stationID ].cityName;
}

/*!
    \fn StationDatabase::stationLongitudeFromID( const QString &stationID)
 */
QString StationDatabase::stationLongitudeFromID( const QString & stationID )
{
	if ( theDB.find( stationID ) == theDB.end() )
		loadStation(stationID);

	return theDB[ stationID ].longitude;
}

/*!
    \fn StationDatabase::stationLatitudeFromID(const QString &stationID)
 */
QString StationDatabase::stationLatitudeFromID( const QString & stationID )
{
	if ( theDB.find( stationID ) == theDB.end() )
		loadStation(stationID);

	return theDB[ stationID ].latitude;
}

/*!
    \fn StationDatabase::stationCountryFromID( const QString &stationID)
 */
QString StationDatabase::stationCountryFromID( const QString &stationID )
{
	if ( theDB.find( stationID ) == theDB.end() )
		loadStation(stationID);

	return theDB[ stationID ].country;
}

#include "stationdatabase.moc"
