/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 2000 by Matthias Kiefer <matthias.kiefer@gmx.de>
		2002 by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <klocale.h>
#include <kinstance.h>
#include <kaboutdata.h>
#include <kdebug.h>

#include "pc_factory.h"
#include "tmxcompendium.h"


extern "C"
{
	void *init_kbabeldict_tmxcompendium()
	{
		return new PcFactory;
	}
}


KInstance *PcFactory::s_instance = 0;
KAboutData *PcFactory::s_about = 0;


PcFactory::PcFactory( QObject *parent, const char *name)
		: KLibFactory(parent,name)
{
}

PcFactory::~PcFactory()
{
	if(s_instance)
	{
		delete s_instance;
		s_instance=0;
	}

	if(s_about)
	{
		delete s_about;
		s_about=0;
	}
}


QObject *PcFactory::createObject( QObject *parent, const char *name
				, const char *classname, const QStringList &)
{
	if(QCString(classname) != "SearchEngine")
	{
		kdError() << "not a SearchEngine requested" << endl;
		return 0;
	}
	
	return new TmxCompendium(parent,name);
}


KInstance *PcFactory::instance()
{
	if(!s_instance)
	{
		s_about = new KAboutData( "tmxcompendium", I18N_NOOP("TMX Compendium")
						, "1.0"
						, I18N_NOOP("A module for searching in a TMX file")
						, KAboutData::License_GPL
						, "Copyright 2002, Stanislav Visnovsky"
						,0,0, "visnovsky@kde.org");

		s_about->addAuthor("Matthias Kiefer",0,"kiefer@kde.org");
		s_about->addAuthor("Stanislav Visnovsky",0,"visnovsky@kde.org");
		
		s_instance = new KInstance(s_about);
	}

	return s_instance;
}

#include "pc_factory.moc"
