/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
                2001-2003 by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */
#ifndef PREFWIDGETS_H
#define PREFWIDGETS_H

#include <qwidget.h>
#include <qptrlist.h>
#include "settings.h"


class KLineEdit;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QRadioButton;
class QSpinBox;
class CmdEdit;
class KFontChooser;
class KColorButton;
class KComboBox;
class KSpellConfig;
class KURLRequester;
class QPushButton;

struct ModuleInfo;

class GeneralPreferences : public QWidget
{
    Q_OBJECT
public:
    GeneralPreferences(QWidget *parent = 0);
    virtual ~GeneralPreferences();

    void mergeSettings(CatManSettings& settings) const;
    void setSettings(const CatManSettings&);
    void defaults();

private:
    KURLRequester* _poDirEdit;
    KURLRequester* _potDirEdit;

    QCheckBox* _openWindowButton;

    QCheckBox* _killButton;
    QCheckBox* _indexButton;
};

class DirCommandsPreferences : public QWidget
{
    Q_OBJECT
public:
    DirCommandsPreferences(QWidget *parent = 0);
    virtual ~DirCommandsPreferences();

    void mergeSettings(CatManSettings& settings) const;
    void setSettings(const CatManSettings&);
    void defaults();

private:
    CmdEdit* _dirCmdEdit;
};

class FileCommandsPreferences : public QWidget
{
    Q_OBJECT
public:
    FileCommandsPreferences(QWidget *parent = 0);
    virtual ~FileCommandsPreferences();

    void mergeSettings(CatManSettings& settings) const;
    void setSettings(const CatManSettings&);
    void defaults();

private:
    CmdEdit* _fileCmdEdit;
};

class ViewPreferences : public QWidget
{
    Q_OBJECT
public:
    ViewPreferences(QWidget *parent = 0);
    virtual ~ViewPreferences();

    void mergeSettings(CatManSettings& settings) const;
    void setSettings(const CatManSettings&);
    void defaults();

private:
    QCheckBox* _flagColumnCheckbox;
    QCheckBox* _fuzzyColumnCheckbox;
    QCheckBox* _untranslatedColumnCheckbox;
    QCheckBox* _totalColumnCheckbox;
    QCheckBox* _cvsColumnCheckbox;
    QCheckBox* _revisionColumnCheckbox;
    QCheckBox* _translatorColumnCheckbox;
};

#endif // PREFWIDGETS_H
