/***************************************************************************
                            kde_NetAccess.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_NETACCESS
#define KDE_NETACCESS

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Net Transparency, formerly provided by kfmlib, but now
 done with @ref KIO::Job.

 This class isn't meant to be used as a class but only as a simple
  namespace for static functions, though an instance of the class
  is built for internal purposes.  Whereas a @ref KIO::Job is
  asynchronous, meaning that the developer has to connect slots
  for it, KIO::NetAccess provides synchronous downloads and
  uploads, as well as temporary file creation and removal.

  Port to kio done by David Faure, faure@kde.org

 @short Provides a synchronous interface to io jobs.
   
*/

/** *
 Downloads a file from an arbitrary URL (@p src) to a
 temporary file on the local filesystem (@p target).

 If the argument
 for @p target is an empty string, download will generate a
 unique temporary filename in /tmp. Since @p target is a reference
 to @ref QString you can access this filename easily. Download will
 return true if the download was successful, otherwise false.

 Special case:
 If the URL is of kind file:, then no downloading is
 processed but the full filename is returned in @p target.
 That means you @em have to take care about the @p target argument.
 (This is very easy to do, please see the example below.)

 Download is synchronous. That means you can use it like
 this, (assuming @p u is a string which represents a URL and your
 application has a @ref loadFile() function):

 <pre>
 QString tmpFile;
 if( KIO::NetAccess::download( u, tmpFile ) )
 {
   loadFile( tmpFile );
   KIO::NetAccess::removeTempFile( tmpFile );
   }
 </pre>

 Of course, your user interface will still process exposure/repaint
 events during the download.

*/
#ifdef __cplusplus
extern   "C" {
#endif
int kde_NetAccess_download( kde_KURL* src, qt_QString * target);

/** *
 Removes the specified file if and only if it was created
 by KIO::NetAccess as a temporary file for a former download.

 Note: This means that if you created your temporary with @ref KTempFile,
 use @ref KTempFile::unlink() or @ref KTempFile::setAutoDelete() to have
 it removed.

*/
void kde_NetAccess_removeTempFile( qt_QString * name);

/** *
 Uploads file @p src to URL @p target.

 Both must be specified, unlike @ref #download.
 Note that this is assumed to be used for saving a file over
 the network, so overwriting is set to true. This is not the
 case with @ref #copy.

*/
int kde_NetAccess_upload( qt_QString * src, kde_KURL* target);

/** *
 Alternative method for copying over the network.
 Overwrite is false, so this will fail if @p target exists.

 This one takes two URLs and is a direct equivalent
 of @ref KIO::file_copy (not KIO::copy!).
     
*/
int kde_NetAccess_copy( kde_KURL* src, kde_KURL* target);

/** *
 Alternative method for copying over the network.
 Overwrite is false, so this will fail if @p target exists.

 This one takes two URLs and is a direct equivalent
 of @ref KIO::copy!.
     
*/
int kde_NetAccess_dircopy( kde_KURL* src, kde_KURL* target);

/** *
 Tests whether a URL exists.

 This is a convenience function for @ref KIO::stat
 (it saves creating a slot and testing for the job result).

*/
int kde_NetAccess_exists( kde_KURL* url);

/** *
 Overloaded version of exists
 A stat() can have two meanings. Either we want to read from this URL,
 or to check if we can write to it. First case is "source", second is "dest".
 It is necessary to know what the StatJob is for, to tune the kioslave's behaviour
 (e.g. with FTP)
 Tests whether a URL exists.

*/
int kde_NetAccess_exists1( kde_KURL* url, int source);

/** *
 Tests whether a URL exists and return information on it.

 This is a convenience function for @ref KIO::stat
 (it saves creating a slot and testing for the job result).

*/

/** *
 Deletes a file or a directory in an synchronous way.

 This is a convenience function for @ref KIO::del
 (it saves creating a slot and testing for the job result).

*/
int kde_NetAccess_del( kde_KURL* url);

/** *
 Creates a directory in a synchronous way.

 This is a convenience function for @p KIO::mkdir
 (it saves creating a slot and testing for the job result).

*/
int kde_NetAccess_mkdir( kde_KURL* url, int permissions);

/** *
 Determines the mimetype of a given URL.

 This is a convenience function for @ref KIO::mimetype.  You
 should call this only when really necessary.  @ref
 KMimeType::findByURL can determine extension a lot faster, but
 less reliably for remote files. Only when @ref findByURL() returns
 unknown (application/octet-stream) then this one should be
 used.

*/

/** *
 Returns the error string for the last job, in case it failed.
     
*/
qt_QString * kde_NetAccess_lastErrorString( );

#ifdef __cplusplus
}
#endif
#endif
