/***************************************************************************
                            kde_KTrader.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KTRADER
#define KDE_KTRADER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A Trader interface, similar to the CORBA Trader.

 Basically, it provides a way for an application to query
 all KDE services (that is, applications and components) that match
 a specific set of requirements.  This allows you to find an
 application in real-time without you having to hard-code the name
 and/or path of the application.  It is mostly used when you want to
 do complex queries that @ref KServiceTypeProfile can't handle.

 A few examples will make this a lot more clear.

 Say you have an application that will display HTML.  In this
 example, you don't want to link to khtml... and furthermore, you
 really don't care if the HTML browser is ours or not, as long as
 it works.  The way that you formulate your query as well as the way
 that you execute the browser depends on whether or not you want the
 browser to run stand-alone or embedded.

 If you want the browser to run standalone, then you will limit the
 query to search for all services that handle 'text/html' @em and,
 furthermore, they must be applications (Type=Application).  You
 then will use @ref KRun::run() to invoke the application.  In "trader-speak",
 this looks like so:
 <PRE>
 KTrader::OfferList offers = KTrader::self()->query("text/html", "Type == 'Application'");
 KService::Ptr ptr = offers.first();
 KURL::List lst;
 lst.append("http://www.kde.org/index.html");
 KRun::run(*ptr, lst);
 </PRE>

 It should be noted that in the above example, using
 @ref KServiceTypeProfile would be the better choice since you would
 probably want the preferred service and the trader doesn't take
 this into account.  The trader does allow you to do more complex
 things, though.  Say, for instance, you want to only choose
 Netscape.  You can do it with the constraint: "(Type ==
 'Application') and (Name == 'Netscape')"

 More the likely, though, you will only use the trader for such
 things as finding components.  In our continuing example, we say
 that we want to load any KParts component that can handle HTML.  We
 will need to use the @ref KLibFactory and @ref KLibLoader to
 actually do something with our query, then.  Our code would look
 like so:
 <PRE>
 KTrader::OfferList offers = KTrader::self()->query("text/html", "'KParts/ReadOnlyPart' in ServiceTypes");
 KService::Ptr ptr = offers.first();
 KLibFactory *factory = KLibLoader::self()->factory( ptr->library() );
 if (factory)
   part = static_cast<KParts::ReadOnlyPart *>(factory->create(this, ptr->name(), "KParts::ReadOnlyPart"));
 </PRE>

 Please note that when including property names containing arithmetic operators like - or +, then you have
 to put brackets around the property name, in order to correctly separate arithmetic operations from
 the name. So for example a constraint expression like
  X-KDE-Blah < 4
 needs to be written as
 [X-KDE-Blah] < 4
 otherwise it could also be interpreted as
 Substract the numeric value of the property "KDE" and "Blah" from the property "X" and make sure it
 is less than 4.
 Instead of the other meaning, make sure that the numeric value of "X-KDE-Blah" is less than 4.

 Please read http://developer.kde.org/documentation/library/tradersyntax.html for
 a more complete description of the trader language syntax.

 @author Torben Weis <weis@kde.org>
 
 @short Provides a way to query the KDE infrastructure for specific
        applications or components.

*/

/** *
 Standard destructor
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
void kde_del_KTrader( kde_KTrader* p );

/** *
 The main function in the KTrader class.

 It will return a list of services that match your
 specifications.  The only required parameter is the service
 type.  This is something like 'text/plain' or 'text/html'.  The
 constraint parameter is used to limit the possible choices
 returned based on the constraints you give it.

 The constraint language is rather full.  The most common
 keywords are AND, OR, NOT, IN, and EXIST.. all used in an
 almost spoken-word form.  An example is:
 <PRE>
 (Type == 'Service') and (('KParts/ReadOnlyPart' in ServiceTypes) or (exist Exec))
 </PRE>

 The keys used in the query (Type, ServiceType, Exec) are all
 fields found in the .desktop files.

*/
kde_OfferList* kde_KTrader_query(kde_KTrader* instPointer,qt_QString * servicetype, qt_QString * constraint, qt_QString * preferences);

/** *
 A variant of query, that takes two service types as an input.
 It is not exactly the same as adding the second service type
 in the constraints of the other query call, because this one
 takes into account user preferences for this combination of service types.

 Typically, this is used for getting the list of embeddable components
 that can handle a given mimetype.
 In that case, @p servicetype is the mimetype and @p genericServiceType is "KParts/ReadOnlyPart".
     
*/
kde_OfferList* kde_KTrader_query1(kde_KTrader* instPointer,qt_QString * servicetype, qt_QString * genericServiceType, qt_QString * constraint, qt_QString * preferences);

/** *
 This is a static pointer to a KTrader instance.

  You will need
 to use this to access the KTrader functionality since the
 constuctors are protected.

*/
kde_KTrader* kde_KTrader_self( );

/** *

     
*/
kde_KTrader * kde_new_KTrader();
void kde_KTrader_virtual_hook(kde_KTrader* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
