/***************************************************************************
                            kde_KColorDialog.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KCOLORDIALOG
#define KDE_KCOLORDIALOG

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The KColorDialog provides a dialog for color selection.

 In most cases, you will want to use the static method @ref KColorDialog::getColor().
 This pops up the dialog (with an initial selection provided by you), lets the
 user choose a color, and returns.

 Example:

 <pre>
 	QColor myColor;
 	int result = KColorDialog::getColor( myColor );
         if ( result == KColorDialog::Accepted )
            ...
 </pre>

 The color dialog is really a collection of several widgets which can
 you can also use separately: the quadratic plane in the top left of
 the dialog is a @ref KXYSelector. Right next to it is a @ref KHSSelector
 for chosing hue/saturation.

 On the right side of the dialog you see a @ref KPaletteTable showing
 up to 40 colors with a combo box which offers several predefined
 palettes or a palette configured by the user. The small field showing
 the currently selected color is a @ref KColorPatch.

 @short A color selection dialog.

*/

/** *
 Constructs a color selection dialog.
     
*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KColorDialog * kde_new_KColorDialog(qt_QWidget * parent, char* name, int modal);

/** *
 Destroys the color selection dialog.
     
*/
void kde_del_KColorDialog( kde_KColorDialog* p );

/** *
 Returns the currently selected color.

*/
qt_QColor * kde_KColorDialog_color(kde_KColorDialog* instPointer);

/** *
 Call this to make the dialog show a "Default Color" checkbox.
 If this checkbox is selected, the dialog will return an "invalid" color (QColor()).
 This can be used to mean "the default text color", for instance,
 the one with the KDE text color on screen, but black when printing.
     
*/
void kde_KColorDialog_setDefaultColor(kde_KColorDialog* instPointer,qt_QColor * defaultCol);

/** *

*/
qt_QColor * kde_KColorDialog_defaultColor(kde_KColorDialog* instPointer);

/** *
 Preselects a color.
     
*/
void kde_KColorDialog_setColor(kde_KColorDialog* instPointer,qt_QColor * col);

/** *
 Creates a modal color dialog, let the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument @p theColor.

*/
int kde_KColorDialog_getColor( qt_QColor * theColor, qt_QWidget * parent);

/** *
 Creates a modal color dialog, lets the user choose a
 color, and returns when the dialog is closed.

 The selected color is returned in the argument @p theColor.

 This version takes a @p defaultColor argument, which sets the color
 selected by the "default color" checkbox. When this checkbox is checked,
 the invalid color (QColor()) is returned into @p theColor.

*/
int kde_KColorDialog_getColor1( qt_QColor * theColor, qt_QColor * defaultColor, qt_QWidget * parent);

/** *
 Gets the color from the pixel at point p on the screen.
     
*/
qt_QColor * kde_KColorDialog_grabColor( qt_QPoint* p);
void kde_KColorDialog_virtual_hook(kde_KColorDialog* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
