/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qpopupmenu.h>

#include <kapplication.h>
#include <kipc.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kicontheme.h>

#include "popupposition.h"

#include "panelbutton.h"
#include "panelbutton.moc"

PanelButton::PanelButton( QWidget* parent, const char* name )
  : PanelButtonBase( parent, name )
{
    connect(kapp, SIGNAL(iconChanged(int)), SLOT(slotIconChanged(int)));
    kapp->addKipcEventMask(KIPC::IconChanged);
}

void PanelButton::configure()
{
    QString name = tileName();
    if( name.isEmpty() )
        return;

    KConfigGroup config( KGlobal::config(), "buttons" );
    if( !config.readBoolEntry( "EnableTileBackground", false ) ) {
        setTile( QString::null );
        return;
    }

    KConfigGroup tilesGroup( KGlobal::config(), "button_tiles" );
    if( !tilesGroup.readBoolEntry( "Enable" + name + "Tiles", true ) ) {
            setTile( QString::null );
        return;
    }

    QString tile = tilesGroup.readEntry( name + "Tile" );
    QColor color = QColor();

    if (tile == "Colorize")
    {
        color = tilesGroup.readColorEntry( name + "TileColor" );
        tile = QString::null;
    }

    setTile( tile, color );

    PanelButtonBase::configure();
}

void PanelButton::slotIconChanged(int group)
{
    if (group != KIcon::Panel)
        return;
    loadIcons();
    update();
}

PanelPopupButton::PanelPopupButton(QWidget *parent, const char *name)
  : PanelButton(parent, name)
{
    _pressedDuringPopup = false;
    _popup = 0;
    setDrawArrow(true);
    connect(this, SIGNAL(pressed()), SLOT(slotExecMenu()));
}

void PanelPopupButton::setPopup(QPopupMenu *popup)
{
    if(popup != 0) {
	_popup = popup;
	_popup->installEventFilter(this);
    }
}

QPopupMenu *PanelPopupButton::popup() const
{
    return _popup;
}

bool PanelPopupButton::eventFilter(QObject *, QEvent *e)
{
    if (e->type() == QEvent::MouseButtonPress
	    || e->type() == QEvent::MouseButtonDblClick) {
	QMouseEvent *me = static_cast<QMouseEvent *>(e);
	if (rect().contains(mapFromGlobal(me->globalPos()))) {
	    _pressedDuringPopup = true;
	    return true;
	}
    }
    else if (e->type() == QEvent::MouseButtonRelease) {
	QMouseEvent *me = static_cast<QMouseEvent *>(e);
	if (rect().contains(mapFromGlobal(me->globalPos()))) {
	    if (_pressedDuringPopup)
		_popup->hide();
	    return true;
	}
    }
    return false;
}

void PanelPopupButton::slotExecMenu()
{
    if (_popup != 0) {
	_pressedDuringPopup = false;
	setZoomEnabled(false);
	kapp->syncX();
	kapp->processEvents();
	initPopup();
	_popup->adjustSize();
	_popup->exec( popupPosition( popupDirection(), _popup, this ) );
	setDown(false);
	setZoomEnabled(true);
    }
}
