# Allow for selectively disabling from commandline
%{!?quantum:%define quantum 16}
%{!?perlm:%define perlm 1}
%{!?cplus:%define cplus 1}

%define name  ImageMagick
%define version 6.0.4
%define release 3
%define serial  1
%define prefix  /usr/local
%define datadir %{prefix}/share
%define pkgdatadir %{prefix}/share/ImageMagick-6.0.4
%define project Magick
%define wand Wand

Summary: Convert, Edit, and Compose Images
Name: %{name}
Version: %{version}
Release: %{release}
Vendor: ImageMagick Studio LLC
URL: http://www.imageMagick.org/
Source: ftp://ftp.imageMagick.org/pub/%{name}/%{name}-%{version}.tar.bz2
License: freeware
Group: X11/Applications/Graphics
Buildroot: %{_tmppath}/%{name}-%{version}-root
BuildPrereq: bzip2-devel, freetype-devel, libjpeg-devel, libpng-devel
BuildPrereq: libtiff-devel, zlib-devel
BuildPrereq: freetype-devel >= 2.0.1
Requires: bzip2, freetype, libjpeg, libpng, zlib

%description
ImageMagick is a robust collection of tools and libraries offered
under a usage license to read, write, and manipulate an image in many
image formats (over 89 major formats) including popular formats like
TIFF, JPEG, PNG, PDF, PhotoCD, and GIF. With ImageMagick you can create
images dynamically, making it suitable for Web applications. You can
also resize, rotate, sharpen, color reduce, or add special effects to
an image or image sequence and save your completed work in the same
or differing image format. Image processing operations are available
from the command line, or from the C, C++, Perl, Java, PHP, Python,
or Ruby programming languages. A high-quality 2D renderer is included,
which provides a subset of SVG capabilities. ImageMagick's focus is on
performance, minimizing bugs, and providing stable APIs and ABIs.

%package devel
Summary: Static libraries and header files for ImageMagick development.
Group: X11/Development/Libraries
Requires: %{name} = %{version}-%{release}

%description devel
This is the ImageMagick development package.  It includes the static
libraries and header files for use in developing your own applications
that make use of the ImageMagick code and/or APIs.

%if %{perlm}
%package perl
Summary: Object-oriented Perl bindings to ImageMagick
Group: Development/Libraries/Perl
BuildPrereq: perl >= 5.6.0
Requires: %{name} = %{version}-%{release}, perl >= 5.6.0

%description perl
This is the ImageMagick perl support package. It includes perl modules and
support files for access to ImageMagick library from perl.
%endif

%if %{cplus}
%package c++
Summary: Object-oriented C++ bindings to ImageMagick
Group: System Environment/Libraries
Requires: %{name} = %{version}-%{release}

%description c++
This is the Magick++ package, the object-oriented C++ API to the ImageMagick
image-processing library.

%package c++-devel
Summary: Object-oriented C++ bindings to ImageMagick
Group: Development/Libraries
Requires: %{name} = %{version}, %{name}-c++ = %{version}
Requires: %{name}-devel = %{version}, bzip2-devel, freetype-devel
Requires: libjpeg-devel, libpng-devel, libtiff-devel, zlib-devel, libxml2-devel

%description c++-devel
ImageMagick-devel contains the static libraries and header files you'll
need to develop ImageMagick applications using the Magick++ C++ bindings.
ImageMagick is an image manipulation program.

If you want to create applications that will use Magick++ code or
APIs, you'll need to install ImageMagick-c++-devel, ImageMagick-devel
and ImageMagick.  You don't need to install it if you just want to use
ImageMagick, or if you want to develop/compile applications using the
ImageMagick C interface, however.
%endif

%prep
%setup -q

%build

#%if %{perlm}
#if [ "`perl -v | grep -c 5.8`" ]; then
#    export PERLOPTS="PREFIX=$RPM_BUILD_ROOT%{_prefix}"
#fi
#%endif

%configure --enable-shared --disable-static \
	--with-modules --without-frozenpaths \
%if %{perlm}
	--with-perl \
	--with-perl-options="$PERLOPTS" \
%else
	--without-perl \
%endif
%if %{cplus}
	--with-magick-plus-plus \
%else
	--without-magick-plus-plus \
%endif
	--with-quantum-depth=%{quantum}
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%if %{perlm}
# Remove unpackaged files.
rm -f `find $RPM_BUILD_ROOT%{_libdir}/perl*/ -name perllocal.pod -type f`
rm -f `find $RPM_BUILD_ROOT%{_libdir}/perl*/ -name .packlist -type f`
%endif
# These are empty directories, just nuke 'em.
#rmdir $RPM_BUILD_ROOT%{_includedir}/magick
#rmdir $RPM_BUILD_ROOT%{_datadir}/%{name}
# These have incorrect permissions set.
chmod 755 $RPM_BUILD_ROOT%{_bindir}/%{project}-config
chmod 755 $RPM_BUILD_ROOT%{_bindir}/%{wand}-config
%if %{cplus}
chmod 755 $RPM_BUILD_ROOT%{_bindir}/%{project}++-config
%endif

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(644, root, root, 755)
%doc LICENSE NOTICE NEWS AUTHORS QuickStart.txt index.html README.txt www images
%doc %{_datadir}/%{name}-%{version}
%{_libdir}/lib%{project}.so.*
%{_libdir}/lib%{wand}.so.*
%dir %{_libdir}/%{name}-%{version}
%{_libdir}/%{name}-%{version}/config/*.mgk
%dir %{_libdir}/%{name}-%{version}/modules-Q%{quantum}
%{_libdir}/%{name}-%{version}/modules-Q%{quantum}/*/*.so
%{_libdir}/%{name}-%{version}/modules-Q%{quantum}/*/*.la
%attr(755, root, root) %{_bindir}/*
%attr(644, root, man) %{_mandir}/man1/*gz
%attr(644, root, man) %{_mandir}/man4/*gz
%attr(644, root, man) %{_mandir}/man5/*gz

%files devel
%defattr(644, root, root, 755)
%dir %{_includedir}/magick
%{_includedir}/magick/*
%{_includedir}/wand/*
%{_libdir}/lib%{project}.*a
%{_libdir}/lib%{wand}.*a
%{_libdir}/lib%{project}.so
%{_libdir}/lib%{wand}.so
%dir %{_libdir}/%{name}-%{version}/modules-Q%{quantum}
%{_libdir}/%{name}-%{version}/modules-Q%{quantum}/*/*.la
%{_libdir}/pkgconfig/%{name}.pc
%{_libdir}/pkgconfig/%{wand}.pc
%{_bindir}/%{project}-config
%attr(755, root, root) %{_bindir}/%{project}-config
%{_bindir}/%{wand}-config
%attr(755, root, root) %{_bindir}/%{wand}-config
%attr(644, root, man) %{_mandir}/man1/%{project}-config.1.gz
%attr(644, root, man) %{_mandir}/man1/%{wand}-config.1.gz

%if %{perlm}
%files perl
%defattr(644, root, root, 755)
%dir %{_libdir}/perl*/site_perl/*/*/Image
%{_libdir}/perl*/site_perl/*/*/Image/Magick.pm
%dir %{_libdir}/perl*/site_perl/*/*/auto/Image/Magick
%{_libdir}/perl*/site_perl/*/*/auto/Image/Magick/*
%attr(644, root, man) %{_mandir}/man3/*.gz
%endif

%if %{cplus}
%files c++
%defattr(644, root, root, 755)
%{_libdir}/lib%{project}++.so.*

%files c++-devel
%defattr(644, root, root, 755)
%{_includedir}/Magick++.h
%dir %{_includedir}/Magick++
%{_includedir}/Magick++/*
%{_libdir}/lib%{project}++.*a
%{_libdir}/lib%{project}++.so
%{_libdir}/pkgconfig/%{name}++.pc
%{_bindir}/%{project}++-config
%attr(644, root, man) %{_mandir}/man1/%{project}++-config.1.gz
%endif

%changelog
* Mon Jul 28 2003 Cristy <cristy@mystic.es.dupont.com> 1.0-0
- Port of Troy Edwards' script to support ImageMagick.  Thanks Troy.
