/****************************************************************************
** $Id: qt/qpaintdevice.h   3.3.3   edited May 27 2003 $
**
** Definition of QPaintDevice class
**
** Created : 940721
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QPAINTDEVICE_H
#define QPAINTDEVICE_H

#ifndef QT_H
#include "qwindowdefs.h"
#include "qrect.h"
#endif // QT_H

#if defined(Q_WS_QWS)
class QWSDisplay;
class QGfx;
#endif

class QIODevice;
class QString;
class QTextItem;


#if defined(Q_WS_X11)
struct QPaintDeviceX11Data;
#endif

union QPDevCmdParam {
    int			 ival;
    int			*ivec;
    QString	        *str;
    const QPoint	*point;
    const QRect		*rect;
    const QPointArray	*ptarr;
    const QPixmap	*pixmap;
    const QImage	*image;
    const QColor	*color;
    const QFont		*font;
    const QPen		*pen;
    const QBrush	*brush;
    const QRegion	*rgn;
    const QWMatrix	*matrix;
    const QTextItem     *textItem;
    QIODevice		*device;
};



class Q_EXPORT QPaintDevice				// device for QPainter
{
public:
    virtual ~QPaintDevice();

    int		devType() const;
    bool	isExtDev() const;
    bool	paintingActive() const;

    virtual void setResolution( int );
    virtual int resolution() const;

    // Windows:	  get device context
    // X-Windows: get drawable
#if defined(Q_WS_WIN)
    virtual HDC		handle() const;
#elif defined(Q_WS_X11)
    virtual Qt::HANDLE	handle() const;
    virtual Qt::HANDLE  x11RenderHandle() const;
#elif defined(Q_WS_MAC)
    virtual Qt::HANDLE      handle() const;
#elif defined(Q_WS_QWS)
    virtual Qt::HANDLE	handle() const;
#endif

#if defined(Q_WS_X11)
    Display 	   *x11Display() const;
    int		    x11Screen() const;
    int		    x11Depth() const;
    int		    x11Cells() const;
    Qt::HANDLE	    x11Colormap() const;
    bool	    x11DefaultColormap() const;
    void	   *x11Visual() const;
    bool	    x11DefaultVisual() const;

    static Display *x11AppDisplay();
    static int	    x11AppScreen();

    static int      x11AppDpiX();
    static int      x11AppDpiY();
    static void     x11SetAppDpiX(int);
    static void     x11SetAppDpiY(int);
    static int	    x11AppDepth();
    static int	    x11AppCells();
    static Qt::HANDLE   x11AppRootWindow();
    static Qt::HANDLE   x11AppColormap();
    static bool     x11AppDefaultColormap();
    static void    *x11AppVisual();
    static bool	    x11AppDefaultVisual();

    // ### in 4.0, the above need to go away, the below needs to take a -1 default
    // argument, signifying the default screen...
    static int	    x11AppDepth( int screen );
    static int	    x11AppCells( int screen );
    static Qt::HANDLE   x11AppRootWindow( int screen );
    static Qt::HANDLE   x11AppColormap( int screen );
    static void    *x11AppVisual( int screen );
    static bool     x11AppDefaultColormap( int screen );
    static bool	    x11AppDefaultVisual( int screen );
    static int      x11AppDpiX( int );
    static int      x11AppDpiY( int );
    static void     x11SetAppDpiX( int, int );
    static void     x11SetAppDpiY( int, int );
#endif

#if defined(Q_WS_QWS)
    static QWSDisplay *qwsDisplay();
    virtual unsigned char * scanLine(int) const;
    virtual int bytesPerLine() const;
    virtual QGfx * graphicsContext(bool clip_children=TRUE) const;
#endif

    enum PDevCmd {
	PdcNOP = 0, //  <void>
	PdcDrawPoint = 1, // point
	PdcDrawFirst = PdcDrawPoint,
	PdcMoveTo = 2, // point
	PdcLineTo = 3, // point
	PdcDrawLine = 4, // point,point
	PdcDrawRect = 5, // rect
	PdcDrawRoundRect = 6, // rect,ival,ival
	PdcDrawEllipse = 7, // rect
	PdcDrawArc = 8, // rect,ival,ival
	PdcDrawPie = 9, // rect,ival,ival
	PdcDrawChord = 10, // rect,ival,ival
	PdcDrawLineSegments = 11, // ptarr
	PdcDrawPolyline = 12, // ptarr
	PdcDrawPolygon = 13, // ptarr,ival
	PdcDrawCubicBezier = 14, // ptarr
	PdcDrawText = 15, // point,str
	PdcDrawTextFormatted = 16, // rect,ival,str
	PdcDrawPixmap = 17, // rect,pixmap
	PdcDrawImage = 18, // rect,image
	PdcDrawText2 = 19, // point,str
	PdcDrawText2Formatted = 20, // rect,ival,str
	PdcDrawTextItem = 21,
	PdcDrawLast = PdcDrawTextItem,

	// no painting commands below PdcDrawLast.

	PdcBegin = 30, //  <void>
	PdcEnd = 31, //  <void>
	PdcSave = 32, //  <void>
	PdcRestore = 33, //  <void>
	PdcSetdev = 34, // device - PRIVATE
	PdcSetBkColor = 40, // color
	PdcSetBkMode = 41, // ival
	PdcSetROP = 42, // ival
	PdcSetBrushOrigin = 43, // point
	PdcSetFont = 45, // font
	PdcSetPen = 46, // pen
	PdcSetBrush = 47, // brush
	PdcSetTabStops = 48, // ival
	PdcSetTabArray = 49, // ival,ivec
	PdcSetUnit = 50, // ival
	PdcSetVXform = 51, // ival
	PdcSetWindow = 52, // rect
	PdcSetViewport = 53, // rect
	PdcSetWXform = 54, // ival
	PdcSetWMatrix = 55, // matrix,ival
	PdcSaveWMatrix = 56,
	PdcRestoreWMatrix = 57,
	PdcSetClip = 60, // ival
	PdcSetClipRegion = 61, // rgn

	PdcReservedStart = 0, // codes 0-199 are reserved
	PdcReservedStop = 199 //   for Qt
    };

protected:
    QPaintDevice( uint devflags );

#if defined(Q_WS_WIN)
    HDC		hdc;				// device context
#elif defined(Q_WS_X11)
    Qt::HANDLE	hd;				// handle to drawable
    Qt::HANDLE  rendhd;                         // handle to RENDER pict

    void		 copyX11Data( const QPaintDevice * );
    void		 cloneX11Data( const QPaintDevice * );
    virtual void	 setX11Data( const QPaintDeviceX11Data* );
    QPaintDeviceX11Data* getX11Data( bool def=FALSE ) const;
#elif defined(Q_WS_MAC)
#if !defined( QMAC_NO_QUARTZ )
    CGContextRef ctx;
#endif
    void * hd;
#elif defined(Q_WS_QWS)
    Qt::HANDLE hd;
#endif

    virtual bool cmd( int, QPainter *, QPDevCmdParam * );
    virtual int	 metric( int ) const;
    virtual int	 fontMet( QFont *, int, const char * = 0, int = 0 ) const;
    virtual int	 fontInf( QFont *, int ) const;

    ushort	devFlags;			// device flags
    ushort	painters;			// refcount

    friend class QPainter;
    friend class QPaintDeviceMetrics;
#if defined(Q_WS_MAC)
#ifndef QMAC_NO_QUARTZ
    virtual CGContextRef macCGContext(bool clipped=TRUE) const;
#endif
    friend Q_EXPORT void unclippedScaledBitBlt( QPaintDevice *, int, int, int, int,
						const QPaintDevice *, int, int, int, int, Qt::RasterOp, bool, bool );
#else
    friend Q_EXPORT void bitBlt( QPaintDevice *, int, int,
				 const QPaintDevice *,
				 int, int, int, int, Qt::RasterOp, bool );
#endif
#if defined(Q_WS_X11)
    friend void qt_init_internal( int *, char **, Display *, Qt::HANDLE, Qt::HANDLE );
    friend void qt_cleanup();
#endif

private:
#if defined(Q_WS_X11)
    static Display *x_appdisplay;
    static int	    x_appscreen;

    static int	    x_appdepth;
    static int	    x_appcells;
    static Qt::HANDLE   x_approotwindow;
    static Qt::HANDLE   x_appcolormap;
    static bool	    x_appdefcolormap;
    static void	   *x_appvisual;
    static bool     x_appdefvisual;

    // ### in 4.0, remove the above, and replace with the below
    static int	      *x_appdepth_arr;
    static int	      *x_appcells_arr;
    static Qt::HANDLE *x_approotwindow_arr;
    static Qt::HANDLE *x_appcolormap_arr;
    static bool	      *x_appdefcolormap_arr;
    static void	     **x_appvisual_arr;
    static bool       *x_appdefvisual_arr;

    QPaintDeviceX11Data* x11Data;
#endif

private:	// Disabled copy constructor and operator=
#if defined(Q_DISABLE_COPY)
    QPaintDevice( const QPaintDevice & );
    QPaintDevice &operator=( const QPaintDevice & );
#endif
};


Q_EXPORT
void bitBlt( QPaintDevice *dst, int dx, int dy,
	     const QPaintDevice *src, int sx=0, int sy=0, int sw=-1, int sh=-1,
	     Qt::RasterOp = Qt::CopyROP, bool ignoreMask=FALSE );

Q_EXPORT
void bitBlt( QPaintDevice *dst, int dx, int dy,
	     const QImage *src, int sx=0, int sy=0, int sw=-1, int sh=-1,
	     int conversion_flags=0 );


#if defined(Q_WS_X11)

struct Q_EXPORT QPaintDeviceX11Data : public QShared {
    Display*	x_display;
    int		x_screen;
    int		x_depth;
    int		x_cells;
    Qt::HANDLE	x_colormap;
    bool	x_defcolormap;
    void*	x_visual;
    bool	x_defvisual;
};

#endif

/*****************************************************************************
  Inline functions
 *****************************************************************************/

inline int QPaintDevice::devType() const
{ return devFlags & QInternal::DeviceTypeMask; }

inline bool QPaintDevice::isExtDev() const
{ return (devFlags & QInternal::ExternalDevice) != 0; }

inline bool QPaintDevice::paintingActive() const
{ return painters != 0; }

#if defined(Q_WS_X11)
inline Display *QPaintDevice::x11Display() const
{ return x11Data ? x11Data->x_display : x_appdisplay; }

inline int QPaintDevice::x11Screen() const
{ return x11Data ? x11Data->x_screen : x_appscreen; }

inline int QPaintDevice::x11Depth() const
{ return x11Data ? x11Data->x_depth : x_appdepth; }

inline int QPaintDevice::x11Cells() const
{ return x11Data ? x11Data->x_cells : x_appcells; }

inline Qt::HANDLE QPaintDevice::x11Colormap() const
{ return x11Data ? x11Data->x_colormap : x_appcolormap; }

inline bool QPaintDevice::x11DefaultColormap() const
{ return x11Data ? x11Data->x_defcolormap : x_appdefcolormap; }

inline void *QPaintDevice::x11Visual() const
{ return x11Data ? x11Data->x_visual : x_appvisual; }

inline bool QPaintDevice::x11DefaultVisual() const
{ return x11Data ? x11Data->x_defvisual : x_appdefvisual; }

inline Display *QPaintDevice::x11AppDisplay()
{ return x_appdisplay; }

inline int QPaintDevice::x11AppScreen()
{ return x_appscreen; }

inline int QPaintDevice::x11AppDepth( int screen )
{ return x_appdepth_arr[ screen == -1 ? x_appscreen : screen ]; }

inline int QPaintDevice::x11AppCells( int screen )
{ return x_appcells_arr[ screen == -1 ? x_appscreen : screen ]; }

inline Qt::HANDLE QPaintDevice::x11AppRootWindow( int screen )
{ return x_approotwindow_arr[ screen == -1 ? x_appscreen : screen ]; }

inline Qt::HANDLE QPaintDevice::x11AppColormap( int screen )
{ return x_appcolormap_arr[ screen == -1 ? x_appscreen : screen ]; }

inline bool QPaintDevice::x11AppDefaultColormap( int screen )
{ return x_appdefcolormap_arr[ screen == -1 ? x_appscreen : screen ]; }

inline void *QPaintDevice::x11AppVisual( int screen )
{ return x_appvisual_arr[ screen == -1 ? x_appscreen : screen ]; }

inline bool QPaintDevice::x11AppDefaultVisual( int screen )
{ return x_appdefvisual_arr[ screen == -1 ? x_appscreen : screen ]; }

inline int QPaintDevice::x11AppDepth()
{ return x_appdepth; }

inline int QPaintDevice::x11AppCells()
{ return x_appcells; }

inline Qt::HANDLE QPaintDevice::x11AppRootWindow()
{ return x_approotwindow; }

inline Qt::HANDLE QPaintDevice::x11AppColormap()
{ return x_appcolormap; }

inline bool QPaintDevice::x11AppDefaultColormap()
{ return x_appdefcolormap; }

inline void *QPaintDevice::x11AppVisual()
{ return x_appvisual; }

inline bool QPaintDevice::x11AppDefaultVisual()
{ return x_appdefvisual; }

#endif // Q_WS_X11


Q_EXPORT
inline void bitBlt( QPaintDevice *dst, const QPoint &dp,
		    const QPaintDevice *src, const QRect &sr =QRect(0,0,-1,-1),
		    Qt::RasterOp rop=Qt::CopyROP, bool ignoreMask=FALSE )
{
    bitBlt( dst, dp.x(), dp.y(), src, sr.x(), sr.y(), sr.width(), sr.height(),
	    rop, ignoreMask );
}




#endif // QPAINTDEVICE_H
