/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001-2003 Joop Stakenborg <pa4tu@amsat.org>
 *
 * This program is free oftware; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * logfile.h
 */

#ifndef _LOGFILE_H
#define _LOGFILE_H 1

#include <glib.h>

#define FLOG_MAX_LINE_SIZE 300
#define MAX_VARIABLE_LEN 128
#define MAX_COLUMN 32

extern const gint qso_fields[];
extern const gint qso_widths[];
extern const gint qso_field_nr;
typedef gchar *qso_t;

/* Forward struct references */

struct log_file;
typedef struct log_file LOGDB;

enum log_file_type
{
  TYPE_OLD_LOG,			/* version 0.4 and 0.5 */
  TYPE_FLOG,			/* flexible xlog format */
  TYPE_TWLOG,
  TYPE_ADIF,
  TYPE_CABRILLO,
  TYPE_EDITEST,
/*	TYPE_DB3	to be defined */
};

/*
 * Here we go again, OOP in C. hi.
 */
struct log_ops
{
  gint (*open) (LOGDB *);
  void (*close) (LOGDB *);
    gint (*create) (LOGDB *);
    gint (*add_column) (LOGDB *, gint pos, gint field, gint width);
    gint (*delete_column) (LOGDB *, gint pos);
    gint (*qso_append) (LOGDB *, const qso_t *);
    gint (*qso_foreach) (LOGDB *, gint (*fn) (LOGDB *, qso_t *, gpointer arg),
			 gpointer arg);
  enum log_file_type type;
  const char *name;
  const char *extension;
};

struct log_file
{
  enum log_file_type type;
  const struct log_ops *ops;
  gchar *path;
  gpointer priv;		/* for use by the log backend */
  gint column_nr;
  gint column_fields[MAX_COLUMN];
  gint column_widths[MAX_COLUMN];
};

LOGDB *log_file_open (const gchar * path, enum log_file_type type);
LOGDB *log_file_create (const gchar * path, enum log_file_type type,
			gint columns, const gint column_field[],
			const gint column_width[]);
void log_file_close (LOGDB *);
gint log_file_add_column (LOGDB *, gint pos, gint field, gint width);
gint log_file_delete_column (LOGDB *, gint pos);

gint log_file_qso_append (LOGDB *, const qso_t *);
gint log_file_qso_foreach (LOGDB *,
			   gint (*fn) (LOGDB *, qso_t *, gpointer arg),
			   gpointer arg);
/*
	qso_t* get_qso_from_nr(nr)
	update_qso(nr, qso_t)
	delete_qso(nr)
 */

gint parse_field_name (const gchar * s);
gint parse_field_width (const gint field);
const gchar *strfield (gint field);
const gchar *stroldfield (gint field);
gint scan_month (const gchar * s);

#endif /* _LOGFILE_H */
