/*
 * Tlf - contest logging program for amateur radio operators
 * Copyright (C) 2001-2002-2003 Rein Couperus <pa0rct@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
	/* ------------------------------------------------------------
 	*   write cabrillo  file
 	*
 	*--------------------------------------------------------------*/

#include "writecabrillo.h"
#include "printcall.h"
#include "curses.h"

	int  write_cabrillo(void)
	{
	extern int trxmode;
	extern char backgrnd_str[];
	extern char logfile[];
	extern char call[];
	extern int cqww;
	extern int arrldx_usa;
	extern int other_flg;
	extern int wysiwyg_multi;
	extern int wysiwyg_once;
	extern char mycqzone[];
	extern char exchange[];
	extern int exchange_serial;
	extern int cqwwm2;
	extern int arrlss;
	extern int wpx;

	char buf[181];
	char buffer[82]= "";
	char standardexchange[70] = "";
	int cfile;
	struct stat statbuf;

	FILE *fp1,  *fp2;

	getsummary();
	
	if (strlen(exchange) > 0) strcpy (standardexchange, exchange);

	if  ( (fp1 = fopen(logfile,"r"))  == NULL){
			fprintf(stdout,  "Opening logfile not possible.\n");
			return(1);
		}
	if  ( (fp2 = fopen("./cabrillo","w"))  == NULL){
			fprintf(stdout,  "Opening cbr  file not possible.\n");
			return(2);
		}
	if (strlen(standardexchange) == 0) {
			nicebox (14,  0, 1, 78 , "Exchange used:");
			mvprintw(15, 1,  "                                                       ");
			mvprintw(15, 1,  "");
			attron(COLOR_PAIR(7) | A_STANDOUT);
			echo();
			if (arrlss == 1)
				getnstr(standardexchange,  6);
			else
				getnstr(standardexchange,  3);

			noecho();
	}

while ( !feof(fp1))
	{
		fgets (buf,  180,  fp1);

		if (buf[0] != ';'){

		buffer[0] = '\0';

		strcat(buffer, "QSO: ");

		if  (buf[1]  == '6')
			strcat(buffer, " 1800");
		else  if (buf[1] ==  '8')
			strcat(buffer," 3500");
		else  if (buf[1] ==  '4')
			strcat(buffer," 7000");
		else  if (buf[1] ==  '2')
			strcat(buffer,"14000");
		else  if (buf[1] ==  '1' &&  buf[2] ==  '5')
			strcat(buffer,"21000");
		else  if (buf[1] ==  '1' &&  buf[2] ==  '0')
			strcat(buffer, "28000");

		if (buf[3] == 'C')
			strcat(buffer, " CW 20");
		else if (buf[3] == 'S')
			strcat(buffer, " PH 20");
		else
			strcat(buffer, "DIG 20");

		strncat(buffer, buf+14, 2); /* year */

		if (buf[10] == 'J' && buf[11] == 'a')
			strcat(buffer, "-01-");
		if (buf[10] == 'F')
			strcat(buffer, "-02-");
		if (buf[10] == 'M' && buf[12] == 'r')
			strcat(buffer, "-03-");
		if (buf[10] == 'A' && buf[12] == 'r')
			strcat(buffer, "-04-");
		if (buf[10] == 'M' && buf[12] == 'y')
			strcat(buffer, "-05-");
		if (buf[10] == 'J' && buf[11] == 'u' &&buf[12] == 'n')
			strcat(buffer, "-06-");
		if (buf[10] == 'J' && buf[12] == 'l')
			strcat(buffer, "-07-");
		if (buf[10] == 'A' && buf[12] == 'g')
			strcat(buffer, "-08-");
		if (buf[10] == 'S')
			strcat(buffer, "-09-");
		if (buf[10] == 'O')
			strcat(buffer, "-10-");
		if (buf[10] == 'N')
			strcat(buffer, "-11-");
		if (buf[10] == 'D')
			strcat(buffer, "-12-");

		strncat(buffer, buf+7, 2);
		strncat(buffer, buf+16, 3);
		strncat(buffer, buf+20, 3);
		strncat(buffer, call, strlen(call) -1);         /* strip the \n */
		strncat(buffer, backgrnd_str, 15 - strlen(call));

			if (arrlss ==1) {

		sprintf(buffer + 41 , "%4d", atoi(buf+22));
		strcat(buffer, "                    ");
		sprintf(buffer + 46, "%c" , standardexchange[0]);
		strcat(buffer, "                    ");
		sprintf(buffer + 48, "%2d", atoi(standardexchange + 1));
		strcat(buffer, "                    ");
		sprintf(buffer + 51, "%s", standardexchange+3);
		strcat(buffer, "                    ");

		sprintf(buffer + 55, "%s", buf + 29);
		strcat(buffer, "                    ");
		sprintf(buffer + 66, "%4d", atoi(buf+54));
		strcat(buffer, "                    ");
		sprintf(buffer + 71, "%c", buf[59]);
		strcat(buffer, "                    ");
		sprintf(buffer + 72, "%s", buf + 60);
		strcat(buffer, "                    ");
		sprintf(buffer + 75, "%s", buf + 63);
		strcat(buffer, "                    ");
		buffer[79] = '\0';
		strcat(buffer, "\n");

		}   else {


			if (buf[3] == 'S')
				strcat(buffer, "59  ");
			else
				strcat(buffer, "599 ");


			if (other_flg == 1|| wysiwyg_multi == 1 || wysiwyg_once == 1) {


				strcat(buffer, standardexchange);
				strncat(buffer, "            ", 7 - strlen(standardexchange));


			} /* end other (wysiwyg) */

			else if ((wpx == 1) || (standardexchange[0] == '#')){
				strncat(buffer, buf+23,5);
			}

			else if (cqww == 1){
				strcat(buffer, mycqzone);
				strcat(buffer, "     ");
			}

			else if (arrldx_usa == 1)
			{
				strncat(buffer, exchange, 2);
				strcat (buffer, "     ");

			}
			else {
				strncat(buffer, standardexchange, 10);
				strncat (buffer, "     ", strlen(buffer)-8);

			}

			strncat(buffer, buf+29, 14);

			if (buf[3] == 'S')
				strcat(buffer, "59  ");
			else
				strcat(buffer, "599 ");

			strncat(buffer, buf+54, 4);
			strcat(buffer, "  ");



		if ((cqww == 1) && (cqwwm2 == 1)) {               // cqww M2 mode

			if (buf[79] == '*')   {
				strcat(buffer, " 1\n");


			}
			else
				strcat(buffer, " 0\n");
		}  else
			strcat(buffer, " 0\n");

	}       // end else arrlss

		if (strlen(buffer) > 1) fputs(buffer,fp2);

		}


	}

	fclose(fp1);
	fclose(fp2);


	if ((cfile = open("cabrillo", O_RDWR)) < 0){

			mvprintw(24,0, "I can not find the cabrillo file...");
			refresh();
			sleep(2);
	}  else {
			fstat(cfile,  &statbuf);

			if(statbuf.st_size > 81)
				ftruncate(cfile, statbuf.st_size - 82);

			close(cfile);
	}

	fp2 = fopen("cabrillo","a");
	fputs("\nEND-OF-LOG:\n", fp2);
	fclose(fp2);

	system("cat cabrillo >> header");
	system("cp header cabrillo");
	system ("mv header summary.txt");


	return(0);
	}

