/*
 * bltInit.c --
 *
 * Copyright 1993 by AT&T Bell Laboratories.
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for any purpose and without fee is hereby
 * granted, provided that the above copyright notice appear in all
 * copies and that both that the copyright notice and warranty
 * disclaimer appear in supporting documentation, and that the
 * names of AT&T Bell Laboratories any of their entities not be used
 * in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * AT&T disclaims all warranties with regard to this software, including
 * all implied warranties of merchantability and fitness.  In no event
 * shall AT&T be liable for any special, indirect or consequential
 * damages or any damages whatsoever resulting from loss of use, data
 * or profits, whether in an action of contract, negligence or other
 * tortuous action, arising out of or in connection with the use or
 * performance of this software.
 *
 */

#include <tcl.h>

/*
 * The inclusion of contributed commands/widgets can be suppressed by
 * defining the respective preprocessor symbol.  
 */

#ifndef NO_HTEXT
EXTERN void Blt_HtextInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_GRAPH
EXTERN void Blt_GraphInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_BARCHART
EXTERN void Blt_BarchartInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_TABLE
EXTERN void Blt_TableInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_BUSY
EXTERN void Blt_BusyInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_WINDOW
EXTERN void Blt_WindowInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_BITMAP
EXTERN void Blt_BitmapInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_BGEXEC
EXTERN void Blt_BgExecInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_INCRTCL
EXTERN void iTclInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_DRAGDROP
EXTERN int Blt_DragDropInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_DEBUG
EXTERN void Blt_DebugInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_BELL
EXTERN void Blt_BellInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif
#ifndef NO_CUTBUFFER
EXTERN void Blt_CutbufferInit _ANSI_ARGS_((Tcl_Interp *interp));
#endif

int
Blt_Init(interp)
    Tcl_Interp *interp;		/* Interpreter to add extra commands */
{
    char *libDir;

    libDir = Tcl_GetVar2(interp, "env", "BLT_LIBRARY", TCL_GLOBAL_ONLY);
    if (libDir == NULL) {
	libDir = BLT_LIBRARY;
    }
    Tcl_SetVar2(interp, "blt_library", (char *)NULL, libDir, TCL_GLOBAL_ONLY);

#ifndef NO_HTEXT
    Blt_HtextInit(interp);
#endif
#ifndef NO_GRAPH
    Blt_GraphInit(interp);
#endif
#ifndef NO_BARCHART
    Blt_BarchartInit(interp);
#endif
#ifndef NO_TABLE
    Blt_TableInit(interp);
#endif
#ifndef NO_BUSY
    Blt_BusyInit(interp);
#endif
#ifndef NO_WINDOW
    Blt_WindowInit(interp);
#endif
#ifndef NO_DRAGDROP
    if (Blt_DragDropInit(interp) != TCL_OK) {
	return TCL_ERROR;
    }
#endif
#ifndef NO_BELL
    Blt_BellInit(interp);
#endif
#ifndef NO_CUTBUFFER
    Blt_CutbufferInit(interp);
#endif
#ifndef NO_BITMAP
    Blt_BitmapInit(interp);
#endif
#ifndef NO_BGEXEC
    Blt_BgExecInit(interp);
#endif
#ifndef NO_DEBUG
    Blt_DebugInit(interp);
#endif
    return TCL_OK;
}
