## Lout output

sub lout_init {
    open(LOUT,">$prefix.lout");
    chop($dprint= `date '+%d %B %Y'`);
    $dprint =~ s/^0//;
    print LOUT <<END;
@Use { @DocumentLayout
  @PageTopFormat { //0c }
  @PageFootFormat { { Linux FAQ } |0.5rt { - @PageNum - } |1.0rt { $dprint } //0.5c }
  @ParaGap { 1.70vx }
  @InitialBreak { ragged }
}
END
    $lout_textstatus= 'p';
}

sub lout_pageref {
    print LOUT "Q$_[1] (page {@PageOf{$_[0]}}) ";
}

sub lout_finish {
    print LOUT "@End @Text\n";
    close(L);
}

sub lout_startmajorheading {
    $lout_styles .= 'h';
    print LOUT <<END
@CNP
{
  newpath   0  ysize 0.3 ft sub  moveto
            xsize  0  rlineto
            0  0.2 ft  rlineto
            xsize neg  0  rlineto
  closepath fill
} @Graphic { //1.6f @HAdjust @Heading{
END
    ;
    $endh= "}\n{@PageMark $_[0]}\n/1.0fo\n";
}

sub lout_startminorheading {
    $lout_styles .= 'h';
    print LOUT "//0.2f @CNP {@PageMark $_[0]} @Heading{\n";
    $endh= '';
}

sub lout_endheading {
    $lout_styles =~ s/.$//; print LOUT "}\n$endh";
    $lout_status= 'p';
}

sub lout_courier {
    $lout_styles .= 'f';
    print LOUT "{{0.7 1.0} @Scale {Courier Bold} @Font {";
}

sub lout_endcourier {
    $lout_styles =~ s/.$//; print LOUT "}}";
}

sub lout_italic { $lout_styles .= 'f'; print LOUT "{Slope @Font {"; }
sub lout_enditalic { $lout_styles =~ s/.$//; print LOUT "}}"; }

sub lout_startindent { $lout_styles .= 'i'; print LOUT "@IndentedDisplay {\n"; }

sub lout_endindent {
    &lout_endpara;
    $lout_styles =~ s/.$//; print LOUT "}\n@LP\n";
}

sub lout_startlist {
    print LOUT "@BulletList {\n";
    $lout_styles .= 'l';
    $lout_status= '';
}

sub lout_endlist {
    &lout_endpara;
    print LOUT "}\n\n";
    $lout_styles =~ s/.$//;
}

sub lout_item {
    &lout_endpara;
    print LOUT "@ListItem{";
    $lout_styles.= 'I';
}

sub lout_startindex {
    print LOUT "//0.0fe\n";
}

sub lout_endindex {
    $lout_status='p';
}

sub lout_startindexmainitem {
    $lout_marker= $_[0];
    $lout_status= '';
    print LOUT "//0.3fx Bold @Font @HAdjust { @HContract { { $_[1] } |3cx {";
    $lout_styles .= 'X';
}

sub lout_startindexitem {
    $lout_marker= $_[0];
    print LOUT "@HAdjust { @HContract { { $_[1] } |3cx {";
    $lout_styles .= 'X';
}

sub lout_endindexitem {
    print LOUT "} } |0c @PageOf { $lout_marker } } //1.0fx\n";
    $lout_styles =~ s/.$//;
}

sub lout_text {
    $lout_status= 'p';
    $_= &lout_sanitise($_[0]);
    s/ $/\n/ unless $lout_styles =~ m/[fhX]/;
    print LOUT $_;
}

sub lout_tab {
    local ($size) = $_[0]*0.5;
    print LOUT " |${size}ft ";
}

sub lout_newline {
    print LOUT " //1.0fx\n";
}

sub lout_sanitise {
    local ($in) = @_;
    local ($out);
    $in= ' '.$in.' ';
    $out='';
    while ($in =~ m/(\s)(\S*[@\/|\\\"\^\&\{\}\#]\S*)(\s)/) {
        $out .= $`.$1;
        $in = $3.$';
        $_= $2;
        s/\\\"/\\$&/g;
        $out .= '"'.$_.'"';
    }
    $out .= $in;
    $out =~ s/^ //;  $out =~ s/ $//;
    $out;
}

sub lout_endpara {
    return if $lout_status eq '';
    if ($lout_styles eq '') {
        print LOUT "@LP\n\n";
    } elsif ($lout_styles =~ s/I$//) {
        print LOUT "}\n";
    }
    $lout_status= '';
}

sub lout_startverbatim {
    print LOUT "//0.4f\n@RawIndentedDisplay lines @Break".
               " { {0.7 1.0} @Scale {Courier Bold} @Font {\n";
}

sub lout_verbatim {
    $_= $_[0];
    s/^\s*//;
    print LOUT &lout_sanitise($_),"\n";
}

sub lout_endverbatim { print LOUT "}\n}\n//0.4f\n"; }

1;
