%token EOL NUMBER LITERAL KEYCODE EQUALS SHIFT CONTROL ALT ALTGR STRING STRLITERAL

%{
#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <fcntl.h>
#include <linux/kd.h>
#include <linux/keyboard.h>
#include "analyze.c"

static void defkey(int index, int table, int keycode);
int key_buf[16];
int mod;
int fd;
%}

%%
keytable	:
		| keytable line
		;
line		: EOL
		| fullline
		| singleline
		| strline
		;
strline		: STRING LITERAL EQUALS STRLITERAL EOL
			{
				if (KTYP($2) != KT_FN) {
					printf("'%s' is not a function key symbol\n",
						syms[KTYP($2)].table[KVAL($2)]);
					exit(1);
				}
				buf.kb_func = KVAL($2);
				if (ioctl(fd, KDSKBSENT, (unsigned long)&buf))
					fprintf(stderr, "failed to bind string '%s' to function %s\n",
						buf.kb_string, syms[KT_FN].table[buf.kb_func]);
			}
		;
singleline	:	{ mod = 0; }
		  modifiers KEYCODE NUMBER EQUALS rvalue EOL
			{
				defkey($4, mod, $6);
			}
		;
modifiers	: modifiers modifier
		| modifier
		;
modifier	: SHIFT		{ mod |= (1 << KG_SHIFT);	}
		| CONTROL	{ mod |= (1 << KG_CTRL);	}
		| ALT		{ mod |= (1 << KG_ALT);		}
		| ALTGR		{ mod |= (1 << KG_ALTGR);	}
		;
fullline	: KEYCODE NUMBER EQUALS rvalue0 EOL
			{
			int i;

			for (i = 0; i < $4; i++)
				defkey($2, i, key_buf[i]);
			if ($4 == 1) {
				int c = key_buf[0];

				if (KTYP(c) != KT_LATIN)
					for (i = 1; i < NR_KEYMAPS; i++)
						defkey($2, i, c);
				else if (tolower(c) >= 'a' && tolower(c) <= 'z') {
					c = toupper(c);
					defkey($2, 0, c + 32);
					defkey($2, 1, c);		/* shift */
					defkey($2, 2, K_HOLE);		/* altgr */
					defkey($2, 3, K_HOLE);
					defkey($2, 4, c - 64);		/* ctrl */
					defkey($2, 5, c - 64);		/* ctrl-shift */
					defkey($2, 6, K_HOLE);
					defkey($2, 7, K_HOLE);
					defkey($2, 8, K(KT_META, c+32)); /* alt */
					defkey($2, 9, K(KT_META, c));	/* shift-alt */
					defkey($2, 10, K_HOLE);
					defkey($2, 11, K_HOLE);
					defkey($2, 12, K(KT_META, c-64)); /* ctrl-alt */
					defkey($2, 13, K(KT_META, c-64)); /* ctrl-shift-alt */
					i = 14;
				}
			}
			for (; i < NR_KEYMAPS; i++)
				defkey($2, i, K_HOLE);
			}
		;

rvalue0		: { $$ = 0; }
		| rvalue rvalue1
			{
			key_buf[0] = $1;
			$$ = $2 + 1;
			}
		;
rvalue1		: { $$ = 0; }
		| rvalue rvalue2
			{
			key_buf[1] = $1;
			$$ = $2 + 1;
			}
		;
rvalue2		: { $$ = 0; }
		| rvalue rvalue3
			{
			key_buf[2] = $1;
			$$ = $2 + 1;
			}
		;
rvalue3		: { $$ = 0; }
		| rvalue rvalue4
			{
			key_buf[3] = $1;
			$$ = $2 + 1;
			}
		;
rvalue4		: { $$ = 0; }
		| rvalue rvalue5
			{
			key_buf[4] = $1;
			$$ = $2 + 1;
			}
		;
rvalue5		: { $$ = 0; }
		| rvalue rvalue6
			{
			key_buf[5] = $1;
			$$ = $2 + 1;
			}
		;
rvalue6		: { $$ = 0; }
		| rvalue rvalue7
			{
			key_buf[6] = $1;
			$$ = $2 + 1;
			}
		;
rvalue7		: { $$ = 0; }
		| rvalue rvalue8
			{
			key_buf[7] = $1;
			$$ = $2 + 1;
			}
		;
rvalue8		: { $$ = 0; }
		| rvalue rvalue9
			{
			key_buf[8] = $1;
			$$ = $2 + 1;
			}
		;
rvalue9		: { $$ = 0; }
		| rvalue rvalue10
			{
			key_buf[9] = $1;
			$$ = $2 + 1;
			}
		;
rvalue10	: { $$ = 0; }
		| rvalue rvalue11
			{
			key_buf[10] = $1;
			$$ = $2 + 1;
			}
		;
rvalue11	: { $$ = 0; }
		| rvalue rvalue12
			{
			key_buf[11] = $1;
			$$ = $2 + 1;
			}
		;
rvalue12	: { $$ = 0; }
		| rvalue rvalue13
			{
			key_buf[12] = $1;
			$$ = $2 + 1;
			}
		;
rvalue13	: { $$ = 0; }
		| rvalue rvalue14
			{
			key_buf[13] = $1;
			$$ = $2 + 1;
			}
		;
rvalue14	: { $$ = 0; }
		| rvalue rvalue15
			{
			key_buf[14] = $1;
			$$ = $2 + 1;
			}
		;
rvalue15	: { $$ = 0; }
		| rvalue
			{
			key_buf[15] = $1;
			$$ = 1;
			}
		;
rvalue		: NUMBER
			{$$=$1;}
		| LITERAL
			{$$=$1;}
		;
%%			

char **args;

int main(unsigned int argc, char *argv[]) {

	args = argv;
	if (argc > 2) {
		fprintf(stderr,"usage: %s [map_file...]\n", argv[0]);
		exit(1);
	}
	if (argc >= 2) {
		if (freopen(argv[1], "r", stdin) == NULL) {
			fprintf(stderr, "cannot open file %s\n", argv[1]);
			exit(1);
		}
	}
	if ((fd = open("/dev/console", O_RDONLY)) < 0) {
		fprintf(stderr, "cannot open console for ioctl\n");
		exit(1);
	}
	if (yyparse()) {
		fprintf(stderr,"syntax error in map file\n");
		exit(1);
	}
	exit(0);
}

yyerror(char *s) {
	fprintf(stderr, "line %d: %s\n", line_nr, s);
}

#undef yywrap
yywrap(void) {
	if (!++args)
		return 1;
	if (freopen(*args, "r", stdin) == NULL) {
		fprintf(stderr, "cannot open file %s\n", *args);
		exit(1);
	}
	return 0;
}

static void defkey(int index, int table, int keycode) {
	struct kbentry ke;

	if (keycode == -1)
		return;

	ke.kb_index = index;
	ke.kb_table = table;
	ke.kb_value = keycode;

#if 0
printf("keycode %d, table %d = %d\n", index, table, keycode);
#else
	if (ioctl(fd, KDSKBENT, (unsigned long)&ke))
		fprintf(stderr, "failed to bind key %d to value %d\n",
			index, keycode);
#endif
}
