%{
#include <linux/kd.h>
	int	line_nr=1;
	int	yylval;
	struct kbsentry buf;
	char *p;
%}

%s RVALUE
%x STR
Eol			\n
Blank			[ \t]
Decimal			[1-9][0-9]*
Octal			0[0-7]*
Hex			0[xX][0-9a-fA-F]+
Literal			[a-zA-Z][a-zA-Z_0-9]*
Octa			([0-7]){1,3}
Keycode			[kK][eE][yY][cC][oO][dD][eE]
String			[sS][tT][rR][iI][nN][gG]
Equals			=
Shift			[sS][hH][iI][fF][tT]
Control			[cC][oO][nN][tT][rR][oO][lL]
Alt			[aA][lL][tT]
AltGr			[aA][lL][tT][gG][rR]
Meta			[mM][eE][tT][aA]
Comment			#|!
%%
{Eol}			{line_nr++;BEGIN(0);return(EOL);}
{Blank}+		; /* do nothing */
{Comment}.*/{Eol}	; /* do nothing */
{Equals}		{BEGIN(RVALUE);return(EQUALS);}
{Decimal}|{Octal}|{Hex}	{yylval=strtol(yytext,NULL,0);return(NUMBER);}
<RVALUE>{Literal}	{yylval=ksymtocode(yytext);return(LITERAL);}
<RVALUE>\'.\'		{yylval=yytext[1];return(LITERAL);}
<RVALUE>{Meta}\-{Literal} {yylval=K(KT_META,ksymtocode(yytext+5));return(LITERAL);}
<RVALUE>{Meta}\-\'.\'	{yylval=K(KT_META,yytext[6]);return(LITERAL);}
{Keycode}		{return(KEYCODE);}
{String}		{BEGIN(RVALUE);return(STRING);}
{Shift}			{return(SHIFT);}
{Control}		{return(CONTROL);}
{Alt}			{return(ALT);}
{AltGr}			{return(ALTGR);}
\"			{p=buf.kb_string;BEGIN(STR);}
<STR>\\{Octa}		{*p++=strtol(yytext+1,NULL,8);}
<STR>\\n		{*p++='\n';}
<STR>[^"\\]*		{strcpy(p,yytext);p+=strlen(yytext);}
<STR>\"			{*p='\0';BEGIN(0);return(STRLITERAL);}
%%
#include "ksyms.h"
#include <linux/keyboard.h>

static struct sym_code {
	char *keysym;
	int code;
}
depr[] = {
	{ "Shift_L",	K_SHIFT },
	{ "Shift_R",	K_SHIFT },
	{ "Control_L",	K_CTRL },
	{ "Control_R",	K_CTRL },
	{ "AltGr_L",	K_ALTGR }
};

int ksymtocode(char *s)
{
	int i;
	int j;

	for (i = 0; i < syms_size; i++)
		for (j = 0; j < syms[i].size; j++)
			if (!strcmp(s,syms[i].table[j]))
				return K(i, j);

	for (i = 0; i < sizeof(depr) / sizeof(struct sym_code); i++)
		if (!strcmp(s, depr[i].keysym)) {
			j = depr[i].code;
			printf("symbol `%s' deprecated, use `%s' instead\n",
				s, syms[KTYP(j)].table[KVAL(j)]);
			return j;
		}

	fprintf(stderr, "unknown keysym '%s'\n", s);
	return -1;
}
