/* libnotes.vapi generated by valac 0.56.17, do not modify. */

namespace Xnp {
	namespace FileUtils {
		[CCode (cheader_filename = "libnotes.h")]
		public static bool path_exists (string path);
		[CCode (cheader_filename = "libnotes.h")]
		public static bool validate_text_file (GLib.File file);
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class Application : GLib.Object {
		public bool external_event;
		public bool system_tray_mode;
		public Application (string config_file);
		public Gtk.Menu context_menu ();
		public Xnp.Window? create_window (string? name = null);
		public unowned GLib.SList<Xnp.Window> get_window_list ();
		public void open_about_dialog ();
		public void open_settings_dialog ();
		public void quit ();
		public void save_notes ();
		public bool save_windows_configuration ();
		public void show_hide_notes ();
		public Application.with_notes_path (string config_file, string notes_path);
		public string config_file { get; construct; }
		public Xnp.Window? next_focus { get; }
		public string notes_path { get; set construct; }
		public bool skip_taskbar_hint { get; set; }
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class HypertextView : Gtk.SourceView {
		public HypertextView ();
		public string get_text_with_tags ();
		public void insert_checkbox (bool checked = false);
		public new void redo ();
		public void set_text_with_tags (string text);
		public void toggle_tag (string tag_name);
		public new void undo ();
		public void update_tags ();
		public string font { get; set; }
	}
	[CCode (cheader_filename = "libnotes.h")]
	public abstract class IconButton : Gtk.EventBox {
		protected bool active;
		protected IconButton ();
		public override void add (Gtk.Widget widget);
		public override bool draw (Cairo.Context cr);
		protected abstract void draw_icon (Cairo.Context cr, int width, int height);
		protected void set_widget_source_color (Cairo.Context cr);
		public bool enabled { get; set; }
		public signal void clicked ();
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class Note : Gtk.ScrolledWindow {
		public bool backed;
		public ulong save_handler_id;
		public ulong tab_handler_id;
		public Xnp.HypertextView text_view;
		public Note (string name);
		public void save ();
		public double adjustment { get; set; }
		public int cursor { get; set; }
		public bool dirty { get; set; }
		public new string name { get; set; }
		public string text { owned get; set; }
		public signal void save_data ();
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class Theme : GLib.Object {
		public Theme ();
		public void use_color (string color);
		public void use_gtk_style ();
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class ThemeGtkcss : GLib.Object {
		public ThemeGtkcss ();
		public void update_color_css (Gdk.RGBA rgba);
		public bool use_gtk_style { get; set; }
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class TitleBarButton : Xnp.IconButton {
		public TitleBarButton (Xnp.TitleBarButtonType icon_type);
		protected override void draw_icon (Cairo.Context cr, int width, int height);
		public Xnp.TitleBarButtonType icon_type { get; set construct; }
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class Window : Gtk.Window {
		public Xnp.WindowMonitor monitor;
		public Window (Xnp.Application app);
		public int compare_func (Xnp.Window win2);
		public void connect_note_signals (Xnp.Note note, Gtk.EventBox tab_evbox);
		public void delete_current_note ();
		public void dialog_destroy (Gtk.Dialog dialog);
		public void dialog_hide (Gtk.Dialog dialog);
		public void disconnect_note_signals (Xnp.Note note, Gtk.EventBox tab_evbox);
		public void externally_removed (string note_name);
		public Xnp.Note? find_note_by_name (string name);
		public int get_current_page ();
		public void get_geometry (out int winx, out int winy, out int width, out int height);
		public string[] get_note_names ();
		public Gtk.EventBox get_tab_evbox (Xnp.Note note);
		public new void hide ();
		public Xnp.Note insert_note (string? name = null);
		public void move_note (string note_name, int page);
		public bool note_file_exists (string file_name);
		public bool note_name_exists (string name);
		public void popup_error (string message);
		public void rename_current_note ();
		public void rename_note (string note_name, string new_name);
		public void save_notes ();
		public void set_current_page (int page);
		public bool above { get; set; }
		public Xnp.Note current_note { get; }
		public bool empty { get; }
		public int n_pages { get; }
		public new string name { get; set; }
		public bool show_tabs { get; set; }
		public bool sticky { get; set; }
		public int tabs_position { get; set; }
		public signal void action (string action);
		[Signal (action = true)]
		public signal void action_cycle_backward ();
		[Signal (action = true)]
		public signal void action_cycle_forward ();
		public signal void note_deleted (Xnp.Note note);
		public signal void note_inserted (Xnp.Note note);
		public signal bool note_moved (Xnp.Window src_win, Xnp.Note note);
		public signal void note_renamed (Xnp.Note note, string name);
		public signal void save_data (Xnp.Note note);
	}
	[CCode (cheader_filename = "libnotes.h")]
	public class WindowMonitor : GLib.Object {
		public WindowMonitor (GLib.File path);
		public void internal_change ();
		public signal void note_created (string note_name);
		public signal void note_deleted (string note_name);
		public signal bool note_exists (GLib.File file);
		public signal void note_renamed (string note_name, string new_name);
		public signal void note_updated (string note_name);
	}
	[CCode (cheader_filename = "libnotes.h")]
	public enum TitleBarButtonType {
		EMPTY,
		CLOSE,
		LEFT_ARROW,
		RIGHT_ARROW
	}
}
