/* file-utils.c generated by valac 0.56.17, the Vala compiler
 * generated from file-utils.vala, do not modify */

/*
 *  Notes - panel plugin for Xfce Desktop Environment
 *  Copyright (c) 2024       Arthur Demchenkov <spinal.by@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
 */

#include "libnotes.h"
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

gboolean
xnp_file_utils_validate_text_file (GFile* file)
{
	gboolean _result_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (file != NULL, FALSE);
	_result_ = FALSE;
	{
		gchar* valid_end = NULL;
		guint8* content = NULL;
		guint8* _tmp0_;
		gint content_length1;
		gint _content_size_;
		const gchar* str = NULL;
		guint8* _tmp1_;
		gint _tmp1__length1;
		GFileInputStream* stream = NULL;
		GFileInputStream* _tmp2_;
		gssize length = 0L;
		GFileInputStream* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		gboolean _tmp5_ = FALSE;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gboolean _tmp8_;
		_tmp0_ = g_new0 (guint8, 4096);
		content = _tmp0_;
		content_length1 = 4096;
		_content_size_ = content_length1;
		_tmp1_ = content;
		_tmp1__length1 = content_length1;
		str = (const gchar*) _tmp1_;
		_tmp2_ = g_file_read (file, NULL, &_inner_error0_);
		stream = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			content = (g_free (content), NULL);
			goto __catch0_g_error;
		}
		_tmp3_ = stream;
		_tmp4_ = content;
		_tmp4__length1 = content_length1;
		length = g_input_stream_read ((GInputStream*) _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (stream);
			content = (g_free (content), NULL);
			goto __catch0_g_error;
		}
		_tmp6_ = str;
		_tmp8_ = g_utf8_validate (_tmp6_, length, &_tmp7_);
		valid_end = _tmp7_;
		if (_tmp8_) {
			_tmp5_ = TRUE;
		} else {
			gchar* _tmp9_;
			guint8* _tmp10_;
			gint _tmp10__length1;
			_tmp9_ = valid_end;
			_tmp10_ = content;
			_tmp10__length1 = content_length1;
			_tmp5_ = (_tmp9_ - ((gchar*) _tmp10_)) > ((gsize) (length - 6));
		}
		_result_ = _tmp5_;
		_g_object_unref0 (stream);
		content = (g_free (content), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp11_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp11_;
	}
	result = _result_;
	return result;
}

gboolean
xnp_file_utils_path_exists (const gchar* path)
{
	gboolean result;
	g_return_val_if_fail (path != NULL, FALSE);
	result = g_file_test (path, G_FILE_TEST_EXISTS);
	return result;
}

