/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.7.9
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/sysopt.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>


PyDoc_STRVAR(doc_wxSystemOptions_SetOption, "SetOption(name, value)\n"
"SetOption(name, value)\n"
"\n"
"Sets an option.\n"
"");

extern "C" {static PyObject *meth_wxSystemOptions_SetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_SetOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;
        const  ::wxString* value;
        int valueState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1J1", sipType_wxString, &name, &nameState, sipType_wxString, &value, &valueState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxSystemOptions::SetOption(*name,*value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);
            sipReleaseType(const_cast< ::wxString *>(value), sipType_wxString, valueState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    {
        const  ::wxString* name;
        int nameState = 0;
        int value;

        static const char *sipKwdList[] = {
            sipName_name,
            sipName_value,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1i", sipType_wxString, &name, &nameState, &value))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
             ::wxSystemOptions::SetOption(*name,value);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_SetOption, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSystemOptions_GetOption, "GetOption(name) -> String\n"
"\n"
"Gets an option.");

extern "C" {static PyObject *meth_wxSystemOptions_GetOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_GetOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &name, &nameState))
        {
             ::wxString*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxString( ::wxSystemOptions::GetOption(*name));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxString,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_GetOption, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSystemOptions_GetOptionInt, "GetOptionInt(name) -> int\n"
"\n"
"Gets an option as an integer.");

extern "C" {static PyObject *meth_wxSystemOptions_GetOptionInt(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_GetOptionInt(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &name, &nameState))
        {
            int sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::GetOptionInt(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_GetOptionInt, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSystemOptions_HasOption, "HasOption(name) -> bool\n"
"\n"
"Returns true if the given option is present.");

extern "C" {static PyObject *meth_wxSystemOptions_HasOption(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_HasOption(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::HasOption(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_HasOption, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxSystemOptions_IsFalse, "IsFalse(name) -> bool\n"
"\n"
"Returns true if the option with the given name had been set to 0\n"
"value.");

extern "C" {static PyObject *meth_wxSystemOptions_IsFalse(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxSystemOptions_IsFalse(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxString* name;
        int nameState = 0;

        static const char *sipKwdList[] = {
            sipName_name,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1", sipType_wxString, &name, &nameState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes =  ::wxSystemOptions::IsFalse(*name);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(name), sipType_wxString, nameState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_SystemOptions, sipName_IsFalse, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxSystemOptions(void *, const sipTypeDef *);}
static void *cast_wxSystemOptions(void *sipCppV, const sipTypeDef *targetType)
{
     ::wxSystemOptions *sipCpp = reinterpret_cast< ::wxSystemOptions *>(sipCppV);

    if (targetType == sipType_wxSystemOptions)
        return sipCppV;

    if (targetType == sipType_wxObject)
        return static_cast< ::wxObject *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxSystemOptions(void *, int);}
static void release_wxSystemOptions(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxSystemOptions *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxSystemOptions(Py_ssize_t);}
static void *array_wxSystemOptions(Py_ssize_t sipNrElem)
{
    return new  ::wxSystemOptions[sipNrElem];
}


extern "C" {static void assign_wxSystemOptions(void *, Py_ssize_t, void *);}
static void assign_wxSystemOptions(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxSystemOptions *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxSystemOptions *>(sipSrc);
}


extern "C" {static void *copy_wxSystemOptions(const void *, Py_ssize_t);}
static void *copy_wxSystemOptions(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new  ::wxSystemOptions(reinterpret_cast<const  ::wxSystemOptions *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxSystemOptions(sipSimpleWrapper *);}
static void dealloc_wxSystemOptions(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxSystemOptions(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxSystemOptions(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxSystemOptions(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxSystemOptions *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemOptions();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxSystemOptions* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxSystemOptions, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxSystemOptions(*a0);
            Py_END_ALLOW_THREADS

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxSystemOptions[] = {{392, 255, 1}};


static PyMethodDef methods_wxSystemOptions[] = {
    {sipName_GetOption, SIP_MLMETH_CAST(meth_wxSystemOptions_GetOption), METH_VARARGS|METH_KEYWORDS, doc_wxSystemOptions_GetOption},
    {sipName_GetOptionInt, SIP_MLMETH_CAST(meth_wxSystemOptions_GetOptionInt), METH_VARARGS|METH_KEYWORDS, doc_wxSystemOptions_GetOptionInt},
    {sipName_HasOption, SIP_MLMETH_CAST(meth_wxSystemOptions_HasOption), METH_VARARGS|METH_KEYWORDS, doc_wxSystemOptions_HasOption},
    {sipName_IsFalse, SIP_MLMETH_CAST(meth_wxSystemOptions_IsFalse), METH_VARARGS|METH_KEYWORDS, doc_wxSystemOptions_IsFalse},
    {sipName_SetOption, SIP_MLMETH_CAST(meth_wxSystemOptions_SetOption), METH_VARARGS|METH_KEYWORDS, doc_wxSystemOptions_SetOption}
};

PyDoc_STRVAR(doc_wxSystemOptions, "SystemOptions()\n"
"\n"
"wxSystemOptions stores option/value pairs that wxWidgets itself or\n"
"applications can use to alter behaviour at run-time.");


sipClassTypeDef sipTypeDef__core_wxSystemOptions = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxSystemOptions,
        SIP_NULLPTR,
        SIP_NULLPTR
    },
    {
        sipNameNr_SystemOptions,
        {0, 0, 1},
        5, methods_wxSystemOptions,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxSystemOptions,
    -1,
    -1,
    supers_wxSystemOptions,
    SIP_NULLPTR,
    init_type_wxSystemOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxSystemOptions,
    assign_wxSystemOptions,
    array_wxSystemOptions,
    copy_wxSystemOptions,
    release_wxSystemOptions,
    cast_wxSystemOptions,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
};
