#!/usr/bin/env bash
set -euxo pipefail

ACTION=$2

SSH_COMMAND="ssh -i $SSH_KEY $SSH_USER@review.dev.storj.io -o StrictHostKeyChecking=no -p 29418"

case $ACTION in
start)
  $SSH_COMMAND gerrit review "$(git rev-parse HEAD)" --message \"build $1 is started: $BUILD_URL\" --tag autogenerated:gerrit-integration --label Verified=$3
  ;;

failure)
  $SSH_COMMAND gerrit review "$(git rev-parse HEAD)" --message \"build $1 is failed: $BUILD_URL\" --tag autogenerated:gerrit-integration --label Verified=$3
  ;;

success)
  $SSH_COMMAND gerrit review "$(git rev-parse HEAD)" --message \"build $1 is finished successfully: $BUILD_URL\" --tag autogenerated:gerrit-integration --label Verified=$3
  ;;

*)
  echo "Action is missing"
  exit 1
  ;;

esac
