/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "ContentPrefs.h"

/******************************************************************************
 *
 *           DO NOT ADD PREFS TO THIS LIST WITHOUT DOM PEER REVIEW
 *
 * This is the list of preferences that are sent to the content process on
 * startup. Only prefs that are required immediately upon startup should be
 * listed here. The first IPC message received in the content process will
 * contain all the other prefs. Prefs should only be listed here if they must be
 * read before the first IPC message is received.
 *
 ******************************************************************************/

const char* mozilla::dom::ContentPrefs::gEarlyPrefs[] = {
  "accessibility.monoaudio.enable",
  "accessibility.mouse_focuses_formcontrol",
  "accessibility.tabfocus_applies_to_xul",
  "app.update.channel",
  "browser.autofocus",
  "browser.dom.window.dump.enabled",
  "browser.sessionhistory.max_entries",
  "browser.sessionhistory.max_total_viewers",
#if defined(NIGHTLY_BUILD) || defined(DEBUG)
  "browser.startup.record",
#endif
  "content.cors.disable",
  "content.cors.no_private_data",
  "content.notify.backoffcount",
  "content.notify.interval",
  "content.notify.ontimer",
  "content.sink.enable_perf_mode",
  "content.sink.event_probe_rate",
  "content.sink.initial_perf_time",
  "content.sink.interactive_deflect_count",
  "content.sink.interactive_parse_time",
  "content.sink.interactive_time",
  "content.sink.pending_event_mode",
  "content.sink.perf_deflect_count",
  "content.sink.perf_parse_time",
  "device.storage.prompt.testing",
  "device.storage.writable.name",
  "devtools.enabled",
  "dom.allow_XUL_XBL_for_file",
  "dom.allow_cut_copy",
  "dom.animations-api.core.enabled",
  "dom.animations-api.element-animate.enabled",
  "dom.animations-api.pending-member.enabled",
  "dom.enable_frame_timing",
  "dom.enable_performance",
  "dom.enable_performance_navigation_timing",
  "dom.enable_resource_timing",
  "dom.event.handling-user-input-time-limit",
  "dom.event.touch.coalescing.enabled",
  "dom.forms.autocomplete.formautofill",
  "dom.forms.inputmode",
  "dom.input.skip_cursor_move_for_same_value_set",
  "dom.ipc.processPriorityManager.backgroundGracePeriodMS",
  "dom.ipc.processPriorityManager.backgroundPerceivableGracePeriodMS",
  "dom.ipc.useNativeEventProcessing.content",
  "dom.max_chrome_script_run_time",
  "dom.max_ext_content_script_run_time",
  "dom.max_script_run_time",
  "dom.mozBrowserFramesEnabled",
  "dom.performance.enable_notify_performance_timing",
  "dom.performance.enable_user_timing_logging",
  "dom.placeholder.show_on_focus",
  "dom.requestIdleCallback.enabled",
  "dom.script_loader.bytecode_cache.enabled",
  "dom.script_loader.bytecode_cache.strategy",
  "dom.storage.testing",
  "dom.url.encode_decode_hash",
  "dom.url.getters_decode_hash",
  "dom.use_watchdog",
  "dom.vibrator.enabled",
  "dom.vibrator.max_vibrate_list_len",
  "dom.vibrator.max_vibrate_ms",
  "dom.webcomponents.customelements.enabled",
  "dom.webcomponents.enabled",
  "focusmanager.testmode",
  "font.size.inflation.disabledInMasterProcess",
  "font.size.inflation.emPerLine",
  "font.size.inflation.forceEnabled",
  "font.size.inflation.lineThreshold",
  "font.size.inflation.mappingIntercept",
  "font.size.inflation.maxRatio",
  "font.size.inflation.minTwips",
  "font.size.systemFontScale",
  "full-screen-api.allow-trusted-requests-only",
  "full-screen-api.enabled",
  "full-screen-api.unprefix.enabled",
#ifdef FUZZING
  "fuzzing.enabled",
#endif
  "gfx.font_rendering.opentype_svg.enabled",
  "hangmonitor.timeout",
  "html5.flushtimer.initialdelay",
  "html5.flushtimer.subsequentdelay",
  "html5.offmainthread",
  "intl.charset.fallback.tld",
  "intl.charset.fallback.utf8_for_file",
  "intl.ime.hack.on_ime_unaware_apps.fire_key_events_for_composition",
  "javascript.enabled",
  "javascript.options.array_prototype_values",
  "javascript.options.asmjs",
  "javascript.options.asyncstack",
  "javascript.options.baselinejit",
  "javascript.options.baselinejit.threshold",
  "javascript.options.baselinejit.unsafe_eager_compilation",
  "javascript.options.discardSystemSource",
  "javascript.options.dump_stack_on_debuggee_would_run",
  "javascript.options.gczeal",
  "javascript.options.gczeal.frequency",
  "javascript.options.ion",
  "javascript.options.ion.offthread_compilation",
  "javascript.options.ion.threshold",
  "javascript.options.ion.unsafe_eager_compilation",
  "javascript.options.jit.full_debug_checks",
  "javascript.options.native_regexp",
  "javascript.options.parallel_parsing",
  "javascript.options.shared_memory",
  "javascript.options.spectre.index_masking",
  "javascript.options.streams",
  "javascript.options.strict",
  "javascript.options.strict.debug",
  "javascript.options.throw_on_asmjs_validation_failure",
  "javascript.options.throw_on_debuggee_would_run",
  "javascript.options.unboxed_objects",
  "javascript.options.wasm",
  "javascript.options.wasm_baselinejit",
  "javascript.options.wasm_ionjit",
  "javascript.options.werror",
  "javascript.use_us_english_locale",
  "jsloader.shareGlobal",
  "layout.css.all-shorthand.enabled",
  "layout.css.background-blend-mode.enabled",
  "layout.css.box-decoration-break.enabled",
  "layout.css.color-adjust.enabled",
  "layout.css.column-span.enabled",
  "layout.css.contain.enabled",
  "layout.css.control-characters.visible",
  "layout.css.emulate-moz-box-with-flex",
  "layout.css.expensive-style-struct-assertions.enabled",
  "layout.css.float-logical-values.enabled",
  "layout.css.font-display.enabled",
  "layout.css.font-variations.enabled",
  "layout.css.frames-timing.enabled",
  "layout.css.getBoxQuads.enabled",
  "layout.css.grid-template-subgrid-value.enabled",
  "layout.css.grid.enabled",
  "layout.css.image-orientation.enabled",
  "layout.css.individual-transform.enabled",
  "layout.css.initial-letter.enabled",
  "layout.css.isolation.enabled",
  "layout.css.mix-blend-mode.enabled",
  "layout.css.moz-document.content.enabled",
  "layout.css.osx-font-smoothing.enabled",
  "layout.css.overflow-clip-box.enabled",
  "layout.css.overscroll-behavior.enabled",
  "layout.css.prefixes.animations",
  "layout.css.prefixes.border-image",
  "layout.css.prefixes.box-sizing",
  "layout.css.prefixes.device-pixel-ratio-webkit",
  "layout.css.prefixes.font-features",
  "layout.css.prefixes.gradients",
  "layout.css.prefixes.transforms",
  "layout.css.prefixes.transitions",
  "layout.css.prefixes.webkit",
  "layout.css.scope-pseudo.enabled",
  "layout.css.scroll-behavior.property-enabled",
  "layout.css.scroll-snap.enabled",
#ifdef MOZ_STYLO
  "layout.css.servo.chrome.enabled",
  "layout.css.servo.enabled",
#endif
  "layout.css.shape-outside.enabled",
#ifdef MOZ_STYLO
  "layout.css.stylo-blocklist.blocked_domains",
  "layout.css.stylo-blocklist.enabled",
#endif
  "layout.css.text-align-unsafe-value.enabled",
  "layout.css.text-combine-upright-digits.enabled",
  "layout.css.text-combine-upright.enabled",
  "layout.css.text-justify.enabled",
  "layout.css.touch_action.enabled",
  "layout.css.visited_links_enabled",
  "layout.idle_period.required_quiescent_frames",
  "layout.idle_period.time_limit",
  "layout.interruptible-reflow.enabled",
  "mathml.disabled",
  "media.audio-max-decode-error",
  "media.cache_readahead_limit",
  "media.cache_resume_threshold",
  "media.cache_size",
  "media.clearkey.persistent-license.enabled",
  "media.cubeb.backend",
  "media.cubeb.sandbox",
  "media.cubeb_latency_msg_frames",
  "media.cubeb_latency_playback_ms",
  "media.decoder-doctor.wmf-disabled-is-failure",
  "media.decoder.recycle.enabled",
  "media.decoder.skip-to-next-key-frame.enabled",
  "media.dormant-on-pause-timeout-ms",
  "media.eme.audio.blank",
  "media.eme.chromium-api.video-shmems",
  "media.eme.enabled",
  "media.eme.video.blank",
  "media.ffmpeg.enabled",
  "media.ffmpeg.low-latency.enabled",
  "media.ffvpx.enabled",
  "media.ffvpx.low-latency.enabled",
  "media.flac.enabled",
  "media.forcestereo.enabled",
  "media.gmp.decoder.enabled",
  "media.gmp.insecure.allow",
  "media.gpu-process-decoder",
  "media.hls.enabled",
  "media.libavcodec.allow-obsolete",
  "media.memory_cache_max_size",
  "media.memory_caches_combined_limit_kb",
  "media.memory_caches_combined_limit_pc_sysmem",
  "media.mp4.enabled",
  "media.navigator.mediadatadecoder_enabled",
  "media.ogg.enabled",
  "media.ogg.flac.enabled",
  "media.playback.warnings-as-errors",
  "media.resampling.enabled",
  "media.resume-bkgnd-video-on-tabhover",
  "media.ruin-av-sync.enabled",
  "media.rust.mp4parser",
  "media.seamless-looping",
  "media.suspend-bkgnd-video.delay-ms",
  "media.suspend-bkgnd-video.enabled",
  "media.use-blank-decoder",
  "media.video-max-decode-error",
  "media.video_stats.enabled",
  "media.videocontrols.lock-video-orientation",
  "media.volume_scale",
  "media.webspeech.recognition.enable",
  "media.webspeech.recognition.force_enable",
  "media.webspeech.synth.force_global_queue",
  "media.webspeech.test.enable",
  "media.webspeech.test.fake_fsm_events",
  "media.webspeech.test.fake_recognition_service",
  "media.wmf.allow-unsupported-resolutions",
  "media.wmf.enabled",
  "media.wmf.skip-blacklist",
  "media.wmf.vp9.enabled",
  "network.IDN.blacklist_chars",
  "network.IDN.restriction_profile",
  "network.IDN.use_whitelist",
  "network.IDN_show_punycode",
  "network.buffer.cache.count",
  "network.buffer.cache.size",
  "network.captive-portal-service.enabled",
  "network.cookie.cookieBehavior",
  "network.cookie.lifetimePolicy",
  "network.dns.disablePrefetch",
  "network.dns.disablePrefetchFromHTTPS",
  "network.file.disable_unc_paths",
  "network.http.tailing.enabled",
  "network.jar.block-remote-files",
  "network.loadinfo.skip_type_assertion",
  "network.notify.changed",
  "network.offline-mirrors-connectivity",
  "network.protocol-handler.external.jar",
  "network.proxy.type",
  "network.security.ports.banned",
  "network.security.ports.banned.override",
  "network.standard-url.enable-rust",
  "network.standard-url.max-length",
  "network.standard-url.punycode-host",
  "network.sts.max_time_for_events_between_two_polls",
  "network.sts.max_time_for_pr_close_during_shutdown",
  "network.tcp.keepalive.enabled",
  "network.tcp.keepalive.idle_time",
  "network.tcp.keepalive.probe_count",
  "network.tcp.keepalive.retry_interval",
  "network.tcp.sendbuffer",
  "nglayout.debug.invalidation",
  "privacy.donottrackheader.enabled",
  "privacy.firstparty.isolate",
  "privacy.firstparty.isolate.restrict_opener_access",
  "privacy.reduceTimerPrecision",
  "privacy.resistFingerprinting",
  "privacy.resistFingerprinting.reduceTimerPrecision.microseconds",
  "privacy.resistFingerprinting.target_video_res",
  "privacy.resistFingerprinting.video_dropped_ratio",
  "privacy.resistFingerprinting.video_frames_per_sec",
  "privacy.trackingprotection.lower_network_priority",
  "privacy.window.maxInnerHeight",
  "privacy.window.maxInnerWidth",
  "security.csp.enable",
  "security.data_uri.block_toplevel_data_uri_navigations",
  "security.data_uri.unique_opaque_origin",
  "security.fileuri.strict_origin_policy",
  "security.mixed_content.block_active_content",
  "security.mixed_content.block_display_content",
  "security.mixed_content.block_object_subrequest",
  "security.mixed_content.hsts_priming_cache_timeout",
  "security.mixed_content.send_hsts_priming",
  "security.mixed_content.use_hsts",
  "security.sandbox.content.level",
  "security.sandbox.content.tempDirSuffix",
  "security.sandbox.logging.enabled",
  "security.sandbox.mac.track.violations",
  "security.sandbox.windows.log.stackTraceDepth",
  "svg.disabled",
  "svg.display-lists.hit-testing.enabled",
  "svg.display-lists.painting.enabled",
  "svg.new-getBBox.enabled",
  "svg.path-caching.enabled",
  "svg.transform-box.enabled",
  "toolkit.asyncshutdown.crash_timeout",
  "toolkit.asyncshutdown.log",
  "toolkit.osfile.log",
  "toolkit.osfile.log.redirect",
  "toolkit.telemetry.enabled",
  "toolkit.telemetry.idleTimeout",
  "toolkit.telemetry.initDelay",
  "toolkit.telemetry.log.dump",
  "toolkit.telemetry.log.level",
  "toolkit.telemetry.minSubsessionLength",
  "toolkit.telemetry.scheduler.idleTickInterval",
  "toolkit.telemetry.scheduler.tickInterval",
  "toolkit.telemetry.unified",
  "ui.key.menuAccessKeyFocuses",
  "ui.popup.disable_autohide",
  "ui.use_activity_cursor",
  "view_source.editor.external",
  "zoom.maxPercent",
  "zoom.minPercent"
};

const char** mozilla::dom::ContentPrefs::GetEarlyPrefs(size_t* aCount)
{
  *aCount = ArrayLength(ContentPrefs::gEarlyPrefs);
  return gEarlyPrefs;
}

const char* mozilla::dom::ContentPrefs::GetEarlyPref(size_t aIndex)
{
  MOZ_ASSERT(aIndex < ArrayLength(ContentPrefs::gEarlyPrefs));
  return gEarlyPrefs[aIndex];
}
