import warnings

from PyObjCTools.TestSupport import TestCase, min_os_level

with warnings.catch_warnings():
    warnings.filterwarnings("ignore")
    import LaunchServices


class TestUTCoreTypes(TestCase):
    def testConstants(self):
        self.assertIsInstance(LaunchServices.kUTTypeItem, str)
        self.assertIsInstance(LaunchServices.kUTTypeContent, str)
        self.assertIsInstance(LaunchServices.kUTTypeCompositeContent, str)
        self.assertIsInstance(LaunchServices.kUTTypeApplication, str)
        self.assertIsInstance(LaunchServices.kUTTypeMessage, str)
        self.assertIsInstance(LaunchServices.kUTTypeContact, str)
        self.assertIsInstance(LaunchServices.kUTTypeArchive, str)
        self.assertIsInstance(LaunchServices.kUTTypeDiskImage, str)
        self.assertIsInstance(LaunchServices.kUTTypeData, str)
        self.assertIsInstance(LaunchServices.kUTTypeDirectory, str)
        self.assertIsInstance(LaunchServices.kUTTypeResolvable, str)
        self.assertIsInstance(LaunchServices.kUTTypeSymLink, str)
        self.assertIsInstance(LaunchServices.kUTTypeMountPoint, str)
        self.assertIsInstance(LaunchServices.kUTTypeAliasFile, str)
        self.assertIsInstance(LaunchServices.kUTTypeAliasRecord, str)
        self.assertIsInstance(LaunchServices.kUTTypeURL, str)
        self.assertIsInstance(LaunchServices.kUTTypeFileURL, str)
        self.assertIsInstance(LaunchServices.kUTTypeText, str)
        self.assertIsInstance(LaunchServices.kUTTypePlainText, str)
        self.assertIsInstance(LaunchServices.kUTTypeUTF8PlainText, str)
        self.assertIsInstance(LaunchServices.kUTTypeUTF16ExternalPlainText, str)
        self.assertIsInstance(LaunchServices.kUTTypeUTF16PlainText, str)
        self.assertIsInstance(LaunchServices.kUTTypeRTF, str)
        self.assertIsInstance(LaunchServices.kUTTypeHTML, str)
        self.assertIsInstance(LaunchServices.kUTTypeXML, str)
        self.assertIsInstance(LaunchServices.kUTTypeSourceCode, str)
        self.assertIsInstance(LaunchServices.kUTTypeCSource, str)
        self.assertIsInstance(LaunchServices.kUTTypeObjectiveCSource, str)
        self.assertIsInstance(LaunchServices.kUTTypeCPlusPlusSource, str)
        self.assertIsInstance(LaunchServices.kUTTypeObjectiveCPlusPlusSource, str)
        self.assertIsInstance(LaunchServices.kUTTypeCHeader, str)
        self.assertIsInstance(LaunchServices.kUTTypeCPlusPlusHeader, str)
        self.assertIsInstance(LaunchServices.kUTTypeJavaSource, str)
        self.assertIsInstance(LaunchServices.kUTTypePDF, str)
        self.assertIsInstance(LaunchServices.kUTTypeRTFD, str)
        self.assertIsInstance(LaunchServices.kUTTypeFlatRTFD, str)
        self.assertIsInstance(LaunchServices.kUTTypeTXNTextAndMultimediaData, str)
        self.assertIsInstance(LaunchServices.kUTTypeWebArchive, str)
        self.assertIsInstance(LaunchServices.kUTTypeImage, str)
        self.assertIsInstance(LaunchServices.kUTTypeJPEG, str)
        self.assertIsInstance(LaunchServices.kUTTypeJPEG2000, str)
        self.assertIsInstance(LaunchServices.kUTTypeTIFF, str)
        self.assertIsInstance(LaunchServices.kUTTypePICT, str)
        self.assertIsInstance(LaunchServices.kUTTypeGIF, str)
        self.assertIsInstance(LaunchServices.kUTTypePNG, str)
        self.assertIsInstance(LaunchServices.kUTTypeQuickTimeImage, str)
        self.assertIsInstance(LaunchServices.kUTTypeAppleICNS, str)
        self.assertIsInstance(LaunchServices.kUTTypeBMP, str)
        self.assertIsInstance(LaunchServices.kUTTypeICO, str)
        self.assertIsInstance(LaunchServices.kUTTypeAudiovisualContent, str)
        self.assertIsInstance(LaunchServices.kUTTypeMovie, str)
        self.assertIsInstance(LaunchServices.kUTTypeVideo, str)
        self.assertIsInstance(LaunchServices.kUTTypeAudio, str)
        self.assertIsInstance(LaunchServices.kUTTypeQuickTimeMovie, str)
        self.assertIsInstance(LaunchServices.kUTTypeMPEG, str)
        self.assertIsInstance(LaunchServices.kUTTypeMPEG4, str)
        self.assertIsInstance(LaunchServices.kUTTypeMP3, str)
        self.assertIsInstance(LaunchServices.kUTTypeMPEG4Audio, str)
        self.assertIsInstance(LaunchServices.kUTTypeAppleProtectedMPEG4Audio, str)
        self.assertIsInstance(LaunchServices.kUTTypeFolder, str)
        self.assertIsInstance(LaunchServices.kUTTypeVolume, str)
        self.assertIsInstance(LaunchServices.kUTTypePackage, str)
        self.assertIsInstance(LaunchServices.kUTTypeBundle, str)
        self.assertIsInstance(LaunchServices.kUTTypeFramework, str)
        self.assertIsInstance(LaunchServices.kUTTypeApplicationBundle, str)
        self.assertIsInstance(LaunchServices.kUTTypeApplicationFile, str)
        self.assertIsInstance(LaunchServices.kUTTypeVCard, str)
        self.assertIsInstance(LaunchServices.kUTTypeInkText, str)

    @min_os_level("10.10")
    def testConstants10_10(self):
        self.assertIsInstance(LaunchServices.kUTTypeURLBookmarkData, str)
        self.assertIsInstance(LaunchServices.kUTTypeDelimitedText, str)
        self.assertIsInstance(LaunchServices.kUTTypeCommaSeparatedText, str)
        self.assertIsInstance(LaunchServices.kUTTypeTabSeparatedText, str)
        self.assertIsInstance(LaunchServices.kUTTypeUTF8TabSeparatedText, str)
        self.assertIsInstance(LaunchServices.kUTTypeAssemblyLanguageSource, str)
        self.assertIsInstance(LaunchServices.kUTTypeScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeAppleScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeOSAScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeOSAScriptBundle, str)
        self.assertIsInstance(LaunchServices.kUTTypeJavaScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeShellScript, str)
        self.assertIsInstance(LaunchServices.kUTTypePerlScript, str)
        self.assertIsInstance(LaunchServices.kUTTypePythonScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeRubyScript, str)
        self.assertIsInstance(LaunchServices.kUTTypePHPScript, str)
        self.assertIsInstance(LaunchServices.kUTTypeJSON, str)
        self.assertIsInstance(LaunchServices.kUTTypePropertyList, str)
        self.assertIsInstance(LaunchServices.kUTTypeXMLPropertyList, str)
        self.assertIsInstance(LaunchServices.kUTTypeBinaryPropertyList, str)
        self.assertIsInstance(LaunchServices.kUTTypeRawImage, str)
        self.assertIsInstance(LaunchServices.kUTTypeScalableVectorGraphics, str)
        self.assertIsInstance(LaunchServices.kUTTypeMPEG2Video, str)
        self.assertIsInstance(LaunchServices.kUTTypeMPEG2TransportStream, str)
        self.assertIsInstance(LaunchServices.kUTTypeAppleProtectedMPEG4Video, str)
        self.assertIsInstance(LaunchServices.kUTTypeAVIMovie, str)
        self.assertIsInstance(LaunchServices.kUTTypeAudioInterchangeFileFormat, str)
        self.assertIsInstance(LaunchServices.kUTTypeWaveformAudio, str)
        self.assertIsInstance(LaunchServices.kUTTypeMIDIAudio, str)
        self.assertIsInstance(LaunchServices.kUTTypePlaylist, str)
        self.assertIsInstance(LaunchServices.kUTTypeM3UPlaylist, str)
        self.assertIsInstance(LaunchServices.kUTTypePluginBundle, str)
        self.assertIsInstance(LaunchServices.kUTTypeSpotlightImporter, str)
        self.assertIsInstance(LaunchServices.kUTTypeQuickLookGenerator, str)
        self.assertIsInstance(LaunchServices.kUTTypeXPCService, str)
        self.assertIsInstance(LaunchServices.kUTTypeUnixExecutable, str)
        self.assertIsInstance(LaunchServices.kUTTypeWindowsExecutable, str)
        self.assertIsInstance(LaunchServices.kUTTypeJavaClass, str)
        self.assertIsInstance(LaunchServices.kUTTypeJavaArchive, str)
        self.assertIsInstance(LaunchServices.kUTTypeSystemPreferencesPane, str)
        self.assertIsInstance(LaunchServices.kUTTypeGNUZipArchive, str)
        self.assertIsInstance(LaunchServices.kUTTypeBzip2Archive, str)
        self.assertIsInstance(LaunchServices.kUTTypeZipArchive, str)
        self.assertIsInstance(LaunchServices.kUTTypeSpreadsheet, str)
        self.assertIsInstance(LaunchServices.kUTTypePresentation, str)
        self.assertIsInstance(LaunchServices.kUTTypeToDoItem, str)
        self.assertIsInstance(LaunchServices.kUTTypeCalendarEvent, str)
        self.assertIsInstance(LaunchServices.kUTTypeEmailMessage, str)
        self.assertIsInstance(LaunchServices.kUTTypeInternetLocation, str)
        self.assertIsInstance(LaunchServices.kUTTypeFont, str)
        self.assertIsInstance(LaunchServices.kUTTypeBookmark, str)
        self.assertIsInstance(LaunchServices.kUTType3DContent, str)
        self.assertIsInstance(LaunchServices.kUTTypePKCS12, str)
        self.assertIsInstance(LaunchServices.kUTTypeX509Certificate, str)
        self.assertIsInstance(LaunchServices.kUTTypeElectronicPublication, str)
        self.assertIsInstance(LaunchServices.kUTTypeLog, str)

    @min_os_level("10.11")
    def testConstants10_11(self):
        self.assertIsInstance(LaunchServices.kUTTypeSwiftSource, str)
