#!/bin/sh -e

##########################################################################
#   Script description:
#       Split a BED file containing feature info into major features
#       such as genes and pseudogenes.  Major features are separated
#       by lines containing ###.  The BED file is typically the augmented
#       conversion of a GFF generated by peak-classifier.
#       
#   History:
#   Date        Name        Modification
#   2021-06-13  Jason Bacon Begin
##########################################################################

usage()
{
    printf "Usage: $0 file.bed\n"
    exit 1
}


##########################################################################
#   Main
##########################################################################

if [ $# != 1 ]; then
    usage
fi
bed_file=$1

dir=Genes-${bed_file%.bed}
mkdir -p $dir

if which mawk > /dev/null 2>&1; then
    awk=mawk
else
    awk=awk
fi
$awk -v dir=$dir -f extract-genes.awk $bed_file
