/**********************************************************************************************************************
 * DISCLAIMER
 * This software is supplied by Renesas Electronics Corporation and is only intended for use with Renesas products. No
 * other uses are authorized. This software is owned by Renesas Electronics Corporation and is protected under all
 * applicable laws, including copyright laws.
 * THIS SOFTWARE IS PROVIDED "AS IS" AND RENESAS MAKES NO WARRANTIES REGARDING
 * THIS SOFTWARE, WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. ALL SUCH WARRANTIES ARE EXPRESSLY DISCLAIMED. TO THE MAXIMUM
 * EXTENT PERMITTED NOT PROHIBITED BY LAW, NEITHER RENESAS ELECTRONICS CORPORATION NOR ANY OF ITS AFFILIATED COMPANIES
 * SHALL BE LIABLE FOR ANY DIRECT, INDIRECT, SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES FOR ANY REASON RELATED TO
 * THIS SOFTWARE, EVEN IF RENESAS OR ITS AFFILIATES HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 * Renesas reserves the right, without notice, to make changes to this software and to discontinue the availability of
 * this software. By using this software, you agree to the additional terms and conditions found by accessing the
 * following link:
 * http://www.renesas.com/disclaimer
 *
 * Copyright (C) 2020 Renesas Electronics Corporation. All rights reserved.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * File Name    : s_flash2.c
 * Version      : 1.01
 * Description  : Key information file.
 *********************************************************************************************************************/
/**********************************************************************************************************************
 * History : DD.MM.YYYY Version  Description
 *         : 05.10.2020 1.00        First Release.
 *         : 02.12.2020 1.01        Added new functions such as the Brainpool curve.
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Includes   <System Includes> , "Project Includes"
 *********************************************************************************************************************/
#include "r_sce_if.h"

/**********************************************************************************************************************
 Macro definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Typedef definitions
 *********************************************************************************************************************/

/**********************************************************************************************************************
 Exported global variables
 *********************************************************************************************************************/
uint32_t const S_FLASH2[] =
{
#ifndef __ARMEB__   /* Little endian */
    0xa97e88e5, 0x9367f2d1, 0x6dbef413, 0x21635d62,
    0xa7ea11b6, 0xa9d276b7, 0x7d7794a2, 0x1873a29a,
    0x3e9c40cb, 0x0b8d4dbf, 0x73aeb933, 0xeb14cc91,
    0xc9131cfb, 0xc8e97751, 0x2b99db2b, 0xbe9d8767,
    0x8337b2e7, 0xff52a52d, 0x2a3f3a98, 0x9ee442f7,
    0x96e8a825, 0x33a27277, 0x3557abc7, 0x60b4c293,
    0x4de50db9, 0x501f6b02, 0xe99df0c2, 0x62783de7,
    0x189e7165, 0xeb0c54cd, 0xace3726a, 0x526970ed,
    0xb02d40d2, 0xc78a767e, 0xff870b4e, 0x7e7750eb,
    0x08e8363a, 0x96a21e3f, 0x5a93eb79, 0x751468eb,
    0x62109752, 0x9a00a6eb, 0xa5e4af0a, 0x3ba56a15,
    0x76f059a9, 0x1271cd0e, 0x7fb4a5df, 0x28a35a93,
    0x2c7cd2a9, 0x1b4eda82, 0xc4b7552f, 0x0d9e1a58,
    0xafc3ea92, 0xaf3b31d3, 0x96415f8a, 0xcb1ccfd5,
    0x5c27f5d0, 0x8598cfde, 0xc0761a48, 0xe8c8a684,
    0x803e6a0f, 0x48f1f0b3, 0x5ab98cc1, 0xfb24c087,
    0x4d3bb2e8, 0xba6c49bc, 0x7bfbeaef, 0xf7032f75,
    0xd598e9bd, 0x997311a9, 0x4827aa63, 0xd28d9e73,
    0x5d66676a, 0x68361bae, 0x02bb891e, 0xda3fd64d,
    0x05763c5a, 0x21d77097, 0xbb647ced, 0xf1ec875b,
    0x63bd802b, 0x24c1a0ab, 0x74cdfddd, 0xd557679e,
    0xe71bf79b, 0x61148bc5, 0x446b1873, 0xff7467e5,
    0x8504aee6, 0x532c69a1, 0x00df9576, 0x52a87387,
    0x06f5aad8, 0xb1c0b047, 0xda6af29d, 0xec4a121c,
    0x55356c0e, 0x1d582a44, 0xb12df61e, 0x77252975,
    0x105eb488, 0xe01f2550, 0xc4ad4c34, 0x00e2c6aa,
    0xef48405a, 0x84370d7d, 0x180847e1, 0x91421fa6,
    0x1dd1191e, 0x51762fa4, 0xba7f6d2e, 0x9fee58ad,
    0x7723437d, 0xdac3b188, 0xdc615c16, 0x22bda7dd,
    0x01f1b6ed, 0x735f9242, 0xe3f92375, 0xc14c3c57,
    0xaf02d0be, 0xc7953bcd, 0x3ce43d75, 0xd0f26c0f,
    0x15a6baa5, 0x1cd55c9a, 0xba585795, 0x4a34bfdb,
    0xd10041c4, 0x790d5a7c, 0x403efe1d, 0xc368e331,
    0x05b2b426, 0x7df201c2, 0xd5d56897, 0xe8f3340b,
    0x925849c6, 0x63c03afd, 0x2d4ce596, 0x0bd72787,
    0x51e10cc4, 0x19fc7c4e, 0x583de3c5, 0x5db86155,
    0x5555f5bd, 0xec96f0e3, 0xfb58fbc1, 0x812997d8,
    0xcdb0111a, 0x6c37393a, 0xede922e7, 0x945a51d2,
    0xbcbb9315, 0x3ea7242f, 0x9505420f, 0x490d7d17,
    0x7a9623e5, 0xc9386691, 0xe826fc95, 0x9b4af647,
    0x74a8f50e, 0x870ea4e7, 0x1533eb0a, 0x29616e0b,
    0x285933dc, 0x02a0d596, 0x3b781c4c, 0x3eb05458,
    0x1e3e275c, 0x3a159d48, 0x73ebe204, 0x468acc45,
    0x85cf6a1d, 0xd1055350, 0xe0e4f622, 0x1304e990,
    0x09e4aa7e, 0x72e7ee98, 0xb1de602f, 0x44beec64,
    0xe26e1dfe, 0xdffdfd01, 0x62c668b4, 0x8245c35c,
    0xbcb225f8, 0x811e185c, 0x7283352f, 0x96c17572,
    0x9ac73d4c, 0x79a5c426, 0x4e61bed9, 0x1a9c0649,
    0x07a3f222, 0xe1aed316, 0x62d97ed7, 0x7fd40d97,
    0x02cc6bc7, 0x179ec919, 0x5d1273dd, 0x393ddfa4,
    0x33a57a1d, 0xad3cbbb2, 0x8f249c68, 0xfe19dc28,
    0x4a5bd96b, 0xf19096dd, 0x3ed59c48, 0x94777cc8,
    0x28c61df6, 0xf56d2df1, 0xe2a87678, 0x4c16b6c0,
    0xb35fbe16, 0xdb30f584, 0x9c5bbcd4, 0x442bd65f,
    0x12dcad82, 0xb575a8b7, 0xbadd7e9b, 0x21388394,
    0x1b738c96, 0xfe123240, 0x7e11bb78, 0xc813085d,
    0xf280bb1a, 0x3bee0a85, 0x2bfea15b, 0x1a1ddc12,
    0x830b641e, 0xda11d02b, 0x290be194, 0x337ce862,
    0x889274b6, 0x65188565, 0x97fdcc19, 0xd1fec76f,
    0xe5c01654, 0x41149690, 0x4fcf9e05, 0xc3d1c46d,
    0x0ca429f7, 0x86c6f8ff, 0xd7557d5b, 0x447735a6,
    0x996fe728, 0x0b96224b, 0x8048bedf, 0xaea8740f,
    0x273553f5, 0xfef21b6a, 0xb69b59fe, 0x2830b136,
    0x8e646d47, 0xbd70f0a7, 0xdca46c07, 0x625f8b13,
    0xdc10e10b, 0x78ed0540, 0x4dec07b9, 0x4b9797b7,
    0x2a74cd0d, 0x0ddeeaba, 0x71579b62, 0x1f869b4c,
    0x70d23a25, 0x8d0685b8, 0x4f1bda6e, 0x564a0ac0,
    0x533a7419, 0x5e17e68f, 0x44afde8d, 0x9600db58,
    0xcb9511d4, 0x8a3a2ae2, 0x2ad3e68b, 0xb4bc03b7,
    0x7a1a50ea, 0xe31dbe23, 0xda6d2dbe, 0xfccad5a0,
    0x0059c6d2, 0xf772170f, 0xbc8cac6a, 0x14da0a87,
    0xf2ec1a1f, 0xa3702b88, 0x15966394, 0x9c3e49b8,
    0x07bc5abc, 0xc1a30c87, 0xe898bb59, 0xf3d1ed4c,
    0xd3b0f9e1, 0x48cee253, 0xdf587104, 0x99773b42,
    0xbca2974c, 0x4c1ef8de, 0x28da0b84, 0x46341861,
    0x96a1dfb3, 0x10fb4725, 0x62a53cf2, 0x31bc54f3,
    0xfb046761, 0xd30d5365, 0x31ba0ef1, 0x60aed6f2,
    0xf022d530, 0xb99836c6, 0x7fcdc95d, 0x2211cbed,
    0xfc503ddc, 0x10c21f64, 0xacf00db4, 0x0b427a47,
    0x8ff773be, 0xdae8f5b9, 0x6ebe5924, 0xdb2460c8,
    0xafcfeb3d, 0x9368e608, 0xf42000c3, 0x2cf59f90,
    0xf7fe2adf, 0x9c552280, 0x44e58bfb, 0x735a3ecc,
    0xb1edfaae, 0xc2b6ceae, 0x9d549823, 0xfe008818,
    0xe2a06be5, 0x0c96afa9, 0x45e0baf4, 0x4dc7f084,
    0xccd00f50, 0xfc75da65, 0x983a17a5, 0x5fd64fad,
    0x338e4250, 0xfbcc2d40, 0x367b4bd7, 0xda2e30c2,
    0x58a8b55c, 0x49fc8b0f, 0x15132c39, 0xad64fa42,
    0x22a90ce0, 0x56cb83c3, 0xbe2bd150, 0x69fc9c11,
    0x44fe0878, 0xdf4c9866, 0x5a07f984, 0x792e6627,
    0x66a46566, 0x4db32f8a, 0xbd05806d, 0x04f1bcba,
    0x868cb837, 0x854f8df5, 0x6c7f55d9, 0x57e8f107,
    0xbcf6988b, 0x8e10ee89, 0xd4ffe0ab, 0x17e715a0,
    0x37148962, 0x43b72722, 0x03b2eb40, 0x6003d14e,
    0x06c74fbb, 0xed7b5cde, 0x8d2ea577, 0xc5fee509,
    0xc843ce52, 0x5bdffac2, 0x020d9e88, 0x2f0b8760,
    0x509d2bff, 0x97f464dd, 0xee55839e, 0xd4a61328,
    0xe76bd4ce, 0x54d7c908, 0x739b5f68, 0x53f814f3,
    0xff638447, 0x1bb93af1, 0x045c82d3, 0x33287474,
    0xf904311b, 0x27264390, 0x645b3078, 0x7768671a,
    0xcce1a520, 0xd9890be0, 0x35d58bb4, 0xcadadee9,
    0x49c31313, 0xfd0c9127, 0xfcc283fa, 0x4b5b8e06,
    0x9ee352c2, 0xbe1914bf, 0x9e97a769, 0x25d2c450,
    0x8542b849, 0xb9daaf9c, 0x42860a34, 0xc5918c84,
    0x2a580252, 0xc2c369c8, 0xabd27275, 0xf2aaac7e,
    0xbaa300dd, 0x39180f20, 0xc0bf3e94, 0xe56053ac,
    0x143d0424, 0x1a7ff8d4, 0x7f06dffe, 0xc076ce66,
    0x518405af, 0x103ccb20, 0xe023bc64, 0xdec520ba,
    0x86e1f9ca, 0xf0361144, 0x665e0314, 0x200dcd6a,
    0x92162fb1, 0x7d2b16f9, 0xed897397, 0x41abce1c,
    0x6b89a607, 0x9beb2abb, 0x5c76ed37, 0x25b97c6f,
    0x12d39ccf, 0xe35a84d0, 0x31968aa2, 0xbb4e7f17,
    0x265075a2, 0x5150e3a9, 0xcc214e98, 0x7a5c1021,
    0xe0037392, 0x30ca7678, 0x30cd8fd7, 0x87cfd362,
    0x03f353cb, 0x5831a5cf, 0xb506259e, 0x7d94dffe,
    0x9304beec, 0x87abd31f, 0x0e81dddc, 0x14adac14,
    0x5e3830ff, 0xed00f55d, 0xbc2ff45c, 0xffb38a2e,
    0x69c30468, 0xf80ba68f, 0xd8464e40, 0xd523bac9,
    0x623e1c2c, 0x278a1f49, 0x1c2b59a7, 0xf10374ff,
    0x23015b76, 0xeb5b389f, 0x1631a01a, 0x7ea30437,
    0xa5a9b11f, 0x3cbad734, 0xc374496e, 0x6e35ef35,
    0xe48f0357, 0xe173f2bf, 0xa75dfda7, 0x16be2987,
    0xd190ea85, 0x910fc8a8, 0x2ca722d3, 0xbf71d925,
    0x65d01ac5, 0x5cff3359, 0x40b84aa4, 0x6b6d0954,
    0x52408f93, 0x04d2cf59, 0xcaf00c4a, 0xb5221edc,
    0x4cfd2789, 0xf1bab227, 0x1bf22068, 0x2c81c491,
    0xbfa25d15, 0x441b4df0, 0x09d9de8a, 0x3347cb31,
    0x7adf3125, 0x62672ad3, 0x4bbfbb9f, 0xf57b75a4,
    0xa0233d5d, 0x60b00ca7, 0x23b841ca, 0xc718c214,
    0x5082684d, 0xeee25b34, 0x52803903, 0x8a51f447,
    0xdb67805b, 0x96833b66, 0xd174c1a5, 0x0f5ee545,
    0x1fc43ced, 0x99c227db, 0x7a0146ec, 0xbdb81b38,
    0xa3d5f003, 0xc5643ce4, 0x1018b54b, 0xe5d82d4b,
    0x4a59932f, 0xf9d91235, 0x518c0dbd, 0x660de337,
    0xc9a64ffc, 0xdbb6a6e4, 0x3d411199, 0xbdd1f96a,
    0x1323eac7, 0x7a928163, 0xccf3d625, 0x3a3502e7,
    0xa4537da8, 0x892c118c, 0xb946dc80, 0x8af172b5,
    0x88f7ba6d, 0x58c786ce, 0x13761cf8, 0xc80beec6,
    0x4a8f622a, 0x48ca6baa, 0x32a9660c, 0xee02a31f,
    0x2c817a10, 0x351a56cd, 0x4af7ce49, 0xc14d2666,
    0xcdeff3d3, 0x3b1c8e6b, 0x063f3657, 0xe546e05c,
    0x603b7339, 0x794057cc, 0x88df1dba, 0xbc442a47,
    0x67ddab33, 0xe7c183aa, 0xdd86777d, 0x7bac3e2c,
    0xb3b42b9b, 0xf955e506, 0xf7764ac7, 0x1f400ad5,
    0x940237ab, 0x098b2da1, 0xabfd0896, 0xabf8c5df,
    0x688ef4d5, 0x09021dfd, 0x821d393c, 0x2ce33f47,
    0x7392d1d8, 0x29d2cbf2, 0xca8727e3, 0x48cea0fb,
    0x6f4371f8, 0xc83b7ed9, 0x79b907f6, 0x54ff8797,
    0x6a32274a, 0xc8a740c5, 0x47807259, 0x32a2a1bb,
    0x2d034fc3, 0x6b4eb2ca, 0x18fb0e25, 0x20a9e8d2,
    0x4342026e, 0x3b56c06a, 0x37e20b60, 0xc4ea21db,
    0xa284b7ca, 0xa21ecb79, 0xb848bcf9, 0xa3460211,
    0x75fe4fb0, 0xf3a72543, 0xbf99d04a, 0xc1a4753b,
    0xeaf92e16, 0xd1164e0f, 0x0be2d5c3, 0xa8a8da35,
    0x661eefde, 0xc65199fc, 0x2d112c74, 0xc3e828cd,
    0xa54b5063, 0x9f4f9ab8, 0xe88439cf, 0x3ff6cd70,
    0x0f330953, 0x13134843, 0xb6a5b16c, 0x2943611f,
    0xe749e30e, 0x3fa9b536, 0x82e0ca78, 0x6f9cc4e6,
    0x1dd83a22, 0x01eade6a, 0x77a96e4a, 0x6f3b389c,
    0x4e7a3bbf, 0x617d0be8, 0x65d0f059, 0x15a49304,
    0xbebeca64, 0x98696bb1, 0x29224dcd, 0x95f785c4,
    0x86e2e92c, 0x74bc92c6, 0xbaf78504, 0x320800c6,
    0x4cc1f145, 0x0ea01105, 0x05b59e00, 0xcbdc815a,
    0xd7b3c257, 0xd08afa51, 0x5ae63462, 0x29f3d6fb,
    0xb7a2dd1a, 0x8529a664, 0x1acc9169, 0xfe87ae3d,
    0xf26e9222, 0x4b907865, 0x08987d01, 0x473d6e0d,
    0x5a0f091a, 0x5f1a6dd5, 0x5bbc4f12, 0x5ec3bfae,
    0xb9f5047f, 0xc5653d1e, 0x16f9bd89, 0x947f2496,
    0x8ebd60d2, 0x9aa27e72, 0xa8f2369d, 0x1572a262,
    0x628323f4, 0x6d896164, 0xaa78f219, 0x72fb6bb5,
    0xf47ae5fb, 0xcb8d6fd2, 0x0e77f409, 0x78d62979,
    0x849af546, 0xac2979ac, 0xffd89672, 0xe8434139,
    0xd6dd8f92, 0x1edaa1ac, 0x91689eea, 0xbec42797,
    0x4a0f84cf, 0x1de31bdd, 0x88e5308f, 0xbef6a8c9,
    0x5dea939b, 0xa6f79274, 0xe5ced6b1, 0xb37ca895,
    0xe63ee49e, 0xa872e3d8, 0xeba8353d, 0x55810932,
    0xb9ad1486, 0xefc6329e, 0x4229d6ea, 0x9adeb857,
    0x8a3d25c1, 0xd731b218, 0x85ddee44, 0xb0820515,
    0x31bef107, 0xe784f639, 0x8b91036a, 0xc909b142,
    0xbfaabdd3, 0xa4fde630, 0x04ea7ad9, 0xd8069c90,
    0x701c0ed7, 0xdc27bfe9, 0x182035cd, 0xf163217d,
    0x8bde8728, 0x3de76b4b, 0x1727193d, 0x6dc73cbf,
    0x548f72b4, 0x5a832952, 0xadcc68bc, 0x5fabd0fd,
    0xfd96ac69, 0xedfb4097, 0xc6a72fbc, 0x2f04e30d,
    0x4f3d5e5a, 0x75b2d6b1, 0x7d40b7a9, 0xe39116ac,
    0xf23776df, 0xea74b874, 0x6b0e0236, 0x1a3236fd,
    0x015ea4a5, 0x37030d18, 0x52f51bb2, 0xfb31a406,
    0xb133ff75, 0x3c60bbab, 0x59c416e9, 0x7103e149,
    0x0be6658e, 0xc5f8f73d, 0x0d988a5d, 0xc4ed0e71,
    0x3e65dbca, 0xcb14f81c, 0xb67956ad, 0xa5c50684,
    0x5835bd0c, 0x3730696b, 0x4bf0f287, 0x78087c67,
    0xaa863c01, 0xe736e736, 0xd8bced25, 0x522d8459,
    0x082eea3e, 0x7cf18dfe, 0xf0fc2868, 0xbfd64c9c,
    0xa074eb38, 0x638f2976, 0x161e5c1e, 0x95005dd6,
    0x88ca210f, 0xd5b13e47, 0xbc5cb4ac, 0x6992c128,
    0xe1900295, 0x2257a841, 0x096cfd92, 0xdec55d62,
    0xf0878bec, 0xb3c4fc12, 0x85b57766, 0x1aa86784,
    0xcc8949d8, 0x9bf18fe0, 0x8aa23170, 0x3d218a88,
    0x4a029bc0, 0x2791265b, 0x3e9882d0, 0x425f6e30,
    0xb775323e, 0x9334de4a, 0x1fe3301e, 0xc0442543,
    0x9fb8e1df, 0xb40b021b, 0x5da189d2, 0xd16e7eb4,
    0x8fecbcb6, 0xf05c7d5e, 0x253324e5, 0x6013163d,
    0x9298188a, 0x14b7fce2, 0x76363224, 0x243d780b,
    0xe05d0c2d, 0x6cdc5a60, 0xbd488af0, 0x2b298037,
    0xed4513ac, 0xe0f5ac19, 0xcae9a014, 0x97b79366,
    0xc9aee2ed, 0x13351f17, 0x96c70caf, 0x076653fd,
    0x3f7afe35, 0xf5c06030, 0x3e4334a8, 0xd425a8f0,
    0xfc7f290a, 0xaa0a90ff, 0xf97681ad, 0x59f0524c,
    0xfc7b83f9, 0xf21edfe4, 0x07fe6a1a, 0x83da8c92,
    0xdb06e2c4, 0xb021d08a, 0xd495dac1, 0x559d0aab,
    0xcf170bcb, 0xebfe13df, 0x03c0ef6b, 0x7a4565c9,
    0xa11c4835, 0x44e2a47f, 0x9d704950, 0xdf996a50,
    0xa0d7eb0e, 0x122b0857, 0xe4855aa6, 0x6e9d2747,
    0xbfb91d1b, 0x3b90c888, 0x5fe9bf6b, 0xb2407b78,
    0x838e633c, 0x16c20177, 0x0321e6ae, 0x71df1826,
    0x7caa5f26, 0x96ab8806, 0xc06dfe41, 0x505da2e6,
    0xa954d80e, 0x40b82273, 0x4386f1e2, 0xb2f947cd,
    0x675a3170, 0x9532537b, 0x762fdb3c, 0xb22e7228,
    0x3b28bb53, 0x8a17d9e1, 0x78c5f07c, 0x4d2df374,
    0x1f8ff85d, 0x5f8af236, 0xc19c0493, 0x5ef3671b,
    0x0711f7fa, 0x3d22b2cd, 0x6f641681, 0x84b9cbad,
    0x830281bb, 0xde280477, 0xfe5a057f, 0x616f9255,
    0xa0ffb83c, 0x842aded8, 0x86cf85da, 0x8940abd0,
    0xdd3e488e, 0x0dab64a4, 0x504bfef9, 0x8d398aaa,
    0xcd43ead3, 0xc2b5ff9b, 0x6ac81f5e, 0xe62dced4,
    0x2909919e, 0x16f352e0, 0x65881229, 0xd2d8acaa,
    0x65f70a6a, 0x0b8a5fc6, 0xa91a425c, 0x438e43c7,
    0xf1f71303, 0x65c41d35, 0xda1fd15c, 0xc9a4c1b9,
    0xde678b74, 0xbe577722, 0xea3924f1, 0x56c6a325,
    0x0f13a8f2, 0x1aea07c5, 0xb9d4b9f2, 0x4a07db18,
    0x73c86815, 0x226d2dfc, 0xbab580ba, 0x21be6ba6,
    0x94b7052e, 0xed03de61, 0x66a19aef, 0xf1b3ed38,
    0x6b7dafc5, 0x1d206b0d, 0x9690b505, 0x0f967889,
    0x2c195871, 0xa90432af, 0x24b5efa2, 0xb1f52492,
    0xc8c2e921, 0x8cec8fe6, 0xf8d4fe42, 0xab2212c3,
    0xc275a15e, 0x9c120bdd, 0x721692ba, 0xe4cb1268,
    0x49acb98b, 0x13860cd3, 0x76d7b85a, 0x16d69dae,
    0x1c737ca5, 0x9eccc24e, 0xd28f1c6c, 0x64bc4bd6,
    0xb58992a4, 0x9bac0bb7, 0x85be6629, 0x49dd9a6b,
    0xd2d5ae1e, 0x1ec75d7b, 0xa7e9c291, 0x2a3aee86,
    0x726971b1, 0x68bb63a2, 0xb503425e, 0x5775805f,
    0xe4dc02a9, 0xcbd8c400, 0x35c86be8, 0x79e0b3af,
    0xbbf681a4, 0xe5d0a875, 0x0ec0d0f8, 0x9ed6a9ec,
    0x5dc5fa4b, 0xe64fca20, 0xde288052, 0x29c0c225,
    0xcb310d63, 0x90acc224, 0xa818c8f7, 0x0c077083,
    0xd25404a4, 0x816862bc, 0xa32852f7, 0xf90d91b0,
    0x81f1d3c0, 0x7fe30fbe, 0xbf53df67, 0x46cd7e3a,
    0x293f1003, 0x7e8a708b, 0xf3a22fd5, 0x1ee08029,
    0xf82e333a, 0xee120124, 0x318341bc, 0x8a923a36,
    0x4c781a4c, 0xa9337bfc, 0x1e155798, 0x0217171a,
    0x77508d8e, 0xea901171, 0xa87f530c, 0x3660fa56,
    0xf3d87636, 0xe1d303aa, 0x3c60d96e, 0x7d4b15ed,
    0x82e6ed54, 0x6c959c04, 0xcbdd2827, 0xcb0bcb8f,
    0x4e808dfd, 0xb8d22b46, 0xf94ab7fa, 0x66db5448,
    0xf4ff6e95, 0x8a6724e4, 0x77dca78c, 0x12e71fc7,
    0x5046bccb, 0x0ade27dc, 0x059dc2c5, 0x19c698b3,
    0xf34f5737, 0xf11f53bb, 0xc8a6e4b1, 0xa7d0a738,
    0xd982d491, 0x0ed59903, 0x9548df4f, 0x6028afd5,
    0x74bee82d, 0x9700dd96, 0x8b8c34b0, 0x08f2125e,
    0x5bb546d7, 0x653fc881, 0x2917abe2, 0x5ac94013,
    0x9c2d5f1d, 0xfece8b17, 0xa67e590b, 0xdc16a9ee,
    0x8298f3d8, 0x75f16049, 0xfaacfb3c, 0x4fe9f9b8,
    0xd868e9c6, 0xef058afa, 0xac570f54, 0x1dd4a599,
    0xb6e111ce, 0x8d57de4c, 0x33ab91ce, 0x772b40c2,
    0x4f877818, 0xc295da38, 0x4dcb6473, 0xe83ad378,
    0x77d70454, 0xc913bc7e, 0xd89f0b02, 0xd257243b,
    0xedd8cdff, 0x2521beab, 0x68c5df9e, 0xe580f947,
    0xb89c6242, 0x959cd105, 0x03d5159e, 0xb4788a7d,
    0xd1008a7e, 0xcad8617a, 0x48669c60, 0x9de4ef78,
    0x4f517fe0, 0x2eb58ec2, 0x9b3ee14e, 0xddc869b6,
    0xe16db5b6, 0x570b1ecd, 0xb1a614f9, 0xd83e4405,
    0x60f1e0a8, 0x3d662f1a, 0xdbb9cb7e, 0xdec496a9,
    0xdd654171, 0x6d3c4e16, 0x88e09967, 0x104984c4,
    0x84c0112f, 0xf1169b6c, 0x77028d49, 0x08e1d448,
    0x0ebc3cdd, 0xba9cc9af, 0x33bec66b, 0xb477b767,
    0x2bb31438, 0x7cf54d08, 0x93794991, 0x1ea91a03,
    0x96ea31ad, 0xcd25d5f3, 0x7466a7df, 0x3e4bcd30,
    0x3bd97ca6, 0x6c9fe12b, 0x1f5d03de, 0xff172fac,
    0x4c4462d0, 0x820813ea, 0xef101884, 0x26c6728b,
    0x8b0533a2, 0xc786ad6d, 0x863b1483, 0xff05a19f,
    0x1c9ba2e5, 0xc3f5ee8c, 0x31a8a75e, 0xb780ad8f,
    0xadccef0d, 0x71b320de, 0x2bebaf18, 0x12c11d84,
    0x2ea4814c, 0xc09436b7, 0x01cb9224, 0x7d1372e4,
    0x71da541a, 0xf7f15add, 0xb7ed54c6, 0x0c8d324e,
    0xc932869a, 0x164ddef4, 0xef3fc071, 0xef4b4bf5,
    0x764fd1a0, 0x1f78d159, 0x5cea38ee, 0xd79917a1,
    0xd9fb3e46, 0x31b2f904, 0x8df7c0b1, 0xdf6b4884,
    0x7e9a34ce, 0x39205f7b, 0x409a1901, 0x63a3bf35,
    0xb544a6c3, 0xfaccd9ff, 0x43bce0b5, 0xb149b7f3,
    0xa0aad6d7, 0xcd086a1b, 0xcfb2e563, 0x8a419617,
    0x69b3ca01, 0xed9992d1, 0xca95b076, 0xc043119b,
    0x76df0789, 0xc7dedb91, 0x2af16340, 0x962bf359,
    0xbc3c4382, 0x3696e0dd, 0x1d799a9b, 0x1f2d7a21,
    0x25fd07de, 0xfdf497c9, 0x006ef6e0, 0x5c9ca8c3,
    0x6ac7ad94, 0x183ec408, 0xe1bb333c, 0x7a583226,
    0xfb1f881b, 0xf70f11ef, 0xbbd7811f, 0xd150d21e,
    0xeb23afa3, 0xfdb3f2c7, 0xe9d3a4be, 0x9a28b72d,
    0x1f0c2d17, 0xd0bcd29a, 0x5c7bf5b1, 0x81dba8f0,
    0xfcd37206, 0xe6642e1b, 0x38cc79e3, 0x293bb08c,
    0xd65cc8bf, 0x4c3a52d2, 0xab6aa13c, 0x250fe7fb,
    0x837a63e7, 0x2197af7f, 0xf6f42a80, 0x27ad39a2,
    0xc676f01c, 0x01959ee1, 0x714cfb31, 0x04cbb5dc,
    0xbd96e699, 0x0245d9db, 0xd37a57ad, 0x1bed9622,
    0xe2fe2df7, 0x16821c8a, 0xe9f1470b, 0xb6f5e02b,
    0xa893af17, 0xe89f83e2, 0xefd5578c, 0x7887a4f3,
    0xdd74f9ab, 0x186a5a0a, 0xfae9aeca, 0x8e2f4cf2,
    0x1c8e5436, 0x6324fe93, 0xae4dbf4e, 0xc6fb94f6,
    0x46536e72, 0x634ef238, 0x92f6d797, 0x998a4495,
    0xbc9045b5, 0x3711c67a, 0x06398c82, 0xd400d007,
    0x9a7ab900, 0x2bac3f07, 0x25287997, 0x3cf6ea82,
    0x8659ba53, 0x04225b0f, 0xf8d8df07, 0x2810ec68,
    0x6f6ac63a, 0x059421ec, 0xacbf0003, 0x8c814bd6,
    0x729f7df0, 0xa4e71474, 0xbe6fa67e, 0x285187ca,
    0xb4e10c6a, 0xe75eb871, 0x069f279a, 0x8f077838,
    0xc7da5fe8, 0x33f9018a, 0xb25ac608, 0x3800a999,
    0x4a0d5281, 0x0035732f, 0xf29716ea, 0xeadf79cf,
    0xaa334c92, 0x006c5e92, 0x800993b0, 0x73087119,
    0x8a96c964, 0xb77cf734, 0xf6cb19ce, 0xcfb89d15,
    0x3d540bc5, 0x857f1191, 0x2da68eb2, 0x2ef16da1,
    0xa57160fd, 0xbf16cf7b, 0x5bb56f3c, 0x0f3f3a96,
    0xe702a064, 0x2add1bb8, 0x05280bb0, 0x49445ab8,
    0xf560ef61, 0x3af163ab, 0xd35cb600, 0x8b8f9ae6,
    0x06576967, 0xd80dfea3, 0x259b0191, 0x2278a868,
    0xf45319d8, 0x425b6c40, 0x3bae950d, 0x26444870,
    0x4ff182bb, 0x2e53b357, 0x24a8f9b2, 0x7aae7740,
    0x2a360653, 0xdc564384, 0x053b1f16, 0x3dae0afa,
    0x11c0079d, 0x6ecc742c, 0x01cf0947, 0x68f33267,
    0x828d35ad, 0x6f4d5a11, 0x01d09dc1, 0x09aeefeb,
    0xf0e8412b, 0xa959fc23, 0x91bad736, 0x265b2075,
    0xe3ddc4b7, 0x07569527, 0xc34f7ec1, 0x0c97d192,
    0x0a43f79c, 0x7ad3abf4, 0xf69b9033, 0x1bdf0124,
    0x3961aaa6, 0xa7b78b13, 0xdcd1dffd, 0x59611fb2,
    0x64b2f04b, 0x506cc54e, 0x5f7fc2ab, 0xd22018a0,
    0x1e2064a9, 0x1db995c0, 0xeddc7fe1, 0xf91b245c,
    0xb062a7ad, 0xbe199ab8, 0x15d22c79, 0x7a7cdab2,
    0xc37df0be, 0x2007b582, 0x2f04c75f, 0x4b84ab20,
    0x1998d8e3, 0x2169ca81, 0xff3c8a5c, 0xc30af54a,
    0x87015fe3, 0xd52edcab, 0xed6c8706, 0x9db80ec3,
    0x10d62f38, 0xa5268e7d, 0x77ab0d49, 0xe60c8031,
    0x74288339, 0x0094f2e2, 0x9d850c3c, 0x9899990f,
    0x04dccf5e, 0x0c7fd917, 0x6d31624f, 0xfc003f1c,
    0x283add48, 0x7517c415, 0x2bf12ccd, 0xb66ce8b6,
    0x605be298, 0x685c18e1, 0x9970558c, 0x41a706e0,
    0xb90628db, 0x10857227, 0x37587353, 0xe6ba1c2e,
    0xf090e241, 0xf98cd147, 0x8985233d, 0xf2750b6d,
    0xf97cf9ae, 0x5d7ea61e, 0xe0e1671d, 0x49b8ae4a,
    0xeff49261, 0xdb288fdd, 0x19833ef2, 0xf1dd599f,
    0xb9611ffd, 0x6f4237cd, 0x0d0f54f0, 0x7245776a,
    0x404e9b1d, 0x8d20e5da, 0xf2d36b59, 0x00c9cabc,
    0x6db48924, 0xecae72b4, 0x6e76329b, 0xbf3f6b1a,
    0x91b8e699, 0x6c251849, 0x894f45ad, 0x99ae898a,
    0x177d0a36, 0x5ad9c3a0, 0x6dee12b7, 0xa3468398,
    0x167bc972, 0x9d6077b5, 0x926dfc50, 0xd03e6ce7,
    0x2acc9202, 0xcd06ca90, 0x0e817154, 0xc80d72e7,
#else               /* Big endian */
    0xe5887ea9, 0xd1f26793, 0x13f4be6d, 0x625d6321,
    0xb611eaa7, 0xb776d2a9, 0xa294777d, 0x9aa27318,
    0xcb409c3e, 0xbf4d8d0b, 0x33b9ae73, 0x91cc14eb,
    0xfb1c13c9, 0x5177e9c8, 0x2bdb992b, 0x67879dbe,
    0xe7b23783, 0x2da552ff, 0x983a3f2a, 0xf742e49e,
    0x25a8e896, 0x7772a233, 0xc7ab5735, 0x93c2b460,
    0xb90de54d, 0x026b1f50, 0xc2f09de9, 0xe73d7862,
    0x65719e18, 0xcd540ceb, 0x6a72e3ac, 0xed706952,
    0xd2402db0, 0x7e768ac7, 0x4e0b87ff, 0xeb50777e,
    0x3a36e808, 0x3f1ea296, 0x79eb935a, 0xeb681475,
    0x52971062, 0xeba6009a, 0x0aafe4a5, 0x156aa53b,
    0xa959f076, 0x0ecd7112, 0xdfa5b47f, 0x935aa328,
    0xa9d27c2c, 0x82da4e1b, 0x2f55b7c4, 0x581a9e0d,
    0x92eac3af, 0xd3313baf, 0x8a5f4196, 0xd5cf1ccb,
    0xd0f5275c, 0xdecf9885, 0x481a76c0, 0x84a6c8e8,
    0x0f6a3e80, 0xb3f0f148, 0xc18cb95a, 0x87c024fb,
    0xe8b23b4d, 0xbc496cba, 0xefeafb7b, 0x752f03f7,
    0xbde998d5, 0xa9117399, 0x63aa2748, 0x739e8dd2,
    0x6a67665d, 0xae1b3668, 0x1e89bb02, 0x4dd63fda,
    0x5a3c7605, 0x9770d721, 0xed7c64bb, 0x5b87ecf1,
    0x2b80bd63, 0xaba0c124, 0xddfdcd74, 0x9e6757d5,
    0x9bf71be7, 0xc58b1461, 0x73186b44, 0xe56774ff,
    0xe6ae0485, 0xa1692c53, 0x7695df00, 0x8773a852,
    0xd8aaf506, 0x47b0c0b1, 0x9df26ada, 0x1c124aec,
    0x0e6c3555, 0x442a581d, 0x1ef62db1, 0x75292577,
    0x88b45e10, 0x50251fe0, 0x344cadc4, 0xaac6e200,
    0x5a4048ef, 0x7d0d3784, 0xe1470818, 0xa61f4291,
    0x1e19d11d, 0xa42f7651, 0x2e6d7fba, 0xad58ee9f,
    0x7d432377, 0x88b1c3da, 0x165c61dc, 0xdda7bd22,
    0xedb6f101, 0x42925f73, 0x7523f9e3, 0x573c4cc1,
    0xbed002af, 0xcd3b95c7, 0x753de43c, 0x0f6cf2d0,
    0xa5baa615, 0x9a5cd51c, 0x955758ba, 0xdbbf344a,
    0xc44100d1, 0x7c5a0d79, 0x1dfe3e40, 0x31e368c3,
    0x26b4b205, 0xc201f27d, 0x9768d5d5, 0x0b34f3e8,
    0xc6495892, 0xfd3ac063, 0x96e54c2d, 0x8727d70b,
    0xc40ce151, 0x4e7cfc19, 0xc5e33d58, 0x5561b85d,
    0xbdf55555, 0xe3f096ec, 0xc1fb58fb, 0xd8972981,
    0x1a11b0cd, 0x3a39376c, 0xe722e9ed, 0xd2515a94,
    0x1593bbbc, 0x2f24a73e, 0x0f420595, 0x177d0d49,
    0xe523967a, 0x916638c9, 0x95fc26e8, 0x47f64a9b,
    0x0ef5a874, 0xe7a40e87, 0x0aeb3315, 0x0b6e6129,
    0xdc335928, 0x96d5a002, 0x4c1c783b, 0x5854b03e,
    0x5c273e1e, 0x489d153a, 0x04e2eb73, 0x45cc8a46,
    0x1d6acf85, 0x505305d1, 0x22f6e4e0, 0x90e90413,
    0x7eaae409, 0x98eee772, 0x2f60deb1, 0x64ecbe44,
    0xfe1d6ee2, 0x01fdfddf, 0xb468c662, 0x5cc34582,
    0xf825b2bc, 0x5c181e81, 0x2f358372, 0x7275c196,
    0x4c3dc79a, 0x26c4a579, 0xd9be614e, 0x49069c1a,
    0x22f2a307, 0x16d3aee1, 0xd77ed962, 0x970dd47f,
    0xc76bcc02, 0x19c99e17, 0xdd73125d, 0xa4df3d39,
    0x1d7aa533, 0xb2bb3cad, 0x689c248f, 0x28dc19fe,
    0x6bd95b4a, 0xdd9690f1, 0x489cd53e, 0xc87c7794,
    0xf61dc628, 0xf12d6df5, 0x7876a8e2, 0xc0b6164c,
    0x16be5fb3, 0x84f530db, 0xd4bc5b9c, 0x5fd62b44,
    0x82addc12, 0xb7a875b5, 0x9b7eddba, 0x94833821,
    0x968c731b, 0x403212fe, 0x78bb117e, 0x5d0813c8,
    0x1abb80f2, 0x850aee3b, 0x5ba1fe2b, 0x12dc1d1a,
    0x1e640b83, 0x2bd011da, 0x94e10b29, 0x62e87c33,
    0xb6749288, 0x65851865, 0x19ccfd97, 0x6fc7fed1,
    0x5416c0e5, 0x90961441, 0x059ecf4f, 0x6dc4d1c3,
    0xf729a40c, 0xfff8c686, 0x5b7d55d7, 0xa6357744,
    0x28e76f99, 0x4b22960b, 0xdfbe4880, 0x0f74a8ae,
    0xf5533527, 0x6a1bf2fe, 0xfe599bb6, 0x36b13028,
    0x476d648e, 0xa7f070bd, 0x076ca4dc, 0x138b5f62,
    0x0be110dc, 0x4005ed78, 0xb907ec4d, 0xb797974b,
    0x0dcd742a, 0xbaeade0d, 0x629b5771, 0x4c9b861f,
    0x253ad270, 0xb885068d, 0x6eda1b4f, 0xc00a4a56,
    0x19743a53, 0x8fe6175e, 0x8ddeaf44, 0x58db0096,
    0xd41195cb, 0xe22a3a8a, 0x8be6d32a, 0xb703bcb4,
    0xea501a7a, 0x23be1de3, 0xbe2d6dda, 0xa0d5cafc,
    0xd2c65900, 0x0f1772f7, 0x6aac8cbc, 0x870ada14,
    0x1f1aecf2, 0x882b70a3, 0x94639615, 0xb8493e9c,
    0xbc5abc07, 0x870ca3c1, 0x59bb98e8, 0x4cedd1f3,
    0xe1f9b0d3, 0x53e2ce48, 0x047158df, 0x423b7799,
    0x4c97a2bc, 0xdef81e4c, 0x840bda28, 0x61183446,
    0xb3dfa196, 0x2547fb10, 0xf23ca562, 0xf354bc31,
    0x616704fb, 0x65530dd3, 0xf10eba31, 0xf2d6ae60,
    0x30d522f0, 0xc63698b9, 0x5dc9cd7f, 0xedcb1122,
    0xdc3d50fc, 0x641fc210, 0xb40df0ac, 0x477a420b,
    0xbe73f78f, 0xb9f5e8da, 0x2459be6e, 0xc86024db,
    0x3debcfaf, 0x08e66893, 0xc30020f4, 0x909ff52c,
    0xdf2afef7, 0x8022559c, 0xfb8be544, 0xcc3e5a73,
    0xaefaedb1, 0xaeceb6c2, 0x2398549d, 0x188800fe,
    0xe56ba0e2, 0xa9af960c, 0xf4bae045, 0x84f0c74d,
    0x500fd0cc, 0x65da75fc, 0xa5173a98, 0xad4fd65f,
    0x50428e33, 0x402dccfb, 0xd74b7b36, 0xc2302eda,
    0x5cb5a858, 0x0f8bfc49, 0x392c1315, 0x42fa64ad,
    0xe00ca922, 0xc383cb56, 0x50d12bbe, 0x119cfc69,
    0x7808fe44, 0x66984cdf, 0x84f9075a, 0x27662e79,
    0x6665a466, 0x8a2fb34d, 0x6d8005bd, 0xbabcf104,
    0x37b88c86, 0xf58d4f85, 0xd9557f6c, 0x07f1e857,
    0x8b98f6bc, 0x89ee108e, 0xabe0ffd4, 0xa015e717,
    0x62891437, 0x2227b743, 0x40ebb203, 0x4ed10360,
    0xbb4fc706, 0xde5c7bed, 0x77a52e8d, 0x09e5fec5,
    0x52ce43c8, 0xc2fadf5b, 0x889e0d02, 0x60870b2f,
    0xff2b9d50, 0xdd64f497, 0x9e8355ee, 0x2813a6d4,
    0xced46be7, 0x08c9d754, 0x685f9b73, 0xf314f853,
    0x478463ff, 0xf13ab91b, 0xd3825c04, 0x74742833,
    0x1b3104f9, 0x90432627, 0x78305b64, 0x1a676877,
    0x20a5e1cc, 0xe00b89d9, 0xb48bd535, 0xe9dedaca,
    0x1313c349, 0x27910cfd, 0xfa83c2fc, 0x068e5b4b,
    0xc252e39e, 0xbf1419be, 0x69a7979e, 0x50c4d225,
    0x49b84285, 0x9cafdab9, 0x340a8642, 0x848c91c5,
    0x5202582a, 0xc869c3c2, 0x7572d2ab, 0x7eacaaf2,
    0xdd00a3ba, 0x200f1839, 0x943ebfc0, 0xac5360e5,
    0x24043d14, 0xd4f87f1a, 0xfedf067f, 0x66ce76c0,
    0xaf058451, 0x20cb3c10, 0x64bc23e0, 0xba20c5de,
    0xcaf9e186, 0x441136f0, 0x14035e66, 0x6acd0d20,
    0xb12f1692, 0xf9162b7d, 0x977389ed, 0x1cceab41,
    0x07a6896b, 0xbb2aeb9b, 0x37ed765c, 0x6f7cb925,
    0xcf9cd312, 0xd0845ae3, 0xa28a9631, 0x177f4ebb,
    0xa2755026, 0xa9e35051, 0x984e21cc, 0x21105c7a,
    0x927303e0, 0x7876ca30, 0xd78fcd30, 0x62d3cf87,
    0xcb53f303, 0xcfa53158, 0x9e2506b5, 0xfedf947d,
    0xecbe0493, 0x1fd3ab87, 0xdcdd810e, 0x14acad14,
    0xff30385e, 0x5df500ed, 0x5cf42fbc, 0x2e8ab3ff,
    0x6804c369, 0x8fa60bf8, 0x404e46d8, 0xc9ba23d5,
    0x2c1c3e62, 0x491f8a27, 0xa7592b1c, 0xff7403f1,
    0x765b0123, 0x9f385beb, 0x1aa03116, 0x3704a37e,
    0x1fb1a9a5, 0x34d7ba3c, 0x6e4974c3, 0x35ef356e,
    0x57038fe4, 0xbff273e1, 0xa7fd5da7, 0x8729be16,
    0x85ea90d1, 0xa8c80f91, 0xd322a72c, 0x25d971bf,
    0xc51ad065, 0x5933ff5c, 0xa44ab840, 0x54096d6b,
    0x938f4052, 0x59cfd204, 0x4a0cf0ca, 0xdc1e22b5,
    0x8927fd4c, 0x27b2baf1, 0x6820f21b, 0x91c4812c,
    0x155da2bf, 0xf04d1b44, 0x8aded909, 0x31cb4733,
    0x2531df7a, 0xd32a6762, 0x9fbbbf4b, 0xa4757bf5,
    0x5d3d23a0, 0xa70cb060, 0xca41b823, 0x14c218c7,
    0x4d688250, 0x345be2ee, 0x03398052, 0x47f4518a,
    0x5b8067db, 0x663b8396, 0xa5c174d1, 0x45e55e0f,
    0xed3cc41f, 0xdb27c299, 0xec46017a, 0x381bb8bd,
    0x03f0d5a3, 0xe43c64c5, 0x4bb51810, 0x4b2dd8e5,
    0x2f93594a, 0x3512d9f9, 0xbd0d8c51, 0x37e30d66,
    0xfc4fa6c9, 0xe4a6b6db, 0x9911413d, 0x6af9d1bd,
    0xc7ea2313, 0x6381927a, 0x25d6f3cc, 0xe702353a,
    0xa87d53a4, 0x8c112c89, 0x80dc46b9, 0xb572f18a,
    0x6dbaf788, 0xce86c758, 0xf81c7613, 0xc6ee0bc8,
    0x2a628f4a, 0xaa6bca48, 0x0c66a932, 0x1fa302ee,
    0x107a812c, 0xcd561a35, 0x49cef74a, 0x66264dc1,
    0xd3f3efcd, 0x6b8e1c3b, 0x57363f06, 0x5ce046e5,
    0x39733b60, 0xcc574079, 0xba1ddf88, 0x472a44bc,
    0x33abdd67, 0xaa83c1e7, 0x7d7786dd, 0x2c3eac7b,
    0x9b2bb4b3, 0x06e555f9, 0xc74a76f7, 0xd50a401f,
    0xab370294, 0xa12d8b09, 0x9608fdab, 0xdfc5f8ab,
    0xd5f48e68, 0xfd1d0209, 0x3c391d82, 0x473fe32c,
    0xd8d19273, 0xf2cbd229, 0xe32787ca, 0xfba0ce48,
    0xf871436f, 0xd97e3bc8, 0xf607b979, 0x9787ff54,
    0x4a27326a, 0xc540a7c8, 0x59728047, 0xbba1a232,
    0xc34f032d, 0xcab24e6b, 0x250efb18, 0xd2e8a920,
    0x6e024243, 0x6ac0563b, 0x600be237, 0xdb21eac4,
    0xcab784a2, 0x79cb1ea2, 0xf9bc48b8, 0x110246a3,
    0xb04ffe75, 0x4325a7f3, 0x4ad099bf, 0x3b75a4c1,
    0x162ef9ea, 0x0f4e16d1, 0xc3d5e20b, 0x35daa8a8,
    0xdeef1e66, 0xfc9951c6, 0x742c112d, 0xcd28e8c3,
    0x63504ba5, 0xb89a4f9f, 0xcf3984e8, 0x70cdf63f,
    0x5309330f, 0x43481313, 0x6cb1a5b6, 0x1f614329,
    0x0ee349e7, 0x36b5a93f, 0x78cae082, 0xe6c49c6f,
    0x223ad81d, 0x6adeea01, 0x4a6ea977, 0x9c383b6f,
    0xbf3b7a4e, 0xe80b7d61, 0x59f0d065, 0x0493a415,
    0x64cabebe, 0xb16b6998, 0xcd4d2229, 0xc485f795,
    0x2ce9e286, 0xc692bc74, 0x0485f7ba, 0xc6000832,
    0x45f1c14c, 0x0511a00e, 0x009eb505, 0x5a81dccb,
    0x57c2b3d7, 0x51fa8ad0, 0x6234e65a, 0xfbd6f329,
    0x1adda2b7, 0x64a62985, 0x6991cc1a, 0x3dae87fe,
    0x22926ef2, 0x6578904b, 0x017d9808, 0x0d6e3d47,
    0x1a090f5a, 0xd56d1a5f, 0x124fbc5b, 0xaebfc35e,
    0x7f04f5b9, 0x1e3d65c5, 0x89bdf916, 0x96247f94,
    0xd260bd8e, 0x727ea29a, 0x9d36f2a8, 0x62a27215,
    0xf4238362, 0x6461896d, 0x19f278aa, 0xb56bfb72,
    0xfbe57af4, 0xd26f8dcb, 0x09f4770e, 0x7929d678,
    0x46f59a84, 0xac7929ac, 0x7296d8ff, 0x394143e8,
    0x928fddd6, 0xaca1da1e, 0xea9e6891, 0x9727c4be,
    0xcf840f4a, 0xdd1be31d, 0x8f30e588, 0xc9a8f6be,
    0x9b93ea5d, 0x7492f7a6, 0xb1d6cee5, 0x95a87cb3,
    0x9ee43ee6, 0xd8e372a8, 0x3d35a8eb, 0x32098155,
    0x8614adb9, 0x9e32c6ef, 0xead62942, 0x57b8de9a,
    0xc1253d8a, 0x18b231d7, 0x44eedd85, 0x150582b0,
    0x07f1be31, 0x39f684e7, 0x6a03918b, 0x42b109c9,
    0xd3bdaabf, 0x30e6fda4, 0xd97aea04, 0x909c06d8,
    0xd70e1c70, 0xe9bf27dc, 0xcd352018, 0x7d2163f1,
    0x2887de8b, 0x4b6be73d, 0x3d192717, 0xbf3cc76d,
    0xb4728f54, 0x5229835a, 0xbc68ccad, 0xfdd0ab5f,
    0x69ac96fd, 0x9740fbed, 0xbc2fa7c6, 0x0de3042f,
    0x5a5e3d4f, 0xb1d6b275, 0xa9b7407d, 0xac1691e3,
    0xdf7637f2, 0x74b874ea, 0x36020e6b, 0xfd36321a,
    0xa5a45e01, 0x180d0337, 0xb21bf552, 0x06a431fb,
    0x75ff33b1, 0xabbb603c, 0xe916c459, 0x49e10371,
    0x8e65e60b, 0x3df7f8c5, 0x5d8a980d, 0x710eedc4,
    0xcadb653e, 0x1cf814cb, 0xad5679b6, 0x8406c5a5,
    0x0cbd3558, 0x6b693037, 0x87f2f04b, 0x677c0878,
    0x013c86aa, 0x36e736e7, 0x25edbcd8, 0x59842d52,
    0x3eea2e08, 0xfe8df17c, 0x6828fcf0, 0x9c4cd6bf,
    0x38eb74a0, 0x76298f63, 0x1e5c1e16, 0xd65d0095,
    0x0f21ca88, 0x473eb1d5, 0xacb45cbc, 0x28c19269,
    0x950290e1, 0x41a85722, 0x92fd6c09, 0x625dc5de,
    0xec8b87f0, 0x12fcc4b3, 0x6677b585, 0x8467a81a,
    0xd84989cc, 0xe08ff19b, 0x7031a28a, 0x888a213d,
    0xc09b024a, 0x5b269127, 0xd082983e, 0x306e5f42,
    0x3e3275b7, 0x4ade3493, 0x1e30e31f, 0x432544c0,
    0xdfe1b89f, 0x1b020bb4, 0xd289a15d, 0xb47e6ed1,
    0xb6bcec8f, 0x5e7d5cf0, 0xe5243325, 0x3d161360,
    0x8a189892, 0xe2fcb714, 0x24323676, 0x0b783d24,
    0x2d0c5de0, 0x605adc6c, 0xf08a48bd, 0x3780292b,
    0xac1345ed, 0x19acf5e0, 0x14a0e9ca, 0x6693b797,
    0xede2aec9, 0x171f3513, 0xaf0cc796, 0xfd536607,
    0x35fe7a3f, 0x3060c0f5, 0xa834433e, 0xf0a825d4,
    0x0a297ffc, 0xff900aaa, 0xad8176f9, 0x4c52f059,
    0xf9837bfc, 0xe4df1ef2, 0x1a6afe07, 0x928cda83,
    0xc4e206db, 0x8ad021b0, 0xc1da95d4, 0xab0a9d55,
    0xcb0b17cf, 0xdf13feeb, 0x6befc003, 0xc965457a,
    0x35481ca1, 0x7fa4e244, 0x5049709d, 0x506a99df,
    0x0eebd7a0, 0x57082b12, 0xa65a85e4, 0x47279d6e,
    0x1b1db9bf, 0x88c8903b, 0x6bbfe95f, 0x787b40b2,
    0x3c638e83, 0x7701c216, 0xaee62103, 0x2618df71,
    0x265faa7c, 0x0688ab96, 0x41fe6dc0, 0xe6a25d50,
    0x0ed854a9, 0x7322b840, 0xe2f18643, 0xcd47f9b2,
    0x70315a67, 0x7b533295, 0x3cdb2f76, 0x28722eb2,
    0x53bb283b, 0xe1d9178a, 0x7cf0c578, 0x74f32d4d,
    0x5df88f1f, 0x36f28a5f, 0x93049cc1, 0x1b67f35e,
    0xfaf71107, 0xcdb2223d, 0x8116646f, 0xadcbb984,
    0xbb810283, 0x770428de, 0x7f055afe, 0x55926f61,
    0x3cb8ffa0, 0xd8de2a84, 0xda85cf86, 0xd0ab4089,
    0x8e483edd, 0xa464ab0d, 0xf9fe4b50, 0xaa8a398d,
    0xd3ea43cd, 0x9bffb5c2, 0x5e1fc86a, 0xd4ce2de6,
    0x9e910929, 0xe052f316, 0x29128865, 0xaaacd8d2,
    0x6a0af765, 0xc65f8a0b, 0x5c421aa9, 0xc7438e43,
    0x0313f7f1, 0x351dc465, 0x5cd11fda, 0xb9c1a4c9,
    0x748b67de, 0x227757be, 0xf12439ea, 0x25a3c656,
    0xf2a8130f, 0xc507ea1a, 0xf2b9d4b9, 0x18db074a,
    0x1568c873, 0xfc2d6d22, 0xba80b5ba, 0xa66bbe21,
    0x2e05b794, 0x61de03ed, 0xef9aa166, 0x38edb3f1,
    0xc5af7d6b, 0x0d6b201d, 0x05b59096, 0x8978960f,
    0x7158192c, 0xaf3204a9, 0xa2efb524, 0x9224f5b1,
    0x21e9c2c8, 0xe68fec8c, 0x42fed4f8, 0xc31222ab,
    0x5ea175c2, 0xdd0b129c, 0xba921672, 0x6812cbe4,
    0x8bb9ac49, 0xd30c8613, 0x5ab8d776, 0xae9dd616,
    0xa57c731c, 0x4ec2cc9e, 0x6c1c8fd2, 0xd64bbc64,
    0xa49289b5, 0xb70bac9b, 0x2966be85, 0x6b9add49,
    0x1eaed5d2, 0x7b5dc71e, 0x91c2e9a7, 0x86ee3a2a,
    0xb1716972, 0xa263bb68, 0x5e4203b5, 0x5f807557,
    0xa902dce4, 0x00c4d8cb, 0xe86bc835, 0xafb3e079,
    0xa481f6bb, 0x75a8d0e5, 0xf8d0c00e, 0xeca9d69e,
    0x4bfac55d, 0x20ca4fe6, 0x528028de, 0x25c2c029,
    0x630d31cb, 0x24c2ac90, 0xf7c818a8, 0x8370070c,
    0xa40454d2, 0xbc626881, 0xf75228a3, 0xb0910df9,
    0xc0d3f181, 0xbe0fe37f, 0x67df53bf, 0x3a7ecd46,
    0x03103f29, 0x8b708a7e, 0xd52fa2f3, 0x2980e01e,
    0x3a332ef8, 0x240112ee, 0xbc418331, 0x363a928a,
    0x4c1a784c, 0xfc7b33a9, 0x9857151e, 0x1a171702,
    0x8e8d5077, 0x711190ea, 0x0c537fa8, 0x56fa6036,
    0x3676d8f3, 0xaa03d3e1, 0x6ed9603c, 0xed154b7d,
    0x54ede682, 0x049c956c, 0x2728ddcb, 0x8fcb0bcb,
    0xfd8d804e, 0x462bd2b8, 0xfab74af9, 0x4854db66,
    0x956efff4, 0xe424678a, 0x8ca7dc77, 0xc71fe712,
    0xcbbc4650, 0xdc27de0a, 0xc5c29d05, 0xb398c619,
    0x37574ff3, 0xbb531ff1, 0xb1e4a6c8, 0x38a7d0a7,
    0x91d482d9, 0x0399d50e, 0x4fdf4895, 0xd5af2860,
    0x2de8be74, 0x96dd0097, 0xb0348c8b, 0x5e12f208,
    0xd746b55b, 0x81c83f65, 0xe2ab1729, 0x1340c95a,
    0x1d5f2d9c, 0x178bcefe, 0x0b597ea6, 0xeea916dc,
    0xd8f39882, 0x4960f175, 0x3cfbacfa, 0xb8f9e94f,
    0xc6e968d8, 0xfa8a05ef, 0x540f57ac, 0x99a5d41d,
    0xce11e1b6, 0x4cde578d, 0xce91ab33, 0xc2402b77,
    0x1878874f, 0x38da95c2, 0x7364cb4d, 0x78d33ae8,
    0x5404d777, 0x7ebc13c9, 0x020b9fd8, 0x3b2457d2,
    0xffcdd8ed, 0xabbe2125, 0x9edfc568, 0x47f980e5,
    0x42629cb8, 0x05d19c95, 0x9e15d503, 0x7d8a78b4,
    0x7e8a00d1, 0x7a61d8ca, 0x609c6648, 0x78efe49d,
    0xe07f514f, 0xc28eb52e, 0x4ee13e9b, 0xb669c8dd,
    0xb6b56de1, 0xcd1e0b57, 0xf914a6b1, 0x05443ed8,
    0xa8e0f160, 0x1a2f663d, 0x7ecbb9db, 0xa996c4de,
    0x714165dd, 0x164e3c6d, 0x6799e088, 0xc4844910,
    0x2f11c084, 0x6c9b16f1, 0x498d0277, 0x48d4e108,
    0xdd3cbc0e, 0xafc99cba, 0x6bc6be33, 0x67b777b4,
    0x3814b32b, 0x084df57c, 0x91497993, 0x031aa91e,
    0xad31ea96, 0xf3d525cd, 0xdfa76674, 0x30cd4b3e,
    0xa67cd93b, 0x2be19f6c, 0xde035d1f, 0xac2f17ff,
    0xd062444c, 0xea130882, 0x841810ef, 0x8b72c626,
    0xa233058b, 0x6dad86c7, 0x83143b86, 0x9fa105ff,
    0xe5a29b1c, 0x8ceef5c3, 0x5ea7a831, 0x8fad80b7,
    0x0defccad, 0xde20b371, 0x18afeb2b, 0x841dc112,
    0x4c81a42e, 0xb73694c0, 0x2492cb01, 0xe472137d,
    0x1a54da71, 0xdd5af1f7, 0xc654edb7, 0x4e328d0c,
    0x9a8632c9, 0xf4de4d16, 0x71c03fef, 0xf54b4bef,
    0xa0d14f76, 0x59d1781f, 0xee38ea5c, 0xa11799d7,
    0x463efbd9, 0x04f9b231, 0xb1c0f78d, 0x84486bdf,
    0xce349a7e, 0x7b5f2039, 0x01199a40, 0x35bfa363,
    0xc3a644b5, 0xffd9ccfa, 0xb5e0bc43, 0xf3b749b1,
    0xd7d6aaa0, 0x1b6a08cd, 0x63e5b2cf, 0x1796418a,
    0x01cab369, 0xd19299ed, 0x76b095ca, 0x9b1143c0,
    0x8907df76, 0x91dbdec7, 0x4063f12a, 0x59f32b96,
    0x82433cbc, 0xdde09636, 0x9b9a791d, 0x217a2d1f,
    0xde07fd25, 0xc997f4fd, 0xe0f66e00, 0xc3a89c5c,
    0x94adc76a, 0x08c43e18, 0x3c33bbe1, 0x2632587a,
    0x1b881ffb, 0xef110ff7, 0x1f81d7bb, 0x1ed250d1,
    0xa3af23eb, 0xc7f2b3fd, 0xbea4d3e9, 0x2db7289a,
    0x172d0c1f, 0x9ad2bcd0, 0xb1f57b5c, 0xf0a8db81,
    0x0672d3fc, 0x1b2e64e6, 0xe379cc38, 0x8cb03b29,
    0xbfc85cd6, 0xd2523a4c, 0x3ca16aab, 0xfbe70f25,
    0xe7637a83, 0x7faf9721, 0x802af4f6, 0xa239ad27,
    0x1cf076c6, 0xe19e9501, 0x31fb4c71, 0xdcb5cb04,
    0x99e696bd, 0xdbd94502, 0xad577ad3, 0x2296ed1b,
    0xf72dfee2, 0x8a1c8216, 0x0b47f1e9, 0x2be0f5b6,
    0x17af93a8, 0xe2839fe8, 0x8c57d5ef, 0xf3a48778,
    0xabf974dd, 0x0a5a6a18, 0xcaaee9fa, 0xf24c2f8e,
    0x36548e1c, 0x93fe2463, 0x4ebf4dae, 0xf694fbc6,
    0x726e5346, 0x38f24e63, 0x97d7f692, 0x95448a99,
    0xb54590bc, 0x7ac61137, 0x828c3906, 0x07d000d4,
    0x00b97a9a, 0x073fac2b, 0x97792825, 0x82eaf63c,
    0x53ba5986, 0x0f5b2204, 0x07dfd8f8, 0x68ec1028,
    0x3ac66a6f, 0xec219405, 0x0300bfac, 0xd64b818c,
    0xf07d9f72, 0x7414e7a4, 0x7ea66fbe, 0xca875128,
    0x6a0ce1b4, 0x71b85ee7, 0x9a279f06, 0x3878078f,
    0xe85fdac7, 0x8a01f933, 0x08c65ab2, 0x99a90038,
    0x81520d4a, 0x2f733500, 0xea1697f2, 0xcf79dfea,
    0x924c33aa, 0x925e6c00, 0xb0930980, 0x19710873,
    0x64c9968a, 0x34f77cb7, 0xce19cbf6, 0x159db8cf,
    0xc50b543d, 0x91117f85, 0xb28ea62d, 0xa16df12e,
    0xfd6071a5, 0x7bcf16bf, 0x3c6fb55b, 0x963a3f0f,
    0x64a002e7, 0xb81bdd2a, 0xb00b2805, 0xb85a4449,
    0x61ef60f5, 0xab63f13a, 0x00b65cd3, 0xe69a8f8b,
    0x67695706, 0xa3fe0dd8, 0x91019b25, 0x68a87822,
    0xd81953f4, 0x406c5b42, 0x0d95ae3b, 0x70484426,
    0xbb82f14f, 0x57b3532e, 0xb2f9a824, 0x4077ae7a,
    0x5306362a, 0x844356dc, 0x161f3b05, 0xfa0aae3d,
    0x9d07c011, 0x2c74cc6e, 0x4709cf01, 0x6732f368,
    0xad358d82, 0x115a4d6f, 0xc19dd001, 0xebefae09,
    0x2b41e8f0, 0x23fc59a9, 0x36d7ba91, 0x75205b26,
    0xb7c4dde3, 0x27955607, 0xc17e4fc3, 0x92d1970c,
    0x9cf7430a, 0xf4abd37a, 0x33909bf6, 0x2401df1b,
    0xa6aa6139, 0x138bb7a7, 0xfddfd1dc, 0xb21f6159,
    0x4bf0b264, 0x4ec56c50, 0xabc27f5f, 0xa01820d2,
    0xa964201e, 0xc095b91d, 0xe17fdced, 0x5c241bf9,
    0xada762b0, 0xb89a19be, 0x792cd215, 0xb2da7c7a,
    0xbef07dc3, 0x82b50720, 0x5fc7042f, 0x20ab844b,
    0xe3d89819, 0x81ca6921, 0x5c8a3cff, 0x4af50ac3,
    0xe35f0187, 0xabdc2ed5, 0x06876ced, 0xc30eb89d,
    0x382fd610, 0x7d8e26a5, 0x490dab77, 0x31800ce6,
    0x39832874, 0xe2f29400, 0x3c0c859d, 0x0f999998,
    0x5ecfdc04, 0x17d97f0c, 0x4f62316d, 0x1c3f00fc,
    0x48dd3a28, 0x15c41775, 0xcd2cf12b, 0xb6e86cb6,
    0x98e25b60, 0xe1185c68, 0x8c557099, 0xe006a741,
    0xdb2806b9, 0x27728510, 0x53735837, 0x2e1cbae6,
    0x41e290f0, 0x47d18cf9, 0x3d238589, 0x6d0b75f2,
    0xaef97cf9, 0x1ea67e5d, 0x1d67e1e0, 0x4aaeb849,
    0x6192f4ef, 0xdd8f28db, 0xf23e8319, 0x9f59ddf1,
    0xfd1f61b9, 0xcd37426f, 0xf0540f0d, 0x6a774572,
    0x1d9b4e40, 0xdae5208d, 0x596bd3f2, 0xbccac900,
    0x2489b46d, 0xb472aeec, 0x9b32766e, 0x1a6b3fbf,
    0x99e6b891, 0x4918256c, 0xad454f89, 0x8a89ae99,
    0x360a7d17, 0xa0c3d95a, 0xb712ee6d, 0x988346a3,
    0x72c97b16, 0xb577609d, 0x50fc6d92, 0xe76c3ed0,
    0x0292cc2a, 0x90ca06cd, 0x5471810e, 0xe7720dc8,
#endif  /* defined __ARMEB__ */
};

/**********************************************************************************************************************
 Private (static) variables and functions
 *********************************************************************************************************************/

