; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -jump-threading -jump-threading-threshold=3 -S -verify | FileCheck %s

target datalayout = "e-m:e-p270:32:32-p271:32:32-p272:64:64-i64:64-f80:128-n8:16:32:64-S128"
target triple = "x86_64-unknown-linux-gnu"

@a = global i32 0, align 4

; Show that freeze is not counted when comparing the cost with the threshold
define void @foo(i32 %cond1, i32 %cond2) {
; CHECK-LABEL: @foo(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TOBOOL:%.*]] = icmp eq i32 [[COND1:%.*]], 0
; CHECK-NEXT:    br i1 [[TOBOOL]], label [[BB_COND2_THREAD:%.*]], label [[BB_COND2:%.*]]
; CHECK:       bb.cond2:
; CHECK-NEXT:    call void @f1()
; CHECK-NEXT:    [[COND2_FR:%.*]] = freeze i32 [[COND2:%.*]]
; CHECK-NEXT:    [[X:%.*]] = add i32 [[COND2_FR]], 1
; CHECK-NEXT:    [[TOBOOL1:%.*]] = icmp eq i32 [[X]], 0
; CHECK-NEXT:    br i1 [[TOBOOL1]], label [[BB_F4:%.*]], label [[BB_F2:%.*]]
; CHECK:       bb.cond2.thread:
; CHECK-NEXT:    [[COND2_FR2:%.*]] = freeze i32 [[COND2]]
; CHECK-NEXT:    [[X3:%.*]] = add i32 [[COND2_FR2]], 1
; CHECK-NEXT:    [[TOBOOL14:%.*]] = icmp eq i32 [[X3]], 0
; CHECK-NEXT:    br i1 [[TOBOOL14]], label [[BB_F3:%.*]], label [[BB_F2]]
; CHECK:       bb.f2:
; CHECK-NEXT:    call void @f2()
; CHECK-NEXT:    br label [[EXIT:%.*]]
; CHECK:       bb.f3:
; CHECK-NEXT:    call void @f3()
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       bb.f4:
; CHECK-NEXT:    [[PTR5:%.*]] = phi i32* [ null, [[BB_COND2]] ]
; CHECK-NEXT:    call void @f4()
; CHECK-NEXT:    br label [[EXIT]]
; CHECK:       exit:
; CHECK-NEXT:    ret void
;
entry:
  %tobool = icmp eq i32 %cond1, 0
  br i1 %tobool, label %bb.cond2, label %bb.f1

bb.f1:
  call void @f1()
  br label %bb.cond2

bb.cond2:
  %ptr = phi i32* [ null, %bb.f1 ], [ @a, %entry ]
  %cond2.fr = freeze i32 %cond2
  %x = add i32 %cond2.fr, 1
  %tobool1 = icmp eq i32 %x, 0
  br i1 %tobool1, label %bb.file, label %bb.f2

bb.f2:
  call void @f2()
  br label %exit

bb.file:
  %cmp = icmp eq i32* %ptr, null
  br i1 %cmp, label %bb.f4, label %bb.f3

bb.f3:
  call void @f3()
  br label %exit

bb.f4:
  call void @f4()
  br label %exit

exit:
  ret void
}

declare void @f1()

declare void @f2()

declare void @f3()

declare void @f4()
