; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -gvn -S %s | FileCheck %s

; Test for PR46054. Make sure we correctly invalidate MemoryDependenceAnalysis,
; after removing a nonlocaldef.

target datalayout = "e-m:e-i64:64-f80:128-n8:16:32:64-S128"

define void @test_double(double* %data) {
; CHECK-LABEL: @test_double(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LUC:%.*]] = tail call noalias nonnull i64* @data()
; CHECK-NEXT:    store i64 1, i64* [[LUC]], align 8, !invariant.group !0
; CHECK-NEXT:    call void @fn(i64 1)
; CHECK-NEXT:    br i1 true, label [[A:%.*]], label [[ENTRY_B_CRIT_EDGE:%.*]]
; CHECK:       entry.B_crit_edge:
; CHECK-NEXT:    br label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br label [[B]]
; CHECK:       B:
; CHECK-NEXT:    call void @fn(i64 1)
; CHECK-NEXT:    ret void
;
entry:
  %luc = tail call noalias nonnull i64* @data()
  store i64 1, i64* %luc, !invariant.group !0
  %QQ = load i64, i64* %luc, !invariant.group !0
  call void @fn(i64 %QQ)
  br i1 true, label %A, label %B

A:                                                ; preds = %loop
  br label %B

B:                                                ; preds = %A, %loop
  %QQ.1 = load i64, i64* %luc, !invariant.group !0
  call void @fn(i64 %QQ.1)
  ret void
}

declare void @fn(i64)

declare noalias i64* @data()


define void @test_double_ptr(double** %data) {
; CHECK-LABEL: @test_double_ptr(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[LUC:%.*]] = tail call noalias nonnull i64** @data.ptr()
; CHECK-NEXT:    store i64* null, i64** [[LUC]], align 8, !invariant.group !0
; CHECK-NEXT:    call void @fn.ptr(i64* null)
; CHECK-NEXT:    br i1 true, label [[A:%.*]], label [[ENTRY_B_CRIT_EDGE:%.*]]
; CHECK:       entry.B_crit_edge:
; CHECK-NEXT:    br label [[B:%.*]]
; CHECK:       A:
; CHECK-NEXT:    br label [[B]]
; CHECK:       B:
; CHECK-NEXT:    call void @fn.ptr(i64* null)
; CHECK-NEXT:    ret void
;
entry:
  %luc = tail call noalias nonnull i64** @data.ptr()
  store i64* null, i64** %luc, !invariant.group !0
  %QQ = load i64*, i64** %luc, !invariant.group !0
  call void @fn.ptr(i64* %QQ)
  br i1 true, label %A, label %B

A:                                                ; preds = %loop
  br label %B

B:                                                ; preds = %A, %loop
  %QQ.1 = load i64*, i64** %luc, !invariant.group !0
  call void @fn.ptr(i64* %QQ.1)
  ret void
}


declare void @fn.ptr(i64 *)

declare noalias i64** @data.ptr()

!0 = distinct !{}
