; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --function-signature --check-globals
; RUN: opt -S -mtriple=amdgcn-amd- -amdgpu-annotate-kernel-features %s | FileCheck --allow-unused-prefixes -check-prefixes=CHECK,AKF_CHECK %s
; RUN: opt -S -mtriple=amdgcn-amd- -amdgpu-attributor %s | FileCheck --allow-unused-prefixes -check-prefixes=CHECK,ATTRIBUTOR_CHECK %s

; Test to ensure recursive functions exhibit proper behaviour
; Test to generate fibonacci numbers

define i32 @fib(i32 %n) #0 {
; AKF_CHECK-LABEL: define {{[^@]+}}@fib
; AKF_CHECK-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
; AKF_CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[N]], 0
; AKF_CHECK-NEXT:    br i1 [[CMP1]], label [[EXIT:%.*]], label [[CONT1:%.*]]
; AKF_CHECK:       cont1:
; AKF_CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[N]], 1
; AKF_CHECK-NEXT:    br i1 [[CMP2]], label [[EXIT]], label [[CONT2:%.*]]
; AKF_CHECK:       cont2:
; AKF_CHECK-NEXT:    [[NM1:%.*]] = sub i32 [[N]], 1
; AKF_CHECK-NEXT:    [[FIBM1:%.*]] = call i32 @fib(i32 [[NM1]])
; AKF_CHECK-NEXT:    [[NM2:%.*]] = sub i32 [[N]], 2
; AKF_CHECK-NEXT:    [[FIBM2:%.*]] = call i32 @fib(i32 [[NM2]])
; AKF_CHECK-NEXT:    [[RETVAL:%.*]] = add i32 [[FIBM1]], [[FIBM2]]
; AKF_CHECK-NEXT:    ret i32 [[RETVAL]]
; AKF_CHECK:       exit:
; AKF_CHECK-NEXT:    ret i32 1
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@fib
; ATTRIBUTOR_CHECK-SAME: (i32 [[N:%.*]]) #[[ATTR0:[0-9]+]] {
; ATTRIBUTOR_CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[N]], 0
; ATTRIBUTOR_CHECK-NEXT:    br i1 [[CMP1]], label [[EXIT:%.*]], label [[CONT1:%.*]]
; ATTRIBUTOR_CHECK:       cont1:
; ATTRIBUTOR_CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[N]], 1
; ATTRIBUTOR_CHECK-NEXT:    br i1 [[CMP2]], label [[EXIT]], label [[CONT2:%.*]]
; ATTRIBUTOR_CHECK:       cont2:
; ATTRIBUTOR_CHECK-NEXT:    [[NM1:%.*]] = sub i32 [[N]], 1
; ATTRIBUTOR_CHECK-NEXT:    [[FIBM1:%.*]] = call i32 @fib(i32 [[NM1]]) #[[ATTR3:[0-9]+]]
; ATTRIBUTOR_CHECK-NEXT:    [[NM2:%.*]] = sub i32 [[N]], 2
; ATTRIBUTOR_CHECK-NEXT:    [[FIBM2:%.*]] = call i32 @fib(i32 [[NM2]]) #[[ATTR3]]
; ATTRIBUTOR_CHECK-NEXT:    [[RETVAL:%.*]] = add i32 [[FIBM1]], [[FIBM2]]
; ATTRIBUTOR_CHECK-NEXT:    ret i32 [[RETVAL]]
; ATTRIBUTOR_CHECK:       exit:
; ATTRIBUTOR_CHECK-NEXT:    ret i32 1
;
  %cmp1 = icmp eq i32 %n, 0
  br i1 %cmp1, label %exit, label %cont1

cont1:
  %cmp2 = icmp eq i32 %n, 1
  br i1 %cmp2, label %exit, label %cont2

cont2:
  %nm1 = sub i32 %n, 1
  %fibm1 = call i32 @fib(i32 %nm1)
  %nm2 = sub i32 %n, 2
  %fibm2 = call i32 @fib(i32 %nm2)
  %retval = add i32 %fibm1, %fibm2

  ret i32 %retval

exit:
  ret i32 1
}

define internal i32 @fib_internal(i32 %n) #0 {
; AKF_CHECK-LABEL: define {{[^@]+}}@fib_internal
; AKF_CHECK-SAME: (i32 [[N:%.*]]) #[[ATTR0]] {
; AKF_CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[N]], 0
; AKF_CHECK-NEXT:    br i1 [[CMP1]], label [[EXIT:%.*]], label [[CONT1:%.*]]
; AKF_CHECK:       cont1:
; AKF_CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[N]], 1
; AKF_CHECK-NEXT:    br i1 [[CMP2]], label [[EXIT]], label [[CONT2:%.*]]
; AKF_CHECK:       cont2:
; AKF_CHECK-NEXT:    [[NM1:%.*]] = sub i32 [[N]], 1
; AKF_CHECK-NEXT:    [[FIBM1:%.*]] = call i32 @fib_internal(i32 [[NM1]])
; AKF_CHECK-NEXT:    [[NM2:%.*]] = sub i32 [[N]], 2
; AKF_CHECK-NEXT:    [[FIBM2:%.*]] = call i32 @fib_internal(i32 [[NM2]])
; AKF_CHECK-NEXT:    [[RETVAL:%.*]] = add i32 [[FIBM1]], [[FIBM2]]
; AKF_CHECK-NEXT:    ret i32 [[RETVAL]]
; AKF_CHECK:       exit:
; AKF_CHECK-NEXT:    ret i32 1
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@fib_internal
; ATTRIBUTOR_CHECK-SAME: (i32 [[N:%.*]]) #[[ATTR1:[0-9]+]] {
; ATTRIBUTOR_CHECK-NEXT:    [[CMP1:%.*]] = icmp eq i32 [[N]], 0
; ATTRIBUTOR_CHECK-NEXT:    br i1 [[CMP1]], label [[EXIT:%.*]], label [[CONT1:%.*]]
; ATTRIBUTOR_CHECK:       cont1:
; ATTRIBUTOR_CHECK-NEXT:    [[CMP2:%.*]] = icmp eq i32 [[N]], 1
; ATTRIBUTOR_CHECK-NEXT:    br i1 [[CMP2]], label [[EXIT]], label [[CONT2:%.*]]
; ATTRIBUTOR_CHECK:       cont2:
; ATTRIBUTOR_CHECK-NEXT:    [[NM1:%.*]] = sub i32 [[N]], 1
; ATTRIBUTOR_CHECK-NEXT:    [[FIBM1:%.*]] = call i32 @fib_internal(i32 [[NM1]]) #[[ATTR4:[0-9]+]]
; ATTRIBUTOR_CHECK-NEXT:    [[NM2:%.*]] = sub i32 [[N]], 2
; ATTRIBUTOR_CHECK-NEXT:    [[FIBM2:%.*]] = call i32 @fib_internal(i32 [[NM2]]) #[[ATTR4]]
; ATTRIBUTOR_CHECK-NEXT:    [[RETVAL:%.*]] = add i32 [[FIBM1]], [[FIBM2]]
; ATTRIBUTOR_CHECK-NEXT:    ret i32 [[RETVAL]]
; ATTRIBUTOR_CHECK:       exit:
; ATTRIBUTOR_CHECK-NEXT:    ret i32 1
;
  %cmp1 = icmp eq i32 %n, 0
  br i1 %cmp1, label %exit, label %cont1

cont1:
  %cmp2 = icmp eq i32 %n, 1
  br i1 %cmp2, label %exit, label %cont2

cont2:
  %nm1 = sub i32 %n, 1
  %fibm1 = call i32 @fib_internal(i32 %nm1)
  %nm2 = sub i32 %n, 2
  %fibm2 = call i32 @fib_internal(i32 %nm2)
  %retval = add i32 %fibm1, %fibm2

  ret i32 %retval

exit:
  ret i32 1
}

define amdgpu_kernel void @kernel(i32 addrspace(1)* %m) #1 {
; AKF_CHECK-LABEL: define {{[^@]+}}@kernel
; AKF_CHECK-SAME: (i32 addrspace(1)* [[M:%.*]]) #[[ATTR1:[0-9]+]] {
; AKF_CHECK-NEXT:    [[R:%.*]] = call i32 @fib(i32 5)
; AKF_CHECK-NEXT:    [[R2:%.*]] = call i32 @fib_internal(i32 5)
; AKF_CHECK-NEXT:    store i32 [[R]], i32 addrspace(1)* [[M]], align 4
; AKF_CHECK-NEXT:    store i32 [[R2]], i32 addrspace(1)* [[M]], align 4
; AKF_CHECK-NEXT:    ret void
;
; ATTRIBUTOR_CHECK-LABEL: define {{[^@]+}}@kernel
; ATTRIBUTOR_CHECK-SAME: (i32 addrspace(1)* [[M:%.*]]) #[[ATTR2:[0-9]+]] {
; ATTRIBUTOR_CHECK-NEXT:    [[R:%.*]] = call i32 @fib(i32 5) #[[ATTR3]]
; ATTRIBUTOR_CHECK-NEXT:    [[R2:%.*]] = call i32 @fib_internal(i32 noundef 5) #[[ATTR3]]
; ATTRIBUTOR_CHECK-NEXT:    store i32 [[R]], i32 addrspace(1)* [[M]], align 4
; ATTRIBUTOR_CHECK-NEXT:    store i32 [[R2]], i32 addrspace(1)* [[M]], align 4
; ATTRIBUTOR_CHECK-NEXT:    ret void
;
  %r = call i32 @fib(i32 5)
  %r2 = call i32 @fib_internal(i32 5)

  store i32 %r, i32 addrspace(1)* %m
  store i32 %r2, i32 addrspace(1)* %m
  ret void
}

; nounwind and readnone are added to match attributor results.
attributes #0 = { nounwind readnone }
attributes #1 = { "uniform-work-group-size"="true" }

;.
; AKF_CHECK: attributes #[[ATTR0]] = { nounwind readnone "uniform-work-group-size"="true" }
; AKF_CHECK: attributes #[[ATTR1]] = { "amdgpu-calls" "uniform-work-group-size"="true" }
;.
; ATTRIBUTOR_CHECK: attributes #[[ATTR0]] = { nounwind readnone "uniform-work-group-size"="false" }
; ATTRIBUTOR_CHECK: attributes #[[ATTR1]] = { nofree nosync nounwind readnone "uniform-work-group-size"="true" }
; ATTRIBUTOR_CHECK: attributes #[[ATTR2]] = { "amdgpu-calls" "uniform-work-group-size"="true" }
; ATTRIBUTOR_CHECK: attributes #[[ATTR3]] = { nounwind readnone }
; ATTRIBUTOR_CHECK: attributes #[[ATTR4]] = { nofree nounwind readnone }
;.
