/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Provides classes and interfaces for the input method framework. This package
 * enables text editing components to receive text input through input methods.
 * Input methods are software components that let the user enter text in ways
 * other than simple typing on a keyboard. They are commonly used to enter
 * Japanese, Chinese, or Korean - languages using thousands of different
 * characters - on keyboards with far fewer keys. However, the framework also
 * supports input methods for other languages and the use of entirely different
 * input mechanisms, such as handwriting or speech recognition.
 *
 * <h2>Related Documentation</h2>
 * For overviews, tutorials, examples, guides, and tool documentation, please
 * see {@extLink imf_overview Input Method Framework Overview}.
 *
 * @since 1.2
 */
package java.awt.im;
