// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostScanTargetErrorSummary One of the error during scanning on instances associated with a host scan target (application of a host scan recipe to a compartment or list of hosts).
type HostScanTargetErrorSummary struct {

	// Vendor which was used for the host scan agent.
	Vendor VendorTypeEnum `mandatory:"true" json:"vendor"`

	// Error message detailing task failure.
	Message *string `mandatory:"true" json:"message"`

	// OCID of the host instance where scan was done.
	InstanceId *string `mandatory:"true" json:"instanceId"`

	// The current state of the config.
	LifecycleState LifecycleStateEnum `mandatory:"true" json:"lifecycleState"`

	// Date and time the error was updated, format as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339).
	TimeUpdated *common.SDKTime `mandatory:"true" json:"timeUpdated"`

	// Task during scan which failed.
	Task *string `mandatory:"false" json:"task"`

	// Error code of task failure.
	ErrorCode *string `mandatory:"false" json:"errorCode"`

	// Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
	// Example: `{"bar-key": "value"}`
	FreeformTags map[string]string `mandatory:"false" json:"freeformTags"`

	// Defined tags for this resource. Each key is predefined and scoped to a namespace.
	// Example: `{"foo-namespace": {"bar-key": "value"}}`
	DefinedTags map[string]map[string]interface{} `mandatory:"false" json:"definedTags"`

	// Usage of system tag keys. These predefined keys are scoped to namespaces.
	// Example: `{"orcl-cloud": {"free-tier-retained": "true"}}`
	SystemTags map[string]map[string]interface{} `mandatory:"false" json:"systemTags"`
}

func (m HostScanTargetErrorSummary) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostScanTargetErrorSummary) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingVendorTypeEnum(string(m.Vendor)); !ok && m.Vendor != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for Vendor: %s. Supported values are: %s.", m.Vendor, strings.Join(GetVendorTypeEnumStringValues(), ",")))
	}
	if _, ok := GetMappingLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetLifecycleStateEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
