// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Java Management Service API
//
// API for the Java Management Service. Use this API to view, create, and manage Fleets.
//

package jms

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// RequestPerformanceTuningAnalysesDetails Details of the request to start a JFR performance tuning analysis.
type RequestPerformanceTuningAnalysesDetails struct {

	// Duration of the JFR recording in minutes.
	RecordingDurationInMinutes *int `mandatory:"true" json:"recordingDurationInMinutes"`

	// The attachment targets to start JFR.
	Targets []JfrAttachmentTarget `mandatory:"false" json:"targets"`

	// Period to looking for JVMs. In addition to attach to running JVMs when given the command,
	// JVM started within the waiting period will also be attached for JFR. The value should be
	// larger than the agent polling interval setting for the fleet to ensure agent can get the
	// instructions. If not specified, the agent polling interval for the fleet is used.
	WaitingPeriodInMinutes *int `mandatory:"false" json:"waitingPeriodInMinutes"`
}

func (m RequestPerformanceTuningAnalysesDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m RequestPerformanceTuningAnalysesDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
