// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostVulnerabilitySortByEnum Enum with underlying type: string
type HostVulnerabilitySortByEnum string

// Set of constants representing the allowable values for HostVulnerabilitySortByEnum
const (
	HostVulnerabilitySortByName          HostVulnerabilitySortByEnum = "name"
	HostVulnerabilitySortBySeverity      HostVulnerabilitySortByEnum = "severity"
	HostVulnerabilitySortByImpactedHosts HostVulnerabilitySortByEnum = "impactedHosts"
	HostVulnerabilitySortByFirstDetected HostVulnerabilitySortByEnum = "firstDetected"
	HostVulnerabilitySortByLastDetected  HostVulnerabilitySortByEnum = "lastDetected"
)

var mappingHostVulnerabilitySortByEnum = map[string]HostVulnerabilitySortByEnum{
	"name":          HostVulnerabilitySortByName,
	"severity":      HostVulnerabilitySortBySeverity,
	"impactedHosts": HostVulnerabilitySortByImpactedHosts,
	"firstDetected": HostVulnerabilitySortByFirstDetected,
	"lastDetected":  HostVulnerabilitySortByLastDetected,
}

var mappingHostVulnerabilitySortByEnumLowerCase = map[string]HostVulnerabilitySortByEnum{
	"name":          HostVulnerabilitySortByName,
	"severity":      HostVulnerabilitySortBySeverity,
	"impactedhosts": HostVulnerabilitySortByImpactedHosts,
	"firstdetected": HostVulnerabilitySortByFirstDetected,
	"lastdetected":  HostVulnerabilitySortByLastDetected,
}

// GetHostVulnerabilitySortByEnumValues Enumerates the set of values for HostVulnerabilitySortByEnum
func GetHostVulnerabilitySortByEnumValues() []HostVulnerabilitySortByEnum {
	values := make([]HostVulnerabilitySortByEnum, 0)
	for _, v := range mappingHostVulnerabilitySortByEnum {
		values = append(values, v)
	}
	return values
}

// GetHostVulnerabilitySortByEnumStringValues Enumerates the set of values in String for HostVulnerabilitySortByEnum
func GetHostVulnerabilitySortByEnumStringValues() []string {
	return []string{
		"name",
		"severity",
		"impactedHosts",
		"firstDetected",
		"lastDetected",
	}
}

// GetMappingHostVulnerabilitySortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostVulnerabilitySortByEnum(val string) (HostVulnerabilitySortByEnum, bool) {
	enum, ok := mappingHostVulnerabilitySortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
