// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// HostPortScanResult A scan result for a host port scan
type HostPortScanResult struct {

	// Unique identifier of the scan
	Id *string `mandatory:"true" json:"id"`

	// Instance ID of the Compute Instance scanned
	InstanceId *string `mandatory:"true" json:"instanceId"`

	// Compartment ID of the resource. This is set to the same as the compartment ID of the scan target
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Highest problem severity in this report
	HighestProblemSeverity ScanResultProblemSeverityEnum `mandatory:"true" json:"highestProblemSeverity"`

	// Date and time the scan was started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStarted *common.SDKTime `mandatory:"true" json:"timeStarted"`

	// Date and time the scan was completed, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeFinished *common.SDKTime `mandatory:"true" json:"timeFinished"`

	// List of open ports (including interface) found in this scan
	OpenPorts []HostPortScanResultOpenPort `mandatory:"true" json:"openPorts"`

	// Name of the resource
	DisplayName *string `mandatory:"false" json:"displayName"`

	// Total number of open ports across all attached VNICs found in this scan
	OpenPortCount *int `mandatory:"false" json:"openPortCount"`

	// The current state of the result.
	LifecycleState LifecycleStateEnum `mandatory:"false" json:"lifecycleState,omitempty"`
}

func (m HostPortScanResult) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m HostPortScanResult) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingScanResultProblemSeverityEnum(string(m.HighestProblemSeverity)); !ok && m.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", m.HighestProblemSeverity, strings.Join(GetScanResultProblemSeverityEnumStringValues(), ",")))
	}

	if _, ok := GetMappingLifecycleStateEnum(string(m.LifecycleState)); !ok && m.LifecycleState != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for LifecycleState: %s. Supported values are: %s.", m.LifecycleState, strings.Join(GetLifecycleStateEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
