// Code generated by command: avogen -output zinstructions.go build. DO NOT EDIT.

package build

import (
	"github.com/mmcloughlin/avo/ir"
	"github.com/mmcloughlin/avo/operand"
	"github.com/mmcloughlin/avo/x86"
)

func (c *Context) addinstruction(i *ir.Instruction, err error) {
	if err == nil {
		c.Instruction(i)
	} else {
		c.adderror(err)
	}
}

// ADCB: Add with Carry.
//
// Forms:
//
//	ADCB imm8 al
//	ADCB imm8 m8
//	ADCB imm8 r8
//	ADCB m8   r8
//	ADCB r8   m8
//	ADCB r8   r8
//
// Construct and append a ADCB instruction to the active function.
func (c *Context) ADCB(imr, amr operand.Op) {
	c.addinstruction(x86.ADCB(imr, amr))
}

// ADCB: Add with Carry.
//
// Forms:
//
//	ADCB imm8 al
//	ADCB imm8 m8
//	ADCB imm8 r8
//	ADCB m8   r8
//	ADCB r8   m8
//	ADCB r8   r8
//
// Construct and append a ADCB instruction to the active function.
// Operates on the global context.
func ADCB(imr, amr operand.Op) { ctx.ADCB(imr, amr) }

// ADCL: Add with Carry.
//
// Forms:
//
//	ADCL imm32 eax
//	ADCL imm32 m32
//	ADCL imm32 r32
//	ADCL imm8  m32
//	ADCL imm8  r32
//	ADCL m32   r32
//	ADCL r32   m32
//	ADCL r32   r32
//
// Construct and append a ADCL instruction to the active function.
func (c *Context) ADCL(imr, emr operand.Op) {
	c.addinstruction(x86.ADCL(imr, emr))
}

// ADCL: Add with Carry.
//
// Forms:
//
//	ADCL imm32 eax
//	ADCL imm32 m32
//	ADCL imm32 r32
//	ADCL imm8  m32
//	ADCL imm8  r32
//	ADCL m32   r32
//	ADCL r32   m32
//	ADCL r32   r32
//
// Construct and append a ADCL instruction to the active function.
// Operates on the global context.
func ADCL(imr, emr operand.Op) { ctx.ADCL(imr, emr) }

// ADCQ: Add with Carry.
//
// Forms:
//
//	ADCQ imm32 m64
//	ADCQ imm32 r64
//	ADCQ imm32 rax
//	ADCQ imm8  m64
//	ADCQ imm8  r64
//	ADCQ m64   r64
//	ADCQ r64   m64
//	ADCQ r64   r64
//
// Construct and append a ADCQ instruction to the active function.
func (c *Context) ADCQ(imr, mr operand.Op) {
	c.addinstruction(x86.ADCQ(imr, mr))
}

// ADCQ: Add with Carry.
//
// Forms:
//
//	ADCQ imm32 m64
//	ADCQ imm32 r64
//	ADCQ imm32 rax
//	ADCQ imm8  m64
//	ADCQ imm8  r64
//	ADCQ m64   r64
//	ADCQ r64   m64
//	ADCQ r64   r64
//
// Construct and append a ADCQ instruction to the active function.
// Operates on the global context.
func ADCQ(imr, mr operand.Op) { ctx.ADCQ(imr, mr) }

// ADCW: Add with Carry.
//
// Forms:
//
//	ADCW imm16 ax
//	ADCW imm16 m16
//	ADCW imm16 r16
//	ADCW imm8  m16
//	ADCW imm8  r16
//	ADCW m16   r16
//	ADCW r16   m16
//	ADCW r16   r16
//
// Construct and append a ADCW instruction to the active function.
func (c *Context) ADCW(imr, amr operand.Op) {
	c.addinstruction(x86.ADCW(imr, amr))
}

// ADCW: Add with Carry.
//
// Forms:
//
//	ADCW imm16 ax
//	ADCW imm16 m16
//	ADCW imm16 r16
//	ADCW imm8  m16
//	ADCW imm8  r16
//	ADCW m16   r16
//	ADCW r16   m16
//	ADCW r16   r16
//
// Construct and append a ADCW instruction to the active function.
// Operates on the global context.
func ADCW(imr, amr operand.Op) { ctx.ADCW(imr, amr) }

// ADCXL: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXL m32 r32
//	ADCXL r32 r32
//
// Construct and append a ADCXL instruction to the active function.
func (c *Context) ADCXL(mr, r operand.Op) {
	c.addinstruction(x86.ADCXL(mr, r))
}

// ADCXL: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXL m32 r32
//	ADCXL r32 r32
//
// Construct and append a ADCXL instruction to the active function.
// Operates on the global context.
func ADCXL(mr, r operand.Op) { ctx.ADCXL(mr, r) }

// ADCXQ: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXQ m64 r64
//	ADCXQ r64 r64
//
// Construct and append a ADCXQ instruction to the active function.
func (c *Context) ADCXQ(mr, r operand.Op) {
	c.addinstruction(x86.ADCXQ(mr, r))
}

// ADCXQ: Unsigned Integer Addition of Two Operands with Carry Flag.
//
// Forms:
//
//	ADCXQ m64 r64
//	ADCXQ r64 r64
//
// Construct and append a ADCXQ instruction to the active function.
// Operates on the global context.
func ADCXQ(mr, r operand.Op) { ctx.ADCXQ(mr, r) }

// ADDB: Add.
//
// Forms:
//
//	ADDB imm8 al
//	ADDB imm8 m8
//	ADDB imm8 r8
//	ADDB m8   r8
//	ADDB r8   m8
//	ADDB r8   r8
//
// Construct and append a ADDB instruction to the active function.
func (c *Context) ADDB(imr, amr operand.Op) {
	c.addinstruction(x86.ADDB(imr, amr))
}

// ADDB: Add.
//
// Forms:
//
//	ADDB imm8 al
//	ADDB imm8 m8
//	ADDB imm8 r8
//	ADDB m8   r8
//	ADDB r8   m8
//	ADDB r8   r8
//
// Construct and append a ADDB instruction to the active function.
// Operates on the global context.
func ADDB(imr, amr operand.Op) { ctx.ADDB(imr, amr) }

// ADDL: Add.
//
// Forms:
//
//	ADDL imm32 eax
//	ADDL imm32 m32
//	ADDL imm32 r32
//	ADDL imm8  m32
//	ADDL imm8  r32
//	ADDL m32   r32
//	ADDL r32   m32
//	ADDL r32   r32
//
// Construct and append a ADDL instruction to the active function.
func (c *Context) ADDL(imr, emr operand.Op) {
	c.addinstruction(x86.ADDL(imr, emr))
}

// ADDL: Add.
//
// Forms:
//
//	ADDL imm32 eax
//	ADDL imm32 m32
//	ADDL imm32 r32
//	ADDL imm8  m32
//	ADDL imm8  r32
//	ADDL m32   r32
//	ADDL r32   m32
//	ADDL r32   r32
//
// Construct and append a ADDL instruction to the active function.
// Operates on the global context.
func ADDL(imr, emr operand.Op) { ctx.ADDL(imr, emr) }

// ADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPD m128 xmm
//	ADDPD xmm  xmm
//
// Construct and append a ADDPD instruction to the active function.
func (c *Context) ADDPD(mx, x operand.Op) {
	c.addinstruction(x86.ADDPD(mx, x))
}

// ADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPD m128 xmm
//	ADDPD xmm  xmm
//
// Construct and append a ADDPD instruction to the active function.
// Operates on the global context.
func ADDPD(mx, x operand.Op) { ctx.ADDPD(mx, x) }

// ADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPS m128 xmm
//	ADDPS xmm  xmm
//
// Construct and append a ADDPS instruction to the active function.
func (c *Context) ADDPS(mx, x operand.Op) {
	c.addinstruction(x86.ADDPS(mx, x))
}

// ADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDPS m128 xmm
//	ADDPS xmm  xmm
//
// Construct and append a ADDPS instruction to the active function.
// Operates on the global context.
func ADDPS(mx, x operand.Op) { ctx.ADDPS(mx, x) }

// ADDQ: Add.
//
// Forms:
//
//	ADDQ imm32 m64
//	ADDQ imm32 r64
//	ADDQ imm32 rax
//	ADDQ imm8  m64
//	ADDQ imm8  r64
//	ADDQ m64   r64
//	ADDQ r64   m64
//	ADDQ r64   r64
//
// Construct and append a ADDQ instruction to the active function.
func (c *Context) ADDQ(imr, mr operand.Op) {
	c.addinstruction(x86.ADDQ(imr, mr))
}

// ADDQ: Add.
//
// Forms:
//
//	ADDQ imm32 m64
//	ADDQ imm32 r64
//	ADDQ imm32 rax
//	ADDQ imm8  m64
//	ADDQ imm8  r64
//	ADDQ m64   r64
//	ADDQ r64   m64
//	ADDQ r64   r64
//
// Construct and append a ADDQ instruction to the active function.
// Operates on the global context.
func ADDQ(imr, mr operand.Op) { ctx.ADDQ(imr, mr) }

// ADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSD m64 xmm
//	ADDSD xmm xmm
//
// Construct and append a ADDSD instruction to the active function.
func (c *Context) ADDSD(mx, x operand.Op) {
	c.addinstruction(x86.ADDSD(mx, x))
}

// ADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSD m64 xmm
//	ADDSD xmm xmm
//
// Construct and append a ADDSD instruction to the active function.
// Operates on the global context.
func ADDSD(mx, x operand.Op) { ctx.ADDSD(mx, x) }

// ADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSS m32 xmm
//	ADDSS xmm xmm
//
// Construct and append a ADDSS instruction to the active function.
func (c *Context) ADDSS(mx, x operand.Op) {
	c.addinstruction(x86.ADDSS(mx, x))
}

// ADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	ADDSS m32 xmm
//	ADDSS xmm xmm
//
// Construct and append a ADDSS instruction to the active function.
// Operates on the global context.
func ADDSS(mx, x operand.Op) { ctx.ADDSS(mx, x) }

// ADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPD m128 xmm
//	ADDSUBPD xmm  xmm
//
// Construct and append a ADDSUBPD instruction to the active function.
func (c *Context) ADDSUBPD(mx, x operand.Op) {
	c.addinstruction(x86.ADDSUBPD(mx, x))
}

// ADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPD m128 xmm
//	ADDSUBPD xmm  xmm
//
// Construct and append a ADDSUBPD instruction to the active function.
// Operates on the global context.
func ADDSUBPD(mx, x operand.Op) { ctx.ADDSUBPD(mx, x) }

// ADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPS m128 xmm
//	ADDSUBPS xmm  xmm
//
// Construct and append a ADDSUBPS instruction to the active function.
func (c *Context) ADDSUBPS(mx, x operand.Op) {
	c.addinstruction(x86.ADDSUBPS(mx, x))
}

// ADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	ADDSUBPS m128 xmm
//	ADDSUBPS xmm  xmm
//
// Construct and append a ADDSUBPS instruction to the active function.
// Operates on the global context.
func ADDSUBPS(mx, x operand.Op) { ctx.ADDSUBPS(mx, x) }

// ADDW: Add.
//
// Forms:
//
//	ADDW imm16 ax
//	ADDW imm16 m16
//	ADDW imm16 r16
//	ADDW imm8  m16
//	ADDW imm8  r16
//	ADDW m16   r16
//	ADDW r16   m16
//	ADDW r16   r16
//
// Construct and append a ADDW instruction to the active function.
func (c *Context) ADDW(imr, amr operand.Op) {
	c.addinstruction(x86.ADDW(imr, amr))
}

// ADDW: Add.
//
// Forms:
//
//	ADDW imm16 ax
//	ADDW imm16 m16
//	ADDW imm16 r16
//	ADDW imm8  m16
//	ADDW imm8  r16
//	ADDW m16   r16
//	ADDW r16   m16
//	ADDW r16   r16
//
// Construct and append a ADDW instruction to the active function.
// Operates on the global context.
func ADDW(imr, amr operand.Op) { ctx.ADDW(imr, amr) }

// ADOXL: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXL m32 r32
//	ADOXL r32 r32
//
// Construct and append a ADOXL instruction to the active function.
func (c *Context) ADOXL(mr, r operand.Op) {
	c.addinstruction(x86.ADOXL(mr, r))
}

// ADOXL: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXL m32 r32
//	ADOXL r32 r32
//
// Construct and append a ADOXL instruction to the active function.
// Operates on the global context.
func ADOXL(mr, r operand.Op) { ctx.ADOXL(mr, r) }

// ADOXQ: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXQ m64 r64
//	ADOXQ r64 r64
//
// Construct and append a ADOXQ instruction to the active function.
func (c *Context) ADOXQ(mr, r operand.Op) {
	c.addinstruction(x86.ADOXQ(mr, r))
}

// ADOXQ: Unsigned Integer Addition of Two Operands with Overflow Flag.
//
// Forms:
//
//	ADOXQ m64 r64
//	ADOXQ r64 r64
//
// Construct and append a ADOXQ instruction to the active function.
// Operates on the global context.
func ADOXQ(mr, r operand.Op) { ctx.ADOXQ(mr, r) }

// AESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDEC m128 xmm
//	AESDEC xmm  xmm
//
// Construct and append a AESDEC instruction to the active function.
func (c *Context) AESDEC(mx, x operand.Op) {
	c.addinstruction(x86.AESDEC(mx, x))
}

// AESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDEC m128 xmm
//	AESDEC xmm  xmm
//
// Construct and append a AESDEC instruction to the active function.
// Operates on the global context.
func AESDEC(mx, x operand.Op) { ctx.AESDEC(mx, x) }

// AESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDECLAST m128 xmm
//	AESDECLAST xmm  xmm
//
// Construct and append a AESDECLAST instruction to the active function.
func (c *Context) AESDECLAST(mx, x operand.Op) {
	c.addinstruction(x86.AESDECLAST(mx, x))
}

// AESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	AESDECLAST m128 xmm
//	AESDECLAST xmm  xmm
//
// Construct and append a AESDECLAST instruction to the active function.
// Operates on the global context.
func AESDECLAST(mx, x operand.Op) { ctx.AESDECLAST(mx, x) }

// AESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENC m128 xmm
//	AESENC xmm  xmm
//
// Construct and append a AESENC instruction to the active function.
func (c *Context) AESENC(mx, x operand.Op) {
	c.addinstruction(x86.AESENC(mx, x))
}

// AESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENC m128 xmm
//	AESENC xmm  xmm
//
// Construct and append a AESENC instruction to the active function.
// Operates on the global context.
func AESENC(mx, x operand.Op) { ctx.AESENC(mx, x) }

// AESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENCLAST m128 xmm
//	AESENCLAST xmm  xmm
//
// Construct and append a AESENCLAST instruction to the active function.
func (c *Context) AESENCLAST(mx, x operand.Op) {
	c.addinstruction(x86.AESENCLAST(mx, x))
}

// AESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	AESENCLAST m128 xmm
//	AESENCLAST xmm  xmm
//
// Construct and append a AESENCLAST instruction to the active function.
// Operates on the global context.
func AESENCLAST(mx, x operand.Op) { ctx.AESENCLAST(mx, x) }

// AESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	AESIMC m128 xmm
//	AESIMC xmm  xmm
//
// Construct and append a AESIMC instruction to the active function.
func (c *Context) AESIMC(mx, x operand.Op) {
	c.addinstruction(x86.AESIMC(mx, x))
}

// AESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	AESIMC m128 xmm
//	AESIMC xmm  xmm
//
// Construct and append a AESIMC instruction to the active function.
// Operates on the global context.
func AESIMC(mx, x operand.Op) { ctx.AESIMC(mx, x) }

// AESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	AESKEYGENASSIST imm8 m128 xmm
//	AESKEYGENASSIST imm8 xmm  xmm
//
// Construct and append a AESKEYGENASSIST instruction to the active function.
func (c *Context) AESKEYGENASSIST(i, mx, x operand.Op) {
	c.addinstruction(x86.AESKEYGENASSIST(i, mx, x))
}

// AESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	AESKEYGENASSIST imm8 m128 xmm
//	AESKEYGENASSIST imm8 xmm  xmm
//
// Construct and append a AESKEYGENASSIST instruction to the active function.
// Operates on the global context.
func AESKEYGENASSIST(i, mx, x operand.Op) { ctx.AESKEYGENASSIST(i, mx, x) }

// ANDB: Logical AND.
//
// Forms:
//
//	ANDB imm8 al
//	ANDB imm8 m8
//	ANDB imm8 r8
//	ANDB m8   r8
//	ANDB r8   m8
//	ANDB r8   r8
//
// Construct and append a ANDB instruction to the active function.
func (c *Context) ANDB(imr, amr operand.Op) {
	c.addinstruction(x86.ANDB(imr, amr))
}

// ANDB: Logical AND.
//
// Forms:
//
//	ANDB imm8 al
//	ANDB imm8 m8
//	ANDB imm8 r8
//	ANDB m8   r8
//	ANDB r8   m8
//	ANDB r8   r8
//
// Construct and append a ANDB instruction to the active function.
// Operates on the global context.
func ANDB(imr, amr operand.Op) { ctx.ANDB(imr, amr) }

// ANDL: Logical AND.
//
// Forms:
//
//	ANDL imm32 eax
//	ANDL imm32 m32
//	ANDL imm32 r32
//	ANDL imm8  m32
//	ANDL imm8  r32
//	ANDL m32   r32
//	ANDL r32   m32
//	ANDL r32   r32
//
// Construct and append a ANDL instruction to the active function.
func (c *Context) ANDL(imr, emr operand.Op) {
	c.addinstruction(x86.ANDL(imr, emr))
}

// ANDL: Logical AND.
//
// Forms:
//
//	ANDL imm32 eax
//	ANDL imm32 m32
//	ANDL imm32 r32
//	ANDL imm8  m32
//	ANDL imm8  r32
//	ANDL m32   r32
//	ANDL r32   m32
//	ANDL r32   r32
//
// Construct and append a ANDL instruction to the active function.
// Operates on the global context.
func ANDL(imr, emr operand.Op) { ctx.ANDL(imr, emr) }

// ANDNL: Logical AND NOT.
//
// Forms:
//
//	ANDNL m32 r32 r32
//	ANDNL r32 r32 r32
//
// Construct and append a ANDNL instruction to the active function.
func (c *Context) ANDNL(mr, r, r1 operand.Op) {
	c.addinstruction(x86.ANDNL(mr, r, r1))
}

// ANDNL: Logical AND NOT.
//
// Forms:
//
//	ANDNL m32 r32 r32
//	ANDNL r32 r32 r32
//
// Construct and append a ANDNL instruction to the active function.
// Operates on the global context.
func ANDNL(mr, r, r1 operand.Op) { ctx.ANDNL(mr, r, r1) }

// ANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPD m128 xmm
//	ANDNPD xmm  xmm
//
// Construct and append a ANDNPD instruction to the active function.
func (c *Context) ANDNPD(mx, x operand.Op) {
	c.addinstruction(x86.ANDNPD(mx, x))
}

// ANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPD m128 xmm
//	ANDNPD xmm  xmm
//
// Construct and append a ANDNPD instruction to the active function.
// Operates on the global context.
func ANDNPD(mx, x operand.Op) { ctx.ANDNPD(mx, x) }

// ANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPS m128 xmm
//	ANDNPS xmm  xmm
//
// Construct and append a ANDNPS instruction to the active function.
func (c *Context) ANDNPS(mx, x operand.Op) {
	c.addinstruction(x86.ANDNPS(mx, x))
}

// ANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDNPS m128 xmm
//	ANDNPS xmm  xmm
//
// Construct and append a ANDNPS instruction to the active function.
// Operates on the global context.
func ANDNPS(mx, x operand.Op) { ctx.ANDNPS(mx, x) }

// ANDNQ: Logical AND NOT.
//
// Forms:
//
//	ANDNQ m64 r64 r64
//	ANDNQ r64 r64 r64
//
// Construct and append a ANDNQ instruction to the active function.
func (c *Context) ANDNQ(mr, r, r1 operand.Op) {
	c.addinstruction(x86.ANDNQ(mr, r, r1))
}

// ANDNQ: Logical AND NOT.
//
// Forms:
//
//	ANDNQ m64 r64 r64
//	ANDNQ r64 r64 r64
//
// Construct and append a ANDNQ instruction to the active function.
// Operates on the global context.
func ANDNQ(mr, r, r1 operand.Op) { ctx.ANDNQ(mr, r, r1) }

// ANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPD m128 xmm
//	ANDPD xmm  xmm
//
// Construct and append a ANDPD instruction to the active function.
func (c *Context) ANDPD(mx, x operand.Op) {
	c.addinstruction(x86.ANDPD(mx, x))
}

// ANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPD m128 xmm
//	ANDPD xmm  xmm
//
// Construct and append a ANDPD instruction to the active function.
// Operates on the global context.
func ANDPD(mx, x operand.Op) { ctx.ANDPD(mx, x) }

// ANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPS m128 xmm
//	ANDPS xmm  xmm
//
// Construct and append a ANDPS instruction to the active function.
func (c *Context) ANDPS(mx, x operand.Op) {
	c.addinstruction(x86.ANDPS(mx, x))
}

// ANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	ANDPS m128 xmm
//	ANDPS xmm  xmm
//
// Construct and append a ANDPS instruction to the active function.
// Operates on the global context.
func ANDPS(mx, x operand.Op) { ctx.ANDPS(mx, x) }

// ANDQ: Logical AND.
//
// Forms:
//
//	ANDQ imm32 m64
//	ANDQ imm32 r64
//	ANDQ imm32 rax
//	ANDQ imm8  m64
//	ANDQ imm8  r64
//	ANDQ m64   r64
//	ANDQ r64   m64
//	ANDQ r64   r64
//
// Construct and append a ANDQ instruction to the active function.
func (c *Context) ANDQ(imr, mr operand.Op) {
	c.addinstruction(x86.ANDQ(imr, mr))
}

// ANDQ: Logical AND.
//
// Forms:
//
//	ANDQ imm32 m64
//	ANDQ imm32 r64
//	ANDQ imm32 rax
//	ANDQ imm8  m64
//	ANDQ imm8  r64
//	ANDQ m64   r64
//	ANDQ r64   m64
//	ANDQ r64   r64
//
// Construct and append a ANDQ instruction to the active function.
// Operates on the global context.
func ANDQ(imr, mr operand.Op) { ctx.ANDQ(imr, mr) }

// ANDW: Logical AND.
//
// Forms:
//
//	ANDW imm16 ax
//	ANDW imm16 m16
//	ANDW imm16 r16
//	ANDW imm8  m16
//	ANDW imm8  r16
//	ANDW m16   r16
//	ANDW r16   m16
//	ANDW r16   r16
//
// Construct and append a ANDW instruction to the active function.
func (c *Context) ANDW(imr, amr operand.Op) {
	c.addinstruction(x86.ANDW(imr, amr))
}

// ANDW: Logical AND.
//
// Forms:
//
//	ANDW imm16 ax
//	ANDW imm16 m16
//	ANDW imm16 r16
//	ANDW imm8  m16
//	ANDW imm8  r16
//	ANDW m16   r16
//	ANDW r16   m16
//	ANDW r16   r16
//
// Construct and append a ANDW instruction to the active function.
// Operates on the global context.
func ANDW(imr, amr operand.Op) { ctx.ANDW(imr, amr) }

// BEXTRL: Bit Field Extract.
//
// Forms:
//
//	BEXTRL r32 m32 r32
//	BEXTRL r32 r32 r32
//
// Construct and append a BEXTRL instruction to the active function.
func (c *Context) BEXTRL(r, mr, r1 operand.Op) {
	c.addinstruction(x86.BEXTRL(r, mr, r1))
}

// BEXTRL: Bit Field Extract.
//
// Forms:
//
//	BEXTRL r32 m32 r32
//	BEXTRL r32 r32 r32
//
// Construct and append a BEXTRL instruction to the active function.
// Operates on the global context.
func BEXTRL(r, mr, r1 operand.Op) { ctx.BEXTRL(r, mr, r1) }

// BEXTRQ: Bit Field Extract.
//
// Forms:
//
//	BEXTRQ r64 m64 r64
//	BEXTRQ r64 r64 r64
//
// Construct and append a BEXTRQ instruction to the active function.
func (c *Context) BEXTRQ(r, mr, r1 operand.Op) {
	c.addinstruction(x86.BEXTRQ(r, mr, r1))
}

// BEXTRQ: Bit Field Extract.
//
// Forms:
//
//	BEXTRQ r64 m64 r64
//	BEXTRQ r64 r64 r64
//
// Construct and append a BEXTRQ instruction to the active function.
// Operates on the global context.
func BEXTRQ(r, mr, r1 operand.Op) { ctx.BEXTRQ(r, mr, r1) }

// BLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPD imm8 m128 xmm
//	BLENDPD imm8 xmm  xmm
//
// Construct and append a BLENDPD instruction to the active function.
func (c *Context) BLENDPD(i, mx, x operand.Op) {
	c.addinstruction(x86.BLENDPD(i, mx, x))
}

// BLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPD imm8 m128 xmm
//	BLENDPD imm8 xmm  xmm
//
// Construct and append a BLENDPD instruction to the active function.
// Operates on the global context.
func BLENDPD(i, mx, x operand.Op) { ctx.BLENDPD(i, mx, x) }

// BLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPS imm8 m128 xmm
//	BLENDPS imm8 xmm  xmm
//
// Construct and append a BLENDPS instruction to the active function.
func (c *Context) BLENDPS(i, mx, x operand.Op) {
	c.addinstruction(x86.BLENDPS(i, mx, x))
}

// BLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDPS imm8 m128 xmm
//	BLENDPS imm8 xmm  xmm
//
// Construct and append a BLENDPS instruction to the active function.
// Operates on the global context.
func BLENDPS(i, mx, x operand.Op) { ctx.BLENDPS(i, mx, x) }

// BLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPD xmm0 m128 xmm
//	BLENDVPD xmm0 xmm  xmm
//
// Construct and append a BLENDVPD instruction to the active function.
func (c *Context) BLENDVPD(x, mx, x1 operand.Op) {
	c.addinstruction(x86.BLENDVPD(x, mx, x1))
}

// BLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPD xmm0 m128 xmm
//	BLENDVPD xmm0 xmm  xmm
//
// Construct and append a BLENDVPD instruction to the active function.
// Operates on the global context.
func BLENDVPD(x, mx, x1 operand.Op) { ctx.BLENDVPD(x, mx, x1) }

// BLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPS xmm0 m128 xmm
//	BLENDVPS xmm0 xmm  xmm
//
// Construct and append a BLENDVPS instruction to the active function.
func (c *Context) BLENDVPS(x, mx, x1 operand.Op) {
	c.addinstruction(x86.BLENDVPS(x, mx, x1))
}

// BLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	BLENDVPS xmm0 m128 xmm
//	BLENDVPS xmm0 xmm  xmm
//
// Construct and append a BLENDVPS instruction to the active function.
// Operates on the global context.
func BLENDVPS(x, mx, x1 operand.Op) { ctx.BLENDVPS(x, mx, x1) }

// BLSIL: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIL m32 r32
//	BLSIL r32 r32
//
// Construct and append a BLSIL instruction to the active function.
func (c *Context) BLSIL(mr, r operand.Op) {
	c.addinstruction(x86.BLSIL(mr, r))
}

// BLSIL: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIL m32 r32
//	BLSIL r32 r32
//
// Construct and append a BLSIL instruction to the active function.
// Operates on the global context.
func BLSIL(mr, r operand.Op) { ctx.BLSIL(mr, r) }

// BLSIQ: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIQ m64 r64
//	BLSIQ r64 r64
//
// Construct and append a BLSIQ instruction to the active function.
func (c *Context) BLSIQ(mr, r operand.Op) {
	c.addinstruction(x86.BLSIQ(mr, r))
}

// BLSIQ: Isolate Lowest Set Bit.
//
// Forms:
//
//	BLSIQ m64 r64
//	BLSIQ r64 r64
//
// Construct and append a BLSIQ instruction to the active function.
// Operates on the global context.
func BLSIQ(mr, r operand.Op) { ctx.BLSIQ(mr, r) }

// BLSMSKL: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKL m32 r32
//	BLSMSKL r32 r32
//
// Construct and append a BLSMSKL instruction to the active function.
func (c *Context) BLSMSKL(mr, r operand.Op) {
	c.addinstruction(x86.BLSMSKL(mr, r))
}

// BLSMSKL: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKL m32 r32
//	BLSMSKL r32 r32
//
// Construct and append a BLSMSKL instruction to the active function.
// Operates on the global context.
func BLSMSKL(mr, r operand.Op) { ctx.BLSMSKL(mr, r) }

// BLSMSKQ: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKQ m64 r64
//	BLSMSKQ r64 r64
//
// Construct and append a BLSMSKQ instruction to the active function.
func (c *Context) BLSMSKQ(mr, r operand.Op) {
	c.addinstruction(x86.BLSMSKQ(mr, r))
}

// BLSMSKQ: Mask From Lowest Set Bit.
//
// Forms:
//
//	BLSMSKQ m64 r64
//	BLSMSKQ r64 r64
//
// Construct and append a BLSMSKQ instruction to the active function.
// Operates on the global context.
func BLSMSKQ(mr, r operand.Op) { ctx.BLSMSKQ(mr, r) }

// BLSRL: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRL m32 r32
//	BLSRL r32 r32
//
// Construct and append a BLSRL instruction to the active function.
func (c *Context) BLSRL(mr, r operand.Op) {
	c.addinstruction(x86.BLSRL(mr, r))
}

// BLSRL: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRL m32 r32
//	BLSRL r32 r32
//
// Construct and append a BLSRL instruction to the active function.
// Operates on the global context.
func BLSRL(mr, r operand.Op) { ctx.BLSRL(mr, r) }

// BLSRQ: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRQ m64 r64
//	BLSRQ r64 r64
//
// Construct and append a BLSRQ instruction to the active function.
func (c *Context) BLSRQ(mr, r operand.Op) {
	c.addinstruction(x86.BLSRQ(mr, r))
}

// BLSRQ: Reset Lowest Set Bit.
//
// Forms:
//
//	BLSRQ m64 r64
//	BLSRQ r64 r64
//
// Construct and append a BLSRQ instruction to the active function.
// Operates on the global context.
func BLSRQ(mr, r operand.Op) { ctx.BLSRQ(mr, r) }

// BSFL: Bit Scan Forward.
//
// Forms:
//
//	BSFL m32 r32
//	BSFL r32 r32
//
// Construct and append a BSFL instruction to the active function.
func (c *Context) BSFL(mr, r operand.Op) {
	c.addinstruction(x86.BSFL(mr, r))
}

// BSFL: Bit Scan Forward.
//
// Forms:
//
//	BSFL m32 r32
//	BSFL r32 r32
//
// Construct and append a BSFL instruction to the active function.
// Operates on the global context.
func BSFL(mr, r operand.Op) { ctx.BSFL(mr, r) }

// BSFQ: Bit Scan Forward.
//
// Forms:
//
//	BSFQ m64 r64
//	BSFQ r64 r64
//
// Construct and append a BSFQ instruction to the active function.
func (c *Context) BSFQ(mr, r operand.Op) {
	c.addinstruction(x86.BSFQ(mr, r))
}

// BSFQ: Bit Scan Forward.
//
// Forms:
//
//	BSFQ m64 r64
//	BSFQ r64 r64
//
// Construct and append a BSFQ instruction to the active function.
// Operates on the global context.
func BSFQ(mr, r operand.Op) { ctx.BSFQ(mr, r) }

// BSFW: Bit Scan Forward.
//
// Forms:
//
//	BSFW m16 r16
//	BSFW r16 r16
//
// Construct and append a BSFW instruction to the active function.
func (c *Context) BSFW(mr, r operand.Op) {
	c.addinstruction(x86.BSFW(mr, r))
}

// BSFW: Bit Scan Forward.
//
// Forms:
//
//	BSFW m16 r16
//	BSFW r16 r16
//
// Construct and append a BSFW instruction to the active function.
// Operates on the global context.
func BSFW(mr, r operand.Op) { ctx.BSFW(mr, r) }

// BSRL: Bit Scan Reverse.
//
// Forms:
//
//	BSRL m32 r32
//	BSRL r32 r32
//
// Construct and append a BSRL instruction to the active function.
func (c *Context) BSRL(mr, r operand.Op) {
	c.addinstruction(x86.BSRL(mr, r))
}

// BSRL: Bit Scan Reverse.
//
// Forms:
//
//	BSRL m32 r32
//	BSRL r32 r32
//
// Construct and append a BSRL instruction to the active function.
// Operates on the global context.
func BSRL(mr, r operand.Op) { ctx.BSRL(mr, r) }

// BSRQ: Bit Scan Reverse.
//
// Forms:
//
//	BSRQ m64 r64
//	BSRQ r64 r64
//
// Construct and append a BSRQ instruction to the active function.
func (c *Context) BSRQ(mr, r operand.Op) {
	c.addinstruction(x86.BSRQ(mr, r))
}

// BSRQ: Bit Scan Reverse.
//
// Forms:
//
//	BSRQ m64 r64
//	BSRQ r64 r64
//
// Construct and append a BSRQ instruction to the active function.
// Operates on the global context.
func BSRQ(mr, r operand.Op) { ctx.BSRQ(mr, r) }

// BSRW: Bit Scan Reverse.
//
// Forms:
//
//	BSRW m16 r16
//	BSRW r16 r16
//
// Construct and append a BSRW instruction to the active function.
func (c *Context) BSRW(mr, r operand.Op) {
	c.addinstruction(x86.BSRW(mr, r))
}

// BSRW: Bit Scan Reverse.
//
// Forms:
//
//	BSRW m16 r16
//	BSRW r16 r16
//
// Construct and append a BSRW instruction to the active function.
// Operates on the global context.
func BSRW(mr, r operand.Op) { ctx.BSRW(mr, r) }

// BSWAPL: Byte Swap.
//
// Forms:
//
//	BSWAPL r32
//
// Construct and append a BSWAPL instruction to the active function.
func (c *Context) BSWAPL(r operand.Op) {
	c.addinstruction(x86.BSWAPL(r))
}

// BSWAPL: Byte Swap.
//
// Forms:
//
//	BSWAPL r32
//
// Construct and append a BSWAPL instruction to the active function.
// Operates on the global context.
func BSWAPL(r operand.Op) { ctx.BSWAPL(r) }

// BSWAPQ: Byte Swap.
//
// Forms:
//
//	BSWAPQ r64
//
// Construct and append a BSWAPQ instruction to the active function.
func (c *Context) BSWAPQ(r operand.Op) {
	c.addinstruction(x86.BSWAPQ(r))
}

// BSWAPQ: Byte Swap.
//
// Forms:
//
//	BSWAPQ r64
//
// Construct and append a BSWAPQ instruction to the active function.
// Operates on the global context.
func BSWAPQ(r operand.Op) { ctx.BSWAPQ(r) }

// BTCL: Bit Test and Complement.
//
// Forms:
//
//	BTCL imm8 m32
//	BTCL imm8 r32
//	BTCL r32  m32
//	BTCL r32  r32
//
// Construct and append a BTCL instruction to the active function.
func (c *Context) BTCL(ir, mr operand.Op) {
	c.addinstruction(x86.BTCL(ir, mr))
}

// BTCL: Bit Test and Complement.
//
// Forms:
//
//	BTCL imm8 m32
//	BTCL imm8 r32
//	BTCL r32  m32
//	BTCL r32  r32
//
// Construct and append a BTCL instruction to the active function.
// Operates on the global context.
func BTCL(ir, mr operand.Op) { ctx.BTCL(ir, mr) }

// BTCQ: Bit Test and Complement.
//
// Forms:
//
//	BTCQ imm8 m64
//	BTCQ imm8 r64
//	BTCQ r64  m64
//	BTCQ r64  r64
//
// Construct and append a BTCQ instruction to the active function.
func (c *Context) BTCQ(ir, mr operand.Op) {
	c.addinstruction(x86.BTCQ(ir, mr))
}

// BTCQ: Bit Test and Complement.
//
// Forms:
//
//	BTCQ imm8 m64
//	BTCQ imm8 r64
//	BTCQ r64  m64
//	BTCQ r64  r64
//
// Construct and append a BTCQ instruction to the active function.
// Operates on the global context.
func BTCQ(ir, mr operand.Op) { ctx.BTCQ(ir, mr) }

// BTCW: Bit Test and Complement.
//
// Forms:
//
//	BTCW imm8 m16
//	BTCW imm8 r16
//	BTCW r16  m16
//	BTCW r16  r16
//
// Construct and append a BTCW instruction to the active function.
func (c *Context) BTCW(ir, mr operand.Op) {
	c.addinstruction(x86.BTCW(ir, mr))
}

// BTCW: Bit Test and Complement.
//
// Forms:
//
//	BTCW imm8 m16
//	BTCW imm8 r16
//	BTCW r16  m16
//	BTCW r16  r16
//
// Construct and append a BTCW instruction to the active function.
// Operates on the global context.
func BTCW(ir, mr operand.Op) { ctx.BTCW(ir, mr) }

// BTL: Bit Test.
//
// Forms:
//
//	BTL imm8 m32
//	BTL imm8 r32
//	BTL r32  m32
//	BTL r32  r32
//
// Construct and append a BTL instruction to the active function.
func (c *Context) BTL(ir, mr operand.Op) {
	c.addinstruction(x86.BTL(ir, mr))
}

// BTL: Bit Test.
//
// Forms:
//
//	BTL imm8 m32
//	BTL imm8 r32
//	BTL r32  m32
//	BTL r32  r32
//
// Construct and append a BTL instruction to the active function.
// Operates on the global context.
func BTL(ir, mr operand.Op) { ctx.BTL(ir, mr) }

// BTQ: Bit Test.
//
// Forms:
//
//	BTQ imm8 m64
//	BTQ imm8 r64
//	BTQ r64  m64
//	BTQ r64  r64
//
// Construct and append a BTQ instruction to the active function.
func (c *Context) BTQ(ir, mr operand.Op) {
	c.addinstruction(x86.BTQ(ir, mr))
}

// BTQ: Bit Test.
//
// Forms:
//
//	BTQ imm8 m64
//	BTQ imm8 r64
//	BTQ r64  m64
//	BTQ r64  r64
//
// Construct and append a BTQ instruction to the active function.
// Operates on the global context.
func BTQ(ir, mr operand.Op) { ctx.BTQ(ir, mr) }

// BTRL: Bit Test and Reset.
//
// Forms:
//
//	BTRL imm8 m32
//	BTRL imm8 r32
//	BTRL r32  m32
//	BTRL r32  r32
//
// Construct and append a BTRL instruction to the active function.
func (c *Context) BTRL(ir, mr operand.Op) {
	c.addinstruction(x86.BTRL(ir, mr))
}

// BTRL: Bit Test and Reset.
//
// Forms:
//
//	BTRL imm8 m32
//	BTRL imm8 r32
//	BTRL r32  m32
//	BTRL r32  r32
//
// Construct and append a BTRL instruction to the active function.
// Operates on the global context.
func BTRL(ir, mr operand.Op) { ctx.BTRL(ir, mr) }

// BTRQ: Bit Test and Reset.
//
// Forms:
//
//	BTRQ imm8 m64
//	BTRQ imm8 r64
//	BTRQ r64  m64
//	BTRQ r64  r64
//
// Construct and append a BTRQ instruction to the active function.
func (c *Context) BTRQ(ir, mr operand.Op) {
	c.addinstruction(x86.BTRQ(ir, mr))
}

// BTRQ: Bit Test and Reset.
//
// Forms:
//
//	BTRQ imm8 m64
//	BTRQ imm8 r64
//	BTRQ r64  m64
//	BTRQ r64  r64
//
// Construct and append a BTRQ instruction to the active function.
// Operates on the global context.
func BTRQ(ir, mr operand.Op) { ctx.BTRQ(ir, mr) }

// BTRW: Bit Test and Reset.
//
// Forms:
//
//	BTRW imm8 m16
//	BTRW imm8 r16
//	BTRW r16  m16
//	BTRW r16  r16
//
// Construct and append a BTRW instruction to the active function.
func (c *Context) BTRW(ir, mr operand.Op) {
	c.addinstruction(x86.BTRW(ir, mr))
}

// BTRW: Bit Test and Reset.
//
// Forms:
//
//	BTRW imm8 m16
//	BTRW imm8 r16
//	BTRW r16  m16
//	BTRW r16  r16
//
// Construct and append a BTRW instruction to the active function.
// Operates on the global context.
func BTRW(ir, mr operand.Op) { ctx.BTRW(ir, mr) }

// BTSL: Bit Test and Set.
//
// Forms:
//
//	BTSL imm8 m32
//	BTSL imm8 r32
//	BTSL r32  m32
//	BTSL r32  r32
//
// Construct and append a BTSL instruction to the active function.
func (c *Context) BTSL(ir, mr operand.Op) {
	c.addinstruction(x86.BTSL(ir, mr))
}

// BTSL: Bit Test and Set.
//
// Forms:
//
//	BTSL imm8 m32
//	BTSL imm8 r32
//	BTSL r32  m32
//	BTSL r32  r32
//
// Construct and append a BTSL instruction to the active function.
// Operates on the global context.
func BTSL(ir, mr operand.Op) { ctx.BTSL(ir, mr) }

// BTSQ: Bit Test and Set.
//
// Forms:
//
//	BTSQ imm8 m64
//	BTSQ imm8 r64
//	BTSQ r64  m64
//	BTSQ r64  r64
//
// Construct and append a BTSQ instruction to the active function.
func (c *Context) BTSQ(ir, mr operand.Op) {
	c.addinstruction(x86.BTSQ(ir, mr))
}

// BTSQ: Bit Test and Set.
//
// Forms:
//
//	BTSQ imm8 m64
//	BTSQ imm8 r64
//	BTSQ r64  m64
//	BTSQ r64  r64
//
// Construct and append a BTSQ instruction to the active function.
// Operates on the global context.
func BTSQ(ir, mr operand.Op) { ctx.BTSQ(ir, mr) }

// BTSW: Bit Test and Set.
//
// Forms:
//
//	BTSW imm8 m16
//	BTSW imm8 r16
//	BTSW r16  m16
//	BTSW r16  r16
//
// Construct and append a BTSW instruction to the active function.
func (c *Context) BTSW(ir, mr operand.Op) {
	c.addinstruction(x86.BTSW(ir, mr))
}

// BTSW: Bit Test and Set.
//
// Forms:
//
//	BTSW imm8 m16
//	BTSW imm8 r16
//	BTSW r16  m16
//	BTSW r16  r16
//
// Construct and append a BTSW instruction to the active function.
// Operates on the global context.
func BTSW(ir, mr operand.Op) { ctx.BTSW(ir, mr) }

// BTW: Bit Test.
//
// Forms:
//
//	BTW imm8 m16
//	BTW imm8 r16
//	BTW r16  m16
//	BTW r16  r16
//
// Construct and append a BTW instruction to the active function.
func (c *Context) BTW(ir, mr operand.Op) {
	c.addinstruction(x86.BTW(ir, mr))
}

// BTW: Bit Test.
//
// Forms:
//
//	BTW imm8 m16
//	BTW imm8 r16
//	BTW r16  m16
//	BTW r16  r16
//
// Construct and append a BTW instruction to the active function.
// Operates on the global context.
func BTW(ir, mr operand.Op) { ctx.BTW(ir, mr) }

// BZHIL: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIL r32 m32 r32
//	BZHIL r32 r32 r32
//
// Construct and append a BZHIL instruction to the active function.
func (c *Context) BZHIL(r, mr, r1 operand.Op) {
	c.addinstruction(x86.BZHIL(r, mr, r1))
}

// BZHIL: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIL r32 m32 r32
//	BZHIL r32 r32 r32
//
// Construct and append a BZHIL instruction to the active function.
// Operates on the global context.
func BZHIL(r, mr, r1 operand.Op) { ctx.BZHIL(r, mr, r1) }

// BZHIQ: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIQ r64 m64 r64
//	BZHIQ r64 r64 r64
//
// Construct and append a BZHIQ instruction to the active function.
func (c *Context) BZHIQ(r, mr, r1 operand.Op) {
	c.addinstruction(x86.BZHIQ(r, mr, r1))
}

// BZHIQ: Zero High Bits Starting with Specified Bit Position.
//
// Forms:
//
//	BZHIQ r64 m64 r64
//	BZHIQ r64 r64 r64
//
// Construct and append a BZHIQ instruction to the active function.
// Operates on the global context.
func BZHIQ(r, mr, r1 operand.Op) { ctx.BZHIQ(r, mr, r1) }

// CALL: Call Procedure.
//
// Forms:
//
//	CALL rel32
//
// Construct and append a CALL instruction to the active function.
func (c *Context) CALL(r operand.Op) {
	c.addinstruction(x86.CALL(r))
}

// CALL: Call Procedure.
//
// Forms:
//
//	CALL rel32
//
// Construct and append a CALL instruction to the active function.
// Operates on the global context.
func CALL(r operand.Op) { ctx.CALL(r) }

// CBW: Convert Byte to Word.
//
// Forms:
//
//	CBW
//
// Construct and append a CBW instruction to the active function.
func (c *Context) CBW() {
	c.addinstruction(x86.CBW())
}

// CBW: Convert Byte to Word.
//
// Forms:
//
//	CBW
//
// Construct and append a CBW instruction to the active function.
// Operates on the global context.
func CBW() { ctx.CBW() }

// CDQ: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQ
//
// Construct and append a CDQ instruction to the active function.
func (c *Context) CDQ() {
	c.addinstruction(x86.CDQ())
}

// CDQ: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQ
//
// Construct and append a CDQ instruction to the active function.
// Operates on the global context.
func CDQ() { ctx.CDQ() }

// CDQE: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQE
//
// Construct and append a CDQE instruction to the active function.
func (c *Context) CDQE() {
	c.addinstruction(x86.CDQE())
}

// CDQE: Convert Doubleword to Quadword.
//
// Forms:
//
//	CDQE
//
// Construct and append a CDQE instruction to the active function.
// Operates on the global context.
func CDQE() { ctx.CDQE() }

// CLC: Clear Carry Flag.
//
// Forms:
//
//	CLC
//
// Construct and append a CLC instruction to the active function.
func (c *Context) CLC() {
	c.addinstruction(x86.CLC())
}

// CLC: Clear Carry Flag.
//
// Forms:
//
//	CLC
//
// Construct and append a CLC instruction to the active function.
// Operates on the global context.
func CLC() { ctx.CLC() }

// CLD: Clear Direction Flag.
//
// Forms:
//
//	CLD
//
// Construct and append a CLD instruction to the active function.
func (c *Context) CLD() {
	c.addinstruction(x86.CLD())
}

// CLD: Clear Direction Flag.
//
// Forms:
//
//	CLD
//
// Construct and append a CLD instruction to the active function.
// Operates on the global context.
func CLD() { ctx.CLD() }

// CLFLUSH: Flush Cache Line.
//
// Forms:
//
//	CLFLUSH m8
//
// Construct and append a CLFLUSH instruction to the active function.
func (c *Context) CLFLUSH(m operand.Op) {
	c.addinstruction(x86.CLFLUSH(m))
}

// CLFLUSH: Flush Cache Line.
//
// Forms:
//
//	CLFLUSH m8
//
// Construct and append a CLFLUSH instruction to the active function.
// Operates on the global context.
func CLFLUSH(m operand.Op) { ctx.CLFLUSH(m) }

// CLFLUSHOPT: Flush Cache Line Optimized.
//
// Forms:
//
//	CLFLUSHOPT m8
//
// Construct and append a CLFLUSHOPT instruction to the active function.
func (c *Context) CLFLUSHOPT(m operand.Op) {
	c.addinstruction(x86.CLFLUSHOPT(m))
}

// CLFLUSHOPT: Flush Cache Line Optimized.
//
// Forms:
//
//	CLFLUSHOPT m8
//
// Construct and append a CLFLUSHOPT instruction to the active function.
// Operates on the global context.
func CLFLUSHOPT(m operand.Op) { ctx.CLFLUSHOPT(m) }

// CMC: Complement Carry Flag.
//
// Forms:
//
//	CMC
//
// Construct and append a CMC instruction to the active function.
func (c *Context) CMC() {
	c.addinstruction(x86.CMC())
}

// CMC: Complement Carry Flag.
//
// Forms:
//
//	CMC
//
// Construct and append a CMC instruction to the active function.
// Operates on the global context.
func CMC() { ctx.CMC() }

// CMOVLCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVLCC m32 r32
//	CMOVLCC r32 r32
//
// Construct and append a CMOVLCC instruction to the active function.
func (c *Context) CMOVLCC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLCC(mr, r))
}

// CMOVLCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVLCC m32 r32
//	CMOVLCC r32 r32
//
// Construct and append a CMOVLCC instruction to the active function.
// Operates on the global context.
func CMOVLCC(mr, r operand.Op) { ctx.CMOVLCC(mr, r) }

// CMOVLCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVLCS m32 r32
//	CMOVLCS r32 r32
//
// Construct and append a CMOVLCS instruction to the active function.
func (c *Context) CMOVLCS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLCS(mr, r))
}

// CMOVLCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVLCS m32 r32
//	CMOVLCS r32 r32
//
// Construct and append a CMOVLCS instruction to the active function.
// Operates on the global context.
func CMOVLCS(mr, r operand.Op) { ctx.CMOVLCS(mr, r) }

// CMOVLEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVLEQ m32 r32
//	CMOVLEQ r32 r32
//
// Construct and append a CMOVLEQ instruction to the active function.
func (c *Context) CMOVLEQ(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLEQ(mr, r))
}

// CMOVLEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVLEQ m32 r32
//	CMOVLEQ r32 r32
//
// Construct and append a CMOVLEQ instruction to the active function.
// Operates on the global context.
func CMOVLEQ(mr, r operand.Op) { ctx.CMOVLEQ(mr, r) }

// CMOVLGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVLGE m32 r32
//	CMOVLGE r32 r32
//
// Construct and append a CMOVLGE instruction to the active function.
func (c *Context) CMOVLGE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLGE(mr, r))
}

// CMOVLGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVLGE m32 r32
//	CMOVLGE r32 r32
//
// Construct and append a CMOVLGE instruction to the active function.
// Operates on the global context.
func CMOVLGE(mr, r operand.Op) { ctx.CMOVLGE(mr, r) }

// CMOVLGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVLGT m32 r32
//	CMOVLGT r32 r32
//
// Construct and append a CMOVLGT instruction to the active function.
func (c *Context) CMOVLGT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLGT(mr, r))
}

// CMOVLGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVLGT m32 r32
//	CMOVLGT r32 r32
//
// Construct and append a CMOVLGT instruction to the active function.
// Operates on the global context.
func CMOVLGT(mr, r operand.Op) { ctx.CMOVLGT(mr, r) }

// CMOVLHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVLHI m32 r32
//	CMOVLHI r32 r32
//
// Construct and append a CMOVLHI instruction to the active function.
func (c *Context) CMOVLHI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLHI(mr, r))
}

// CMOVLHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVLHI m32 r32
//	CMOVLHI r32 r32
//
// Construct and append a CMOVLHI instruction to the active function.
// Operates on the global context.
func CMOVLHI(mr, r operand.Op) { ctx.CMOVLHI(mr, r) }

// CMOVLLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVLLE m32 r32
//	CMOVLLE r32 r32
//
// Construct and append a CMOVLLE instruction to the active function.
func (c *Context) CMOVLLE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLLE(mr, r))
}

// CMOVLLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVLLE m32 r32
//	CMOVLLE r32 r32
//
// Construct and append a CMOVLLE instruction to the active function.
// Operates on the global context.
func CMOVLLE(mr, r operand.Op) { ctx.CMOVLLE(mr, r) }

// CMOVLLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVLLS m32 r32
//	CMOVLLS r32 r32
//
// Construct and append a CMOVLLS instruction to the active function.
func (c *Context) CMOVLLS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLLS(mr, r))
}

// CMOVLLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVLLS m32 r32
//	CMOVLLS r32 r32
//
// Construct and append a CMOVLLS instruction to the active function.
// Operates on the global context.
func CMOVLLS(mr, r operand.Op) { ctx.CMOVLLS(mr, r) }

// CMOVLLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVLLT m32 r32
//	CMOVLLT r32 r32
//
// Construct and append a CMOVLLT instruction to the active function.
func (c *Context) CMOVLLT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLLT(mr, r))
}

// CMOVLLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVLLT m32 r32
//	CMOVLLT r32 r32
//
// Construct and append a CMOVLLT instruction to the active function.
// Operates on the global context.
func CMOVLLT(mr, r operand.Op) { ctx.CMOVLLT(mr, r) }

// CMOVLMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVLMI m32 r32
//	CMOVLMI r32 r32
//
// Construct and append a CMOVLMI instruction to the active function.
func (c *Context) CMOVLMI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLMI(mr, r))
}

// CMOVLMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVLMI m32 r32
//	CMOVLMI r32 r32
//
// Construct and append a CMOVLMI instruction to the active function.
// Operates on the global context.
func CMOVLMI(mr, r operand.Op) { ctx.CMOVLMI(mr, r) }

// CMOVLNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVLNE m32 r32
//	CMOVLNE r32 r32
//
// Construct and append a CMOVLNE instruction to the active function.
func (c *Context) CMOVLNE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLNE(mr, r))
}

// CMOVLNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVLNE m32 r32
//	CMOVLNE r32 r32
//
// Construct and append a CMOVLNE instruction to the active function.
// Operates on the global context.
func CMOVLNE(mr, r operand.Op) { ctx.CMOVLNE(mr, r) }

// CMOVLOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVLOC m32 r32
//	CMOVLOC r32 r32
//
// Construct and append a CMOVLOC instruction to the active function.
func (c *Context) CMOVLOC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLOC(mr, r))
}

// CMOVLOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVLOC m32 r32
//	CMOVLOC r32 r32
//
// Construct and append a CMOVLOC instruction to the active function.
// Operates on the global context.
func CMOVLOC(mr, r operand.Op) { ctx.CMOVLOC(mr, r) }

// CMOVLOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVLOS m32 r32
//	CMOVLOS r32 r32
//
// Construct and append a CMOVLOS instruction to the active function.
func (c *Context) CMOVLOS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLOS(mr, r))
}

// CMOVLOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVLOS m32 r32
//	CMOVLOS r32 r32
//
// Construct and append a CMOVLOS instruction to the active function.
// Operates on the global context.
func CMOVLOS(mr, r operand.Op) { ctx.CMOVLOS(mr, r) }

// CMOVLPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVLPC m32 r32
//	CMOVLPC r32 r32
//
// Construct and append a CMOVLPC instruction to the active function.
func (c *Context) CMOVLPC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLPC(mr, r))
}

// CMOVLPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVLPC m32 r32
//	CMOVLPC r32 r32
//
// Construct and append a CMOVLPC instruction to the active function.
// Operates on the global context.
func CMOVLPC(mr, r operand.Op) { ctx.CMOVLPC(mr, r) }

// CMOVLPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVLPL m32 r32
//	CMOVLPL r32 r32
//
// Construct and append a CMOVLPL instruction to the active function.
func (c *Context) CMOVLPL(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLPL(mr, r))
}

// CMOVLPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVLPL m32 r32
//	CMOVLPL r32 r32
//
// Construct and append a CMOVLPL instruction to the active function.
// Operates on the global context.
func CMOVLPL(mr, r operand.Op) { ctx.CMOVLPL(mr, r) }

// CMOVLPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVLPS m32 r32
//	CMOVLPS r32 r32
//
// Construct and append a CMOVLPS instruction to the active function.
func (c *Context) CMOVLPS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVLPS(mr, r))
}

// CMOVLPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVLPS m32 r32
//	CMOVLPS r32 r32
//
// Construct and append a CMOVLPS instruction to the active function.
// Operates on the global context.
func CMOVLPS(mr, r operand.Op) { ctx.CMOVLPS(mr, r) }

// CMOVQCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVQCC m64 r64
//	CMOVQCC r64 r64
//
// Construct and append a CMOVQCC instruction to the active function.
func (c *Context) CMOVQCC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQCC(mr, r))
}

// CMOVQCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVQCC m64 r64
//	CMOVQCC r64 r64
//
// Construct and append a CMOVQCC instruction to the active function.
// Operates on the global context.
func CMOVQCC(mr, r operand.Op) { ctx.CMOVQCC(mr, r) }

// CMOVQCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVQCS m64 r64
//	CMOVQCS r64 r64
//
// Construct and append a CMOVQCS instruction to the active function.
func (c *Context) CMOVQCS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQCS(mr, r))
}

// CMOVQCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVQCS m64 r64
//	CMOVQCS r64 r64
//
// Construct and append a CMOVQCS instruction to the active function.
// Operates on the global context.
func CMOVQCS(mr, r operand.Op) { ctx.CMOVQCS(mr, r) }

// CMOVQEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVQEQ m64 r64
//	CMOVQEQ r64 r64
//
// Construct and append a CMOVQEQ instruction to the active function.
func (c *Context) CMOVQEQ(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQEQ(mr, r))
}

// CMOVQEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVQEQ m64 r64
//	CMOVQEQ r64 r64
//
// Construct and append a CMOVQEQ instruction to the active function.
// Operates on the global context.
func CMOVQEQ(mr, r operand.Op) { ctx.CMOVQEQ(mr, r) }

// CMOVQGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVQGE m64 r64
//	CMOVQGE r64 r64
//
// Construct and append a CMOVQGE instruction to the active function.
func (c *Context) CMOVQGE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQGE(mr, r))
}

// CMOVQGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVQGE m64 r64
//	CMOVQGE r64 r64
//
// Construct and append a CMOVQGE instruction to the active function.
// Operates on the global context.
func CMOVQGE(mr, r operand.Op) { ctx.CMOVQGE(mr, r) }

// CMOVQGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVQGT m64 r64
//	CMOVQGT r64 r64
//
// Construct and append a CMOVQGT instruction to the active function.
func (c *Context) CMOVQGT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQGT(mr, r))
}

// CMOVQGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVQGT m64 r64
//	CMOVQGT r64 r64
//
// Construct and append a CMOVQGT instruction to the active function.
// Operates on the global context.
func CMOVQGT(mr, r operand.Op) { ctx.CMOVQGT(mr, r) }

// CMOVQHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVQHI m64 r64
//	CMOVQHI r64 r64
//
// Construct and append a CMOVQHI instruction to the active function.
func (c *Context) CMOVQHI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQHI(mr, r))
}

// CMOVQHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVQHI m64 r64
//	CMOVQHI r64 r64
//
// Construct and append a CMOVQHI instruction to the active function.
// Operates on the global context.
func CMOVQHI(mr, r operand.Op) { ctx.CMOVQHI(mr, r) }

// CMOVQLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVQLE m64 r64
//	CMOVQLE r64 r64
//
// Construct and append a CMOVQLE instruction to the active function.
func (c *Context) CMOVQLE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQLE(mr, r))
}

// CMOVQLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVQLE m64 r64
//	CMOVQLE r64 r64
//
// Construct and append a CMOVQLE instruction to the active function.
// Operates on the global context.
func CMOVQLE(mr, r operand.Op) { ctx.CMOVQLE(mr, r) }

// CMOVQLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVQLS m64 r64
//	CMOVQLS r64 r64
//
// Construct and append a CMOVQLS instruction to the active function.
func (c *Context) CMOVQLS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQLS(mr, r))
}

// CMOVQLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVQLS m64 r64
//	CMOVQLS r64 r64
//
// Construct and append a CMOVQLS instruction to the active function.
// Operates on the global context.
func CMOVQLS(mr, r operand.Op) { ctx.CMOVQLS(mr, r) }

// CMOVQLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVQLT m64 r64
//	CMOVQLT r64 r64
//
// Construct and append a CMOVQLT instruction to the active function.
func (c *Context) CMOVQLT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQLT(mr, r))
}

// CMOVQLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVQLT m64 r64
//	CMOVQLT r64 r64
//
// Construct and append a CMOVQLT instruction to the active function.
// Operates on the global context.
func CMOVQLT(mr, r operand.Op) { ctx.CMOVQLT(mr, r) }

// CMOVQMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVQMI m64 r64
//	CMOVQMI r64 r64
//
// Construct and append a CMOVQMI instruction to the active function.
func (c *Context) CMOVQMI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQMI(mr, r))
}

// CMOVQMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVQMI m64 r64
//	CMOVQMI r64 r64
//
// Construct and append a CMOVQMI instruction to the active function.
// Operates on the global context.
func CMOVQMI(mr, r operand.Op) { ctx.CMOVQMI(mr, r) }

// CMOVQNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVQNE m64 r64
//	CMOVQNE r64 r64
//
// Construct and append a CMOVQNE instruction to the active function.
func (c *Context) CMOVQNE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQNE(mr, r))
}

// CMOVQNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVQNE m64 r64
//	CMOVQNE r64 r64
//
// Construct and append a CMOVQNE instruction to the active function.
// Operates on the global context.
func CMOVQNE(mr, r operand.Op) { ctx.CMOVQNE(mr, r) }

// CMOVQOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVQOC m64 r64
//	CMOVQOC r64 r64
//
// Construct and append a CMOVQOC instruction to the active function.
func (c *Context) CMOVQOC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQOC(mr, r))
}

// CMOVQOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVQOC m64 r64
//	CMOVQOC r64 r64
//
// Construct and append a CMOVQOC instruction to the active function.
// Operates on the global context.
func CMOVQOC(mr, r operand.Op) { ctx.CMOVQOC(mr, r) }

// CMOVQOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVQOS m64 r64
//	CMOVQOS r64 r64
//
// Construct and append a CMOVQOS instruction to the active function.
func (c *Context) CMOVQOS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQOS(mr, r))
}

// CMOVQOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVQOS m64 r64
//	CMOVQOS r64 r64
//
// Construct and append a CMOVQOS instruction to the active function.
// Operates on the global context.
func CMOVQOS(mr, r operand.Op) { ctx.CMOVQOS(mr, r) }

// CMOVQPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVQPC m64 r64
//	CMOVQPC r64 r64
//
// Construct and append a CMOVQPC instruction to the active function.
func (c *Context) CMOVQPC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQPC(mr, r))
}

// CMOVQPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVQPC m64 r64
//	CMOVQPC r64 r64
//
// Construct and append a CMOVQPC instruction to the active function.
// Operates on the global context.
func CMOVQPC(mr, r operand.Op) { ctx.CMOVQPC(mr, r) }

// CMOVQPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVQPL m64 r64
//	CMOVQPL r64 r64
//
// Construct and append a CMOVQPL instruction to the active function.
func (c *Context) CMOVQPL(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQPL(mr, r))
}

// CMOVQPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVQPL m64 r64
//	CMOVQPL r64 r64
//
// Construct and append a CMOVQPL instruction to the active function.
// Operates on the global context.
func CMOVQPL(mr, r operand.Op) { ctx.CMOVQPL(mr, r) }

// CMOVQPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVQPS m64 r64
//	CMOVQPS r64 r64
//
// Construct and append a CMOVQPS instruction to the active function.
func (c *Context) CMOVQPS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVQPS(mr, r))
}

// CMOVQPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVQPS m64 r64
//	CMOVQPS r64 r64
//
// Construct and append a CMOVQPS instruction to the active function.
// Operates on the global context.
func CMOVQPS(mr, r operand.Op) { ctx.CMOVQPS(mr, r) }

// CMOVWCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVWCC m16 r16
//	CMOVWCC r16 r16
//
// Construct and append a CMOVWCC instruction to the active function.
func (c *Context) CMOVWCC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWCC(mr, r))
}

// CMOVWCC: Move if above or equal (CF == 0).
//
// Forms:
//
//	CMOVWCC m16 r16
//	CMOVWCC r16 r16
//
// Construct and append a CMOVWCC instruction to the active function.
// Operates on the global context.
func CMOVWCC(mr, r operand.Op) { ctx.CMOVWCC(mr, r) }

// CMOVWCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVWCS m16 r16
//	CMOVWCS r16 r16
//
// Construct and append a CMOVWCS instruction to the active function.
func (c *Context) CMOVWCS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWCS(mr, r))
}

// CMOVWCS: Move if below (CF == 1).
//
// Forms:
//
//	CMOVWCS m16 r16
//	CMOVWCS r16 r16
//
// Construct and append a CMOVWCS instruction to the active function.
// Operates on the global context.
func CMOVWCS(mr, r operand.Op) { ctx.CMOVWCS(mr, r) }

// CMOVWEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVWEQ m16 r16
//	CMOVWEQ r16 r16
//
// Construct and append a CMOVWEQ instruction to the active function.
func (c *Context) CMOVWEQ(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWEQ(mr, r))
}

// CMOVWEQ: Move if equal (ZF == 1).
//
// Forms:
//
//	CMOVWEQ m16 r16
//	CMOVWEQ r16 r16
//
// Construct and append a CMOVWEQ instruction to the active function.
// Operates on the global context.
func CMOVWEQ(mr, r operand.Op) { ctx.CMOVWEQ(mr, r) }

// CMOVWGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVWGE m16 r16
//	CMOVWGE r16 r16
//
// Construct and append a CMOVWGE instruction to the active function.
func (c *Context) CMOVWGE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWGE(mr, r))
}

// CMOVWGE: Move if greater or equal (SF == OF).
//
// Forms:
//
//	CMOVWGE m16 r16
//	CMOVWGE r16 r16
//
// Construct and append a CMOVWGE instruction to the active function.
// Operates on the global context.
func CMOVWGE(mr, r operand.Op) { ctx.CMOVWGE(mr, r) }

// CMOVWGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVWGT m16 r16
//	CMOVWGT r16 r16
//
// Construct and append a CMOVWGT instruction to the active function.
func (c *Context) CMOVWGT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWGT(mr, r))
}

// CMOVWGT: Move if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	CMOVWGT m16 r16
//	CMOVWGT r16 r16
//
// Construct and append a CMOVWGT instruction to the active function.
// Operates on the global context.
func CMOVWGT(mr, r operand.Op) { ctx.CMOVWGT(mr, r) }

// CMOVWHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVWHI m16 r16
//	CMOVWHI r16 r16
//
// Construct and append a CMOVWHI instruction to the active function.
func (c *Context) CMOVWHI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWHI(mr, r))
}

// CMOVWHI: Move if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	CMOVWHI m16 r16
//	CMOVWHI r16 r16
//
// Construct and append a CMOVWHI instruction to the active function.
// Operates on the global context.
func CMOVWHI(mr, r operand.Op) { ctx.CMOVWHI(mr, r) }

// CMOVWLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVWLE m16 r16
//	CMOVWLE r16 r16
//
// Construct and append a CMOVWLE instruction to the active function.
func (c *Context) CMOVWLE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWLE(mr, r))
}

// CMOVWLE: Move if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	CMOVWLE m16 r16
//	CMOVWLE r16 r16
//
// Construct and append a CMOVWLE instruction to the active function.
// Operates on the global context.
func CMOVWLE(mr, r operand.Op) { ctx.CMOVWLE(mr, r) }

// CMOVWLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVWLS m16 r16
//	CMOVWLS r16 r16
//
// Construct and append a CMOVWLS instruction to the active function.
func (c *Context) CMOVWLS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWLS(mr, r))
}

// CMOVWLS: Move if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	CMOVWLS m16 r16
//	CMOVWLS r16 r16
//
// Construct and append a CMOVWLS instruction to the active function.
// Operates on the global context.
func CMOVWLS(mr, r operand.Op) { ctx.CMOVWLS(mr, r) }

// CMOVWLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVWLT m16 r16
//	CMOVWLT r16 r16
//
// Construct and append a CMOVWLT instruction to the active function.
func (c *Context) CMOVWLT(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWLT(mr, r))
}

// CMOVWLT: Move if less (SF != OF).
//
// Forms:
//
//	CMOVWLT m16 r16
//	CMOVWLT r16 r16
//
// Construct and append a CMOVWLT instruction to the active function.
// Operates on the global context.
func CMOVWLT(mr, r operand.Op) { ctx.CMOVWLT(mr, r) }

// CMOVWMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVWMI m16 r16
//	CMOVWMI r16 r16
//
// Construct and append a CMOVWMI instruction to the active function.
func (c *Context) CMOVWMI(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWMI(mr, r))
}

// CMOVWMI: Move if sign (SF == 1).
//
// Forms:
//
//	CMOVWMI m16 r16
//	CMOVWMI r16 r16
//
// Construct and append a CMOVWMI instruction to the active function.
// Operates on the global context.
func CMOVWMI(mr, r operand.Op) { ctx.CMOVWMI(mr, r) }

// CMOVWNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVWNE m16 r16
//	CMOVWNE r16 r16
//
// Construct and append a CMOVWNE instruction to the active function.
func (c *Context) CMOVWNE(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWNE(mr, r))
}

// CMOVWNE: Move if not equal (ZF == 0).
//
// Forms:
//
//	CMOVWNE m16 r16
//	CMOVWNE r16 r16
//
// Construct and append a CMOVWNE instruction to the active function.
// Operates on the global context.
func CMOVWNE(mr, r operand.Op) { ctx.CMOVWNE(mr, r) }

// CMOVWOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVWOC m16 r16
//	CMOVWOC r16 r16
//
// Construct and append a CMOVWOC instruction to the active function.
func (c *Context) CMOVWOC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWOC(mr, r))
}

// CMOVWOC: Move if not overflow (OF == 0).
//
// Forms:
//
//	CMOVWOC m16 r16
//	CMOVWOC r16 r16
//
// Construct and append a CMOVWOC instruction to the active function.
// Operates on the global context.
func CMOVWOC(mr, r operand.Op) { ctx.CMOVWOC(mr, r) }

// CMOVWOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVWOS m16 r16
//	CMOVWOS r16 r16
//
// Construct and append a CMOVWOS instruction to the active function.
func (c *Context) CMOVWOS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWOS(mr, r))
}

// CMOVWOS: Move if overflow (OF == 1).
//
// Forms:
//
//	CMOVWOS m16 r16
//	CMOVWOS r16 r16
//
// Construct and append a CMOVWOS instruction to the active function.
// Operates on the global context.
func CMOVWOS(mr, r operand.Op) { ctx.CMOVWOS(mr, r) }

// CMOVWPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVWPC m16 r16
//	CMOVWPC r16 r16
//
// Construct and append a CMOVWPC instruction to the active function.
func (c *Context) CMOVWPC(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWPC(mr, r))
}

// CMOVWPC: Move if not parity (PF == 0).
//
// Forms:
//
//	CMOVWPC m16 r16
//	CMOVWPC r16 r16
//
// Construct and append a CMOVWPC instruction to the active function.
// Operates on the global context.
func CMOVWPC(mr, r operand.Op) { ctx.CMOVWPC(mr, r) }

// CMOVWPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVWPL m16 r16
//	CMOVWPL r16 r16
//
// Construct and append a CMOVWPL instruction to the active function.
func (c *Context) CMOVWPL(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWPL(mr, r))
}

// CMOVWPL: Move if not sign (SF == 0).
//
// Forms:
//
//	CMOVWPL m16 r16
//	CMOVWPL r16 r16
//
// Construct and append a CMOVWPL instruction to the active function.
// Operates on the global context.
func CMOVWPL(mr, r operand.Op) { ctx.CMOVWPL(mr, r) }

// CMOVWPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVWPS m16 r16
//	CMOVWPS r16 r16
//
// Construct and append a CMOVWPS instruction to the active function.
func (c *Context) CMOVWPS(mr, r operand.Op) {
	c.addinstruction(x86.CMOVWPS(mr, r))
}

// CMOVWPS: Move if parity (PF == 1).
//
// Forms:
//
//	CMOVWPS m16 r16
//	CMOVWPS r16 r16
//
// Construct and append a CMOVWPS instruction to the active function.
// Operates on the global context.
func CMOVWPS(mr, r operand.Op) { ctx.CMOVWPS(mr, r) }

// CMPB: Compare Two Operands.
//
// Forms:
//
//	CMPB al imm8
//	CMPB m8 imm8
//	CMPB m8 r8
//	CMPB r8 imm8
//	CMPB r8 m8
//	CMPB r8 r8
//
// Construct and append a CMPB instruction to the active function.
func (c *Context) CMPB(amr, imr operand.Op) {
	c.addinstruction(x86.CMPB(amr, imr))
}

// CMPB: Compare Two Operands.
//
// Forms:
//
//	CMPB al imm8
//	CMPB m8 imm8
//	CMPB m8 r8
//	CMPB r8 imm8
//	CMPB r8 m8
//	CMPB r8 r8
//
// Construct and append a CMPB instruction to the active function.
// Operates on the global context.
func CMPB(amr, imr operand.Op) { ctx.CMPB(amr, imr) }

// CMPL: Compare Two Operands.
//
// Forms:
//
//	CMPL eax imm32
//	CMPL m32 imm32
//	CMPL m32 imm8
//	CMPL m32 r32
//	CMPL r32 imm32
//	CMPL r32 imm8
//	CMPL r32 m32
//	CMPL r32 r32
//
// Construct and append a CMPL instruction to the active function.
func (c *Context) CMPL(emr, imr operand.Op) {
	c.addinstruction(x86.CMPL(emr, imr))
}

// CMPL: Compare Two Operands.
//
// Forms:
//
//	CMPL eax imm32
//	CMPL m32 imm32
//	CMPL m32 imm8
//	CMPL m32 r32
//	CMPL r32 imm32
//	CMPL r32 imm8
//	CMPL r32 m32
//	CMPL r32 r32
//
// Construct and append a CMPL instruction to the active function.
// Operates on the global context.
func CMPL(emr, imr operand.Op) { ctx.CMPL(emr, imr) }

// CMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPD m128 xmm imm8
//	CMPPD xmm  xmm imm8
//
// Construct and append a CMPPD instruction to the active function.
func (c *Context) CMPPD(mx, x, i operand.Op) {
	c.addinstruction(x86.CMPPD(mx, x, i))
}

// CMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPD m128 xmm imm8
//	CMPPD xmm  xmm imm8
//
// Construct and append a CMPPD instruction to the active function.
// Operates on the global context.
func CMPPD(mx, x, i operand.Op) { ctx.CMPPD(mx, x, i) }

// CMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPS m128 xmm imm8
//	CMPPS xmm  xmm imm8
//
// Construct and append a CMPPS instruction to the active function.
func (c *Context) CMPPS(mx, x, i operand.Op) {
	c.addinstruction(x86.CMPPS(mx, x, i))
}

// CMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPPS m128 xmm imm8
//	CMPPS xmm  xmm imm8
//
// Construct and append a CMPPS instruction to the active function.
// Operates on the global context.
func CMPPS(mx, x, i operand.Op) { ctx.CMPPS(mx, x, i) }

// CMPQ: Compare Two Operands.
//
// Forms:
//
//	CMPQ m64 imm32
//	CMPQ m64 imm8
//	CMPQ m64 r64
//	CMPQ r64 imm32
//	CMPQ r64 imm8
//	CMPQ r64 m64
//	CMPQ r64 r64
//	CMPQ rax imm32
//
// Construct and append a CMPQ instruction to the active function.
func (c *Context) CMPQ(mr, imr operand.Op) {
	c.addinstruction(x86.CMPQ(mr, imr))
}

// CMPQ: Compare Two Operands.
//
// Forms:
//
//	CMPQ m64 imm32
//	CMPQ m64 imm8
//	CMPQ m64 r64
//	CMPQ r64 imm32
//	CMPQ r64 imm8
//	CMPQ r64 m64
//	CMPQ r64 r64
//	CMPQ rax imm32
//
// Construct and append a CMPQ instruction to the active function.
// Operates on the global context.
func CMPQ(mr, imr operand.Op) { ctx.CMPQ(mr, imr) }

// CMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSD m64 xmm imm8
//	CMPSD xmm xmm imm8
//
// Construct and append a CMPSD instruction to the active function.
func (c *Context) CMPSD(mx, x, i operand.Op) {
	c.addinstruction(x86.CMPSD(mx, x, i))
}

// CMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSD m64 xmm imm8
//	CMPSD xmm xmm imm8
//
// Construct and append a CMPSD instruction to the active function.
// Operates on the global context.
func CMPSD(mx, x, i operand.Op) { ctx.CMPSD(mx, x, i) }

// CMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSS m32 xmm imm8
//	CMPSS xmm xmm imm8
//
// Construct and append a CMPSS instruction to the active function.
func (c *Context) CMPSS(mx, x, i operand.Op) {
	c.addinstruction(x86.CMPSS(mx, x, i))
}

// CMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	CMPSS m32 xmm imm8
//	CMPSS xmm xmm imm8
//
// Construct and append a CMPSS instruction to the active function.
// Operates on the global context.
func CMPSS(mx, x, i operand.Op) { ctx.CMPSS(mx, x, i) }

// CMPW: Compare Two Operands.
//
// Forms:
//
//	CMPW ax  imm16
//	CMPW m16 imm16
//	CMPW m16 imm8
//	CMPW m16 r16
//	CMPW r16 imm16
//	CMPW r16 imm8
//	CMPW r16 m16
//	CMPW r16 r16
//
// Construct and append a CMPW instruction to the active function.
func (c *Context) CMPW(amr, imr operand.Op) {
	c.addinstruction(x86.CMPW(amr, imr))
}

// CMPW: Compare Two Operands.
//
// Forms:
//
//	CMPW ax  imm16
//	CMPW m16 imm16
//	CMPW m16 imm8
//	CMPW m16 r16
//	CMPW r16 imm16
//	CMPW r16 imm8
//	CMPW r16 m16
//	CMPW r16 r16
//
// Construct and append a CMPW instruction to the active function.
// Operates on the global context.
func CMPW(amr, imr operand.Op) { ctx.CMPW(amr, imr) }

// CMPXCHG16B: Compare and Exchange 16 Bytes.
//
// Forms:
//
//	CMPXCHG16B m128
//
// Construct and append a CMPXCHG16B instruction to the active function.
func (c *Context) CMPXCHG16B(m operand.Op) {
	c.addinstruction(x86.CMPXCHG16B(m))
}

// CMPXCHG16B: Compare and Exchange 16 Bytes.
//
// Forms:
//
//	CMPXCHG16B m128
//
// Construct and append a CMPXCHG16B instruction to the active function.
// Operates on the global context.
func CMPXCHG16B(m operand.Op) { ctx.CMPXCHG16B(m) }

// CMPXCHG8B: Compare and Exchange 8 Bytes.
//
// Forms:
//
//	CMPXCHG8B m64
//
// Construct and append a CMPXCHG8B instruction to the active function.
func (c *Context) CMPXCHG8B(m operand.Op) {
	c.addinstruction(x86.CMPXCHG8B(m))
}

// CMPXCHG8B: Compare and Exchange 8 Bytes.
//
// Forms:
//
//	CMPXCHG8B m64
//
// Construct and append a CMPXCHG8B instruction to the active function.
// Operates on the global context.
func CMPXCHG8B(m operand.Op) { ctx.CMPXCHG8B(m) }

// CMPXCHGB: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGB r8 m8
//	CMPXCHGB r8 r8
//
// Construct and append a CMPXCHGB instruction to the active function.
func (c *Context) CMPXCHGB(r, mr operand.Op) {
	c.addinstruction(x86.CMPXCHGB(r, mr))
}

// CMPXCHGB: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGB r8 m8
//	CMPXCHGB r8 r8
//
// Construct and append a CMPXCHGB instruction to the active function.
// Operates on the global context.
func CMPXCHGB(r, mr operand.Op) { ctx.CMPXCHGB(r, mr) }

// CMPXCHGL: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGL r32 m32
//	CMPXCHGL r32 r32
//
// Construct and append a CMPXCHGL instruction to the active function.
func (c *Context) CMPXCHGL(r, mr operand.Op) {
	c.addinstruction(x86.CMPXCHGL(r, mr))
}

// CMPXCHGL: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGL r32 m32
//	CMPXCHGL r32 r32
//
// Construct and append a CMPXCHGL instruction to the active function.
// Operates on the global context.
func CMPXCHGL(r, mr operand.Op) { ctx.CMPXCHGL(r, mr) }

// CMPXCHGQ: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGQ r64 m64
//	CMPXCHGQ r64 r64
//
// Construct and append a CMPXCHGQ instruction to the active function.
func (c *Context) CMPXCHGQ(r, mr operand.Op) {
	c.addinstruction(x86.CMPXCHGQ(r, mr))
}

// CMPXCHGQ: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGQ r64 m64
//	CMPXCHGQ r64 r64
//
// Construct and append a CMPXCHGQ instruction to the active function.
// Operates on the global context.
func CMPXCHGQ(r, mr operand.Op) { ctx.CMPXCHGQ(r, mr) }

// CMPXCHGW: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGW r16 m16
//	CMPXCHGW r16 r16
//
// Construct and append a CMPXCHGW instruction to the active function.
func (c *Context) CMPXCHGW(r, mr operand.Op) {
	c.addinstruction(x86.CMPXCHGW(r, mr))
}

// CMPXCHGW: Compare and Exchange.
//
// Forms:
//
//	CMPXCHGW r16 m16
//	CMPXCHGW r16 r16
//
// Construct and append a CMPXCHGW instruction to the active function.
// Operates on the global context.
func CMPXCHGW(r, mr operand.Op) { ctx.CMPXCHGW(r, mr) }

// COMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISD m64 xmm
//	COMISD xmm xmm
//
// Construct and append a COMISD instruction to the active function.
func (c *Context) COMISD(mx, x operand.Op) {
	c.addinstruction(x86.COMISD(mx, x))
}

// COMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISD m64 xmm
//	COMISD xmm xmm
//
// Construct and append a COMISD instruction to the active function.
// Operates on the global context.
func COMISD(mx, x operand.Op) { ctx.COMISD(mx, x) }

// COMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISS m32 xmm
//	COMISS xmm xmm
//
// Construct and append a COMISS instruction to the active function.
func (c *Context) COMISS(mx, x operand.Op) {
	c.addinstruction(x86.COMISS(mx, x))
}

// COMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	COMISS m32 xmm
//	COMISS xmm xmm
//
// Construct and append a COMISS instruction to the active function.
// Operates on the global context.
func COMISS(mx, x operand.Op) { ctx.COMISS(mx, x) }

// CPUID: CPU Identification.
//
// Forms:
//
//	CPUID
//
// Construct and append a CPUID instruction to the active function.
func (c *Context) CPUID() {
	c.addinstruction(x86.CPUID())
}

// CPUID: CPU Identification.
//
// Forms:
//
//	CPUID
//
// Construct and append a CPUID instruction to the active function.
// Operates on the global context.
func CPUID() { ctx.CPUID() }

// CQO: Convert Quadword to Octaword.
//
// Forms:
//
//	CQO
//
// Construct and append a CQO instruction to the active function.
func (c *Context) CQO() {
	c.addinstruction(x86.CQO())
}

// CQO: Convert Quadword to Octaword.
//
// Forms:
//
//	CQO
//
// Construct and append a CQO instruction to the active function.
// Operates on the global context.
func CQO() { ctx.CQO() }

// CRC32B: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32B m8 r32
//	CRC32B m8 r64
//	CRC32B r8 r32
//	CRC32B r8 r64
//
// Construct and append a CRC32B instruction to the active function.
func (c *Context) CRC32B(mr, r operand.Op) {
	c.addinstruction(x86.CRC32B(mr, r))
}

// CRC32B: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32B m8 r32
//	CRC32B m8 r64
//	CRC32B r8 r32
//	CRC32B r8 r64
//
// Construct and append a CRC32B instruction to the active function.
// Operates on the global context.
func CRC32B(mr, r operand.Op) { ctx.CRC32B(mr, r) }

// CRC32L: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32L m32 r32
//	CRC32L r32 r32
//
// Construct and append a CRC32L instruction to the active function.
func (c *Context) CRC32L(mr, r operand.Op) {
	c.addinstruction(x86.CRC32L(mr, r))
}

// CRC32L: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32L m32 r32
//	CRC32L r32 r32
//
// Construct and append a CRC32L instruction to the active function.
// Operates on the global context.
func CRC32L(mr, r operand.Op) { ctx.CRC32L(mr, r) }

// CRC32Q: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32Q m64 r64
//	CRC32Q r64 r64
//
// Construct and append a CRC32Q instruction to the active function.
func (c *Context) CRC32Q(mr, r operand.Op) {
	c.addinstruction(x86.CRC32Q(mr, r))
}

// CRC32Q: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32Q m64 r64
//	CRC32Q r64 r64
//
// Construct and append a CRC32Q instruction to the active function.
// Operates on the global context.
func CRC32Q(mr, r operand.Op) { ctx.CRC32Q(mr, r) }

// CRC32W: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32W m16 r32
//	CRC32W r16 r32
//
// Construct and append a CRC32W instruction to the active function.
func (c *Context) CRC32W(mr, r operand.Op) {
	c.addinstruction(x86.CRC32W(mr, r))
}

// CRC32W: Accumulate CRC32 Value.
//
// Forms:
//
//	CRC32W m16 r32
//	CRC32W r16 r32
//
// Construct and append a CRC32W instruction to the active function.
// Operates on the global context.
func CRC32W(mr, r operand.Op) { ctx.CRC32W(mr, r) }

// CVTPD2PL: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPD2PL m128 xmm
//	CVTPD2PL xmm  xmm
//
// Construct and append a CVTPD2PL instruction to the active function.
func (c *Context) CVTPD2PL(mx, x operand.Op) {
	c.addinstruction(x86.CVTPD2PL(mx, x))
}

// CVTPD2PL: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPD2PL m128 xmm
//	CVTPD2PL xmm  xmm
//
// Construct and append a CVTPD2PL instruction to the active function.
// Operates on the global context.
func CVTPD2PL(mx, x operand.Op) { ctx.CVTPD2PL(mx, x) }

// CVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPD2PS m128 xmm
//	CVTPD2PS xmm  xmm
//
// Construct and append a CVTPD2PS instruction to the active function.
func (c *Context) CVTPD2PS(mx, x operand.Op) {
	c.addinstruction(x86.CVTPD2PS(mx, x))
}

// CVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPD2PS m128 xmm
//	CVTPD2PS xmm  xmm
//
// Construct and append a CVTPD2PS instruction to the active function.
// Operates on the global context.
func CVTPD2PS(mx, x operand.Op) { ctx.CVTPD2PS(mx, x) }

// CVTPL2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPL2PD m64 xmm
//	CVTPL2PD xmm xmm
//
// Construct and append a CVTPL2PD instruction to the active function.
func (c *Context) CVTPL2PD(mx, x operand.Op) {
	c.addinstruction(x86.CVTPL2PD(mx, x))
}

// CVTPL2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPL2PD m64 xmm
//	CVTPL2PD xmm xmm
//
// Construct and append a CVTPL2PD instruction to the active function.
// Operates on the global context.
func CVTPL2PD(mx, x operand.Op) { ctx.CVTPL2PD(mx, x) }

// CVTPL2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPL2PS m128 xmm
//	CVTPL2PS xmm  xmm
//
// Construct and append a CVTPL2PS instruction to the active function.
func (c *Context) CVTPL2PS(mx, x operand.Op) {
	c.addinstruction(x86.CVTPL2PS(mx, x))
}

// CVTPL2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	CVTPL2PS m128 xmm
//	CVTPL2PS xmm  xmm
//
// Construct and append a CVTPL2PS instruction to the active function.
// Operates on the global context.
func CVTPL2PS(mx, x operand.Op) { ctx.CVTPL2PS(mx, x) }

// CVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPS2PD m64 xmm
//	CVTPS2PD xmm xmm
//
// Construct and append a CVTPS2PD instruction to the active function.
func (c *Context) CVTPS2PD(mx, x operand.Op) {
	c.addinstruction(x86.CVTPS2PD(mx, x))
}

// CVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	CVTPS2PD m64 xmm
//	CVTPS2PD xmm xmm
//
// Construct and append a CVTPS2PD instruction to the active function.
// Operates on the global context.
func CVTPS2PD(mx, x operand.Op) { ctx.CVTPS2PD(mx, x) }

// CVTPS2PL: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPS2PL m128 xmm
//	CVTPS2PL xmm  xmm
//
// Construct and append a CVTPS2PL instruction to the active function.
func (c *Context) CVTPS2PL(mx, x operand.Op) {
	c.addinstruction(x86.CVTPS2PL(mx, x))
}

// CVTPS2PL: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTPS2PL m128 xmm
//	CVTPS2PL xmm  xmm
//
// Construct and append a CVTPS2PL instruction to the active function.
// Operates on the global context.
func CVTPS2PL(mx, x operand.Op) { ctx.CVTPS2PL(mx, x) }

// CVTSD2SL: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	CVTSD2SL m64 r32
//	CVTSD2SL m64 r64
//	CVTSD2SL xmm r32
//	CVTSD2SL xmm r64
//
// Construct and append a CVTSD2SL instruction to the active function.
func (c *Context) CVTSD2SL(mx, r operand.Op) {
	c.addinstruction(x86.CVTSD2SL(mx, r))
}

// CVTSD2SL: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	CVTSD2SL m64 r32
//	CVTSD2SL m64 r64
//	CVTSD2SL xmm r32
//	CVTSD2SL xmm r64
//
// Construct and append a CVTSD2SL instruction to the active function.
// Operates on the global context.
func CVTSD2SL(mx, r operand.Op) { ctx.CVTSD2SL(mx, r) }

// CVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSD2SS m64 xmm
//	CVTSD2SS xmm xmm
//
// Construct and append a CVTSD2SS instruction to the active function.
func (c *Context) CVTSD2SS(mx, x operand.Op) {
	c.addinstruction(x86.CVTSD2SS(mx, x))
}

// CVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSD2SS m64 xmm
//	CVTSD2SS xmm xmm
//
// Construct and append a CVTSD2SS instruction to the active function.
// Operates on the global context.
func CVTSD2SS(mx, x operand.Op) { ctx.CVTSD2SS(mx, x) }

// CVTSL2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSL2SD m32 xmm
//	CVTSL2SD r32 xmm
//
// Construct and append a CVTSL2SD instruction to the active function.
func (c *Context) CVTSL2SD(mr, x operand.Op) {
	c.addinstruction(x86.CVTSL2SD(mr, x))
}

// CVTSL2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSL2SD m32 xmm
//	CVTSL2SD r32 xmm
//
// Construct and append a CVTSL2SD instruction to the active function.
// Operates on the global context.
func CVTSL2SD(mr, x operand.Op) { ctx.CVTSL2SD(mr, x) }

// CVTSL2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSL2SS m32 xmm
//	CVTSL2SS r32 xmm
//
// Construct and append a CVTSL2SS instruction to the active function.
func (c *Context) CVTSL2SS(mr, x operand.Op) {
	c.addinstruction(x86.CVTSL2SS(mr, x))
}

// CVTSL2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSL2SS m32 xmm
//	CVTSL2SS r32 xmm
//
// Construct and append a CVTSL2SS instruction to the active function.
// Operates on the global context.
func CVTSL2SS(mr, x operand.Op) { ctx.CVTSL2SS(mr, x) }

// CVTSQ2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SD m64 xmm
//	CVTSQ2SD r64 xmm
//
// Construct and append a CVTSQ2SD instruction to the active function.
func (c *Context) CVTSQ2SD(mr, x operand.Op) {
	c.addinstruction(x86.CVTSQ2SD(mr, x))
}

// CVTSQ2SD: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SD m64 xmm
//	CVTSQ2SD r64 xmm
//
// Construct and append a CVTSQ2SD instruction to the active function.
// Operates on the global context.
func CVTSQ2SD(mr, x operand.Op) { ctx.CVTSQ2SD(mr, x) }

// CVTSQ2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SS m64 xmm
//	CVTSQ2SS r64 xmm
//
// Construct and append a CVTSQ2SS instruction to the active function.
func (c *Context) CVTSQ2SS(mr, x operand.Op) {
	c.addinstruction(x86.CVTSQ2SS(mr, x))
}

// CVTSQ2SS: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	CVTSQ2SS m64 xmm
//	CVTSQ2SS r64 xmm
//
// Construct and append a CVTSQ2SS instruction to the active function.
// Operates on the global context.
func CVTSQ2SS(mr, x operand.Op) { ctx.CVTSQ2SS(mr, x) }

// CVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSS2SD m32 xmm
//	CVTSS2SD xmm xmm
//
// Construct and append a CVTSS2SD instruction to the active function.
func (c *Context) CVTSS2SD(mx, x operand.Op) {
	c.addinstruction(x86.CVTSS2SD(mx, x))
}

// CVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	CVTSS2SD m32 xmm
//	CVTSS2SD xmm xmm
//
// Construct and append a CVTSS2SD instruction to the active function.
// Operates on the global context.
func CVTSS2SD(mx, x operand.Op) { ctx.CVTSS2SD(mx, x) }

// CVTSS2SL: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTSS2SL m32 r32
//	CVTSS2SL m32 r64
//	CVTSS2SL xmm r32
//	CVTSS2SL xmm r64
//
// Construct and append a CVTSS2SL instruction to the active function.
func (c *Context) CVTSS2SL(mx, r operand.Op) {
	c.addinstruction(x86.CVTSS2SL(mx, r))
}

// CVTSS2SL: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTSS2SL m32 r32
//	CVTSS2SL m32 r64
//	CVTSS2SL xmm r32
//	CVTSS2SL xmm r64
//
// Construct and append a CVTSS2SL instruction to the active function.
// Operates on the global context.
func CVTSS2SL(mx, r operand.Op) { ctx.CVTSS2SL(mx, r) }

// CVTTPD2PL: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPD2PL m128 xmm
//	CVTTPD2PL xmm  xmm
//
// Construct and append a CVTTPD2PL instruction to the active function.
func (c *Context) CVTTPD2PL(mx, x operand.Op) {
	c.addinstruction(x86.CVTTPD2PL(mx, x))
}

// CVTTPD2PL: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPD2PL m128 xmm
//	CVTTPD2PL xmm  xmm
//
// Construct and append a CVTTPD2PL instruction to the active function.
// Operates on the global context.
func CVTTPD2PL(mx, x operand.Op) { ctx.CVTTPD2PL(mx, x) }

// CVTTPS2PL: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPS2PL m128 xmm
//	CVTTPS2PL xmm  xmm
//
// Construct and append a CVTTPS2PL instruction to the active function.
func (c *Context) CVTTPS2PL(mx, x operand.Op) {
	c.addinstruction(x86.CVTTPS2PL(mx, x))
}

// CVTTPS2PL: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	CVTTPS2PL m128 xmm
//	CVTTPS2PL xmm  xmm
//
// Construct and append a CVTTPS2PL instruction to the active function.
// Operates on the global context.
func CVTTPS2PL(mx, x operand.Op) { ctx.CVTTPS2PL(mx, x) }

// CVTTSD2SL: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SL m64 r32
//	CVTTSD2SL xmm r32
//
// Construct and append a CVTTSD2SL instruction to the active function.
func (c *Context) CVTTSD2SL(mx, r operand.Op) {
	c.addinstruction(x86.CVTTSD2SL(mx, r))
}

// CVTTSD2SL: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SL m64 r32
//	CVTTSD2SL xmm r32
//
// Construct and append a CVTTSD2SL instruction to the active function.
// Operates on the global context.
func CVTTSD2SL(mx, r operand.Op) { ctx.CVTTSD2SL(mx, r) }

// CVTTSD2SQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SQ m64 r64
//	CVTTSD2SQ xmm r64
//
// Construct and append a CVTTSD2SQ instruction to the active function.
func (c *Context) CVTTSD2SQ(mx, r operand.Op) {
	c.addinstruction(x86.CVTTSD2SQ(mx, r))
}

// CVTTSD2SQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	CVTTSD2SQ m64 r64
//	CVTTSD2SQ xmm r64
//
// Construct and append a CVTTSD2SQ instruction to the active function.
// Operates on the global context.
func CVTTSD2SQ(mx, r operand.Op) { ctx.CVTTSD2SQ(mx, r) }

// CVTTSS2SL: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTTSS2SL m32 r32
//	CVTTSS2SL m32 r64
//	CVTTSS2SL xmm r32
//	CVTTSS2SL xmm r64
//
// Construct and append a CVTTSS2SL instruction to the active function.
func (c *Context) CVTTSS2SL(mx, r operand.Op) {
	c.addinstruction(x86.CVTTSS2SL(mx, r))
}

// CVTTSS2SL: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	CVTTSS2SL m32 r32
//	CVTTSS2SL m32 r64
//	CVTTSS2SL xmm r32
//	CVTTSS2SL xmm r64
//
// Construct and append a CVTTSS2SL instruction to the active function.
// Operates on the global context.
func CVTTSS2SL(mx, r operand.Op) { ctx.CVTTSS2SL(mx, r) }

// CWD: Convert Word to Doubleword.
//
// Forms:
//
//	CWD
//
// Construct and append a CWD instruction to the active function.
func (c *Context) CWD() {
	c.addinstruction(x86.CWD())
}

// CWD: Convert Word to Doubleword.
//
// Forms:
//
//	CWD
//
// Construct and append a CWD instruction to the active function.
// Operates on the global context.
func CWD() { ctx.CWD() }

// CWDE: Convert Word to Doubleword.
//
// Forms:
//
//	CWDE
//
// Construct and append a CWDE instruction to the active function.
func (c *Context) CWDE() {
	c.addinstruction(x86.CWDE())
}

// CWDE: Convert Word to Doubleword.
//
// Forms:
//
//	CWDE
//
// Construct and append a CWDE instruction to the active function.
// Operates on the global context.
func CWDE() { ctx.CWDE() }

// DECB: Decrement by 1.
//
// Forms:
//
//	DECB m8
//	DECB r8
//
// Construct and append a DECB instruction to the active function.
func (c *Context) DECB(mr operand.Op) {
	c.addinstruction(x86.DECB(mr))
}

// DECB: Decrement by 1.
//
// Forms:
//
//	DECB m8
//	DECB r8
//
// Construct and append a DECB instruction to the active function.
// Operates on the global context.
func DECB(mr operand.Op) { ctx.DECB(mr) }

// DECL: Decrement by 1.
//
// Forms:
//
//	DECL m32
//	DECL r32
//
// Construct and append a DECL instruction to the active function.
func (c *Context) DECL(mr operand.Op) {
	c.addinstruction(x86.DECL(mr))
}

// DECL: Decrement by 1.
//
// Forms:
//
//	DECL m32
//	DECL r32
//
// Construct and append a DECL instruction to the active function.
// Operates on the global context.
func DECL(mr operand.Op) { ctx.DECL(mr) }

// DECQ: Decrement by 1.
//
// Forms:
//
//	DECQ m64
//	DECQ r64
//
// Construct and append a DECQ instruction to the active function.
func (c *Context) DECQ(mr operand.Op) {
	c.addinstruction(x86.DECQ(mr))
}

// DECQ: Decrement by 1.
//
// Forms:
//
//	DECQ m64
//	DECQ r64
//
// Construct and append a DECQ instruction to the active function.
// Operates on the global context.
func DECQ(mr operand.Op) { ctx.DECQ(mr) }

// DECW: Decrement by 1.
//
// Forms:
//
//	DECW m16
//	DECW r16
//
// Construct and append a DECW instruction to the active function.
func (c *Context) DECW(mr operand.Op) {
	c.addinstruction(x86.DECW(mr))
}

// DECW: Decrement by 1.
//
// Forms:
//
//	DECW m16
//	DECW r16
//
// Construct and append a DECW instruction to the active function.
// Operates on the global context.
func DECW(mr operand.Op) { ctx.DECW(mr) }

// DIVB: Unsigned Divide.
//
// Forms:
//
//	DIVB m8
//	DIVB r8
//
// Construct and append a DIVB instruction to the active function.
func (c *Context) DIVB(mr operand.Op) {
	c.addinstruction(x86.DIVB(mr))
}

// DIVB: Unsigned Divide.
//
// Forms:
//
//	DIVB m8
//	DIVB r8
//
// Construct and append a DIVB instruction to the active function.
// Operates on the global context.
func DIVB(mr operand.Op) { ctx.DIVB(mr) }

// DIVL: Unsigned Divide.
//
// Forms:
//
//	DIVL m32
//	DIVL r32
//
// Construct and append a DIVL instruction to the active function.
func (c *Context) DIVL(mr operand.Op) {
	c.addinstruction(x86.DIVL(mr))
}

// DIVL: Unsigned Divide.
//
// Forms:
//
//	DIVL m32
//	DIVL r32
//
// Construct and append a DIVL instruction to the active function.
// Operates on the global context.
func DIVL(mr operand.Op) { ctx.DIVL(mr) }

// DIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPD m128 xmm
//	DIVPD xmm  xmm
//
// Construct and append a DIVPD instruction to the active function.
func (c *Context) DIVPD(mx, x operand.Op) {
	c.addinstruction(x86.DIVPD(mx, x))
}

// DIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPD m128 xmm
//	DIVPD xmm  xmm
//
// Construct and append a DIVPD instruction to the active function.
// Operates on the global context.
func DIVPD(mx, x operand.Op) { ctx.DIVPD(mx, x) }

// DIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPS m128 xmm
//	DIVPS xmm  xmm
//
// Construct and append a DIVPS instruction to the active function.
func (c *Context) DIVPS(mx, x operand.Op) {
	c.addinstruction(x86.DIVPS(mx, x))
}

// DIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVPS m128 xmm
//	DIVPS xmm  xmm
//
// Construct and append a DIVPS instruction to the active function.
// Operates on the global context.
func DIVPS(mx, x operand.Op) { ctx.DIVPS(mx, x) }

// DIVQ: Unsigned Divide.
//
// Forms:
//
//	DIVQ m64
//	DIVQ r64
//
// Construct and append a DIVQ instruction to the active function.
func (c *Context) DIVQ(mr operand.Op) {
	c.addinstruction(x86.DIVQ(mr))
}

// DIVQ: Unsigned Divide.
//
// Forms:
//
//	DIVQ m64
//	DIVQ r64
//
// Construct and append a DIVQ instruction to the active function.
// Operates on the global context.
func DIVQ(mr operand.Op) { ctx.DIVQ(mr) }

// DIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSD m64 xmm
//	DIVSD xmm xmm
//
// Construct and append a DIVSD instruction to the active function.
func (c *Context) DIVSD(mx, x operand.Op) {
	c.addinstruction(x86.DIVSD(mx, x))
}

// DIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSD m64 xmm
//	DIVSD xmm xmm
//
// Construct and append a DIVSD instruction to the active function.
// Operates on the global context.
func DIVSD(mx, x operand.Op) { ctx.DIVSD(mx, x) }

// DIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSS m32 xmm
//	DIVSS xmm xmm
//
// Construct and append a DIVSS instruction to the active function.
func (c *Context) DIVSS(mx, x operand.Op) {
	c.addinstruction(x86.DIVSS(mx, x))
}

// DIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	DIVSS m32 xmm
//	DIVSS xmm xmm
//
// Construct and append a DIVSS instruction to the active function.
// Operates on the global context.
func DIVSS(mx, x operand.Op) { ctx.DIVSS(mx, x) }

// DIVW: Unsigned Divide.
//
// Forms:
//
//	DIVW m16
//	DIVW r16
//
// Construct and append a DIVW instruction to the active function.
func (c *Context) DIVW(mr operand.Op) {
	c.addinstruction(x86.DIVW(mr))
}

// DIVW: Unsigned Divide.
//
// Forms:
//
//	DIVW m16
//	DIVW r16
//
// Construct and append a DIVW instruction to the active function.
// Operates on the global context.
func DIVW(mr operand.Op) { ctx.DIVW(mr) }

// DPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	DPPD imm8 m128 xmm
//	DPPD imm8 xmm  xmm
//
// Construct and append a DPPD instruction to the active function.
func (c *Context) DPPD(i, mx, x operand.Op) {
	c.addinstruction(x86.DPPD(i, mx, x))
}

// DPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	DPPD imm8 m128 xmm
//	DPPD imm8 xmm  xmm
//
// Construct and append a DPPD instruction to the active function.
// Operates on the global context.
func DPPD(i, mx, x operand.Op) { ctx.DPPD(i, mx, x) }

// DPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	DPPS imm8 m128 xmm
//	DPPS imm8 xmm  xmm
//
// Construct and append a DPPS instruction to the active function.
func (c *Context) DPPS(i, mx, x operand.Op) {
	c.addinstruction(x86.DPPS(i, mx, x))
}

// DPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	DPPS imm8 m128 xmm
//	DPPS imm8 xmm  xmm
//
// Construct and append a DPPS instruction to the active function.
// Operates on the global context.
func DPPS(i, mx, x operand.Op) { ctx.DPPS(i, mx, x) }

// EXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	EXTRACTPS imm2u xmm m32
//	EXTRACTPS imm2u xmm r32
//
// Construct and append a EXTRACTPS instruction to the active function.
func (c *Context) EXTRACTPS(i, x, mr operand.Op) {
	c.addinstruction(x86.EXTRACTPS(i, x, mr))
}

// EXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	EXTRACTPS imm2u xmm m32
//	EXTRACTPS imm2u xmm r32
//
// Construct and append a EXTRACTPS instruction to the active function.
// Operates on the global context.
func EXTRACTPS(i, x, mr operand.Op) { ctx.EXTRACTPS(i, x, mr) }

// HADDPD: Packed Double-FP Horizontal Add.
//
// Forms:
//
//	HADDPD m128 xmm
//	HADDPD xmm  xmm
//
// Construct and append a HADDPD instruction to the active function.
func (c *Context) HADDPD(mx, x operand.Op) {
	c.addinstruction(x86.HADDPD(mx, x))
}

// HADDPD: Packed Double-FP Horizontal Add.
//
// Forms:
//
//	HADDPD m128 xmm
//	HADDPD xmm  xmm
//
// Construct and append a HADDPD instruction to the active function.
// Operates on the global context.
func HADDPD(mx, x operand.Op) { ctx.HADDPD(mx, x) }

// HADDPS: Packed Single-FP Horizontal Add.
//
// Forms:
//
//	HADDPS m128 xmm
//	HADDPS xmm  xmm
//
// Construct and append a HADDPS instruction to the active function.
func (c *Context) HADDPS(mx, x operand.Op) {
	c.addinstruction(x86.HADDPS(mx, x))
}

// HADDPS: Packed Single-FP Horizontal Add.
//
// Forms:
//
//	HADDPS m128 xmm
//	HADDPS xmm  xmm
//
// Construct and append a HADDPS instruction to the active function.
// Operates on the global context.
func HADDPS(mx, x operand.Op) { ctx.HADDPS(mx, x) }

// HSUBPD: Packed Double-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPD m128 xmm
//	HSUBPD xmm  xmm
//
// Construct and append a HSUBPD instruction to the active function.
func (c *Context) HSUBPD(mx, x operand.Op) {
	c.addinstruction(x86.HSUBPD(mx, x))
}

// HSUBPD: Packed Double-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPD m128 xmm
//	HSUBPD xmm  xmm
//
// Construct and append a HSUBPD instruction to the active function.
// Operates on the global context.
func HSUBPD(mx, x operand.Op) { ctx.HSUBPD(mx, x) }

// HSUBPS: Packed Single-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPS m128 xmm
//	HSUBPS xmm  xmm
//
// Construct and append a HSUBPS instruction to the active function.
func (c *Context) HSUBPS(mx, x operand.Op) {
	c.addinstruction(x86.HSUBPS(mx, x))
}

// HSUBPS: Packed Single-FP Horizontal Subtract.
//
// Forms:
//
//	HSUBPS m128 xmm
//	HSUBPS xmm  xmm
//
// Construct and append a HSUBPS instruction to the active function.
// Operates on the global context.
func HSUBPS(mx, x operand.Op) { ctx.HSUBPS(mx, x) }

// IDIVB: Signed Divide.
//
// Forms:
//
//	IDIVB m8
//	IDIVB r8
//
// Construct and append a IDIVB instruction to the active function.
func (c *Context) IDIVB(mr operand.Op) {
	c.addinstruction(x86.IDIVB(mr))
}

// IDIVB: Signed Divide.
//
// Forms:
//
//	IDIVB m8
//	IDIVB r8
//
// Construct and append a IDIVB instruction to the active function.
// Operates on the global context.
func IDIVB(mr operand.Op) { ctx.IDIVB(mr) }

// IDIVL: Signed Divide.
//
// Forms:
//
//	IDIVL m32
//	IDIVL r32
//
// Construct and append a IDIVL instruction to the active function.
func (c *Context) IDIVL(mr operand.Op) {
	c.addinstruction(x86.IDIVL(mr))
}

// IDIVL: Signed Divide.
//
// Forms:
//
//	IDIVL m32
//	IDIVL r32
//
// Construct and append a IDIVL instruction to the active function.
// Operates on the global context.
func IDIVL(mr operand.Op) { ctx.IDIVL(mr) }

// IDIVQ: Signed Divide.
//
// Forms:
//
//	IDIVQ m64
//	IDIVQ r64
//
// Construct and append a IDIVQ instruction to the active function.
func (c *Context) IDIVQ(mr operand.Op) {
	c.addinstruction(x86.IDIVQ(mr))
}

// IDIVQ: Signed Divide.
//
// Forms:
//
//	IDIVQ m64
//	IDIVQ r64
//
// Construct and append a IDIVQ instruction to the active function.
// Operates on the global context.
func IDIVQ(mr operand.Op) { ctx.IDIVQ(mr) }

// IDIVW: Signed Divide.
//
// Forms:
//
//	IDIVW m16
//	IDIVW r16
//
// Construct and append a IDIVW instruction to the active function.
func (c *Context) IDIVW(mr operand.Op) {
	c.addinstruction(x86.IDIVW(mr))
}

// IDIVW: Signed Divide.
//
// Forms:
//
//	IDIVW m16
//	IDIVW r16
//
// Construct and append a IDIVW instruction to the active function.
// Operates on the global context.
func IDIVW(mr operand.Op) { ctx.IDIVW(mr) }

// IMUL3L: Signed Multiply.
//
// Forms:
//
//	IMUL3L imm32 m32 r32
//	IMUL3L imm32 r32 r32
//	IMUL3L imm8  m32 r32
//	IMUL3L imm8  r32 r32
//
// Construct and append a IMUL3L instruction to the active function.
func (c *Context) IMUL3L(i, mr, r operand.Op) {
	c.addinstruction(x86.IMUL3L(i, mr, r))
}

// IMUL3L: Signed Multiply.
//
// Forms:
//
//	IMUL3L imm32 m32 r32
//	IMUL3L imm32 r32 r32
//	IMUL3L imm8  m32 r32
//	IMUL3L imm8  r32 r32
//
// Construct and append a IMUL3L instruction to the active function.
// Operates on the global context.
func IMUL3L(i, mr, r operand.Op) { ctx.IMUL3L(i, mr, r) }

// IMUL3Q: Signed Multiply.
//
// Forms:
//
//	IMUL3Q imm32 m64 r64
//	IMUL3Q imm32 r64 r64
//	IMUL3Q imm8  m64 r64
//	IMUL3Q imm8  r64 r64
//
// Construct and append a IMUL3Q instruction to the active function.
func (c *Context) IMUL3Q(i, mr, r operand.Op) {
	c.addinstruction(x86.IMUL3Q(i, mr, r))
}

// IMUL3Q: Signed Multiply.
//
// Forms:
//
//	IMUL3Q imm32 m64 r64
//	IMUL3Q imm32 r64 r64
//	IMUL3Q imm8  m64 r64
//	IMUL3Q imm8  r64 r64
//
// Construct and append a IMUL3Q instruction to the active function.
// Operates on the global context.
func IMUL3Q(i, mr, r operand.Op) { ctx.IMUL3Q(i, mr, r) }

// IMUL3W: Signed Multiply.
//
// Forms:
//
//	IMUL3W imm16 m16 r16
//	IMUL3W imm16 r16 r16
//	IMUL3W imm8  m16 r16
//	IMUL3W imm8  r16 r16
//
// Construct and append a IMUL3W instruction to the active function.
func (c *Context) IMUL3W(i, mr, r operand.Op) {
	c.addinstruction(x86.IMUL3W(i, mr, r))
}

// IMUL3W: Signed Multiply.
//
// Forms:
//
//	IMUL3W imm16 m16 r16
//	IMUL3W imm16 r16 r16
//	IMUL3W imm8  m16 r16
//	IMUL3W imm8  r16 r16
//
// Construct and append a IMUL3W instruction to the active function.
// Operates on the global context.
func IMUL3W(i, mr, r operand.Op) { ctx.IMUL3W(i, mr, r) }

// IMULB: Signed Multiply.
//
// Forms:
//
//	IMULB m8
//	IMULB r8
//
// Construct and append a IMULB instruction to the active function.
func (c *Context) IMULB(mr operand.Op) {
	c.addinstruction(x86.IMULB(mr))
}

// IMULB: Signed Multiply.
//
// Forms:
//
//	IMULB m8
//	IMULB r8
//
// Construct and append a IMULB instruction to the active function.
// Operates on the global context.
func IMULB(mr operand.Op) { ctx.IMULB(mr) }

// IMULL: Signed Multiply.
//
// Forms:
//
//	IMULL m32 r32
//	IMULL m32
//	IMULL r32 r32
//	IMULL r32
//
// Construct and append a IMULL instruction to the active function.
func (c *Context) IMULL(ops ...operand.Op) {
	c.addinstruction(x86.IMULL(ops...))
}

// IMULL: Signed Multiply.
//
// Forms:
//
//	IMULL m32 r32
//	IMULL m32
//	IMULL r32 r32
//	IMULL r32
//
// Construct and append a IMULL instruction to the active function.
// Operates on the global context.
func IMULL(ops ...operand.Op) { ctx.IMULL(ops...) }

// IMULQ: Signed Multiply.
//
// Forms:
//
//	IMULQ m64 r64
//	IMULQ m64
//	IMULQ r64 r64
//	IMULQ r64
//
// Construct and append a IMULQ instruction to the active function.
func (c *Context) IMULQ(ops ...operand.Op) {
	c.addinstruction(x86.IMULQ(ops...))
}

// IMULQ: Signed Multiply.
//
// Forms:
//
//	IMULQ m64 r64
//	IMULQ m64
//	IMULQ r64 r64
//	IMULQ r64
//
// Construct and append a IMULQ instruction to the active function.
// Operates on the global context.
func IMULQ(ops ...operand.Op) { ctx.IMULQ(ops...) }

// IMULW: Signed Multiply.
//
// Forms:
//
//	IMULW m16 r16
//	IMULW m16
//	IMULW r16 r16
//	IMULW r16
//
// Construct and append a IMULW instruction to the active function.
func (c *Context) IMULW(ops ...operand.Op) {
	c.addinstruction(x86.IMULW(ops...))
}

// IMULW: Signed Multiply.
//
// Forms:
//
//	IMULW m16 r16
//	IMULW m16
//	IMULW r16 r16
//	IMULW r16
//
// Construct and append a IMULW instruction to the active function.
// Operates on the global context.
func IMULW(ops ...operand.Op) { ctx.IMULW(ops...) }

// INCB: Increment by 1.
//
// Forms:
//
//	INCB m8
//	INCB r8
//
// Construct and append a INCB instruction to the active function.
func (c *Context) INCB(mr operand.Op) {
	c.addinstruction(x86.INCB(mr))
}

// INCB: Increment by 1.
//
// Forms:
//
//	INCB m8
//	INCB r8
//
// Construct and append a INCB instruction to the active function.
// Operates on the global context.
func INCB(mr operand.Op) { ctx.INCB(mr) }

// INCL: Increment by 1.
//
// Forms:
//
//	INCL m32
//	INCL r32
//
// Construct and append a INCL instruction to the active function.
func (c *Context) INCL(mr operand.Op) {
	c.addinstruction(x86.INCL(mr))
}

// INCL: Increment by 1.
//
// Forms:
//
//	INCL m32
//	INCL r32
//
// Construct and append a INCL instruction to the active function.
// Operates on the global context.
func INCL(mr operand.Op) { ctx.INCL(mr) }

// INCQ: Increment by 1.
//
// Forms:
//
//	INCQ m64
//	INCQ r64
//
// Construct and append a INCQ instruction to the active function.
func (c *Context) INCQ(mr operand.Op) {
	c.addinstruction(x86.INCQ(mr))
}

// INCQ: Increment by 1.
//
// Forms:
//
//	INCQ m64
//	INCQ r64
//
// Construct and append a INCQ instruction to the active function.
// Operates on the global context.
func INCQ(mr operand.Op) { ctx.INCQ(mr) }

// INCW: Increment by 1.
//
// Forms:
//
//	INCW m16
//	INCW r16
//
// Construct and append a INCW instruction to the active function.
func (c *Context) INCW(mr operand.Op) {
	c.addinstruction(x86.INCW(mr))
}

// INCW: Increment by 1.
//
// Forms:
//
//	INCW m16
//	INCW r16
//
// Construct and append a INCW instruction to the active function.
// Operates on the global context.
func INCW(mr operand.Op) { ctx.INCW(mr) }

// INSERTPS: Insert Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	INSERTPS imm8 m32 xmm
//	INSERTPS imm8 xmm xmm
//
// Construct and append a INSERTPS instruction to the active function.
func (c *Context) INSERTPS(i, mx, x operand.Op) {
	c.addinstruction(x86.INSERTPS(i, mx, x))
}

// INSERTPS: Insert Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	INSERTPS imm8 m32 xmm
//	INSERTPS imm8 xmm xmm
//
// Construct and append a INSERTPS instruction to the active function.
// Operates on the global context.
func INSERTPS(i, mx, x operand.Op) { ctx.INSERTPS(i, mx, x) }

// INT: Call to Interrupt Procedure.
//
// Forms:
//
//	INT 3
//	INT imm8
//
// Construct and append a INT instruction to the active function.
func (c *Context) INT(i operand.Op) {
	c.addinstruction(x86.INT(i))
}

// INT: Call to Interrupt Procedure.
//
// Forms:
//
//	INT 3
//	INT imm8
//
// Construct and append a INT instruction to the active function.
// Operates on the global context.
func INT(i operand.Op) { ctx.INT(i) }

// JA: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JA rel32
//	JA rel8
//
// Construct and append a JA instruction to the active function.
func (c *Context) JA(r operand.Op) {
	c.addinstruction(x86.JA(r))
}

// JA: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JA rel32
//	JA rel8
//
// Construct and append a JA instruction to the active function.
// Operates on the global context.
func JA(r operand.Op) { ctx.JA(r) }

// JAE: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JAE rel32
//	JAE rel8
//
// Construct and append a JAE instruction to the active function.
func (c *Context) JAE(r operand.Op) {
	c.addinstruction(x86.JAE(r))
}

// JAE: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JAE rel32
//	JAE rel8
//
// Construct and append a JAE instruction to the active function.
// Operates on the global context.
func JAE(r operand.Op) { ctx.JAE(r) }

// JB: Jump if below (CF == 1).
//
// Forms:
//
//	JB rel32
//	JB rel8
//
// Construct and append a JB instruction to the active function.
func (c *Context) JB(r operand.Op) {
	c.addinstruction(x86.JB(r))
}

// JB: Jump if below (CF == 1).
//
// Forms:
//
//	JB rel32
//	JB rel8
//
// Construct and append a JB instruction to the active function.
// Operates on the global context.
func JB(r operand.Op) { ctx.JB(r) }

// JBE: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JBE rel32
//	JBE rel8
//
// Construct and append a JBE instruction to the active function.
func (c *Context) JBE(r operand.Op) {
	c.addinstruction(x86.JBE(r))
}

// JBE: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JBE rel32
//	JBE rel8
//
// Construct and append a JBE instruction to the active function.
// Operates on the global context.
func JBE(r operand.Op) { ctx.JBE(r) }

// JC: Jump if below (CF == 1).
//
// Forms:
//
//	JC rel32
//	JC rel8
//
// Construct and append a JC instruction to the active function.
func (c *Context) JC(r operand.Op) {
	c.addinstruction(x86.JC(r))
}

// JC: Jump if below (CF == 1).
//
// Forms:
//
//	JC rel32
//	JC rel8
//
// Construct and append a JC instruction to the active function.
// Operates on the global context.
func JC(r operand.Op) { ctx.JC(r) }

// JCC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JCC rel32
//	JCC rel8
//
// Construct and append a JCC instruction to the active function.
func (c *Context) JCC(r operand.Op) {
	c.addinstruction(x86.JCC(r))
}

// JCC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JCC rel32
//	JCC rel8
//
// Construct and append a JCC instruction to the active function.
// Operates on the global context.
func JCC(r operand.Op) { ctx.JCC(r) }

// JCS: Jump if below (CF == 1).
//
// Forms:
//
//	JCS rel32
//	JCS rel8
//
// Construct and append a JCS instruction to the active function.
func (c *Context) JCS(r operand.Op) {
	c.addinstruction(x86.JCS(r))
}

// JCS: Jump if below (CF == 1).
//
// Forms:
//
//	JCS rel32
//	JCS rel8
//
// Construct and append a JCS instruction to the active function.
// Operates on the global context.
func JCS(r operand.Op) { ctx.JCS(r) }

// JCXZL: Jump if ECX register is 0.
//
// Forms:
//
//	JCXZL rel8
//
// Construct and append a JCXZL instruction to the active function.
func (c *Context) JCXZL(r operand.Op) {
	c.addinstruction(x86.JCXZL(r))
}

// JCXZL: Jump if ECX register is 0.
//
// Forms:
//
//	JCXZL rel8
//
// Construct and append a JCXZL instruction to the active function.
// Operates on the global context.
func JCXZL(r operand.Op) { ctx.JCXZL(r) }

// JCXZQ: Jump if RCX register is 0.
//
// Forms:
//
//	JCXZQ rel8
//
// Construct and append a JCXZQ instruction to the active function.
func (c *Context) JCXZQ(r operand.Op) {
	c.addinstruction(x86.JCXZQ(r))
}

// JCXZQ: Jump if RCX register is 0.
//
// Forms:
//
//	JCXZQ rel8
//
// Construct and append a JCXZQ instruction to the active function.
// Operates on the global context.
func JCXZQ(r operand.Op) { ctx.JCXZQ(r) }

// JE: Jump if equal (ZF == 1).
//
// Forms:
//
//	JE rel32
//	JE rel8
//
// Construct and append a JE instruction to the active function.
func (c *Context) JE(r operand.Op) {
	c.addinstruction(x86.JE(r))
}

// JE: Jump if equal (ZF == 1).
//
// Forms:
//
//	JE rel32
//	JE rel8
//
// Construct and append a JE instruction to the active function.
// Operates on the global context.
func JE(r operand.Op) { ctx.JE(r) }

// JEQ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JEQ rel32
//	JEQ rel8
//
// Construct and append a JEQ instruction to the active function.
func (c *Context) JEQ(r operand.Op) {
	c.addinstruction(x86.JEQ(r))
}

// JEQ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JEQ rel32
//	JEQ rel8
//
// Construct and append a JEQ instruction to the active function.
// Operates on the global context.
func JEQ(r operand.Op) { ctx.JEQ(r) }

// JG: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JG rel32
//	JG rel8
//
// Construct and append a JG instruction to the active function.
func (c *Context) JG(r operand.Op) {
	c.addinstruction(x86.JG(r))
}

// JG: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JG rel32
//	JG rel8
//
// Construct and append a JG instruction to the active function.
// Operates on the global context.
func JG(r operand.Op) { ctx.JG(r) }

// JGE: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JGE rel32
//	JGE rel8
//
// Construct and append a JGE instruction to the active function.
func (c *Context) JGE(r operand.Op) {
	c.addinstruction(x86.JGE(r))
}

// JGE: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JGE rel32
//	JGE rel8
//
// Construct and append a JGE instruction to the active function.
// Operates on the global context.
func JGE(r operand.Op) { ctx.JGE(r) }

// JGT: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JGT rel32
//	JGT rel8
//
// Construct and append a JGT instruction to the active function.
func (c *Context) JGT(r operand.Op) {
	c.addinstruction(x86.JGT(r))
}

// JGT: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JGT rel32
//	JGT rel8
//
// Construct and append a JGT instruction to the active function.
// Operates on the global context.
func JGT(r operand.Op) { ctx.JGT(r) }

// JHI: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JHI rel32
//	JHI rel8
//
// Construct and append a JHI instruction to the active function.
func (c *Context) JHI(r operand.Op) {
	c.addinstruction(x86.JHI(r))
}

// JHI: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JHI rel32
//	JHI rel8
//
// Construct and append a JHI instruction to the active function.
// Operates on the global context.
func JHI(r operand.Op) { ctx.JHI(r) }

// JHS: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JHS rel32
//	JHS rel8
//
// Construct and append a JHS instruction to the active function.
func (c *Context) JHS(r operand.Op) {
	c.addinstruction(x86.JHS(r))
}

// JHS: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JHS rel32
//	JHS rel8
//
// Construct and append a JHS instruction to the active function.
// Operates on the global context.
func JHS(r operand.Op) { ctx.JHS(r) }

// JL: Jump if less (SF != OF).
//
// Forms:
//
//	JL rel32
//	JL rel8
//
// Construct and append a JL instruction to the active function.
func (c *Context) JL(r operand.Op) {
	c.addinstruction(x86.JL(r))
}

// JL: Jump if less (SF != OF).
//
// Forms:
//
//	JL rel32
//	JL rel8
//
// Construct and append a JL instruction to the active function.
// Operates on the global context.
func JL(r operand.Op) { ctx.JL(r) }

// JLE: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JLE rel32
//	JLE rel8
//
// Construct and append a JLE instruction to the active function.
func (c *Context) JLE(r operand.Op) {
	c.addinstruction(x86.JLE(r))
}

// JLE: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JLE rel32
//	JLE rel8
//
// Construct and append a JLE instruction to the active function.
// Operates on the global context.
func JLE(r operand.Op) { ctx.JLE(r) }

// JLO: Jump if below (CF == 1).
//
// Forms:
//
//	JLO rel32
//	JLO rel8
//
// Construct and append a JLO instruction to the active function.
func (c *Context) JLO(r operand.Op) {
	c.addinstruction(x86.JLO(r))
}

// JLO: Jump if below (CF == 1).
//
// Forms:
//
//	JLO rel32
//	JLO rel8
//
// Construct and append a JLO instruction to the active function.
// Operates on the global context.
func JLO(r operand.Op) { ctx.JLO(r) }

// JLS: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JLS rel32
//	JLS rel8
//
// Construct and append a JLS instruction to the active function.
func (c *Context) JLS(r operand.Op) {
	c.addinstruction(x86.JLS(r))
}

// JLS: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JLS rel32
//	JLS rel8
//
// Construct and append a JLS instruction to the active function.
// Operates on the global context.
func JLS(r operand.Op) { ctx.JLS(r) }

// JLT: Jump if less (SF != OF).
//
// Forms:
//
//	JLT rel32
//	JLT rel8
//
// Construct and append a JLT instruction to the active function.
func (c *Context) JLT(r operand.Op) {
	c.addinstruction(x86.JLT(r))
}

// JLT: Jump if less (SF != OF).
//
// Forms:
//
//	JLT rel32
//	JLT rel8
//
// Construct and append a JLT instruction to the active function.
// Operates on the global context.
func JLT(r operand.Op) { ctx.JLT(r) }

// JMI: Jump if sign (SF == 1).
//
// Forms:
//
//	JMI rel32
//	JMI rel8
//
// Construct and append a JMI instruction to the active function.
func (c *Context) JMI(r operand.Op) {
	c.addinstruction(x86.JMI(r))
}

// JMI: Jump if sign (SF == 1).
//
// Forms:
//
//	JMI rel32
//	JMI rel8
//
// Construct and append a JMI instruction to the active function.
// Operates on the global context.
func JMI(r operand.Op) { ctx.JMI(r) }

// JMP: Jump Unconditionally.
//
// Forms:
//
//	JMP rel32
//	JMP rel8
//	JMP m64
//	JMP r64
//
// Construct and append a JMP instruction to the active function.
func (c *Context) JMP(mr operand.Op) {
	c.addinstruction(x86.JMP(mr))
}

// JMP: Jump Unconditionally.
//
// Forms:
//
//	JMP rel32
//	JMP rel8
//	JMP m64
//	JMP r64
//
// Construct and append a JMP instruction to the active function.
// Operates on the global context.
func JMP(mr operand.Op) { ctx.JMP(mr) }

// JNA: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JNA rel32
//	JNA rel8
//
// Construct and append a JNA instruction to the active function.
func (c *Context) JNA(r operand.Op) {
	c.addinstruction(x86.JNA(r))
}

// JNA: Jump if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	JNA rel32
//	JNA rel8
//
// Construct and append a JNA instruction to the active function.
// Operates on the global context.
func JNA(r operand.Op) { ctx.JNA(r) }

// JNAE: Jump if below (CF == 1).
//
// Forms:
//
//	JNAE rel32
//	JNAE rel8
//
// Construct and append a JNAE instruction to the active function.
func (c *Context) JNAE(r operand.Op) {
	c.addinstruction(x86.JNAE(r))
}

// JNAE: Jump if below (CF == 1).
//
// Forms:
//
//	JNAE rel32
//	JNAE rel8
//
// Construct and append a JNAE instruction to the active function.
// Operates on the global context.
func JNAE(r operand.Op) { ctx.JNAE(r) }

// JNB: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNB rel32
//	JNB rel8
//
// Construct and append a JNB instruction to the active function.
func (c *Context) JNB(r operand.Op) {
	c.addinstruction(x86.JNB(r))
}

// JNB: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNB rel32
//	JNB rel8
//
// Construct and append a JNB instruction to the active function.
// Operates on the global context.
func JNB(r operand.Op) { ctx.JNB(r) }

// JNBE: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JNBE rel32
//	JNBE rel8
//
// Construct and append a JNBE instruction to the active function.
func (c *Context) JNBE(r operand.Op) {
	c.addinstruction(x86.JNBE(r))
}

// JNBE: Jump if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	JNBE rel32
//	JNBE rel8
//
// Construct and append a JNBE instruction to the active function.
// Operates on the global context.
func JNBE(r operand.Op) { ctx.JNBE(r) }

// JNC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNC rel32
//	JNC rel8
//
// Construct and append a JNC instruction to the active function.
func (c *Context) JNC(r operand.Op) {
	c.addinstruction(x86.JNC(r))
}

// JNC: Jump if above or equal (CF == 0).
//
// Forms:
//
//	JNC rel32
//	JNC rel8
//
// Construct and append a JNC instruction to the active function.
// Operates on the global context.
func JNC(r operand.Op) { ctx.JNC(r) }

// JNE: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNE rel32
//	JNE rel8
//
// Construct and append a JNE instruction to the active function.
func (c *Context) JNE(r operand.Op) {
	c.addinstruction(x86.JNE(r))
}

// JNE: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNE rel32
//	JNE rel8
//
// Construct and append a JNE instruction to the active function.
// Operates on the global context.
func JNE(r operand.Op) { ctx.JNE(r) }

// JNG: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JNG rel32
//	JNG rel8
//
// Construct and append a JNG instruction to the active function.
func (c *Context) JNG(r operand.Op) {
	c.addinstruction(x86.JNG(r))
}

// JNG: Jump if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	JNG rel32
//	JNG rel8
//
// Construct and append a JNG instruction to the active function.
// Operates on the global context.
func JNG(r operand.Op) { ctx.JNG(r) }

// JNGE: Jump if less (SF != OF).
//
// Forms:
//
//	JNGE rel32
//	JNGE rel8
//
// Construct and append a JNGE instruction to the active function.
func (c *Context) JNGE(r operand.Op) {
	c.addinstruction(x86.JNGE(r))
}

// JNGE: Jump if less (SF != OF).
//
// Forms:
//
//	JNGE rel32
//	JNGE rel8
//
// Construct and append a JNGE instruction to the active function.
// Operates on the global context.
func JNGE(r operand.Op) { ctx.JNGE(r) }

// JNL: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JNL rel32
//	JNL rel8
//
// Construct and append a JNL instruction to the active function.
func (c *Context) JNL(r operand.Op) {
	c.addinstruction(x86.JNL(r))
}

// JNL: Jump if greater or equal (SF == OF).
//
// Forms:
//
//	JNL rel32
//	JNL rel8
//
// Construct and append a JNL instruction to the active function.
// Operates on the global context.
func JNL(r operand.Op) { ctx.JNL(r) }

// JNLE: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JNLE rel32
//	JNLE rel8
//
// Construct and append a JNLE instruction to the active function.
func (c *Context) JNLE(r operand.Op) {
	c.addinstruction(x86.JNLE(r))
}

// JNLE: Jump if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	JNLE rel32
//	JNLE rel8
//
// Construct and append a JNLE instruction to the active function.
// Operates on the global context.
func JNLE(r operand.Op) { ctx.JNLE(r) }

// JNO: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JNO rel32
//	JNO rel8
//
// Construct and append a JNO instruction to the active function.
func (c *Context) JNO(r operand.Op) {
	c.addinstruction(x86.JNO(r))
}

// JNO: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JNO rel32
//	JNO rel8
//
// Construct and append a JNO instruction to the active function.
// Operates on the global context.
func JNO(r operand.Op) { ctx.JNO(r) }

// JNP: Jump if not parity (PF == 0).
//
// Forms:
//
//	JNP rel32
//	JNP rel8
//
// Construct and append a JNP instruction to the active function.
func (c *Context) JNP(r operand.Op) {
	c.addinstruction(x86.JNP(r))
}

// JNP: Jump if not parity (PF == 0).
//
// Forms:
//
//	JNP rel32
//	JNP rel8
//
// Construct and append a JNP instruction to the active function.
// Operates on the global context.
func JNP(r operand.Op) { ctx.JNP(r) }

// JNS: Jump if not sign (SF == 0).
//
// Forms:
//
//	JNS rel32
//	JNS rel8
//
// Construct and append a JNS instruction to the active function.
func (c *Context) JNS(r operand.Op) {
	c.addinstruction(x86.JNS(r))
}

// JNS: Jump if not sign (SF == 0).
//
// Forms:
//
//	JNS rel32
//	JNS rel8
//
// Construct and append a JNS instruction to the active function.
// Operates on the global context.
func JNS(r operand.Op) { ctx.JNS(r) }

// JNZ: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNZ rel32
//	JNZ rel8
//
// Construct and append a JNZ instruction to the active function.
func (c *Context) JNZ(r operand.Op) {
	c.addinstruction(x86.JNZ(r))
}

// JNZ: Jump if not equal (ZF == 0).
//
// Forms:
//
//	JNZ rel32
//	JNZ rel8
//
// Construct and append a JNZ instruction to the active function.
// Operates on the global context.
func JNZ(r operand.Op) { ctx.JNZ(r) }

// JO: Jump if overflow (OF == 1).
//
// Forms:
//
//	JO rel32
//	JO rel8
//
// Construct and append a JO instruction to the active function.
func (c *Context) JO(r operand.Op) {
	c.addinstruction(x86.JO(r))
}

// JO: Jump if overflow (OF == 1).
//
// Forms:
//
//	JO rel32
//	JO rel8
//
// Construct and append a JO instruction to the active function.
// Operates on the global context.
func JO(r operand.Op) { ctx.JO(r) }

// JOC: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JOC rel32
//	JOC rel8
//
// Construct and append a JOC instruction to the active function.
func (c *Context) JOC(r operand.Op) {
	c.addinstruction(x86.JOC(r))
}

// JOC: Jump if not overflow (OF == 0).
//
// Forms:
//
//	JOC rel32
//	JOC rel8
//
// Construct and append a JOC instruction to the active function.
// Operates on the global context.
func JOC(r operand.Op) { ctx.JOC(r) }

// JOS: Jump if overflow (OF == 1).
//
// Forms:
//
//	JOS rel32
//	JOS rel8
//
// Construct and append a JOS instruction to the active function.
func (c *Context) JOS(r operand.Op) {
	c.addinstruction(x86.JOS(r))
}

// JOS: Jump if overflow (OF == 1).
//
// Forms:
//
//	JOS rel32
//	JOS rel8
//
// Construct and append a JOS instruction to the active function.
// Operates on the global context.
func JOS(r operand.Op) { ctx.JOS(r) }

// JP: Jump if parity (PF == 1).
//
// Forms:
//
//	JP rel32
//	JP rel8
//
// Construct and append a JP instruction to the active function.
func (c *Context) JP(r operand.Op) {
	c.addinstruction(x86.JP(r))
}

// JP: Jump if parity (PF == 1).
//
// Forms:
//
//	JP rel32
//	JP rel8
//
// Construct and append a JP instruction to the active function.
// Operates on the global context.
func JP(r operand.Op) { ctx.JP(r) }

// JPC: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPC rel32
//	JPC rel8
//
// Construct and append a JPC instruction to the active function.
func (c *Context) JPC(r operand.Op) {
	c.addinstruction(x86.JPC(r))
}

// JPC: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPC rel32
//	JPC rel8
//
// Construct and append a JPC instruction to the active function.
// Operates on the global context.
func JPC(r operand.Op) { ctx.JPC(r) }

// JPE: Jump if parity (PF == 1).
//
// Forms:
//
//	JPE rel32
//	JPE rel8
//
// Construct and append a JPE instruction to the active function.
func (c *Context) JPE(r operand.Op) {
	c.addinstruction(x86.JPE(r))
}

// JPE: Jump if parity (PF == 1).
//
// Forms:
//
//	JPE rel32
//	JPE rel8
//
// Construct and append a JPE instruction to the active function.
// Operates on the global context.
func JPE(r operand.Op) { ctx.JPE(r) }

// JPL: Jump if not sign (SF == 0).
//
// Forms:
//
//	JPL rel32
//	JPL rel8
//
// Construct and append a JPL instruction to the active function.
func (c *Context) JPL(r operand.Op) {
	c.addinstruction(x86.JPL(r))
}

// JPL: Jump if not sign (SF == 0).
//
// Forms:
//
//	JPL rel32
//	JPL rel8
//
// Construct and append a JPL instruction to the active function.
// Operates on the global context.
func JPL(r operand.Op) { ctx.JPL(r) }

// JPO: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPO rel32
//	JPO rel8
//
// Construct and append a JPO instruction to the active function.
func (c *Context) JPO(r operand.Op) {
	c.addinstruction(x86.JPO(r))
}

// JPO: Jump if not parity (PF == 0).
//
// Forms:
//
//	JPO rel32
//	JPO rel8
//
// Construct and append a JPO instruction to the active function.
// Operates on the global context.
func JPO(r operand.Op) { ctx.JPO(r) }

// JPS: Jump if parity (PF == 1).
//
// Forms:
//
//	JPS rel32
//	JPS rel8
//
// Construct and append a JPS instruction to the active function.
func (c *Context) JPS(r operand.Op) {
	c.addinstruction(x86.JPS(r))
}

// JPS: Jump if parity (PF == 1).
//
// Forms:
//
//	JPS rel32
//	JPS rel8
//
// Construct and append a JPS instruction to the active function.
// Operates on the global context.
func JPS(r operand.Op) { ctx.JPS(r) }

// JS: Jump if sign (SF == 1).
//
// Forms:
//
//	JS rel32
//	JS rel8
//
// Construct and append a JS instruction to the active function.
func (c *Context) JS(r operand.Op) {
	c.addinstruction(x86.JS(r))
}

// JS: Jump if sign (SF == 1).
//
// Forms:
//
//	JS rel32
//	JS rel8
//
// Construct and append a JS instruction to the active function.
// Operates on the global context.
func JS(r operand.Op) { ctx.JS(r) }

// JZ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JZ rel32
//	JZ rel8
//
// Construct and append a JZ instruction to the active function.
func (c *Context) JZ(r operand.Op) {
	c.addinstruction(x86.JZ(r))
}

// JZ: Jump if equal (ZF == 1).
//
// Forms:
//
//	JZ rel32
//	JZ rel8
//
// Construct and append a JZ instruction to the active function.
// Operates on the global context.
func JZ(r operand.Op) { ctx.JZ(r) }

// KADDB: ADD Two 8-bit Masks.
//
// Forms:
//
//	KADDB k k k
//
// Construct and append a KADDB instruction to the active function.
func (c *Context) KADDB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KADDB(k, k1, k2))
}

// KADDB: ADD Two 8-bit Masks.
//
// Forms:
//
//	KADDB k k k
//
// Construct and append a KADDB instruction to the active function.
// Operates on the global context.
func KADDB(k, k1, k2 operand.Op) { ctx.KADDB(k, k1, k2) }

// KADDD: ADD Two 32-bit Masks.
//
// Forms:
//
//	KADDD k k k
//
// Construct and append a KADDD instruction to the active function.
func (c *Context) KADDD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KADDD(k, k1, k2))
}

// KADDD: ADD Two 32-bit Masks.
//
// Forms:
//
//	KADDD k k k
//
// Construct and append a KADDD instruction to the active function.
// Operates on the global context.
func KADDD(k, k1, k2 operand.Op) { ctx.KADDD(k, k1, k2) }

// KADDQ: ADD Two 64-bit Masks.
//
// Forms:
//
//	KADDQ k k k
//
// Construct and append a KADDQ instruction to the active function.
func (c *Context) KADDQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KADDQ(k, k1, k2))
}

// KADDQ: ADD Two 64-bit Masks.
//
// Forms:
//
//	KADDQ k k k
//
// Construct and append a KADDQ instruction to the active function.
// Operates on the global context.
func KADDQ(k, k1, k2 operand.Op) { ctx.KADDQ(k, k1, k2) }

// KADDW: ADD Two 16-bit Masks.
//
// Forms:
//
//	KADDW k k k
//
// Construct and append a KADDW instruction to the active function.
func (c *Context) KADDW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KADDW(k, k1, k2))
}

// KADDW: ADD Two 16-bit Masks.
//
// Forms:
//
//	KADDW k k k
//
// Construct and append a KADDW instruction to the active function.
// Operates on the global context.
func KADDW(k, k1, k2 operand.Op) { ctx.KADDW(k, k1, k2) }

// KANDB: Bitwise Logical AND 8-bit Masks.
//
// Forms:
//
//	KANDB k k k
//
// Construct and append a KANDB instruction to the active function.
func (c *Context) KANDB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDB(k, k1, k2))
}

// KANDB: Bitwise Logical AND 8-bit Masks.
//
// Forms:
//
//	KANDB k k k
//
// Construct and append a KANDB instruction to the active function.
// Operates on the global context.
func KANDB(k, k1, k2 operand.Op) { ctx.KANDB(k, k1, k2) }

// KANDD: Bitwise Logical AND 32-bit Masks.
//
// Forms:
//
//	KANDD k k k
//
// Construct and append a KANDD instruction to the active function.
func (c *Context) KANDD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDD(k, k1, k2))
}

// KANDD: Bitwise Logical AND 32-bit Masks.
//
// Forms:
//
//	KANDD k k k
//
// Construct and append a KANDD instruction to the active function.
// Operates on the global context.
func KANDD(k, k1, k2 operand.Op) { ctx.KANDD(k, k1, k2) }

// KANDNB: Bitwise Logical AND NOT 8-bit Masks.
//
// Forms:
//
//	KANDNB k k k
//
// Construct and append a KANDNB instruction to the active function.
func (c *Context) KANDNB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDNB(k, k1, k2))
}

// KANDNB: Bitwise Logical AND NOT 8-bit Masks.
//
// Forms:
//
//	KANDNB k k k
//
// Construct and append a KANDNB instruction to the active function.
// Operates on the global context.
func KANDNB(k, k1, k2 operand.Op) { ctx.KANDNB(k, k1, k2) }

// KANDND: Bitwise Logical AND NOT 32-bit Masks.
//
// Forms:
//
//	KANDND k k k
//
// Construct and append a KANDND instruction to the active function.
func (c *Context) KANDND(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDND(k, k1, k2))
}

// KANDND: Bitwise Logical AND NOT 32-bit Masks.
//
// Forms:
//
//	KANDND k k k
//
// Construct and append a KANDND instruction to the active function.
// Operates on the global context.
func KANDND(k, k1, k2 operand.Op) { ctx.KANDND(k, k1, k2) }

// KANDNQ: Bitwise Logical AND NOT 64-bit Masks.
//
// Forms:
//
//	KANDNQ k k k
//
// Construct and append a KANDNQ instruction to the active function.
func (c *Context) KANDNQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDNQ(k, k1, k2))
}

// KANDNQ: Bitwise Logical AND NOT 64-bit Masks.
//
// Forms:
//
//	KANDNQ k k k
//
// Construct and append a KANDNQ instruction to the active function.
// Operates on the global context.
func KANDNQ(k, k1, k2 operand.Op) { ctx.KANDNQ(k, k1, k2) }

// KANDNW: Bitwise Logical AND NOT 16-bit Masks.
//
// Forms:
//
//	KANDNW k k k
//
// Construct and append a KANDNW instruction to the active function.
func (c *Context) KANDNW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDNW(k, k1, k2))
}

// KANDNW: Bitwise Logical AND NOT 16-bit Masks.
//
// Forms:
//
//	KANDNW k k k
//
// Construct and append a KANDNW instruction to the active function.
// Operates on the global context.
func KANDNW(k, k1, k2 operand.Op) { ctx.KANDNW(k, k1, k2) }

// KANDQ: Bitwise Logical AND 64-bit Masks.
//
// Forms:
//
//	KANDQ k k k
//
// Construct and append a KANDQ instruction to the active function.
func (c *Context) KANDQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDQ(k, k1, k2))
}

// KANDQ: Bitwise Logical AND 64-bit Masks.
//
// Forms:
//
//	KANDQ k k k
//
// Construct and append a KANDQ instruction to the active function.
// Operates on the global context.
func KANDQ(k, k1, k2 operand.Op) { ctx.KANDQ(k, k1, k2) }

// KANDW: Bitwise Logical AND 16-bit Masks.
//
// Forms:
//
//	KANDW k k k
//
// Construct and append a KANDW instruction to the active function.
func (c *Context) KANDW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KANDW(k, k1, k2))
}

// KANDW: Bitwise Logical AND 16-bit Masks.
//
// Forms:
//
//	KANDW k k k
//
// Construct and append a KANDW instruction to the active function.
// Operates on the global context.
func KANDW(k, k1, k2 operand.Op) { ctx.KANDW(k, k1, k2) }

// KMOVB: Move 8-bit Mask.
//
// Forms:
//
//	KMOVB k   k
//	KMOVB k   m8
//	KMOVB k   r32
//	KMOVB m8  k
//	KMOVB r32 k
//
// Construct and append a KMOVB instruction to the active function.
func (c *Context) KMOVB(kmr, kmr1 operand.Op) {
	c.addinstruction(x86.KMOVB(kmr, kmr1))
}

// KMOVB: Move 8-bit Mask.
//
// Forms:
//
//	KMOVB k   k
//	KMOVB k   m8
//	KMOVB k   r32
//	KMOVB m8  k
//	KMOVB r32 k
//
// Construct and append a KMOVB instruction to the active function.
// Operates on the global context.
func KMOVB(kmr, kmr1 operand.Op) { ctx.KMOVB(kmr, kmr1) }

// KMOVD: Move 32-bit Mask.
//
// Forms:
//
//	KMOVD k   k
//	KMOVD k   m32
//	KMOVD k   r32
//	KMOVD m32 k
//	KMOVD r32 k
//
// Construct and append a KMOVD instruction to the active function.
func (c *Context) KMOVD(kmr, kmr1 operand.Op) {
	c.addinstruction(x86.KMOVD(kmr, kmr1))
}

// KMOVD: Move 32-bit Mask.
//
// Forms:
//
//	KMOVD k   k
//	KMOVD k   m32
//	KMOVD k   r32
//	KMOVD m32 k
//	KMOVD r32 k
//
// Construct and append a KMOVD instruction to the active function.
// Operates on the global context.
func KMOVD(kmr, kmr1 operand.Op) { ctx.KMOVD(kmr, kmr1) }

// KMOVQ: Move 64-bit Mask.
//
// Forms:
//
//	KMOVQ k   k
//	KMOVQ k   m64
//	KMOVQ k   r64
//	KMOVQ m64 k
//	KMOVQ r64 k
//
// Construct and append a KMOVQ instruction to the active function.
func (c *Context) KMOVQ(kmr, kmr1 operand.Op) {
	c.addinstruction(x86.KMOVQ(kmr, kmr1))
}

// KMOVQ: Move 64-bit Mask.
//
// Forms:
//
//	KMOVQ k   k
//	KMOVQ k   m64
//	KMOVQ k   r64
//	KMOVQ m64 k
//	KMOVQ r64 k
//
// Construct and append a KMOVQ instruction to the active function.
// Operates on the global context.
func KMOVQ(kmr, kmr1 operand.Op) { ctx.KMOVQ(kmr, kmr1) }

// KMOVW: Move 16-bit Mask.
//
// Forms:
//
//	KMOVW k   k
//	KMOVW k   m16
//	KMOVW k   r32
//	KMOVW m16 k
//	KMOVW r32 k
//
// Construct and append a KMOVW instruction to the active function.
func (c *Context) KMOVW(kmr, kmr1 operand.Op) {
	c.addinstruction(x86.KMOVW(kmr, kmr1))
}

// KMOVW: Move 16-bit Mask.
//
// Forms:
//
//	KMOVW k   k
//	KMOVW k   m16
//	KMOVW k   r32
//	KMOVW m16 k
//	KMOVW r32 k
//
// Construct and append a KMOVW instruction to the active function.
// Operates on the global context.
func KMOVW(kmr, kmr1 operand.Op) { ctx.KMOVW(kmr, kmr1) }

// KNOTB: NOT 8-bit Mask Register.
//
// Forms:
//
//	KNOTB k k
//
// Construct and append a KNOTB instruction to the active function.
func (c *Context) KNOTB(k, k1 operand.Op) {
	c.addinstruction(x86.KNOTB(k, k1))
}

// KNOTB: NOT 8-bit Mask Register.
//
// Forms:
//
//	KNOTB k k
//
// Construct and append a KNOTB instruction to the active function.
// Operates on the global context.
func KNOTB(k, k1 operand.Op) { ctx.KNOTB(k, k1) }

// KNOTD: NOT 32-bit Mask Register.
//
// Forms:
//
//	KNOTD k k
//
// Construct and append a KNOTD instruction to the active function.
func (c *Context) KNOTD(k, k1 operand.Op) {
	c.addinstruction(x86.KNOTD(k, k1))
}

// KNOTD: NOT 32-bit Mask Register.
//
// Forms:
//
//	KNOTD k k
//
// Construct and append a KNOTD instruction to the active function.
// Operates on the global context.
func KNOTD(k, k1 operand.Op) { ctx.KNOTD(k, k1) }

// KNOTQ: NOT 64-bit Mask Register.
//
// Forms:
//
//	KNOTQ k k
//
// Construct and append a KNOTQ instruction to the active function.
func (c *Context) KNOTQ(k, k1 operand.Op) {
	c.addinstruction(x86.KNOTQ(k, k1))
}

// KNOTQ: NOT 64-bit Mask Register.
//
// Forms:
//
//	KNOTQ k k
//
// Construct and append a KNOTQ instruction to the active function.
// Operates on the global context.
func KNOTQ(k, k1 operand.Op) { ctx.KNOTQ(k, k1) }

// KNOTW: NOT 16-bit Mask Register.
//
// Forms:
//
//	KNOTW k k
//
// Construct and append a KNOTW instruction to the active function.
func (c *Context) KNOTW(k, k1 operand.Op) {
	c.addinstruction(x86.KNOTW(k, k1))
}

// KNOTW: NOT 16-bit Mask Register.
//
// Forms:
//
//	KNOTW k k
//
// Construct and append a KNOTW instruction to the active function.
// Operates on the global context.
func KNOTW(k, k1 operand.Op) { ctx.KNOTW(k, k1) }

// KORB: Bitwise Logical OR 8-bit Masks.
//
// Forms:
//
//	KORB k k k
//
// Construct and append a KORB instruction to the active function.
func (c *Context) KORB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KORB(k, k1, k2))
}

// KORB: Bitwise Logical OR 8-bit Masks.
//
// Forms:
//
//	KORB k k k
//
// Construct and append a KORB instruction to the active function.
// Operates on the global context.
func KORB(k, k1, k2 operand.Op) { ctx.KORB(k, k1, k2) }

// KORD: Bitwise Logical OR 32-bit Masks.
//
// Forms:
//
//	KORD k k k
//
// Construct and append a KORD instruction to the active function.
func (c *Context) KORD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KORD(k, k1, k2))
}

// KORD: Bitwise Logical OR 32-bit Masks.
//
// Forms:
//
//	KORD k k k
//
// Construct and append a KORD instruction to the active function.
// Operates on the global context.
func KORD(k, k1, k2 operand.Op) { ctx.KORD(k, k1, k2) }

// KORQ: Bitwise Logical OR 64-bit Masks.
//
// Forms:
//
//	KORQ k k k
//
// Construct and append a KORQ instruction to the active function.
func (c *Context) KORQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KORQ(k, k1, k2))
}

// KORQ: Bitwise Logical OR 64-bit Masks.
//
// Forms:
//
//	KORQ k k k
//
// Construct and append a KORQ instruction to the active function.
// Operates on the global context.
func KORQ(k, k1, k2 operand.Op) { ctx.KORQ(k, k1, k2) }

// KORTESTB: OR 8-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTB k k
//
// Construct and append a KORTESTB instruction to the active function.
func (c *Context) KORTESTB(k, k1 operand.Op) {
	c.addinstruction(x86.KORTESTB(k, k1))
}

// KORTESTB: OR 8-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTB k k
//
// Construct and append a KORTESTB instruction to the active function.
// Operates on the global context.
func KORTESTB(k, k1 operand.Op) { ctx.KORTESTB(k, k1) }

// KORTESTD: OR 32-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTD k k
//
// Construct and append a KORTESTD instruction to the active function.
func (c *Context) KORTESTD(k, k1 operand.Op) {
	c.addinstruction(x86.KORTESTD(k, k1))
}

// KORTESTD: OR 32-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTD k k
//
// Construct and append a KORTESTD instruction to the active function.
// Operates on the global context.
func KORTESTD(k, k1 operand.Op) { ctx.KORTESTD(k, k1) }

// KORTESTQ: OR 64-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTQ k k
//
// Construct and append a KORTESTQ instruction to the active function.
func (c *Context) KORTESTQ(k, k1 operand.Op) {
	c.addinstruction(x86.KORTESTQ(k, k1))
}

// KORTESTQ: OR 64-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTQ k k
//
// Construct and append a KORTESTQ instruction to the active function.
// Operates on the global context.
func KORTESTQ(k, k1 operand.Op) { ctx.KORTESTQ(k, k1) }

// KORTESTW: OR 16-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTW k k
//
// Construct and append a KORTESTW instruction to the active function.
func (c *Context) KORTESTW(k, k1 operand.Op) {
	c.addinstruction(x86.KORTESTW(k, k1))
}

// KORTESTW: OR 16-bit Masks and Set Flags.
//
// Forms:
//
//	KORTESTW k k
//
// Construct and append a KORTESTW instruction to the active function.
// Operates on the global context.
func KORTESTW(k, k1 operand.Op) { ctx.KORTESTW(k, k1) }

// KORW: Bitwise Logical OR 16-bit Masks.
//
// Forms:
//
//	KORW k k k
//
// Construct and append a KORW instruction to the active function.
func (c *Context) KORW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KORW(k, k1, k2))
}

// KORW: Bitwise Logical OR 16-bit Masks.
//
// Forms:
//
//	KORW k k k
//
// Construct and append a KORW instruction to the active function.
// Operates on the global context.
func KORW(k, k1, k2 operand.Op) { ctx.KORW(k, k1, k2) }

// KSHIFTLB: Shift Left 8-bit Masks.
//
// Forms:
//
//	KSHIFTLB imm8 k k
//
// Construct and append a KSHIFTLB instruction to the active function.
func (c *Context) KSHIFTLB(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTLB(i, k, k1))
}

// KSHIFTLB: Shift Left 8-bit Masks.
//
// Forms:
//
//	KSHIFTLB imm8 k k
//
// Construct and append a KSHIFTLB instruction to the active function.
// Operates on the global context.
func KSHIFTLB(i, k, k1 operand.Op) { ctx.KSHIFTLB(i, k, k1) }

// KSHIFTLD: Shift Left 32-bit Masks.
//
// Forms:
//
//	KSHIFTLD imm8 k k
//
// Construct and append a KSHIFTLD instruction to the active function.
func (c *Context) KSHIFTLD(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTLD(i, k, k1))
}

// KSHIFTLD: Shift Left 32-bit Masks.
//
// Forms:
//
//	KSHIFTLD imm8 k k
//
// Construct and append a KSHIFTLD instruction to the active function.
// Operates on the global context.
func KSHIFTLD(i, k, k1 operand.Op) { ctx.KSHIFTLD(i, k, k1) }

// KSHIFTLQ: Shift Left 64-bit Masks.
//
// Forms:
//
//	KSHIFTLQ imm8 k k
//
// Construct and append a KSHIFTLQ instruction to the active function.
func (c *Context) KSHIFTLQ(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTLQ(i, k, k1))
}

// KSHIFTLQ: Shift Left 64-bit Masks.
//
// Forms:
//
//	KSHIFTLQ imm8 k k
//
// Construct and append a KSHIFTLQ instruction to the active function.
// Operates on the global context.
func KSHIFTLQ(i, k, k1 operand.Op) { ctx.KSHIFTLQ(i, k, k1) }

// KSHIFTLW: Shift Left 16-bit Masks.
//
// Forms:
//
//	KSHIFTLW imm8 k k
//
// Construct and append a KSHIFTLW instruction to the active function.
func (c *Context) KSHIFTLW(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTLW(i, k, k1))
}

// KSHIFTLW: Shift Left 16-bit Masks.
//
// Forms:
//
//	KSHIFTLW imm8 k k
//
// Construct and append a KSHIFTLW instruction to the active function.
// Operates on the global context.
func KSHIFTLW(i, k, k1 operand.Op) { ctx.KSHIFTLW(i, k, k1) }

// KSHIFTRB: Shift Right 8-bit Masks.
//
// Forms:
//
//	KSHIFTRB imm8 k k
//
// Construct and append a KSHIFTRB instruction to the active function.
func (c *Context) KSHIFTRB(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTRB(i, k, k1))
}

// KSHIFTRB: Shift Right 8-bit Masks.
//
// Forms:
//
//	KSHIFTRB imm8 k k
//
// Construct and append a KSHIFTRB instruction to the active function.
// Operates on the global context.
func KSHIFTRB(i, k, k1 operand.Op) { ctx.KSHIFTRB(i, k, k1) }

// KSHIFTRD: Shift Right 32-bit Masks.
//
// Forms:
//
//	KSHIFTRD imm8 k k
//
// Construct and append a KSHIFTRD instruction to the active function.
func (c *Context) KSHIFTRD(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTRD(i, k, k1))
}

// KSHIFTRD: Shift Right 32-bit Masks.
//
// Forms:
//
//	KSHIFTRD imm8 k k
//
// Construct and append a KSHIFTRD instruction to the active function.
// Operates on the global context.
func KSHIFTRD(i, k, k1 operand.Op) { ctx.KSHIFTRD(i, k, k1) }

// KSHIFTRQ: Shift Right 64-bit Masks.
//
// Forms:
//
//	KSHIFTRQ imm8 k k
//
// Construct and append a KSHIFTRQ instruction to the active function.
func (c *Context) KSHIFTRQ(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTRQ(i, k, k1))
}

// KSHIFTRQ: Shift Right 64-bit Masks.
//
// Forms:
//
//	KSHIFTRQ imm8 k k
//
// Construct and append a KSHIFTRQ instruction to the active function.
// Operates on the global context.
func KSHIFTRQ(i, k, k1 operand.Op) { ctx.KSHIFTRQ(i, k, k1) }

// KSHIFTRW: Shift Right 16-bit Masks.
//
// Forms:
//
//	KSHIFTRW imm8 k k
//
// Construct and append a KSHIFTRW instruction to the active function.
func (c *Context) KSHIFTRW(i, k, k1 operand.Op) {
	c.addinstruction(x86.KSHIFTRW(i, k, k1))
}

// KSHIFTRW: Shift Right 16-bit Masks.
//
// Forms:
//
//	KSHIFTRW imm8 k k
//
// Construct and append a KSHIFTRW instruction to the active function.
// Operates on the global context.
func KSHIFTRW(i, k, k1 operand.Op) { ctx.KSHIFTRW(i, k, k1) }

// KTESTB: Bit Test 8-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTB k k
//
// Construct and append a KTESTB instruction to the active function.
func (c *Context) KTESTB(k, k1 operand.Op) {
	c.addinstruction(x86.KTESTB(k, k1))
}

// KTESTB: Bit Test 8-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTB k k
//
// Construct and append a KTESTB instruction to the active function.
// Operates on the global context.
func KTESTB(k, k1 operand.Op) { ctx.KTESTB(k, k1) }

// KTESTD: Bit Test 32-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTD k k
//
// Construct and append a KTESTD instruction to the active function.
func (c *Context) KTESTD(k, k1 operand.Op) {
	c.addinstruction(x86.KTESTD(k, k1))
}

// KTESTD: Bit Test 32-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTD k k
//
// Construct and append a KTESTD instruction to the active function.
// Operates on the global context.
func KTESTD(k, k1 operand.Op) { ctx.KTESTD(k, k1) }

// KTESTQ: Bit Test 64-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTQ k k
//
// Construct and append a KTESTQ instruction to the active function.
func (c *Context) KTESTQ(k, k1 operand.Op) {
	c.addinstruction(x86.KTESTQ(k, k1))
}

// KTESTQ: Bit Test 64-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTQ k k
//
// Construct and append a KTESTQ instruction to the active function.
// Operates on the global context.
func KTESTQ(k, k1 operand.Op) { ctx.KTESTQ(k, k1) }

// KTESTW: Bit Test 16-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTW k k
//
// Construct and append a KTESTW instruction to the active function.
func (c *Context) KTESTW(k, k1 operand.Op) {
	c.addinstruction(x86.KTESTW(k, k1))
}

// KTESTW: Bit Test 16-bit Masks and Set Flags.
//
// Forms:
//
//	KTESTW k k
//
// Construct and append a KTESTW instruction to the active function.
// Operates on the global context.
func KTESTW(k, k1 operand.Op) { ctx.KTESTW(k, k1) }

// KUNPCKBW: Unpack and Interleave 8-bit Masks.
//
// Forms:
//
//	KUNPCKBW k k k
//
// Construct and append a KUNPCKBW instruction to the active function.
func (c *Context) KUNPCKBW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KUNPCKBW(k, k1, k2))
}

// KUNPCKBW: Unpack and Interleave 8-bit Masks.
//
// Forms:
//
//	KUNPCKBW k k k
//
// Construct and append a KUNPCKBW instruction to the active function.
// Operates on the global context.
func KUNPCKBW(k, k1, k2 operand.Op) { ctx.KUNPCKBW(k, k1, k2) }

// KUNPCKDQ: Unpack and Interleave 32-bit Masks.
//
// Forms:
//
//	KUNPCKDQ k k k
//
// Construct and append a KUNPCKDQ instruction to the active function.
func (c *Context) KUNPCKDQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KUNPCKDQ(k, k1, k2))
}

// KUNPCKDQ: Unpack and Interleave 32-bit Masks.
//
// Forms:
//
//	KUNPCKDQ k k k
//
// Construct and append a KUNPCKDQ instruction to the active function.
// Operates on the global context.
func KUNPCKDQ(k, k1, k2 operand.Op) { ctx.KUNPCKDQ(k, k1, k2) }

// KUNPCKWD: Unpack and Interleave 16-bit Masks.
//
// Forms:
//
//	KUNPCKWD k k k
//
// Construct and append a KUNPCKWD instruction to the active function.
func (c *Context) KUNPCKWD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KUNPCKWD(k, k1, k2))
}

// KUNPCKWD: Unpack and Interleave 16-bit Masks.
//
// Forms:
//
//	KUNPCKWD k k k
//
// Construct and append a KUNPCKWD instruction to the active function.
// Operates on the global context.
func KUNPCKWD(k, k1, k2 operand.Op) { ctx.KUNPCKWD(k, k1, k2) }

// KXNORB: Bitwise Logical XNOR 8-bit Masks.
//
// Forms:
//
//	KXNORB k k k
//
// Construct and append a KXNORB instruction to the active function.
func (c *Context) KXNORB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXNORB(k, k1, k2))
}

// KXNORB: Bitwise Logical XNOR 8-bit Masks.
//
// Forms:
//
//	KXNORB k k k
//
// Construct and append a KXNORB instruction to the active function.
// Operates on the global context.
func KXNORB(k, k1, k2 operand.Op) { ctx.KXNORB(k, k1, k2) }

// KXNORD: Bitwise Logical XNOR 32-bit Masks.
//
// Forms:
//
//	KXNORD k k k
//
// Construct and append a KXNORD instruction to the active function.
func (c *Context) KXNORD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXNORD(k, k1, k2))
}

// KXNORD: Bitwise Logical XNOR 32-bit Masks.
//
// Forms:
//
//	KXNORD k k k
//
// Construct and append a KXNORD instruction to the active function.
// Operates on the global context.
func KXNORD(k, k1, k2 operand.Op) { ctx.KXNORD(k, k1, k2) }

// KXNORQ: Bitwise Logical XNOR 64-bit Masks.
//
// Forms:
//
//	KXNORQ k k k
//
// Construct and append a KXNORQ instruction to the active function.
func (c *Context) KXNORQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXNORQ(k, k1, k2))
}

// KXNORQ: Bitwise Logical XNOR 64-bit Masks.
//
// Forms:
//
//	KXNORQ k k k
//
// Construct and append a KXNORQ instruction to the active function.
// Operates on the global context.
func KXNORQ(k, k1, k2 operand.Op) { ctx.KXNORQ(k, k1, k2) }

// KXNORW: Bitwise Logical XNOR 16-bit Masks.
//
// Forms:
//
//	KXNORW k k k
//
// Construct and append a KXNORW instruction to the active function.
func (c *Context) KXNORW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXNORW(k, k1, k2))
}

// KXNORW: Bitwise Logical XNOR 16-bit Masks.
//
// Forms:
//
//	KXNORW k k k
//
// Construct and append a KXNORW instruction to the active function.
// Operates on the global context.
func KXNORW(k, k1, k2 operand.Op) { ctx.KXNORW(k, k1, k2) }

// KXORB: Bitwise Logical XOR 8-bit Masks.
//
// Forms:
//
//	KXORB k k k
//
// Construct and append a KXORB instruction to the active function.
func (c *Context) KXORB(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXORB(k, k1, k2))
}

// KXORB: Bitwise Logical XOR 8-bit Masks.
//
// Forms:
//
//	KXORB k k k
//
// Construct and append a KXORB instruction to the active function.
// Operates on the global context.
func KXORB(k, k1, k2 operand.Op) { ctx.KXORB(k, k1, k2) }

// KXORD: Bitwise Logical XOR 32-bit Masks.
//
// Forms:
//
//	KXORD k k k
//
// Construct and append a KXORD instruction to the active function.
func (c *Context) KXORD(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXORD(k, k1, k2))
}

// KXORD: Bitwise Logical XOR 32-bit Masks.
//
// Forms:
//
//	KXORD k k k
//
// Construct and append a KXORD instruction to the active function.
// Operates on the global context.
func KXORD(k, k1, k2 operand.Op) { ctx.KXORD(k, k1, k2) }

// KXORQ: Bitwise Logical XOR 64-bit Masks.
//
// Forms:
//
//	KXORQ k k k
//
// Construct and append a KXORQ instruction to the active function.
func (c *Context) KXORQ(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXORQ(k, k1, k2))
}

// KXORQ: Bitwise Logical XOR 64-bit Masks.
//
// Forms:
//
//	KXORQ k k k
//
// Construct and append a KXORQ instruction to the active function.
// Operates on the global context.
func KXORQ(k, k1, k2 operand.Op) { ctx.KXORQ(k, k1, k2) }

// KXORW: Bitwise Logical XOR 16-bit Masks.
//
// Forms:
//
//	KXORW k k k
//
// Construct and append a KXORW instruction to the active function.
func (c *Context) KXORW(k, k1, k2 operand.Op) {
	c.addinstruction(x86.KXORW(k, k1, k2))
}

// KXORW: Bitwise Logical XOR 16-bit Masks.
//
// Forms:
//
//	KXORW k k k
//
// Construct and append a KXORW instruction to the active function.
// Operates on the global context.
func KXORW(k, k1, k2 operand.Op) { ctx.KXORW(k, k1, k2) }

// LDDQU: Load Unaligned Integer 128 Bits.
//
// Forms:
//
//	LDDQU m128 xmm
//
// Construct and append a LDDQU instruction to the active function.
func (c *Context) LDDQU(m, x operand.Op) {
	c.addinstruction(x86.LDDQU(m, x))
}

// LDDQU: Load Unaligned Integer 128 Bits.
//
// Forms:
//
//	LDDQU m128 xmm
//
// Construct and append a LDDQU instruction to the active function.
// Operates on the global context.
func LDDQU(m, x operand.Op) { ctx.LDDQU(m, x) }

// LDMXCSR: Load MXCSR Register.
//
// Forms:
//
//	LDMXCSR m32
//
// Construct and append a LDMXCSR instruction to the active function.
func (c *Context) LDMXCSR(m operand.Op) {
	c.addinstruction(x86.LDMXCSR(m))
}

// LDMXCSR: Load MXCSR Register.
//
// Forms:
//
//	LDMXCSR m32
//
// Construct and append a LDMXCSR instruction to the active function.
// Operates on the global context.
func LDMXCSR(m operand.Op) { ctx.LDMXCSR(m) }

// LEAL: Load Effective Address.
//
// Forms:
//
//	LEAL m r32
//
// Construct and append a LEAL instruction to the active function.
func (c *Context) LEAL(m, r operand.Op) {
	c.addinstruction(x86.LEAL(m, r))
}

// LEAL: Load Effective Address.
//
// Forms:
//
//	LEAL m r32
//
// Construct and append a LEAL instruction to the active function.
// Operates on the global context.
func LEAL(m, r operand.Op) { ctx.LEAL(m, r) }

// LEAQ: Load Effective Address.
//
// Forms:
//
//	LEAQ m r64
//
// Construct and append a LEAQ instruction to the active function.
func (c *Context) LEAQ(m, r operand.Op) {
	c.addinstruction(x86.LEAQ(m, r))
}

// LEAQ: Load Effective Address.
//
// Forms:
//
//	LEAQ m r64
//
// Construct and append a LEAQ instruction to the active function.
// Operates on the global context.
func LEAQ(m, r operand.Op) { ctx.LEAQ(m, r) }

// LEAW: Load Effective Address.
//
// Forms:
//
//	LEAW m r16
//
// Construct and append a LEAW instruction to the active function.
func (c *Context) LEAW(m, r operand.Op) {
	c.addinstruction(x86.LEAW(m, r))
}

// LEAW: Load Effective Address.
//
// Forms:
//
//	LEAW m r16
//
// Construct and append a LEAW instruction to the active function.
// Operates on the global context.
func LEAW(m, r operand.Op) { ctx.LEAW(m, r) }

// LFENCE: Load Fence.
//
// Forms:
//
//	LFENCE
//
// Construct and append a LFENCE instruction to the active function.
func (c *Context) LFENCE() {
	c.addinstruction(x86.LFENCE())
}

// LFENCE: Load Fence.
//
// Forms:
//
//	LFENCE
//
// Construct and append a LFENCE instruction to the active function.
// Operates on the global context.
func LFENCE() { ctx.LFENCE() }

// LZCNTL: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTL m32 r32
//	LZCNTL r32 r32
//
// Construct and append a LZCNTL instruction to the active function.
func (c *Context) LZCNTL(mr, r operand.Op) {
	c.addinstruction(x86.LZCNTL(mr, r))
}

// LZCNTL: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTL m32 r32
//	LZCNTL r32 r32
//
// Construct and append a LZCNTL instruction to the active function.
// Operates on the global context.
func LZCNTL(mr, r operand.Op) { ctx.LZCNTL(mr, r) }

// LZCNTQ: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTQ m64 r64
//	LZCNTQ r64 r64
//
// Construct and append a LZCNTQ instruction to the active function.
func (c *Context) LZCNTQ(mr, r operand.Op) {
	c.addinstruction(x86.LZCNTQ(mr, r))
}

// LZCNTQ: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTQ m64 r64
//	LZCNTQ r64 r64
//
// Construct and append a LZCNTQ instruction to the active function.
// Operates on the global context.
func LZCNTQ(mr, r operand.Op) { ctx.LZCNTQ(mr, r) }

// LZCNTW: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTW m16 r16
//	LZCNTW r16 r16
//
// Construct and append a LZCNTW instruction to the active function.
func (c *Context) LZCNTW(mr, r operand.Op) {
	c.addinstruction(x86.LZCNTW(mr, r))
}

// LZCNTW: Count the Number of Leading Zero Bits.
//
// Forms:
//
//	LZCNTW m16 r16
//	LZCNTW r16 r16
//
// Construct and append a LZCNTW instruction to the active function.
// Operates on the global context.
func LZCNTW(mr, r operand.Op) { ctx.LZCNTW(mr, r) }

// MASKMOVDQU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVDQU xmm xmm
//
// Construct and append a MASKMOVDQU instruction to the active function.
func (c *Context) MASKMOVDQU(x, x1 operand.Op) {
	c.addinstruction(x86.MASKMOVDQU(x, x1))
}

// MASKMOVDQU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVDQU xmm xmm
//
// Construct and append a MASKMOVDQU instruction to the active function.
// Operates on the global context.
func MASKMOVDQU(x, x1 operand.Op) { ctx.MASKMOVDQU(x, x1) }

// MASKMOVOU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVOU xmm xmm
//
// Construct and append a MASKMOVOU instruction to the active function.
func (c *Context) MASKMOVOU(x, x1 operand.Op) {
	c.addinstruction(x86.MASKMOVOU(x, x1))
}

// MASKMOVOU: Store Selected Bytes of Double Quadword.
//
// Forms:
//
//	MASKMOVOU xmm xmm
//
// Construct and append a MASKMOVOU instruction to the active function.
// Operates on the global context.
func MASKMOVOU(x, x1 operand.Op) { ctx.MASKMOVOU(x, x1) }

// MAXPD: Return Maximum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPD m128 xmm
//	MAXPD xmm  xmm
//
// Construct and append a MAXPD instruction to the active function.
func (c *Context) MAXPD(mx, x operand.Op) {
	c.addinstruction(x86.MAXPD(mx, x))
}

// MAXPD: Return Maximum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPD m128 xmm
//	MAXPD xmm  xmm
//
// Construct and append a MAXPD instruction to the active function.
// Operates on the global context.
func MAXPD(mx, x operand.Op) { ctx.MAXPD(mx, x) }

// MAXPS: Return Maximum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPS m128 xmm
//	MAXPS xmm  xmm
//
// Construct and append a MAXPS instruction to the active function.
func (c *Context) MAXPS(mx, x operand.Op) {
	c.addinstruction(x86.MAXPS(mx, x))
}

// MAXPS: Return Maximum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MAXPS m128 xmm
//	MAXPS xmm  xmm
//
// Construct and append a MAXPS instruction to the active function.
// Operates on the global context.
func MAXPS(mx, x operand.Op) { ctx.MAXPS(mx, x) }

// MAXSD: Return Maximum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSD m64 xmm
//	MAXSD xmm xmm
//
// Construct and append a MAXSD instruction to the active function.
func (c *Context) MAXSD(mx, x operand.Op) {
	c.addinstruction(x86.MAXSD(mx, x))
}

// MAXSD: Return Maximum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSD m64 xmm
//	MAXSD xmm xmm
//
// Construct and append a MAXSD instruction to the active function.
// Operates on the global context.
func MAXSD(mx, x operand.Op) { ctx.MAXSD(mx, x) }

// MAXSS: Return Maximum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSS m32 xmm
//	MAXSS xmm xmm
//
// Construct and append a MAXSS instruction to the active function.
func (c *Context) MAXSS(mx, x operand.Op) {
	c.addinstruction(x86.MAXSS(mx, x))
}

// MAXSS: Return Maximum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MAXSS m32 xmm
//	MAXSS xmm xmm
//
// Construct and append a MAXSS instruction to the active function.
// Operates on the global context.
func MAXSS(mx, x operand.Op) { ctx.MAXSS(mx, x) }

// MFENCE: Memory Fence.
//
// Forms:
//
//	MFENCE
//
// Construct and append a MFENCE instruction to the active function.
func (c *Context) MFENCE() {
	c.addinstruction(x86.MFENCE())
}

// MFENCE: Memory Fence.
//
// Forms:
//
//	MFENCE
//
// Construct and append a MFENCE instruction to the active function.
// Operates on the global context.
func MFENCE() { ctx.MFENCE() }

// MINPD: Return Minimum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MINPD m128 xmm
//	MINPD xmm  xmm
//
// Construct and append a MINPD instruction to the active function.
func (c *Context) MINPD(mx, x operand.Op) {
	c.addinstruction(x86.MINPD(mx, x))
}

// MINPD: Return Minimum Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MINPD m128 xmm
//	MINPD xmm  xmm
//
// Construct and append a MINPD instruction to the active function.
// Operates on the global context.
func MINPD(mx, x operand.Op) { ctx.MINPD(mx, x) }

// MINPS: Return Minimum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MINPS m128 xmm
//	MINPS xmm  xmm
//
// Construct and append a MINPS instruction to the active function.
func (c *Context) MINPS(mx, x operand.Op) {
	c.addinstruction(x86.MINPS(mx, x))
}

// MINPS: Return Minimum Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MINPS m128 xmm
//	MINPS xmm  xmm
//
// Construct and append a MINPS instruction to the active function.
// Operates on the global context.
func MINPS(mx, x operand.Op) { ctx.MINPS(mx, x) }

// MINSD: Return Minimum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MINSD m64 xmm
//	MINSD xmm xmm
//
// Construct and append a MINSD instruction to the active function.
func (c *Context) MINSD(mx, x operand.Op) {
	c.addinstruction(x86.MINSD(mx, x))
}

// MINSD: Return Minimum Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MINSD m64 xmm
//	MINSD xmm xmm
//
// Construct and append a MINSD instruction to the active function.
// Operates on the global context.
func MINSD(mx, x operand.Op) { ctx.MINSD(mx, x) }

// MINSS: Return Minimum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MINSS m32 xmm
//	MINSS xmm xmm
//
// Construct and append a MINSS instruction to the active function.
func (c *Context) MINSS(mx, x operand.Op) {
	c.addinstruction(x86.MINSS(mx, x))
}

// MINSS: Return Minimum Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	MINSS m32 xmm
//	MINSS xmm xmm
//
// Construct and append a MINSS instruction to the active function.
// Operates on the global context.
func MINSS(mx, x operand.Op) { ctx.MINSS(mx, x) }

// MONITOR: Monitor a Linear Address Range.
//
// Forms:
//
//	MONITOR
//
// Construct and append a MONITOR instruction to the active function.
func (c *Context) MONITOR() {
	c.addinstruction(x86.MONITOR())
}

// MONITOR: Monitor a Linear Address Range.
//
// Forms:
//
//	MONITOR
//
// Construct and append a MONITOR instruction to the active function.
// Operates on the global context.
func MONITOR() { ctx.MONITOR() }

// MOVAPD: Move Aligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPD m128 xmm
//	MOVAPD xmm  m128
//	MOVAPD xmm  xmm
//
// Construct and append a MOVAPD instruction to the active function.
func (c *Context) MOVAPD(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVAPD(mx, mx1))
}

// MOVAPD: Move Aligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPD m128 xmm
//	MOVAPD xmm  m128
//	MOVAPD xmm  xmm
//
// Construct and append a MOVAPD instruction to the active function.
// Operates on the global context.
func MOVAPD(mx, mx1 operand.Op) { ctx.MOVAPD(mx, mx1) }

// MOVAPS: Move Aligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPS m128 xmm
//	MOVAPS xmm  m128
//	MOVAPS xmm  xmm
//
// Construct and append a MOVAPS instruction to the active function.
func (c *Context) MOVAPS(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVAPS(mx, mx1))
}

// MOVAPS: Move Aligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVAPS m128 xmm
//	MOVAPS xmm  m128
//	MOVAPS xmm  xmm
//
// Construct and append a MOVAPS instruction to the active function.
// Operates on the global context.
func MOVAPS(mx, mx1 operand.Op) { ctx.MOVAPS(mx, mx1) }

// MOVB: Move.
//
// Forms:
//
//	MOVB imm8 m8
//	MOVB imm8 r8
//	MOVB m8   r8
//	MOVB r8   m8
//	MOVB r8   r8
//
// Construct and append a MOVB instruction to the active function.
func (c *Context) MOVB(imr, mr operand.Op) {
	c.addinstruction(x86.MOVB(imr, mr))
}

// MOVB: Move.
//
// Forms:
//
//	MOVB imm8 m8
//	MOVB imm8 r8
//	MOVB m8   r8
//	MOVB r8   m8
//	MOVB r8   r8
//
// Construct and append a MOVB instruction to the active function.
// Operates on the global context.
func MOVB(imr, mr operand.Op) { ctx.MOVB(imr, mr) }

// MOVBELL: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBELL m32 r32
//	MOVBELL r32 m32
//
// Construct and append a MOVBELL instruction to the active function.
func (c *Context) MOVBELL(mr, mr1 operand.Op) {
	c.addinstruction(x86.MOVBELL(mr, mr1))
}

// MOVBELL: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBELL m32 r32
//	MOVBELL r32 m32
//
// Construct and append a MOVBELL instruction to the active function.
// Operates on the global context.
func MOVBELL(mr, mr1 operand.Op) { ctx.MOVBELL(mr, mr1) }

// MOVBEQQ: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEQQ m64 r64
//	MOVBEQQ r64 m64
//
// Construct and append a MOVBEQQ instruction to the active function.
func (c *Context) MOVBEQQ(mr, mr1 operand.Op) {
	c.addinstruction(x86.MOVBEQQ(mr, mr1))
}

// MOVBEQQ: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEQQ m64 r64
//	MOVBEQQ r64 m64
//
// Construct and append a MOVBEQQ instruction to the active function.
// Operates on the global context.
func MOVBEQQ(mr, mr1 operand.Op) { ctx.MOVBEQQ(mr, mr1) }

// MOVBEWW: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEWW m16 r16
//	MOVBEWW r16 m16
//
// Construct and append a MOVBEWW instruction to the active function.
func (c *Context) MOVBEWW(mr, mr1 operand.Op) {
	c.addinstruction(x86.MOVBEWW(mr, mr1))
}

// MOVBEWW: Move Data After Swapping Bytes.
//
// Forms:
//
//	MOVBEWW m16 r16
//	MOVBEWW r16 m16
//
// Construct and append a MOVBEWW instruction to the active function.
// Operates on the global context.
func MOVBEWW(mr, mr1 operand.Op) { ctx.MOVBEWW(mr, mr1) }

// MOVBLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBLSX m8 r32
//	MOVBLSX r8 r32
//
// Construct and append a MOVBLSX instruction to the active function.
func (c *Context) MOVBLSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBLSX(mr, r))
}

// MOVBLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBLSX m8 r32
//	MOVBLSX r8 r32
//
// Construct and append a MOVBLSX instruction to the active function.
// Operates on the global context.
func MOVBLSX(mr, r operand.Op) { ctx.MOVBLSX(mr, r) }

// MOVBLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBLZX m8 r32
//	MOVBLZX r8 r32
//
// Construct and append a MOVBLZX instruction to the active function.
func (c *Context) MOVBLZX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBLZX(mr, r))
}

// MOVBLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBLZX m8 r32
//	MOVBLZX r8 r32
//
// Construct and append a MOVBLZX instruction to the active function.
// Operates on the global context.
func MOVBLZX(mr, r operand.Op) { ctx.MOVBLZX(mr, r) }

// MOVBQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBQSX m8 r64
//	MOVBQSX r8 r64
//
// Construct and append a MOVBQSX instruction to the active function.
func (c *Context) MOVBQSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBQSX(mr, r))
}

// MOVBQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBQSX m8 r64
//	MOVBQSX r8 r64
//
// Construct and append a MOVBQSX instruction to the active function.
// Operates on the global context.
func MOVBQSX(mr, r operand.Op) { ctx.MOVBQSX(mr, r) }

// MOVBQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBQZX m8 r64
//	MOVBQZX r8 r64
//
// Construct and append a MOVBQZX instruction to the active function.
func (c *Context) MOVBQZX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBQZX(mr, r))
}

// MOVBQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBQZX m8 r64
//	MOVBQZX r8 r64
//
// Construct and append a MOVBQZX instruction to the active function.
// Operates on the global context.
func MOVBQZX(mr, r operand.Op) { ctx.MOVBQZX(mr, r) }

// MOVBWSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBWSX m8 r16
//	MOVBWSX r8 r16
//
// Construct and append a MOVBWSX instruction to the active function.
func (c *Context) MOVBWSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBWSX(mr, r))
}

// MOVBWSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVBWSX m8 r16
//	MOVBWSX r8 r16
//
// Construct and append a MOVBWSX instruction to the active function.
// Operates on the global context.
func MOVBWSX(mr, r operand.Op) { ctx.MOVBWSX(mr, r) }

// MOVBWZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBWZX m8 r16
//	MOVBWZX r8 r16
//
// Construct and append a MOVBWZX instruction to the active function.
func (c *Context) MOVBWZX(mr, r operand.Op) {
	c.addinstruction(x86.MOVBWZX(mr, r))
}

// MOVBWZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVBWZX m8 r16
//	MOVBWZX r8 r16
//
// Construct and append a MOVBWZX instruction to the active function.
// Operates on the global context.
func MOVBWZX(mr, r operand.Op) { ctx.MOVBWZX(mr, r) }

// MOVD: Move.
//
// Forms:
//
//	MOVD m32   xmm
//	MOVD m64   xmm
//	MOVD r32   xmm
//	MOVD r64   xmm
//	MOVD xmm   m32
//	MOVD xmm   m64
//	MOVD xmm   r32
//	MOVD xmm   r64
//	MOVD xmm   xmm
//	MOVD imm32 m64
//	MOVD imm32 r64
//	MOVD imm64 r64
//	MOVD m64   r64
//	MOVD r64   m64
//	MOVD r64   r64
//
// Construct and append a MOVD instruction to the active function.
func (c *Context) MOVD(imrx, mrx operand.Op) {
	c.addinstruction(x86.MOVD(imrx, mrx))
}

// MOVD: Move.
//
// Forms:
//
//	MOVD m32   xmm
//	MOVD m64   xmm
//	MOVD r32   xmm
//	MOVD r64   xmm
//	MOVD xmm   m32
//	MOVD xmm   m64
//	MOVD xmm   r32
//	MOVD xmm   r64
//	MOVD xmm   xmm
//	MOVD imm32 m64
//	MOVD imm32 r64
//	MOVD imm64 r64
//	MOVD m64   r64
//	MOVD r64   m64
//	MOVD r64   r64
//
// Construct and append a MOVD instruction to the active function.
// Operates on the global context.
func MOVD(imrx, mrx operand.Op) { ctx.MOVD(imrx, mrx) }

// MOVDDUP: Move One Double-FP and Duplicate.
//
// Forms:
//
//	MOVDDUP m64 xmm
//	MOVDDUP xmm xmm
//
// Construct and append a MOVDDUP instruction to the active function.
func (c *Context) MOVDDUP(mx, x operand.Op) {
	c.addinstruction(x86.MOVDDUP(mx, x))
}

// MOVDDUP: Move One Double-FP and Duplicate.
//
// Forms:
//
//	MOVDDUP m64 xmm
//	MOVDDUP xmm xmm
//
// Construct and append a MOVDDUP instruction to the active function.
// Operates on the global context.
func MOVDDUP(mx, x operand.Op) { ctx.MOVDDUP(mx, x) }

// MOVDQ2Q: Move.
//
// Forms:
//
//	MOVDQ2Q m32   xmm
//	MOVDQ2Q m64   xmm
//	MOVDQ2Q r32   xmm
//	MOVDQ2Q r64   xmm
//	MOVDQ2Q xmm   m32
//	MOVDQ2Q xmm   m64
//	MOVDQ2Q xmm   r32
//	MOVDQ2Q xmm   r64
//	MOVDQ2Q xmm   xmm
//	MOVDQ2Q imm32 m64
//	MOVDQ2Q imm32 r64
//	MOVDQ2Q imm64 r64
//	MOVDQ2Q m64   r64
//	MOVDQ2Q r64   m64
//	MOVDQ2Q r64   r64
//
// Construct and append a MOVDQ2Q instruction to the active function.
func (c *Context) MOVDQ2Q(imrx, mrx operand.Op) {
	c.addinstruction(x86.MOVDQ2Q(imrx, mrx))
}

// MOVDQ2Q: Move.
//
// Forms:
//
//	MOVDQ2Q m32   xmm
//	MOVDQ2Q m64   xmm
//	MOVDQ2Q r32   xmm
//	MOVDQ2Q r64   xmm
//	MOVDQ2Q xmm   m32
//	MOVDQ2Q xmm   m64
//	MOVDQ2Q xmm   r32
//	MOVDQ2Q xmm   r64
//	MOVDQ2Q xmm   xmm
//	MOVDQ2Q imm32 m64
//	MOVDQ2Q imm32 r64
//	MOVDQ2Q imm64 r64
//	MOVDQ2Q m64   r64
//	MOVDQ2Q r64   m64
//	MOVDQ2Q r64   r64
//
// Construct and append a MOVDQ2Q instruction to the active function.
// Operates on the global context.
func MOVDQ2Q(imrx, mrx operand.Op) { ctx.MOVDQ2Q(imrx, mrx) }

// MOVHLPS: Move Packed Single-Precision Floating-Point Values High to Low.
//
// Forms:
//
//	MOVHLPS xmm xmm
//
// Construct and append a MOVHLPS instruction to the active function.
func (c *Context) MOVHLPS(x, x1 operand.Op) {
	c.addinstruction(x86.MOVHLPS(x, x1))
}

// MOVHLPS: Move Packed Single-Precision Floating-Point Values High to Low.
//
// Forms:
//
//	MOVHLPS xmm xmm
//
// Construct and append a MOVHLPS instruction to the active function.
// Operates on the global context.
func MOVHLPS(x, x1 operand.Op) { ctx.MOVHLPS(x, x1) }

// MOVHPD: Move High Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVHPD m64 xmm
//	MOVHPD xmm m64
//
// Construct and append a MOVHPD instruction to the active function.
func (c *Context) MOVHPD(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVHPD(mx, mx1))
}

// MOVHPD: Move High Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVHPD m64 xmm
//	MOVHPD xmm m64
//
// Construct and append a MOVHPD instruction to the active function.
// Operates on the global context.
func MOVHPD(mx, mx1 operand.Op) { ctx.MOVHPD(mx, mx1) }

// MOVHPS: Move High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVHPS m64 xmm
//	MOVHPS xmm m64
//
// Construct and append a MOVHPS instruction to the active function.
func (c *Context) MOVHPS(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVHPS(mx, mx1))
}

// MOVHPS: Move High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVHPS m64 xmm
//	MOVHPS xmm m64
//
// Construct and append a MOVHPS instruction to the active function.
// Operates on the global context.
func MOVHPS(mx, mx1 operand.Op) { ctx.MOVHPS(mx, mx1) }

// MOVL: Move.
//
// Forms:
//
//	MOVL imm32 m32
//	MOVL imm32 r32
//	MOVL m32   r32
//	MOVL r32   m32
//	MOVL r32   r32
//
// Construct and append a MOVL instruction to the active function.
func (c *Context) MOVL(imr, mr operand.Op) {
	c.addinstruction(x86.MOVL(imr, mr))
}

// MOVL: Move.
//
// Forms:
//
//	MOVL imm32 m32
//	MOVL imm32 r32
//	MOVL m32   r32
//	MOVL r32   m32
//	MOVL r32   r32
//
// Construct and append a MOVL instruction to the active function.
// Operates on the global context.
func MOVL(imr, mr operand.Op) { ctx.MOVL(imr, mr) }

// MOVLHPS: Move Packed Single-Precision Floating-Point Values Low to High.
//
// Forms:
//
//	MOVLHPS xmm xmm
//
// Construct and append a MOVLHPS instruction to the active function.
func (c *Context) MOVLHPS(x, x1 operand.Op) {
	c.addinstruction(x86.MOVLHPS(x, x1))
}

// MOVLHPS: Move Packed Single-Precision Floating-Point Values Low to High.
//
// Forms:
//
//	MOVLHPS xmm xmm
//
// Construct and append a MOVLHPS instruction to the active function.
// Operates on the global context.
func MOVLHPS(x, x1 operand.Op) { ctx.MOVLHPS(x, x1) }

// MOVLPD: Move Low Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVLPD m64 xmm
//	MOVLPD xmm m64
//
// Construct and append a MOVLPD instruction to the active function.
func (c *Context) MOVLPD(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVLPD(mx, mx1))
}

// MOVLPD: Move Low Packed Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVLPD m64 xmm
//	MOVLPD xmm m64
//
// Construct and append a MOVLPD instruction to the active function.
// Operates on the global context.
func MOVLPD(mx, mx1 operand.Op) { ctx.MOVLPD(mx, mx1) }

// MOVLPS: Move Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVLPS m64 xmm
//	MOVLPS xmm m64
//
// Construct and append a MOVLPS instruction to the active function.
func (c *Context) MOVLPS(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVLPS(mx, mx1))
}

// MOVLPS: Move Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVLPS m64 xmm
//	MOVLPS xmm m64
//
// Construct and append a MOVLPS instruction to the active function.
// Operates on the global context.
func MOVLPS(mx, mx1 operand.Op) { ctx.MOVLPS(mx, mx1) }

// MOVLQSX: Move Doubleword to Quadword with Sign-Extension.
//
// Forms:
//
//	MOVLQSX m32 r64
//	MOVLQSX r32 r64
//
// Construct and append a MOVLQSX instruction to the active function.
func (c *Context) MOVLQSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVLQSX(mr, r))
}

// MOVLQSX: Move Doubleword to Quadword with Sign-Extension.
//
// Forms:
//
//	MOVLQSX m32 r64
//	MOVLQSX r32 r64
//
// Construct and append a MOVLQSX instruction to the active function.
// Operates on the global context.
func MOVLQSX(mr, r operand.Op) { ctx.MOVLQSX(mr, r) }

// MOVLQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVLQZX m32 r64
//
// Construct and append a MOVLQZX instruction to the active function.
func (c *Context) MOVLQZX(m, r operand.Op) {
	c.addinstruction(x86.MOVLQZX(m, r))
}

// MOVLQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVLQZX m32 r64
//
// Construct and append a MOVLQZX instruction to the active function.
// Operates on the global context.
func MOVLQZX(m, r operand.Op) { ctx.MOVLQZX(m, r) }

// MOVMSKPD: Extract Packed Double-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPD xmm r32
//
// Construct and append a MOVMSKPD instruction to the active function.
func (c *Context) MOVMSKPD(x, r operand.Op) {
	c.addinstruction(x86.MOVMSKPD(x, r))
}

// MOVMSKPD: Extract Packed Double-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPD xmm r32
//
// Construct and append a MOVMSKPD instruction to the active function.
// Operates on the global context.
func MOVMSKPD(x, r operand.Op) { ctx.MOVMSKPD(x, r) }

// MOVMSKPS: Extract Packed Single-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPS xmm r32
//
// Construct and append a MOVMSKPS instruction to the active function.
func (c *Context) MOVMSKPS(x, r operand.Op) {
	c.addinstruction(x86.MOVMSKPS(x, r))
}

// MOVMSKPS: Extract Packed Single-Precision Floating-Point Sign Mask.
//
// Forms:
//
//	MOVMSKPS xmm r32
//
// Construct and append a MOVMSKPS instruction to the active function.
// Operates on the global context.
func MOVMSKPS(x, r operand.Op) { ctx.MOVMSKPS(x, r) }

// MOVNTDQ: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTDQ xmm m128
//
// Construct and append a MOVNTDQ instruction to the active function.
func (c *Context) MOVNTDQ(x, m operand.Op) {
	c.addinstruction(x86.MOVNTDQ(x, m))
}

// MOVNTDQ: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTDQ xmm m128
//
// Construct and append a MOVNTDQ instruction to the active function.
// Operates on the global context.
func MOVNTDQ(x, m operand.Op) { ctx.MOVNTDQ(x, m) }

// MOVNTDQA: Load Double Quadword Non-Temporal Aligned Hint.
//
// Forms:
//
//	MOVNTDQA m128 xmm
//
// Construct and append a MOVNTDQA instruction to the active function.
func (c *Context) MOVNTDQA(m, x operand.Op) {
	c.addinstruction(x86.MOVNTDQA(m, x))
}

// MOVNTDQA: Load Double Quadword Non-Temporal Aligned Hint.
//
// Forms:
//
//	MOVNTDQA m128 xmm
//
// Construct and append a MOVNTDQA instruction to the active function.
// Operates on the global context.
func MOVNTDQA(m, x operand.Op) { ctx.MOVNTDQA(m, x) }

// MOVNTIL: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIL r32 m32
//
// Construct and append a MOVNTIL instruction to the active function.
func (c *Context) MOVNTIL(r, m operand.Op) {
	c.addinstruction(x86.MOVNTIL(r, m))
}

// MOVNTIL: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIL r32 m32
//
// Construct and append a MOVNTIL instruction to the active function.
// Operates on the global context.
func MOVNTIL(r, m operand.Op) { ctx.MOVNTIL(r, m) }

// MOVNTIQ: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIQ r64 m64
//
// Construct and append a MOVNTIQ instruction to the active function.
func (c *Context) MOVNTIQ(r, m operand.Op) {
	c.addinstruction(x86.MOVNTIQ(r, m))
}

// MOVNTIQ: Store Doubleword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTIQ r64 m64
//
// Construct and append a MOVNTIQ instruction to the active function.
// Operates on the global context.
func MOVNTIQ(r, m operand.Op) { ctx.MOVNTIQ(r, m) }

// MOVNTO: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTO xmm m128
//
// Construct and append a MOVNTO instruction to the active function.
func (c *Context) MOVNTO(x, m operand.Op) {
	c.addinstruction(x86.MOVNTO(x, m))
}

// MOVNTO: Store Double Quadword Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTO xmm m128
//
// Construct and append a MOVNTO instruction to the active function.
// Operates on the global context.
func MOVNTO(x, m operand.Op) { ctx.MOVNTO(x, m) }

// MOVNTPD: Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPD xmm m128
//
// Construct and append a MOVNTPD instruction to the active function.
func (c *Context) MOVNTPD(x, m operand.Op) {
	c.addinstruction(x86.MOVNTPD(x, m))
}

// MOVNTPD: Store Packed Double-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPD xmm m128
//
// Construct and append a MOVNTPD instruction to the active function.
// Operates on the global context.
func MOVNTPD(x, m operand.Op) { ctx.MOVNTPD(x, m) }

// MOVNTPS: Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPS xmm m128
//
// Construct and append a MOVNTPS instruction to the active function.
func (c *Context) MOVNTPS(x, m operand.Op) {
	c.addinstruction(x86.MOVNTPS(x, m))
}

// MOVNTPS: Store Packed Single-Precision Floating-Point Values Using Non-Temporal Hint.
//
// Forms:
//
//	MOVNTPS xmm m128
//
// Construct and append a MOVNTPS instruction to the active function.
// Operates on the global context.
func MOVNTPS(x, m operand.Op) { ctx.MOVNTPS(x, m) }

// MOVO: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVO m128 xmm
//	MOVO xmm  m128
//	MOVO xmm  xmm
//
// Construct and append a MOVO instruction to the active function.
func (c *Context) MOVO(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVO(mx, mx1))
}

// MOVO: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVO m128 xmm
//	MOVO xmm  m128
//	MOVO xmm  xmm
//
// Construct and append a MOVO instruction to the active function.
// Operates on the global context.
func MOVO(mx, mx1 operand.Op) { ctx.MOVO(mx, mx1) }

// MOVOA: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVOA m128 xmm
//	MOVOA xmm  m128
//	MOVOA xmm  xmm
//
// Construct and append a MOVOA instruction to the active function.
func (c *Context) MOVOA(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVOA(mx, mx1))
}

// MOVOA: Move Aligned Double Quadword.
//
// Forms:
//
//	MOVOA m128 xmm
//	MOVOA xmm  m128
//	MOVOA xmm  xmm
//
// Construct and append a MOVOA instruction to the active function.
// Operates on the global context.
func MOVOA(mx, mx1 operand.Op) { ctx.MOVOA(mx, mx1) }

// MOVOU: Move Unaligned Double Quadword.
//
// Forms:
//
//	MOVOU m128 xmm
//	MOVOU xmm  m128
//	MOVOU xmm  xmm
//
// Construct and append a MOVOU instruction to the active function.
func (c *Context) MOVOU(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVOU(mx, mx1))
}

// MOVOU: Move Unaligned Double Quadword.
//
// Forms:
//
//	MOVOU m128 xmm
//	MOVOU xmm  m128
//	MOVOU xmm  xmm
//
// Construct and append a MOVOU instruction to the active function.
// Operates on the global context.
func MOVOU(mx, mx1 operand.Op) { ctx.MOVOU(mx, mx1) }

// MOVQ: Move.
//
// Forms:
//
//	MOVQ m32   xmm
//	MOVQ m64   xmm
//	MOVQ r32   xmm
//	MOVQ r64   xmm
//	MOVQ xmm   m32
//	MOVQ xmm   m64
//	MOVQ xmm   r32
//	MOVQ xmm   r64
//	MOVQ xmm   xmm
//	MOVQ imm32 m64
//	MOVQ imm32 r64
//	MOVQ imm64 r64
//	MOVQ m64   r64
//	MOVQ r64   m64
//	MOVQ r64   r64
//
// Construct and append a MOVQ instruction to the active function.
func (c *Context) MOVQ(imrx, mrx operand.Op) {
	c.addinstruction(x86.MOVQ(imrx, mrx))
}

// MOVQ: Move.
//
// Forms:
//
//	MOVQ m32   xmm
//	MOVQ m64   xmm
//	MOVQ r32   xmm
//	MOVQ r64   xmm
//	MOVQ xmm   m32
//	MOVQ xmm   m64
//	MOVQ xmm   r32
//	MOVQ xmm   r64
//	MOVQ xmm   xmm
//	MOVQ imm32 m64
//	MOVQ imm32 r64
//	MOVQ imm64 r64
//	MOVQ m64   r64
//	MOVQ r64   m64
//	MOVQ r64   r64
//
// Construct and append a MOVQ instruction to the active function.
// Operates on the global context.
func MOVQ(imrx, mrx operand.Op) { ctx.MOVQ(imrx, mrx) }

// MOVSD: Move Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVSD m64 xmm
//	MOVSD xmm m64
//	MOVSD xmm xmm
//
// Construct and append a MOVSD instruction to the active function.
func (c *Context) MOVSD(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVSD(mx, mx1))
}

// MOVSD: Move Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	MOVSD m64 xmm
//	MOVSD xmm m64
//	MOVSD xmm xmm
//
// Construct and append a MOVSD instruction to the active function.
// Operates on the global context.
func MOVSD(mx, mx1 operand.Op) { ctx.MOVSD(mx, mx1) }

// MOVSHDUP: Move Packed Single-FP High and Duplicate.
//
// Forms:
//
//	MOVSHDUP m128 xmm
//	MOVSHDUP xmm  xmm
//
// Construct and append a MOVSHDUP instruction to the active function.
func (c *Context) MOVSHDUP(mx, x operand.Op) {
	c.addinstruction(x86.MOVSHDUP(mx, x))
}

// MOVSHDUP: Move Packed Single-FP High and Duplicate.
//
// Forms:
//
//	MOVSHDUP m128 xmm
//	MOVSHDUP xmm  xmm
//
// Construct and append a MOVSHDUP instruction to the active function.
// Operates on the global context.
func MOVSHDUP(mx, x operand.Op) { ctx.MOVSHDUP(mx, x) }

// MOVSLDUP: Move Packed Single-FP Low and Duplicate.
//
// Forms:
//
//	MOVSLDUP m128 xmm
//	MOVSLDUP xmm  xmm
//
// Construct and append a MOVSLDUP instruction to the active function.
func (c *Context) MOVSLDUP(mx, x operand.Op) {
	c.addinstruction(x86.MOVSLDUP(mx, x))
}

// MOVSLDUP: Move Packed Single-FP Low and Duplicate.
//
// Forms:
//
//	MOVSLDUP m128 xmm
//	MOVSLDUP xmm  xmm
//
// Construct and append a MOVSLDUP instruction to the active function.
// Operates on the global context.
func MOVSLDUP(mx, x operand.Op) { ctx.MOVSLDUP(mx, x) }

// MOVSS: Move Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVSS m32 xmm
//	MOVSS xmm m32
//	MOVSS xmm xmm
//
// Construct and append a MOVSS instruction to the active function.
func (c *Context) MOVSS(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVSS(mx, mx1))
}

// MOVSS: Move Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVSS m32 xmm
//	MOVSS xmm m32
//	MOVSS xmm xmm
//
// Construct and append a MOVSS instruction to the active function.
// Operates on the global context.
func MOVSS(mx, mx1 operand.Op) { ctx.MOVSS(mx, mx1) }

// MOVUPD: Move Unaligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPD m128 xmm
//	MOVUPD xmm  m128
//	MOVUPD xmm  xmm
//
// Construct and append a MOVUPD instruction to the active function.
func (c *Context) MOVUPD(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVUPD(mx, mx1))
}

// MOVUPD: Move Unaligned Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPD m128 xmm
//	MOVUPD xmm  m128
//	MOVUPD xmm  xmm
//
// Construct and append a MOVUPD instruction to the active function.
// Operates on the global context.
func MOVUPD(mx, mx1 operand.Op) { ctx.MOVUPD(mx, mx1) }

// MOVUPS: Move Unaligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPS m128 xmm
//	MOVUPS xmm  m128
//	MOVUPS xmm  xmm
//
// Construct and append a MOVUPS instruction to the active function.
func (c *Context) MOVUPS(mx, mx1 operand.Op) {
	c.addinstruction(x86.MOVUPS(mx, mx1))
}

// MOVUPS: Move Unaligned Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MOVUPS m128 xmm
//	MOVUPS xmm  m128
//	MOVUPS xmm  xmm
//
// Construct and append a MOVUPS instruction to the active function.
// Operates on the global context.
func MOVUPS(mx, mx1 operand.Op) { ctx.MOVUPS(mx, mx1) }

// MOVW: Move.
//
// Forms:
//
//	MOVW imm16 m16
//	MOVW imm16 r16
//	MOVW m16   r16
//	MOVW r16   m16
//	MOVW r16   r16
//
// Construct and append a MOVW instruction to the active function.
func (c *Context) MOVW(imr, mr operand.Op) {
	c.addinstruction(x86.MOVW(imr, mr))
}

// MOVW: Move.
//
// Forms:
//
//	MOVW imm16 m16
//	MOVW imm16 r16
//	MOVW m16   r16
//	MOVW r16   m16
//	MOVW r16   r16
//
// Construct and append a MOVW instruction to the active function.
// Operates on the global context.
func MOVW(imr, mr operand.Op) { ctx.MOVW(imr, mr) }

// MOVWLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWLSX m16 r32
//	MOVWLSX r16 r32
//
// Construct and append a MOVWLSX instruction to the active function.
func (c *Context) MOVWLSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVWLSX(mr, r))
}

// MOVWLSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWLSX m16 r32
//	MOVWLSX r16 r32
//
// Construct and append a MOVWLSX instruction to the active function.
// Operates on the global context.
func MOVWLSX(mr, r operand.Op) { ctx.MOVWLSX(mr, r) }

// MOVWLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWLZX m16 r32
//	MOVWLZX r16 r32
//
// Construct and append a MOVWLZX instruction to the active function.
func (c *Context) MOVWLZX(mr, r operand.Op) {
	c.addinstruction(x86.MOVWLZX(mr, r))
}

// MOVWLZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWLZX m16 r32
//	MOVWLZX r16 r32
//
// Construct and append a MOVWLZX instruction to the active function.
// Operates on the global context.
func MOVWLZX(mr, r operand.Op) { ctx.MOVWLZX(mr, r) }

// MOVWQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWQSX m16 r64
//	MOVWQSX r16 r64
//
// Construct and append a MOVWQSX instruction to the active function.
func (c *Context) MOVWQSX(mr, r operand.Op) {
	c.addinstruction(x86.MOVWQSX(mr, r))
}

// MOVWQSX: Move with Sign-Extension.
//
// Forms:
//
//	MOVWQSX m16 r64
//	MOVWQSX r16 r64
//
// Construct and append a MOVWQSX instruction to the active function.
// Operates on the global context.
func MOVWQSX(mr, r operand.Op) { ctx.MOVWQSX(mr, r) }

// MOVWQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWQZX m16 r64
//	MOVWQZX r16 r64
//
// Construct and append a MOVWQZX instruction to the active function.
func (c *Context) MOVWQZX(mr, r operand.Op) {
	c.addinstruction(x86.MOVWQZX(mr, r))
}

// MOVWQZX: Move with Zero-Extend.
//
// Forms:
//
//	MOVWQZX m16 r64
//	MOVWQZX r16 r64
//
// Construct and append a MOVWQZX instruction to the active function.
// Operates on the global context.
func MOVWQZX(mr, r operand.Op) { ctx.MOVWQZX(mr, r) }

// MPSADBW: Compute Multiple Packed Sums of Absolute Difference.
//
// Forms:
//
//	MPSADBW imm8 m128 xmm
//	MPSADBW imm8 xmm  xmm
//
// Construct and append a MPSADBW instruction to the active function.
func (c *Context) MPSADBW(i, mx, x operand.Op) {
	c.addinstruction(x86.MPSADBW(i, mx, x))
}

// MPSADBW: Compute Multiple Packed Sums of Absolute Difference.
//
// Forms:
//
//	MPSADBW imm8 m128 xmm
//	MPSADBW imm8 xmm  xmm
//
// Construct and append a MPSADBW instruction to the active function.
// Operates on the global context.
func MPSADBW(i, mx, x operand.Op) { ctx.MPSADBW(i, mx, x) }

// MULB: Unsigned Multiply.
//
// Forms:
//
//	MULB m8
//	MULB r8
//
// Construct and append a MULB instruction to the active function.
func (c *Context) MULB(mr operand.Op) {
	c.addinstruction(x86.MULB(mr))
}

// MULB: Unsigned Multiply.
//
// Forms:
//
//	MULB m8
//	MULB r8
//
// Construct and append a MULB instruction to the active function.
// Operates on the global context.
func MULB(mr operand.Op) { ctx.MULB(mr) }

// MULL: Unsigned Multiply.
//
// Forms:
//
//	MULL m32
//	MULL r32
//
// Construct and append a MULL instruction to the active function.
func (c *Context) MULL(mr operand.Op) {
	c.addinstruction(x86.MULL(mr))
}

// MULL: Unsigned Multiply.
//
// Forms:
//
//	MULL m32
//	MULL r32
//
// Construct and append a MULL instruction to the active function.
// Operates on the global context.
func MULL(mr operand.Op) { ctx.MULL(mr) }

// MULPD: Multiply Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULPD m128 xmm
//	MULPD xmm  xmm
//
// Construct and append a MULPD instruction to the active function.
func (c *Context) MULPD(mx, x operand.Op) {
	c.addinstruction(x86.MULPD(mx, x))
}

// MULPD: Multiply Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULPD m128 xmm
//	MULPD xmm  xmm
//
// Construct and append a MULPD instruction to the active function.
// Operates on the global context.
func MULPD(mx, x operand.Op) { ctx.MULPD(mx, x) }

// MULPS: Multiply Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULPS m128 xmm
//	MULPS xmm  xmm
//
// Construct and append a MULPS instruction to the active function.
func (c *Context) MULPS(mx, x operand.Op) {
	c.addinstruction(x86.MULPS(mx, x))
}

// MULPS: Multiply Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULPS m128 xmm
//	MULPS xmm  xmm
//
// Construct and append a MULPS instruction to the active function.
// Operates on the global context.
func MULPS(mx, x operand.Op) { ctx.MULPS(mx, x) }

// MULQ: Unsigned Multiply.
//
// Forms:
//
//	MULQ m64
//	MULQ r64
//
// Construct and append a MULQ instruction to the active function.
func (c *Context) MULQ(mr operand.Op) {
	c.addinstruction(x86.MULQ(mr))
}

// MULQ: Unsigned Multiply.
//
// Forms:
//
//	MULQ m64
//	MULQ r64
//
// Construct and append a MULQ instruction to the active function.
// Operates on the global context.
func MULQ(mr operand.Op) { ctx.MULQ(mr) }

// MULSD: Multiply Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULSD m64 xmm
//	MULSD xmm xmm
//
// Construct and append a MULSD instruction to the active function.
func (c *Context) MULSD(mx, x operand.Op) {
	c.addinstruction(x86.MULSD(mx, x))
}

// MULSD: Multiply Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	MULSD m64 xmm
//	MULSD xmm xmm
//
// Construct and append a MULSD instruction to the active function.
// Operates on the global context.
func MULSD(mx, x operand.Op) { ctx.MULSD(mx, x) }

// MULSS: Multiply Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULSS m32 xmm
//	MULSS xmm xmm
//
// Construct and append a MULSS instruction to the active function.
func (c *Context) MULSS(mx, x operand.Op) {
	c.addinstruction(x86.MULSS(mx, x))
}

// MULSS: Multiply Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	MULSS m32 xmm
//	MULSS xmm xmm
//
// Construct and append a MULSS instruction to the active function.
// Operates on the global context.
func MULSS(mx, x operand.Op) { ctx.MULSS(mx, x) }

// MULW: Unsigned Multiply.
//
// Forms:
//
//	MULW m16
//	MULW r16
//
// Construct and append a MULW instruction to the active function.
func (c *Context) MULW(mr operand.Op) {
	c.addinstruction(x86.MULW(mr))
}

// MULW: Unsigned Multiply.
//
// Forms:
//
//	MULW m16
//	MULW r16
//
// Construct and append a MULW instruction to the active function.
// Operates on the global context.
func MULW(mr operand.Op) { ctx.MULW(mr) }

// MULXL: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXL m32 r32 r32
//	MULXL r32 r32 r32
//
// Construct and append a MULXL instruction to the active function.
func (c *Context) MULXL(mr, r, r1 operand.Op) {
	c.addinstruction(x86.MULXL(mr, r, r1))
}

// MULXL: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXL m32 r32 r32
//	MULXL r32 r32 r32
//
// Construct and append a MULXL instruction to the active function.
// Operates on the global context.
func MULXL(mr, r, r1 operand.Op) { ctx.MULXL(mr, r, r1) }

// MULXQ: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXQ m64 r64 r64
//	MULXQ r64 r64 r64
//
// Construct and append a MULXQ instruction to the active function.
func (c *Context) MULXQ(mr, r, r1 operand.Op) {
	c.addinstruction(x86.MULXQ(mr, r, r1))
}

// MULXQ: Unsigned Multiply Without Affecting Flags.
//
// Forms:
//
//	MULXQ m64 r64 r64
//	MULXQ r64 r64 r64
//
// Construct and append a MULXQ instruction to the active function.
// Operates on the global context.
func MULXQ(mr, r, r1 operand.Op) { ctx.MULXQ(mr, r, r1) }

// MWAIT: Monitor Wait.
//
// Forms:
//
//	MWAIT
//
// Construct and append a MWAIT instruction to the active function.
func (c *Context) MWAIT() {
	c.addinstruction(x86.MWAIT())
}

// MWAIT: Monitor Wait.
//
// Forms:
//
//	MWAIT
//
// Construct and append a MWAIT instruction to the active function.
// Operates on the global context.
func MWAIT() { ctx.MWAIT() }

// NEGB: Two's Complement Negation.
//
// Forms:
//
//	NEGB m8
//	NEGB r8
//
// Construct and append a NEGB instruction to the active function.
func (c *Context) NEGB(mr operand.Op) {
	c.addinstruction(x86.NEGB(mr))
}

// NEGB: Two's Complement Negation.
//
// Forms:
//
//	NEGB m8
//	NEGB r8
//
// Construct and append a NEGB instruction to the active function.
// Operates on the global context.
func NEGB(mr operand.Op) { ctx.NEGB(mr) }

// NEGL: Two's Complement Negation.
//
// Forms:
//
//	NEGL m32
//	NEGL r32
//
// Construct and append a NEGL instruction to the active function.
func (c *Context) NEGL(mr operand.Op) {
	c.addinstruction(x86.NEGL(mr))
}

// NEGL: Two's Complement Negation.
//
// Forms:
//
//	NEGL m32
//	NEGL r32
//
// Construct and append a NEGL instruction to the active function.
// Operates on the global context.
func NEGL(mr operand.Op) { ctx.NEGL(mr) }

// NEGQ: Two's Complement Negation.
//
// Forms:
//
//	NEGQ m64
//	NEGQ r64
//
// Construct and append a NEGQ instruction to the active function.
func (c *Context) NEGQ(mr operand.Op) {
	c.addinstruction(x86.NEGQ(mr))
}

// NEGQ: Two's Complement Negation.
//
// Forms:
//
//	NEGQ m64
//	NEGQ r64
//
// Construct and append a NEGQ instruction to the active function.
// Operates on the global context.
func NEGQ(mr operand.Op) { ctx.NEGQ(mr) }

// NEGW: Two's Complement Negation.
//
// Forms:
//
//	NEGW m16
//	NEGW r16
//
// Construct and append a NEGW instruction to the active function.
func (c *Context) NEGW(mr operand.Op) {
	c.addinstruction(x86.NEGW(mr))
}

// NEGW: Two's Complement Negation.
//
// Forms:
//
//	NEGW m16
//	NEGW r16
//
// Construct and append a NEGW instruction to the active function.
// Operates on the global context.
func NEGW(mr operand.Op) { ctx.NEGW(mr) }

// NOP: No Operation.
//
// Forms:
//
//	NOP
//
// Construct and append a NOP instruction to the active function.
func (c *Context) NOP() {
	c.addinstruction(x86.NOP())
}

// NOP: No Operation.
//
// Forms:
//
//	NOP
//
// Construct and append a NOP instruction to the active function.
// Operates on the global context.
func NOP() { ctx.NOP() }

// NOTB: One's Complement Negation.
//
// Forms:
//
//	NOTB m8
//	NOTB r8
//
// Construct and append a NOTB instruction to the active function.
func (c *Context) NOTB(mr operand.Op) {
	c.addinstruction(x86.NOTB(mr))
}

// NOTB: One's Complement Negation.
//
// Forms:
//
//	NOTB m8
//	NOTB r8
//
// Construct and append a NOTB instruction to the active function.
// Operates on the global context.
func NOTB(mr operand.Op) { ctx.NOTB(mr) }

// NOTL: One's Complement Negation.
//
// Forms:
//
//	NOTL m32
//	NOTL r32
//
// Construct and append a NOTL instruction to the active function.
func (c *Context) NOTL(mr operand.Op) {
	c.addinstruction(x86.NOTL(mr))
}

// NOTL: One's Complement Negation.
//
// Forms:
//
//	NOTL m32
//	NOTL r32
//
// Construct and append a NOTL instruction to the active function.
// Operates on the global context.
func NOTL(mr operand.Op) { ctx.NOTL(mr) }

// NOTQ: One's Complement Negation.
//
// Forms:
//
//	NOTQ m64
//	NOTQ r64
//
// Construct and append a NOTQ instruction to the active function.
func (c *Context) NOTQ(mr operand.Op) {
	c.addinstruction(x86.NOTQ(mr))
}

// NOTQ: One's Complement Negation.
//
// Forms:
//
//	NOTQ m64
//	NOTQ r64
//
// Construct and append a NOTQ instruction to the active function.
// Operates on the global context.
func NOTQ(mr operand.Op) { ctx.NOTQ(mr) }

// NOTW: One's Complement Negation.
//
// Forms:
//
//	NOTW m16
//	NOTW r16
//
// Construct and append a NOTW instruction to the active function.
func (c *Context) NOTW(mr operand.Op) {
	c.addinstruction(x86.NOTW(mr))
}

// NOTW: One's Complement Negation.
//
// Forms:
//
//	NOTW m16
//	NOTW r16
//
// Construct and append a NOTW instruction to the active function.
// Operates on the global context.
func NOTW(mr operand.Op) { ctx.NOTW(mr) }

// ORB: Logical Inclusive OR.
//
// Forms:
//
//	ORB imm8 al
//	ORB imm8 m8
//	ORB imm8 r8
//	ORB m8   r8
//	ORB r8   m8
//	ORB r8   r8
//
// Construct and append a ORB instruction to the active function.
func (c *Context) ORB(imr, amr operand.Op) {
	c.addinstruction(x86.ORB(imr, amr))
}

// ORB: Logical Inclusive OR.
//
// Forms:
//
//	ORB imm8 al
//	ORB imm8 m8
//	ORB imm8 r8
//	ORB m8   r8
//	ORB r8   m8
//	ORB r8   r8
//
// Construct and append a ORB instruction to the active function.
// Operates on the global context.
func ORB(imr, amr operand.Op) { ctx.ORB(imr, amr) }

// ORL: Logical Inclusive OR.
//
// Forms:
//
//	ORL imm32 eax
//	ORL imm32 m32
//	ORL imm32 r32
//	ORL imm8  m32
//	ORL imm8  r32
//	ORL m32   r32
//	ORL r32   m32
//	ORL r32   r32
//
// Construct and append a ORL instruction to the active function.
func (c *Context) ORL(imr, emr operand.Op) {
	c.addinstruction(x86.ORL(imr, emr))
}

// ORL: Logical Inclusive OR.
//
// Forms:
//
//	ORL imm32 eax
//	ORL imm32 m32
//	ORL imm32 r32
//	ORL imm8  m32
//	ORL imm8  r32
//	ORL m32   r32
//	ORL r32   m32
//	ORL r32   r32
//
// Construct and append a ORL instruction to the active function.
// Operates on the global context.
func ORL(imr, emr operand.Op) { ctx.ORL(imr, emr) }

// ORPD: Bitwise Logical OR of Double-Precision Floating-Point Values.
//
// Forms:
//
//	ORPD m128 xmm
//	ORPD xmm  xmm
//
// Construct and append a ORPD instruction to the active function.
func (c *Context) ORPD(mx, x operand.Op) {
	c.addinstruction(x86.ORPD(mx, x))
}

// ORPD: Bitwise Logical OR of Double-Precision Floating-Point Values.
//
// Forms:
//
//	ORPD m128 xmm
//	ORPD xmm  xmm
//
// Construct and append a ORPD instruction to the active function.
// Operates on the global context.
func ORPD(mx, x operand.Op) { ctx.ORPD(mx, x) }

// ORPS: Bitwise Logical OR of Single-Precision Floating-Point Values.
//
// Forms:
//
//	ORPS m128 xmm
//	ORPS xmm  xmm
//
// Construct and append a ORPS instruction to the active function.
func (c *Context) ORPS(mx, x operand.Op) {
	c.addinstruction(x86.ORPS(mx, x))
}

// ORPS: Bitwise Logical OR of Single-Precision Floating-Point Values.
//
// Forms:
//
//	ORPS m128 xmm
//	ORPS xmm  xmm
//
// Construct and append a ORPS instruction to the active function.
// Operates on the global context.
func ORPS(mx, x operand.Op) { ctx.ORPS(mx, x) }

// ORQ: Logical Inclusive OR.
//
// Forms:
//
//	ORQ imm32 m64
//	ORQ imm32 r64
//	ORQ imm32 rax
//	ORQ imm8  m64
//	ORQ imm8  r64
//	ORQ m64   r64
//	ORQ r64   m64
//	ORQ r64   r64
//
// Construct and append a ORQ instruction to the active function.
func (c *Context) ORQ(imr, mr operand.Op) {
	c.addinstruction(x86.ORQ(imr, mr))
}

// ORQ: Logical Inclusive OR.
//
// Forms:
//
//	ORQ imm32 m64
//	ORQ imm32 r64
//	ORQ imm32 rax
//	ORQ imm8  m64
//	ORQ imm8  r64
//	ORQ m64   r64
//	ORQ r64   m64
//	ORQ r64   r64
//
// Construct and append a ORQ instruction to the active function.
// Operates on the global context.
func ORQ(imr, mr operand.Op) { ctx.ORQ(imr, mr) }

// ORW: Logical Inclusive OR.
//
// Forms:
//
//	ORW imm16 ax
//	ORW imm16 m16
//	ORW imm16 r16
//	ORW imm8  m16
//	ORW imm8  r16
//	ORW m16   r16
//	ORW r16   m16
//	ORW r16   r16
//
// Construct and append a ORW instruction to the active function.
func (c *Context) ORW(imr, amr operand.Op) {
	c.addinstruction(x86.ORW(imr, amr))
}

// ORW: Logical Inclusive OR.
//
// Forms:
//
//	ORW imm16 ax
//	ORW imm16 m16
//	ORW imm16 r16
//	ORW imm8  m16
//	ORW imm8  r16
//	ORW m16   r16
//	ORW r16   m16
//	ORW r16   r16
//
// Construct and append a ORW instruction to the active function.
// Operates on the global context.
func ORW(imr, amr operand.Op) { ctx.ORW(imr, amr) }

// PABSB: Packed Absolute Value of Byte Integers.
//
// Forms:
//
//	PABSB m128 xmm
//	PABSB xmm  xmm
//
// Construct and append a PABSB instruction to the active function.
func (c *Context) PABSB(mx, x operand.Op) {
	c.addinstruction(x86.PABSB(mx, x))
}

// PABSB: Packed Absolute Value of Byte Integers.
//
// Forms:
//
//	PABSB m128 xmm
//	PABSB xmm  xmm
//
// Construct and append a PABSB instruction to the active function.
// Operates on the global context.
func PABSB(mx, x operand.Op) { ctx.PABSB(mx, x) }

// PABSD: Packed Absolute Value of Doubleword Integers.
//
// Forms:
//
//	PABSD m128 xmm
//	PABSD xmm  xmm
//
// Construct and append a PABSD instruction to the active function.
func (c *Context) PABSD(mx, x operand.Op) {
	c.addinstruction(x86.PABSD(mx, x))
}

// PABSD: Packed Absolute Value of Doubleword Integers.
//
// Forms:
//
//	PABSD m128 xmm
//	PABSD xmm  xmm
//
// Construct and append a PABSD instruction to the active function.
// Operates on the global context.
func PABSD(mx, x operand.Op) { ctx.PABSD(mx, x) }

// PABSW: Packed Absolute Value of Word Integers.
//
// Forms:
//
//	PABSW m128 xmm
//	PABSW xmm  xmm
//
// Construct and append a PABSW instruction to the active function.
func (c *Context) PABSW(mx, x operand.Op) {
	c.addinstruction(x86.PABSW(mx, x))
}

// PABSW: Packed Absolute Value of Word Integers.
//
// Forms:
//
//	PABSW m128 xmm
//	PABSW xmm  xmm
//
// Construct and append a PABSW instruction to the active function.
// Operates on the global context.
func PABSW(mx, x operand.Op) { ctx.PABSW(mx, x) }

// PACKSSLW: Pack Doublewords into Words with Signed Saturation.
//
// Forms:
//
//	PACKSSLW m128 xmm
//	PACKSSLW xmm  xmm
//
// Construct and append a PACKSSLW instruction to the active function.
func (c *Context) PACKSSLW(mx, x operand.Op) {
	c.addinstruction(x86.PACKSSLW(mx, x))
}

// PACKSSLW: Pack Doublewords into Words with Signed Saturation.
//
// Forms:
//
//	PACKSSLW m128 xmm
//	PACKSSLW xmm  xmm
//
// Construct and append a PACKSSLW instruction to the active function.
// Operates on the global context.
func PACKSSLW(mx, x operand.Op) { ctx.PACKSSLW(mx, x) }

// PACKSSWB: Pack Words into Bytes with Signed Saturation.
//
// Forms:
//
//	PACKSSWB m128 xmm
//	PACKSSWB xmm  xmm
//
// Construct and append a PACKSSWB instruction to the active function.
func (c *Context) PACKSSWB(mx, x operand.Op) {
	c.addinstruction(x86.PACKSSWB(mx, x))
}

// PACKSSWB: Pack Words into Bytes with Signed Saturation.
//
// Forms:
//
//	PACKSSWB m128 xmm
//	PACKSSWB xmm  xmm
//
// Construct and append a PACKSSWB instruction to the active function.
// Operates on the global context.
func PACKSSWB(mx, x operand.Op) { ctx.PACKSSWB(mx, x) }

// PACKUSDW: Pack Doublewords into Words with Unsigned Saturation.
//
// Forms:
//
//	PACKUSDW m128 xmm
//	PACKUSDW xmm  xmm
//
// Construct and append a PACKUSDW instruction to the active function.
func (c *Context) PACKUSDW(mx, x operand.Op) {
	c.addinstruction(x86.PACKUSDW(mx, x))
}

// PACKUSDW: Pack Doublewords into Words with Unsigned Saturation.
//
// Forms:
//
//	PACKUSDW m128 xmm
//	PACKUSDW xmm  xmm
//
// Construct and append a PACKUSDW instruction to the active function.
// Operates on the global context.
func PACKUSDW(mx, x operand.Op) { ctx.PACKUSDW(mx, x) }

// PACKUSWB: Pack Words into Bytes with Unsigned Saturation.
//
// Forms:
//
//	PACKUSWB m128 xmm
//	PACKUSWB xmm  xmm
//
// Construct and append a PACKUSWB instruction to the active function.
func (c *Context) PACKUSWB(mx, x operand.Op) {
	c.addinstruction(x86.PACKUSWB(mx, x))
}

// PACKUSWB: Pack Words into Bytes with Unsigned Saturation.
//
// Forms:
//
//	PACKUSWB m128 xmm
//	PACKUSWB xmm  xmm
//
// Construct and append a PACKUSWB instruction to the active function.
// Operates on the global context.
func PACKUSWB(mx, x operand.Op) { ctx.PACKUSWB(mx, x) }

// PADDB: Add Packed Byte Integers.
//
// Forms:
//
//	PADDB m128 xmm
//	PADDB xmm  xmm
//
// Construct and append a PADDB instruction to the active function.
func (c *Context) PADDB(mx, x operand.Op) {
	c.addinstruction(x86.PADDB(mx, x))
}

// PADDB: Add Packed Byte Integers.
//
// Forms:
//
//	PADDB m128 xmm
//	PADDB xmm  xmm
//
// Construct and append a PADDB instruction to the active function.
// Operates on the global context.
func PADDB(mx, x operand.Op) { ctx.PADDB(mx, x) }

// PADDD: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDD m128 xmm
//	PADDD xmm  xmm
//
// Construct and append a PADDD instruction to the active function.
func (c *Context) PADDD(mx, x operand.Op) {
	c.addinstruction(x86.PADDD(mx, x))
}

// PADDD: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDD m128 xmm
//	PADDD xmm  xmm
//
// Construct and append a PADDD instruction to the active function.
// Operates on the global context.
func PADDD(mx, x operand.Op) { ctx.PADDD(mx, x) }

// PADDL: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDL m128 xmm
//	PADDL xmm  xmm
//
// Construct and append a PADDL instruction to the active function.
func (c *Context) PADDL(mx, x operand.Op) {
	c.addinstruction(x86.PADDL(mx, x))
}

// PADDL: Add Packed Doubleword Integers.
//
// Forms:
//
//	PADDL m128 xmm
//	PADDL xmm  xmm
//
// Construct and append a PADDL instruction to the active function.
// Operates on the global context.
func PADDL(mx, x operand.Op) { ctx.PADDL(mx, x) }

// PADDQ: Add Packed Quadword Integers.
//
// Forms:
//
//	PADDQ m128 xmm
//	PADDQ xmm  xmm
//
// Construct and append a PADDQ instruction to the active function.
func (c *Context) PADDQ(mx, x operand.Op) {
	c.addinstruction(x86.PADDQ(mx, x))
}

// PADDQ: Add Packed Quadword Integers.
//
// Forms:
//
//	PADDQ m128 xmm
//	PADDQ xmm  xmm
//
// Construct and append a PADDQ instruction to the active function.
// Operates on the global context.
func PADDQ(mx, x operand.Op) { ctx.PADDQ(mx, x) }

// PADDSB: Add Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PADDSB m128 xmm
//	PADDSB xmm  xmm
//
// Construct and append a PADDSB instruction to the active function.
func (c *Context) PADDSB(mx, x operand.Op) {
	c.addinstruction(x86.PADDSB(mx, x))
}

// PADDSB: Add Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PADDSB m128 xmm
//	PADDSB xmm  xmm
//
// Construct and append a PADDSB instruction to the active function.
// Operates on the global context.
func PADDSB(mx, x operand.Op) { ctx.PADDSB(mx, x) }

// PADDSW: Add Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PADDSW m128 xmm
//	PADDSW xmm  xmm
//
// Construct and append a PADDSW instruction to the active function.
func (c *Context) PADDSW(mx, x operand.Op) {
	c.addinstruction(x86.PADDSW(mx, x))
}

// PADDSW: Add Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PADDSW m128 xmm
//	PADDSW xmm  xmm
//
// Construct and append a PADDSW instruction to the active function.
// Operates on the global context.
func PADDSW(mx, x operand.Op) { ctx.PADDSW(mx, x) }

// PADDUSB: Add Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSB m128 xmm
//	PADDUSB xmm  xmm
//
// Construct and append a PADDUSB instruction to the active function.
func (c *Context) PADDUSB(mx, x operand.Op) {
	c.addinstruction(x86.PADDUSB(mx, x))
}

// PADDUSB: Add Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSB m128 xmm
//	PADDUSB xmm  xmm
//
// Construct and append a PADDUSB instruction to the active function.
// Operates on the global context.
func PADDUSB(mx, x operand.Op) { ctx.PADDUSB(mx, x) }

// PADDUSW: Add Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSW m128 xmm
//	PADDUSW xmm  xmm
//
// Construct and append a PADDUSW instruction to the active function.
func (c *Context) PADDUSW(mx, x operand.Op) {
	c.addinstruction(x86.PADDUSW(mx, x))
}

// PADDUSW: Add Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PADDUSW m128 xmm
//	PADDUSW xmm  xmm
//
// Construct and append a PADDUSW instruction to the active function.
// Operates on the global context.
func PADDUSW(mx, x operand.Op) { ctx.PADDUSW(mx, x) }

// PADDW: Add Packed Word Integers.
//
// Forms:
//
//	PADDW m128 xmm
//	PADDW xmm  xmm
//
// Construct and append a PADDW instruction to the active function.
func (c *Context) PADDW(mx, x operand.Op) {
	c.addinstruction(x86.PADDW(mx, x))
}

// PADDW: Add Packed Word Integers.
//
// Forms:
//
//	PADDW m128 xmm
//	PADDW xmm  xmm
//
// Construct and append a PADDW instruction to the active function.
// Operates on the global context.
func PADDW(mx, x operand.Op) { ctx.PADDW(mx, x) }

// PALIGNR: Packed Align Right.
//
// Forms:
//
//	PALIGNR imm8 m128 xmm
//	PALIGNR imm8 xmm  xmm
//
// Construct and append a PALIGNR instruction to the active function.
func (c *Context) PALIGNR(i, mx, x operand.Op) {
	c.addinstruction(x86.PALIGNR(i, mx, x))
}

// PALIGNR: Packed Align Right.
//
// Forms:
//
//	PALIGNR imm8 m128 xmm
//	PALIGNR imm8 xmm  xmm
//
// Construct and append a PALIGNR instruction to the active function.
// Operates on the global context.
func PALIGNR(i, mx, x operand.Op) { ctx.PALIGNR(i, mx, x) }

// PAND: Packed Bitwise Logical AND.
//
// Forms:
//
//	PAND m128 xmm
//	PAND xmm  xmm
//
// Construct and append a PAND instruction to the active function.
func (c *Context) PAND(mx, x operand.Op) {
	c.addinstruction(x86.PAND(mx, x))
}

// PAND: Packed Bitwise Logical AND.
//
// Forms:
//
//	PAND m128 xmm
//	PAND xmm  xmm
//
// Construct and append a PAND instruction to the active function.
// Operates on the global context.
func PAND(mx, x operand.Op) { ctx.PAND(mx, x) }

// PANDN: Packed Bitwise Logical AND NOT.
//
// Forms:
//
//	PANDN m128 xmm
//	PANDN xmm  xmm
//
// Construct and append a PANDN instruction to the active function.
func (c *Context) PANDN(mx, x operand.Op) {
	c.addinstruction(x86.PANDN(mx, x))
}

// PANDN: Packed Bitwise Logical AND NOT.
//
// Forms:
//
//	PANDN m128 xmm
//	PANDN xmm  xmm
//
// Construct and append a PANDN instruction to the active function.
// Operates on the global context.
func PANDN(mx, x operand.Op) { ctx.PANDN(mx, x) }

// PAUSE: Spin Loop Hint.
//
// Forms:
//
//	PAUSE
//
// Construct and append a PAUSE instruction to the active function.
func (c *Context) PAUSE() {
	c.addinstruction(x86.PAUSE())
}

// PAUSE: Spin Loop Hint.
//
// Forms:
//
//	PAUSE
//
// Construct and append a PAUSE instruction to the active function.
// Operates on the global context.
func PAUSE() { ctx.PAUSE() }

// PAVGB: Average Packed Byte Integers.
//
// Forms:
//
//	PAVGB m128 xmm
//	PAVGB xmm  xmm
//
// Construct and append a PAVGB instruction to the active function.
func (c *Context) PAVGB(mx, x operand.Op) {
	c.addinstruction(x86.PAVGB(mx, x))
}

// PAVGB: Average Packed Byte Integers.
//
// Forms:
//
//	PAVGB m128 xmm
//	PAVGB xmm  xmm
//
// Construct and append a PAVGB instruction to the active function.
// Operates on the global context.
func PAVGB(mx, x operand.Op) { ctx.PAVGB(mx, x) }

// PAVGW: Average Packed Word Integers.
//
// Forms:
//
//	PAVGW m128 xmm
//	PAVGW xmm  xmm
//
// Construct and append a PAVGW instruction to the active function.
func (c *Context) PAVGW(mx, x operand.Op) {
	c.addinstruction(x86.PAVGW(mx, x))
}

// PAVGW: Average Packed Word Integers.
//
// Forms:
//
//	PAVGW m128 xmm
//	PAVGW xmm  xmm
//
// Construct and append a PAVGW instruction to the active function.
// Operates on the global context.
func PAVGW(mx, x operand.Op) { ctx.PAVGW(mx, x) }

// PBLENDVB: Variable Blend Packed Bytes.
//
// Forms:
//
//	PBLENDVB xmm0 m128 xmm
//	PBLENDVB xmm0 xmm  xmm
//
// Construct and append a PBLENDVB instruction to the active function.
func (c *Context) PBLENDVB(x, mx, x1 operand.Op) {
	c.addinstruction(x86.PBLENDVB(x, mx, x1))
}

// PBLENDVB: Variable Blend Packed Bytes.
//
// Forms:
//
//	PBLENDVB xmm0 m128 xmm
//	PBLENDVB xmm0 xmm  xmm
//
// Construct and append a PBLENDVB instruction to the active function.
// Operates on the global context.
func PBLENDVB(x, mx, x1 operand.Op) { ctx.PBLENDVB(x, mx, x1) }

// PBLENDW: Blend Packed Words.
//
// Forms:
//
//	PBLENDW imm8 m128 xmm
//	PBLENDW imm8 xmm  xmm
//
// Construct and append a PBLENDW instruction to the active function.
func (c *Context) PBLENDW(i, mx, x operand.Op) {
	c.addinstruction(x86.PBLENDW(i, mx, x))
}

// PBLENDW: Blend Packed Words.
//
// Forms:
//
//	PBLENDW imm8 m128 xmm
//	PBLENDW imm8 xmm  xmm
//
// Construct and append a PBLENDW instruction to the active function.
// Operates on the global context.
func PBLENDW(i, mx, x operand.Op) { ctx.PBLENDW(i, mx, x) }

// PCLMULQDQ: Carry-Less Quadword Multiplication.
//
// Forms:
//
//	PCLMULQDQ imm8 m128 xmm
//	PCLMULQDQ imm8 xmm  xmm
//
// Construct and append a PCLMULQDQ instruction to the active function.
func (c *Context) PCLMULQDQ(i, mx, x operand.Op) {
	c.addinstruction(x86.PCLMULQDQ(i, mx, x))
}

// PCLMULQDQ: Carry-Less Quadword Multiplication.
//
// Forms:
//
//	PCLMULQDQ imm8 m128 xmm
//	PCLMULQDQ imm8 xmm  xmm
//
// Construct and append a PCLMULQDQ instruction to the active function.
// Operates on the global context.
func PCLMULQDQ(i, mx, x operand.Op) { ctx.PCLMULQDQ(i, mx, x) }

// PCMPEQB: Compare Packed Byte Data for Equality.
//
// Forms:
//
//	PCMPEQB m128 xmm
//	PCMPEQB xmm  xmm
//
// Construct and append a PCMPEQB instruction to the active function.
func (c *Context) PCMPEQB(mx, x operand.Op) {
	c.addinstruction(x86.PCMPEQB(mx, x))
}

// PCMPEQB: Compare Packed Byte Data for Equality.
//
// Forms:
//
//	PCMPEQB m128 xmm
//	PCMPEQB xmm  xmm
//
// Construct and append a PCMPEQB instruction to the active function.
// Operates on the global context.
func PCMPEQB(mx, x operand.Op) { ctx.PCMPEQB(mx, x) }

// PCMPEQL: Compare Packed Doubleword Data for Equality.
//
// Forms:
//
//	PCMPEQL m128 xmm
//	PCMPEQL xmm  xmm
//
// Construct and append a PCMPEQL instruction to the active function.
func (c *Context) PCMPEQL(mx, x operand.Op) {
	c.addinstruction(x86.PCMPEQL(mx, x))
}

// PCMPEQL: Compare Packed Doubleword Data for Equality.
//
// Forms:
//
//	PCMPEQL m128 xmm
//	PCMPEQL xmm  xmm
//
// Construct and append a PCMPEQL instruction to the active function.
// Operates on the global context.
func PCMPEQL(mx, x operand.Op) { ctx.PCMPEQL(mx, x) }

// PCMPEQQ: Compare Packed Quadword Data for Equality.
//
// Forms:
//
//	PCMPEQQ m128 xmm
//	PCMPEQQ xmm  xmm
//
// Construct and append a PCMPEQQ instruction to the active function.
func (c *Context) PCMPEQQ(mx, x operand.Op) {
	c.addinstruction(x86.PCMPEQQ(mx, x))
}

// PCMPEQQ: Compare Packed Quadword Data for Equality.
//
// Forms:
//
//	PCMPEQQ m128 xmm
//	PCMPEQQ xmm  xmm
//
// Construct and append a PCMPEQQ instruction to the active function.
// Operates on the global context.
func PCMPEQQ(mx, x operand.Op) { ctx.PCMPEQQ(mx, x) }

// PCMPEQW: Compare Packed Word Data for Equality.
//
// Forms:
//
//	PCMPEQW m128 xmm
//	PCMPEQW xmm  xmm
//
// Construct and append a PCMPEQW instruction to the active function.
func (c *Context) PCMPEQW(mx, x operand.Op) {
	c.addinstruction(x86.PCMPEQW(mx, x))
}

// PCMPEQW: Compare Packed Word Data for Equality.
//
// Forms:
//
//	PCMPEQW m128 xmm
//	PCMPEQW xmm  xmm
//
// Construct and append a PCMPEQW instruction to the active function.
// Operates on the global context.
func PCMPEQW(mx, x operand.Op) { ctx.PCMPEQW(mx, x) }

// PCMPESTRI: Packed Compare Explicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPESTRI imm8 m128 xmm
//	PCMPESTRI imm8 xmm  xmm
//
// Construct and append a PCMPESTRI instruction to the active function.
func (c *Context) PCMPESTRI(i, mx, x operand.Op) {
	c.addinstruction(x86.PCMPESTRI(i, mx, x))
}

// PCMPESTRI: Packed Compare Explicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPESTRI imm8 m128 xmm
//	PCMPESTRI imm8 xmm  xmm
//
// Construct and append a PCMPESTRI instruction to the active function.
// Operates on the global context.
func PCMPESTRI(i, mx, x operand.Op) { ctx.PCMPESTRI(i, mx, x) }

// PCMPESTRM: Packed Compare Explicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPESTRM imm8 m128 xmm
//	PCMPESTRM imm8 xmm  xmm
//
// Construct and append a PCMPESTRM instruction to the active function.
func (c *Context) PCMPESTRM(i, mx, x operand.Op) {
	c.addinstruction(x86.PCMPESTRM(i, mx, x))
}

// PCMPESTRM: Packed Compare Explicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPESTRM imm8 m128 xmm
//	PCMPESTRM imm8 xmm  xmm
//
// Construct and append a PCMPESTRM instruction to the active function.
// Operates on the global context.
func PCMPESTRM(i, mx, x operand.Op) { ctx.PCMPESTRM(i, mx, x) }

// PCMPGTB: Compare Packed Signed Byte Integers for Greater Than.
//
// Forms:
//
//	PCMPGTB m128 xmm
//	PCMPGTB xmm  xmm
//
// Construct and append a PCMPGTB instruction to the active function.
func (c *Context) PCMPGTB(mx, x operand.Op) {
	c.addinstruction(x86.PCMPGTB(mx, x))
}

// PCMPGTB: Compare Packed Signed Byte Integers for Greater Than.
//
// Forms:
//
//	PCMPGTB m128 xmm
//	PCMPGTB xmm  xmm
//
// Construct and append a PCMPGTB instruction to the active function.
// Operates on the global context.
func PCMPGTB(mx, x operand.Op) { ctx.PCMPGTB(mx, x) }

// PCMPGTL: Compare Packed Signed Doubleword Integers for Greater Than.
//
// Forms:
//
//	PCMPGTL m128 xmm
//	PCMPGTL xmm  xmm
//
// Construct and append a PCMPGTL instruction to the active function.
func (c *Context) PCMPGTL(mx, x operand.Op) {
	c.addinstruction(x86.PCMPGTL(mx, x))
}

// PCMPGTL: Compare Packed Signed Doubleword Integers for Greater Than.
//
// Forms:
//
//	PCMPGTL m128 xmm
//	PCMPGTL xmm  xmm
//
// Construct and append a PCMPGTL instruction to the active function.
// Operates on the global context.
func PCMPGTL(mx, x operand.Op) { ctx.PCMPGTL(mx, x) }

// PCMPGTQ: Compare Packed Data for Greater Than.
//
// Forms:
//
//	PCMPGTQ m128 xmm
//	PCMPGTQ xmm  xmm
//
// Construct and append a PCMPGTQ instruction to the active function.
func (c *Context) PCMPGTQ(mx, x operand.Op) {
	c.addinstruction(x86.PCMPGTQ(mx, x))
}

// PCMPGTQ: Compare Packed Data for Greater Than.
//
// Forms:
//
//	PCMPGTQ m128 xmm
//	PCMPGTQ xmm  xmm
//
// Construct and append a PCMPGTQ instruction to the active function.
// Operates on the global context.
func PCMPGTQ(mx, x operand.Op) { ctx.PCMPGTQ(mx, x) }

// PCMPGTW: Compare Packed Signed Word Integers for Greater Than.
//
// Forms:
//
//	PCMPGTW m128 xmm
//	PCMPGTW xmm  xmm
//
// Construct and append a PCMPGTW instruction to the active function.
func (c *Context) PCMPGTW(mx, x operand.Op) {
	c.addinstruction(x86.PCMPGTW(mx, x))
}

// PCMPGTW: Compare Packed Signed Word Integers for Greater Than.
//
// Forms:
//
//	PCMPGTW m128 xmm
//	PCMPGTW xmm  xmm
//
// Construct and append a PCMPGTW instruction to the active function.
// Operates on the global context.
func PCMPGTW(mx, x operand.Op) { ctx.PCMPGTW(mx, x) }

// PCMPISTRI: Packed Compare Implicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPISTRI imm8 m128 xmm
//	PCMPISTRI imm8 xmm  xmm
//
// Construct and append a PCMPISTRI instruction to the active function.
func (c *Context) PCMPISTRI(i, mx, x operand.Op) {
	c.addinstruction(x86.PCMPISTRI(i, mx, x))
}

// PCMPISTRI: Packed Compare Implicit Length Strings, Return Index.
//
// Forms:
//
//	PCMPISTRI imm8 m128 xmm
//	PCMPISTRI imm8 xmm  xmm
//
// Construct and append a PCMPISTRI instruction to the active function.
// Operates on the global context.
func PCMPISTRI(i, mx, x operand.Op) { ctx.PCMPISTRI(i, mx, x) }

// PCMPISTRM: Packed Compare Implicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPISTRM imm8 m128 xmm
//	PCMPISTRM imm8 xmm  xmm
//
// Construct and append a PCMPISTRM instruction to the active function.
func (c *Context) PCMPISTRM(i, mx, x operand.Op) {
	c.addinstruction(x86.PCMPISTRM(i, mx, x))
}

// PCMPISTRM: Packed Compare Implicit Length Strings, Return Mask.
//
// Forms:
//
//	PCMPISTRM imm8 m128 xmm
//	PCMPISTRM imm8 xmm  xmm
//
// Construct and append a PCMPISTRM instruction to the active function.
// Operates on the global context.
func PCMPISTRM(i, mx, x operand.Op) { ctx.PCMPISTRM(i, mx, x) }

// PDEPL: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPL m32 r32 r32
//	PDEPL r32 r32 r32
//
// Construct and append a PDEPL instruction to the active function.
func (c *Context) PDEPL(mr, r, r1 operand.Op) {
	c.addinstruction(x86.PDEPL(mr, r, r1))
}

// PDEPL: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPL m32 r32 r32
//	PDEPL r32 r32 r32
//
// Construct and append a PDEPL instruction to the active function.
// Operates on the global context.
func PDEPL(mr, r, r1 operand.Op) { ctx.PDEPL(mr, r, r1) }

// PDEPQ: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPQ m64 r64 r64
//	PDEPQ r64 r64 r64
//
// Construct and append a PDEPQ instruction to the active function.
func (c *Context) PDEPQ(mr, r, r1 operand.Op) {
	c.addinstruction(x86.PDEPQ(mr, r, r1))
}

// PDEPQ: Parallel Bits Deposit.
//
// Forms:
//
//	PDEPQ m64 r64 r64
//	PDEPQ r64 r64 r64
//
// Construct and append a PDEPQ instruction to the active function.
// Operates on the global context.
func PDEPQ(mr, r, r1 operand.Op) { ctx.PDEPQ(mr, r, r1) }

// PEXTL: Parallel Bits Extract.
//
// Forms:
//
//	PEXTL m32 r32 r32
//	PEXTL r32 r32 r32
//
// Construct and append a PEXTL instruction to the active function.
func (c *Context) PEXTL(mr, r, r1 operand.Op) {
	c.addinstruction(x86.PEXTL(mr, r, r1))
}

// PEXTL: Parallel Bits Extract.
//
// Forms:
//
//	PEXTL m32 r32 r32
//	PEXTL r32 r32 r32
//
// Construct and append a PEXTL instruction to the active function.
// Operates on the global context.
func PEXTL(mr, r, r1 operand.Op) { ctx.PEXTL(mr, r, r1) }

// PEXTQ: Parallel Bits Extract.
//
// Forms:
//
//	PEXTQ m64 r64 r64
//	PEXTQ r64 r64 r64
//
// Construct and append a PEXTQ instruction to the active function.
func (c *Context) PEXTQ(mr, r, r1 operand.Op) {
	c.addinstruction(x86.PEXTQ(mr, r, r1))
}

// PEXTQ: Parallel Bits Extract.
//
// Forms:
//
//	PEXTQ m64 r64 r64
//	PEXTQ r64 r64 r64
//
// Construct and append a PEXTQ instruction to the active function.
// Operates on the global context.
func PEXTQ(mr, r, r1 operand.Op) { ctx.PEXTQ(mr, r, r1) }

// PEXTRB: Extract Byte.
//
// Forms:
//
//	PEXTRB imm8 xmm m8
//	PEXTRB imm8 xmm r32
//
// Construct and append a PEXTRB instruction to the active function.
func (c *Context) PEXTRB(i, x, mr operand.Op) {
	c.addinstruction(x86.PEXTRB(i, x, mr))
}

// PEXTRB: Extract Byte.
//
// Forms:
//
//	PEXTRB imm8 xmm m8
//	PEXTRB imm8 xmm r32
//
// Construct and append a PEXTRB instruction to the active function.
// Operates on the global context.
func PEXTRB(i, x, mr operand.Op) { ctx.PEXTRB(i, x, mr) }

// PEXTRD: Extract Doubleword.
//
// Forms:
//
//	PEXTRD imm8 xmm m32
//	PEXTRD imm8 xmm r32
//
// Construct and append a PEXTRD instruction to the active function.
func (c *Context) PEXTRD(i, x, mr operand.Op) {
	c.addinstruction(x86.PEXTRD(i, x, mr))
}

// PEXTRD: Extract Doubleword.
//
// Forms:
//
//	PEXTRD imm8 xmm m32
//	PEXTRD imm8 xmm r32
//
// Construct and append a PEXTRD instruction to the active function.
// Operates on the global context.
func PEXTRD(i, x, mr operand.Op) { ctx.PEXTRD(i, x, mr) }

// PEXTRQ: Extract Quadword.
//
// Forms:
//
//	PEXTRQ imm8 xmm m64
//	PEXTRQ imm8 xmm r64
//
// Construct and append a PEXTRQ instruction to the active function.
func (c *Context) PEXTRQ(i, x, mr operand.Op) {
	c.addinstruction(x86.PEXTRQ(i, x, mr))
}

// PEXTRQ: Extract Quadword.
//
// Forms:
//
//	PEXTRQ imm8 xmm m64
//	PEXTRQ imm8 xmm r64
//
// Construct and append a PEXTRQ instruction to the active function.
// Operates on the global context.
func PEXTRQ(i, x, mr operand.Op) { ctx.PEXTRQ(i, x, mr) }

// PEXTRW: Extract Word.
//
// Forms:
//
//	PEXTRW imm8 xmm m16
//	PEXTRW imm8 xmm r32
//
// Construct and append a PEXTRW instruction to the active function.
func (c *Context) PEXTRW(i, x, mr operand.Op) {
	c.addinstruction(x86.PEXTRW(i, x, mr))
}

// PEXTRW: Extract Word.
//
// Forms:
//
//	PEXTRW imm8 xmm m16
//	PEXTRW imm8 xmm r32
//
// Construct and append a PEXTRW instruction to the active function.
// Operates on the global context.
func PEXTRW(i, x, mr operand.Op) { ctx.PEXTRW(i, x, mr) }

// PHADDD: Packed Horizontal Add Doubleword Integer.
//
// Forms:
//
//	PHADDD m128 xmm
//	PHADDD xmm  xmm
//
// Construct and append a PHADDD instruction to the active function.
func (c *Context) PHADDD(mx, x operand.Op) {
	c.addinstruction(x86.PHADDD(mx, x))
}

// PHADDD: Packed Horizontal Add Doubleword Integer.
//
// Forms:
//
//	PHADDD m128 xmm
//	PHADDD xmm  xmm
//
// Construct and append a PHADDD instruction to the active function.
// Operates on the global context.
func PHADDD(mx, x operand.Op) { ctx.PHADDD(mx, x) }

// PHADDSW: Packed Horizontal Add Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHADDSW m128 xmm
//	PHADDSW xmm  xmm
//
// Construct and append a PHADDSW instruction to the active function.
func (c *Context) PHADDSW(mx, x operand.Op) {
	c.addinstruction(x86.PHADDSW(mx, x))
}

// PHADDSW: Packed Horizontal Add Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHADDSW m128 xmm
//	PHADDSW xmm  xmm
//
// Construct and append a PHADDSW instruction to the active function.
// Operates on the global context.
func PHADDSW(mx, x operand.Op) { ctx.PHADDSW(mx, x) }

// PHADDW: Packed Horizontal Add Word Integers.
//
// Forms:
//
//	PHADDW m128 xmm
//	PHADDW xmm  xmm
//
// Construct and append a PHADDW instruction to the active function.
func (c *Context) PHADDW(mx, x operand.Op) {
	c.addinstruction(x86.PHADDW(mx, x))
}

// PHADDW: Packed Horizontal Add Word Integers.
//
// Forms:
//
//	PHADDW m128 xmm
//	PHADDW xmm  xmm
//
// Construct and append a PHADDW instruction to the active function.
// Operates on the global context.
func PHADDW(mx, x operand.Op) { ctx.PHADDW(mx, x) }

// PHMINPOSUW: Packed Horizontal Minimum of Unsigned Word Integers.
//
// Forms:
//
//	PHMINPOSUW m128 xmm
//	PHMINPOSUW xmm  xmm
//
// Construct and append a PHMINPOSUW instruction to the active function.
func (c *Context) PHMINPOSUW(mx, x operand.Op) {
	c.addinstruction(x86.PHMINPOSUW(mx, x))
}

// PHMINPOSUW: Packed Horizontal Minimum of Unsigned Word Integers.
//
// Forms:
//
//	PHMINPOSUW m128 xmm
//	PHMINPOSUW xmm  xmm
//
// Construct and append a PHMINPOSUW instruction to the active function.
// Operates on the global context.
func PHMINPOSUW(mx, x operand.Op) { ctx.PHMINPOSUW(mx, x) }

// PHSUBD: Packed Horizontal Subtract Doubleword Integers.
//
// Forms:
//
//	PHSUBD m128 xmm
//	PHSUBD xmm  xmm
//
// Construct and append a PHSUBD instruction to the active function.
func (c *Context) PHSUBD(mx, x operand.Op) {
	c.addinstruction(x86.PHSUBD(mx, x))
}

// PHSUBD: Packed Horizontal Subtract Doubleword Integers.
//
// Forms:
//
//	PHSUBD m128 xmm
//	PHSUBD xmm  xmm
//
// Construct and append a PHSUBD instruction to the active function.
// Operates on the global context.
func PHSUBD(mx, x operand.Op) { ctx.PHSUBD(mx, x) }

// PHSUBSW: Packed Horizontal Subtract Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHSUBSW m128 xmm
//	PHSUBSW xmm  xmm
//
// Construct and append a PHSUBSW instruction to the active function.
func (c *Context) PHSUBSW(mx, x operand.Op) {
	c.addinstruction(x86.PHSUBSW(mx, x))
}

// PHSUBSW: Packed Horizontal Subtract Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PHSUBSW m128 xmm
//	PHSUBSW xmm  xmm
//
// Construct and append a PHSUBSW instruction to the active function.
// Operates on the global context.
func PHSUBSW(mx, x operand.Op) { ctx.PHSUBSW(mx, x) }

// PHSUBW: Packed Horizontal Subtract Word Integers.
//
// Forms:
//
//	PHSUBW m128 xmm
//	PHSUBW xmm  xmm
//
// Construct and append a PHSUBW instruction to the active function.
func (c *Context) PHSUBW(mx, x operand.Op) {
	c.addinstruction(x86.PHSUBW(mx, x))
}

// PHSUBW: Packed Horizontal Subtract Word Integers.
//
// Forms:
//
//	PHSUBW m128 xmm
//	PHSUBW xmm  xmm
//
// Construct and append a PHSUBW instruction to the active function.
// Operates on the global context.
func PHSUBW(mx, x operand.Op) { ctx.PHSUBW(mx, x) }

// PINSRB: Insert Byte.
//
// Forms:
//
//	PINSRB imm8 m8  xmm
//	PINSRB imm8 r32 xmm
//
// Construct and append a PINSRB instruction to the active function.
func (c *Context) PINSRB(i, mr, x operand.Op) {
	c.addinstruction(x86.PINSRB(i, mr, x))
}

// PINSRB: Insert Byte.
//
// Forms:
//
//	PINSRB imm8 m8  xmm
//	PINSRB imm8 r32 xmm
//
// Construct and append a PINSRB instruction to the active function.
// Operates on the global context.
func PINSRB(i, mr, x operand.Op) { ctx.PINSRB(i, mr, x) }

// PINSRD: Insert Doubleword.
//
// Forms:
//
//	PINSRD imm8 m32 xmm
//	PINSRD imm8 r32 xmm
//
// Construct and append a PINSRD instruction to the active function.
func (c *Context) PINSRD(i, mr, x operand.Op) {
	c.addinstruction(x86.PINSRD(i, mr, x))
}

// PINSRD: Insert Doubleword.
//
// Forms:
//
//	PINSRD imm8 m32 xmm
//	PINSRD imm8 r32 xmm
//
// Construct and append a PINSRD instruction to the active function.
// Operates on the global context.
func PINSRD(i, mr, x operand.Op) { ctx.PINSRD(i, mr, x) }

// PINSRQ: Insert Quadword.
//
// Forms:
//
//	PINSRQ imm8 m64 xmm
//	PINSRQ imm8 r64 xmm
//
// Construct and append a PINSRQ instruction to the active function.
func (c *Context) PINSRQ(i, mr, x operand.Op) {
	c.addinstruction(x86.PINSRQ(i, mr, x))
}

// PINSRQ: Insert Quadword.
//
// Forms:
//
//	PINSRQ imm8 m64 xmm
//	PINSRQ imm8 r64 xmm
//
// Construct and append a PINSRQ instruction to the active function.
// Operates on the global context.
func PINSRQ(i, mr, x operand.Op) { ctx.PINSRQ(i, mr, x) }

// PINSRW: Insert Word.
//
// Forms:
//
//	PINSRW imm8 m16 xmm
//	PINSRW imm8 r32 xmm
//
// Construct and append a PINSRW instruction to the active function.
func (c *Context) PINSRW(i, mr, x operand.Op) {
	c.addinstruction(x86.PINSRW(i, mr, x))
}

// PINSRW: Insert Word.
//
// Forms:
//
//	PINSRW imm8 m16 xmm
//	PINSRW imm8 r32 xmm
//
// Construct and append a PINSRW instruction to the active function.
// Operates on the global context.
func PINSRW(i, mr, x operand.Op) { ctx.PINSRW(i, mr, x) }

// PMADDUBSW: Multiply and Add Packed Signed and Unsigned Byte Integers.
//
// Forms:
//
//	PMADDUBSW m128 xmm
//	PMADDUBSW xmm  xmm
//
// Construct and append a PMADDUBSW instruction to the active function.
func (c *Context) PMADDUBSW(mx, x operand.Op) {
	c.addinstruction(x86.PMADDUBSW(mx, x))
}

// PMADDUBSW: Multiply and Add Packed Signed and Unsigned Byte Integers.
//
// Forms:
//
//	PMADDUBSW m128 xmm
//	PMADDUBSW xmm  xmm
//
// Construct and append a PMADDUBSW instruction to the active function.
// Operates on the global context.
func PMADDUBSW(mx, x operand.Op) { ctx.PMADDUBSW(mx, x) }

// PMADDWL: Multiply and Add Packed Signed Word Integers.
//
// Forms:
//
//	PMADDWL m128 xmm
//	PMADDWL xmm  xmm
//
// Construct and append a PMADDWL instruction to the active function.
func (c *Context) PMADDWL(mx, x operand.Op) {
	c.addinstruction(x86.PMADDWL(mx, x))
}

// PMADDWL: Multiply and Add Packed Signed Word Integers.
//
// Forms:
//
//	PMADDWL m128 xmm
//	PMADDWL xmm  xmm
//
// Construct and append a PMADDWL instruction to the active function.
// Operates on the global context.
func PMADDWL(mx, x operand.Op) { ctx.PMADDWL(mx, x) }

// PMAXSB: Maximum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMAXSB m128 xmm
//	PMAXSB xmm  xmm
//
// Construct and append a PMAXSB instruction to the active function.
func (c *Context) PMAXSB(mx, x operand.Op) {
	c.addinstruction(x86.PMAXSB(mx, x))
}

// PMAXSB: Maximum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMAXSB m128 xmm
//	PMAXSB xmm  xmm
//
// Construct and append a PMAXSB instruction to the active function.
// Operates on the global context.
func PMAXSB(mx, x operand.Op) { ctx.PMAXSB(mx, x) }

// PMAXSD: Maximum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMAXSD m128 xmm
//	PMAXSD xmm  xmm
//
// Construct and append a PMAXSD instruction to the active function.
func (c *Context) PMAXSD(mx, x operand.Op) {
	c.addinstruction(x86.PMAXSD(mx, x))
}

// PMAXSD: Maximum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMAXSD m128 xmm
//	PMAXSD xmm  xmm
//
// Construct and append a PMAXSD instruction to the active function.
// Operates on the global context.
func PMAXSD(mx, x operand.Op) { ctx.PMAXSD(mx, x) }

// PMAXSW: Maximum of Packed Signed Word Integers.
//
// Forms:
//
//	PMAXSW m128 xmm
//	PMAXSW xmm  xmm
//
// Construct and append a PMAXSW instruction to the active function.
func (c *Context) PMAXSW(mx, x operand.Op) {
	c.addinstruction(x86.PMAXSW(mx, x))
}

// PMAXSW: Maximum of Packed Signed Word Integers.
//
// Forms:
//
//	PMAXSW m128 xmm
//	PMAXSW xmm  xmm
//
// Construct and append a PMAXSW instruction to the active function.
// Operates on the global context.
func PMAXSW(mx, x operand.Op) { ctx.PMAXSW(mx, x) }

// PMAXUB: Maximum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMAXUB m128 xmm
//	PMAXUB xmm  xmm
//
// Construct and append a PMAXUB instruction to the active function.
func (c *Context) PMAXUB(mx, x operand.Op) {
	c.addinstruction(x86.PMAXUB(mx, x))
}

// PMAXUB: Maximum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMAXUB m128 xmm
//	PMAXUB xmm  xmm
//
// Construct and append a PMAXUB instruction to the active function.
// Operates on the global context.
func PMAXUB(mx, x operand.Op) { ctx.PMAXUB(mx, x) }

// PMAXUD: Maximum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMAXUD m128 xmm
//	PMAXUD xmm  xmm
//
// Construct and append a PMAXUD instruction to the active function.
func (c *Context) PMAXUD(mx, x operand.Op) {
	c.addinstruction(x86.PMAXUD(mx, x))
}

// PMAXUD: Maximum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMAXUD m128 xmm
//	PMAXUD xmm  xmm
//
// Construct and append a PMAXUD instruction to the active function.
// Operates on the global context.
func PMAXUD(mx, x operand.Op) { ctx.PMAXUD(mx, x) }

// PMAXUW: Maximum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMAXUW m128 xmm
//	PMAXUW xmm  xmm
//
// Construct and append a PMAXUW instruction to the active function.
func (c *Context) PMAXUW(mx, x operand.Op) {
	c.addinstruction(x86.PMAXUW(mx, x))
}

// PMAXUW: Maximum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMAXUW m128 xmm
//	PMAXUW xmm  xmm
//
// Construct and append a PMAXUW instruction to the active function.
// Operates on the global context.
func PMAXUW(mx, x operand.Op) { ctx.PMAXUW(mx, x) }

// PMINSB: Minimum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMINSB m128 xmm
//	PMINSB xmm  xmm
//
// Construct and append a PMINSB instruction to the active function.
func (c *Context) PMINSB(mx, x operand.Op) {
	c.addinstruction(x86.PMINSB(mx, x))
}

// PMINSB: Minimum of Packed Signed Byte Integers.
//
// Forms:
//
//	PMINSB m128 xmm
//	PMINSB xmm  xmm
//
// Construct and append a PMINSB instruction to the active function.
// Operates on the global context.
func PMINSB(mx, x operand.Op) { ctx.PMINSB(mx, x) }

// PMINSD: Minimum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMINSD m128 xmm
//	PMINSD xmm  xmm
//
// Construct and append a PMINSD instruction to the active function.
func (c *Context) PMINSD(mx, x operand.Op) {
	c.addinstruction(x86.PMINSD(mx, x))
}

// PMINSD: Minimum of Packed Signed Doubleword Integers.
//
// Forms:
//
//	PMINSD m128 xmm
//	PMINSD xmm  xmm
//
// Construct and append a PMINSD instruction to the active function.
// Operates on the global context.
func PMINSD(mx, x operand.Op) { ctx.PMINSD(mx, x) }

// PMINSW: Minimum of Packed Signed Word Integers.
//
// Forms:
//
//	PMINSW m128 xmm
//	PMINSW xmm  xmm
//
// Construct and append a PMINSW instruction to the active function.
func (c *Context) PMINSW(mx, x operand.Op) {
	c.addinstruction(x86.PMINSW(mx, x))
}

// PMINSW: Minimum of Packed Signed Word Integers.
//
// Forms:
//
//	PMINSW m128 xmm
//	PMINSW xmm  xmm
//
// Construct and append a PMINSW instruction to the active function.
// Operates on the global context.
func PMINSW(mx, x operand.Op) { ctx.PMINSW(mx, x) }

// PMINUB: Minimum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMINUB m128 xmm
//	PMINUB xmm  xmm
//
// Construct and append a PMINUB instruction to the active function.
func (c *Context) PMINUB(mx, x operand.Op) {
	c.addinstruction(x86.PMINUB(mx, x))
}

// PMINUB: Minimum of Packed Unsigned Byte Integers.
//
// Forms:
//
//	PMINUB m128 xmm
//	PMINUB xmm  xmm
//
// Construct and append a PMINUB instruction to the active function.
// Operates on the global context.
func PMINUB(mx, x operand.Op) { ctx.PMINUB(mx, x) }

// PMINUD: Minimum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMINUD m128 xmm
//	PMINUD xmm  xmm
//
// Construct and append a PMINUD instruction to the active function.
func (c *Context) PMINUD(mx, x operand.Op) {
	c.addinstruction(x86.PMINUD(mx, x))
}

// PMINUD: Minimum of Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMINUD m128 xmm
//	PMINUD xmm  xmm
//
// Construct and append a PMINUD instruction to the active function.
// Operates on the global context.
func PMINUD(mx, x operand.Op) { ctx.PMINUD(mx, x) }

// PMINUW: Minimum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMINUW m128 xmm
//	PMINUW xmm  xmm
//
// Construct and append a PMINUW instruction to the active function.
func (c *Context) PMINUW(mx, x operand.Op) {
	c.addinstruction(x86.PMINUW(mx, x))
}

// PMINUW: Minimum of Packed Unsigned Word Integers.
//
// Forms:
//
//	PMINUW m128 xmm
//	PMINUW xmm  xmm
//
// Construct and append a PMINUW instruction to the active function.
// Operates on the global context.
func PMINUW(mx, x operand.Op) { ctx.PMINUW(mx, x) }

// PMOVMSKB: Move Byte Mask.
//
// Forms:
//
//	PMOVMSKB xmm r32
//
// Construct and append a PMOVMSKB instruction to the active function.
func (c *Context) PMOVMSKB(x, r operand.Op) {
	c.addinstruction(x86.PMOVMSKB(x, r))
}

// PMOVMSKB: Move Byte Mask.
//
// Forms:
//
//	PMOVMSKB xmm r32
//
// Construct and append a PMOVMSKB instruction to the active function.
// Operates on the global context.
func PMOVMSKB(x, r operand.Op) { ctx.PMOVMSKB(x, r) }

// PMOVSXBD: Move Packed Byte Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBD m32 xmm
//	PMOVSXBD xmm xmm
//
// Construct and append a PMOVSXBD instruction to the active function.
func (c *Context) PMOVSXBD(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXBD(mx, x))
}

// PMOVSXBD: Move Packed Byte Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBD m32 xmm
//	PMOVSXBD xmm xmm
//
// Construct and append a PMOVSXBD instruction to the active function.
// Operates on the global context.
func PMOVSXBD(mx, x operand.Op) { ctx.PMOVSXBD(mx, x) }

// PMOVSXBQ: Move Packed Byte Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBQ m16 xmm
//	PMOVSXBQ xmm xmm
//
// Construct and append a PMOVSXBQ instruction to the active function.
func (c *Context) PMOVSXBQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXBQ(mx, x))
}

// PMOVSXBQ: Move Packed Byte Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBQ m16 xmm
//	PMOVSXBQ xmm xmm
//
// Construct and append a PMOVSXBQ instruction to the active function.
// Operates on the global context.
func PMOVSXBQ(mx, x operand.Op) { ctx.PMOVSXBQ(mx, x) }

// PMOVSXBW: Move Packed Byte Integers to Word Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBW m64 xmm
//	PMOVSXBW xmm xmm
//
// Construct and append a PMOVSXBW instruction to the active function.
func (c *Context) PMOVSXBW(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXBW(mx, x))
}

// PMOVSXBW: Move Packed Byte Integers to Word Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXBW m64 xmm
//	PMOVSXBW xmm xmm
//
// Construct and append a PMOVSXBW instruction to the active function.
// Operates on the global context.
func PMOVSXBW(mx, x operand.Op) { ctx.PMOVSXBW(mx, x) }

// PMOVSXDQ: Move Packed Doubleword Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXDQ m64 xmm
//	PMOVSXDQ xmm xmm
//
// Construct and append a PMOVSXDQ instruction to the active function.
func (c *Context) PMOVSXDQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXDQ(mx, x))
}

// PMOVSXDQ: Move Packed Doubleword Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXDQ m64 xmm
//	PMOVSXDQ xmm xmm
//
// Construct and append a PMOVSXDQ instruction to the active function.
// Operates on the global context.
func PMOVSXDQ(mx, x operand.Op) { ctx.PMOVSXDQ(mx, x) }

// PMOVSXWD: Move Packed Word Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWD m64 xmm
//	PMOVSXWD xmm xmm
//
// Construct and append a PMOVSXWD instruction to the active function.
func (c *Context) PMOVSXWD(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXWD(mx, x))
}

// PMOVSXWD: Move Packed Word Integers to Doubleword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWD m64 xmm
//	PMOVSXWD xmm xmm
//
// Construct and append a PMOVSXWD instruction to the active function.
// Operates on the global context.
func PMOVSXWD(mx, x operand.Op) { ctx.PMOVSXWD(mx, x) }

// PMOVSXWQ: Move Packed Word Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWQ m32 xmm
//	PMOVSXWQ xmm xmm
//
// Construct and append a PMOVSXWQ instruction to the active function.
func (c *Context) PMOVSXWQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVSXWQ(mx, x))
}

// PMOVSXWQ: Move Packed Word Integers to Quadword Integers with Sign Extension.
//
// Forms:
//
//	PMOVSXWQ m32 xmm
//	PMOVSXWQ xmm xmm
//
// Construct and append a PMOVSXWQ instruction to the active function.
// Operates on the global context.
func PMOVSXWQ(mx, x operand.Op) { ctx.PMOVSXWQ(mx, x) }

// PMOVZXBD: Move Packed Byte Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBD m32 xmm
//	PMOVZXBD xmm xmm
//
// Construct and append a PMOVZXBD instruction to the active function.
func (c *Context) PMOVZXBD(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXBD(mx, x))
}

// PMOVZXBD: Move Packed Byte Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBD m32 xmm
//	PMOVZXBD xmm xmm
//
// Construct and append a PMOVZXBD instruction to the active function.
// Operates on the global context.
func PMOVZXBD(mx, x operand.Op) { ctx.PMOVZXBD(mx, x) }

// PMOVZXBQ: Move Packed Byte Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBQ m16 xmm
//	PMOVZXBQ xmm xmm
//
// Construct and append a PMOVZXBQ instruction to the active function.
func (c *Context) PMOVZXBQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXBQ(mx, x))
}

// PMOVZXBQ: Move Packed Byte Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBQ m16 xmm
//	PMOVZXBQ xmm xmm
//
// Construct and append a PMOVZXBQ instruction to the active function.
// Operates on the global context.
func PMOVZXBQ(mx, x operand.Op) { ctx.PMOVZXBQ(mx, x) }

// PMOVZXBW: Move Packed Byte Integers to Word Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBW m64 xmm
//	PMOVZXBW xmm xmm
//
// Construct and append a PMOVZXBW instruction to the active function.
func (c *Context) PMOVZXBW(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXBW(mx, x))
}

// PMOVZXBW: Move Packed Byte Integers to Word Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXBW m64 xmm
//	PMOVZXBW xmm xmm
//
// Construct and append a PMOVZXBW instruction to the active function.
// Operates on the global context.
func PMOVZXBW(mx, x operand.Op) { ctx.PMOVZXBW(mx, x) }

// PMOVZXDQ: Move Packed Doubleword Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXDQ m64 xmm
//	PMOVZXDQ xmm xmm
//
// Construct and append a PMOVZXDQ instruction to the active function.
func (c *Context) PMOVZXDQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXDQ(mx, x))
}

// PMOVZXDQ: Move Packed Doubleword Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXDQ m64 xmm
//	PMOVZXDQ xmm xmm
//
// Construct and append a PMOVZXDQ instruction to the active function.
// Operates on the global context.
func PMOVZXDQ(mx, x operand.Op) { ctx.PMOVZXDQ(mx, x) }

// PMOVZXWD: Move Packed Word Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWD m64 xmm
//	PMOVZXWD xmm xmm
//
// Construct and append a PMOVZXWD instruction to the active function.
func (c *Context) PMOVZXWD(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXWD(mx, x))
}

// PMOVZXWD: Move Packed Word Integers to Doubleword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWD m64 xmm
//	PMOVZXWD xmm xmm
//
// Construct and append a PMOVZXWD instruction to the active function.
// Operates on the global context.
func PMOVZXWD(mx, x operand.Op) { ctx.PMOVZXWD(mx, x) }

// PMOVZXWQ: Move Packed Word Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWQ m32 xmm
//	PMOVZXWQ xmm xmm
//
// Construct and append a PMOVZXWQ instruction to the active function.
func (c *Context) PMOVZXWQ(mx, x operand.Op) {
	c.addinstruction(x86.PMOVZXWQ(mx, x))
}

// PMOVZXWQ: Move Packed Word Integers to Quadword Integers with Zero Extension.
//
// Forms:
//
//	PMOVZXWQ m32 xmm
//	PMOVZXWQ xmm xmm
//
// Construct and append a PMOVZXWQ instruction to the active function.
// Operates on the global context.
func PMOVZXWQ(mx, x operand.Op) { ctx.PMOVZXWQ(mx, x) }

// PMULDQ: Multiply Packed Signed Doubleword Integers and Store Quadword Result.
//
// Forms:
//
//	PMULDQ m128 xmm
//	PMULDQ xmm  xmm
//
// Construct and append a PMULDQ instruction to the active function.
func (c *Context) PMULDQ(mx, x operand.Op) {
	c.addinstruction(x86.PMULDQ(mx, x))
}

// PMULDQ: Multiply Packed Signed Doubleword Integers and Store Quadword Result.
//
// Forms:
//
//	PMULDQ m128 xmm
//	PMULDQ xmm  xmm
//
// Construct and append a PMULDQ instruction to the active function.
// Operates on the global context.
func PMULDQ(mx, x operand.Op) { ctx.PMULDQ(mx, x) }

// PMULHRSW: Packed Multiply Signed Word Integers and Store High Result with Round and Scale.
//
// Forms:
//
//	PMULHRSW m128 xmm
//	PMULHRSW xmm  xmm
//
// Construct and append a PMULHRSW instruction to the active function.
func (c *Context) PMULHRSW(mx, x operand.Op) {
	c.addinstruction(x86.PMULHRSW(mx, x))
}

// PMULHRSW: Packed Multiply Signed Word Integers and Store High Result with Round and Scale.
//
// Forms:
//
//	PMULHRSW m128 xmm
//	PMULHRSW xmm  xmm
//
// Construct and append a PMULHRSW instruction to the active function.
// Operates on the global context.
func PMULHRSW(mx, x operand.Op) { ctx.PMULHRSW(mx, x) }

// PMULHUW: Multiply Packed Unsigned Word Integers and Store High Result.
//
// Forms:
//
//	PMULHUW m128 xmm
//	PMULHUW xmm  xmm
//
// Construct and append a PMULHUW instruction to the active function.
func (c *Context) PMULHUW(mx, x operand.Op) {
	c.addinstruction(x86.PMULHUW(mx, x))
}

// PMULHUW: Multiply Packed Unsigned Word Integers and Store High Result.
//
// Forms:
//
//	PMULHUW m128 xmm
//	PMULHUW xmm  xmm
//
// Construct and append a PMULHUW instruction to the active function.
// Operates on the global context.
func PMULHUW(mx, x operand.Op) { ctx.PMULHUW(mx, x) }

// PMULHW: Multiply Packed Signed Word Integers and Store High Result.
//
// Forms:
//
//	PMULHW m128 xmm
//	PMULHW xmm  xmm
//
// Construct and append a PMULHW instruction to the active function.
func (c *Context) PMULHW(mx, x operand.Op) {
	c.addinstruction(x86.PMULHW(mx, x))
}

// PMULHW: Multiply Packed Signed Word Integers and Store High Result.
//
// Forms:
//
//	PMULHW m128 xmm
//	PMULHW xmm  xmm
//
// Construct and append a PMULHW instruction to the active function.
// Operates on the global context.
func PMULHW(mx, x operand.Op) { ctx.PMULHW(mx, x) }

// PMULLD: Multiply Packed Signed Doubleword Integers and Store Low Result.
//
// Forms:
//
//	PMULLD m128 xmm
//	PMULLD xmm  xmm
//
// Construct and append a PMULLD instruction to the active function.
func (c *Context) PMULLD(mx, x operand.Op) {
	c.addinstruction(x86.PMULLD(mx, x))
}

// PMULLD: Multiply Packed Signed Doubleword Integers and Store Low Result.
//
// Forms:
//
//	PMULLD m128 xmm
//	PMULLD xmm  xmm
//
// Construct and append a PMULLD instruction to the active function.
// Operates on the global context.
func PMULLD(mx, x operand.Op) { ctx.PMULLD(mx, x) }

// PMULLW: Multiply Packed Signed Word Integers and Store Low Result.
//
// Forms:
//
//	PMULLW m128 xmm
//	PMULLW xmm  xmm
//
// Construct and append a PMULLW instruction to the active function.
func (c *Context) PMULLW(mx, x operand.Op) {
	c.addinstruction(x86.PMULLW(mx, x))
}

// PMULLW: Multiply Packed Signed Word Integers and Store Low Result.
//
// Forms:
//
//	PMULLW m128 xmm
//	PMULLW xmm  xmm
//
// Construct and append a PMULLW instruction to the active function.
// Operates on the global context.
func PMULLW(mx, x operand.Op) { ctx.PMULLW(mx, x) }

// PMULULQ: Multiply Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMULULQ m128 xmm
//	PMULULQ xmm  xmm
//
// Construct and append a PMULULQ instruction to the active function.
func (c *Context) PMULULQ(mx, x operand.Op) {
	c.addinstruction(x86.PMULULQ(mx, x))
}

// PMULULQ: Multiply Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	PMULULQ m128 xmm
//	PMULULQ xmm  xmm
//
// Construct and append a PMULULQ instruction to the active function.
// Operates on the global context.
func PMULULQ(mx, x operand.Op) { ctx.PMULULQ(mx, x) }

// POPCNTL: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTL m32 r32
//	POPCNTL r32 r32
//
// Construct and append a POPCNTL instruction to the active function.
func (c *Context) POPCNTL(mr, r operand.Op) {
	c.addinstruction(x86.POPCNTL(mr, r))
}

// POPCNTL: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTL m32 r32
//	POPCNTL r32 r32
//
// Construct and append a POPCNTL instruction to the active function.
// Operates on the global context.
func POPCNTL(mr, r operand.Op) { ctx.POPCNTL(mr, r) }

// POPCNTQ: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTQ m64 r64
//	POPCNTQ r64 r64
//
// Construct and append a POPCNTQ instruction to the active function.
func (c *Context) POPCNTQ(mr, r operand.Op) {
	c.addinstruction(x86.POPCNTQ(mr, r))
}

// POPCNTQ: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTQ m64 r64
//	POPCNTQ r64 r64
//
// Construct and append a POPCNTQ instruction to the active function.
// Operates on the global context.
func POPCNTQ(mr, r operand.Op) { ctx.POPCNTQ(mr, r) }

// POPCNTW: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTW m16 r16
//	POPCNTW r16 r16
//
// Construct and append a POPCNTW instruction to the active function.
func (c *Context) POPCNTW(mr, r operand.Op) {
	c.addinstruction(x86.POPCNTW(mr, r))
}

// POPCNTW: Count of Number of Bits Set to 1.
//
// Forms:
//
//	POPCNTW m16 r16
//	POPCNTW r16 r16
//
// Construct and append a POPCNTW instruction to the active function.
// Operates on the global context.
func POPCNTW(mr, r operand.Op) { ctx.POPCNTW(mr, r) }

// POPQ: Pop a Value from the Stack.
//
// Forms:
//
//	POPQ m64
//	POPQ r64
//
// Construct and append a POPQ instruction to the active function.
func (c *Context) POPQ(mr operand.Op) {
	c.addinstruction(x86.POPQ(mr))
}

// POPQ: Pop a Value from the Stack.
//
// Forms:
//
//	POPQ m64
//	POPQ r64
//
// Construct and append a POPQ instruction to the active function.
// Operates on the global context.
func POPQ(mr operand.Op) { ctx.POPQ(mr) }

// POPW: Pop a Value from the Stack.
//
// Forms:
//
//	POPW m16
//	POPW r16
//
// Construct and append a POPW instruction to the active function.
func (c *Context) POPW(mr operand.Op) {
	c.addinstruction(x86.POPW(mr))
}

// POPW: Pop a Value from the Stack.
//
// Forms:
//
//	POPW m16
//	POPW r16
//
// Construct and append a POPW instruction to the active function.
// Operates on the global context.
func POPW(mr operand.Op) { ctx.POPW(mr) }

// POR: Packed Bitwise Logical OR.
//
// Forms:
//
//	POR m128 xmm
//	POR xmm  xmm
//
// Construct and append a POR instruction to the active function.
func (c *Context) POR(mx, x operand.Op) {
	c.addinstruction(x86.POR(mx, x))
}

// POR: Packed Bitwise Logical OR.
//
// Forms:
//
//	POR m128 xmm
//	POR xmm  xmm
//
// Construct and append a POR instruction to the active function.
// Operates on the global context.
func POR(mx, x operand.Op) { ctx.POR(mx, x) }

// PREFETCHNTA: Prefetch Data Into Caches using NTA Hint.
//
// Forms:
//
//	PREFETCHNTA m8
//
// Construct and append a PREFETCHNTA instruction to the active function.
func (c *Context) PREFETCHNTA(m operand.Op) {
	c.addinstruction(x86.PREFETCHNTA(m))
}

// PREFETCHNTA: Prefetch Data Into Caches using NTA Hint.
//
// Forms:
//
//	PREFETCHNTA m8
//
// Construct and append a PREFETCHNTA instruction to the active function.
// Operates on the global context.
func PREFETCHNTA(m operand.Op) { ctx.PREFETCHNTA(m) }

// PREFETCHT0: Prefetch Data Into Caches using T0 Hint.
//
// Forms:
//
//	PREFETCHT0 m8
//
// Construct and append a PREFETCHT0 instruction to the active function.
func (c *Context) PREFETCHT0(m operand.Op) {
	c.addinstruction(x86.PREFETCHT0(m))
}

// PREFETCHT0: Prefetch Data Into Caches using T0 Hint.
//
// Forms:
//
//	PREFETCHT0 m8
//
// Construct and append a PREFETCHT0 instruction to the active function.
// Operates on the global context.
func PREFETCHT0(m operand.Op) { ctx.PREFETCHT0(m) }

// PREFETCHT1: Prefetch Data Into Caches using T1 Hint.
//
// Forms:
//
//	PREFETCHT1 m8
//
// Construct and append a PREFETCHT1 instruction to the active function.
func (c *Context) PREFETCHT1(m operand.Op) {
	c.addinstruction(x86.PREFETCHT1(m))
}

// PREFETCHT1: Prefetch Data Into Caches using T1 Hint.
//
// Forms:
//
//	PREFETCHT1 m8
//
// Construct and append a PREFETCHT1 instruction to the active function.
// Operates on the global context.
func PREFETCHT1(m operand.Op) { ctx.PREFETCHT1(m) }

// PREFETCHT2: Prefetch Data Into Caches using T2 Hint.
//
// Forms:
//
//	PREFETCHT2 m8
//
// Construct and append a PREFETCHT2 instruction to the active function.
func (c *Context) PREFETCHT2(m operand.Op) {
	c.addinstruction(x86.PREFETCHT2(m))
}

// PREFETCHT2: Prefetch Data Into Caches using T2 Hint.
//
// Forms:
//
//	PREFETCHT2 m8
//
// Construct and append a PREFETCHT2 instruction to the active function.
// Operates on the global context.
func PREFETCHT2(m operand.Op) { ctx.PREFETCHT2(m) }

// PSADBW: Compute Sum of Absolute Differences.
//
// Forms:
//
//	PSADBW m128 xmm
//	PSADBW xmm  xmm
//
// Construct and append a PSADBW instruction to the active function.
func (c *Context) PSADBW(mx, x operand.Op) {
	c.addinstruction(x86.PSADBW(mx, x))
}

// PSADBW: Compute Sum of Absolute Differences.
//
// Forms:
//
//	PSADBW m128 xmm
//	PSADBW xmm  xmm
//
// Construct and append a PSADBW instruction to the active function.
// Operates on the global context.
func PSADBW(mx, x operand.Op) { ctx.PSADBW(mx, x) }

// PSHUFB: Packed Shuffle Bytes.
//
// Forms:
//
//	PSHUFB m128 xmm
//	PSHUFB xmm  xmm
//
// Construct and append a PSHUFB instruction to the active function.
func (c *Context) PSHUFB(mx, x operand.Op) {
	c.addinstruction(x86.PSHUFB(mx, x))
}

// PSHUFB: Packed Shuffle Bytes.
//
// Forms:
//
//	PSHUFB m128 xmm
//	PSHUFB xmm  xmm
//
// Construct and append a PSHUFB instruction to the active function.
// Operates on the global context.
func PSHUFB(mx, x operand.Op) { ctx.PSHUFB(mx, x) }

// PSHUFD: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFD imm8 m128 xmm
//	PSHUFD imm8 xmm  xmm
//
// Construct and append a PSHUFD instruction to the active function.
func (c *Context) PSHUFD(i, mx, x operand.Op) {
	c.addinstruction(x86.PSHUFD(i, mx, x))
}

// PSHUFD: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFD imm8 m128 xmm
//	PSHUFD imm8 xmm  xmm
//
// Construct and append a PSHUFD instruction to the active function.
// Operates on the global context.
func PSHUFD(i, mx, x operand.Op) { ctx.PSHUFD(i, mx, x) }

// PSHUFHW: Shuffle Packed High Words.
//
// Forms:
//
//	PSHUFHW imm8 m128 xmm
//	PSHUFHW imm8 xmm  xmm
//
// Construct and append a PSHUFHW instruction to the active function.
func (c *Context) PSHUFHW(i, mx, x operand.Op) {
	c.addinstruction(x86.PSHUFHW(i, mx, x))
}

// PSHUFHW: Shuffle Packed High Words.
//
// Forms:
//
//	PSHUFHW imm8 m128 xmm
//	PSHUFHW imm8 xmm  xmm
//
// Construct and append a PSHUFHW instruction to the active function.
// Operates on the global context.
func PSHUFHW(i, mx, x operand.Op) { ctx.PSHUFHW(i, mx, x) }

// PSHUFL: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFL imm8 m128 xmm
//	PSHUFL imm8 xmm  xmm
//
// Construct and append a PSHUFL instruction to the active function.
func (c *Context) PSHUFL(i, mx, x operand.Op) {
	c.addinstruction(x86.PSHUFL(i, mx, x))
}

// PSHUFL: Shuffle Packed Doublewords.
//
// Forms:
//
//	PSHUFL imm8 m128 xmm
//	PSHUFL imm8 xmm  xmm
//
// Construct and append a PSHUFL instruction to the active function.
// Operates on the global context.
func PSHUFL(i, mx, x operand.Op) { ctx.PSHUFL(i, mx, x) }

// PSHUFLW: Shuffle Packed Low Words.
//
// Forms:
//
//	PSHUFLW imm8 m128 xmm
//	PSHUFLW imm8 xmm  xmm
//
// Construct and append a PSHUFLW instruction to the active function.
func (c *Context) PSHUFLW(i, mx, x operand.Op) {
	c.addinstruction(x86.PSHUFLW(i, mx, x))
}

// PSHUFLW: Shuffle Packed Low Words.
//
// Forms:
//
//	PSHUFLW imm8 m128 xmm
//	PSHUFLW imm8 xmm  xmm
//
// Construct and append a PSHUFLW instruction to the active function.
// Operates on the global context.
func PSHUFLW(i, mx, x operand.Op) { ctx.PSHUFLW(i, mx, x) }

// PSIGNB: Packed Sign of Byte Integers.
//
// Forms:
//
//	PSIGNB m128 xmm
//	PSIGNB xmm  xmm
//
// Construct and append a PSIGNB instruction to the active function.
func (c *Context) PSIGNB(mx, x operand.Op) {
	c.addinstruction(x86.PSIGNB(mx, x))
}

// PSIGNB: Packed Sign of Byte Integers.
//
// Forms:
//
//	PSIGNB m128 xmm
//	PSIGNB xmm  xmm
//
// Construct and append a PSIGNB instruction to the active function.
// Operates on the global context.
func PSIGNB(mx, x operand.Op) { ctx.PSIGNB(mx, x) }

// PSIGND: Packed Sign of Doubleword Integers.
//
// Forms:
//
//	PSIGND m128 xmm
//	PSIGND xmm  xmm
//
// Construct and append a PSIGND instruction to the active function.
func (c *Context) PSIGND(mx, x operand.Op) {
	c.addinstruction(x86.PSIGND(mx, x))
}

// PSIGND: Packed Sign of Doubleword Integers.
//
// Forms:
//
//	PSIGND m128 xmm
//	PSIGND xmm  xmm
//
// Construct and append a PSIGND instruction to the active function.
// Operates on the global context.
func PSIGND(mx, x operand.Op) { ctx.PSIGND(mx, x) }

// PSIGNW: Packed Sign of Word Integers.
//
// Forms:
//
//	PSIGNW m128 xmm
//	PSIGNW xmm  xmm
//
// Construct and append a PSIGNW instruction to the active function.
func (c *Context) PSIGNW(mx, x operand.Op) {
	c.addinstruction(x86.PSIGNW(mx, x))
}

// PSIGNW: Packed Sign of Word Integers.
//
// Forms:
//
//	PSIGNW m128 xmm
//	PSIGNW xmm  xmm
//
// Construct and append a PSIGNW instruction to the active function.
// Operates on the global context.
func PSIGNW(mx, x operand.Op) { ctx.PSIGNW(mx, x) }

// PSLLDQ: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLDQ imm8 xmm
//
// Construct and append a PSLLDQ instruction to the active function.
func (c *Context) PSLLDQ(i, x operand.Op) {
	c.addinstruction(x86.PSLLDQ(i, x))
}

// PSLLDQ: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLDQ imm8 xmm
//
// Construct and append a PSLLDQ instruction to the active function.
// Operates on the global context.
func PSLLDQ(i, x operand.Op) { ctx.PSLLDQ(i, x) }

// PSLLL: Shift Packed Doubleword Data Left Logical.
//
// Forms:
//
//	PSLLL imm8 xmm
//	PSLLL m128 xmm
//	PSLLL xmm  xmm
//
// Construct and append a PSLLL instruction to the active function.
func (c *Context) PSLLL(imx, x operand.Op) {
	c.addinstruction(x86.PSLLL(imx, x))
}

// PSLLL: Shift Packed Doubleword Data Left Logical.
//
// Forms:
//
//	PSLLL imm8 xmm
//	PSLLL m128 xmm
//	PSLLL xmm  xmm
//
// Construct and append a PSLLL instruction to the active function.
// Operates on the global context.
func PSLLL(imx, x operand.Op) { ctx.PSLLL(imx, x) }

// PSLLO: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLO imm8 xmm
//
// Construct and append a PSLLO instruction to the active function.
func (c *Context) PSLLO(i, x operand.Op) {
	c.addinstruction(x86.PSLLO(i, x))
}

// PSLLO: Shift Packed Double Quadword Left Logical.
//
// Forms:
//
//	PSLLO imm8 xmm
//
// Construct and append a PSLLO instruction to the active function.
// Operates on the global context.
func PSLLO(i, x operand.Op) { ctx.PSLLO(i, x) }

// PSLLQ: Shift Packed Quadword Data Left Logical.
//
// Forms:
//
//	PSLLQ imm8 xmm
//	PSLLQ m128 xmm
//	PSLLQ xmm  xmm
//
// Construct and append a PSLLQ instruction to the active function.
func (c *Context) PSLLQ(imx, x operand.Op) {
	c.addinstruction(x86.PSLLQ(imx, x))
}

// PSLLQ: Shift Packed Quadword Data Left Logical.
//
// Forms:
//
//	PSLLQ imm8 xmm
//	PSLLQ m128 xmm
//	PSLLQ xmm  xmm
//
// Construct and append a PSLLQ instruction to the active function.
// Operates on the global context.
func PSLLQ(imx, x operand.Op) { ctx.PSLLQ(imx, x) }

// PSLLW: Shift Packed Word Data Left Logical.
//
// Forms:
//
//	PSLLW imm8 xmm
//	PSLLW m128 xmm
//	PSLLW xmm  xmm
//
// Construct and append a PSLLW instruction to the active function.
func (c *Context) PSLLW(imx, x operand.Op) {
	c.addinstruction(x86.PSLLW(imx, x))
}

// PSLLW: Shift Packed Word Data Left Logical.
//
// Forms:
//
//	PSLLW imm8 xmm
//	PSLLW m128 xmm
//	PSLLW xmm  xmm
//
// Construct and append a PSLLW instruction to the active function.
// Operates on the global context.
func PSLLW(imx, x operand.Op) { ctx.PSLLW(imx, x) }

// PSRAL: Shift Packed Doubleword Data Right Arithmetic.
//
// Forms:
//
//	PSRAL imm8 xmm
//	PSRAL m128 xmm
//	PSRAL xmm  xmm
//
// Construct and append a PSRAL instruction to the active function.
func (c *Context) PSRAL(imx, x operand.Op) {
	c.addinstruction(x86.PSRAL(imx, x))
}

// PSRAL: Shift Packed Doubleword Data Right Arithmetic.
//
// Forms:
//
//	PSRAL imm8 xmm
//	PSRAL m128 xmm
//	PSRAL xmm  xmm
//
// Construct and append a PSRAL instruction to the active function.
// Operates on the global context.
func PSRAL(imx, x operand.Op) { ctx.PSRAL(imx, x) }

// PSRAW: Shift Packed Word Data Right Arithmetic.
//
// Forms:
//
//	PSRAW imm8 xmm
//	PSRAW m128 xmm
//	PSRAW xmm  xmm
//
// Construct and append a PSRAW instruction to the active function.
func (c *Context) PSRAW(imx, x operand.Op) {
	c.addinstruction(x86.PSRAW(imx, x))
}

// PSRAW: Shift Packed Word Data Right Arithmetic.
//
// Forms:
//
//	PSRAW imm8 xmm
//	PSRAW m128 xmm
//	PSRAW xmm  xmm
//
// Construct and append a PSRAW instruction to the active function.
// Operates on the global context.
func PSRAW(imx, x operand.Op) { ctx.PSRAW(imx, x) }

// PSRLDQ: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLDQ imm8 xmm
//
// Construct and append a PSRLDQ instruction to the active function.
func (c *Context) PSRLDQ(i, x operand.Op) {
	c.addinstruction(x86.PSRLDQ(i, x))
}

// PSRLDQ: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLDQ imm8 xmm
//
// Construct and append a PSRLDQ instruction to the active function.
// Operates on the global context.
func PSRLDQ(i, x operand.Op) { ctx.PSRLDQ(i, x) }

// PSRLL: Shift Packed Doubleword Data Right Logical.
//
// Forms:
//
//	PSRLL imm8 xmm
//	PSRLL m128 xmm
//	PSRLL xmm  xmm
//
// Construct and append a PSRLL instruction to the active function.
func (c *Context) PSRLL(imx, x operand.Op) {
	c.addinstruction(x86.PSRLL(imx, x))
}

// PSRLL: Shift Packed Doubleword Data Right Logical.
//
// Forms:
//
//	PSRLL imm8 xmm
//	PSRLL m128 xmm
//	PSRLL xmm  xmm
//
// Construct and append a PSRLL instruction to the active function.
// Operates on the global context.
func PSRLL(imx, x operand.Op) { ctx.PSRLL(imx, x) }

// PSRLO: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLO imm8 xmm
//
// Construct and append a PSRLO instruction to the active function.
func (c *Context) PSRLO(i, x operand.Op) {
	c.addinstruction(x86.PSRLO(i, x))
}

// PSRLO: Shift Packed Double Quadword Right Logical.
//
// Forms:
//
//	PSRLO imm8 xmm
//
// Construct and append a PSRLO instruction to the active function.
// Operates on the global context.
func PSRLO(i, x operand.Op) { ctx.PSRLO(i, x) }

// PSRLQ: Shift Packed Quadword Data Right Logical.
//
// Forms:
//
//	PSRLQ imm8 xmm
//	PSRLQ m128 xmm
//	PSRLQ xmm  xmm
//
// Construct and append a PSRLQ instruction to the active function.
func (c *Context) PSRLQ(imx, x operand.Op) {
	c.addinstruction(x86.PSRLQ(imx, x))
}

// PSRLQ: Shift Packed Quadword Data Right Logical.
//
// Forms:
//
//	PSRLQ imm8 xmm
//	PSRLQ m128 xmm
//	PSRLQ xmm  xmm
//
// Construct and append a PSRLQ instruction to the active function.
// Operates on the global context.
func PSRLQ(imx, x operand.Op) { ctx.PSRLQ(imx, x) }

// PSRLW: Shift Packed Word Data Right Logical.
//
// Forms:
//
//	PSRLW imm8 xmm
//	PSRLW m128 xmm
//	PSRLW xmm  xmm
//
// Construct and append a PSRLW instruction to the active function.
func (c *Context) PSRLW(imx, x operand.Op) {
	c.addinstruction(x86.PSRLW(imx, x))
}

// PSRLW: Shift Packed Word Data Right Logical.
//
// Forms:
//
//	PSRLW imm8 xmm
//	PSRLW m128 xmm
//	PSRLW xmm  xmm
//
// Construct and append a PSRLW instruction to the active function.
// Operates on the global context.
func PSRLW(imx, x operand.Op) { ctx.PSRLW(imx, x) }

// PSUBB: Subtract Packed Byte Integers.
//
// Forms:
//
//	PSUBB m128 xmm
//	PSUBB xmm  xmm
//
// Construct and append a PSUBB instruction to the active function.
func (c *Context) PSUBB(mx, x operand.Op) {
	c.addinstruction(x86.PSUBB(mx, x))
}

// PSUBB: Subtract Packed Byte Integers.
//
// Forms:
//
//	PSUBB m128 xmm
//	PSUBB xmm  xmm
//
// Construct and append a PSUBB instruction to the active function.
// Operates on the global context.
func PSUBB(mx, x operand.Op) { ctx.PSUBB(mx, x) }

// PSUBL: Subtract Packed Doubleword Integers.
//
// Forms:
//
//	PSUBL m128 xmm
//	PSUBL xmm  xmm
//
// Construct and append a PSUBL instruction to the active function.
func (c *Context) PSUBL(mx, x operand.Op) {
	c.addinstruction(x86.PSUBL(mx, x))
}

// PSUBL: Subtract Packed Doubleword Integers.
//
// Forms:
//
//	PSUBL m128 xmm
//	PSUBL xmm  xmm
//
// Construct and append a PSUBL instruction to the active function.
// Operates on the global context.
func PSUBL(mx, x operand.Op) { ctx.PSUBL(mx, x) }

// PSUBQ: Subtract Packed Quadword Integers.
//
// Forms:
//
//	PSUBQ m128 xmm
//	PSUBQ xmm  xmm
//
// Construct and append a PSUBQ instruction to the active function.
func (c *Context) PSUBQ(mx, x operand.Op) {
	c.addinstruction(x86.PSUBQ(mx, x))
}

// PSUBQ: Subtract Packed Quadword Integers.
//
// Forms:
//
//	PSUBQ m128 xmm
//	PSUBQ xmm  xmm
//
// Construct and append a PSUBQ instruction to the active function.
// Operates on the global context.
func PSUBQ(mx, x operand.Op) { ctx.PSUBQ(mx, x) }

// PSUBSB: Subtract Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSB m128 xmm
//	PSUBSB xmm  xmm
//
// Construct and append a PSUBSB instruction to the active function.
func (c *Context) PSUBSB(mx, x operand.Op) {
	c.addinstruction(x86.PSUBSB(mx, x))
}

// PSUBSB: Subtract Packed Signed Byte Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSB m128 xmm
//	PSUBSB xmm  xmm
//
// Construct and append a PSUBSB instruction to the active function.
// Operates on the global context.
func PSUBSB(mx, x operand.Op) { ctx.PSUBSB(mx, x) }

// PSUBSW: Subtract Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSW m128 xmm
//	PSUBSW xmm  xmm
//
// Construct and append a PSUBSW instruction to the active function.
func (c *Context) PSUBSW(mx, x operand.Op) {
	c.addinstruction(x86.PSUBSW(mx, x))
}

// PSUBSW: Subtract Packed Signed Word Integers with Signed Saturation.
//
// Forms:
//
//	PSUBSW m128 xmm
//	PSUBSW xmm  xmm
//
// Construct and append a PSUBSW instruction to the active function.
// Operates on the global context.
func PSUBSW(mx, x operand.Op) { ctx.PSUBSW(mx, x) }

// PSUBUSB: Subtract Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSB m128 xmm
//	PSUBUSB xmm  xmm
//
// Construct and append a PSUBUSB instruction to the active function.
func (c *Context) PSUBUSB(mx, x operand.Op) {
	c.addinstruction(x86.PSUBUSB(mx, x))
}

// PSUBUSB: Subtract Packed Unsigned Byte Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSB m128 xmm
//	PSUBUSB xmm  xmm
//
// Construct and append a PSUBUSB instruction to the active function.
// Operates on the global context.
func PSUBUSB(mx, x operand.Op) { ctx.PSUBUSB(mx, x) }

// PSUBUSW: Subtract Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSW m128 xmm
//	PSUBUSW xmm  xmm
//
// Construct and append a PSUBUSW instruction to the active function.
func (c *Context) PSUBUSW(mx, x operand.Op) {
	c.addinstruction(x86.PSUBUSW(mx, x))
}

// PSUBUSW: Subtract Packed Unsigned Word Integers with Unsigned Saturation.
//
// Forms:
//
//	PSUBUSW m128 xmm
//	PSUBUSW xmm  xmm
//
// Construct and append a PSUBUSW instruction to the active function.
// Operates on the global context.
func PSUBUSW(mx, x operand.Op) { ctx.PSUBUSW(mx, x) }

// PSUBW: Subtract Packed Word Integers.
//
// Forms:
//
//	PSUBW m128 xmm
//	PSUBW xmm  xmm
//
// Construct and append a PSUBW instruction to the active function.
func (c *Context) PSUBW(mx, x operand.Op) {
	c.addinstruction(x86.PSUBW(mx, x))
}

// PSUBW: Subtract Packed Word Integers.
//
// Forms:
//
//	PSUBW m128 xmm
//	PSUBW xmm  xmm
//
// Construct and append a PSUBW instruction to the active function.
// Operates on the global context.
func PSUBW(mx, x operand.Op) { ctx.PSUBW(mx, x) }

// PTEST: Packed Logical Compare.
//
// Forms:
//
//	PTEST m128 xmm
//	PTEST xmm  xmm
//
// Construct and append a PTEST instruction to the active function.
func (c *Context) PTEST(mx, x operand.Op) {
	c.addinstruction(x86.PTEST(mx, x))
}

// PTEST: Packed Logical Compare.
//
// Forms:
//
//	PTEST m128 xmm
//	PTEST xmm  xmm
//
// Construct and append a PTEST instruction to the active function.
// Operates on the global context.
func PTEST(mx, x operand.Op) { ctx.PTEST(mx, x) }

// PUNPCKHBW: Unpack and Interleave High-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKHBW m128 xmm
//	PUNPCKHBW xmm  xmm
//
// Construct and append a PUNPCKHBW instruction to the active function.
func (c *Context) PUNPCKHBW(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKHBW(mx, x))
}

// PUNPCKHBW: Unpack and Interleave High-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKHBW m128 xmm
//	PUNPCKHBW xmm  xmm
//
// Construct and append a PUNPCKHBW instruction to the active function.
// Operates on the global context.
func PUNPCKHBW(mx, x operand.Op) { ctx.PUNPCKHBW(mx, x) }

// PUNPCKHLQ: Unpack and Interleave High-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKHLQ m128 xmm
//	PUNPCKHLQ xmm  xmm
//
// Construct and append a PUNPCKHLQ instruction to the active function.
func (c *Context) PUNPCKHLQ(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKHLQ(mx, x))
}

// PUNPCKHLQ: Unpack and Interleave High-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKHLQ m128 xmm
//	PUNPCKHLQ xmm  xmm
//
// Construct and append a PUNPCKHLQ instruction to the active function.
// Operates on the global context.
func PUNPCKHLQ(mx, x operand.Op) { ctx.PUNPCKHLQ(mx, x) }

// PUNPCKHQDQ: Unpack and Interleave High-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKHQDQ m128 xmm
//	PUNPCKHQDQ xmm  xmm
//
// Construct and append a PUNPCKHQDQ instruction to the active function.
func (c *Context) PUNPCKHQDQ(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKHQDQ(mx, x))
}

// PUNPCKHQDQ: Unpack and Interleave High-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKHQDQ m128 xmm
//	PUNPCKHQDQ xmm  xmm
//
// Construct and append a PUNPCKHQDQ instruction to the active function.
// Operates on the global context.
func PUNPCKHQDQ(mx, x operand.Op) { ctx.PUNPCKHQDQ(mx, x) }

// PUNPCKHWL: Unpack and Interleave High-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKHWL m128 xmm
//	PUNPCKHWL xmm  xmm
//
// Construct and append a PUNPCKHWL instruction to the active function.
func (c *Context) PUNPCKHWL(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKHWL(mx, x))
}

// PUNPCKHWL: Unpack and Interleave High-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKHWL m128 xmm
//	PUNPCKHWL xmm  xmm
//
// Construct and append a PUNPCKHWL instruction to the active function.
// Operates on the global context.
func PUNPCKHWL(mx, x operand.Op) { ctx.PUNPCKHWL(mx, x) }

// PUNPCKLBW: Unpack and Interleave Low-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKLBW m128 xmm
//	PUNPCKLBW xmm  xmm
//
// Construct and append a PUNPCKLBW instruction to the active function.
func (c *Context) PUNPCKLBW(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKLBW(mx, x))
}

// PUNPCKLBW: Unpack and Interleave Low-Order Bytes into Words.
//
// Forms:
//
//	PUNPCKLBW m128 xmm
//	PUNPCKLBW xmm  xmm
//
// Construct and append a PUNPCKLBW instruction to the active function.
// Operates on the global context.
func PUNPCKLBW(mx, x operand.Op) { ctx.PUNPCKLBW(mx, x) }

// PUNPCKLLQ: Unpack and Interleave Low-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKLLQ m128 xmm
//	PUNPCKLLQ xmm  xmm
//
// Construct and append a PUNPCKLLQ instruction to the active function.
func (c *Context) PUNPCKLLQ(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKLLQ(mx, x))
}

// PUNPCKLLQ: Unpack and Interleave Low-Order Doublewords into Quadwords.
//
// Forms:
//
//	PUNPCKLLQ m128 xmm
//	PUNPCKLLQ xmm  xmm
//
// Construct and append a PUNPCKLLQ instruction to the active function.
// Operates on the global context.
func PUNPCKLLQ(mx, x operand.Op) { ctx.PUNPCKLLQ(mx, x) }

// PUNPCKLQDQ: Unpack and Interleave Low-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKLQDQ m128 xmm
//	PUNPCKLQDQ xmm  xmm
//
// Construct and append a PUNPCKLQDQ instruction to the active function.
func (c *Context) PUNPCKLQDQ(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKLQDQ(mx, x))
}

// PUNPCKLQDQ: Unpack and Interleave Low-Order Quadwords into Double Quadwords.
//
// Forms:
//
//	PUNPCKLQDQ m128 xmm
//	PUNPCKLQDQ xmm  xmm
//
// Construct and append a PUNPCKLQDQ instruction to the active function.
// Operates on the global context.
func PUNPCKLQDQ(mx, x operand.Op) { ctx.PUNPCKLQDQ(mx, x) }

// PUNPCKLWL: Unpack and Interleave Low-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKLWL m128 xmm
//	PUNPCKLWL xmm  xmm
//
// Construct and append a PUNPCKLWL instruction to the active function.
func (c *Context) PUNPCKLWL(mx, x operand.Op) {
	c.addinstruction(x86.PUNPCKLWL(mx, x))
}

// PUNPCKLWL: Unpack and Interleave Low-Order Words into Doublewords.
//
// Forms:
//
//	PUNPCKLWL m128 xmm
//	PUNPCKLWL xmm  xmm
//
// Construct and append a PUNPCKLWL instruction to the active function.
// Operates on the global context.
func PUNPCKLWL(mx, x operand.Op) { ctx.PUNPCKLWL(mx, x) }

// PUSHQ: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHQ imm32
//	PUSHQ imm8
//	PUSHQ m64
//	PUSHQ r64
//
// Construct and append a PUSHQ instruction to the active function.
func (c *Context) PUSHQ(imr operand.Op) {
	c.addinstruction(x86.PUSHQ(imr))
}

// PUSHQ: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHQ imm32
//	PUSHQ imm8
//	PUSHQ m64
//	PUSHQ r64
//
// Construct and append a PUSHQ instruction to the active function.
// Operates on the global context.
func PUSHQ(imr operand.Op) { ctx.PUSHQ(imr) }

// PUSHW: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHW m16
//	PUSHW r16
//
// Construct and append a PUSHW instruction to the active function.
func (c *Context) PUSHW(mr operand.Op) {
	c.addinstruction(x86.PUSHW(mr))
}

// PUSHW: Push Value Onto the Stack.
//
// Forms:
//
//	PUSHW m16
//	PUSHW r16
//
// Construct and append a PUSHW instruction to the active function.
// Operates on the global context.
func PUSHW(mr operand.Op) { ctx.PUSHW(mr) }

// PXOR: Packed Bitwise Logical Exclusive OR.
//
// Forms:
//
//	PXOR m128 xmm
//	PXOR xmm  xmm
//
// Construct and append a PXOR instruction to the active function.
func (c *Context) PXOR(mx, x operand.Op) {
	c.addinstruction(x86.PXOR(mx, x))
}

// PXOR: Packed Bitwise Logical Exclusive OR.
//
// Forms:
//
//	PXOR m128 xmm
//	PXOR xmm  xmm
//
// Construct and append a PXOR instruction to the active function.
// Operates on the global context.
func PXOR(mx, x operand.Op) { ctx.PXOR(mx, x) }

// RCLB: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLB 1    m8
//	RCLB 1    r8
//	RCLB cl   m8
//	RCLB cl   r8
//	RCLB imm8 m8
//	RCLB imm8 r8
//
// Construct and append a RCLB instruction to the active function.
func (c *Context) RCLB(ci, mr operand.Op) {
	c.addinstruction(x86.RCLB(ci, mr))
}

// RCLB: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLB 1    m8
//	RCLB 1    r8
//	RCLB cl   m8
//	RCLB cl   r8
//	RCLB imm8 m8
//	RCLB imm8 r8
//
// Construct and append a RCLB instruction to the active function.
// Operates on the global context.
func RCLB(ci, mr operand.Op) { ctx.RCLB(ci, mr) }

// RCLL: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLL 1    m32
//	RCLL 1    r32
//	RCLL cl   m32
//	RCLL cl   r32
//	RCLL imm8 m32
//	RCLL imm8 r32
//
// Construct and append a RCLL instruction to the active function.
func (c *Context) RCLL(ci, mr operand.Op) {
	c.addinstruction(x86.RCLL(ci, mr))
}

// RCLL: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLL 1    m32
//	RCLL 1    r32
//	RCLL cl   m32
//	RCLL cl   r32
//	RCLL imm8 m32
//	RCLL imm8 r32
//
// Construct and append a RCLL instruction to the active function.
// Operates on the global context.
func RCLL(ci, mr operand.Op) { ctx.RCLL(ci, mr) }

// RCLQ: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLQ 1    m64
//	RCLQ 1    r64
//	RCLQ cl   m64
//	RCLQ cl   r64
//	RCLQ imm8 m64
//	RCLQ imm8 r64
//
// Construct and append a RCLQ instruction to the active function.
func (c *Context) RCLQ(ci, mr operand.Op) {
	c.addinstruction(x86.RCLQ(ci, mr))
}

// RCLQ: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLQ 1    m64
//	RCLQ 1    r64
//	RCLQ cl   m64
//	RCLQ cl   r64
//	RCLQ imm8 m64
//	RCLQ imm8 r64
//
// Construct and append a RCLQ instruction to the active function.
// Operates on the global context.
func RCLQ(ci, mr operand.Op) { ctx.RCLQ(ci, mr) }

// RCLW: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLW 1    m16
//	RCLW 1    r16
//	RCLW cl   m16
//	RCLW cl   r16
//	RCLW imm8 m16
//	RCLW imm8 r16
//
// Construct and append a RCLW instruction to the active function.
func (c *Context) RCLW(ci, mr operand.Op) {
	c.addinstruction(x86.RCLW(ci, mr))
}

// RCLW: Rotate Left through Carry Flag.
//
// Forms:
//
//	RCLW 1    m16
//	RCLW 1    r16
//	RCLW cl   m16
//	RCLW cl   r16
//	RCLW imm8 m16
//	RCLW imm8 r16
//
// Construct and append a RCLW instruction to the active function.
// Operates on the global context.
func RCLW(ci, mr operand.Op) { ctx.RCLW(ci, mr) }

// RCPPS: Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPPS m128 xmm
//	RCPPS xmm  xmm
//
// Construct and append a RCPPS instruction to the active function.
func (c *Context) RCPPS(mx, x operand.Op) {
	c.addinstruction(x86.RCPPS(mx, x))
}

// RCPPS: Compute Approximate Reciprocals of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPPS m128 xmm
//	RCPPS xmm  xmm
//
// Construct and append a RCPPS instruction to the active function.
// Operates on the global context.
func RCPPS(mx, x operand.Op) { ctx.RCPPS(mx, x) }

// RCPSS: Compute Approximate Reciprocal of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPSS m32 xmm
//	RCPSS xmm xmm
//
// Construct and append a RCPSS instruction to the active function.
func (c *Context) RCPSS(mx, x operand.Op) {
	c.addinstruction(x86.RCPSS(mx, x))
}

// RCPSS: Compute Approximate Reciprocal of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	RCPSS m32 xmm
//	RCPSS xmm xmm
//
// Construct and append a RCPSS instruction to the active function.
// Operates on the global context.
func RCPSS(mx, x operand.Op) { ctx.RCPSS(mx, x) }

// RCRB: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRB 1    m8
//	RCRB 1    r8
//	RCRB cl   m8
//	RCRB cl   r8
//	RCRB imm8 m8
//	RCRB imm8 r8
//
// Construct and append a RCRB instruction to the active function.
func (c *Context) RCRB(ci, mr operand.Op) {
	c.addinstruction(x86.RCRB(ci, mr))
}

// RCRB: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRB 1    m8
//	RCRB 1    r8
//	RCRB cl   m8
//	RCRB cl   r8
//	RCRB imm8 m8
//	RCRB imm8 r8
//
// Construct and append a RCRB instruction to the active function.
// Operates on the global context.
func RCRB(ci, mr operand.Op) { ctx.RCRB(ci, mr) }

// RCRL: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRL 1    m32
//	RCRL 1    r32
//	RCRL cl   m32
//	RCRL cl   r32
//	RCRL imm8 m32
//	RCRL imm8 r32
//
// Construct and append a RCRL instruction to the active function.
func (c *Context) RCRL(ci, mr operand.Op) {
	c.addinstruction(x86.RCRL(ci, mr))
}

// RCRL: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRL 1    m32
//	RCRL 1    r32
//	RCRL cl   m32
//	RCRL cl   r32
//	RCRL imm8 m32
//	RCRL imm8 r32
//
// Construct and append a RCRL instruction to the active function.
// Operates on the global context.
func RCRL(ci, mr operand.Op) { ctx.RCRL(ci, mr) }

// RCRQ: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRQ 1    m64
//	RCRQ 1    r64
//	RCRQ cl   m64
//	RCRQ cl   r64
//	RCRQ imm8 m64
//	RCRQ imm8 r64
//
// Construct and append a RCRQ instruction to the active function.
func (c *Context) RCRQ(ci, mr operand.Op) {
	c.addinstruction(x86.RCRQ(ci, mr))
}

// RCRQ: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRQ 1    m64
//	RCRQ 1    r64
//	RCRQ cl   m64
//	RCRQ cl   r64
//	RCRQ imm8 m64
//	RCRQ imm8 r64
//
// Construct and append a RCRQ instruction to the active function.
// Operates on the global context.
func RCRQ(ci, mr operand.Op) { ctx.RCRQ(ci, mr) }

// RCRW: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRW 1    m16
//	RCRW 1    r16
//	RCRW cl   m16
//	RCRW cl   r16
//	RCRW imm8 m16
//	RCRW imm8 r16
//
// Construct and append a RCRW instruction to the active function.
func (c *Context) RCRW(ci, mr operand.Op) {
	c.addinstruction(x86.RCRW(ci, mr))
}

// RCRW: Rotate Right through Carry Flag.
//
// Forms:
//
//	RCRW 1    m16
//	RCRW 1    r16
//	RCRW cl   m16
//	RCRW cl   r16
//	RCRW imm8 m16
//	RCRW imm8 r16
//
// Construct and append a RCRW instruction to the active function.
// Operates on the global context.
func RCRW(ci, mr operand.Op) { ctx.RCRW(ci, mr) }

// RDRANDL: Read Random Number.
//
// Forms:
//
//	RDRANDL r16
//	RDRANDL r32
//	RDRANDL r64
//
// Construct and append a RDRANDL instruction to the active function.
func (c *Context) RDRANDL(r operand.Op) {
	c.addinstruction(x86.RDRANDL(r))
}

// RDRANDL: Read Random Number.
//
// Forms:
//
//	RDRANDL r16
//	RDRANDL r32
//	RDRANDL r64
//
// Construct and append a RDRANDL instruction to the active function.
// Operates on the global context.
func RDRANDL(r operand.Op) { ctx.RDRANDL(r) }

// RDSEEDL: Read Random SEED.
//
// Forms:
//
//	RDSEEDL r16
//	RDSEEDL r32
//	RDSEEDL r64
//
// Construct and append a RDSEEDL instruction to the active function.
func (c *Context) RDSEEDL(r operand.Op) {
	c.addinstruction(x86.RDSEEDL(r))
}

// RDSEEDL: Read Random SEED.
//
// Forms:
//
//	RDSEEDL r16
//	RDSEEDL r32
//	RDSEEDL r64
//
// Construct and append a RDSEEDL instruction to the active function.
// Operates on the global context.
func RDSEEDL(r operand.Op) { ctx.RDSEEDL(r) }

// RDTSC: Read Time-Stamp Counter.
//
// Forms:
//
//	RDTSC
//
// Construct and append a RDTSC instruction to the active function.
func (c *Context) RDTSC() {
	c.addinstruction(x86.RDTSC())
}

// RDTSC: Read Time-Stamp Counter.
//
// Forms:
//
//	RDTSC
//
// Construct and append a RDTSC instruction to the active function.
// Operates on the global context.
func RDTSC() { ctx.RDTSC() }

// RDTSCP: Read Time-Stamp Counter and Processor ID.
//
// Forms:
//
//	RDTSCP
//
// Construct and append a RDTSCP instruction to the active function.
func (c *Context) RDTSCP() {
	c.addinstruction(x86.RDTSCP())
}

// RDTSCP: Read Time-Stamp Counter and Processor ID.
//
// Forms:
//
//	RDTSCP
//
// Construct and append a RDTSCP instruction to the active function.
// Operates on the global context.
func RDTSCP() { ctx.RDTSCP() }

// RET: Return from Procedure.
//
// Forms:
//
//	RET
//
// Construct and append a RET instruction to the active function.
func (c *Context) RET() {
	c.addinstruction(x86.RET())
}

// RET: Return from Procedure.
//
// Forms:
//
//	RET
//
// Construct and append a RET instruction to the active function.
// Operates on the global context.
func RET() { ctx.RET() }

// RETFL: Return from Procedure.
//
// Forms:
//
//	RETFL imm16
//
// Construct and append a RETFL instruction to the active function.
func (c *Context) RETFL(i operand.Op) {
	c.addinstruction(x86.RETFL(i))
}

// RETFL: Return from Procedure.
//
// Forms:
//
//	RETFL imm16
//
// Construct and append a RETFL instruction to the active function.
// Operates on the global context.
func RETFL(i operand.Op) { ctx.RETFL(i) }

// RETFQ: Return from Procedure.
//
// Forms:
//
//	RETFQ imm16
//
// Construct and append a RETFQ instruction to the active function.
func (c *Context) RETFQ(i operand.Op) {
	c.addinstruction(x86.RETFQ(i))
}

// RETFQ: Return from Procedure.
//
// Forms:
//
//	RETFQ imm16
//
// Construct and append a RETFQ instruction to the active function.
// Operates on the global context.
func RETFQ(i operand.Op) { ctx.RETFQ(i) }

// RETFW: Return from Procedure.
//
// Forms:
//
//	RETFW imm16
//
// Construct and append a RETFW instruction to the active function.
func (c *Context) RETFW(i operand.Op) {
	c.addinstruction(x86.RETFW(i))
}

// RETFW: Return from Procedure.
//
// Forms:
//
//	RETFW imm16
//
// Construct and append a RETFW instruction to the active function.
// Operates on the global context.
func RETFW(i operand.Op) { ctx.RETFW(i) }

// ROLB: Rotate Left.
//
// Forms:
//
//	ROLB 1    m8
//	ROLB 1    r8
//	ROLB cl   m8
//	ROLB cl   r8
//	ROLB imm8 m8
//	ROLB imm8 r8
//
// Construct and append a ROLB instruction to the active function.
func (c *Context) ROLB(ci, mr operand.Op) {
	c.addinstruction(x86.ROLB(ci, mr))
}

// ROLB: Rotate Left.
//
// Forms:
//
//	ROLB 1    m8
//	ROLB 1    r8
//	ROLB cl   m8
//	ROLB cl   r8
//	ROLB imm8 m8
//	ROLB imm8 r8
//
// Construct and append a ROLB instruction to the active function.
// Operates on the global context.
func ROLB(ci, mr operand.Op) { ctx.ROLB(ci, mr) }

// ROLL: Rotate Left.
//
// Forms:
//
//	ROLL 1    m32
//	ROLL 1    r32
//	ROLL cl   m32
//	ROLL cl   r32
//	ROLL imm8 m32
//	ROLL imm8 r32
//
// Construct and append a ROLL instruction to the active function.
func (c *Context) ROLL(ci, mr operand.Op) {
	c.addinstruction(x86.ROLL(ci, mr))
}

// ROLL: Rotate Left.
//
// Forms:
//
//	ROLL 1    m32
//	ROLL 1    r32
//	ROLL cl   m32
//	ROLL cl   r32
//	ROLL imm8 m32
//	ROLL imm8 r32
//
// Construct and append a ROLL instruction to the active function.
// Operates on the global context.
func ROLL(ci, mr operand.Op) { ctx.ROLL(ci, mr) }

// ROLQ: Rotate Left.
//
// Forms:
//
//	ROLQ 1    m64
//	ROLQ 1    r64
//	ROLQ cl   m64
//	ROLQ cl   r64
//	ROLQ imm8 m64
//	ROLQ imm8 r64
//
// Construct and append a ROLQ instruction to the active function.
func (c *Context) ROLQ(ci, mr operand.Op) {
	c.addinstruction(x86.ROLQ(ci, mr))
}

// ROLQ: Rotate Left.
//
// Forms:
//
//	ROLQ 1    m64
//	ROLQ 1    r64
//	ROLQ cl   m64
//	ROLQ cl   r64
//	ROLQ imm8 m64
//	ROLQ imm8 r64
//
// Construct and append a ROLQ instruction to the active function.
// Operates on the global context.
func ROLQ(ci, mr operand.Op) { ctx.ROLQ(ci, mr) }

// ROLW: Rotate Left.
//
// Forms:
//
//	ROLW 1    m16
//	ROLW 1    r16
//	ROLW cl   m16
//	ROLW cl   r16
//	ROLW imm8 m16
//	ROLW imm8 r16
//
// Construct and append a ROLW instruction to the active function.
func (c *Context) ROLW(ci, mr operand.Op) {
	c.addinstruction(x86.ROLW(ci, mr))
}

// ROLW: Rotate Left.
//
// Forms:
//
//	ROLW 1    m16
//	ROLW 1    r16
//	ROLW cl   m16
//	ROLW cl   r16
//	ROLW imm8 m16
//	ROLW imm8 r16
//
// Construct and append a ROLW instruction to the active function.
// Operates on the global context.
func ROLW(ci, mr operand.Op) { ctx.ROLW(ci, mr) }

// RORB: Rotate Right.
//
// Forms:
//
//	RORB 1    m8
//	RORB 1    r8
//	RORB cl   m8
//	RORB cl   r8
//	RORB imm8 m8
//	RORB imm8 r8
//
// Construct and append a RORB instruction to the active function.
func (c *Context) RORB(ci, mr operand.Op) {
	c.addinstruction(x86.RORB(ci, mr))
}

// RORB: Rotate Right.
//
// Forms:
//
//	RORB 1    m8
//	RORB 1    r8
//	RORB cl   m8
//	RORB cl   r8
//	RORB imm8 m8
//	RORB imm8 r8
//
// Construct and append a RORB instruction to the active function.
// Operates on the global context.
func RORB(ci, mr operand.Op) { ctx.RORB(ci, mr) }

// RORL: Rotate Right.
//
// Forms:
//
//	RORL 1    m32
//	RORL 1    r32
//	RORL cl   m32
//	RORL cl   r32
//	RORL imm8 m32
//	RORL imm8 r32
//
// Construct and append a RORL instruction to the active function.
func (c *Context) RORL(ci, mr operand.Op) {
	c.addinstruction(x86.RORL(ci, mr))
}

// RORL: Rotate Right.
//
// Forms:
//
//	RORL 1    m32
//	RORL 1    r32
//	RORL cl   m32
//	RORL cl   r32
//	RORL imm8 m32
//	RORL imm8 r32
//
// Construct and append a RORL instruction to the active function.
// Operates on the global context.
func RORL(ci, mr operand.Op) { ctx.RORL(ci, mr) }

// RORQ: Rotate Right.
//
// Forms:
//
//	RORQ 1    m64
//	RORQ 1    r64
//	RORQ cl   m64
//	RORQ cl   r64
//	RORQ imm8 m64
//	RORQ imm8 r64
//
// Construct and append a RORQ instruction to the active function.
func (c *Context) RORQ(ci, mr operand.Op) {
	c.addinstruction(x86.RORQ(ci, mr))
}

// RORQ: Rotate Right.
//
// Forms:
//
//	RORQ 1    m64
//	RORQ 1    r64
//	RORQ cl   m64
//	RORQ cl   r64
//	RORQ imm8 m64
//	RORQ imm8 r64
//
// Construct and append a RORQ instruction to the active function.
// Operates on the global context.
func RORQ(ci, mr operand.Op) { ctx.RORQ(ci, mr) }

// RORW: Rotate Right.
//
// Forms:
//
//	RORW 1    m16
//	RORW 1    r16
//	RORW cl   m16
//	RORW cl   r16
//	RORW imm8 m16
//	RORW imm8 r16
//
// Construct and append a RORW instruction to the active function.
func (c *Context) RORW(ci, mr operand.Op) {
	c.addinstruction(x86.RORW(ci, mr))
}

// RORW: Rotate Right.
//
// Forms:
//
//	RORW 1    m16
//	RORW 1    r16
//	RORW cl   m16
//	RORW cl   r16
//	RORW imm8 m16
//	RORW imm8 r16
//
// Construct and append a RORW instruction to the active function.
// Operates on the global context.
func RORW(ci, mr operand.Op) { ctx.RORW(ci, mr) }

// RORXL: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXL imm8 m32 r32
//	RORXL imm8 r32 r32
//
// Construct and append a RORXL instruction to the active function.
func (c *Context) RORXL(i, mr, r operand.Op) {
	c.addinstruction(x86.RORXL(i, mr, r))
}

// RORXL: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXL imm8 m32 r32
//	RORXL imm8 r32 r32
//
// Construct and append a RORXL instruction to the active function.
// Operates on the global context.
func RORXL(i, mr, r operand.Op) { ctx.RORXL(i, mr, r) }

// RORXQ: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXQ imm8 m64 r64
//	RORXQ imm8 r64 r64
//
// Construct and append a RORXQ instruction to the active function.
func (c *Context) RORXQ(i, mr, r operand.Op) {
	c.addinstruction(x86.RORXQ(i, mr, r))
}

// RORXQ: Rotate Right Logical Without Affecting Flags.
//
// Forms:
//
//	RORXQ imm8 m64 r64
//	RORXQ imm8 r64 r64
//
// Construct and append a RORXQ instruction to the active function.
// Operates on the global context.
func RORXQ(i, mr, r operand.Op) { ctx.RORXQ(i, mr, r) }

// ROUNDPD: Round Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPD imm8 m128 xmm
//	ROUNDPD imm8 xmm  xmm
//
// Construct and append a ROUNDPD instruction to the active function.
func (c *Context) ROUNDPD(i, mx, x operand.Op) {
	c.addinstruction(x86.ROUNDPD(i, mx, x))
}

// ROUNDPD: Round Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPD imm8 m128 xmm
//	ROUNDPD imm8 xmm  xmm
//
// Construct and append a ROUNDPD instruction to the active function.
// Operates on the global context.
func ROUNDPD(i, mx, x operand.Op) { ctx.ROUNDPD(i, mx, x) }

// ROUNDPS: Round Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPS imm8 m128 xmm
//	ROUNDPS imm8 xmm  xmm
//
// Construct and append a ROUNDPS instruction to the active function.
func (c *Context) ROUNDPS(i, mx, x operand.Op) {
	c.addinstruction(x86.ROUNDPS(i, mx, x))
}

// ROUNDPS: Round Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDPS imm8 m128 xmm
//	ROUNDPS imm8 xmm  xmm
//
// Construct and append a ROUNDPS instruction to the active function.
// Operates on the global context.
func ROUNDPS(i, mx, x operand.Op) { ctx.ROUNDPS(i, mx, x) }

// ROUNDSD: Round Scalar Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSD imm8 m64 xmm
//	ROUNDSD imm8 xmm xmm
//
// Construct and append a ROUNDSD instruction to the active function.
func (c *Context) ROUNDSD(i, mx, x operand.Op) {
	c.addinstruction(x86.ROUNDSD(i, mx, x))
}

// ROUNDSD: Round Scalar Double Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSD imm8 m64 xmm
//	ROUNDSD imm8 xmm xmm
//
// Construct and append a ROUNDSD instruction to the active function.
// Operates on the global context.
func ROUNDSD(i, mx, x operand.Op) { ctx.ROUNDSD(i, mx, x) }

// ROUNDSS: Round Scalar Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSS imm8 m32 xmm
//	ROUNDSS imm8 xmm xmm
//
// Construct and append a ROUNDSS instruction to the active function.
func (c *Context) ROUNDSS(i, mx, x operand.Op) {
	c.addinstruction(x86.ROUNDSS(i, mx, x))
}

// ROUNDSS: Round Scalar Single Precision Floating-Point Values.
//
// Forms:
//
//	ROUNDSS imm8 m32 xmm
//	ROUNDSS imm8 xmm xmm
//
// Construct and append a ROUNDSS instruction to the active function.
// Operates on the global context.
func ROUNDSS(i, mx, x operand.Op) { ctx.ROUNDSS(i, mx, x) }

// RSQRTPS: Compute Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RSQRTPS m128 xmm
//	RSQRTPS xmm  xmm
//
// Construct and append a RSQRTPS instruction to the active function.
func (c *Context) RSQRTPS(mx, x operand.Op) {
	c.addinstruction(x86.RSQRTPS(mx, x))
}

// RSQRTPS: Compute Reciprocals of Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	RSQRTPS m128 xmm
//	RSQRTPS xmm  xmm
//
// Construct and append a RSQRTPS instruction to the active function.
// Operates on the global context.
func RSQRTPS(mx, x operand.Op) { ctx.RSQRTPS(mx, x) }

// RSQRTSS: Compute Reciprocal of Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	RSQRTSS m32 xmm
//	RSQRTSS xmm xmm
//
// Construct and append a RSQRTSS instruction to the active function.
func (c *Context) RSQRTSS(mx, x operand.Op) {
	c.addinstruction(x86.RSQRTSS(mx, x))
}

// RSQRTSS: Compute Reciprocal of Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	RSQRTSS m32 xmm
//	RSQRTSS xmm xmm
//
// Construct and append a RSQRTSS instruction to the active function.
// Operates on the global context.
func RSQRTSS(mx, x operand.Op) { ctx.RSQRTSS(mx, x) }

// SALB: Arithmetic Shift Left.
//
// Forms:
//
//	SALB 1    m8
//	SALB 1    r8
//	SALB cl   m8
//	SALB cl   r8
//	SALB imm8 m8
//	SALB imm8 r8
//
// Construct and append a SALB instruction to the active function.
func (c *Context) SALB(ci, mr operand.Op) {
	c.addinstruction(x86.SALB(ci, mr))
}

// SALB: Arithmetic Shift Left.
//
// Forms:
//
//	SALB 1    m8
//	SALB 1    r8
//	SALB cl   m8
//	SALB cl   r8
//	SALB imm8 m8
//	SALB imm8 r8
//
// Construct and append a SALB instruction to the active function.
// Operates on the global context.
func SALB(ci, mr operand.Op) { ctx.SALB(ci, mr) }

// SALL: Arithmetic Shift Left.
//
// Forms:
//
//	SALL 1    m32
//	SALL 1    r32
//	SALL cl   m32
//	SALL cl   r32
//	SALL imm8 m32
//	SALL imm8 r32
//
// Construct and append a SALL instruction to the active function.
func (c *Context) SALL(ci, mr operand.Op) {
	c.addinstruction(x86.SALL(ci, mr))
}

// SALL: Arithmetic Shift Left.
//
// Forms:
//
//	SALL 1    m32
//	SALL 1    r32
//	SALL cl   m32
//	SALL cl   r32
//	SALL imm8 m32
//	SALL imm8 r32
//
// Construct and append a SALL instruction to the active function.
// Operates on the global context.
func SALL(ci, mr operand.Op) { ctx.SALL(ci, mr) }

// SALQ: Arithmetic Shift Left.
//
// Forms:
//
//	SALQ 1    m64
//	SALQ 1    r64
//	SALQ cl   m64
//	SALQ cl   r64
//	SALQ imm8 m64
//	SALQ imm8 r64
//
// Construct and append a SALQ instruction to the active function.
func (c *Context) SALQ(ci, mr operand.Op) {
	c.addinstruction(x86.SALQ(ci, mr))
}

// SALQ: Arithmetic Shift Left.
//
// Forms:
//
//	SALQ 1    m64
//	SALQ 1    r64
//	SALQ cl   m64
//	SALQ cl   r64
//	SALQ imm8 m64
//	SALQ imm8 r64
//
// Construct and append a SALQ instruction to the active function.
// Operates on the global context.
func SALQ(ci, mr operand.Op) { ctx.SALQ(ci, mr) }

// SALW: Arithmetic Shift Left.
//
// Forms:
//
//	SALW 1    m16
//	SALW 1    r16
//	SALW cl   m16
//	SALW cl   r16
//	SALW imm8 m16
//	SALW imm8 r16
//
// Construct and append a SALW instruction to the active function.
func (c *Context) SALW(ci, mr operand.Op) {
	c.addinstruction(x86.SALW(ci, mr))
}

// SALW: Arithmetic Shift Left.
//
// Forms:
//
//	SALW 1    m16
//	SALW 1    r16
//	SALW cl   m16
//	SALW cl   r16
//	SALW imm8 m16
//	SALW imm8 r16
//
// Construct and append a SALW instruction to the active function.
// Operates on the global context.
func SALW(ci, mr operand.Op) { ctx.SALW(ci, mr) }

// SARB: Arithmetic Shift Right.
//
// Forms:
//
//	SARB 1    m8
//	SARB 1    r8
//	SARB cl   m8
//	SARB cl   r8
//	SARB imm8 m8
//	SARB imm8 r8
//
// Construct and append a SARB instruction to the active function.
func (c *Context) SARB(ci, mr operand.Op) {
	c.addinstruction(x86.SARB(ci, mr))
}

// SARB: Arithmetic Shift Right.
//
// Forms:
//
//	SARB 1    m8
//	SARB 1    r8
//	SARB cl   m8
//	SARB cl   r8
//	SARB imm8 m8
//	SARB imm8 r8
//
// Construct and append a SARB instruction to the active function.
// Operates on the global context.
func SARB(ci, mr operand.Op) { ctx.SARB(ci, mr) }

// SARL: Arithmetic Shift Right.
//
// Forms:
//
//	SARL 1    m32
//	SARL 1    r32
//	SARL cl   m32
//	SARL cl   r32
//	SARL imm8 m32
//	SARL imm8 r32
//
// Construct and append a SARL instruction to the active function.
func (c *Context) SARL(ci, mr operand.Op) {
	c.addinstruction(x86.SARL(ci, mr))
}

// SARL: Arithmetic Shift Right.
//
// Forms:
//
//	SARL 1    m32
//	SARL 1    r32
//	SARL cl   m32
//	SARL cl   r32
//	SARL imm8 m32
//	SARL imm8 r32
//
// Construct and append a SARL instruction to the active function.
// Operates on the global context.
func SARL(ci, mr operand.Op) { ctx.SARL(ci, mr) }

// SARQ: Arithmetic Shift Right.
//
// Forms:
//
//	SARQ 1    m64
//	SARQ 1    r64
//	SARQ cl   m64
//	SARQ cl   r64
//	SARQ imm8 m64
//	SARQ imm8 r64
//
// Construct and append a SARQ instruction to the active function.
func (c *Context) SARQ(ci, mr operand.Op) {
	c.addinstruction(x86.SARQ(ci, mr))
}

// SARQ: Arithmetic Shift Right.
//
// Forms:
//
//	SARQ 1    m64
//	SARQ 1    r64
//	SARQ cl   m64
//	SARQ cl   r64
//	SARQ imm8 m64
//	SARQ imm8 r64
//
// Construct and append a SARQ instruction to the active function.
// Operates on the global context.
func SARQ(ci, mr operand.Op) { ctx.SARQ(ci, mr) }

// SARW: Arithmetic Shift Right.
//
// Forms:
//
//	SARW 1    m16
//	SARW 1    r16
//	SARW cl   m16
//	SARW cl   r16
//	SARW imm8 m16
//	SARW imm8 r16
//
// Construct and append a SARW instruction to the active function.
func (c *Context) SARW(ci, mr operand.Op) {
	c.addinstruction(x86.SARW(ci, mr))
}

// SARW: Arithmetic Shift Right.
//
// Forms:
//
//	SARW 1    m16
//	SARW 1    r16
//	SARW cl   m16
//	SARW cl   r16
//	SARW imm8 m16
//	SARW imm8 r16
//
// Construct and append a SARW instruction to the active function.
// Operates on the global context.
func SARW(ci, mr operand.Op) { ctx.SARW(ci, mr) }

// SARXL: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXL r32 m32 r32
//	SARXL r32 r32 r32
//
// Construct and append a SARXL instruction to the active function.
func (c *Context) SARXL(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SARXL(r, mr, r1))
}

// SARXL: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXL r32 m32 r32
//	SARXL r32 r32 r32
//
// Construct and append a SARXL instruction to the active function.
// Operates on the global context.
func SARXL(r, mr, r1 operand.Op) { ctx.SARXL(r, mr, r1) }

// SARXQ: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXQ r64 m64 r64
//	SARXQ r64 r64 r64
//
// Construct and append a SARXQ instruction to the active function.
func (c *Context) SARXQ(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SARXQ(r, mr, r1))
}

// SARXQ: Arithmetic Shift Right Without Affecting Flags.
//
// Forms:
//
//	SARXQ r64 m64 r64
//	SARXQ r64 r64 r64
//
// Construct and append a SARXQ instruction to the active function.
// Operates on the global context.
func SARXQ(r, mr, r1 operand.Op) { ctx.SARXQ(r, mr, r1) }

// SBBB: Subtract with Borrow.
//
// Forms:
//
//	SBBB imm8 al
//	SBBB imm8 m8
//	SBBB imm8 r8
//	SBBB m8   r8
//	SBBB r8   m8
//	SBBB r8   r8
//
// Construct and append a SBBB instruction to the active function.
func (c *Context) SBBB(imr, amr operand.Op) {
	c.addinstruction(x86.SBBB(imr, amr))
}

// SBBB: Subtract with Borrow.
//
// Forms:
//
//	SBBB imm8 al
//	SBBB imm8 m8
//	SBBB imm8 r8
//	SBBB m8   r8
//	SBBB r8   m8
//	SBBB r8   r8
//
// Construct and append a SBBB instruction to the active function.
// Operates on the global context.
func SBBB(imr, amr operand.Op) { ctx.SBBB(imr, amr) }

// SBBL: Subtract with Borrow.
//
// Forms:
//
//	SBBL imm32 eax
//	SBBL imm32 m32
//	SBBL imm32 r32
//	SBBL imm8  m32
//	SBBL imm8  r32
//	SBBL m32   r32
//	SBBL r32   m32
//	SBBL r32   r32
//
// Construct and append a SBBL instruction to the active function.
func (c *Context) SBBL(imr, emr operand.Op) {
	c.addinstruction(x86.SBBL(imr, emr))
}

// SBBL: Subtract with Borrow.
//
// Forms:
//
//	SBBL imm32 eax
//	SBBL imm32 m32
//	SBBL imm32 r32
//	SBBL imm8  m32
//	SBBL imm8  r32
//	SBBL m32   r32
//	SBBL r32   m32
//	SBBL r32   r32
//
// Construct and append a SBBL instruction to the active function.
// Operates on the global context.
func SBBL(imr, emr operand.Op) { ctx.SBBL(imr, emr) }

// SBBQ: Subtract with Borrow.
//
// Forms:
//
//	SBBQ imm32 m64
//	SBBQ imm32 r64
//	SBBQ imm32 rax
//	SBBQ imm8  m64
//	SBBQ imm8  r64
//	SBBQ m64   r64
//	SBBQ r64   m64
//	SBBQ r64   r64
//
// Construct and append a SBBQ instruction to the active function.
func (c *Context) SBBQ(imr, mr operand.Op) {
	c.addinstruction(x86.SBBQ(imr, mr))
}

// SBBQ: Subtract with Borrow.
//
// Forms:
//
//	SBBQ imm32 m64
//	SBBQ imm32 r64
//	SBBQ imm32 rax
//	SBBQ imm8  m64
//	SBBQ imm8  r64
//	SBBQ m64   r64
//	SBBQ r64   m64
//	SBBQ r64   r64
//
// Construct and append a SBBQ instruction to the active function.
// Operates on the global context.
func SBBQ(imr, mr operand.Op) { ctx.SBBQ(imr, mr) }

// SBBW: Subtract with Borrow.
//
// Forms:
//
//	SBBW imm16 ax
//	SBBW imm16 m16
//	SBBW imm16 r16
//	SBBW imm8  m16
//	SBBW imm8  r16
//	SBBW m16   r16
//	SBBW r16   m16
//	SBBW r16   r16
//
// Construct and append a SBBW instruction to the active function.
func (c *Context) SBBW(imr, amr operand.Op) {
	c.addinstruction(x86.SBBW(imr, amr))
}

// SBBW: Subtract with Borrow.
//
// Forms:
//
//	SBBW imm16 ax
//	SBBW imm16 m16
//	SBBW imm16 r16
//	SBBW imm8  m16
//	SBBW imm8  r16
//	SBBW m16   r16
//	SBBW r16   m16
//	SBBW r16   r16
//
// Construct and append a SBBW instruction to the active function.
// Operates on the global context.
func SBBW(imr, amr operand.Op) { ctx.SBBW(imr, amr) }

// SETCC: Set byte if above or equal (CF == 0).
//
// Forms:
//
//	SETCC m8
//	SETCC r8
//
// Construct and append a SETCC instruction to the active function.
func (c *Context) SETCC(mr operand.Op) {
	c.addinstruction(x86.SETCC(mr))
}

// SETCC: Set byte if above or equal (CF == 0).
//
// Forms:
//
//	SETCC m8
//	SETCC r8
//
// Construct and append a SETCC instruction to the active function.
// Operates on the global context.
func SETCC(mr operand.Op) { ctx.SETCC(mr) }

// SETCS: Set byte if below (CF == 1).
//
// Forms:
//
//	SETCS m8
//	SETCS r8
//
// Construct and append a SETCS instruction to the active function.
func (c *Context) SETCS(mr operand.Op) {
	c.addinstruction(x86.SETCS(mr))
}

// SETCS: Set byte if below (CF == 1).
//
// Forms:
//
//	SETCS m8
//	SETCS r8
//
// Construct and append a SETCS instruction to the active function.
// Operates on the global context.
func SETCS(mr operand.Op) { ctx.SETCS(mr) }

// SETEQ: Set byte if equal (ZF == 1).
//
// Forms:
//
//	SETEQ m8
//	SETEQ r8
//
// Construct and append a SETEQ instruction to the active function.
func (c *Context) SETEQ(mr operand.Op) {
	c.addinstruction(x86.SETEQ(mr))
}

// SETEQ: Set byte if equal (ZF == 1).
//
// Forms:
//
//	SETEQ m8
//	SETEQ r8
//
// Construct and append a SETEQ instruction to the active function.
// Operates on the global context.
func SETEQ(mr operand.Op) { ctx.SETEQ(mr) }

// SETGE: Set byte if greater or equal (SF == OF).
//
// Forms:
//
//	SETGE m8
//	SETGE r8
//
// Construct and append a SETGE instruction to the active function.
func (c *Context) SETGE(mr operand.Op) {
	c.addinstruction(x86.SETGE(mr))
}

// SETGE: Set byte if greater or equal (SF == OF).
//
// Forms:
//
//	SETGE m8
//	SETGE r8
//
// Construct and append a SETGE instruction to the active function.
// Operates on the global context.
func SETGE(mr operand.Op) { ctx.SETGE(mr) }

// SETGT: Set byte if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	SETGT m8
//	SETGT r8
//
// Construct and append a SETGT instruction to the active function.
func (c *Context) SETGT(mr operand.Op) {
	c.addinstruction(x86.SETGT(mr))
}

// SETGT: Set byte if greater (ZF == 0 and SF == OF).
//
// Forms:
//
//	SETGT m8
//	SETGT r8
//
// Construct and append a SETGT instruction to the active function.
// Operates on the global context.
func SETGT(mr operand.Op) { ctx.SETGT(mr) }

// SETHI: Set byte if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	SETHI m8
//	SETHI r8
//
// Construct and append a SETHI instruction to the active function.
func (c *Context) SETHI(mr operand.Op) {
	c.addinstruction(x86.SETHI(mr))
}

// SETHI: Set byte if above (CF == 0 and ZF == 0).
//
// Forms:
//
//	SETHI m8
//	SETHI r8
//
// Construct and append a SETHI instruction to the active function.
// Operates on the global context.
func SETHI(mr operand.Op) { ctx.SETHI(mr) }

// SETLE: Set byte if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	SETLE m8
//	SETLE r8
//
// Construct and append a SETLE instruction to the active function.
func (c *Context) SETLE(mr operand.Op) {
	c.addinstruction(x86.SETLE(mr))
}

// SETLE: Set byte if less or equal (ZF == 1 or SF != OF).
//
// Forms:
//
//	SETLE m8
//	SETLE r8
//
// Construct and append a SETLE instruction to the active function.
// Operates on the global context.
func SETLE(mr operand.Op) { ctx.SETLE(mr) }

// SETLS: Set byte if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	SETLS m8
//	SETLS r8
//
// Construct and append a SETLS instruction to the active function.
func (c *Context) SETLS(mr operand.Op) {
	c.addinstruction(x86.SETLS(mr))
}

// SETLS: Set byte if below or equal (CF == 1 or ZF == 1).
//
// Forms:
//
//	SETLS m8
//	SETLS r8
//
// Construct and append a SETLS instruction to the active function.
// Operates on the global context.
func SETLS(mr operand.Op) { ctx.SETLS(mr) }

// SETLT: Set byte if less (SF != OF).
//
// Forms:
//
//	SETLT m8
//	SETLT r8
//
// Construct and append a SETLT instruction to the active function.
func (c *Context) SETLT(mr operand.Op) {
	c.addinstruction(x86.SETLT(mr))
}

// SETLT: Set byte if less (SF != OF).
//
// Forms:
//
//	SETLT m8
//	SETLT r8
//
// Construct and append a SETLT instruction to the active function.
// Operates on the global context.
func SETLT(mr operand.Op) { ctx.SETLT(mr) }

// SETMI: Set byte if sign (SF == 1).
//
// Forms:
//
//	SETMI m8
//	SETMI r8
//
// Construct and append a SETMI instruction to the active function.
func (c *Context) SETMI(mr operand.Op) {
	c.addinstruction(x86.SETMI(mr))
}

// SETMI: Set byte if sign (SF == 1).
//
// Forms:
//
//	SETMI m8
//	SETMI r8
//
// Construct and append a SETMI instruction to the active function.
// Operates on the global context.
func SETMI(mr operand.Op) { ctx.SETMI(mr) }

// SETNE: Set byte if not equal (ZF == 0).
//
// Forms:
//
//	SETNE m8
//	SETNE r8
//
// Construct and append a SETNE instruction to the active function.
func (c *Context) SETNE(mr operand.Op) {
	c.addinstruction(x86.SETNE(mr))
}

// SETNE: Set byte if not equal (ZF == 0).
//
// Forms:
//
//	SETNE m8
//	SETNE r8
//
// Construct and append a SETNE instruction to the active function.
// Operates on the global context.
func SETNE(mr operand.Op) { ctx.SETNE(mr) }

// SETOC: Set byte if not overflow (OF == 0).
//
// Forms:
//
//	SETOC m8
//	SETOC r8
//
// Construct and append a SETOC instruction to the active function.
func (c *Context) SETOC(mr operand.Op) {
	c.addinstruction(x86.SETOC(mr))
}

// SETOC: Set byte if not overflow (OF == 0).
//
// Forms:
//
//	SETOC m8
//	SETOC r8
//
// Construct and append a SETOC instruction to the active function.
// Operates on the global context.
func SETOC(mr operand.Op) { ctx.SETOC(mr) }

// SETOS: Set byte if overflow (OF == 1).
//
// Forms:
//
//	SETOS m8
//	SETOS r8
//
// Construct and append a SETOS instruction to the active function.
func (c *Context) SETOS(mr operand.Op) {
	c.addinstruction(x86.SETOS(mr))
}

// SETOS: Set byte if overflow (OF == 1).
//
// Forms:
//
//	SETOS m8
//	SETOS r8
//
// Construct and append a SETOS instruction to the active function.
// Operates on the global context.
func SETOS(mr operand.Op) { ctx.SETOS(mr) }

// SETPC: Set byte if not parity (PF == 0).
//
// Forms:
//
//	SETPC m8
//	SETPC r8
//
// Construct and append a SETPC instruction to the active function.
func (c *Context) SETPC(mr operand.Op) {
	c.addinstruction(x86.SETPC(mr))
}

// SETPC: Set byte if not parity (PF == 0).
//
// Forms:
//
//	SETPC m8
//	SETPC r8
//
// Construct and append a SETPC instruction to the active function.
// Operates on the global context.
func SETPC(mr operand.Op) { ctx.SETPC(mr) }

// SETPL: Set byte if not sign (SF == 0).
//
// Forms:
//
//	SETPL m8
//	SETPL r8
//
// Construct and append a SETPL instruction to the active function.
func (c *Context) SETPL(mr operand.Op) {
	c.addinstruction(x86.SETPL(mr))
}

// SETPL: Set byte if not sign (SF == 0).
//
// Forms:
//
//	SETPL m8
//	SETPL r8
//
// Construct and append a SETPL instruction to the active function.
// Operates on the global context.
func SETPL(mr operand.Op) { ctx.SETPL(mr) }

// SETPS: Set byte if parity (PF == 1).
//
// Forms:
//
//	SETPS m8
//	SETPS r8
//
// Construct and append a SETPS instruction to the active function.
func (c *Context) SETPS(mr operand.Op) {
	c.addinstruction(x86.SETPS(mr))
}

// SETPS: Set byte if parity (PF == 1).
//
// Forms:
//
//	SETPS m8
//	SETPS r8
//
// Construct and append a SETPS instruction to the active function.
// Operates on the global context.
func SETPS(mr operand.Op) { ctx.SETPS(mr) }

// SFENCE: Store Fence.
//
// Forms:
//
//	SFENCE
//
// Construct and append a SFENCE instruction to the active function.
func (c *Context) SFENCE() {
	c.addinstruction(x86.SFENCE())
}

// SFENCE: Store Fence.
//
// Forms:
//
//	SFENCE
//
// Construct and append a SFENCE instruction to the active function.
// Operates on the global context.
func SFENCE() { ctx.SFENCE() }

// SHA1MSG1: Perform an Intermediate Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG1 m128 xmm
//	SHA1MSG1 xmm  xmm
//
// Construct and append a SHA1MSG1 instruction to the active function.
func (c *Context) SHA1MSG1(mx, x operand.Op) {
	c.addinstruction(x86.SHA1MSG1(mx, x))
}

// SHA1MSG1: Perform an Intermediate Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG1 m128 xmm
//	SHA1MSG1 xmm  xmm
//
// Construct and append a SHA1MSG1 instruction to the active function.
// Operates on the global context.
func SHA1MSG1(mx, x operand.Op) { ctx.SHA1MSG1(mx, x) }

// SHA1MSG2: Perform a Final Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG2 m128 xmm
//	SHA1MSG2 xmm  xmm
//
// Construct and append a SHA1MSG2 instruction to the active function.
func (c *Context) SHA1MSG2(mx, x operand.Op) {
	c.addinstruction(x86.SHA1MSG2(mx, x))
}

// SHA1MSG2: Perform a Final Calculation for the Next Four SHA1 Message Doublewords.
//
// Forms:
//
//	SHA1MSG2 m128 xmm
//	SHA1MSG2 xmm  xmm
//
// Construct and append a SHA1MSG2 instruction to the active function.
// Operates on the global context.
func SHA1MSG2(mx, x operand.Op) { ctx.SHA1MSG2(mx, x) }

// SHA1NEXTE: Calculate SHA1 State Variable E after Four Rounds.
//
// Forms:
//
//	SHA1NEXTE m128 xmm
//	SHA1NEXTE xmm  xmm
//
// Construct and append a SHA1NEXTE instruction to the active function.
func (c *Context) SHA1NEXTE(mx, x operand.Op) {
	c.addinstruction(x86.SHA1NEXTE(mx, x))
}

// SHA1NEXTE: Calculate SHA1 State Variable E after Four Rounds.
//
// Forms:
//
//	SHA1NEXTE m128 xmm
//	SHA1NEXTE xmm  xmm
//
// Construct and append a SHA1NEXTE instruction to the active function.
// Operates on the global context.
func SHA1NEXTE(mx, x operand.Op) { ctx.SHA1NEXTE(mx, x) }

// SHA1RNDS4: Perform Four Rounds of SHA1 Operation.
//
// Forms:
//
//	SHA1RNDS4 imm2u m128 xmm
//	SHA1RNDS4 imm2u xmm  xmm
//
// Construct and append a SHA1RNDS4 instruction to the active function.
func (c *Context) SHA1RNDS4(i, mx, x operand.Op) {
	c.addinstruction(x86.SHA1RNDS4(i, mx, x))
}

// SHA1RNDS4: Perform Four Rounds of SHA1 Operation.
//
// Forms:
//
//	SHA1RNDS4 imm2u m128 xmm
//	SHA1RNDS4 imm2u xmm  xmm
//
// Construct and append a SHA1RNDS4 instruction to the active function.
// Operates on the global context.
func SHA1RNDS4(i, mx, x operand.Op) { ctx.SHA1RNDS4(i, mx, x) }

// SHA256MSG1: Perform an Intermediate Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG1 m128 xmm
//	SHA256MSG1 xmm  xmm
//
// Construct and append a SHA256MSG1 instruction to the active function.
func (c *Context) SHA256MSG1(mx, x operand.Op) {
	c.addinstruction(x86.SHA256MSG1(mx, x))
}

// SHA256MSG1: Perform an Intermediate Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG1 m128 xmm
//	SHA256MSG1 xmm  xmm
//
// Construct and append a SHA256MSG1 instruction to the active function.
// Operates on the global context.
func SHA256MSG1(mx, x operand.Op) { ctx.SHA256MSG1(mx, x) }

// SHA256MSG2: Perform a Final Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG2 m128 xmm
//	SHA256MSG2 xmm  xmm
//
// Construct and append a SHA256MSG2 instruction to the active function.
func (c *Context) SHA256MSG2(mx, x operand.Op) {
	c.addinstruction(x86.SHA256MSG2(mx, x))
}

// SHA256MSG2: Perform a Final Calculation for the Next Four SHA256 Message Doublewords.
//
// Forms:
//
//	SHA256MSG2 m128 xmm
//	SHA256MSG2 xmm  xmm
//
// Construct and append a SHA256MSG2 instruction to the active function.
// Operates on the global context.
func SHA256MSG2(mx, x operand.Op) { ctx.SHA256MSG2(mx, x) }

// SHA256RNDS2: Perform Two Rounds of SHA256 Operation.
//
// Forms:
//
//	SHA256RNDS2 xmm0 m128 xmm
//	SHA256RNDS2 xmm0 xmm  xmm
//
// Construct and append a SHA256RNDS2 instruction to the active function.
func (c *Context) SHA256RNDS2(x, mx, x1 operand.Op) {
	c.addinstruction(x86.SHA256RNDS2(x, mx, x1))
}

// SHA256RNDS2: Perform Two Rounds of SHA256 Operation.
//
// Forms:
//
//	SHA256RNDS2 xmm0 m128 xmm
//	SHA256RNDS2 xmm0 xmm  xmm
//
// Construct and append a SHA256RNDS2 instruction to the active function.
// Operates on the global context.
func SHA256RNDS2(x, mx, x1 operand.Op) { ctx.SHA256RNDS2(x, mx, x1) }

// SHLB: Logical Shift Left.
//
// Forms:
//
//	SHLB 1    m8
//	SHLB 1    r8
//	SHLB cl   m8
//	SHLB cl   r8
//	SHLB imm8 m8
//	SHLB imm8 r8
//
// Construct and append a SHLB instruction to the active function.
func (c *Context) SHLB(ci, mr operand.Op) {
	c.addinstruction(x86.SHLB(ci, mr))
}

// SHLB: Logical Shift Left.
//
// Forms:
//
//	SHLB 1    m8
//	SHLB 1    r8
//	SHLB cl   m8
//	SHLB cl   r8
//	SHLB imm8 m8
//	SHLB imm8 r8
//
// Construct and append a SHLB instruction to the active function.
// Operates on the global context.
func SHLB(ci, mr operand.Op) { ctx.SHLB(ci, mr) }

// SHLL: Logical Shift Left.
//
// Forms:
//
//	SHLL 1    m32
//	SHLL 1    r32
//	SHLL cl   m32
//	SHLL cl   r32
//	SHLL cl   r32 m32
//	SHLL cl   r32 r32
//	SHLL imm8 m32
//	SHLL imm8 r32
//	SHLL imm8 r32 m32
//	SHLL imm8 r32 r32
//
// Construct and append a SHLL instruction to the active function.
func (c *Context) SHLL(ops ...operand.Op) {
	c.addinstruction(x86.SHLL(ops...))
}

// SHLL: Logical Shift Left.
//
// Forms:
//
//	SHLL 1    m32
//	SHLL 1    r32
//	SHLL cl   m32
//	SHLL cl   r32
//	SHLL cl   r32 m32
//	SHLL cl   r32 r32
//	SHLL imm8 m32
//	SHLL imm8 r32
//	SHLL imm8 r32 m32
//	SHLL imm8 r32 r32
//
// Construct and append a SHLL instruction to the active function.
// Operates on the global context.
func SHLL(ops ...operand.Op) { ctx.SHLL(ops...) }

// SHLQ: Logical Shift Left.
//
// Forms:
//
//	SHLQ 1    m64
//	SHLQ 1    r64
//	SHLQ cl   m64
//	SHLQ cl   r64
//	SHLQ cl   r64 m64
//	SHLQ cl   r64 r64
//	SHLQ imm8 m64
//	SHLQ imm8 r64
//	SHLQ imm8 r64 m64
//	SHLQ imm8 r64 r64
//
// Construct and append a SHLQ instruction to the active function.
func (c *Context) SHLQ(ops ...operand.Op) {
	c.addinstruction(x86.SHLQ(ops...))
}

// SHLQ: Logical Shift Left.
//
// Forms:
//
//	SHLQ 1    m64
//	SHLQ 1    r64
//	SHLQ cl   m64
//	SHLQ cl   r64
//	SHLQ cl   r64 m64
//	SHLQ cl   r64 r64
//	SHLQ imm8 m64
//	SHLQ imm8 r64
//	SHLQ imm8 r64 m64
//	SHLQ imm8 r64 r64
//
// Construct and append a SHLQ instruction to the active function.
// Operates on the global context.
func SHLQ(ops ...operand.Op) { ctx.SHLQ(ops...) }

// SHLW: Logical Shift Left.
//
// Forms:
//
//	SHLW 1    m16
//	SHLW 1    r16
//	SHLW cl   m16
//	SHLW cl   r16
//	SHLW cl   r16 m16
//	SHLW cl   r16 r16
//	SHLW imm8 m16
//	SHLW imm8 r16
//	SHLW imm8 r16 m16
//	SHLW imm8 r16 r16
//
// Construct and append a SHLW instruction to the active function.
func (c *Context) SHLW(ops ...operand.Op) {
	c.addinstruction(x86.SHLW(ops...))
}

// SHLW: Logical Shift Left.
//
// Forms:
//
//	SHLW 1    m16
//	SHLW 1    r16
//	SHLW cl   m16
//	SHLW cl   r16
//	SHLW cl   r16 m16
//	SHLW cl   r16 r16
//	SHLW imm8 m16
//	SHLW imm8 r16
//	SHLW imm8 r16 m16
//	SHLW imm8 r16 r16
//
// Construct and append a SHLW instruction to the active function.
// Operates on the global context.
func SHLW(ops ...operand.Op) { ctx.SHLW(ops...) }

// SHLXL: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXL r32 m32 r32
//	SHLXL r32 r32 r32
//
// Construct and append a SHLXL instruction to the active function.
func (c *Context) SHLXL(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SHLXL(r, mr, r1))
}

// SHLXL: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXL r32 m32 r32
//	SHLXL r32 r32 r32
//
// Construct and append a SHLXL instruction to the active function.
// Operates on the global context.
func SHLXL(r, mr, r1 operand.Op) { ctx.SHLXL(r, mr, r1) }

// SHLXQ: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXQ r64 m64 r64
//	SHLXQ r64 r64 r64
//
// Construct and append a SHLXQ instruction to the active function.
func (c *Context) SHLXQ(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SHLXQ(r, mr, r1))
}

// SHLXQ: Logical Shift Left Without Affecting Flags.
//
// Forms:
//
//	SHLXQ r64 m64 r64
//	SHLXQ r64 r64 r64
//
// Construct and append a SHLXQ instruction to the active function.
// Operates on the global context.
func SHLXQ(r, mr, r1 operand.Op) { ctx.SHLXQ(r, mr, r1) }

// SHRB: Logical Shift Right.
//
// Forms:
//
//	SHRB 1    m8
//	SHRB 1    r8
//	SHRB cl   m8
//	SHRB cl   r8
//	SHRB imm8 m8
//	SHRB imm8 r8
//
// Construct and append a SHRB instruction to the active function.
func (c *Context) SHRB(ci, mr operand.Op) {
	c.addinstruction(x86.SHRB(ci, mr))
}

// SHRB: Logical Shift Right.
//
// Forms:
//
//	SHRB 1    m8
//	SHRB 1    r8
//	SHRB cl   m8
//	SHRB cl   r8
//	SHRB imm8 m8
//	SHRB imm8 r8
//
// Construct and append a SHRB instruction to the active function.
// Operates on the global context.
func SHRB(ci, mr operand.Op) { ctx.SHRB(ci, mr) }

// SHRL: Logical Shift Right.
//
// Forms:
//
//	SHRL 1    m32
//	SHRL 1    r32
//	SHRL cl   m32
//	SHRL cl   r32
//	SHRL cl   r32 m32
//	SHRL cl   r32 r32
//	SHRL imm8 m32
//	SHRL imm8 r32
//	SHRL imm8 r32 m32
//	SHRL imm8 r32 r32
//
// Construct and append a SHRL instruction to the active function.
func (c *Context) SHRL(ops ...operand.Op) {
	c.addinstruction(x86.SHRL(ops...))
}

// SHRL: Logical Shift Right.
//
// Forms:
//
//	SHRL 1    m32
//	SHRL 1    r32
//	SHRL cl   m32
//	SHRL cl   r32
//	SHRL cl   r32 m32
//	SHRL cl   r32 r32
//	SHRL imm8 m32
//	SHRL imm8 r32
//	SHRL imm8 r32 m32
//	SHRL imm8 r32 r32
//
// Construct and append a SHRL instruction to the active function.
// Operates on the global context.
func SHRL(ops ...operand.Op) { ctx.SHRL(ops...) }

// SHRQ: Logical Shift Right.
//
// Forms:
//
//	SHRQ 1    m64
//	SHRQ 1    r64
//	SHRQ cl   m64
//	SHRQ cl   r64
//	SHRQ cl   r64 m64
//	SHRQ cl   r64 r64
//	SHRQ imm8 m64
//	SHRQ imm8 r64
//	SHRQ imm8 r64 m64
//	SHRQ imm8 r64 r64
//
// Construct and append a SHRQ instruction to the active function.
func (c *Context) SHRQ(ops ...operand.Op) {
	c.addinstruction(x86.SHRQ(ops...))
}

// SHRQ: Logical Shift Right.
//
// Forms:
//
//	SHRQ 1    m64
//	SHRQ 1    r64
//	SHRQ cl   m64
//	SHRQ cl   r64
//	SHRQ cl   r64 m64
//	SHRQ cl   r64 r64
//	SHRQ imm8 m64
//	SHRQ imm8 r64
//	SHRQ imm8 r64 m64
//	SHRQ imm8 r64 r64
//
// Construct and append a SHRQ instruction to the active function.
// Operates on the global context.
func SHRQ(ops ...operand.Op) { ctx.SHRQ(ops...) }

// SHRW: Logical Shift Right.
//
// Forms:
//
//	SHRW 1    m16
//	SHRW 1    r16
//	SHRW cl   m16
//	SHRW cl   r16
//	SHRW cl   r16 m16
//	SHRW cl   r16 r16
//	SHRW imm8 m16
//	SHRW imm8 r16
//	SHRW imm8 r16 m16
//	SHRW imm8 r16 r16
//
// Construct and append a SHRW instruction to the active function.
func (c *Context) SHRW(ops ...operand.Op) {
	c.addinstruction(x86.SHRW(ops...))
}

// SHRW: Logical Shift Right.
//
// Forms:
//
//	SHRW 1    m16
//	SHRW 1    r16
//	SHRW cl   m16
//	SHRW cl   r16
//	SHRW cl   r16 m16
//	SHRW cl   r16 r16
//	SHRW imm8 m16
//	SHRW imm8 r16
//	SHRW imm8 r16 m16
//	SHRW imm8 r16 r16
//
// Construct and append a SHRW instruction to the active function.
// Operates on the global context.
func SHRW(ops ...operand.Op) { ctx.SHRW(ops...) }

// SHRXL: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXL r32 m32 r32
//	SHRXL r32 r32 r32
//
// Construct and append a SHRXL instruction to the active function.
func (c *Context) SHRXL(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SHRXL(r, mr, r1))
}

// SHRXL: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXL r32 m32 r32
//	SHRXL r32 r32 r32
//
// Construct and append a SHRXL instruction to the active function.
// Operates on the global context.
func SHRXL(r, mr, r1 operand.Op) { ctx.SHRXL(r, mr, r1) }

// SHRXQ: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXQ r64 m64 r64
//	SHRXQ r64 r64 r64
//
// Construct and append a SHRXQ instruction to the active function.
func (c *Context) SHRXQ(r, mr, r1 operand.Op) {
	c.addinstruction(x86.SHRXQ(r, mr, r1))
}

// SHRXQ: Logical Shift Right Without Affecting Flags.
//
// Forms:
//
//	SHRXQ r64 m64 r64
//	SHRXQ r64 r64 r64
//
// Construct and append a SHRXQ instruction to the active function.
// Operates on the global context.
func SHRXQ(r, mr, r1 operand.Op) { ctx.SHRXQ(r, mr, r1) }

// SHUFPD: Shuffle Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPD imm8 m128 xmm
//	SHUFPD imm8 xmm  xmm
//
// Construct and append a SHUFPD instruction to the active function.
func (c *Context) SHUFPD(i, mx, x operand.Op) {
	c.addinstruction(x86.SHUFPD(i, mx, x))
}

// SHUFPD: Shuffle Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPD imm8 m128 xmm
//	SHUFPD imm8 xmm  xmm
//
// Construct and append a SHUFPD instruction to the active function.
// Operates on the global context.
func SHUFPD(i, mx, x operand.Op) { ctx.SHUFPD(i, mx, x) }

// SHUFPS: Shuffle Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPS imm8 m128 xmm
//	SHUFPS imm8 xmm  xmm
//
// Construct and append a SHUFPS instruction to the active function.
func (c *Context) SHUFPS(i, mx, x operand.Op) {
	c.addinstruction(x86.SHUFPS(i, mx, x))
}

// SHUFPS: Shuffle Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SHUFPS imm8 m128 xmm
//	SHUFPS imm8 xmm  xmm
//
// Construct and append a SHUFPS instruction to the active function.
// Operates on the global context.
func SHUFPS(i, mx, x operand.Op) { ctx.SHUFPS(i, mx, x) }

// SQRTPD: Compute Square Roots of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPD m128 xmm
//	SQRTPD xmm  xmm
//
// Construct and append a SQRTPD instruction to the active function.
func (c *Context) SQRTPD(mx, x operand.Op) {
	c.addinstruction(x86.SQRTPD(mx, x))
}

// SQRTPD: Compute Square Roots of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPD m128 xmm
//	SQRTPD xmm  xmm
//
// Construct and append a SQRTPD instruction to the active function.
// Operates on the global context.
func SQRTPD(mx, x operand.Op) { ctx.SQRTPD(mx, x) }

// SQRTPS: Compute Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPS m128 xmm
//	SQRTPS xmm  xmm
//
// Construct and append a SQRTPS instruction to the active function.
func (c *Context) SQRTPS(mx, x operand.Op) {
	c.addinstruction(x86.SQRTPS(mx, x))
}

// SQRTPS: Compute Square Roots of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SQRTPS m128 xmm
//	SQRTPS xmm  xmm
//
// Construct and append a SQRTPS instruction to the active function.
// Operates on the global context.
func SQRTPS(mx, x operand.Op) { ctx.SQRTPS(mx, x) }

// SQRTSD: Compute Square Root of Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSD m64 xmm
//	SQRTSD xmm xmm
//
// Construct and append a SQRTSD instruction to the active function.
func (c *Context) SQRTSD(mx, x operand.Op) {
	c.addinstruction(x86.SQRTSD(mx, x))
}

// SQRTSD: Compute Square Root of Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSD m64 xmm
//	SQRTSD xmm xmm
//
// Construct and append a SQRTSD instruction to the active function.
// Operates on the global context.
func SQRTSD(mx, x operand.Op) { ctx.SQRTSD(mx, x) }

// SQRTSS: Compute Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSS m32 xmm
//	SQRTSS xmm xmm
//
// Construct and append a SQRTSS instruction to the active function.
func (c *Context) SQRTSS(mx, x operand.Op) {
	c.addinstruction(x86.SQRTSS(mx, x))
}

// SQRTSS: Compute Square Root of Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	SQRTSS m32 xmm
//	SQRTSS xmm xmm
//
// Construct and append a SQRTSS instruction to the active function.
// Operates on the global context.
func SQRTSS(mx, x operand.Op) { ctx.SQRTSS(mx, x) }

// STC: Set Carry Flag.
//
// Forms:
//
//	STC
//
// Construct and append a STC instruction to the active function.
func (c *Context) STC() {
	c.addinstruction(x86.STC())
}

// STC: Set Carry Flag.
//
// Forms:
//
//	STC
//
// Construct and append a STC instruction to the active function.
// Operates on the global context.
func STC() { ctx.STC() }

// STD: Set Direction Flag.
//
// Forms:
//
//	STD
//
// Construct and append a STD instruction to the active function.
func (c *Context) STD() {
	c.addinstruction(x86.STD())
}

// STD: Set Direction Flag.
//
// Forms:
//
//	STD
//
// Construct and append a STD instruction to the active function.
// Operates on the global context.
func STD() { ctx.STD() }

// STMXCSR: Store MXCSR Register State.
//
// Forms:
//
//	STMXCSR m32
//
// Construct and append a STMXCSR instruction to the active function.
func (c *Context) STMXCSR(m operand.Op) {
	c.addinstruction(x86.STMXCSR(m))
}

// STMXCSR: Store MXCSR Register State.
//
// Forms:
//
//	STMXCSR m32
//
// Construct and append a STMXCSR instruction to the active function.
// Operates on the global context.
func STMXCSR(m operand.Op) { ctx.STMXCSR(m) }

// SUBB: Subtract.
//
// Forms:
//
//	SUBB imm8 al
//	SUBB imm8 m8
//	SUBB imm8 r8
//	SUBB m8   r8
//	SUBB r8   m8
//	SUBB r8   r8
//
// Construct and append a SUBB instruction to the active function.
func (c *Context) SUBB(imr, amr operand.Op) {
	c.addinstruction(x86.SUBB(imr, amr))
}

// SUBB: Subtract.
//
// Forms:
//
//	SUBB imm8 al
//	SUBB imm8 m8
//	SUBB imm8 r8
//	SUBB m8   r8
//	SUBB r8   m8
//	SUBB r8   r8
//
// Construct and append a SUBB instruction to the active function.
// Operates on the global context.
func SUBB(imr, amr operand.Op) { ctx.SUBB(imr, amr) }

// SUBL: Subtract.
//
// Forms:
//
//	SUBL imm32 eax
//	SUBL imm32 m32
//	SUBL imm32 r32
//	SUBL imm8  m32
//	SUBL imm8  r32
//	SUBL m32   r32
//	SUBL r32   m32
//	SUBL r32   r32
//
// Construct and append a SUBL instruction to the active function.
func (c *Context) SUBL(imr, emr operand.Op) {
	c.addinstruction(x86.SUBL(imr, emr))
}

// SUBL: Subtract.
//
// Forms:
//
//	SUBL imm32 eax
//	SUBL imm32 m32
//	SUBL imm32 r32
//	SUBL imm8  m32
//	SUBL imm8  r32
//	SUBL m32   r32
//	SUBL r32   m32
//	SUBL r32   r32
//
// Construct and append a SUBL instruction to the active function.
// Operates on the global context.
func SUBL(imr, emr operand.Op) { ctx.SUBL(imr, emr) }

// SUBPD: Subtract Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPD m128 xmm
//	SUBPD xmm  xmm
//
// Construct and append a SUBPD instruction to the active function.
func (c *Context) SUBPD(mx, x operand.Op) {
	c.addinstruction(x86.SUBPD(mx, x))
}

// SUBPD: Subtract Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPD m128 xmm
//	SUBPD xmm  xmm
//
// Construct and append a SUBPD instruction to the active function.
// Operates on the global context.
func SUBPD(mx, x operand.Op) { ctx.SUBPD(mx, x) }

// SUBPS: Subtract Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPS m128 xmm
//	SUBPS xmm  xmm
//
// Construct and append a SUBPS instruction to the active function.
func (c *Context) SUBPS(mx, x operand.Op) {
	c.addinstruction(x86.SUBPS(mx, x))
}

// SUBPS: Subtract Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBPS m128 xmm
//	SUBPS xmm  xmm
//
// Construct and append a SUBPS instruction to the active function.
// Operates on the global context.
func SUBPS(mx, x operand.Op) { ctx.SUBPS(mx, x) }

// SUBQ: Subtract.
//
// Forms:
//
//	SUBQ imm32 m64
//	SUBQ imm32 r64
//	SUBQ imm32 rax
//	SUBQ imm8  m64
//	SUBQ imm8  r64
//	SUBQ m64   r64
//	SUBQ r64   m64
//	SUBQ r64   r64
//
// Construct and append a SUBQ instruction to the active function.
func (c *Context) SUBQ(imr, mr operand.Op) {
	c.addinstruction(x86.SUBQ(imr, mr))
}

// SUBQ: Subtract.
//
// Forms:
//
//	SUBQ imm32 m64
//	SUBQ imm32 r64
//	SUBQ imm32 rax
//	SUBQ imm8  m64
//	SUBQ imm8  r64
//	SUBQ m64   r64
//	SUBQ r64   m64
//	SUBQ r64   r64
//
// Construct and append a SUBQ instruction to the active function.
// Operates on the global context.
func SUBQ(imr, mr operand.Op) { ctx.SUBQ(imr, mr) }

// SUBSD: Subtract Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSD m64 xmm
//	SUBSD xmm xmm
//
// Construct and append a SUBSD instruction to the active function.
func (c *Context) SUBSD(mx, x operand.Op) {
	c.addinstruction(x86.SUBSD(mx, x))
}

// SUBSD: Subtract Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSD m64 xmm
//	SUBSD xmm xmm
//
// Construct and append a SUBSD instruction to the active function.
// Operates on the global context.
func SUBSD(mx, x operand.Op) { ctx.SUBSD(mx, x) }

// SUBSS: Subtract Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSS m32 xmm
//	SUBSS xmm xmm
//
// Construct and append a SUBSS instruction to the active function.
func (c *Context) SUBSS(mx, x operand.Op) {
	c.addinstruction(x86.SUBSS(mx, x))
}

// SUBSS: Subtract Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	SUBSS m32 xmm
//	SUBSS xmm xmm
//
// Construct and append a SUBSS instruction to the active function.
// Operates on the global context.
func SUBSS(mx, x operand.Op) { ctx.SUBSS(mx, x) }

// SUBW: Subtract.
//
// Forms:
//
//	SUBW imm16 ax
//	SUBW imm16 m16
//	SUBW imm16 r16
//	SUBW imm8  m16
//	SUBW imm8  r16
//	SUBW m16   r16
//	SUBW r16   m16
//	SUBW r16   r16
//
// Construct and append a SUBW instruction to the active function.
func (c *Context) SUBW(imr, amr operand.Op) {
	c.addinstruction(x86.SUBW(imr, amr))
}

// SUBW: Subtract.
//
// Forms:
//
//	SUBW imm16 ax
//	SUBW imm16 m16
//	SUBW imm16 r16
//	SUBW imm8  m16
//	SUBW imm8  r16
//	SUBW m16   r16
//	SUBW r16   m16
//	SUBW r16   r16
//
// Construct and append a SUBW instruction to the active function.
// Operates on the global context.
func SUBW(imr, amr operand.Op) { ctx.SUBW(imr, amr) }

// SYSCALL: Fast System Call.
//
// Forms:
//
//	SYSCALL
//
// Construct and append a SYSCALL instruction to the active function.
func (c *Context) SYSCALL() {
	c.addinstruction(x86.SYSCALL())
}

// SYSCALL: Fast System Call.
//
// Forms:
//
//	SYSCALL
//
// Construct and append a SYSCALL instruction to the active function.
// Operates on the global context.
func SYSCALL() { ctx.SYSCALL() }

// TESTB: Logical Compare.
//
// Forms:
//
//	TESTB imm8 al
//	TESTB imm8 m8
//	TESTB imm8 r8
//	TESTB r8   m8
//	TESTB r8   r8
//
// Construct and append a TESTB instruction to the active function.
func (c *Context) TESTB(ir, amr operand.Op) {
	c.addinstruction(x86.TESTB(ir, amr))
}

// TESTB: Logical Compare.
//
// Forms:
//
//	TESTB imm8 al
//	TESTB imm8 m8
//	TESTB imm8 r8
//	TESTB r8   m8
//	TESTB r8   r8
//
// Construct and append a TESTB instruction to the active function.
// Operates on the global context.
func TESTB(ir, amr operand.Op) { ctx.TESTB(ir, amr) }

// TESTL: Logical Compare.
//
// Forms:
//
//	TESTL imm32 eax
//	TESTL imm32 m32
//	TESTL imm32 r32
//	TESTL r32   m32
//	TESTL r32   r32
//
// Construct and append a TESTL instruction to the active function.
func (c *Context) TESTL(ir, emr operand.Op) {
	c.addinstruction(x86.TESTL(ir, emr))
}

// TESTL: Logical Compare.
//
// Forms:
//
//	TESTL imm32 eax
//	TESTL imm32 m32
//	TESTL imm32 r32
//	TESTL r32   m32
//	TESTL r32   r32
//
// Construct and append a TESTL instruction to the active function.
// Operates on the global context.
func TESTL(ir, emr operand.Op) { ctx.TESTL(ir, emr) }

// TESTQ: Logical Compare.
//
// Forms:
//
//	TESTQ imm32 m64
//	TESTQ imm32 r64
//	TESTQ imm32 rax
//	TESTQ r64   m64
//	TESTQ r64   r64
//
// Construct and append a TESTQ instruction to the active function.
func (c *Context) TESTQ(ir, mr operand.Op) {
	c.addinstruction(x86.TESTQ(ir, mr))
}

// TESTQ: Logical Compare.
//
// Forms:
//
//	TESTQ imm32 m64
//	TESTQ imm32 r64
//	TESTQ imm32 rax
//	TESTQ r64   m64
//	TESTQ r64   r64
//
// Construct and append a TESTQ instruction to the active function.
// Operates on the global context.
func TESTQ(ir, mr operand.Op) { ctx.TESTQ(ir, mr) }

// TESTW: Logical Compare.
//
// Forms:
//
//	TESTW imm16 ax
//	TESTW imm16 m16
//	TESTW imm16 r16
//	TESTW r16   m16
//	TESTW r16   r16
//
// Construct and append a TESTW instruction to the active function.
func (c *Context) TESTW(ir, amr operand.Op) {
	c.addinstruction(x86.TESTW(ir, amr))
}

// TESTW: Logical Compare.
//
// Forms:
//
//	TESTW imm16 ax
//	TESTW imm16 m16
//	TESTW imm16 r16
//	TESTW r16   m16
//	TESTW r16   r16
//
// Construct and append a TESTW instruction to the active function.
// Operates on the global context.
func TESTW(ir, amr operand.Op) { ctx.TESTW(ir, amr) }

// TZCNTL: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTL m32 r32
//	TZCNTL r32 r32
//
// Construct and append a TZCNTL instruction to the active function.
func (c *Context) TZCNTL(mr, r operand.Op) {
	c.addinstruction(x86.TZCNTL(mr, r))
}

// TZCNTL: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTL m32 r32
//	TZCNTL r32 r32
//
// Construct and append a TZCNTL instruction to the active function.
// Operates on the global context.
func TZCNTL(mr, r operand.Op) { ctx.TZCNTL(mr, r) }

// TZCNTQ: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTQ m64 r64
//	TZCNTQ r64 r64
//
// Construct and append a TZCNTQ instruction to the active function.
func (c *Context) TZCNTQ(mr, r operand.Op) {
	c.addinstruction(x86.TZCNTQ(mr, r))
}

// TZCNTQ: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTQ m64 r64
//	TZCNTQ r64 r64
//
// Construct and append a TZCNTQ instruction to the active function.
// Operates on the global context.
func TZCNTQ(mr, r operand.Op) { ctx.TZCNTQ(mr, r) }

// TZCNTW: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTW m16 r16
//	TZCNTW r16 r16
//
// Construct and append a TZCNTW instruction to the active function.
func (c *Context) TZCNTW(mr, r operand.Op) {
	c.addinstruction(x86.TZCNTW(mr, r))
}

// TZCNTW: Count the Number of Trailing Zero Bits.
//
// Forms:
//
//	TZCNTW m16 r16
//	TZCNTW r16 r16
//
// Construct and append a TZCNTW instruction to the active function.
// Operates on the global context.
func TZCNTW(mr, r operand.Op) { ctx.TZCNTW(mr, r) }

// UCOMISD: Unordered Compare Scalar Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISD m64 xmm
//	UCOMISD xmm xmm
//
// Construct and append a UCOMISD instruction to the active function.
func (c *Context) UCOMISD(mx, x operand.Op) {
	c.addinstruction(x86.UCOMISD(mx, x))
}

// UCOMISD: Unordered Compare Scalar Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISD m64 xmm
//	UCOMISD xmm xmm
//
// Construct and append a UCOMISD instruction to the active function.
// Operates on the global context.
func UCOMISD(mx, x operand.Op) { ctx.UCOMISD(mx, x) }

// UCOMISS: Unordered Compare Scalar Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISS m32 xmm
//	UCOMISS xmm xmm
//
// Construct and append a UCOMISS instruction to the active function.
func (c *Context) UCOMISS(mx, x operand.Op) {
	c.addinstruction(x86.UCOMISS(mx, x))
}

// UCOMISS: Unordered Compare Scalar Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	UCOMISS m32 xmm
//	UCOMISS xmm xmm
//
// Construct and append a UCOMISS instruction to the active function.
// Operates on the global context.
func UCOMISS(mx, x operand.Op) { ctx.UCOMISS(mx, x) }

// UD2: Undefined Instruction.
//
// Forms:
//
//	UD2
//
// Construct and append a UD2 instruction to the active function.
func (c *Context) UD2() {
	c.addinstruction(x86.UD2())
}

// UD2: Undefined Instruction.
//
// Forms:
//
//	UD2
//
// Construct and append a UD2 instruction to the active function.
// Operates on the global context.
func UD2() { ctx.UD2() }

// UNPCKHPD: Unpack and Interleave High Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPD m128 xmm
//	UNPCKHPD xmm  xmm
//
// Construct and append a UNPCKHPD instruction to the active function.
func (c *Context) UNPCKHPD(mx, x operand.Op) {
	c.addinstruction(x86.UNPCKHPD(mx, x))
}

// UNPCKHPD: Unpack and Interleave High Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPD m128 xmm
//	UNPCKHPD xmm  xmm
//
// Construct and append a UNPCKHPD instruction to the active function.
// Operates on the global context.
func UNPCKHPD(mx, x operand.Op) { ctx.UNPCKHPD(mx, x) }

// UNPCKHPS: Unpack and Interleave High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPS m128 xmm
//	UNPCKHPS xmm  xmm
//
// Construct and append a UNPCKHPS instruction to the active function.
func (c *Context) UNPCKHPS(mx, x operand.Op) {
	c.addinstruction(x86.UNPCKHPS(mx, x))
}

// UNPCKHPS: Unpack and Interleave High Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKHPS m128 xmm
//	UNPCKHPS xmm  xmm
//
// Construct and append a UNPCKHPS instruction to the active function.
// Operates on the global context.
func UNPCKHPS(mx, x operand.Op) { ctx.UNPCKHPS(mx, x) }

// UNPCKLPD: Unpack and Interleave Low Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPD m128 xmm
//	UNPCKLPD xmm  xmm
//
// Construct and append a UNPCKLPD instruction to the active function.
func (c *Context) UNPCKLPD(mx, x operand.Op) {
	c.addinstruction(x86.UNPCKLPD(mx, x))
}

// UNPCKLPD: Unpack and Interleave Low Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPD m128 xmm
//	UNPCKLPD xmm  xmm
//
// Construct and append a UNPCKLPD instruction to the active function.
// Operates on the global context.
func UNPCKLPD(mx, x operand.Op) { ctx.UNPCKLPD(mx, x) }

// UNPCKLPS: Unpack and Interleave Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPS m128 xmm
//	UNPCKLPS xmm  xmm
//
// Construct and append a UNPCKLPS instruction to the active function.
func (c *Context) UNPCKLPS(mx, x operand.Op) {
	c.addinstruction(x86.UNPCKLPS(mx, x))
}

// UNPCKLPS: Unpack and Interleave Low Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	UNPCKLPS m128 xmm
//	UNPCKLPS xmm  xmm
//
// Construct and append a UNPCKLPS instruction to the active function.
// Operates on the global context.
func UNPCKLPS(mx, x operand.Op) { ctx.UNPCKLPS(mx, x) }

// VADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPD m128 xmm xmm
//	VADDPD m256 ymm ymm
//	VADDPD xmm  xmm xmm
//	VADDPD ymm  ymm ymm
//	VADDPD m128 xmm k xmm
//	VADDPD m256 ymm k ymm
//	VADDPD xmm  xmm k xmm
//	VADDPD ymm  ymm k ymm
//	VADDPD m512 zmm k zmm
//	VADDPD m512 zmm zmm
//	VADDPD zmm  zmm k zmm
//	VADDPD zmm  zmm zmm
//
// Construct and append a VADDPD instruction to the active function.
func (c *Context) VADDPD(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD(ops...))
}

// VADDPD: Add Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPD m128 xmm xmm
//	VADDPD m256 ymm ymm
//	VADDPD xmm  xmm xmm
//	VADDPD ymm  ymm ymm
//	VADDPD m128 xmm k xmm
//	VADDPD m256 ymm k ymm
//	VADDPD xmm  xmm k xmm
//	VADDPD ymm  ymm k ymm
//	VADDPD m512 zmm k zmm
//	VADDPD m512 zmm zmm
//	VADDPD zmm  zmm k zmm
//	VADDPD zmm  zmm zmm
//
// Construct and append a VADDPD instruction to the active function.
// Operates on the global context.
func VADDPD(ops ...operand.Op) { ctx.VADDPD(ops...) }

// VADDPD_BCST: Add Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPD.BCST m64 xmm k xmm
//	VADDPD.BCST m64 xmm xmm
//	VADDPD.BCST m64 ymm k ymm
//	VADDPD.BCST m64 ymm ymm
//	VADDPD.BCST m64 zmm k zmm
//	VADDPD.BCST m64 zmm zmm
//
// Construct and append a VADDPD.BCST instruction to the active function.
func (c *Context) VADDPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD_BCST(ops...))
}

// VADDPD_BCST: Add Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPD.BCST m64 xmm k xmm
//	VADDPD.BCST m64 xmm xmm
//	VADDPD.BCST m64 ymm k ymm
//	VADDPD.BCST m64 ymm ymm
//	VADDPD.BCST m64 zmm k zmm
//	VADDPD.BCST m64 zmm zmm
//
// Construct and append a VADDPD.BCST instruction to the active function.
// Operates on the global context.
func VADDPD_BCST(ops ...operand.Op) { ctx.VADDPD_BCST(ops...) }

// VADDPD_BCST_Z: Add Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPD.BCST.Z m64 xmm k xmm
//	VADDPD.BCST.Z m64 ymm k ymm
//	VADDPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VADDPD.BCST.Z instruction to the active function.
func (c *Context) VADDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VADDPD_BCST_Z(m, xyz, k, xyz1))
}

// VADDPD_BCST_Z: Add Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPD.BCST.Z m64 xmm k xmm
//	VADDPD.BCST.Z m64 ymm k ymm
//	VADDPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VADDPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VADDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VADDPD_BCST_Z(m, xyz, k, xyz1) }

// VADDPD_RD_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPD.RD_SAE zmm zmm k zmm
//	VADDPD.RD_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RD_SAE instruction to the active function.
func (c *Context) VADDPD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD_RD_SAE(ops...))
}

// VADDPD_RD_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPD.RD_SAE zmm zmm k zmm
//	VADDPD.RD_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RD_SAE instruction to the active function.
// Operates on the global context.
func VADDPD_RD_SAE(ops ...operand.Op) { ctx.VADDPD_RD_SAE(ops...) }

// VADDPD_RD_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RD_SAE.Z instruction to the active function.
func (c *Context) VADDPD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPD_RD_SAE_Z(z, z1, k, z2))
}

// VADDPD_RD_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPD_RD_SAE_Z(z, z1, k, z2) }

// VADDPD_RN_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPD.RN_SAE zmm zmm k zmm
//	VADDPD.RN_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RN_SAE instruction to the active function.
func (c *Context) VADDPD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD_RN_SAE(ops...))
}

// VADDPD_RN_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPD.RN_SAE zmm zmm k zmm
//	VADDPD.RN_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RN_SAE instruction to the active function.
// Operates on the global context.
func VADDPD_RN_SAE(ops ...operand.Op) { ctx.VADDPD_RN_SAE(ops...) }

// VADDPD_RN_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RN_SAE.Z instruction to the active function.
func (c *Context) VADDPD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPD_RN_SAE_Z(z, z1, k, z2))
}

// VADDPD_RN_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPD_RN_SAE_Z(z, z1, k, z2) }

// VADDPD_RU_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPD.RU_SAE zmm zmm k zmm
//	VADDPD.RU_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RU_SAE instruction to the active function.
func (c *Context) VADDPD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD_RU_SAE(ops...))
}

// VADDPD_RU_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPD.RU_SAE zmm zmm k zmm
//	VADDPD.RU_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RU_SAE instruction to the active function.
// Operates on the global context.
func VADDPD_RU_SAE(ops ...operand.Op) { ctx.VADDPD_RU_SAE(ops...) }

// VADDPD_RU_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RU_SAE.Z instruction to the active function.
func (c *Context) VADDPD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPD_RU_SAE_Z(z, z1, k, z2))
}

// VADDPD_RU_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPD_RU_SAE_Z(z, z1, k, z2) }

// VADDPD_RZ_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPD.RZ_SAE zmm zmm k zmm
//	VADDPD.RZ_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RZ_SAE instruction to the active function.
func (c *Context) VADDPD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPD_RZ_SAE(ops...))
}

// VADDPD_RZ_SAE: Add Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPD.RZ_SAE zmm zmm k zmm
//	VADDPD.RZ_SAE zmm zmm zmm
//
// Construct and append a VADDPD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VADDPD_RZ_SAE(ops ...operand.Op) { ctx.VADDPD_RZ_SAE(ops...) }

// VADDPD_RZ_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RZ_SAE.Z instruction to the active function.
func (c *Context) VADDPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPD_RZ_SAE_Z(z, z1, k, z2))
}

// VADDPD_RZ_SAE_Z: Add Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPD_RZ_SAE_Z(z, z1, k, z2) }

// VADDPD_Z: Add Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPD.Z m128 xmm k xmm
//	VADDPD.Z m256 ymm k ymm
//	VADDPD.Z xmm  xmm k xmm
//	VADDPD.Z ymm  ymm k ymm
//	VADDPD.Z m512 zmm k zmm
//	VADDPD.Z zmm  zmm k zmm
//
// Construct and append a VADDPD.Z instruction to the active function.
func (c *Context) VADDPD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VADDPD_Z(mxyz, xyz, k, xyz1))
}

// VADDPD_Z: Add Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPD.Z m128 xmm k xmm
//	VADDPD.Z m256 ymm k ymm
//	VADDPD.Z xmm  xmm k xmm
//	VADDPD.Z ymm  ymm k ymm
//	VADDPD.Z m512 zmm k zmm
//	VADDPD.Z zmm  zmm k zmm
//
// Construct and append a VADDPD.Z instruction to the active function.
// Operates on the global context.
func VADDPD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VADDPD_Z(mxyz, xyz, k, xyz1) }

// VADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPS m128 xmm xmm
//	VADDPS m256 ymm ymm
//	VADDPS xmm  xmm xmm
//	VADDPS ymm  ymm ymm
//	VADDPS m128 xmm k xmm
//	VADDPS m256 ymm k ymm
//	VADDPS xmm  xmm k xmm
//	VADDPS ymm  ymm k ymm
//	VADDPS m512 zmm k zmm
//	VADDPS m512 zmm zmm
//	VADDPS zmm  zmm k zmm
//	VADDPS zmm  zmm zmm
//
// Construct and append a VADDPS instruction to the active function.
func (c *Context) VADDPS(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS(ops...))
}

// VADDPS: Add Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDPS m128 xmm xmm
//	VADDPS m256 ymm ymm
//	VADDPS xmm  xmm xmm
//	VADDPS ymm  ymm ymm
//	VADDPS m128 xmm k xmm
//	VADDPS m256 ymm k ymm
//	VADDPS xmm  xmm k xmm
//	VADDPS ymm  ymm k ymm
//	VADDPS m512 zmm k zmm
//	VADDPS m512 zmm zmm
//	VADDPS zmm  zmm k zmm
//	VADDPS zmm  zmm zmm
//
// Construct and append a VADDPS instruction to the active function.
// Operates on the global context.
func VADDPS(ops ...operand.Op) { ctx.VADDPS(ops...) }

// VADDPS_BCST: Add Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPS.BCST m32 xmm k xmm
//	VADDPS.BCST m32 xmm xmm
//	VADDPS.BCST m32 ymm k ymm
//	VADDPS.BCST m32 ymm ymm
//	VADDPS.BCST m32 zmm k zmm
//	VADDPS.BCST m32 zmm zmm
//
// Construct and append a VADDPS.BCST instruction to the active function.
func (c *Context) VADDPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS_BCST(ops...))
}

// VADDPS_BCST: Add Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VADDPS.BCST m32 xmm k xmm
//	VADDPS.BCST m32 xmm xmm
//	VADDPS.BCST m32 ymm k ymm
//	VADDPS.BCST m32 ymm ymm
//	VADDPS.BCST m32 zmm k zmm
//	VADDPS.BCST m32 zmm zmm
//
// Construct and append a VADDPS.BCST instruction to the active function.
// Operates on the global context.
func VADDPS_BCST(ops ...operand.Op) { ctx.VADDPS_BCST(ops...) }

// VADDPS_BCST_Z: Add Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPS.BCST.Z m32 xmm k xmm
//	VADDPS.BCST.Z m32 ymm k ymm
//	VADDPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VADDPS.BCST.Z instruction to the active function.
func (c *Context) VADDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VADDPS_BCST_Z(m, xyz, k, xyz1))
}

// VADDPS_BCST_Z: Add Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VADDPS.BCST.Z m32 xmm k xmm
//	VADDPS.BCST.Z m32 ymm k ymm
//	VADDPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VADDPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VADDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VADDPS_BCST_Z(m, xyz, k, xyz1) }

// VADDPS_RD_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPS.RD_SAE zmm zmm k zmm
//	VADDPS.RD_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RD_SAE instruction to the active function.
func (c *Context) VADDPS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS_RD_SAE(ops...))
}

// VADDPS_RD_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDPS.RD_SAE zmm zmm k zmm
//	VADDPS.RD_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RD_SAE instruction to the active function.
// Operates on the global context.
func VADDPS_RD_SAE(ops ...operand.Op) { ctx.VADDPS_RD_SAE(ops...) }

// VADDPS_RD_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RD_SAE.Z instruction to the active function.
func (c *Context) VADDPS_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPS_RD_SAE_Z(z, z1, k, z2))
}

// VADDPS_RD_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPS_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPS_RD_SAE_Z(z, z1, k, z2) }

// VADDPS_RN_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPS.RN_SAE zmm zmm k zmm
//	VADDPS.RN_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RN_SAE instruction to the active function.
func (c *Context) VADDPS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS_RN_SAE(ops...))
}

// VADDPS_RN_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDPS.RN_SAE zmm zmm k zmm
//	VADDPS.RN_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RN_SAE instruction to the active function.
// Operates on the global context.
func VADDPS_RN_SAE(ops ...operand.Op) { ctx.VADDPS_RN_SAE(ops...) }

// VADDPS_RN_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RN_SAE.Z instruction to the active function.
func (c *Context) VADDPS_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPS_RN_SAE_Z(z, z1, k, z2))
}

// VADDPS_RN_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPS_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPS_RN_SAE_Z(z, z1, k, z2) }

// VADDPS_RU_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPS.RU_SAE zmm zmm k zmm
//	VADDPS.RU_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RU_SAE instruction to the active function.
func (c *Context) VADDPS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS_RU_SAE(ops...))
}

// VADDPS_RU_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDPS.RU_SAE zmm zmm k zmm
//	VADDPS.RU_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RU_SAE instruction to the active function.
// Operates on the global context.
func VADDPS_RU_SAE(ops ...operand.Op) { ctx.VADDPS_RU_SAE(ops...) }

// VADDPS_RU_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RU_SAE.Z instruction to the active function.
func (c *Context) VADDPS_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPS_RU_SAE_Z(z, z1, k, z2))
}

// VADDPS_RU_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPS_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPS_RU_SAE_Z(z, z1, k, z2) }

// VADDPS_RZ_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPS.RZ_SAE zmm zmm k zmm
//	VADDPS.RZ_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RZ_SAE instruction to the active function.
func (c *Context) VADDPS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDPS_RZ_SAE(ops...))
}

// VADDPS_RZ_SAE: Add Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDPS.RZ_SAE zmm zmm k zmm
//	VADDPS.RZ_SAE zmm zmm zmm
//
// Construct and append a VADDPS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VADDPS_RZ_SAE(ops ...operand.Op) { ctx.VADDPS_RZ_SAE(ops...) }

// VADDPS_RZ_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RZ_SAE.Z instruction to the active function.
func (c *Context) VADDPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VADDPS_RZ_SAE_Z(z, z1, k, z2))
}

// VADDPS_RZ_SAE_Z: Add Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDPS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VADDPS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VADDPS_RZ_SAE_Z(z, z1, k, z2) }

// VADDPS_Z: Add Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPS.Z m128 xmm k xmm
//	VADDPS.Z m256 ymm k ymm
//	VADDPS.Z xmm  xmm k xmm
//	VADDPS.Z ymm  ymm k ymm
//	VADDPS.Z m512 zmm k zmm
//	VADDPS.Z zmm  zmm k zmm
//
// Construct and append a VADDPS.Z instruction to the active function.
func (c *Context) VADDPS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VADDPS_Z(mxyz, xyz, k, xyz1))
}

// VADDPS_Z: Add Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDPS.Z m128 xmm k xmm
//	VADDPS.Z m256 ymm k ymm
//	VADDPS.Z xmm  xmm k xmm
//	VADDPS.Z ymm  ymm k ymm
//	VADDPS.Z m512 zmm k zmm
//	VADDPS.Z zmm  zmm k zmm
//
// Construct and append a VADDPS.Z instruction to the active function.
// Operates on the global context.
func VADDPS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VADDPS_Z(mxyz, xyz, k, xyz1) }

// VADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSD m64 xmm xmm
//	VADDSD xmm xmm xmm
//	VADDSD m64 xmm k xmm
//	VADDSD xmm xmm k xmm
//
// Construct and append a VADDSD instruction to the active function.
func (c *Context) VADDSD(ops ...operand.Op) {
	c.addinstruction(x86.VADDSD(ops...))
}

// VADDSD: Add Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSD m64 xmm xmm
//	VADDSD xmm xmm xmm
//	VADDSD m64 xmm k xmm
//	VADDSD xmm xmm k xmm
//
// Construct and append a VADDSD instruction to the active function.
// Operates on the global context.
func VADDSD(ops ...operand.Op) { ctx.VADDSD(ops...) }

// VADDSD_RD_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSD.RD_SAE xmm xmm k xmm
//	VADDSD.RD_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RD_SAE instruction to the active function.
func (c *Context) VADDSD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSD_RD_SAE(ops...))
}

// VADDSD_RD_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSD.RD_SAE xmm xmm k xmm
//	VADDSD.RD_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RD_SAE instruction to the active function.
// Operates on the global context.
func VADDSD_RD_SAE(ops ...operand.Op) { ctx.VADDSD_RD_SAE(ops...) }

// VADDSD_RD_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RD_SAE.Z instruction to the active function.
func (c *Context) VADDSD_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSD_RD_SAE_Z(x, x1, k, x2))
}

// VADDSD_RD_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSD_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSD_RD_SAE_Z(x, x1, k, x2) }

// VADDSD_RN_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSD.RN_SAE xmm xmm k xmm
//	VADDSD.RN_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RN_SAE instruction to the active function.
func (c *Context) VADDSD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSD_RN_SAE(ops...))
}

// VADDSD_RN_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSD.RN_SAE xmm xmm k xmm
//	VADDSD.RN_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RN_SAE instruction to the active function.
// Operates on the global context.
func VADDSD_RN_SAE(ops ...operand.Op) { ctx.VADDSD_RN_SAE(ops...) }

// VADDSD_RN_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RN_SAE.Z instruction to the active function.
func (c *Context) VADDSD_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSD_RN_SAE_Z(x, x1, k, x2))
}

// VADDSD_RN_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSD_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSD_RN_SAE_Z(x, x1, k, x2) }

// VADDSD_RU_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSD.RU_SAE xmm xmm k xmm
//	VADDSD.RU_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RU_SAE instruction to the active function.
func (c *Context) VADDSD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSD_RU_SAE(ops...))
}

// VADDSD_RU_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSD.RU_SAE xmm xmm k xmm
//	VADDSD.RU_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RU_SAE instruction to the active function.
// Operates on the global context.
func VADDSD_RU_SAE(ops ...operand.Op) { ctx.VADDSD_RU_SAE(ops...) }

// VADDSD_RU_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RU_SAE.Z instruction to the active function.
func (c *Context) VADDSD_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSD_RU_SAE_Z(x, x1, k, x2))
}

// VADDSD_RU_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSD_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSD_RU_SAE_Z(x, x1, k, x2) }

// VADDSD_RZ_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSD.RZ_SAE xmm xmm k xmm
//	VADDSD.RZ_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RZ_SAE instruction to the active function.
func (c *Context) VADDSD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSD_RZ_SAE(ops...))
}

// VADDSD_RZ_SAE: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSD.RZ_SAE xmm xmm k xmm
//	VADDSD.RZ_SAE xmm xmm xmm
//
// Construct and append a VADDSD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VADDSD_RZ_SAE(ops ...operand.Op) { ctx.VADDSD_RZ_SAE(ops...) }

// VADDSD_RZ_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RZ_SAE.Z instruction to the active function.
func (c *Context) VADDSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSD_RZ_SAE_Z(x, x1, k, x2))
}

// VADDSD_RZ_SAE_Z: Add Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSD_RZ_SAE_Z(x, x1, k, x2) }

// VADDSD_Z: Add Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSD.Z m64 xmm k xmm
//	VADDSD.Z xmm xmm k xmm
//
// Construct and append a VADDSD.Z instruction to the active function.
func (c *Context) VADDSD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VADDSD_Z(mx, x, k, x1))
}

// VADDSD_Z: Add Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSD.Z m64 xmm k xmm
//	VADDSD.Z xmm xmm k xmm
//
// Construct and append a VADDSD.Z instruction to the active function.
// Operates on the global context.
func VADDSD_Z(mx, x, k, x1 operand.Op) { ctx.VADDSD_Z(mx, x, k, x1) }

// VADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSS m32 xmm xmm
//	VADDSS xmm xmm xmm
//	VADDSS m32 xmm k xmm
//	VADDSS xmm xmm k xmm
//
// Construct and append a VADDSS instruction to the active function.
func (c *Context) VADDSS(ops ...operand.Op) {
	c.addinstruction(x86.VADDSS(ops...))
}

// VADDSS: Add Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VADDSS m32 xmm xmm
//	VADDSS xmm xmm xmm
//	VADDSS m32 xmm k xmm
//	VADDSS xmm xmm k xmm
//
// Construct and append a VADDSS instruction to the active function.
// Operates on the global context.
func VADDSS(ops ...operand.Op) { ctx.VADDSS(ops...) }

// VADDSS_RD_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSS.RD_SAE xmm xmm k xmm
//	VADDSS.RD_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RD_SAE instruction to the active function.
func (c *Context) VADDSS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSS_RD_SAE(ops...))
}

// VADDSS_RD_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VADDSS.RD_SAE xmm xmm k xmm
//	VADDSS.RD_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RD_SAE instruction to the active function.
// Operates on the global context.
func VADDSS_RD_SAE(ops ...operand.Op) { ctx.VADDSS_RD_SAE(ops...) }

// VADDSS_RD_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RD_SAE.Z instruction to the active function.
func (c *Context) VADDSS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSS_RD_SAE_Z(x, x1, k, x2))
}

// VADDSS_RD_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSS_RD_SAE_Z(x, x1, k, x2) }

// VADDSS_RN_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSS.RN_SAE xmm xmm k xmm
//	VADDSS.RN_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RN_SAE instruction to the active function.
func (c *Context) VADDSS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSS_RN_SAE(ops...))
}

// VADDSS_RN_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VADDSS.RN_SAE xmm xmm k xmm
//	VADDSS.RN_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RN_SAE instruction to the active function.
// Operates on the global context.
func VADDSS_RN_SAE(ops ...operand.Op) { ctx.VADDSS_RN_SAE(ops...) }

// VADDSS_RN_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RN_SAE.Z instruction to the active function.
func (c *Context) VADDSS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSS_RN_SAE_Z(x, x1, k, x2))
}

// VADDSS_RN_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSS_RN_SAE_Z(x, x1, k, x2) }

// VADDSS_RU_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSS.RU_SAE xmm xmm k xmm
//	VADDSS.RU_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RU_SAE instruction to the active function.
func (c *Context) VADDSS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSS_RU_SAE(ops...))
}

// VADDSS_RU_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VADDSS.RU_SAE xmm xmm k xmm
//	VADDSS.RU_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RU_SAE instruction to the active function.
// Operates on the global context.
func VADDSS_RU_SAE(ops ...operand.Op) { ctx.VADDSS_RU_SAE(ops...) }

// VADDSS_RU_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RU_SAE.Z instruction to the active function.
func (c *Context) VADDSS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSS_RU_SAE_Z(x, x1, k, x2))
}

// VADDSS_RU_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSS_RU_SAE_Z(x, x1, k, x2) }

// VADDSS_RZ_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSS.RZ_SAE xmm xmm k xmm
//	VADDSS.RZ_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RZ_SAE instruction to the active function.
func (c *Context) VADDSS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VADDSS_RZ_SAE(ops...))
}

// VADDSS_RZ_SAE: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VADDSS.RZ_SAE xmm xmm k xmm
//	VADDSS.RZ_SAE xmm xmm xmm
//
// Construct and append a VADDSS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VADDSS_RZ_SAE(ops ...operand.Op) { ctx.VADDSS_RZ_SAE(ops...) }

// VADDSS_RZ_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RZ_SAE.Z instruction to the active function.
func (c *Context) VADDSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VADDSS_RZ_SAE_Z(x, x1, k, x2))
}

// VADDSS_RZ_SAE_Z: Add Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VADDSS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VADDSS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VADDSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VADDSS_RZ_SAE_Z(x, x1, k, x2) }

// VADDSS_Z: Add Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSS.Z m32 xmm k xmm
//	VADDSS.Z xmm xmm k xmm
//
// Construct and append a VADDSS.Z instruction to the active function.
func (c *Context) VADDSS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VADDSS_Z(mx, x, k, x1))
}

// VADDSS_Z: Add Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VADDSS.Z m32 xmm k xmm
//	VADDSS.Z xmm xmm k xmm
//
// Construct and append a VADDSS.Z instruction to the active function.
// Operates on the global context.
func VADDSS_Z(mx, x, k, x1 operand.Op) { ctx.VADDSS_Z(mx, x, k, x1) }

// VADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPD m128 xmm xmm
//	VADDSUBPD m256 ymm ymm
//	VADDSUBPD xmm  xmm xmm
//	VADDSUBPD ymm  ymm ymm
//
// Construct and append a VADDSUBPD instruction to the active function.
func (c *Context) VADDSUBPD(mxy, xy, xy1 operand.Op) {
	c.addinstruction(x86.VADDSUBPD(mxy, xy, xy1))
}

// VADDSUBPD: Packed Double-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPD m128 xmm xmm
//	VADDSUBPD m256 ymm ymm
//	VADDSUBPD xmm  xmm xmm
//	VADDSUBPD ymm  ymm ymm
//
// Construct and append a VADDSUBPD instruction to the active function.
// Operates on the global context.
func VADDSUBPD(mxy, xy, xy1 operand.Op) { ctx.VADDSUBPD(mxy, xy, xy1) }

// VADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPS m128 xmm xmm
//	VADDSUBPS m256 ymm ymm
//	VADDSUBPS xmm  xmm xmm
//	VADDSUBPS ymm  ymm ymm
//
// Construct and append a VADDSUBPS instruction to the active function.
func (c *Context) VADDSUBPS(mxy, xy, xy1 operand.Op) {
	c.addinstruction(x86.VADDSUBPS(mxy, xy, xy1))
}

// VADDSUBPS: Packed Single-FP Add/Subtract.
//
// Forms:
//
//	VADDSUBPS m128 xmm xmm
//	VADDSUBPS m256 ymm ymm
//	VADDSUBPS xmm  xmm xmm
//	VADDSUBPS ymm  ymm ymm
//
// Construct and append a VADDSUBPS instruction to the active function.
// Operates on the global context.
func VADDSUBPS(mxy, xy, xy1 operand.Op) { ctx.VADDSUBPS(mxy, xy, xy1) }

// VAESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDEC m128 xmm xmm
//	VAESDEC xmm  xmm xmm
//
// Construct and append a VAESDEC instruction to the active function.
func (c *Context) VAESDEC(mx, x, x1 operand.Op) {
	c.addinstruction(x86.VAESDEC(mx, x, x1))
}

// VAESDEC: Perform One Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDEC m128 xmm xmm
//	VAESDEC xmm  xmm xmm
//
// Construct and append a VAESDEC instruction to the active function.
// Operates on the global context.
func VAESDEC(mx, x, x1 operand.Op) { ctx.VAESDEC(mx, x, x1) }

// VAESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDECLAST m128 xmm xmm
//	VAESDECLAST xmm  xmm xmm
//
// Construct and append a VAESDECLAST instruction to the active function.
func (c *Context) VAESDECLAST(mx, x, x1 operand.Op) {
	c.addinstruction(x86.VAESDECLAST(mx, x, x1))
}

// VAESDECLAST: Perform Last Round of an AES Decryption Flow.
//
// Forms:
//
//	VAESDECLAST m128 xmm xmm
//	VAESDECLAST xmm  xmm xmm
//
// Construct and append a VAESDECLAST instruction to the active function.
// Operates on the global context.
func VAESDECLAST(mx, x, x1 operand.Op) { ctx.VAESDECLAST(mx, x, x1) }

// VAESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENC m128 xmm xmm
//	VAESENC xmm  xmm xmm
//
// Construct and append a VAESENC instruction to the active function.
func (c *Context) VAESENC(mx, x, x1 operand.Op) {
	c.addinstruction(x86.VAESENC(mx, x, x1))
}

// VAESENC: Perform One Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENC m128 xmm xmm
//	VAESENC xmm  xmm xmm
//
// Construct and append a VAESENC instruction to the active function.
// Operates on the global context.
func VAESENC(mx, x, x1 operand.Op) { ctx.VAESENC(mx, x, x1) }

// VAESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENCLAST m128 xmm xmm
//	VAESENCLAST xmm  xmm xmm
//
// Construct and append a VAESENCLAST instruction to the active function.
func (c *Context) VAESENCLAST(mx, x, x1 operand.Op) {
	c.addinstruction(x86.VAESENCLAST(mx, x, x1))
}

// VAESENCLAST: Perform Last Round of an AES Encryption Flow.
//
// Forms:
//
//	VAESENCLAST m128 xmm xmm
//	VAESENCLAST xmm  xmm xmm
//
// Construct and append a VAESENCLAST instruction to the active function.
// Operates on the global context.
func VAESENCLAST(mx, x, x1 operand.Op) { ctx.VAESENCLAST(mx, x, x1) }

// VAESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	VAESIMC m128 xmm
//	VAESIMC xmm  xmm
//
// Construct and append a VAESIMC instruction to the active function.
func (c *Context) VAESIMC(mx, x operand.Op) {
	c.addinstruction(x86.VAESIMC(mx, x))
}

// VAESIMC: Perform the AES InvMixColumn Transformation.
//
// Forms:
//
//	VAESIMC m128 xmm
//	VAESIMC xmm  xmm
//
// Construct and append a VAESIMC instruction to the active function.
// Operates on the global context.
func VAESIMC(mx, x operand.Op) { ctx.VAESIMC(mx, x) }

// VAESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	VAESKEYGENASSIST imm8 m128 xmm
//	VAESKEYGENASSIST imm8 xmm  xmm
//
// Construct and append a VAESKEYGENASSIST instruction to the active function.
func (c *Context) VAESKEYGENASSIST(i, mx, x operand.Op) {
	c.addinstruction(x86.VAESKEYGENASSIST(i, mx, x))
}

// VAESKEYGENASSIST: AES Round Key Generation Assist.
//
// Forms:
//
//	VAESKEYGENASSIST imm8 m128 xmm
//	VAESKEYGENASSIST imm8 xmm  xmm
//
// Construct and append a VAESKEYGENASSIST instruction to the active function.
// Operates on the global context.
func VAESKEYGENASSIST(i, mx, x operand.Op) { ctx.VAESKEYGENASSIST(i, mx, x) }

// VALIGND: Align Doubleword Vectors.
//
// Forms:
//
//	VALIGND imm8 m128 xmm k xmm
//	VALIGND imm8 m128 xmm xmm
//	VALIGND imm8 m256 ymm k ymm
//	VALIGND imm8 m256 ymm ymm
//	VALIGND imm8 xmm  xmm k xmm
//	VALIGND imm8 xmm  xmm xmm
//	VALIGND imm8 ymm  ymm k ymm
//	VALIGND imm8 ymm  ymm ymm
//	VALIGND imm8 m512 zmm k zmm
//	VALIGND imm8 m512 zmm zmm
//	VALIGND imm8 zmm  zmm k zmm
//	VALIGND imm8 zmm  zmm zmm
//
// Construct and append a VALIGND instruction to the active function.
func (c *Context) VALIGND(ops ...operand.Op) {
	c.addinstruction(x86.VALIGND(ops...))
}

// VALIGND: Align Doubleword Vectors.
//
// Forms:
//
//	VALIGND imm8 m128 xmm k xmm
//	VALIGND imm8 m128 xmm xmm
//	VALIGND imm8 m256 ymm k ymm
//	VALIGND imm8 m256 ymm ymm
//	VALIGND imm8 xmm  xmm k xmm
//	VALIGND imm8 xmm  xmm xmm
//	VALIGND imm8 ymm  ymm k ymm
//	VALIGND imm8 ymm  ymm ymm
//	VALIGND imm8 m512 zmm k zmm
//	VALIGND imm8 m512 zmm zmm
//	VALIGND imm8 zmm  zmm k zmm
//	VALIGND imm8 zmm  zmm zmm
//
// Construct and append a VALIGND instruction to the active function.
// Operates on the global context.
func VALIGND(ops ...operand.Op) { ctx.VALIGND(ops...) }

// VALIGND_BCST: Align Doubleword Vectors (Broadcast).
//
// Forms:
//
//	VALIGND.BCST imm8 m32 xmm k xmm
//	VALIGND.BCST imm8 m32 xmm xmm
//	VALIGND.BCST imm8 m32 ymm k ymm
//	VALIGND.BCST imm8 m32 ymm ymm
//	VALIGND.BCST imm8 m32 zmm k zmm
//	VALIGND.BCST imm8 m32 zmm zmm
//
// Construct and append a VALIGND.BCST instruction to the active function.
func (c *Context) VALIGND_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VALIGND_BCST(ops...))
}

// VALIGND_BCST: Align Doubleword Vectors (Broadcast).
//
// Forms:
//
//	VALIGND.BCST imm8 m32 xmm k xmm
//	VALIGND.BCST imm8 m32 xmm xmm
//	VALIGND.BCST imm8 m32 ymm k ymm
//	VALIGND.BCST imm8 m32 ymm ymm
//	VALIGND.BCST imm8 m32 zmm k zmm
//	VALIGND.BCST imm8 m32 zmm zmm
//
// Construct and append a VALIGND.BCST instruction to the active function.
// Operates on the global context.
func VALIGND_BCST(ops ...operand.Op) { ctx.VALIGND_BCST(ops...) }

// VALIGND_BCST_Z: Align Doubleword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGND.BCST.Z imm8 m32 xmm k xmm
//	VALIGND.BCST.Z imm8 m32 ymm k ymm
//	VALIGND.BCST.Z imm8 m32 zmm k zmm
//
// Construct and append a VALIGND.BCST.Z instruction to the active function.
func (c *Context) VALIGND_BCST_Z(i, m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VALIGND_BCST_Z(i, m, xyz, k, xyz1))
}

// VALIGND_BCST_Z: Align Doubleword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGND.BCST.Z imm8 m32 xmm k xmm
//	VALIGND.BCST.Z imm8 m32 ymm k ymm
//	VALIGND.BCST.Z imm8 m32 zmm k zmm
//
// Construct and append a VALIGND.BCST.Z instruction to the active function.
// Operates on the global context.
func VALIGND_BCST_Z(i, m, xyz, k, xyz1 operand.Op) { ctx.VALIGND_BCST_Z(i, m, xyz, k, xyz1) }

// VALIGND_Z: Align Doubleword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGND.Z imm8 m128 xmm k xmm
//	VALIGND.Z imm8 m256 ymm k ymm
//	VALIGND.Z imm8 xmm  xmm k xmm
//	VALIGND.Z imm8 ymm  ymm k ymm
//	VALIGND.Z imm8 m512 zmm k zmm
//	VALIGND.Z imm8 zmm  zmm k zmm
//
// Construct and append a VALIGND.Z instruction to the active function.
func (c *Context) VALIGND_Z(i, mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VALIGND_Z(i, mxyz, xyz, k, xyz1))
}

// VALIGND_Z: Align Doubleword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGND.Z imm8 m128 xmm k xmm
//	VALIGND.Z imm8 m256 ymm k ymm
//	VALIGND.Z imm8 xmm  xmm k xmm
//	VALIGND.Z imm8 ymm  ymm k ymm
//	VALIGND.Z imm8 m512 zmm k zmm
//	VALIGND.Z imm8 zmm  zmm k zmm
//
// Construct and append a VALIGND.Z instruction to the active function.
// Operates on the global context.
func VALIGND_Z(i, mxyz, xyz, k, xyz1 operand.Op) { ctx.VALIGND_Z(i, mxyz, xyz, k, xyz1) }

// VALIGNQ: Align Quadword Vectors.
//
// Forms:
//
//	VALIGNQ imm8 m128 xmm k xmm
//	VALIGNQ imm8 m128 xmm xmm
//	VALIGNQ imm8 m256 ymm k ymm
//	VALIGNQ imm8 m256 ymm ymm
//	VALIGNQ imm8 xmm  xmm k xmm
//	VALIGNQ imm8 xmm  xmm xmm
//	VALIGNQ imm8 ymm  ymm k ymm
//	VALIGNQ imm8 ymm  ymm ymm
//	VALIGNQ imm8 m512 zmm k zmm
//	VALIGNQ imm8 m512 zmm zmm
//	VALIGNQ imm8 zmm  zmm k zmm
//	VALIGNQ imm8 zmm  zmm zmm
//
// Construct and append a VALIGNQ instruction to the active function.
func (c *Context) VALIGNQ(ops ...operand.Op) {
	c.addinstruction(x86.VALIGNQ(ops...))
}

// VALIGNQ: Align Quadword Vectors.
//
// Forms:
//
//	VALIGNQ imm8 m128 xmm k xmm
//	VALIGNQ imm8 m128 xmm xmm
//	VALIGNQ imm8 m256 ymm k ymm
//	VALIGNQ imm8 m256 ymm ymm
//	VALIGNQ imm8 xmm  xmm k xmm
//	VALIGNQ imm8 xmm  xmm xmm
//	VALIGNQ imm8 ymm  ymm k ymm
//	VALIGNQ imm8 ymm  ymm ymm
//	VALIGNQ imm8 m512 zmm k zmm
//	VALIGNQ imm8 m512 zmm zmm
//	VALIGNQ imm8 zmm  zmm k zmm
//	VALIGNQ imm8 zmm  zmm zmm
//
// Construct and append a VALIGNQ instruction to the active function.
// Operates on the global context.
func VALIGNQ(ops ...operand.Op) { ctx.VALIGNQ(ops...) }

// VALIGNQ_BCST: Align Quadword Vectors (Broadcast).
//
// Forms:
//
//	VALIGNQ.BCST imm8 m64 xmm k xmm
//	VALIGNQ.BCST imm8 m64 xmm xmm
//	VALIGNQ.BCST imm8 m64 ymm k ymm
//	VALIGNQ.BCST imm8 m64 ymm ymm
//	VALIGNQ.BCST imm8 m64 zmm k zmm
//	VALIGNQ.BCST imm8 m64 zmm zmm
//
// Construct and append a VALIGNQ.BCST instruction to the active function.
func (c *Context) VALIGNQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VALIGNQ_BCST(ops...))
}

// VALIGNQ_BCST: Align Quadword Vectors (Broadcast).
//
// Forms:
//
//	VALIGNQ.BCST imm8 m64 xmm k xmm
//	VALIGNQ.BCST imm8 m64 xmm xmm
//	VALIGNQ.BCST imm8 m64 ymm k ymm
//	VALIGNQ.BCST imm8 m64 ymm ymm
//	VALIGNQ.BCST imm8 m64 zmm k zmm
//	VALIGNQ.BCST imm8 m64 zmm zmm
//
// Construct and append a VALIGNQ.BCST instruction to the active function.
// Operates on the global context.
func VALIGNQ_BCST(ops ...operand.Op) { ctx.VALIGNQ_BCST(ops...) }

// VALIGNQ_BCST_Z: Align Quadword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.BCST.Z imm8 m64 xmm k xmm
//	VALIGNQ.BCST.Z imm8 m64 ymm k ymm
//	VALIGNQ.BCST.Z imm8 m64 zmm k zmm
//
// Construct and append a VALIGNQ.BCST.Z instruction to the active function.
func (c *Context) VALIGNQ_BCST_Z(i, m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VALIGNQ_BCST_Z(i, m, xyz, k, xyz1))
}

// VALIGNQ_BCST_Z: Align Quadword Vectors (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.BCST.Z imm8 m64 xmm k xmm
//	VALIGNQ.BCST.Z imm8 m64 ymm k ymm
//	VALIGNQ.BCST.Z imm8 m64 zmm k zmm
//
// Construct and append a VALIGNQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VALIGNQ_BCST_Z(i, m, xyz, k, xyz1 operand.Op) { ctx.VALIGNQ_BCST_Z(i, m, xyz, k, xyz1) }

// VALIGNQ_Z: Align Quadword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.Z imm8 m128 xmm k xmm
//	VALIGNQ.Z imm8 m256 ymm k ymm
//	VALIGNQ.Z imm8 xmm  xmm k xmm
//	VALIGNQ.Z imm8 ymm  ymm k ymm
//	VALIGNQ.Z imm8 m512 zmm k zmm
//	VALIGNQ.Z imm8 zmm  zmm k zmm
//
// Construct and append a VALIGNQ.Z instruction to the active function.
func (c *Context) VALIGNQ_Z(i, mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VALIGNQ_Z(i, mxyz, xyz, k, xyz1))
}

// VALIGNQ_Z: Align Quadword Vectors (Zeroing Masking).
//
// Forms:
//
//	VALIGNQ.Z imm8 m128 xmm k xmm
//	VALIGNQ.Z imm8 m256 ymm k ymm
//	VALIGNQ.Z imm8 xmm  xmm k xmm
//	VALIGNQ.Z imm8 ymm  ymm k ymm
//	VALIGNQ.Z imm8 m512 zmm k zmm
//	VALIGNQ.Z imm8 zmm  zmm k zmm
//
// Construct and append a VALIGNQ.Z instruction to the active function.
// Operates on the global context.
func VALIGNQ_Z(i, mxyz, xyz, k, xyz1 operand.Op) { ctx.VALIGNQ_Z(i, mxyz, xyz, k, xyz1) }

// VANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPD m128 xmm xmm
//	VANDNPD m256 ymm ymm
//	VANDNPD xmm  xmm xmm
//	VANDNPD ymm  ymm ymm
//	VANDNPD m128 xmm k xmm
//	VANDNPD m256 ymm k ymm
//	VANDNPD xmm  xmm k xmm
//	VANDNPD ymm  ymm k ymm
//	VANDNPD m512 zmm k zmm
//	VANDNPD m512 zmm zmm
//	VANDNPD zmm  zmm k zmm
//	VANDNPD zmm  zmm zmm
//
// Construct and append a VANDNPD instruction to the active function.
func (c *Context) VANDNPD(ops ...operand.Op) {
	c.addinstruction(x86.VANDNPD(ops...))
}

// VANDNPD: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPD m128 xmm xmm
//	VANDNPD m256 ymm ymm
//	VANDNPD xmm  xmm xmm
//	VANDNPD ymm  ymm ymm
//	VANDNPD m128 xmm k xmm
//	VANDNPD m256 ymm k ymm
//	VANDNPD xmm  xmm k xmm
//	VANDNPD ymm  ymm k ymm
//	VANDNPD m512 zmm k zmm
//	VANDNPD m512 zmm zmm
//	VANDNPD zmm  zmm k zmm
//	VANDNPD zmm  zmm zmm
//
// Construct and append a VANDNPD instruction to the active function.
// Operates on the global context.
func VANDNPD(ops ...operand.Op) { ctx.VANDNPD(ops...) }

// VANDNPD_BCST: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPD.BCST m64 xmm k xmm
//	VANDNPD.BCST m64 xmm xmm
//	VANDNPD.BCST m64 ymm k ymm
//	VANDNPD.BCST m64 ymm ymm
//	VANDNPD.BCST m64 zmm k zmm
//	VANDNPD.BCST m64 zmm zmm
//
// Construct and append a VANDNPD.BCST instruction to the active function.
func (c *Context) VANDNPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VANDNPD_BCST(ops...))
}

// VANDNPD_BCST: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPD.BCST m64 xmm k xmm
//	VANDNPD.BCST m64 xmm xmm
//	VANDNPD.BCST m64 ymm k ymm
//	VANDNPD.BCST m64 ymm ymm
//	VANDNPD.BCST m64 zmm k zmm
//	VANDNPD.BCST m64 zmm zmm
//
// Construct and append a VANDNPD.BCST instruction to the active function.
// Operates on the global context.
func VANDNPD_BCST(ops ...operand.Op) { ctx.VANDNPD_BCST(ops...) }

// VANDNPD_BCST_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPD.BCST.Z m64 xmm k xmm
//	VANDNPD.BCST.Z m64 ymm k ymm
//	VANDNPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VANDNPD.BCST.Z instruction to the active function.
func (c *Context) VANDNPD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDNPD_BCST_Z(m, xyz, k, xyz1))
}

// VANDNPD_BCST_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPD.BCST.Z m64 xmm k xmm
//	VANDNPD.BCST.Z m64 ymm k ymm
//	VANDNPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VANDNPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VANDNPD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VANDNPD_BCST_Z(m, xyz, k, xyz1) }

// VANDNPD_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPD.Z m128 xmm k xmm
//	VANDNPD.Z m256 ymm k ymm
//	VANDNPD.Z xmm  xmm k xmm
//	VANDNPD.Z ymm  ymm k ymm
//	VANDNPD.Z m512 zmm k zmm
//	VANDNPD.Z zmm  zmm k zmm
//
// Construct and append a VANDNPD.Z instruction to the active function.
func (c *Context) VANDNPD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDNPD_Z(mxyz, xyz, k, xyz1))
}

// VANDNPD_Z: Bitwise Logical AND NOT of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPD.Z m128 xmm k xmm
//	VANDNPD.Z m256 ymm k ymm
//	VANDNPD.Z xmm  xmm k xmm
//	VANDNPD.Z ymm  ymm k ymm
//	VANDNPD.Z m512 zmm k zmm
//	VANDNPD.Z zmm  zmm k zmm
//
// Construct and append a VANDNPD.Z instruction to the active function.
// Operates on the global context.
func VANDNPD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VANDNPD_Z(mxyz, xyz, k, xyz1) }

// VANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPS m128 xmm xmm
//	VANDNPS m256 ymm ymm
//	VANDNPS xmm  xmm xmm
//	VANDNPS ymm  ymm ymm
//	VANDNPS m128 xmm k xmm
//	VANDNPS m256 ymm k ymm
//	VANDNPS xmm  xmm k xmm
//	VANDNPS ymm  ymm k ymm
//	VANDNPS m512 zmm k zmm
//	VANDNPS m512 zmm zmm
//	VANDNPS zmm  zmm k zmm
//	VANDNPS zmm  zmm zmm
//
// Construct and append a VANDNPS instruction to the active function.
func (c *Context) VANDNPS(ops ...operand.Op) {
	c.addinstruction(x86.VANDNPS(ops...))
}

// VANDNPS: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDNPS m128 xmm xmm
//	VANDNPS m256 ymm ymm
//	VANDNPS xmm  xmm xmm
//	VANDNPS ymm  ymm ymm
//	VANDNPS m128 xmm k xmm
//	VANDNPS m256 ymm k ymm
//	VANDNPS xmm  xmm k xmm
//	VANDNPS ymm  ymm k ymm
//	VANDNPS m512 zmm k zmm
//	VANDNPS m512 zmm zmm
//	VANDNPS zmm  zmm k zmm
//	VANDNPS zmm  zmm zmm
//
// Construct and append a VANDNPS instruction to the active function.
// Operates on the global context.
func VANDNPS(ops ...operand.Op) { ctx.VANDNPS(ops...) }

// VANDNPS_BCST: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPS.BCST m32 xmm k xmm
//	VANDNPS.BCST m32 xmm xmm
//	VANDNPS.BCST m32 ymm k ymm
//	VANDNPS.BCST m32 ymm ymm
//	VANDNPS.BCST m32 zmm k zmm
//	VANDNPS.BCST m32 zmm zmm
//
// Construct and append a VANDNPS.BCST instruction to the active function.
func (c *Context) VANDNPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VANDNPS_BCST(ops...))
}

// VANDNPS_BCST: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDNPS.BCST m32 xmm k xmm
//	VANDNPS.BCST m32 xmm xmm
//	VANDNPS.BCST m32 ymm k ymm
//	VANDNPS.BCST m32 ymm ymm
//	VANDNPS.BCST m32 zmm k zmm
//	VANDNPS.BCST m32 zmm zmm
//
// Construct and append a VANDNPS.BCST instruction to the active function.
// Operates on the global context.
func VANDNPS_BCST(ops ...operand.Op) { ctx.VANDNPS_BCST(ops...) }

// VANDNPS_BCST_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPS.BCST.Z m32 xmm k xmm
//	VANDNPS.BCST.Z m32 ymm k ymm
//	VANDNPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VANDNPS.BCST.Z instruction to the active function.
func (c *Context) VANDNPS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDNPS_BCST_Z(m, xyz, k, xyz1))
}

// VANDNPS_BCST_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDNPS.BCST.Z m32 xmm k xmm
//	VANDNPS.BCST.Z m32 ymm k ymm
//	VANDNPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VANDNPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VANDNPS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VANDNPS_BCST_Z(m, xyz, k, xyz1) }

// VANDNPS_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPS.Z m128 xmm k xmm
//	VANDNPS.Z m256 ymm k ymm
//	VANDNPS.Z xmm  xmm k xmm
//	VANDNPS.Z ymm  ymm k ymm
//	VANDNPS.Z m512 zmm k zmm
//	VANDNPS.Z zmm  zmm k zmm
//
// Construct and append a VANDNPS.Z instruction to the active function.
func (c *Context) VANDNPS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDNPS_Z(mxyz, xyz, k, xyz1))
}

// VANDNPS_Z: Bitwise Logical AND NOT of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDNPS.Z m128 xmm k xmm
//	VANDNPS.Z m256 ymm k ymm
//	VANDNPS.Z xmm  xmm k xmm
//	VANDNPS.Z ymm  ymm k ymm
//	VANDNPS.Z m512 zmm k zmm
//	VANDNPS.Z zmm  zmm k zmm
//
// Construct and append a VANDNPS.Z instruction to the active function.
// Operates on the global context.
func VANDNPS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VANDNPS_Z(mxyz, xyz, k, xyz1) }

// VANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPD m128 xmm xmm
//	VANDPD m256 ymm ymm
//	VANDPD xmm  xmm xmm
//	VANDPD ymm  ymm ymm
//	VANDPD m128 xmm k xmm
//	VANDPD m256 ymm k ymm
//	VANDPD xmm  xmm k xmm
//	VANDPD ymm  ymm k ymm
//	VANDPD m512 zmm k zmm
//	VANDPD m512 zmm zmm
//	VANDPD zmm  zmm k zmm
//	VANDPD zmm  zmm zmm
//
// Construct and append a VANDPD instruction to the active function.
func (c *Context) VANDPD(ops ...operand.Op) {
	c.addinstruction(x86.VANDPD(ops...))
}

// VANDPD: Bitwise Logical AND of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPD m128 xmm xmm
//	VANDPD m256 ymm ymm
//	VANDPD xmm  xmm xmm
//	VANDPD ymm  ymm ymm
//	VANDPD m128 xmm k xmm
//	VANDPD m256 ymm k ymm
//	VANDPD xmm  xmm k xmm
//	VANDPD ymm  ymm k ymm
//	VANDPD m512 zmm k zmm
//	VANDPD m512 zmm zmm
//	VANDPD zmm  zmm k zmm
//	VANDPD zmm  zmm zmm
//
// Construct and append a VANDPD instruction to the active function.
// Operates on the global context.
func VANDPD(ops ...operand.Op) { ctx.VANDPD(ops...) }

// VANDPD_BCST: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPD.BCST m64 xmm k xmm
//	VANDPD.BCST m64 xmm xmm
//	VANDPD.BCST m64 ymm k ymm
//	VANDPD.BCST m64 ymm ymm
//	VANDPD.BCST m64 zmm k zmm
//	VANDPD.BCST m64 zmm zmm
//
// Construct and append a VANDPD.BCST instruction to the active function.
func (c *Context) VANDPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VANDPD_BCST(ops...))
}

// VANDPD_BCST: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPD.BCST m64 xmm k xmm
//	VANDPD.BCST m64 xmm xmm
//	VANDPD.BCST m64 ymm k ymm
//	VANDPD.BCST m64 ymm ymm
//	VANDPD.BCST m64 zmm k zmm
//	VANDPD.BCST m64 zmm zmm
//
// Construct and append a VANDPD.BCST instruction to the active function.
// Operates on the global context.
func VANDPD_BCST(ops ...operand.Op) { ctx.VANDPD_BCST(ops...) }

// VANDPD_BCST_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPD.BCST.Z m64 xmm k xmm
//	VANDPD.BCST.Z m64 ymm k ymm
//	VANDPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VANDPD.BCST.Z instruction to the active function.
func (c *Context) VANDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDPD_BCST_Z(m, xyz, k, xyz1))
}

// VANDPD_BCST_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPD.BCST.Z m64 xmm k xmm
//	VANDPD.BCST.Z m64 ymm k ymm
//	VANDPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VANDPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VANDPD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VANDPD_BCST_Z(m, xyz, k, xyz1) }

// VANDPD_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPD.Z m128 xmm k xmm
//	VANDPD.Z m256 ymm k ymm
//	VANDPD.Z xmm  xmm k xmm
//	VANDPD.Z ymm  ymm k ymm
//	VANDPD.Z m512 zmm k zmm
//	VANDPD.Z zmm  zmm k zmm
//
// Construct and append a VANDPD.Z instruction to the active function.
func (c *Context) VANDPD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDPD_Z(mxyz, xyz, k, xyz1))
}

// VANDPD_Z: Bitwise Logical AND of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPD.Z m128 xmm k xmm
//	VANDPD.Z m256 ymm k ymm
//	VANDPD.Z xmm  xmm k xmm
//	VANDPD.Z ymm  ymm k ymm
//	VANDPD.Z m512 zmm k zmm
//	VANDPD.Z zmm  zmm k zmm
//
// Construct and append a VANDPD.Z instruction to the active function.
// Operates on the global context.
func VANDPD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VANDPD_Z(mxyz, xyz, k, xyz1) }

// VANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPS m128 xmm xmm
//	VANDPS m256 ymm ymm
//	VANDPS xmm  xmm xmm
//	VANDPS ymm  ymm ymm
//	VANDPS m128 xmm k xmm
//	VANDPS m256 ymm k ymm
//	VANDPS xmm  xmm k xmm
//	VANDPS ymm  ymm k ymm
//	VANDPS m512 zmm k zmm
//	VANDPS m512 zmm zmm
//	VANDPS zmm  zmm k zmm
//	VANDPS zmm  zmm zmm
//
// Construct and append a VANDPS instruction to the active function.
func (c *Context) VANDPS(ops ...operand.Op) {
	c.addinstruction(x86.VANDPS(ops...))
}

// VANDPS: Bitwise Logical AND of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VANDPS m128 xmm xmm
//	VANDPS m256 ymm ymm
//	VANDPS xmm  xmm xmm
//	VANDPS ymm  ymm ymm
//	VANDPS m128 xmm k xmm
//	VANDPS m256 ymm k ymm
//	VANDPS xmm  xmm k xmm
//	VANDPS ymm  ymm k ymm
//	VANDPS m512 zmm k zmm
//	VANDPS m512 zmm zmm
//	VANDPS zmm  zmm k zmm
//	VANDPS zmm  zmm zmm
//
// Construct and append a VANDPS instruction to the active function.
// Operates on the global context.
func VANDPS(ops ...operand.Op) { ctx.VANDPS(ops...) }

// VANDPS_BCST: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPS.BCST m32 xmm k xmm
//	VANDPS.BCST m32 xmm xmm
//	VANDPS.BCST m32 ymm k ymm
//	VANDPS.BCST m32 ymm ymm
//	VANDPS.BCST m32 zmm k zmm
//	VANDPS.BCST m32 zmm zmm
//
// Construct and append a VANDPS.BCST instruction to the active function.
func (c *Context) VANDPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VANDPS_BCST(ops...))
}

// VANDPS_BCST: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VANDPS.BCST m32 xmm k xmm
//	VANDPS.BCST m32 xmm xmm
//	VANDPS.BCST m32 ymm k ymm
//	VANDPS.BCST m32 ymm ymm
//	VANDPS.BCST m32 zmm k zmm
//	VANDPS.BCST m32 zmm zmm
//
// Construct and append a VANDPS.BCST instruction to the active function.
// Operates on the global context.
func VANDPS_BCST(ops ...operand.Op) { ctx.VANDPS_BCST(ops...) }

// VANDPS_BCST_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPS.BCST.Z m32 xmm k xmm
//	VANDPS.BCST.Z m32 ymm k ymm
//	VANDPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VANDPS.BCST.Z instruction to the active function.
func (c *Context) VANDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDPS_BCST_Z(m, xyz, k, xyz1))
}

// VANDPS_BCST_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VANDPS.BCST.Z m32 xmm k xmm
//	VANDPS.BCST.Z m32 ymm k ymm
//	VANDPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VANDPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VANDPS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VANDPS_BCST_Z(m, xyz, k, xyz1) }

// VANDPS_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPS.Z m128 xmm k xmm
//	VANDPS.Z m256 ymm k ymm
//	VANDPS.Z xmm  xmm k xmm
//	VANDPS.Z ymm  ymm k ymm
//	VANDPS.Z m512 zmm k zmm
//	VANDPS.Z zmm  zmm k zmm
//
// Construct and append a VANDPS.Z instruction to the active function.
func (c *Context) VANDPS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VANDPS_Z(mxyz, xyz, k, xyz1))
}

// VANDPS_Z: Bitwise Logical AND of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VANDPS.Z m128 xmm k xmm
//	VANDPS.Z m256 ymm k ymm
//	VANDPS.Z xmm  xmm k xmm
//	VANDPS.Z ymm  ymm k ymm
//	VANDPS.Z m512 zmm k zmm
//	VANDPS.Z zmm  zmm k zmm
//
// Construct and append a VANDPS.Z instruction to the active function.
// Operates on the global context.
func VANDPS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VANDPS_Z(mxyz, xyz, k, xyz1) }

// VBLENDMPD: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPD m128 xmm k xmm
//	VBLENDMPD m128 xmm xmm
//	VBLENDMPD m256 ymm k ymm
//	VBLENDMPD m256 ymm ymm
//	VBLENDMPD xmm  xmm k xmm
//	VBLENDMPD xmm  xmm xmm
//	VBLENDMPD ymm  ymm k ymm
//	VBLENDMPD ymm  ymm ymm
//	VBLENDMPD m512 zmm k zmm
//	VBLENDMPD m512 zmm zmm
//	VBLENDMPD zmm  zmm k zmm
//	VBLENDMPD zmm  zmm zmm
//
// Construct and append a VBLENDMPD instruction to the active function.
func (c *Context) VBLENDMPD(ops ...operand.Op) {
	c.addinstruction(x86.VBLENDMPD(ops...))
}

// VBLENDMPD: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPD m128 xmm k xmm
//	VBLENDMPD m128 xmm xmm
//	VBLENDMPD m256 ymm k ymm
//	VBLENDMPD m256 ymm ymm
//	VBLENDMPD xmm  xmm k xmm
//	VBLENDMPD xmm  xmm xmm
//	VBLENDMPD ymm  ymm k ymm
//	VBLENDMPD ymm  ymm ymm
//	VBLENDMPD m512 zmm k zmm
//	VBLENDMPD m512 zmm zmm
//	VBLENDMPD zmm  zmm k zmm
//	VBLENDMPD zmm  zmm zmm
//
// Construct and append a VBLENDMPD instruction to the active function.
// Operates on the global context.
func VBLENDMPD(ops ...operand.Op) { ctx.VBLENDMPD(ops...) }

// VBLENDMPD_BCST: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPD.BCST m64 xmm k xmm
//	VBLENDMPD.BCST m64 xmm xmm
//	VBLENDMPD.BCST m64 ymm k ymm
//	VBLENDMPD.BCST m64 ymm ymm
//	VBLENDMPD.BCST m64 zmm k zmm
//	VBLENDMPD.BCST m64 zmm zmm
//
// Construct and append a VBLENDMPD.BCST instruction to the active function.
func (c *Context) VBLENDMPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VBLENDMPD_BCST(ops...))
}

// VBLENDMPD_BCST: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPD.BCST m64 xmm k xmm
//	VBLENDMPD.BCST m64 xmm xmm
//	VBLENDMPD.BCST m64 ymm k ymm
//	VBLENDMPD.BCST m64 ymm ymm
//	VBLENDMPD.BCST m64 zmm k zmm
//	VBLENDMPD.BCST m64 zmm zmm
//
// Construct and append a VBLENDMPD.BCST instruction to the active function.
// Operates on the global context.
func VBLENDMPD_BCST(ops ...operand.Op) { ctx.VBLENDMPD_BCST(ops...) }

// VBLENDMPD_BCST_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.BCST.Z m64 xmm k xmm
//	VBLENDMPD.BCST.Z m64 ymm k ymm
//	VBLENDMPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VBLENDMPD.BCST.Z instruction to the active function.
func (c *Context) VBLENDMPD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VBLENDMPD_BCST_Z(m, xyz, k, xyz1))
}

// VBLENDMPD_BCST_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.BCST.Z m64 xmm k xmm
//	VBLENDMPD.BCST.Z m64 ymm k ymm
//	VBLENDMPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VBLENDMPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VBLENDMPD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VBLENDMPD_BCST_Z(m, xyz, k, xyz1) }

// VBLENDMPD_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.Z m128 xmm k xmm
//	VBLENDMPD.Z m256 ymm k ymm
//	VBLENDMPD.Z xmm  xmm k xmm
//	VBLENDMPD.Z ymm  ymm k ymm
//	VBLENDMPD.Z m512 zmm k zmm
//	VBLENDMPD.Z zmm  zmm k zmm
//
// Construct and append a VBLENDMPD.Z instruction to the active function.
func (c *Context) VBLENDMPD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VBLENDMPD_Z(mxyz, xyz, k, xyz1))
}

// VBLENDMPD_Z: Blend Packed Double-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPD.Z m128 xmm k xmm
//	VBLENDMPD.Z m256 ymm k ymm
//	VBLENDMPD.Z xmm  xmm k xmm
//	VBLENDMPD.Z ymm  ymm k ymm
//	VBLENDMPD.Z m512 zmm k zmm
//	VBLENDMPD.Z zmm  zmm k zmm
//
// Construct and append a VBLENDMPD.Z instruction to the active function.
// Operates on the global context.
func VBLENDMPD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VBLENDMPD_Z(mxyz, xyz, k, xyz1) }

// VBLENDMPS: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPS m128 xmm k xmm
//	VBLENDMPS m128 xmm xmm
//	VBLENDMPS m256 ymm k ymm
//	VBLENDMPS m256 ymm ymm
//	VBLENDMPS xmm  xmm k xmm
//	VBLENDMPS xmm  xmm xmm
//	VBLENDMPS ymm  ymm k ymm
//	VBLENDMPS ymm  ymm ymm
//	VBLENDMPS m512 zmm k zmm
//	VBLENDMPS m512 zmm zmm
//	VBLENDMPS zmm  zmm k zmm
//	VBLENDMPS zmm  zmm zmm
//
// Construct and append a VBLENDMPS instruction to the active function.
func (c *Context) VBLENDMPS(ops ...operand.Op) {
	c.addinstruction(x86.VBLENDMPS(ops...))
}

// VBLENDMPS: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control.
//
// Forms:
//
//	VBLENDMPS m128 xmm k xmm
//	VBLENDMPS m128 xmm xmm
//	VBLENDMPS m256 ymm k ymm
//	VBLENDMPS m256 ymm ymm
//	VBLENDMPS xmm  xmm k xmm
//	VBLENDMPS xmm  xmm xmm
//	VBLENDMPS ymm  ymm k ymm
//	VBLENDMPS ymm  ymm ymm
//	VBLENDMPS m512 zmm k zmm
//	VBLENDMPS m512 zmm zmm
//	VBLENDMPS zmm  zmm k zmm
//	VBLENDMPS zmm  zmm zmm
//
// Construct and append a VBLENDMPS instruction to the active function.
// Operates on the global context.
func VBLENDMPS(ops ...operand.Op) { ctx.VBLENDMPS(ops...) }

// VBLENDMPS_BCST: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPS.BCST m32 xmm k xmm
//	VBLENDMPS.BCST m32 xmm xmm
//	VBLENDMPS.BCST m32 ymm k ymm
//	VBLENDMPS.BCST m32 ymm ymm
//	VBLENDMPS.BCST m32 zmm k zmm
//	VBLENDMPS.BCST m32 zmm zmm
//
// Construct and append a VBLENDMPS.BCST instruction to the active function.
func (c *Context) VBLENDMPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VBLENDMPS_BCST(ops...))
}

// VBLENDMPS_BCST: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast).
//
// Forms:
//
//	VBLENDMPS.BCST m32 xmm k xmm
//	VBLENDMPS.BCST m32 xmm xmm
//	VBLENDMPS.BCST m32 ymm k ymm
//	VBLENDMPS.BCST m32 ymm ymm
//	VBLENDMPS.BCST m32 zmm k zmm
//	VBLENDMPS.BCST m32 zmm zmm
//
// Construct and append a VBLENDMPS.BCST instruction to the active function.
// Operates on the global context.
func VBLENDMPS_BCST(ops ...operand.Op) { ctx.VBLENDMPS_BCST(ops...) }

// VBLENDMPS_BCST_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.BCST.Z m32 xmm k xmm
//	VBLENDMPS.BCST.Z m32 ymm k ymm
//	VBLENDMPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VBLENDMPS.BCST.Z instruction to the active function.
func (c *Context) VBLENDMPS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VBLENDMPS_BCST_Z(m, xyz, k, xyz1))
}

// VBLENDMPS_BCST_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.BCST.Z m32 xmm k xmm
//	VBLENDMPS.BCST.Z m32 ymm k ymm
//	VBLENDMPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VBLENDMPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VBLENDMPS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VBLENDMPS_BCST_Z(m, xyz, k, xyz1) }

// VBLENDMPS_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.Z m128 xmm k xmm
//	VBLENDMPS.Z m256 ymm k ymm
//	VBLENDMPS.Z xmm  xmm k xmm
//	VBLENDMPS.Z ymm  ymm k ymm
//	VBLENDMPS.Z m512 zmm k zmm
//	VBLENDMPS.Z zmm  zmm k zmm
//
// Construct and append a VBLENDMPS.Z instruction to the active function.
func (c *Context) VBLENDMPS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VBLENDMPS_Z(mxyz, xyz, k, xyz1))
}

// VBLENDMPS_Z: Blend Packed Single-Precision Floating-Point Vectors Using an OpMask Control (Zeroing Masking).
//
// Forms:
//
//	VBLENDMPS.Z m128 xmm k xmm
//	VBLENDMPS.Z m256 ymm k ymm
//	VBLENDMPS.Z xmm  xmm k xmm
//	VBLENDMPS.Z ymm  ymm k ymm
//	VBLENDMPS.Z m512 zmm k zmm
//	VBLENDMPS.Z zmm  zmm k zmm
//
// Construct and append a VBLENDMPS.Z instruction to the active function.
// Operates on the global context.
func VBLENDMPS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VBLENDMPS_Z(mxyz, xyz, k, xyz1) }

// VBLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPD imm8 m128 xmm xmm
//	VBLENDPD imm8 m256 ymm ymm
//	VBLENDPD imm8 xmm  xmm xmm
//	VBLENDPD imm8 ymm  ymm ymm
//
// Construct and append a VBLENDPD instruction to the active function.
func (c *Context) VBLENDPD(i, mxy, xy, xy1 operand.Op) {
	c.addinstruction(x86.VBLENDPD(i, mxy, xy, xy1))
}

// VBLENDPD: Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPD imm8 m128 xmm xmm
//	VBLENDPD imm8 m256 ymm ymm
//	VBLENDPD imm8 xmm  xmm xmm
//	VBLENDPD imm8 ymm  ymm ymm
//
// Construct and append a VBLENDPD instruction to the active function.
// Operates on the global context.
func VBLENDPD(i, mxy, xy, xy1 operand.Op) { ctx.VBLENDPD(i, mxy, xy, xy1) }

// VBLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPS imm8 m128 xmm xmm
//	VBLENDPS imm8 m256 ymm ymm
//	VBLENDPS imm8 xmm  xmm xmm
//	VBLENDPS imm8 ymm  ymm ymm
//
// Construct and append a VBLENDPS instruction to the active function.
func (c *Context) VBLENDPS(i, mxy, xy, xy1 operand.Op) {
	c.addinstruction(x86.VBLENDPS(i, mxy, xy, xy1))
}

// VBLENDPS:  Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDPS imm8 m128 xmm xmm
//	VBLENDPS imm8 m256 ymm ymm
//	VBLENDPS imm8 xmm  xmm xmm
//	VBLENDPS imm8 ymm  ymm ymm
//
// Construct and append a VBLENDPS instruction to the active function.
// Operates on the global context.
func VBLENDPS(i, mxy, xy, xy1 operand.Op) { ctx.VBLENDPS(i, mxy, xy, xy1) }

// VBLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPD xmm m128 xmm xmm
//	VBLENDVPD xmm xmm  xmm xmm
//	VBLENDVPD ymm m256 ymm ymm
//	VBLENDVPD ymm ymm  ymm ymm
//
// Construct and append a VBLENDVPD instruction to the active function.
func (c *Context) VBLENDVPD(xy, mxy, xy1, xy2 operand.Op) {
	c.addinstruction(x86.VBLENDVPD(xy, mxy, xy1, xy2))
}

// VBLENDVPD:  Variable Blend Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPD xmm m128 xmm xmm
//	VBLENDVPD xmm xmm  xmm xmm
//	VBLENDVPD ymm m256 ymm ymm
//	VBLENDVPD ymm ymm  ymm ymm
//
// Construct and append a VBLENDVPD instruction to the active function.
// Operates on the global context.
func VBLENDVPD(xy, mxy, xy1, xy2 operand.Op) { ctx.VBLENDVPD(xy, mxy, xy1, xy2) }

// VBLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPS xmm m128 xmm xmm
//	VBLENDVPS xmm xmm  xmm xmm
//	VBLENDVPS ymm m256 ymm ymm
//	VBLENDVPS ymm ymm  ymm ymm
//
// Construct and append a VBLENDVPS instruction to the active function.
func (c *Context) VBLENDVPS(xy, mxy, xy1, xy2 operand.Op) {
	c.addinstruction(x86.VBLENDVPS(xy, mxy, xy1, xy2))
}

// VBLENDVPS:  Variable Blend Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VBLENDVPS xmm m128 xmm xmm
//	VBLENDVPS xmm xmm  xmm xmm
//	VBLENDVPS ymm m256 ymm ymm
//	VBLENDVPS ymm ymm  ymm ymm
//
// Construct and append a VBLENDVPS instruction to the active function.
// Operates on the global context.
func VBLENDVPS(xy, mxy, xy1, xy2 operand.Op) { ctx.VBLENDVPS(xy, mxy, xy1, xy2) }

// VBROADCASTF128: Broadcast 128 Bit of Floating-Point Data.
//
// Forms:
//
//	VBROADCASTF128 m128 ymm
//
// Construct and append a VBROADCASTF128 instruction to the active function.
func (c *Context) VBROADCASTF128(m, y operand.Op) {
	c.addinstruction(x86.VBROADCASTF128(m, y))
}

// VBROADCASTF128: Broadcast 128 Bit of Floating-Point Data.
//
// Forms:
//
//	VBROADCASTF128 m128 ymm
//
// Construct and append a VBROADCASTF128 instruction to the active function.
// Operates on the global context.
func VBROADCASTF128(m, y operand.Op) { ctx.VBROADCASTF128(m, y) }

// VBROADCASTF32X2: Broadcast Two Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X2 m64 k ymm
//	VBROADCASTF32X2 m64 ymm
//	VBROADCASTF32X2 xmm k ymm
//	VBROADCASTF32X2 xmm ymm
//	VBROADCASTF32X2 m64 k zmm
//	VBROADCASTF32X2 m64 zmm
//	VBROADCASTF32X2 xmm k zmm
//	VBROADCASTF32X2 xmm zmm
//
// Construct and append a VBROADCASTF32X2 instruction to the active function.
func (c *Context) VBROADCASTF32X2(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X2(ops...))
}

// VBROADCASTF32X2: Broadcast Two Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X2 m64 k ymm
//	VBROADCASTF32X2 m64 ymm
//	VBROADCASTF32X2 xmm k ymm
//	VBROADCASTF32X2 xmm ymm
//	VBROADCASTF32X2 m64 k zmm
//	VBROADCASTF32X2 m64 zmm
//	VBROADCASTF32X2 xmm k zmm
//	VBROADCASTF32X2 xmm zmm
//
// Construct and append a VBROADCASTF32X2 instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X2(ops ...operand.Op) { ctx.VBROADCASTF32X2(ops...) }

// VBROADCASTF32X2_Z: Broadcast Two Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X2.Z m64 k ymm
//	VBROADCASTF32X2.Z xmm k ymm
//	VBROADCASTF32X2.Z m64 k zmm
//	VBROADCASTF32X2.Z xmm k zmm
//
// Construct and append a VBROADCASTF32X2.Z instruction to the active function.
func (c *Context) VBROADCASTF32X2_Z(mx, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X2_Z(mx, k, yz))
}

// VBROADCASTF32X2_Z: Broadcast Two Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X2.Z m64 k ymm
//	VBROADCASTF32X2.Z xmm k ymm
//	VBROADCASTF32X2.Z m64 k zmm
//	VBROADCASTF32X2.Z xmm k zmm
//
// Construct and append a VBROADCASTF32X2.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X2_Z(mx, k, yz operand.Op) { ctx.VBROADCASTF32X2_Z(mx, k, yz) }

// VBROADCASTF32X4: Broadcast Four Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X4 m128 k ymm
//	VBROADCASTF32X4 m128 ymm
//	VBROADCASTF32X4 m128 k zmm
//	VBROADCASTF32X4 m128 zmm
//
// Construct and append a VBROADCASTF32X4 instruction to the active function.
func (c *Context) VBROADCASTF32X4(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X4(ops...))
}

// VBROADCASTF32X4: Broadcast Four Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X4 m128 k ymm
//	VBROADCASTF32X4 m128 ymm
//	VBROADCASTF32X4 m128 k zmm
//	VBROADCASTF32X4 m128 zmm
//
// Construct and append a VBROADCASTF32X4 instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X4(ops ...operand.Op) { ctx.VBROADCASTF32X4(ops...) }

// VBROADCASTF32X4_Z: Broadcast Four Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X4.Z m128 k ymm
//	VBROADCASTF32X4.Z m128 k zmm
//
// Construct and append a VBROADCASTF32X4.Z instruction to the active function.
func (c *Context) VBROADCASTF32X4_Z(m, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X4_Z(m, k, yz))
}

// VBROADCASTF32X4_Z: Broadcast Four Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X4.Z m128 k ymm
//	VBROADCASTF32X4.Z m128 k zmm
//
// Construct and append a VBROADCASTF32X4.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X4_Z(m, k, yz operand.Op) { ctx.VBROADCASTF32X4_Z(m, k, yz) }

// VBROADCASTF32X8: Broadcast Eight Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X8 m256 k zmm
//	VBROADCASTF32X8 m256 zmm
//
// Construct and append a VBROADCASTF32X8 instruction to the active function.
func (c *Context) VBROADCASTF32X8(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X8(ops...))
}

// VBROADCASTF32X8: Broadcast Eight Single-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF32X8 m256 k zmm
//	VBROADCASTF32X8 m256 zmm
//
// Construct and append a VBROADCASTF32X8 instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X8(ops ...operand.Op) { ctx.VBROADCASTF32X8(ops...) }

// VBROADCASTF32X8_Z: Broadcast Eight Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X8.Z m256 k zmm
//
// Construct and append a VBROADCASTF32X8.Z instruction to the active function.
func (c *Context) VBROADCASTF32X8_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VBROADCASTF32X8_Z(m, k, z))
}

// VBROADCASTF32X8_Z: Broadcast Eight Single-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF32X8.Z m256 k zmm
//
// Construct and append a VBROADCASTF32X8.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTF32X8_Z(m, k, z operand.Op) { ctx.VBROADCASTF32X8_Z(m, k, z) }

// VBROADCASTF64X2: Broadcast Two Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X2 m128 k ymm
//	VBROADCASTF64X2 m128 ymm
//	VBROADCASTF64X2 m128 k zmm
//	VBROADCASTF64X2 m128 zmm
//
// Construct and append a VBROADCASTF64X2 instruction to the active function.
func (c *Context) VBROADCASTF64X2(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTF64X2(ops...))
}

// VBROADCASTF64X2: Broadcast Two Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X2 m128 k ymm
//	VBROADCASTF64X2 m128 ymm
//	VBROADCASTF64X2 m128 k zmm
//	VBROADCASTF64X2 m128 zmm
//
// Construct and append a VBROADCASTF64X2 instruction to the active function.
// Operates on the global context.
func VBROADCASTF64X2(ops ...operand.Op) { ctx.VBROADCASTF64X2(ops...) }

// VBROADCASTF64X2_Z: Broadcast Two Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X2.Z m128 k ymm
//	VBROADCASTF64X2.Z m128 k zmm
//
// Construct and append a VBROADCASTF64X2.Z instruction to the active function.
func (c *Context) VBROADCASTF64X2_Z(m, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTF64X2_Z(m, k, yz))
}

// VBROADCASTF64X2_Z: Broadcast Two Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X2.Z m128 k ymm
//	VBROADCASTF64X2.Z m128 k zmm
//
// Construct and append a VBROADCASTF64X2.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTF64X2_Z(m, k, yz operand.Op) { ctx.VBROADCASTF64X2_Z(m, k, yz) }

// VBROADCASTF64X4: Broadcast Four Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X4 m256 k zmm
//	VBROADCASTF64X4 m256 zmm
//
// Construct and append a VBROADCASTF64X4 instruction to the active function.
func (c *Context) VBROADCASTF64X4(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTF64X4(ops...))
}

// VBROADCASTF64X4: Broadcast Four Double-Precision Floating-Point Elements.
//
// Forms:
//
//	VBROADCASTF64X4 m256 k zmm
//	VBROADCASTF64X4 m256 zmm
//
// Construct and append a VBROADCASTF64X4 instruction to the active function.
// Operates on the global context.
func VBROADCASTF64X4(ops ...operand.Op) { ctx.VBROADCASTF64X4(ops...) }

// VBROADCASTF64X4_Z: Broadcast Four Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X4.Z m256 k zmm
//
// Construct and append a VBROADCASTF64X4.Z instruction to the active function.
func (c *Context) VBROADCASTF64X4_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VBROADCASTF64X4_Z(m, k, z))
}

// VBROADCASTF64X4_Z: Broadcast Four Double-Precision Floating-Point Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTF64X4.Z m256 k zmm
//
// Construct and append a VBROADCASTF64X4.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTF64X4_Z(m, k, z operand.Op) { ctx.VBROADCASTF64X4_Z(m, k, z) }

// VBROADCASTI128: Broadcast 128 Bits of Integer Data.
//
// Forms:
//
//	VBROADCASTI128 m128 ymm
//
// Construct and append a VBROADCASTI128 instruction to the active function.
func (c *Context) VBROADCASTI128(m, y operand.Op) {
	c.addinstruction(x86.VBROADCASTI128(m, y))
}

// VBROADCASTI128: Broadcast 128 Bits of Integer Data.
//
// Forms:
//
//	VBROADCASTI128 m128 ymm
//
// Construct and append a VBROADCASTI128 instruction to the active function.
// Operates on the global context.
func VBROADCASTI128(m, y operand.Op) { ctx.VBROADCASTI128(m, y) }

// VBROADCASTI32X2: Broadcast Two Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X2 m64 k xmm
//	VBROADCASTI32X2 m64 k ymm
//	VBROADCASTI32X2 m64 xmm
//	VBROADCASTI32X2 m64 ymm
//	VBROADCASTI32X2 xmm k xmm
//	VBROADCASTI32X2 xmm k ymm
//	VBROADCASTI32X2 xmm xmm
//	VBROADCASTI32X2 xmm ymm
//	VBROADCASTI32X2 m64 k zmm
//	VBROADCASTI32X2 m64 zmm
//	VBROADCASTI32X2 xmm k zmm
//	VBROADCASTI32X2 xmm zmm
//
// Construct and append a VBROADCASTI32X2 instruction to the active function.
func (c *Context) VBROADCASTI32X2(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X2(ops...))
}

// VBROADCASTI32X2: Broadcast Two Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X2 m64 k xmm
//	VBROADCASTI32X2 m64 k ymm
//	VBROADCASTI32X2 m64 xmm
//	VBROADCASTI32X2 m64 ymm
//	VBROADCASTI32X2 xmm k xmm
//	VBROADCASTI32X2 xmm k ymm
//	VBROADCASTI32X2 xmm xmm
//	VBROADCASTI32X2 xmm ymm
//	VBROADCASTI32X2 m64 k zmm
//	VBROADCASTI32X2 m64 zmm
//	VBROADCASTI32X2 xmm k zmm
//	VBROADCASTI32X2 xmm zmm
//
// Construct and append a VBROADCASTI32X2 instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X2(ops ...operand.Op) { ctx.VBROADCASTI32X2(ops...) }

// VBROADCASTI32X2_Z: Broadcast Two Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X2.Z m64 k xmm
//	VBROADCASTI32X2.Z m64 k ymm
//	VBROADCASTI32X2.Z xmm k xmm
//	VBROADCASTI32X2.Z xmm k ymm
//	VBROADCASTI32X2.Z m64 k zmm
//	VBROADCASTI32X2.Z xmm k zmm
//
// Construct and append a VBROADCASTI32X2.Z instruction to the active function.
func (c *Context) VBROADCASTI32X2_Z(mx, k, xyz operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X2_Z(mx, k, xyz))
}

// VBROADCASTI32X2_Z: Broadcast Two Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X2.Z m64 k xmm
//	VBROADCASTI32X2.Z m64 k ymm
//	VBROADCASTI32X2.Z xmm k xmm
//	VBROADCASTI32X2.Z xmm k ymm
//	VBROADCASTI32X2.Z m64 k zmm
//	VBROADCASTI32X2.Z xmm k zmm
//
// Construct and append a VBROADCASTI32X2.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X2_Z(mx, k, xyz operand.Op) { ctx.VBROADCASTI32X2_Z(mx, k, xyz) }

// VBROADCASTI32X4: Broadcast Four Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X4 m128 k ymm
//	VBROADCASTI32X4 m128 ymm
//	VBROADCASTI32X4 m128 k zmm
//	VBROADCASTI32X4 m128 zmm
//
// Construct and append a VBROADCASTI32X4 instruction to the active function.
func (c *Context) VBROADCASTI32X4(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X4(ops...))
}

// VBROADCASTI32X4: Broadcast Four Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X4 m128 k ymm
//	VBROADCASTI32X4 m128 ymm
//	VBROADCASTI32X4 m128 k zmm
//	VBROADCASTI32X4 m128 zmm
//
// Construct and append a VBROADCASTI32X4 instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X4(ops ...operand.Op) { ctx.VBROADCASTI32X4(ops...) }

// VBROADCASTI32X4_Z: Broadcast Four Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X4.Z m128 k ymm
//	VBROADCASTI32X4.Z m128 k zmm
//
// Construct and append a VBROADCASTI32X4.Z instruction to the active function.
func (c *Context) VBROADCASTI32X4_Z(m, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X4_Z(m, k, yz))
}

// VBROADCASTI32X4_Z: Broadcast Four Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X4.Z m128 k ymm
//	VBROADCASTI32X4.Z m128 k zmm
//
// Construct and append a VBROADCASTI32X4.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X4_Z(m, k, yz operand.Op) { ctx.VBROADCASTI32X4_Z(m, k, yz) }

// VBROADCASTI32X8: Broadcast Eight Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X8 m256 k zmm
//	VBROADCASTI32X8 m256 zmm
//
// Construct and append a VBROADCASTI32X8 instruction to the active function.
func (c *Context) VBROADCASTI32X8(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X8(ops...))
}

// VBROADCASTI32X8: Broadcast Eight Doubleword Elements.
//
// Forms:
//
//	VBROADCASTI32X8 m256 k zmm
//	VBROADCASTI32X8 m256 zmm
//
// Construct and append a VBROADCASTI32X8 instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X8(ops ...operand.Op) { ctx.VBROADCASTI32X8(ops...) }

// VBROADCASTI32X8_Z: Broadcast Eight Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X8.Z m256 k zmm
//
// Construct and append a VBROADCASTI32X8.Z instruction to the active function.
func (c *Context) VBROADCASTI32X8_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VBROADCASTI32X8_Z(m, k, z))
}

// VBROADCASTI32X8_Z: Broadcast Eight Doubleword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI32X8.Z m256 k zmm
//
// Construct and append a VBROADCASTI32X8.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTI32X8_Z(m, k, z operand.Op) { ctx.VBROADCASTI32X8_Z(m, k, z) }

// VBROADCASTI64X2: Broadcast Two Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X2 m128 k ymm
//	VBROADCASTI64X2 m128 ymm
//	VBROADCASTI64X2 m128 k zmm
//	VBROADCASTI64X2 m128 zmm
//
// Construct and append a VBROADCASTI64X2 instruction to the active function.
func (c *Context) VBROADCASTI64X2(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTI64X2(ops...))
}

// VBROADCASTI64X2: Broadcast Two Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X2 m128 k ymm
//	VBROADCASTI64X2 m128 ymm
//	VBROADCASTI64X2 m128 k zmm
//	VBROADCASTI64X2 m128 zmm
//
// Construct and append a VBROADCASTI64X2 instruction to the active function.
// Operates on the global context.
func VBROADCASTI64X2(ops ...operand.Op) { ctx.VBROADCASTI64X2(ops...) }

// VBROADCASTI64X2_Z: Broadcast Two Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X2.Z m128 k ymm
//	VBROADCASTI64X2.Z m128 k zmm
//
// Construct and append a VBROADCASTI64X2.Z instruction to the active function.
func (c *Context) VBROADCASTI64X2_Z(m, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTI64X2_Z(m, k, yz))
}

// VBROADCASTI64X2_Z: Broadcast Two Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X2.Z m128 k ymm
//	VBROADCASTI64X2.Z m128 k zmm
//
// Construct and append a VBROADCASTI64X2.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTI64X2_Z(m, k, yz operand.Op) { ctx.VBROADCASTI64X2_Z(m, k, yz) }

// VBROADCASTI64X4: Broadcast Four Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X4 m256 k zmm
//	VBROADCASTI64X4 m256 zmm
//
// Construct and append a VBROADCASTI64X4 instruction to the active function.
func (c *Context) VBROADCASTI64X4(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTI64X4(ops...))
}

// VBROADCASTI64X4: Broadcast Four Quadword Elements.
//
// Forms:
//
//	VBROADCASTI64X4 m256 k zmm
//	VBROADCASTI64X4 m256 zmm
//
// Construct and append a VBROADCASTI64X4 instruction to the active function.
// Operates on the global context.
func VBROADCASTI64X4(ops ...operand.Op) { ctx.VBROADCASTI64X4(ops...) }

// VBROADCASTI64X4_Z: Broadcast Four Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X4.Z m256 k zmm
//
// Construct and append a VBROADCASTI64X4.Z instruction to the active function.
func (c *Context) VBROADCASTI64X4_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VBROADCASTI64X4_Z(m, k, z))
}

// VBROADCASTI64X4_Z: Broadcast Four Quadword Elements (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTI64X4.Z m256 k zmm
//
// Construct and append a VBROADCASTI64X4.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTI64X4_Z(m, k, z operand.Op) { ctx.VBROADCASTI64X4_Z(m, k, z) }

// VBROADCASTSD: Broadcast Double-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSD xmm ymm
//	VBROADCASTSD m64 ymm
//	VBROADCASTSD m64 k ymm
//	VBROADCASTSD xmm k ymm
//	VBROADCASTSD m64 k zmm
//	VBROADCASTSD m64 zmm
//	VBROADCASTSD xmm k zmm
//	VBROADCASTSD xmm zmm
//
// Construct and append a VBROADCASTSD instruction to the active function.
func (c *Context) VBROADCASTSD(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTSD(ops...))
}

// VBROADCASTSD: Broadcast Double-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSD xmm ymm
//	VBROADCASTSD m64 ymm
//	VBROADCASTSD m64 k ymm
//	VBROADCASTSD xmm k ymm
//	VBROADCASTSD m64 k zmm
//	VBROADCASTSD m64 zmm
//	VBROADCASTSD xmm k zmm
//	VBROADCASTSD xmm zmm
//
// Construct and append a VBROADCASTSD instruction to the active function.
// Operates on the global context.
func VBROADCASTSD(ops ...operand.Op) { ctx.VBROADCASTSD(ops...) }

// VBROADCASTSD_Z: Broadcast Double-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSD.Z m64 k ymm
//	VBROADCASTSD.Z xmm k ymm
//	VBROADCASTSD.Z m64 k zmm
//	VBROADCASTSD.Z xmm k zmm
//
// Construct and append a VBROADCASTSD.Z instruction to the active function.
func (c *Context) VBROADCASTSD_Z(mx, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTSD_Z(mx, k, yz))
}

// VBROADCASTSD_Z: Broadcast Double-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSD.Z m64 k ymm
//	VBROADCASTSD.Z xmm k ymm
//	VBROADCASTSD.Z m64 k zmm
//	VBROADCASTSD.Z xmm k zmm
//
// Construct and append a VBROADCASTSD.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTSD_Z(mx, k, yz operand.Op) { ctx.VBROADCASTSD_Z(mx, k, yz) }

// VBROADCASTSS: Broadcast Single-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSS xmm xmm
//	VBROADCASTSS xmm ymm
//	VBROADCASTSS m32 xmm
//	VBROADCASTSS m32 ymm
//	VBROADCASTSS m32 k ymm
//	VBROADCASTSS xmm k ymm
//	VBROADCASTSS m32 k zmm
//	VBROADCASTSS m32 zmm
//	VBROADCASTSS xmm k zmm
//	VBROADCASTSS xmm zmm
//
// Construct and append a VBROADCASTSS instruction to the active function.
func (c *Context) VBROADCASTSS(ops ...operand.Op) {
	c.addinstruction(x86.VBROADCASTSS(ops...))
}

// VBROADCASTSS: Broadcast Single-Precision Floating-Point Element.
//
// Forms:
//
//	VBROADCASTSS xmm xmm
//	VBROADCASTSS xmm ymm
//	VBROADCASTSS m32 xmm
//	VBROADCASTSS m32 ymm
//	VBROADCASTSS m32 k ymm
//	VBROADCASTSS xmm k ymm
//	VBROADCASTSS m32 k zmm
//	VBROADCASTSS m32 zmm
//	VBROADCASTSS xmm k zmm
//	VBROADCASTSS xmm zmm
//
// Construct and append a VBROADCASTSS instruction to the active function.
// Operates on the global context.
func VBROADCASTSS(ops ...operand.Op) { ctx.VBROADCASTSS(ops...) }

// VBROADCASTSS_Z: Broadcast Single-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSS.Z m32 k ymm
//	VBROADCASTSS.Z xmm k ymm
//	VBROADCASTSS.Z m32 k zmm
//	VBROADCASTSS.Z xmm k zmm
//
// Construct and append a VBROADCASTSS.Z instruction to the active function.
func (c *Context) VBROADCASTSS_Z(mx, k, yz operand.Op) {
	c.addinstruction(x86.VBROADCASTSS_Z(mx, k, yz))
}

// VBROADCASTSS_Z: Broadcast Single-Precision Floating-Point Element (Zeroing Masking).
//
// Forms:
//
//	VBROADCASTSS.Z m32 k ymm
//	VBROADCASTSS.Z xmm k ymm
//	VBROADCASTSS.Z m32 k zmm
//	VBROADCASTSS.Z xmm k zmm
//
// Construct and append a VBROADCASTSS.Z instruction to the active function.
// Operates on the global context.
func VBROADCASTSS_Z(mx, k, yz operand.Op) { ctx.VBROADCASTSS_Z(mx, k, yz) }

// VCMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPD imm8 m128 xmm xmm
//	VCMPPD imm8 m256 ymm ymm
//	VCMPPD imm8 xmm  xmm xmm
//	VCMPPD imm8 ymm  ymm ymm
//	VCMPPD imm8 m128 xmm k k
//	VCMPPD imm8 m128 xmm k
//	VCMPPD imm8 m256 ymm k k
//	VCMPPD imm8 m256 ymm k
//	VCMPPD imm8 xmm  xmm k k
//	VCMPPD imm8 xmm  xmm k
//	VCMPPD imm8 ymm  ymm k k
//	VCMPPD imm8 ymm  ymm k
//	VCMPPD imm8 m512 zmm k k
//	VCMPPD imm8 m512 zmm k
//	VCMPPD imm8 zmm  zmm k k
//	VCMPPD imm8 zmm  zmm k
//
// Construct and append a VCMPPD instruction to the active function.
func (c *Context) VCMPPD(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPD(ops...))
}

// VCMPPD: Compare Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPD imm8 m128 xmm xmm
//	VCMPPD imm8 m256 ymm ymm
//	VCMPPD imm8 xmm  xmm xmm
//	VCMPPD imm8 ymm  ymm ymm
//	VCMPPD imm8 m128 xmm k k
//	VCMPPD imm8 m128 xmm k
//	VCMPPD imm8 m256 ymm k k
//	VCMPPD imm8 m256 ymm k
//	VCMPPD imm8 xmm  xmm k k
//	VCMPPD imm8 xmm  xmm k
//	VCMPPD imm8 ymm  ymm k k
//	VCMPPD imm8 ymm  ymm k
//	VCMPPD imm8 m512 zmm k k
//	VCMPPD imm8 m512 zmm k
//	VCMPPD imm8 zmm  zmm k k
//	VCMPPD imm8 zmm  zmm k
//
// Construct and append a VCMPPD instruction to the active function.
// Operates on the global context.
func VCMPPD(ops ...operand.Op) { ctx.VCMPPD(ops...) }

// VCMPPD_BCST: Compare Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPD.BCST imm8 m64 xmm k k
//	VCMPPD.BCST imm8 m64 xmm k
//	VCMPPD.BCST imm8 m64 ymm k k
//	VCMPPD.BCST imm8 m64 ymm k
//	VCMPPD.BCST imm8 m64 zmm k k
//	VCMPPD.BCST imm8 m64 zmm k
//
// Construct and append a VCMPPD.BCST instruction to the active function.
func (c *Context) VCMPPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPD_BCST(ops...))
}

// VCMPPD_BCST: Compare Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPD.BCST imm8 m64 xmm k k
//	VCMPPD.BCST imm8 m64 xmm k
//	VCMPPD.BCST imm8 m64 ymm k k
//	VCMPPD.BCST imm8 m64 ymm k
//	VCMPPD.BCST imm8 m64 zmm k k
//	VCMPPD.BCST imm8 m64 zmm k
//
// Construct and append a VCMPPD.BCST instruction to the active function.
// Operates on the global context.
func VCMPPD_BCST(ops ...operand.Op) { ctx.VCMPPD_BCST(ops...) }

// VCMPPD_SAE: Compare Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPD.SAE imm8 zmm zmm k k
//	VCMPPD.SAE imm8 zmm zmm k
//
// Construct and append a VCMPPD.SAE instruction to the active function.
func (c *Context) VCMPPD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPD_SAE(ops...))
}

// VCMPPD_SAE: Compare Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPD.SAE imm8 zmm zmm k k
//	VCMPPD.SAE imm8 zmm zmm k
//
// Construct and append a VCMPPD.SAE instruction to the active function.
// Operates on the global context.
func VCMPPD_SAE(ops ...operand.Op) { ctx.VCMPPD_SAE(ops...) }

// VCMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPS imm8 m128 xmm xmm
//	VCMPPS imm8 m256 ymm ymm
//	VCMPPS imm8 xmm  xmm xmm
//	VCMPPS imm8 ymm  ymm ymm
//	VCMPPS imm8 m128 xmm k k
//	VCMPPS imm8 m128 xmm k
//	VCMPPS imm8 m256 ymm k k
//	VCMPPS imm8 m256 ymm k
//	VCMPPS imm8 xmm  xmm k k
//	VCMPPS imm8 xmm  xmm k
//	VCMPPS imm8 ymm  ymm k k
//	VCMPPS imm8 ymm  ymm k
//	VCMPPS imm8 m512 zmm k k
//	VCMPPS imm8 m512 zmm k
//	VCMPPS imm8 zmm  zmm k k
//	VCMPPS imm8 zmm  zmm k
//
// Construct and append a VCMPPS instruction to the active function.
func (c *Context) VCMPPS(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPS(ops...))
}

// VCMPPS: Compare Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPPS imm8 m128 xmm xmm
//	VCMPPS imm8 m256 ymm ymm
//	VCMPPS imm8 xmm  xmm xmm
//	VCMPPS imm8 ymm  ymm ymm
//	VCMPPS imm8 m128 xmm k k
//	VCMPPS imm8 m128 xmm k
//	VCMPPS imm8 m256 ymm k k
//	VCMPPS imm8 m256 ymm k
//	VCMPPS imm8 xmm  xmm k k
//	VCMPPS imm8 xmm  xmm k
//	VCMPPS imm8 ymm  ymm k k
//	VCMPPS imm8 ymm  ymm k
//	VCMPPS imm8 m512 zmm k k
//	VCMPPS imm8 m512 zmm k
//	VCMPPS imm8 zmm  zmm k k
//	VCMPPS imm8 zmm  zmm k
//
// Construct and append a VCMPPS instruction to the active function.
// Operates on the global context.
func VCMPPS(ops ...operand.Op) { ctx.VCMPPS(ops...) }

// VCMPPS_BCST: Compare Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPS.BCST imm8 m32 xmm k k
//	VCMPPS.BCST imm8 m32 xmm k
//	VCMPPS.BCST imm8 m32 ymm k k
//	VCMPPS.BCST imm8 m32 ymm k
//	VCMPPS.BCST imm8 m32 zmm k k
//	VCMPPS.BCST imm8 m32 zmm k
//
// Construct and append a VCMPPS.BCST instruction to the active function.
func (c *Context) VCMPPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPS_BCST(ops...))
}

// VCMPPS_BCST: Compare Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCMPPS.BCST imm8 m32 xmm k k
//	VCMPPS.BCST imm8 m32 xmm k
//	VCMPPS.BCST imm8 m32 ymm k k
//	VCMPPS.BCST imm8 m32 ymm k
//	VCMPPS.BCST imm8 m32 zmm k k
//	VCMPPS.BCST imm8 m32 zmm k
//
// Construct and append a VCMPPS.BCST instruction to the active function.
// Operates on the global context.
func VCMPPS_BCST(ops ...operand.Op) { ctx.VCMPPS_BCST(ops...) }

// VCMPPS_SAE: Compare Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPS.SAE imm8 zmm zmm k k
//	VCMPPS.SAE imm8 zmm zmm k
//
// Construct and append a VCMPPS.SAE instruction to the active function.
func (c *Context) VCMPPS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCMPPS_SAE(ops...))
}

// VCMPPS_SAE: Compare Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPPS.SAE imm8 zmm zmm k k
//	VCMPPS.SAE imm8 zmm zmm k
//
// Construct and append a VCMPPS.SAE instruction to the active function.
// Operates on the global context.
func VCMPPS_SAE(ops ...operand.Op) { ctx.VCMPPS_SAE(ops...) }

// VCMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSD imm8 m64 xmm xmm
//	VCMPSD imm8 xmm xmm xmm
//	VCMPSD imm8 m64 xmm k k
//	VCMPSD imm8 m64 xmm k
//	VCMPSD imm8 xmm xmm k k
//	VCMPSD imm8 xmm xmm k
//
// Construct and append a VCMPSD instruction to the active function.
func (c *Context) VCMPSD(ops ...operand.Op) {
	c.addinstruction(x86.VCMPSD(ops...))
}

// VCMPSD: Compare Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSD imm8 m64 xmm xmm
//	VCMPSD imm8 xmm xmm xmm
//	VCMPSD imm8 m64 xmm k k
//	VCMPSD imm8 m64 xmm k
//	VCMPSD imm8 xmm xmm k k
//	VCMPSD imm8 xmm xmm k
//
// Construct and append a VCMPSD instruction to the active function.
// Operates on the global context.
func VCMPSD(ops ...operand.Op) { ctx.VCMPSD(ops...) }

// VCMPSD_SAE: Compare Scalar Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSD.SAE imm8 xmm xmm k k
//	VCMPSD.SAE imm8 xmm xmm k
//
// Construct and append a VCMPSD.SAE instruction to the active function.
func (c *Context) VCMPSD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCMPSD_SAE(ops...))
}

// VCMPSD_SAE: Compare Scalar Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSD.SAE imm8 xmm xmm k k
//	VCMPSD.SAE imm8 xmm xmm k
//
// Construct and append a VCMPSD.SAE instruction to the active function.
// Operates on the global context.
func VCMPSD_SAE(ops ...operand.Op) { ctx.VCMPSD_SAE(ops...) }

// VCMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSS imm8 m32 xmm xmm
//	VCMPSS imm8 xmm xmm xmm
//	VCMPSS imm8 m32 xmm k k
//	VCMPSS imm8 m32 xmm k
//	VCMPSS imm8 xmm xmm k k
//	VCMPSS imm8 xmm xmm k
//
// Construct and append a VCMPSS instruction to the active function.
func (c *Context) VCMPSS(ops ...operand.Op) {
	c.addinstruction(x86.VCMPSS(ops...))
}

// VCMPSS: Compare Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCMPSS imm8 m32 xmm xmm
//	VCMPSS imm8 xmm xmm xmm
//	VCMPSS imm8 m32 xmm k k
//	VCMPSS imm8 m32 xmm k
//	VCMPSS imm8 xmm xmm k k
//	VCMPSS imm8 xmm xmm k
//
// Construct and append a VCMPSS instruction to the active function.
// Operates on the global context.
func VCMPSS(ops ...operand.Op) { ctx.VCMPSS(ops...) }

// VCMPSS_SAE: Compare Scalar Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSS.SAE imm8 xmm xmm k k
//	VCMPSS.SAE imm8 xmm xmm k
//
// Construct and append a VCMPSS.SAE instruction to the active function.
func (c *Context) VCMPSS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCMPSS_SAE(ops...))
}

// VCMPSS_SAE: Compare Scalar Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VCMPSS.SAE imm8 xmm xmm k k
//	VCMPSS.SAE imm8 xmm xmm k
//
// Construct and append a VCMPSS.SAE instruction to the active function.
// Operates on the global context.
func VCMPSS_SAE(ops ...operand.Op) { ctx.VCMPSS_SAE(ops...) }

// VCOMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISD m64 xmm
//	VCOMISD xmm xmm
//
// Construct and append a VCOMISD instruction to the active function.
func (c *Context) VCOMISD(mx, x operand.Op) {
	c.addinstruction(x86.VCOMISD(mx, x))
}

// VCOMISD: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISD m64 xmm
//	VCOMISD xmm xmm
//
// Construct and append a VCOMISD instruction to the active function.
// Operates on the global context.
func VCOMISD(mx, x operand.Op) { ctx.VCOMISD(mx, x) }

// VCOMISD_SAE: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISD.SAE xmm xmm
//
// Construct and append a VCOMISD.SAE instruction to the active function.
func (c *Context) VCOMISD_SAE(x, x1 operand.Op) {
	c.addinstruction(x86.VCOMISD_SAE(x, x1))
}

// VCOMISD_SAE: Compare Scalar Ordered Double-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISD.SAE xmm xmm
//
// Construct and append a VCOMISD.SAE instruction to the active function.
// Operates on the global context.
func VCOMISD_SAE(x, x1 operand.Op) { ctx.VCOMISD_SAE(x, x1) }

// VCOMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISS m32 xmm
//	VCOMISS xmm xmm
//
// Construct and append a VCOMISS instruction to the active function.
func (c *Context) VCOMISS(mx, x operand.Op) {
	c.addinstruction(x86.VCOMISS(mx, x))
}

// VCOMISS: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS.
//
// Forms:
//
//	VCOMISS m32 xmm
//	VCOMISS xmm xmm
//
// Construct and append a VCOMISS instruction to the active function.
// Operates on the global context.
func VCOMISS(mx, x operand.Op) { ctx.VCOMISS(mx, x) }

// VCOMISS_SAE: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISS.SAE xmm xmm
//
// Construct and append a VCOMISS.SAE instruction to the active function.
func (c *Context) VCOMISS_SAE(x, x1 operand.Op) {
	c.addinstruction(x86.VCOMISS_SAE(x, x1))
}

// VCOMISS_SAE: Compare Scalar Ordered Single-Precision Floating-Point Values and Set EFLAGS (Suppress All Exceptions).
//
// Forms:
//
//	VCOMISS.SAE xmm xmm
//
// Construct and append a VCOMISS.SAE instruction to the active function.
// Operates on the global context.
func VCOMISS_SAE(x, x1 operand.Op) { ctx.VCOMISS_SAE(x, x1) }

// VCOMPRESSPD: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPD xmm k m128
//	VCOMPRESSPD xmm k xmm
//	VCOMPRESSPD xmm m128
//	VCOMPRESSPD xmm xmm
//	VCOMPRESSPD ymm k m256
//	VCOMPRESSPD ymm k ymm
//	VCOMPRESSPD ymm m256
//	VCOMPRESSPD ymm ymm
//	VCOMPRESSPD zmm k m512
//	VCOMPRESSPD zmm k zmm
//	VCOMPRESSPD zmm m512
//	VCOMPRESSPD zmm zmm
//
// Construct and append a VCOMPRESSPD instruction to the active function.
func (c *Context) VCOMPRESSPD(ops ...operand.Op) {
	c.addinstruction(x86.VCOMPRESSPD(ops...))
}

// VCOMPRESSPD: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPD xmm k m128
//	VCOMPRESSPD xmm k xmm
//	VCOMPRESSPD xmm m128
//	VCOMPRESSPD xmm xmm
//	VCOMPRESSPD ymm k m256
//	VCOMPRESSPD ymm k ymm
//	VCOMPRESSPD ymm m256
//	VCOMPRESSPD ymm ymm
//	VCOMPRESSPD zmm k m512
//	VCOMPRESSPD zmm k zmm
//	VCOMPRESSPD zmm m512
//	VCOMPRESSPD zmm zmm
//
// Construct and append a VCOMPRESSPD instruction to the active function.
// Operates on the global context.
func VCOMPRESSPD(ops ...operand.Op) { ctx.VCOMPRESSPD(ops...) }

// VCOMPRESSPD_Z: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPD.Z xmm k m128
//	VCOMPRESSPD.Z xmm k xmm
//	VCOMPRESSPD.Z ymm k m256
//	VCOMPRESSPD.Z ymm k ymm
//	VCOMPRESSPD.Z zmm k m512
//	VCOMPRESSPD.Z zmm k zmm
//
// Construct and append a VCOMPRESSPD.Z instruction to the active function.
func (c *Context) VCOMPRESSPD_Z(xyz, k, mxyz operand.Op) {
	c.addinstruction(x86.VCOMPRESSPD_Z(xyz, k, mxyz))
}

// VCOMPRESSPD_Z: Store Sparse Packed Double-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPD.Z xmm k m128
//	VCOMPRESSPD.Z xmm k xmm
//	VCOMPRESSPD.Z ymm k m256
//	VCOMPRESSPD.Z ymm k ymm
//	VCOMPRESSPD.Z zmm k m512
//	VCOMPRESSPD.Z zmm k zmm
//
// Construct and append a VCOMPRESSPD.Z instruction to the active function.
// Operates on the global context.
func VCOMPRESSPD_Z(xyz, k, mxyz operand.Op) { ctx.VCOMPRESSPD_Z(xyz, k, mxyz) }

// VCOMPRESSPS: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPS xmm k m128
//	VCOMPRESSPS xmm k xmm
//	VCOMPRESSPS xmm m128
//	VCOMPRESSPS xmm xmm
//	VCOMPRESSPS ymm k m256
//	VCOMPRESSPS ymm k ymm
//	VCOMPRESSPS ymm m256
//	VCOMPRESSPS ymm ymm
//	VCOMPRESSPS zmm k m512
//	VCOMPRESSPS zmm k zmm
//	VCOMPRESSPS zmm m512
//	VCOMPRESSPS zmm zmm
//
// Construct and append a VCOMPRESSPS instruction to the active function.
func (c *Context) VCOMPRESSPS(ops ...operand.Op) {
	c.addinstruction(x86.VCOMPRESSPS(ops...))
}

// VCOMPRESSPS: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register.
//
// Forms:
//
//	VCOMPRESSPS xmm k m128
//	VCOMPRESSPS xmm k xmm
//	VCOMPRESSPS xmm m128
//	VCOMPRESSPS xmm xmm
//	VCOMPRESSPS ymm k m256
//	VCOMPRESSPS ymm k ymm
//	VCOMPRESSPS ymm m256
//	VCOMPRESSPS ymm ymm
//	VCOMPRESSPS zmm k m512
//	VCOMPRESSPS zmm k zmm
//	VCOMPRESSPS zmm m512
//	VCOMPRESSPS zmm zmm
//
// Construct and append a VCOMPRESSPS instruction to the active function.
// Operates on the global context.
func VCOMPRESSPS(ops ...operand.Op) { ctx.VCOMPRESSPS(ops...) }

// VCOMPRESSPS_Z: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPS.Z xmm k m128
//	VCOMPRESSPS.Z xmm k xmm
//	VCOMPRESSPS.Z ymm k m256
//	VCOMPRESSPS.Z ymm k ymm
//	VCOMPRESSPS.Z zmm k m512
//	VCOMPRESSPS.Z zmm k zmm
//
// Construct and append a VCOMPRESSPS.Z instruction to the active function.
func (c *Context) VCOMPRESSPS_Z(xyz, k, mxyz operand.Op) {
	c.addinstruction(x86.VCOMPRESSPS_Z(xyz, k, mxyz))
}

// VCOMPRESSPS_Z: Store Sparse Packed Single-Precision Floating-Point Values into Dense Memory/Register (Zeroing Masking).
//
// Forms:
//
//	VCOMPRESSPS.Z xmm k m128
//	VCOMPRESSPS.Z xmm k xmm
//	VCOMPRESSPS.Z ymm k m256
//	VCOMPRESSPS.Z ymm k ymm
//	VCOMPRESSPS.Z zmm k m512
//	VCOMPRESSPS.Z zmm k zmm
//
// Construct and append a VCOMPRESSPS.Z instruction to the active function.
// Operates on the global context.
func VCOMPRESSPS_Z(xyz, k, mxyz operand.Op) { ctx.VCOMPRESSPS_Z(xyz, k, mxyz) }

// VCVTDQ2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PD m128 ymm
//	VCVTDQ2PD m64  xmm
//	VCVTDQ2PD xmm  xmm
//	VCVTDQ2PD xmm  ymm
//	VCVTDQ2PD m128 k ymm
//	VCVTDQ2PD m64  k xmm
//	VCVTDQ2PD xmm  k xmm
//	VCVTDQ2PD xmm  k ymm
//	VCVTDQ2PD m256 k zmm
//	VCVTDQ2PD m256 zmm
//	VCVTDQ2PD ymm  k zmm
//	VCVTDQ2PD ymm  zmm
//
// Construct and append a VCVTDQ2PD instruction to the active function.
func (c *Context) VCVTDQ2PD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PD(ops...))
}

// VCVTDQ2PD: Convert Packed Dword Integers to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PD m128 ymm
//	VCVTDQ2PD m64  xmm
//	VCVTDQ2PD xmm  xmm
//	VCVTDQ2PD xmm  ymm
//	VCVTDQ2PD m128 k ymm
//	VCVTDQ2PD m64  k xmm
//	VCVTDQ2PD xmm  k xmm
//	VCVTDQ2PD xmm  k ymm
//	VCVTDQ2PD m256 k zmm
//	VCVTDQ2PD m256 zmm
//	VCVTDQ2PD ymm  k zmm
//	VCVTDQ2PD ymm  zmm
//
// Construct and append a VCVTDQ2PD instruction to the active function.
// Operates on the global context.
func VCVTDQ2PD(ops ...operand.Op) { ctx.VCVTDQ2PD(ops...) }

// VCVTDQ2PD_BCST: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PD.BCST m32 k xmm
//	VCVTDQ2PD.BCST m32 k ymm
//	VCVTDQ2PD.BCST m32 xmm
//	VCVTDQ2PD.BCST m32 ymm
//	VCVTDQ2PD.BCST m32 k zmm
//	VCVTDQ2PD.BCST m32 zmm
//
// Construct and append a VCVTDQ2PD.BCST instruction to the active function.
func (c *Context) VCVTDQ2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PD_BCST(ops...))
}

// VCVTDQ2PD_BCST: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PD.BCST m32 k xmm
//	VCVTDQ2PD.BCST m32 k ymm
//	VCVTDQ2PD.BCST m32 xmm
//	VCVTDQ2PD.BCST m32 ymm
//	VCVTDQ2PD.BCST m32 k zmm
//	VCVTDQ2PD.BCST m32 zmm
//
// Construct and append a VCVTDQ2PD.BCST instruction to the active function.
// Operates on the global context.
func VCVTDQ2PD_BCST(ops ...operand.Op) { ctx.VCVTDQ2PD_BCST(ops...) }

// VCVTDQ2PD_BCST_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.BCST.Z m32 k xmm
//	VCVTDQ2PD.BCST.Z m32 k ymm
//	VCVTDQ2PD.BCST.Z m32 k zmm
//
// Construct and append a VCVTDQ2PD.BCST.Z instruction to the active function.
func (c *Context) VCVTDQ2PD_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTDQ2PD_BCST_Z(m, k, xyz))
}

// VCVTDQ2PD_BCST_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.BCST.Z m32 k xmm
//	VCVTDQ2PD.BCST.Z m32 k ymm
//	VCVTDQ2PD.BCST.Z m32 k zmm
//
// Construct and append a VCVTDQ2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PD_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTDQ2PD_BCST_Z(m, k, xyz) }

// VCVTDQ2PD_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.Z m128 k ymm
//	VCVTDQ2PD.Z m64  k xmm
//	VCVTDQ2PD.Z xmm  k xmm
//	VCVTDQ2PD.Z xmm  k ymm
//	VCVTDQ2PD.Z m256 k zmm
//	VCVTDQ2PD.Z ymm  k zmm
//
// Construct and append a VCVTDQ2PD.Z instruction to the active function.
func (c *Context) VCVTDQ2PD_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTDQ2PD_Z(mxy, k, xyz))
}

// VCVTDQ2PD_Z: Convert Packed Dword Integers to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PD.Z m128 k ymm
//	VCVTDQ2PD.Z m64  k xmm
//	VCVTDQ2PD.Z xmm  k xmm
//	VCVTDQ2PD.Z xmm  k ymm
//	VCVTDQ2PD.Z m256 k zmm
//	VCVTDQ2PD.Z ymm  k zmm
//
// Construct and append a VCVTDQ2PD.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PD_Z(mxy, k, xyz operand.Op) { ctx.VCVTDQ2PD_Z(mxy, k, xyz) }

// VCVTDQ2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PS m128 xmm
//	VCVTDQ2PS m256 ymm
//	VCVTDQ2PS xmm  xmm
//	VCVTDQ2PS ymm  ymm
//	VCVTDQ2PS m128 k xmm
//	VCVTDQ2PS m256 k ymm
//	VCVTDQ2PS xmm  k xmm
//	VCVTDQ2PS ymm  k ymm
//	VCVTDQ2PS m512 k zmm
//	VCVTDQ2PS m512 zmm
//	VCVTDQ2PS zmm  k zmm
//	VCVTDQ2PS zmm  zmm
//
// Construct and append a VCVTDQ2PS instruction to the active function.
func (c *Context) VCVTDQ2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS(ops...))
}

// VCVTDQ2PS: Convert Packed Dword Integers to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTDQ2PS m128 xmm
//	VCVTDQ2PS m256 ymm
//	VCVTDQ2PS xmm  xmm
//	VCVTDQ2PS ymm  ymm
//	VCVTDQ2PS m128 k xmm
//	VCVTDQ2PS m256 k ymm
//	VCVTDQ2PS xmm  k xmm
//	VCVTDQ2PS ymm  k ymm
//	VCVTDQ2PS m512 k zmm
//	VCVTDQ2PS m512 zmm
//	VCVTDQ2PS zmm  k zmm
//	VCVTDQ2PS zmm  zmm
//
// Construct and append a VCVTDQ2PS instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS(ops ...operand.Op) { ctx.VCVTDQ2PS(ops...) }

// VCVTDQ2PS_BCST: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PS.BCST m32 k xmm
//	VCVTDQ2PS.BCST m32 k ymm
//	VCVTDQ2PS.BCST m32 xmm
//	VCVTDQ2PS.BCST m32 ymm
//	VCVTDQ2PS.BCST m32 k zmm
//	VCVTDQ2PS.BCST m32 zmm
//
// Construct and append a VCVTDQ2PS.BCST instruction to the active function.
func (c *Context) VCVTDQ2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_BCST(ops...))
}

// VCVTDQ2PS_BCST: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTDQ2PS.BCST m32 k xmm
//	VCVTDQ2PS.BCST m32 k ymm
//	VCVTDQ2PS.BCST m32 xmm
//	VCVTDQ2PS.BCST m32 ymm
//	VCVTDQ2PS.BCST m32 k zmm
//	VCVTDQ2PS.BCST m32 zmm
//
// Construct and append a VCVTDQ2PS.BCST instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_BCST(ops ...operand.Op) { ctx.VCVTDQ2PS_BCST(ops...) }

// VCVTDQ2PS_BCST_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.BCST.Z m32 k xmm
//	VCVTDQ2PS.BCST.Z m32 k ymm
//	VCVTDQ2PS.BCST.Z m32 k zmm
//
// Construct and append a VCVTDQ2PS.BCST.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_BCST_Z(m, k, xyz))
}

// VCVTDQ2PS_BCST_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.BCST.Z m32 k xmm
//	VCVTDQ2PS.BCST.Z m32 k ymm
//	VCVTDQ2PS.BCST.Z m32 k zmm
//
// Construct and append a VCVTDQ2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTDQ2PS_BCST_Z(m, k, xyz) }

// VCVTDQ2PS_RD_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE zmm k zmm
//	VCVTDQ2PS.RD_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RD_SAE instruction to the active function.
func (c *Context) VCVTDQ2PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RD_SAE(ops...))
}

// VCVTDQ2PS_RD_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE zmm k zmm
//	VCVTDQ2PS.RD_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RD_SAE(ops ...operand.Op) { ctx.VCVTDQ2PS_RD_SAE(ops...) }

// VCVTDQ2PS_RD_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RD_SAE_Z(z, k, z1))
}

// VCVTDQ2PS_RD_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTDQ2PS_RD_SAE_Z(z, k, z1) }

// VCVTDQ2PS_RN_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE zmm k zmm
//	VCVTDQ2PS.RN_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RN_SAE instruction to the active function.
func (c *Context) VCVTDQ2PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RN_SAE(ops...))
}

// VCVTDQ2PS_RN_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE zmm k zmm
//	VCVTDQ2PS.RN_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RN_SAE(ops ...operand.Op) { ctx.VCVTDQ2PS_RN_SAE(ops...) }

// VCVTDQ2PS_RN_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RN_SAE_Z(z, k, z1))
}

// VCVTDQ2PS_RN_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTDQ2PS_RN_SAE_Z(z, k, z1) }

// VCVTDQ2PS_RU_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE zmm k zmm
//	VCVTDQ2PS.RU_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RU_SAE instruction to the active function.
func (c *Context) VCVTDQ2PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RU_SAE(ops...))
}

// VCVTDQ2PS_RU_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE zmm k zmm
//	VCVTDQ2PS.RU_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RU_SAE(ops ...operand.Op) { ctx.VCVTDQ2PS_RU_SAE(ops...) }

// VCVTDQ2PS_RU_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RU_SAE_Z(z, k, z1))
}

// VCVTDQ2PS_RU_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTDQ2PS_RU_SAE_Z(z, k, z1) }

// VCVTDQ2PS_RZ_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE zmm k zmm
//	VCVTDQ2PS.RZ_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RZ_SAE instruction to the active function.
func (c *Context) VCVTDQ2PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RZ_SAE(ops...))
}

// VCVTDQ2PS_RZ_SAE: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE zmm k zmm
//	VCVTDQ2PS.RZ_SAE zmm zmm
//
// Construct and append a VCVTDQ2PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RZ_SAE(ops ...operand.Op) { ctx.VCVTDQ2PS_RZ_SAE(ops...) }

// VCVTDQ2PS_RZ_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_RZ_SAE_Z(z, k, z1))
}

// VCVTDQ2PS_RZ_SAE_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTDQ2PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTDQ2PS_RZ_SAE_Z(z, k, z1) }

// VCVTDQ2PS_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.Z m128 k xmm
//	VCVTDQ2PS.Z m256 k ymm
//	VCVTDQ2PS.Z xmm  k xmm
//	VCVTDQ2PS.Z ymm  k ymm
//	VCVTDQ2PS.Z m512 k zmm
//	VCVTDQ2PS.Z zmm  k zmm
//
// Construct and append a VCVTDQ2PS.Z instruction to the active function.
func (c *Context) VCVTDQ2PS_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTDQ2PS_Z(mxyz, k, xyz))
}

// VCVTDQ2PS_Z: Convert Packed Dword Integers to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTDQ2PS.Z m128 k xmm
//	VCVTDQ2PS.Z m256 k ymm
//	VCVTDQ2PS.Z xmm  k xmm
//	VCVTDQ2PS.Z ymm  k ymm
//	VCVTDQ2PS.Z m512 k zmm
//	VCVTDQ2PS.Z zmm  k zmm
//
// Construct and append a VCVTDQ2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTDQ2PS_Z(mxyz, k, xyz operand.Op) { ctx.VCVTDQ2PS_Z(mxyz, k, xyz) }

// VCVTPD2DQ: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQ m512 k ymm
//	VCVTPD2DQ m512 ymm
//	VCVTPD2DQ zmm  k ymm
//	VCVTPD2DQ zmm  ymm
//
// Construct and append a VCVTPD2DQ instruction to the active function.
func (c *Context) VCVTPD2DQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ(ops...))
}

// VCVTPD2DQ: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQ m512 k ymm
//	VCVTPD2DQ m512 ymm
//	VCVTPD2DQ zmm  k ymm
//	VCVTPD2DQ zmm  ymm
//
// Construct and append a VCVTPD2DQ instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ(ops ...operand.Op) { ctx.VCVTPD2DQ(ops...) }

// VCVTPD2DQX: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQX m128 xmm
//	VCVTPD2DQX xmm  xmm
//	VCVTPD2DQX m128 k xmm
//	VCVTPD2DQX xmm  k xmm
//
// Construct and append a VCVTPD2DQX instruction to the active function.
func (c *Context) VCVTPD2DQX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQX(ops...))
}

// VCVTPD2DQX: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQX m128 xmm
//	VCVTPD2DQX xmm  xmm
//	VCVTPD2DQX m128 k xmm
//	VCVTPD2DQX xmm  k xmm
//
// Construct and append a VCVTPD2DQX instruction to the active function.
// Operates on the global context.
func VCVTPD2DQX(ops ...operand.Op) { ctx.VCVTPD2DQX(ops...) }

// VCVTPD2DQX_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQX.BCST m64 k xmm
//	VCVTPD2DQX.BCST m64 xmm
//
// Construct and append a VCVTPD2DQX.BCST instruction to the active function.
func (c *Context) VCVTPD2DQX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQX_BCST(ops...))
}

// VCVTPD2DQX_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQX.BCST m64 k xmm
//	VCVTPD2DQX.BCST m64 xmm
//
// Construct and append a VCVTPD2DQX.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2DQX_BCST(ops ...operand.Op) { ctx.VCVTPD2DQX_BCST(ops...) }

// VCVTPD2DQX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2DQX.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2DQX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2DQX_BCST_Z(m, k, x))
}

// VCVTPD2DQX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2DQX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQX_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2DQX_BCST_Z(m, k, x) }

// VCVTPD2DQX_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.Z m128 k xmm
//	VCVTPD2DQX.Z xmm  k xmm
//
// Construct and append a VCVTPD2DQX.Z instruction to the active function.
func (c *Context) VCVTPD2DQX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2DQX_Z(mx, k, x))
}

// VCVTPD2DQX_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQX.Z m128 k xmm
//	VCVTPD2DQX.Z xmm  k xmm
//
// Construct and append a VCVTPD2DQX.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQX_Z(mx, k, x operand.Op) { ctx.VCVTPD2DQX_Z(mx, k, x) }

// VCVTPD2DQY: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQY m256 xmm
//	VCVTPD2DQY ymm  xmm
//	VCVTPD2DQY m256 k xmm
//	VCVTPD2DQY ymm  k xmm
//
// Construct and append a VCVTPD2DQY instruction to the active function.
func (c *Context) VCVTPD2DQY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQY(ops...))
}

// VCVTPD2DQY: Convert Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPD2DQY m256 xmm
//	VCVTPD2DQY ymm  xmm
//	VCVTPD2DQY m256 k xmm
//	VCVTPD2DQY ymm  k xmm
//
// Construct and append a VCVTPD2DQY instruction to the active function.
// Operates on the global context.
func VCVTPD2DQY(ops ...operand.Op) { ctx.VCVTPD2DQY(ops...) }

// VCVTPD2DQY_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQY.BCST m64 k xmm
//	VCVTPD2DQY.BCST m64 xmm
//
// Construct and append a VCVTPD2DQY.BCST instruction to the active function.
func (c *Context) VCVTPD2DQY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQY_BCST(ops...))
}

// VCVTPD2DQY_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQY.BCST m64 k xmm
//	VCVTPD2DQY.BCST m64 xmm
//
// Construct and append a VCVTPD2DQY.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2DQY_BCST(ops ...operand.Op) { ctx.VCVTPD2DQY_BCST(ops...) }

// VCVTPD2DQY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2DQY.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2DQY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2DQY_BCST_Z(m, k, x))
}

// VCVTPD2DQY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2DQY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQY_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2DQY_BCST_Z(m, k, x) }

// VCVTPD2DQY_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.Z m256 k xmm
//	VCVTPD2DQY.Z ymm  k xmm
//
// Construct and append a VCVTPD2DQY.Z instruction to the active function.
func (c *Context) VCVTPD2DQY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2DQY_Z(my, k, x))
}

// VCVTPD2DQY_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQY.Z m256 k xmm
//	VCVTPD2DQY.Z ymm  k xmm
//
// Construct and append a VCVTPD2DQY.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQY_Z(my, k, x operand.Op) { ctx.VCVTPD2DQY_Z(my, k, x) }

// VCVTPD2DQ_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQ.BCST m64 k ymm
//	VCVTPD2DQ.BCST m64 ymm
//
// Construct and append a VCVTPD2DQ.BCST instruction to the active function.
func (c *Context) VCVTPD2DQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_BCST(ops...))
}

// VCVTPD2DQ_BCST: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2DQ.BCST m64 k ymm
//	VCVTPD2DQ.BCST m64 ymm
//
// Construct and append a VCVTPD2DQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_BCST(ops ...operand.Op) { ctx.VCVTPD2DQ_BCST(ops...) }

// VCVTPD2DQ_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2DQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_BCST_Z(m, k, y))
}

// VCVTPD2DQ_BCST_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2DQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_BCST_Z(m, k, y operand.Op) { ctx.VCVTPD2DQ_BCST_Z(m, k, y) }

// VCVTPD2DQ_RD_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE zmm k ymm
//	VCVTPD2DQ.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPD2DQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RD_SAE(ops...))
}

// VCVTPD2DQ_RD_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE zmm k ymm
//	VCVTPD2DQ.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPD2DQ_RD_SAE(ops...) }

// VCVTPD2DQ_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_RD_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RD_SAE_Z(z, k, y))
}

// VCVTPD2DQ_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RD_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2DQ_RD_SAE_Z(z, k, y) }

// VCVTPD2DQ_RN_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE zmm k ymm
//	VCVTPD2DQ.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPD2DQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RN_SAE(ops...))
}

// VCVTPD2DQ_RN_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE zmm k ymm
//	VCVTPD2DQ.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPD2DQ_RN_SAE(ops...) }

// VCVTPD2DQ_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_RN_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RN_SAE_Z(z, k, y))
}

// VCVTPD2DQ_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RN_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2DQ_RN_SAE_Z(z, k, y) }

// VCVTPD2DQ_RU_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE zmm k ymm
//	VCVTPD2DQ.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPD2DQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RU_SAE(ops...))
}

// VCVTPD2DQ_RU_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE zmm k ymm
//	VCVTPD2DQ.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPD2DQ_RU_SAE(ops...) }

// VCVTPD2DQ_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_RU_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RU_SAE_Z(z, k, y))
}

// VCVTPD2DQ_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RU_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2DQ_RU_SAE_Z(z, k, y) }

// VCVTPD2DQ_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE zmm k ymm
//	VCVTPD2DQ.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPD2DQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RZ_SAE(ops...))
}

// VCVTPD2DQ_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE zmm k ymm
//	VCVTPD2DQ.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2DQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPD2DQ_RZ_SAE(ops...) }

// VCVTPD2DQ_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_RZ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_RZ_SAE_Z(z, k, y))
}

// VCVTPD2DQ_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2DQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_RZ_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2DQ_RZ_SAE_Z(z, k, y) }

// VCVTPD2DQ_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.Z m512 k ymm
//	VCVTPD2DQ.Z zmm  k ymm
//
// Construct and append a VCVTPD2DQ.Z instruction to the active function.
func (c *Context) VCVTPD2DQ_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2DQ_Z(mz, k, y))
}

// VCVTPD2DQ_Z: Convert Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2DQ.Z m512 k ymm
//	VCVTPD2DQ.Z zmm  k ymm
//
// Construct and append a VCVTPD2DQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2DQ_Z(mz, k, y operand.Op) { ctx.VCVTPD2DQ_Z(mz, k, y) }

// VCVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PS m512 k ymm
//	VCVTPD2PS m512 ymm
//	VCVTPD2PS zmm  k ymm
//	VCVTPD2PS zmm  ymm
//
// Construct and append a VCVTPD2PS instruction to the active function.
func (c *Context) VCVTPD2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS(ops...))
}

// VCVTPD2PS: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PS m512 k ymm
//	VCVTPD2PS m512 ymm
//	VCVTPD2PS zmm  k ymm
//	VCVTPD2PS zmm  ymm
//
// Construct and append a VCVTPD2PS instruction to the active function.
// Operates on the global context.
func VCVTPD2PS(ops ...operand.Op) { ctx.VCVTPD2PS(ops...) }

// VCVTPD2PSX: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSX m128 xmm
//	VCVTPD2PSX xmm  xmm
//	VCVTPD2PSX m128 k xmm
//	VCVTPD2PSX xmm  k xmm
//
// Construct and append a VCVTPD2PSX instruction to the active function.
func (c *Context) VCVTPD2PSX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PSX(ops...))
}

// VCVTPD2PSX: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSX m128 xmm
//	VCVTPD2PSX xmm  xmm
//	VCVTPD2PSX m128 k xmm
//	VCVTPD2PSX xmm  k xmm
//
// Construct and append a VCVTPD2PSX instruction to the active function.
// Operates on the global context.
func VCVTPD2PSX(ops ...operand.Op) { ctx.VCVTPD2PSX(ops...) }

// VCVTPD2PSX_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSX.BCST m64 k xmm
//	VCVTPD2PSX.BCST m64 xmm
//
// Construct and append a VCVTPD2PSX.BCST instruction to the active function.
func (c *Context) VCVTPD2PSX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PSX_BCST(ops...))
}

// VCVTPD2PSX_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSX.BCST m64 k xmm
//	VCVTPD2PSX.BCST m64 xmm
//
// Construct and append a VCVTPD2PSX.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2PSX_BCST(ops ...operand.Op) { ctx.VCVTPD2PSX_BCST(ops...) }

// VCVTPD2PSX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2PSX.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2PSX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2PSX_BCST_Z(m, k, x))
}

// VCVTPD2PSX_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2PSX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PSX_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2PSX_BCST_Z(m, k, x) }

// VCVTPD2PSX_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.Z m128 k xmm
//	VCVTPD2PSX.Z xmm  k xmm
//
// Construct and append a VCVTPD2PSX.Z instruction to the active function.
func (c *Context) VCVTPD2PSX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2PSX_Z(mx, k, x))
}

// VCVTPD2PSX_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSX.Z m128 k xmm
//	VCVTPD2PSX.Z xmm  k xmm
//
// Construct and append a VCVTPD2PSX.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PSX_Z(mx, k, x operand.Op) { ctx.VCVTPD2PSX_Z(mx, k, x) }

// VCVTPD2PSY: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSY m256 xmm
//	VCVTPD2PSY ymm  xmm
//	VCVTPD2PSY m256 k xmm
//	VCVTPD2PSY ymm  k xmm
//
// Construct and append a VCVTPD2PSY instruction to the active function.
func (c *Context) VCVTPD2PSY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PSY(ops...))
}

// VCVTPD2PSY: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values.
//
// Forms:
//
//	VCVTPD2PSY m256 xmm
//	VCVTPD2PSY ymm  xmm
//	VCVTPD2PSY m256 k xmm
//	VCVTPD2PSY ymm  k xmm
//
// Construct and append a VCVTPD2PSY instruction to the active function.
// Operates on the global context.
func VCVTPD2PSY(ops ...operand.Op) { ctx.VCVTPD2PSY(ops...) }

// VCVTPD2PSY_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSY.BCST m64 k xmm
//	VCVTPD2PSY.BCST m64 xmm
//
// Construct and append a VCVTPD2PSY.BCST instruction to the active function.
func (c *Context) VCVTPD2PSY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PSY_BCST(ops...))
}

// VCVTPD2PSY_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PSY.BCST m64 k xmm
//	VCVTPD2PSY.BCST m64 xmm
//
// Construct and append a VCVTPD2PSY.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2PSY_BCST(ops ...operand.Op) { ctx.VCVTPD2PSY_BCST(ops...) }

// VCVTPD2PSY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2PSY.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2PSY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2PSY_BCST_Z(m, k, x))
}

// VCVTPD2PSY_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2PSY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PSY_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2PSY_BCST_Z(m, k, x) }

// VCVTPD2PSY_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.Z m256 k xmm
//	VCVTPD2PSY.Z ymm  k xmm
//
// Construct and append a VCVTPD2PSY.Z instruction to the active function.
func (c *Context) VCVTPD2PSY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2PSY_Z(my, k, x))
}

// VCVTPD2PSY_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PSY.Z m256 k xmm
//	VCVTPD2PSY.Z ymm  k xmm
//
// Construct and append a VCVTPD2PSY.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PSY_Z(my, k, x operand.Op) { ctx.VCVTPD2PSY_Z(my, k, x) }

// VCVTPD2PS_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PS.BCST m64 k ymm
//	VCVTPD2PS.BCST m64 ymm
//
// Construct and append a VCVTPD2PS.BCST instruction to the active function.
func (c *Context) VCVTPD2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_BCST(ops...))
}

// VCVTPD2PS_BCST: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPD2PS.BCST m64 k ymm
//	VCVTPD2PS.BCST m64 ymm
//
// Construct and append a VCVTPD2PS.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_BCST(ops ...operand.Op) { ctx.VCVTPD2PS_BCST(ops...) }

// VCVTPD2PS_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2PS.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2PS_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_BCST_Z(m, k, y))
}

// VCVTPD2PS_BCST_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_BCST_Z(m, k, y operand.Op) { ctx.VCVTPD2PS_BCST_Z(m, k, y) }

// VCVTPD2PS_RD_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE zmm k ymm
//	VCVTPD2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RD_SAE instruction to the active function.
func (c *Context) VCVTPD2PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RD_SAE(ops...))
}

// VCVTPD2PS_RD_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE zmm k ymm
//	VCVTPD2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RD_SAE(ops ...operand.Op) { ctx.VCVTPD2PS_RD_SAE(ops...) }

// VCVTPD2PS_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2PS_RD_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RD_SAE_Z(z, k, y))
}

// VCVTPD2PS_RD_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RD_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2PS_RD_SAE_Z(z, k, y) }

// VCVTPD2PS_RN_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE zmm k ymm
//	VCVTPD2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RN_SAE instruction to the active function.
func (c *Context) VCVTPD2PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RN_SAE(ops...))
}

// VCVTPD2PS_RN_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE zmm k ymm
//	VCVTPD2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RN_SAE(ops ...operand.Op) { ctx.VCVTPD2PS_RN_SAE(ops...) }

// VCVTPD2PS_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2PS_RN_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RN_SAE_Z(z, k, y))
}

// VCVTPD2PS_RN_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RN_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2PS_RN_SAE_Z(z, k, y) }

// VCVTPD2PS_RU_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE zmm k ymm
//	VCVTPD2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RU_SAE instruction to the active function.
func (c *Context) VCVTPD2PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RU_SAE(ops...))
}

// VCVTPD2PS_RU_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE zmm k ymm
//	VCVTPD2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RU_SAE(ops ...operand.Op) { ctx.VCVTPD2PS_RU_SAE(ops...) }

// VCVTPD2PS_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2PS_RU_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RU_SAE_Z(z, k, y))
}

// VCVTPD2PS_RU_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RU_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2PS_RU_SAE_Z(z, k, y) }

// VCVTPD2PS_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE zmm k ymm
//	VCVTPD2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RZ_SAE instruction to the active function.
func (c *Context) VCVTPD2PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RZ_SAE(ops...))
}

// VCVTPD2PS_RZ_SAE: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE zmm k ymm
//	VCVTPD2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RZ_SAE(ops ...operand.Op) { ctx.VCVTPD2PS_RZ_SAE(ops...) }

// VCVTPD2PS_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2PS_RZ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_RZ_SAE_Z(z, k, y))
}

// VCVTPD2PS_RZ_SAE_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_RZ_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2PS_RZ_SAE_Z(z, k, y) }

// VCVTPD2PS_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.Z m512 k ymm
//	VCVTPD2PS.Z zmm  k ymm
//
// Construct and append a VCVTPD2PS.Z instruction to the active function.
func (c *Context) VCVTPD2PS_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2PS_Z(mz, k, y))
}

// VCVTPD2PS_Z: Convert Packed Double-Precision FP Values to Packed Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2PS.Z m512 k ymm
//	VCVTPD2PS.Z zmm  k ymm
//
// Construct and append a VCVTPD2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2PS_Z(mz, k, y operand.Op) { ctx.VCVTPD2PS_Z(mz, k, y) }

// VCVTPD2QQ: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTPD2QQ m128 k xmm
//	VCVTPD2QQ m128 xmm
//	VCVTPD2QQ m256 k ymm
//	VCVTPD2QQ m256 ymm
//	VCVTPD2QQ xmm  k xmm
//	VCVTPD2QQ xmm  xmm
//	VCVTPD2QQ ymm  k ymm
//	VCVTPD2QQ ymm  ymm
//	VCVTPD2QQ m512 k zmm
//	VCVTPD2QQ m512 zmm
//	VCVTPD2QQ zmm  k zmm
//	VCVTPD2QQ zmm  zmm
//
// Construct and append a VCVTPD2QQ instruction to the active function.
func (c *Context) VCVTPD2QQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ(ops...))
}

// VCVTPD2QQ: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTPD2QQ m128 k xmm
//	VCVTPD2QQ m128 xmm
//	VCVTPD2QQ m256 k ymm
//	VCVTPD2QQ m256 ymm
//	VCVTPD2QQ xmm  k xmm
//	VCVTPD2QQ xmm  xmm
//	VCVTPD2QQ ymm  k ymm
//	VCVTPD2QQ ymm  ymm
//	VCVTPD2QQ m512 k zmm
//	VCVTPD2QQ m512 zmm
//	VCVTPD2QQ zmm  k zmm
//	VCVTPD2QQ zmm  zmm
//
// Construct and append a VCVTPD2QQ instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ(ops ...operand.Op) { ctx.VCVTPD2QQ(ops...) }

// VCVTPD2QQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2QQ.BCST m64 k xmm
//	VCVTPD2QQ.BCST m64 k ymm
//	VCVTPD2QQ.BCST m64 xmm
//	VCVTPD2QQ.BCST m64 ymm
//	VCVTPD2QQ.BCST m64 k zmm
//	VCVTPD2QQ.BCST m64 zmm
//
// Construct and append a VCVTPD2QQ.BCST instruction to the active function.
func (c *Context) VCVTPD2QQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_BCST(ops...))
}

// VCVTPD2QQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2QQ.BCST m64 k xmm
//	VCVTPD2QQ.BCST m64 k ymm
//	VCVTPD2QQ.BCST m64 xmm
//	VCVTPD2QQ.BCST m64 ymm
//	VCVTPD2QQ.BCST m64 k zmm
//	VCVTPD2QQ.BCST m64 zmm
//
// Construct and append a VCVTPD2QQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_BCST(ops ...operand.Op) { ctx.VCVTPD2QQ_BCST(ops...) }

// VCVTPD2QQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.BCST.Z m64 k xmm
//	VCVTPD2QQ.BCST.Z m64 k ymm
//	VCVTPD2QQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTPD2QQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_BCST_Z(m, k, xyz))
}

// VCVTPD2QQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.BCST.Z m64 k xmm
//	VCVTPD2QQ.BCST.Z m64 k ymm
//	VCVTPD2QQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTPD2QQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPD2QQ_BCST_Z(m, k, xyz) }

// VCVTPD2QQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE zmm k zmm
//	VCVTPD2QQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPD2QQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RD_SAE(ops...))
}

// VCVTPD2QQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE zmm k zmm
//	VCVTPD2QQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPD2QQ_RD_SAE(ops...) }

// VCVTPD2QQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RD_SAE_Z(z, k, z1))
}

// VCVTPD2QQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2QQ_RD_SAE_Z(z, k, z1) }

// VCVTPD2QQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE zmm k zmm
//	VCVTPD2QQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPD2QQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RN_SAE(ops...))
}

// VCVTPD2QQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE zmm k zmm
//	VCVTPD2QQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPD2QQ_RN_SAE(ops...) }

// VCVTPD2QQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RN_SAE_Z(z, k, z1))
}

// VCVTPD2QQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2QQ_RN_SAE_Z(z, k, z1) }

// VCVTPD2QQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE zmm k zmm
//	VCVTPD2QQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPD2QQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RU_SAE(ops...))
}

// VCVTPD2QQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE zmm k zmm
//	VCVTPD2QQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPD2QQ_RU_SAE(ops...) }

// VCVTPD2QQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RU_SAE_Z(z, k, z1))
}

// VCVTPD2QQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2QQ_RU_SAE_Z(z, k, z1) }

// VCVTPD2QQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE zmm k zmm
//	VCVTPD2QQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPD2QQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RZ_SAE(ops...))
}

// VCVTPD2QQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE zmm k zmm
//	VCVTPD2QQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPD2QQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPD2QQ_RZ_SAE(ops...) }

// VCVTPD2QQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_RZ_SAE_Z(z, k, z1))
}

// VCVTPD2QQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2QQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2QQ_RZ_SAE_Z(z, k, z1) }

// VCVTPD2QQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.Z m128 k xmm
//	VCVTPD2QQ.Z m256 k ymm
//	VCVTPD2QQ.Z xmm  k xmm
//	VCVTPD2QQ.Z ymm  k ymm
//	VCVTPD2QQ.Z m512 k zmm
//	VCVTPD2QQ.Z zmm  k zmm
//
// Construct and append a VCVTPD2QQ.Z instruction to the active function.
func (c *Context) VCVTPD2QQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPD2QQ_Z(mxyz, k, xyz))
}

// VCVTPD2QQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2QQ.Z m128 k xmm
//	VCVTPD2QQ.Z m256 k ymm
//	VCVTPD2QQ.Z xmm  k xmm
//	VCVTPD2QQ.Z ymm  k ymm
//	VCVTPD2QQ.Z m512 k zmm
//	VCVTPD2QQ.Z zmm  k zmm
//
// Construct and append a VCVTPD2QQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2QQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTPD2QQ_Z(mxyz, k, xyz) }

// VCVTPD2UDQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQ m512 k ymm
//	VCVTPD2UDQ m512 ymm
//	VCVTPD2UDQ zmm  k ymm
//	VCVTPD2UDQ zmm  ymm
//
// Construct and append a VCVTPD2UDQ instruction to the active function.
func (c *Context) VCVTPD2UDQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ(ops...))
}

// VCVTPD2UDQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQ m512 k ymm
//	VCVTPD2UDQ m512 ymm
//	VCVTPD2UDQ zmm  k ymm
//	VCVTPD2UDQ zmm  ymm
//
// Construct and append a VCVTPD2UDQ instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ(ops ...operand.Op) { ctx.VCVTPD2UDQ(ops...) }

// VCVTPD2UDQX: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQX m128 k xmm
//	VCVTPD2UDQX m128 xmm
//	VCVTPD2UDQX xmm  k xmm
//	VCVTPD2UDQX xmm  xmm
//
// Construct and append a VCVTPD2UDQX instruction to the active function.
func (c *Context) VCVTPD2UDQX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQX(ops...))
}

// VCVTPD2UDQX: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQX m128 k xmm
//	VCVTPD2UDQX m128 xmm
//	VCVTPD2UDQX xmm  k xmm
//	VCVTPD2UDQX xmm  xmm
//
// Construct and append a VCVTPD2UDQX instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQX(ops ...operand.Op) { ctx.VCVTPD2UDQX(ops...) }

// VCVTPD2UDQX_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQX.BCST m64 k xmm
//	VCVTPD2UDQX.BCST m64 xmm
//
// Construct and append a VCVTPD2UDQX.BCST instruction to the active function.
func (c *Context) VCVTPD2UDQX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQX_BCST(ops...))
}

// VCVTPD2UDQX_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQX.BCST m64 k xmm
//	VCVTPD2UDQX.BCST m64 xmm
//
// Construct and append a VCVTPD2UDQX.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQX_BCST(ops ...operand.Op) { ctx.VCVTPD2UDQX_BCST(ops...) }

// VCVTPD2UDQX_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2UDQX.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2UDQX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQX_BCST_Z(m, k, x))
}

// VCVTPD2UDQX_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2UDQX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQX_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2UDQX_BCST_Z(m, k, x) }

// VCVTPD2UDQX_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.Z m128 k xmm
//	VCVTPD2UDQX.Z xmm  k xmm
//
// Construct and append a VCVTPD2UDQX.Z instruction to the active function.
func (c *Context) VCVTPD2UDQX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQX_Z(mx, k, x))
}

// VCVTPD2UDQX_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQX.Z m128 k xmm
//	VCVTPD2UDQX.Z xmm  k xmm
//
// Construct and append a VCVTPD2UDQX.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQX_Z(mx, k, x operand.Op) { ctx.VCVTPD2UDQX_Z(mx, k, x) }

// VCVTPD2UDQY: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQY m256 k xmm
//	VCVTPD2UDQY m256 xmm
//	VCVTPD2UDQY ymm  k xmm
//	VCVTPD2UDQY ymm  xmm
//
// Construct and append a VCVTPD2UDQY instruction to the active function.
func (c *Context) VCVTPD2UDQY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQY(ops...))
}

// VCVTPD2UDQY: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTPD2UDQY m256 k xmm
//	VCVTPD2UDQY m256 xmm
//	VCVTPD2UDQY ymm  k xmm
//	VCVTPD2UDQY ymm  xmm
//
// Construct and append a VCVTPD2UDQY instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQY(ops ...operand.Op) { ctx.VCVTPD2UDQY(ops...) }

// VCVTPD2UDQY_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQY.BCST m64 k xmm
//	VCVTPD2UDQY.BCST m64 xmm
//
// Construct and append a VCVTPD2UDQY.BCST instruction to the active function.
func (c *Context) VCVTPD2UDQY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQY_BCST(ops...))
}

// VCVTPD2UDQY_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQY.BCST m64 k xmm
//	VCVTPD2UDQY.BCST m64 xmm
//
// Construct and append a VCVTPD2UDQY.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQY_BCST(ops ...operand.Op) { ctx.VCVTPD2UDQY_BCST(ops...) }

// VCVTPD2UDQY_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2UDQY.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2UDQY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQY_BCST_Z(m, k, x))
}

// VCVTPD2UDQY_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTPD2UDQY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQY_BCST_Z(m, k, x operand.Op) { ctx.VCVTPD2UDQY_BCST_Z(m, k, x) }

// VCVTPD2UDQY_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.Z m256 k xmm
//	VCVTPD2UDQY.Z ymm  k xmm
//
// Construct and append a VCVTPD2UDQY.Z instruction to the active function.
func (c *Context) VCVTPD2UDQY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQY_Z(my, k, x))
}

// VCVTPD2UDQY_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQY.Z m256 k xmm
//	VCVTPD2UDQY.Z ymm  k xmm
//
// Construct and append a VCVTPD2UDQY.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQY_Z(my, k, x operand.Op) { ctx.VCVTPD2UDQY_Z(my, k, x) }

// VCVTPD2UDQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQ.BCST m64 k ymm
//	VCVTPD2UDQ.BCST m64 ymm
//
// Construct and append a VCVTPD2UDQ.BCST instruction to the active function.
func (c *Context) VCVTPD2UDQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_BCST(ops...))
}

// VCVTPD2UDQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UDQ.BCST m64 k ymm
//	VCVTPD2UDQ.BCST m64 ymm
//
// Construct and append a VCVTPD2UDQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_BCST(ops ...operand.Op) { ctx.VCVTPD2UDQ_BCST(ops...) }

// VCVTPD2UDQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2UDQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_BCST_Z(m, k, y))
}

// VCVTPD2UDQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTPD2UDQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_BCST_Z(m, k, y operand.Op) { ctx.VCVTPD2UDQ_BCST_Z(m, k, y) }

// VCVTPD2UDQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE zmm k ymm
//	VCVTPD2UDQ.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPD2UDQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RD_SAE(ops...))
}

// VCVTPD2UDQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE zmm k ymm
//	VCVTPD2UDQ.RD_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPD2UDQ_RD_SAE(ops...) }

// VCVTPD2UDQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_RD_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RD_SAE_Z(z, k, y))
}

// VCVTPD2UDQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RD_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2UDQ_RD_SAE_Z(z, k, y) }

// VCVTPD2UDQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE zmm k ymm
//	VCVTPD2UDQ.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPD2UDQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RN_SAE(ops...))
}

// VCVTPD2UDQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE zmm k ymm
//	VCVTPD2UDQ.RN_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPD2UDQ_RN_SAE(ops...) }

// VCVTPD2UDQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_RN_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RN_SAE_Z(z, k, y))
}

// VCVTPD2UDQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RN_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2UDQ_RN_SAE_Z(z, k, y) }

// VCVTPD2UDQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE zmm k ymm
//	VCVTPD2UDQ.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPD2UDQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RU_SAE(ops...))
}

// VCVTPD2UDQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE zmm k ymm
//	VCVTPD2UDQ.RU_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPD2UDQ_RU_SAE(ops...) }

// VCVTPD2UDQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_RU_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RU_SAE_Z(z, k, y))
}

// VCVTPD2UDQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RU_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2UDQ_RU_SAE_Z(z, k, y) }

// VCVTPD2UDQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE zmm k ymm
//	VCVTPD2UDQ.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPD2UDQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RZ_SAE(ops...))
}

// VCVTPD2UDQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE zmm k ymm
//	VCVTPD2UDQ.RZ_SAE zmm ymm
//
// Construct and append a VCVTPD2UDQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPD2UDQ_RZ_SAE(ops...) }

// VCVTPD2UDQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_RZ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_RZ_SAE_Z(z, k, y))
}

// VCVTPD2UDQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTPD2UDQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_RZ_SAE_Z(z, k, y operand.Op) { ctx.VCVTPD2UDQ_RZ_SAE_Z(z, k, y) }

// VCVTPD2UDQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.Z m512 k ymm
//	VCVTPD2UDQ.Z zmm  k ymm
//
// Construct and append a VCVTPD2UDQ.Z instruction to the active function.
func (c *Context) VCVTPD2UDQ_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTPD2UDQ_Z(mz, k, y))
}

// VCVTPD2UDQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UDQ.Z m512 k ymm
//	VCVTPD2UDQ.Z zmm  k ymm
//
// Construct and append a VCVTPD2UDQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UDQ_Z(mz, k, y operand.Op) { ctx.VCVTPD2UDQ_Z(mz, k, y) }

// VCVTPD2UQQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTPD2UQQ m128 k xmm
//	VCVTPD2UQQ m128 xmm
//	VCVTPD2UQQ m256 k ymm
//	VCVTPD2UQQ m256 ymm
//	VCVTPD2UQQ xmm  k xmm
//	VCVTPD2UQQ xmm  xmm
//	VCVTPD2UQQ ymm  k ymm
//	VCVTPD2UQQ ymm  ymm
//	VCVTPD2UQQ m512 k zmm
//	VCVTPD2UQQ m512 zmm
//	VCVTPD2UQQ zmm  k zmm
//	VCVTPD2UQQ zmm  zmm
//
// Construct and append a VCVTPD2UQQ instruction to the active function.
func (c *Context) VCVTPD2UQQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ(ops...))
}

// VCVTPD2UQQ: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTPD2UQQ m128 k xmm
//	VCVTPD2UQQ m128 xmm
//	VCVTPD2UQQ m256 k ymm
//	VCVTPD2UQQ m256 ymm
//	VCVTPD2UQQ xmm  k xmm
//	VCVTPD2UQQ xmm  xmm
//	VCVTPD2UQQ ymm  k ymm
//	VCVTPD2UQQ ymm  ymm
//	VCVTPD2UQQ m512 k zmm
//	VCVTPD2UQQ m512 zmm
//	VCVTPD2UQQ zmm  k zmm
//	VCVTPD2UQQ zmm  zmm
//
// Construct and append a VCVTPD2UQQ instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ(ops ...operand.Op) { ctx.VCVTPD2UQQ(ops...) }

// VCVTPD2UQQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UQQ.BCST m64 k xmm
//	VCVTPD2UQQ.BCST m64 k ymm
//	VCVTPD2UQQ.BCST m64 xmm
//	VCVTPD2UQQ.BCST m64 ymm
//	VCVTPD2UQQ.BCST m64 k zmm
//	VCVTPD2UQQ.BCST m64 zmm
//
// Construct and append a VCVTPD2UQQ.BCST instruction to the active function.
func (c *Context) VCVTPD2UQQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_BCST(ops...))
}

// VCVTPD2UQQ_BCST: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTPD2UQQ.BCST m64 k xmm
//	VCVTPD2UQQ.BCST m64 k ymm
//	VCVTPD2UQQ.BCST m64 xmm
//	VCVTPD2UQQ.BCST m64 ymm
//	VCVTPD2UQQ.BCST m64 k zmm
//	VCVTPD2UQQ.BCST m64 zmm
//
// Construct and append a VCVTPD2UQQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_BCST(ops ...operand.Op) { ctx.VCVTPD2UQQ_BCST(ops...) }

// VCVTPD2UQQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.BCST.Z m64 k xmm
//	VCVTPD2UQQ.BCST.Z m64 k ymm
//	VCVTPD2UQQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTPD2UQQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_BCST_Z(m, k, xyz))
}

// VCVTPD2UQQ_BCST_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.BCST.Z m64 k xmm
//	VCVTPD2UQQ.BCST.Z m64 k ymm
//	VCVTPD2UQQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTPD2UQQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPD2UQQ_BCST_Z(m, k, xyz) }

// VCVTPD2UQQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE zmm k zmm
//	VCVTPD2UQQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPD2UQQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RD_SAE(ops...))
}

// VCVTPD2UQQ_RD_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE zmm k zmm
//	VCVTPD2UQQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPD2UQQ_RD_SAE(ops...) }

// VCVTPD2UQQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RD_SAE_Z(z, k, z1))
}

// VCVTPD2UQQ_RD_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2UQQ_RD_SAE_Z(z, k, z1) }

// VCVTPD2UQQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE zmm k zmm
//	VCVTPD2UQQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPD2UQQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RN_SAE(ops...))
}

// VCVTPD2UQQ_RN_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE zmm k zmm
//	VCVTPD2UQQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPD2UQQ_RN_SAE(ops...) }

// VCVTPD2UQQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RN_SAE_Z(z, k, z1))
}

// VCVTPD2UQQ_RN_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2UQQ_RN_SAE_Z(z, k, z1) }

// VCVTPD2UQQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE zmm k zmm
//	VCVTPD2UQQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPD2UQQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RU_SAE(ops...))
}

// VCVTPD2UQQ_RU_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE zmm k zmm
//	VCVTPD2UQQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPD2UQQ_RU_SAE(ops...) }

// VCVTPD2UQQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RU_SAE_Z(z, k, z1))
}

// VCVTPD2UQQ_RU_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2UQQ_RU_SAE_Z(z, k, z1) }

// VCVTPD2UQQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE zmm k zmm
//	VCVTPD2UQQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPD2UQQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RZ_SAE(ops...))
}

// VCVTPD2UQQ_RZ_SAE: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE zmm k zmm
//	VCVTPD2UQQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPD2UQQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPD2UQQ_RZ_SAE(ops...) }

// VCVTPD2UQQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_RZ_SAE_Z(z, k, z1))
}

// VCVTPD2UQQ_RZ_SAE_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPD2UQQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPD2UQQ_RZ_SAE_Z(z, k, z1) }

// VCVTPD2UQQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.Z m128 k xmm
//	VCVTPD2UQQ.Z m256 k ymm
//	VCVTPD2UQQ.Z xmm  k xmm
//	VCVTPD2UQQ.Z ymm  k ymm
//	VCVTPD2UQQ.Z m512 k zmm
//	VCVTPD2UQQ.Z zmm  k zmm
//
// Construct and append a VCVTPD2UQQ.Z instruction to the active function.
func (c *Context) VCVTPD2UQQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPD2UQQ_Z(mxyz, k, xyz))
}

// VCVTPD2UQQ_Z: Convert Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPD2UQQ.Z m128 k xmm
//	VCVTPD2UQQ.Z m256 k ymm
//	VCVTPD2UQQ.Z xmm  k xmm
//	VCVTPD2UQQ.Z ymm  k ymm
//	VCVTPD2UQQ.Z m512 k zmm
//	VCVTPD2UQQ.Z zmm  k zmm
//
// Construct and append a VCVTPD2UQQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPD2UQQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTPD2UQQ_Z(mxyz, k, xyz) }

// VCVTPH2PS: Convert Half-Precision FP Values to Single-Precision FP Values.
//
// Forms:
//
//	VCVTPH2PS m128 ymm
//	VCVTPH2PS m64  xmm
//	VCVTPH2PS xmm  xmm
//	VCVTPH2PS xmm  ymm
//	VCVTPH2PS m128 k ymm
//	VCVTPH2PS m64  k xmm
//	VCVTPH2PS xmm  k xmm
//	VCVTPH2PS xmm  k ymm
//	VCVTPH2PS m256 k zmm
//	VCVTPH2PS m256 zmm
//	VCVTPH2PS ymm  k zmm
//	VCVTPH2PS ymm  zmm
//
// Construct and append a VCVTPH2PS instruction to the active function.
func (c *Context) VCVTPH2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPH2PS(ops...))
}

// VCVTPH2PS: Convert Half-Precision FP Values to Single-Precision FP Values.
//
// Forms:
//
//	VCVTPH2PS m128 ymm
//	VCVTPH2PS m64  xmm
//	VCVTPH2PS xmm  xmm
//	VCVTPH2PS xmm  ymm
//	VCVTPH2PS m128 k ymm
//	VCVTPH2PS m64  k xmm
//	VCVTPH2PS xmm  k xmm
//	VCVTPH2PS xmm  k ymm
//	VCVTPH2PS m256 k zmm
//	VCVTPH2PS m256 zmm
//	VCVTPH2PS ymm  k zmm
//	VCVTPH2PS ymm  zmm
//
// Construct and append a VCVTPH2PS instruction to the active function.
// Operates on the global context.
func VCVTPH2PS(ops ...operand.Op) { ctx.VCVTPH2PS(ops...) }

// VCVTPH2PS_SAE: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPH2PS.SAE ymm k zmm
//	VCVTPH2PS.SAE ymm zmm
//
// Construct and append a VCVTPH2PS.SAE instruction to the active function.
func (c *Context) VCVTPH2PS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPH2PS_SAE(ops...))
}

// VCVTPH2PS_SAE: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPH2PS.SAE ymm k zmm
//	VCVTPH2PS.SAE ymm zmm
//
// Construct and append a VCVTPH2PS.SAE instruction to the active function.
// Operates on the global context.
func VCVTPH2PS_SAE(ops ...operand.Op) { ctx.VCVTPH2PS_SAE(ops...) }

// VCVTPH2PS_SAE_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.SAE.Z ymm k zmm
//
// Construct and append a VCVTPH2PS.SAE.Z instruction to the active function.
func (c *Context) VCVTPH2PS_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPH2PS_SAE_Z(y, k, z))
}

// VCVTPH2PS_SAE_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.SAE.Z ymm k zmm
//
// Construct and append a VCVTPH2PS.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPH2PS_SAE_Z(y, k, z operand.Op) { ctx.VCVTPH2PS_SAE_Z(y, k, z) }

// VCVTPH2PS_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.Z m128 k ymm
//	VCVTPH2PS.Z m64  k xmm
//	VCVTPH2PS.Z xmm  k xmm
//	VCVTPH2PS.Z xmm  k ymm
//	VCVTPH2PS.Z m256 k zmm
//	VCVTPH2PS.Z ymm  k zmm
//
// Construct and append a VCVTPH2PS.Z instruction to the active function.
func (c *Context) VCVTPH2PS_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPH2PS_Z(mxy, k, xyz))
}

// VCVTPH2PS_Z: Convert Half-Precision FP Values to Single-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPH2PS.Z m128 k ymm
//	VCVTPH2PS.Z m64  k xmm
//	VCVTPH2PS.Z xmm  k xmm
//	VCVTPH2PS.Z xmm  k ymm
//	VCVTPH2PS.Z m256 k zmm
//	VCVTPH2PS.Z ymm  k zmm
//
// Construct and append a VCVTPH2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTPH2PS_Z(mxy, k, xyz operand.Op) { ctx.VCVTPH2PS_Z(mxy, k, xyz) }

// VCVTPS2DQ: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPS2DQ m128 xmm
//	VCVTPS2DQ m256 ymm
//	VCVTPS2DQ xmm  xmm
//	VCVTPS2DQ ymm  ymm
//	VCVTPS2DQ m128 k xmm
//	VCVTPS2DQ m256 k ymm
//	VCVTPS2DQ xmm  k xmm
//	VCVTPS2DQ ymm  k ymm
//	VCVTPS2DQ m512 k zmm
//	VCVTPS2DQ m512 zmm
//	VCVTPS2DQ zmm  k zmm
//	VCVTPS2DQ zmm  zmm
//
// Construct and append a VCVTPS2DQ instruction to the active function.
func (c *Context) VCVTPS2DQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ(ops...))
}

// VCVTPS2DQ: Convert Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTPS2DQ m128 xmm
//	VCVTPS2DQ m256 ymm
//	VCVTPS2DQ xmm  xmm
//	VCVTPS2DQ ymm  ymm
//	VCVTPS2DQ m128 k xmm
//	VCVTPS2DQ m256 k ymm
//	VCVTPS2DQ xmm  k xmm
//	VCVTPS2DQ ymm  k ymm
//	VCVTPS2DQ m512 k zmm
//	VCVTPS2DQ m512 zmm
//	VCVTPS2DQ zmm  k zmm
//	VCVTPS2DQ zmm  zmm
//
// Construct and append a VCVTPS2DQ instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ(ops ...operand.Op) { ctx.VCVTPS2DQ(ops...) }

// VCVTPS2DQ_BCST: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPS2DQ.BCST m32 k xmm
//	VCVTPS2DQ.BCST m32 k ymm
//	VCVTPS2DQ.BCST m32 xmm
//	VCVTPS2DQ.BCST m32 ymm
//	VCVTPS2DQ.BCST m32 k zmm
//	VCVTPS2DQ.BCST m32 zmm
//
// Construct and append a VCVTPS2DQ.BCST instruction to the active function.
func (c *Context) VCVTPS2DQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_BCST(ops...))
}

// VCVTPS2DQ_BCST: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTPS2DQ.BCST m32 k xmm
//	VCVTPS2DQ.BCST m32 k ymm
//	VCVTPS2DQ.BCST m32 xmm
//	VCVTPS2DQ.BCST m32 ymm
//	VCVTPS2DQ.BCST m32 k zmm
//	VCVTPS2DQ.BCST m32 zmm
//
// Construct and append a VCVTPS2DQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_BCST(ops ...operand.Op) { ctx.VCVTPS2DQ_BCST(ops...) }

// VCVTPS2DQ_BCST_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.BCST.Z m32 k xmm
//	VCVTPS2DQ.BCST.Z m32 k ymm
//	VCVTPS2DQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2DQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_BCST_Z(m, k, xyz))
}

// VCVTPS2DQ_BCST_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.BCST.Z m32 k xmm
//	VCVTPS2DQ.BCST.Z m32 k ymm
//	VCVTPS2DQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2DQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPS2DQ_BCST_Z(m, k, xyz) }

// VCVTPS2DQ_RD_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE zmm k zmm
//	VCVTPS2DQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPS2DQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RD_SAE(ops...))
}

// VCVTPS2DQ_RD_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE zmm k zmm
//	VCVTPS2DQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPS2DQ_RD_SAE(ops...) }

// VCVTPS2DQ_RD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RD_SAE_Z(z, k, z1))
}

// VCVTPS2DQ_RD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2DQ_RD_SAE_Z(z, k, z1) }

// VCVTPS2DQ_RN_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE zmm k zmm
//	VCVTPS2DQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPS2DQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RN_SAE(ops...))
}

// VCVTPS2DQ_RN_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE zmm k zmm
//	VCVTPS2DQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPS2DQ_RN_SAE(ops...) }

// VCVTPS2DQ_RN_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RN_SAE_Z(z, k, z1))
}

// VCVTPS2DQ_RN_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2DQ_RN_SAE_Z(z, k, z1) }

// VCVTPS2DQ_RU_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE zmm k zmm
//	VCVTPS2DQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPS2DQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RU_SAE(ops...))
}

// VCVTPS2DQ_RU_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE zmm k zmm
//	VCVTPS2DQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPS2DQ_RU_SAE(ops...) }

// VCVTPS2DQ_RU_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RU_SAE_Z(z, k, z1))
}

// VCVTPS2DQ_RU_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2DQ_RU_SAE_Z(z, k, z1) }

// VCVTPS2DQ_RZ_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE zmm k zmm
//	VCVTPS2DQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPS2DQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RZ_SAE(ops...))
}

// VCVTPS2DQ_RZ_SAE: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE zmm k zmm
//	VCVTPS2DQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPS2DQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPS2DQ_RZ_SAE(ops...) }

// VCVTPS2DQ_RZ_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_RZ_SAE_Z(z, k, z1))
}

// VCVTPS2DQ_RZ_SAE_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2DQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2DQ_RZ_SAE_Z(z, k, z1) }

// VCVTPS2DQ_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.Z m128 k xmm
//	VCVTPS2DQ.Z m256 k ymm
//	VCVTPS2DQ.Z xmm  k xmm
//	VCVTPS2DQ.Z ymm  k ymm
//	VCVTPS2DQ.Z m512 k zmm
//	VCVTPS2DQ.Z zmm  k zmm
//
// Construct and append a VCVTPS2DQ.Z instruction to the active function.
func (c *Context) VCVTPS2DQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2DQ_Z(mxyz, k, xyz))
}

// VCVTPS2DQ_Z: Convert Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2DQ.Z m128 k xmm
//	VCVTPS2DQ.Z m256 k ymm
//	VCVTPS2DQ.Z xmm  k xmm
//	VCVTPS2DQ.Z ymm  k ymm
//	VCVTPS2DQ.Z m512 k zmm
//	VCVTPS2DQ.Z zmm  k zmm
//
// Construct and append a VCVTPS2DQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2DQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTPS2DQ_Z(mxyz, k, xyz) }

// VCVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTPS2PD m128 ymm
//	VCVTPS2PD m64  xmm
//	VCVTPS2PD xmm  xmm
//	VCVTPS2PD xmm  ymm
//	VCVTPS2PD m64  k xmm
//	VCVTPS2PD xmm  k xmm
//	VCVTPS2PD m256 k zmm
//	VCVTPS2PD m256 zmm
//	VCVTPS2PD ymm  k zmm
//	VCVTPS2PD ymm  zmm
//	VCVTPS2PD m128 k ymm
//	VCVTPS2PD xmm  k ymm
//
// Construct and append a VCVTPS2PD instruction to the active function.
func (c *Context) VCVTPS2PD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2PD(ops...))
}

// VCVTPS2PD: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values.
//
// Forms:
//
//	VCVTPS2PD m128 ymm
//	VCVTPS2PD m64  xmm
//	VCVTPS2PD xmm  xmm
//	VCVTPS2PD xmm  ymm
//	VCVTPS2PD m64  k xmm
//	VCVTPS2PD xmm  k xmm
//	VCVTPS2PD m256 k zmm
//	VCVTPS2PD m256 zmm
//	VCVTPS2PD ymm  k zmm
//	VCVTPS2PD ymm  zmm
//	VCVTPS2PD m128 k ymm
//	VCVTPS2PD xmm  k ymm
//
// Construct and append a VCVTPS2PD instruction to the active function.
// Operates on the global context.
func VCVTPS2PD(ops ...operand.Op) { ctx.VCVTPS2PD(ops...) }

// VCVTPS2PD_BCST: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPS2PD.BCST m32 k xmm
//	VCVTPS2PD.BCST m32 xmm
//	VCVTPS2PD.BCST m32 k zmm
//	VCVTPS2PD.BCST m32 zmm
//	VCVTPS2PD.BCST m32 k ymm
//	VCVTPS2PD.BCST m32 ymm
//
// Construct and append a VCVTPS2PD.BCST instruction to the active function.
func (c *Context) VCVTPS2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2PD_BCST(ops...))
}

// VCVTPS2PD_BCST: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast).
//
// Forms:
//
//	VCVTPS2PD.BCST m32 k xmm
//	VCVTPS2PD.BCST m32 xmm
//	VCVTPS2PD.BCST m32 k zmm
//	VCVTPS2PD.BCST m32 zmm
//	VCVTPS2PD.BCST m32 k ymm
//	VCVTPS2PD.BCST m32 ymm
//
// Construct and append a VCVTPS2PD.BCST instruction to the active function.
// Operates on the global context.
func VCVTPS2PD_BCST(ops ...operand.Op) { ctx.VCVTPS2PD_BCST(ops...) }

// VCVTPS2PD_BCST_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.BCST.Z m32 k xmm
//	VCVTPS2PD.BCST.Z m32 k zmm
//	VCVTPS2PD.BCST.Z m32 k ymm
//
// Construct and append a VCVTPS2PD.BCST.Z instruction to the active function.
func (c *Context) VCVTPS2PD_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2PD_BCST_Z(m, k, xyz))
}

// VCVTPS2PD_BCST_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.BCST.Z m32 k xmm
//	VCVTPS2PD.BCST.Z m32 k zmm
//	VCVTPS2PD.BCST.Z m32 k ymm
//
// Construct and append a VCVTPS2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2PD_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPS2PD_BCST_Z(m, k, xyz) }

// VCVTPS2PD_SAE: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PD.SAE ymm k zmm
//	VCVTPS2PD.SAE ymm zmm
//
// Construct and append a VCVTPS2PD.SAE instruction to the active function.
func (c *Context) VCVTPS2PD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2PD_SAE(ops...))
}

// VCVTPS2PD_SAE: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PD.SAE ymm k zmm
//	VCVTPS2PD.SAE ymm zmm
//
// Construct and append a VCVTPS2PD.SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2PD_SAE(ops ...operand.Op) { ctx.VCVTPS2PD_SAE(ops...) }

// VCVTPS2PD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2PD.SAE.Z instruction to the active function.
func (c *Context) VCVTPS2PD_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2PD_SAE_Z(y, k, z))
}

// VCVTPS2PD_SAE_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2PD.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2PD_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2PD_SAE_Z(y, k, z) }

// VCVTPS2PD_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.Z m64  k xmm
//	VCVTPS2PD.Z xmm  k xmm
//	VCVTPS2PD.Z m256 k zmm
//	VCVTPS2PD.Z ymm  k zmm
//	VCVTPS2PD.Z m128 k ymm
//	VCVTPS2PD.Z xmm  k ymm
//
// Construct and append a VCVTPS2PD.Z instruction to the active function.
func (c *Context) VCVTPS2PD_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2PD_Z(mxy, k, xyz))
}

// VCVTPS2PD_Z: Convert Packed Single-Precision FP Values to Packed Double-Precision FP Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PD.Z m64  k xmm
//	VCVTPS2PD.Z xmm  k xmm
//	VCVTPS2PD.Z m256 k zmm
//	VCVTPS2PD.Z ymm  k zmm
//	VCVTPS2PD.Z m128 k ymm
//	VCVTPS2PD.Z xmm  k ymm
//
// Construct and append a VCVTPS2PD.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2PD_Z(mxy, k, xyz operand.Op) { ctx.VCVTPS2PD_Z(mxy, k, xyz) }

// VCVTPS2PH: Convert Single-Precision FP value to Half-Precision FP value.
//
// Forms:
//
//	VCVTPS2PH imm8 xmm m64
//	VCVTPS2PH imm8 xmm xmm
//	VCVTPS2PH imm8 ymm m128
//	VCVTPS2PH imm8 ymm xmm
//	VCVTPS2PH imm8 xmm k m64
//	VCVTPS2PH imm8 xmm k xmm
//	VCVTPS2PH imm8 ymm k m128
//	VCVTPS2PH imm8 ymm k xmm
//	VCVTPS2PH imm8 zmm k m256
//	VCVTPS2PH imm8 zmm k ymm
//	VCVTPS2PH imm8 zmm m256
//	VCVTPS2PH imm8 zmm ymm
//
// Construct and append a VCVTPS2PH instruction to the active function.
func (c *Context) VCVTPS2PH(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2PH(ops...))
}

// VCVTPS2PH: Convert Single-Precision FP value to Half-Precision FP value.
//
// Forms:
//
//	VCVTPS2PH imm8 xmm m64
//	VCVTPS2PH imm8 xmm xmm
//	VCVTPS2PH imm8 ymm m128
//	VCVTPS2PH imm8 ymm xmm
//	VCVTPS2PH imm8 xmm k m64
//	VCVTPS2PH imm8 xmm k xmm
//	VCVTPS2PH imm8 ymm k m128
//	VCVTPS2PH imm8 ymm k xmm
//	VCVTPS2PH imm8 zmm k m256
//	VCVTPS2PH imm8 zmm k ymm
//	VCVTPS2PH imm8 zmm m256
//	VCVTPS2PH imm8 zmm ymm
//
// Construct and append a VCVTPS2PH instruction to the active function.
// Operates on the global context.
func VCVTPS2PH(ops ...operand.Op) { ctx.VCVTPS2PH(ops...) }

// VCVTPS2PH_SAE: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PH.SAE imm8 zmm k ymm
//	VCVTPS2PH.SAE imm8 zmm ymm
//
// Construct and append a VCVTPS2PH.SAE instruction to the active function.
func (c *Context) VCVTPS2PH_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2PH_SAE(ops...))
}

// VCVTPS2PH_SAE: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTPS2PH.SAE imm8 zmm k ymm
//	VCVTPS2PH.SAE imm8 zmm ymm
//
// Construct and append a VCVTPS2PH.SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2PH_SAE(ops ...operand.Op) { ctx.VCVTPS2PH_SAE(ops...) }

// VCVTPS2PH_SAE_Z: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.SAE.Z imm8 zmm k ymm
//
// Construct and append a VCVTPS2PH.SAE.Z instruction to the active function.
func (c *Context) VCVTPS2PH_SAE_Z(i, z, k, y operand.Op) {
	c.addinstruction(x86.VCVTPS2PH_SAE_Z(i, z, k, y))
}

// VCVTPS2PH_SAE_Z: Convert Single-Precision FP value to Half-Precision FP value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.SAE.Z imm8 zmm k ymm
//
// Construct and append a VCVTPS2PH.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2PH_SAE_Z(i, z, k, y operand.Op) { ctx.VCVTPS2PH_SAE_Z(i, z, k, y) }

// VCVTPS2PH_Z: Convert Single-Precision FP value to Half-Precision FP value (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.Z imm8 xmm k m64
//	VCVTPS2PH.Z imm8 xmm k xmm
//	VCVTPS2PH.Z imm8 ymm k m128
//	VCVTPS2PH.Z imm8 ymm k xmm
//	VCVTPS2PH.Z imm8 zmm k m256
//	VCVTPS2PH.Z imm8 zmm k ymm
//
// Construct and append a VCVTPS2PH.Z instruction to the active function.
func (c *Context) VCVTPS2PH_Z(i, xyz, k, mxy operand.Op) {
	c.addinstruction(x86.VCVTPS2PH_Z(i, xyz, k, mxy))
}

// VCVTPS2PH_Z: Convert Single-Precision FP value to Half-Precision FP value (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2PH.Z imm8 xmm k m64
//	VCVTPS2PH.Z imm8 xmm k xmm
//	VCVTPS2PH.Z imm8 ymm k m128
//	VCVTPS2PH.Z imm8 ymm k xmm
//	VCVTPS2PH.Z imm8 zmm k m256
//	VCVTPS2PH.Z imm8 zmm k ymm
//
// Construct and append a VCVTPS2PH.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2PH_Z(i, xyz, k, mxy operand.Op) { ctx.VCVTPS2PH_Z(i, xyz, k, mxy) }

// VCVTPS2QQ: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2QQ m128 k ymm
//	VCVTPS2QQ m128 ymm
//	VCVTPS2QQ m64  k xmm
//	VCVTPS2QQ m64  xmm
//	VCVTPS2QQ xmm  k xmm
//	VCVTPS2QQ xmm  k ymm
//	VCVTPS2QQ xmm  xmm
//	VCVTPS2QQ xmm  ymm
//	VCVTPS2QQ m256 k zmm
//	VCVTPS2QQ m256 zmm
//	VCVTPS2QQ ymm  k zmm
//	VCVTPS2QQ ymm  zmm
//
// Construct and append a VCVTPS2QQ instruction to the active function.
func (c *Context) VCVTPS2QQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ(ops...))
}

// VCVTPS2QQ: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2QQ m128 k ymm
//	VCVTPS2QQ m128 ymm
//	VCVTPS2QQ m64  k xmm
//	VCVTPS2QQ m64  xmm
//	VCVTPS2QQ xmm  k xmm
//	VCVTPS2QQ xmm  k ymm
//	VCVTPS2QQ xmm  xmm
//	VCVTPS2QQ xmm  ymm
//	VCVTPS2QQ m256 k zmm
//	VCVTPS2QQ m256 zmm
//	VCVTPS2QQ ymm  k zmm
//	VCVTPS2QQ ymm  zmm
//
// Construct and append a VCVTPS2QQ instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ(ops ...operand.Op) { ctx.VCVTPS2QQ(ops...) }

// VCVTPS2QQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2QQ.BCST m32 k xmm
//	VCVTPS2QQ.BCST m32 k ymm
//	VCVTPS2QQ.BCST m32 xmm
//	VCVTPS2QQ.BCST m32 ymm
//	VCVTPS2QQ.BCST m32 k zmm
//	VCVTPS2QQ.BCST m32 zmm
//
// Construct and append a VCVTPS2QQ.BCST instruction to the active function.
func (c *Context) VCVTPS2QQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_BCST(ops...))
}

// VCVTPS2QQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2QQ.BCST m32 k xmm
//	VCVTPS2QQ.BCST m32 k ymm
//	VCVTPS2QQ.BCST m32 xmm
//	VCVTPS2QQ.BCST m32 ymm
//	VCVTPS2QQ.BCST m32 k zmm
//	VCVTPS2QQ.BCST m32 zmm
//
// Construct and append a VCVTPS2QQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_BCST(ops ...operand.Op) { ctx.VCVTPS2QQ_BCST(ops...) }

// VCVTPS2QQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.BCST.Z m32 k xmm
//	VCVTPS2QQ.BCST.Z m32 k ymm
//	VCVTPS2QQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2QQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_BCST_Z(m, k, xyz))
}

// VCVTPS2QQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.BCST.Z m32 k xmm
//	VCVTPS2QQ.BCST.Z m32 k ymm
//	VCVTPS2QQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2QQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPS2QQ_BCST_Z(m, k, xyz) }

// VCVTPS2QQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE ymm k zmm
//	VCVTPS2QQ.RD_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPS2QQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RD_SAE(ops...))
}

// VCVTPS2QQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE ymm k zmm
//	VCVTPS2QQ.RD_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPS2QQ_RD_SAE(ops...) }

// VCVTPS2QQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_RD_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RD_SAE_Z(y, k, z))
}

// VCVTPS2QQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RD_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RD_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2QQ_RD_SAE_Z(y, k, z) }

// VCVTPS2QQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE ymm k zmm
//	VCVTPS2QQ.RN_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPS2QQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RN_SAE(ops...))
}

// VCVTPS2QQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE ymm k zmm
//	VCVTPS2QQ.RN_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPS2QQ_RN_SAE(ops...) }

// VCVTPS2QQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_RN_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RN_SAE_Z(y, k, z))
}

// VCVTPS2QQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RN_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RN_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2QQ_RN_SAE_Z(y, k, z) }

// VCVTPS2QQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE ymm k zmm
//	VCVTPS2QQ.RU_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPS2QQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RU_SAE(ops...))
}

// VCVTPS2QQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE ymm k zmm
//	VCVTPS2QQ.RU_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPS2QQ_RU_SAE(ops...) }

// VCVTPS2QQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_RU_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RU_SAE_Z(y, k, z))
}

// VCVTPS2QQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RU_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RU_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2QQ_RU_SAE_Z(y, k, z) }

// VCVTPS2QQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE ymm k zmm
//	VCVTPS2QQ.RZ_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPS2QQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RZ_SAE(ops...))
}

// VCVTPS2QQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE ymm k zmm
//	VCVTPS2QQ.RZ_SAE ymm zmm
//
// Construct and append a VCVTPS2QQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPS2QQ_RZ_SAE(ops...) }

// VCVTPS2QQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_RZ_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_RZ_SAE_Z(y, k, z))
}

// VCVTPS2QQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.RZ_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2QQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_RZ_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2QQ_RZ_SAE_Z(y, k, z) }

// VCVTPS2QQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.Z m128 k ymm
//	VCVTPS2QQ.Z m64  k xmm
//	VCVTPS2QQ.Z xmm  k xmm
//	VCVTPS2QQ.Z xmm  k ymm
//	VCVTPS2QQ.Z m256 k zmm
//	VCVTPS2QQ.Z ymm  k zmm
//
// Construct and append a VCVTPS2QQ.Z instruction to the active function.
func (c *Context) VCVTPS2QQ_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2QQ_Z(mxy, k, xyz))
}

// VCVTPS2QQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2QQ.Z m128 k ymm
//	VCVTPS2QQ.Z m64  k xmm
//	VCVTPS2QQ.Z xmm  k xmm
//	VCVTPS2QQ.Z xmm  k ymm
//	VCVTPS2QQ.Z m256 k zmm
//	VCVTPS2QQ.Z ymm  k zmm
//
// Construct and append a VCVTPS2QQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2QQ_Z(mxy, k, xyz operand.Op) { ctx.VCVTPS2QQ_Z(mxy, k, xyz) }

// VCVTPS2UDQ: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTPS2UDQ m128 k xmm
//	VCVTPS2UDQ m128 xmm
//	VCVTPS2UDQ m256 k ymm
//	VCVTPS2UDQ m256 ymm
//	VCVTPS2UDQ xmm  k xmm
//	VCVTPS2UDQ xmm  xmm
//	VCVTPS2UDQ ymm  k ymm
//	VCVTPS2UDQ ymm  ymm
//	VCVTPS2UDQ m512 k zmm
//	VCVTPS2UDQ m512 zmm
//	VCVTPS2UDQ zmm  k zmm
//	VCVTPS2UDQ zmm  zmm
//
// Construct and append a VCVTPS2UDQ instruction to the active function.
func (c *Context) VCVTPS2UDQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ(ops...))
}

// VCVTPS2UDQ: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTPS2UDQ m128 k xmm
//	VCVTPS2UDQ m128 xmm
//	VCVTPS2UDQ m256 k ymm
//	VCVTPS2UDQ m256 ymm
//	VCVTPS2UDQ xmm  k xmm
//	VCVTPS2UDQ xmm  xmm
//	VCVTPS2UDQ ymm  k ymm
//	VCVTPS2UDQ ymm  ymm
//	VCVTPS2UDQ m512 k zmm
//	VCVTPS2UDQ m512 zmm
//	VCVTPS2UDQ zmm  k zmm
//	VCVTPS2UDQ zmm  zmm
//
// Construct and append a VCVTPS2UDQ instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ(ops ...operand.Op) { ctx.VCVTPS2UDQ(ops...) }

// VCVTPS2UDQ_BCST: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UDQ.BCST m32 k xmm
//	VCVTPS2UDQ.BCST m32 k ymm
//	VCVTPS2UDQ.BCST m32 xmm
//	VCVTPS2UDQ.BCST m32 ymm
//	VCVTPS2UDQ.BCST m32 k zmm
//	VCVTPS2UDQ.BCST m32 zmm
//
// Construct and append a VCVTPS2UDQ.BCST instruction to the active function.
func (c *Context) VCVTPS2UDQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_BCST(ops...))
}

// VCVTPS2UDQ_BCST: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UDQ.BCST m32 k xmm
//	VCVTPS2UDQ.BCST m32 k ymm
//	VCVTPS2UDQ.BCST m32 xmm
//	VCVTPS2UDQ.BCST m32 ymm
//	VCVTPS2UDQ.BCST m32 k zmm
//	VCVTPS2UDQ.BCST m32 zmm
//
// Construct and append a VCVTPS2UDQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_BCST(ops ...operand.Op) { ctx.VCVTPS2UDQ_BCST(ops...) }

// VCVTPS2UDQ_BCST_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.BCST.Z m32 k xmm
//	VCVTPS2UDQ.BCST.Z m32 k ymm
//	VCVTPS2UDQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2UDQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_BCST_Z(m, k, xyz))
}

// VCVTPS2UDQ_BCST_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.BCST.Z m32 k xmm
//	VCVTPS2UDQ.BCST.Z m32 k ymm
//	VCVTPS2UDQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2UDQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPS2UDQ_BCST_Z(m, k, xyz) }

// VCVTPS2UDQ_RD_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE zmm k zmm
//	VCVTPS2UDQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPS2UDQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RD_SAE(ops...))
}

// VCVTPS2UDQ_RD_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE zmm k zmm
//	VCVTPS2UDQ.RD_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPS2UDQ_RD_SAE(ops...) }

// VCVTPS2UDQ_RD_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RD_SAE_Z(z, k, z1))
}

// VCVTPS2UDQ_RD_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2UDQ_RD_SAE_Z(z, k, z1) }

// VCVTPS2UDQ_RN_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE zmm k zmm
//	VCVTPS2UDQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPS2UDQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RN_SAE(ops...))
}

// VCVTPS2UDQ_RN_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE zmm k zmm
//	VCVTPS2UDQ.RN_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPS2UDQ_RN_SAE(ops...) }

// VCVTPS2UDQ_RN_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RN_SAE_Z(z, k, z1))
}

// VCVTPS2UDQ_RN_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2UDQ_RN_SAE_Z(z, k, z1) }

// VCVTPS2UDQ_RU_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE zmm k zmm
//	VCVTPS2UDQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPS2UDQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RU_SAE(ops...))
}

// VCVTPS2UDQ_RU_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE zmm k zmm
//	VCVTPS2UDQ.RU_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPS2UDQ_RU_SAE(ops...) }

// VCVTPS2UDQ_RU_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RU_SAE_Z(z, k, z1))
}

// VCVTPS2UDQ_RU_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2UDQ_RU_SAE_Z(z, k, z1) }

// VCVTPS2UDQ_RZ_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE zmm k zmm
//	VCVTPS2UDQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPS2UDQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RZ_SAE(ops...))
}

// VCVTPS2UDQ_RZ_SAE: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE zmm k zmm
//	VCVTPS2UDQ.RZ_SAE zmm zmm
//
// Construct and append a VCVTPS2UDQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPS2UDQ_RZ_SAE(ops...) }

// VCVTPS2UDQ_RZ_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_RZ_SAE_Z(z, k, z1))
}

// VCVTPS2UDQ_RZ_SAE_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTPS2UDQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTPS2UDQ_RZ_SAE_Z(z, k, z1) }

// VCVTPS2UDQ_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.Z m128 k xmm
//	VCVTPS2UDQ.Z m256 k ymm
//	VCVTPS2UDQ.Z xmm  k xmm
//	VCVTPS2UDQ.Z ymm  k ymm
//	VCVTPS2UDQ.Z m512 k zmm
//	VCVTPS2UDQ.Z zmm  k zmm
//
// Construct and append a VCVTPS2UDQ.Z instruction to the active function.
func (c *Context) VCVTPS2UDQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2UDQ_Z(mxyz, k, xyz))
}

// VCVTPS2UDQ_Z: Convert Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UDQ.Z m128 k xmm
//	VCVTPS2UDQ.Z m256 k ymm
//	VCVTPS2UDQ.Z xmm  k xmm
//	VCVTPS2UDQ.Z ymm  k ymm
//	VCVTPS2UDQ.Z m512 k zmm
//	VCVTPS2UDQ.Z zmm  k zmm
//
// Construct and append a VCVTPS2UDQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UDQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTPS2UDQ_Z(mxyz, k, xyz) }

// VCVTPS2UQQ: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2UQQ m128 k ymm
//	VCVTPS2UQQ m128 ymm
//	VCVTPS2UQQ m64  k xmm
//	VCVTPS2UQQ m64  xmm
//	VCVTPS2UQQ xmm  k xmm
//	VCVTPS2UQQ xmm  k ymm
//	VCVTPS2UQQ xmm  xmm
//	VCVTPS2UQQ xmm  ymm
//	VCVTPS2UQQ m256 k zmm
//	VCVTPS2UQQ m256 zmm
//	VCVTPS2UQQ ymm  k zmm
//	VCVTPS2UQQ ymm  zmm
//
// Construct and append a VCVTPS2UQQ instruction to the active function.
func (c *Context) VCVTPS2UQQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ(ops...))
}

// VCVTPS2UQQ: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTPS2UQQ m128 k ymm
//	VCVTPS2UQQ m128 ymm
//	VCVTPS2UQQ m64  k xmm
//	VCVTPS2UQQ m64  xmm
//	VCVTPS2UQQ xmm  k xmm
//	VCVTPS2UQQ xmm  k ymm
//	VCVTPS2UQQ xmm  xmm
//	VCVTPS2UQQ xmm  ymm
//	VCVTPS2UQQ m256 k zmm
//	VCVTPS2UQQ m256 zmm
//	VCVTPS2UQQ ymm  k zmm
//	VCVTPS2UQQ ymm  zmm
//
// Construct and append a VCVTPS2UQQ instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ(ops ...operand.Op) { ctx.VCVTPS2UQQ(ops...) }

// VCVTPS2UQQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UQQ.BCST m32 k xmm
//	VCVTPS2UQQ.BCST m32 k ymm
//	VCVTPS2UQQ.BCST m32 xmm
//	VCVTPS2UQQ.BCST m32 ymm
//	VCVTPS2UQQ.BCST m32 k zmm
//	VCVTPS2UQQ.BCST m32 zmm
//
// Construct and append a VCVTPS2UQQ.BCST instruction to the active function.
func (c *Context) VCVTPS2UQQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_BCST(ops...))
}

// VCVTPS2UQQ_BCST: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTPS2UQQ.BCST m32 k xmm
//	VCVTPS2UQQ.BCST m32 k ymm
//	VCVTPS2UQQ.BCST m32 xmm
//	VCVTPS2UQQ.BCST m32 ymm
//	VCVTPS2UQQ.BCST m32 k zmm
//	VCVTPS2UQQ.BCST m32 zmm
//
// Construct and append a VCVTPS2UQQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_BCST(ops ...operand.Op) { ctx.VCVTPS2UQQ_BCST(ops...) }

// VCVTPS2UQQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.BCST.Z m32 k xmm
//	VCVTPS2UQQ.BCST.Z m32 k ymm
//	VCVTPS2UQQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2UQQ.BCST.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_BCST_Z(m, k, xyz))
}

// VCVTPS2UQQ_BCST_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.BCST.Z m32 k xmm
//	VCVTPS2UQQ.BCST.Z m32 k ymm
//	VCVTPS2UQQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTPS2UQQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTPS2UQQ_BCST_Z(m, k, xyz) }

// VCVTPS2UQQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE ymm k zmm
//	VCVTPS2UQQ.RD_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RD_SAE instruction to the active function.
func (c *Context) VCVTPS2UQQ_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RD_SAE(ops...))
}

// VCVTPS2UQQ_RD_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE ymm k zmm
//	VCVTPS2UQQ.RD_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RD_SAE(ops ...operand.Op) { ctx.VCVTPS2UQQ_RD_SAE(ops...) }

// VCVTPS2UQQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_RD_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RD_SAE_Z(y, k, z))
}

// VCVTPS2UQQ_RD_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RD_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RD_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2UQQ_RD_SAE_Z(y, k, z) }

// VCVTPS2UQQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE ymm k zmm
//	VCVTPS2UQQ.RN_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RN_SAE instruction to the active function.
func (c *Context) VCVTPS2UQQ_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RN_SAE(ops...))
}

// VCVTPS2UQQ_RN_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE ymm k zmm
//	VCVTPS2UQQ.RN_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RN_SAE(ops ...operand.Op) { ctx.VCVTPS2UQQ_RN_SAE(ops...) }

// VCVTPS2UQQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_RN_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RN_SAE_Z(y, k, z))
}

// VCVTPS2UQQ_RN_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RN_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RN_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2UQQ_RN_SAE_Z(y, k, z) }

// VCVTPS2UQQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE ymm k zmm
//	VCVTPS2UQQ.RU_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RU_SAE instruction to the active function.
func (c *Context) VCVTPS2UQQ_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RU_SAE(ops...))
}

// VCVTPS2UQQ_RU_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE ymm k zmm
//	VCVTPS2UQQ.RU_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RU_SAE(ops ...operand.Op) { ctx.VCVTPS2UQQ_RU_SAE(ops...) }

// VCVTPS2UQQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_RU_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RU_SAE_Z(y, k, z))
}

// VCVTPS2UQQ_RU_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RU_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RU_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2UQQ_RU_SAE_Z(y, k, z) }

// VCVTPS2UQQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE ymm k zmm
//	VCVTPS2UQQ.RZ_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTPS2UQQ_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RZ_SAE(ops...))
}

// VCVTPS2UQQ_RZ_SAE: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE ymm k zmm
//	VCVTPS2UQQ.RZ_SAE ymm zmm
//
// Construct and append a VCVTPS2UQQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RZ_SAE(ops ...operand.Op) { ctx.VCVTPS2UQQ_RZ_SAE(ops...) }

// VCVTPS2UQQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_RZ_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_RZ_SAE_Z(y, k, z))
}

// VCVTPS2UQQ_RZ_SAE_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.RZ_SAE.Z ymm k zmm
//
// Construct and append a VCVTPS2UQQ.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_RZ_SAE_Z(y, k, z operand.Op) { ctx.VCVTPS2UQQ_RZ_SAE_Z(y, k, z) }

// VCVTPS2UQQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.Z m128 k ymm
//	VCVTPS2UQQ.Z m64  k xmm
//	VCVTPS2UQQ.Z xmm  k xmm
//	VCVTPS2UQQ.Z xmm  k ymm
//	VCVTPS2UQQ.Z m256 k zmm
//	VCVTPS2UQQ.Z ymm  k zmm
//
// Construct and append a VCVTPS2UQQ.Z instruction to the active function.
func (c *Context) VCVTPS2UQQ_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTPS2UQQ_Z(mxy, k, xyz))
}

// VCVTPS2UQQ_Z: Convert Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTPS2UQQ.Z m128 k ymm
//	VCVTPS2UQQ.Z m64  k xmm
//	VCVTPS2UQQ.Z xmm  k xmm
//	VCVTPS2UQQ.Z xmm  k ymm
//	VCVTPS2UQQ.Z m256 k zmm
//	VCVTPS2UQQ.Z ymm  k zmm
//
// Construct and append a VCVTPS2UQQ.Z instruction to the active function.
// Operates on the global context.
func VCVTPS2UQQ_Z(mxy, k, xyz operand.Op) { ctx.VCVTPS2UQQ_Z(mxy, k, xyz) }

// VCVTQQ2PD: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PD m128 k xmm
//	VCVTQQ2PD m128 xmm
//	VCVTQQ2PD m256 k ymm
//	VCVTQQ2PD m256 ymm
//	VCVTQQ2PD xmm  k xmm
//	VCVTQQ2PD xmm  xmm
//	VCVTQQ2PD ymm  k ymm
//	VCVTQQ2PD ymm  ymm
//	VCVTQQ2PD m512 k zmm
//	VCVTQQ2PD m512 zmm
//	VCVTQQ2PD zmm  k zmm
//	VCVTQQ2PD zmm  zmm
//
// Construct and append a VCVTQQ2PD instruction to the active function.
func (c *Context) VCVTQQ2PD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD(ops...))
}

// VCVTQQ2PD: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PD m128 k xmm
//	VCVTQQ2PD m128 xmm
//	VCVTQQ2PD m256 k ymm
//	VCVTQQ2PD m256 ymm
//	VCVTQQ2PD xmm  k xmm
//	VCVTQQ2PD xmm  xmm
//	VCVTQQ2PD ymm  k ymm
//	VCVTQQ2PD ymm  ymm
//	VCVTQQ2PD m512 k zmm
//	VCVTQQ2PD m512 zmm
//	VCVTQQ2PD zmm  k zmm
//	VCVTQQ2PD zmm  zmm
//
// Construct and append a VCVTQQ2PD instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD(ops ...operand.Op) { ctx.VCVTQQ2PD(ops...) }

// VCVTQQ2PD_BCST: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PD.BCST m64 k xmm
//	VCVTQQ2PD.BCST m64 k ymm
//	VCVTQQ2PD.BCST m64 xmm
//	VCVTQQ2PD.BCST m64 ymm
//	VCVTQQ2PD.BCST m64 k zmm
//	VCVTQQ2PD.BCST m64 zmm
//
// Construct and append a VCVTQQ2PD.BCST instruction to the active function.
func (c *Context) VCVTQQ2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_BCST(ops...))
}

// VCVTQQ2PD_BCST: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PD.BCST m64 k xmm
//	VCVTQQ2PD.BCST m64 k ymm
//	VCVTQQ2PD.BCST m64 xmm
//	VCVTQQ2PD.BCST m64 ymm
//	VCVTQQ2PD.BCST m64 k zmm
//	VCVTQQ2PD.BCST m64 zmm
//
// Construct and append a VCVTQQ2PD.BCST instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_BCST(ops ...operand.Op) { ctx.VCVTQQ2PD_BCST(ops...) }

// VCVTQQ2PD_BCST_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.BCST.Z m64 k xmm
//	VCVTQQ2PD.BCST.Z m64 k ymm
//	VCVTQQ2PD.BCST.Z m64 k zmm
//
// Construct and append a VCVTQQ2PD.BCST.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_BCST_Z(m, k, xyz))
}

// VCVTQQ2PD_BCST_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.BCST.Z m64 k xmm
//	VCVTQQ2PD.BCST.Z m64 k ymm
//	VCVTQQ2PD.BCST.Z m64 k zmm
//
// Construct and append a VCVTQQ2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTQQ2PD_BCST_Z(m, k, xyz) }

// VCVTQQ2PD_RD_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE zmm k zmm
//	VCVTQQ2PD.RD_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RD_SAE instruction to the active function.
func (c *Context) VCVTQQ2PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RD_SAE(ops...))
}

// VCVTQQ2PD_RD_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE zmm k zmm
//	VCVTQQ2PD.RD_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RD_SAE(ops ...operand.Op) { ctx.VCVTQQ2PD_RD_SAE(ops...) }

// VCVTQQ2PD_RD_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RD_SAE_Z(z, k, z1))
}

// VCVTQQ2PD_RD_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTQQ2PD_RD_SAE_Z(z, k, z1) }

// VCVTQQ2PD_RN_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE zmm k zmm
//	VCVTQQ2PD.RN_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RN_SAE instruction to the active function.
func (c *Context) VCVTQQ2PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RN_SAE(ops...))
}

// VCVTQQ2PD_RN_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE zmm k zmm
//	VCVTQQ2PD.RN_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RN_SAE(ops ...operand.Op) { ctx.VCVTQQ2PD_RN_SAE(ops...) }

// VCVTQQ2PD_RN_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RN_SAE_Z(z, k, z1))
}

// VCVTQQ2PD_RN_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTQQ2PD_RN_SAE_Z(z, k, z1) }

// VCVTQQ2PD_RU_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE zmm k zmm
//	VCVTQQ2PD.RU_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RU_SAE instruction to the active function.
func (c *Context) VCVTQQ2PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RU_SAE(ops...))
}

// VCVTQQ2PD_RU_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE zmm k zmm
//	VCVTQQ2PD.RU_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RU_SAE(ops ...operand.Op) { ctx.VCVTQQ2PD_RU_SAE(ops...) }

// VCVTQQ2PD_RU_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RU_SAE_Z(z, k, z1))
}

// VCVTQQ2PD_RU_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTQQ2PD_RU_SAE_Z(z, k, z1) }

// VCVTQQ2PD_RZ_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE zmm k zmm
//	VCVTQQ2PD.RZ_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RZ_SAE instruction to the active function.
func (c *Context) VCVTQQ2PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RZ_SAE(ops...))
}

// VCVTQQ2PD_RZ_SAE: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE zmm k zmm
//	VCVTQQ2PD.RZ_SAE zmm zmm
//
// Construct and append a VCVTQQ2PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RZ_SAE(ops ...operand.Op) { ctx.VCVTQQ2PD_RZ_SAE(ops...) }

// VCVTQQ2PD_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_RZ_SAE_Z(z, k, z1))
}

// VCVTQQ2PD_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTQQ2PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTQQ2PD_RZ_SAE_Z(z, k, z1) }

// VCVTQQ2PD_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.Z m128 k xmm
//	VCVTQQ2PD.Z m256 k ymm
//	VCVTQQ2PD.Z xmm  k xmm
//	VCVTQQ2PD.Z ymm  k ymm
//	VCVTQQ2PD.Z m512 k zmm
//	VCVTQQ2PD.Z zmm  k zmm
//
// Construct and append a VCVTQQ2PD.Z instruction to the active function.
func (c *Context) VCVTQQ2PD_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTQQ2PD_Z(mxyz, k, xyz))
}

// VCVTQQ2PD_Z: Convert Packed Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PD.Z m128 k xmm
//	VCVTQQ2PD.Z m256 k ymm
//	VCVTQQ2PD.Z xmm  k xmm
//	VCVTQQ2PD.Z ymm  k ymm
//	VCVTQQ2PD.Z m512 k zmm
//	VCVTQQ2PD.Z zmm  k zmm
//
// Construct and append a VCVTQQ2PD.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PD_Z(mxyz, k, xyz operand.Op) { ctx.VCVTQQ2PD_Z(mxyz, k, xyz) }

// VCVTQQ2PS: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PS m512 k ymm
//	VCVTQQ2PS m512 ymm
//	VCVTQQ2PS zmm  k ymm
//	VCVTQQ2PS zmm  ymm
//
// Construct and append a VCVTQQ2PS instruction to the active function.
func (c *Context) VCVTQQ2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS(ops...))
}

// VCVTQQ2PS: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PS m512 k ymm
//	VCVTQQ2PS m512 ymm
//	VCVTQQ2PS zmm  k ymm
//	VCVTQQ2PS zmm  ymm
//
// Construct and append a VCVTQQ2PS instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS(ops ...operand.Op) { ctx.VCVTQQ2PS(ops...) }

// VCVTQQ2PSX: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSX m128 k xmm
//	VCVTQQ2PSX m128 xmm
//	VCVTQQ2PSX xmm  k xmm
//	VCVTQQ2PSX xmm  xmm
//
// Construct and append a VCVTQQ2PSX instruction to the active function.
func (c *Context) VCVTQQ2PSX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSX(ops...))
}

// VCVTQQ2PSX: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSX m128 k xmm
//	VCVTQQ2PSX m128 xmm
//	VCVTQQ2PSX xmm  k xmm
//	VCVTQQ2PSX xmm  xmm
//
// Construct and append a VCVTQQ2PSX instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSX(ops ...operand.Op) { ctx.VCVTQQ2PSX(ops...) }

// VCVTQQ2PSX_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSX.BCST m64 k xmm
//	VCVTQQ2PSX.BCST m64 xmm
//
// Construct and append a VCVTQQ2PSX.BCST instruction to the active function.
func (c *Context) VCVTQQ2PSX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSX_BCST(ops...))
}

// VCVTQQ2PSX_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSX.BCST m64 k xmm
//	VCVTQQ2PSX.BCST m64 xmm
//
// Construct and append a VCVTQQ2PSX.BCST instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSX_BCST(ops ...operand.Op) { ctx.VCVTQQ2PSX_BCST(ops...) }

// VCVTQQ2PSX_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTQQ2PSX.BCST.Z instruction to the active function.
func (c *Context) VCVTQQ2PSX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSX_BCST_Z(m, k, x))
}

// VCVTQQ2PSX_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTQQ2PSX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSX_BCST_Z(m, k, x operand.Op) { ctx.VCVTQQ2PSX_BCST_Z(m, k, x) }

// VCVTQQ2PSX_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.Z m128 k xmm
//	VCVTQQ2PSX.Z xmm  k xmm
//
// Construct and append a VCVTQQ2PSX.Z instruction to the active function.
func (c *Context) VCVTQQ2PSX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSX_Z(mx, k, x))
}

// VCVTQQ2PSX_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSX.Z m128 k xmm
//	VCVTQQ2PSX.Z xmm  k xmm
//
// Construct and append a VCVTQQ2PSX.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSX_Z(mx, k, x operand.Op) { ctx.VCVTQQ2PSX_Z(mx, k, x) }

// VCVTQQ2PSY: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSY m256 k xmm
//	VCVTQQ2PSY m256 xmm
//	VCVTQQ2PSY ymm  k xmm
//	VCVTQQ2PSY ymm  xmm
//
// Construct and append a VCVTQQ2PSY instruction to the active function.
func (c *Context) VCVTQQ2PSY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSY(ops...))
}

// VCVTQQ2PSY: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTQQ2PSY m256 k xmm
//	VCVTQQ2PSY m256 xmm
//	VCVTQQ2PSY ymm  k xmm
//	VCVTQQ2PSY ymm  xmm
//
// Construct and append a VCVTQQ2PSY instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSY(ops ...operand.Op) { ctx.VCVTQQ2PSY(ops...) }

// VCVTQQ2PSY_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSY.BCST m64 k xmm
//	VCVTQQ2PSY.BCST m64 xmm
//
// Construct and append a VCVTQQ2PSY.BCST instruction to the active function.
func (c *Context) VCVTQQ2PSY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSY_BCST(ops...))
}

// VCVTQQ2PSY_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PSY.BCST m64 k xmm
//	VCVTQQ2PSY.BCST m64 xmm
//
// Construct and append a VCVTQQ2PSY.BCST instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSY_BCST(ops ...operand.Op) { ctx.VCVTQQ2PSY_BCST(ops...) }

// VCVTQQ2PSY_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTQQ2PSY.BCST.Z instruction to the active function.
func (c *Context) VCVTQQ2PSY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSY_BCST_Z(m, k, x))
}

// VCVTQQ2PSY_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTQQ2PSY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSY_BCST_Z(m, k, x operand.Op) { ctx.VCVTQQ2PSY_BCST_Z(m, k, x) }

// VCVTQQ2PSY_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.Z m256 k xmm
//	VCVTQQ2PSY.Z ymm  k xmm
//
// Construct and append a VCVTQQ2PSY.Z instruction to the active function.
func (c *Context) VCVTQQ2PSY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTQQ2PSY_Z(my, k, x))
}

// VCVTQQ2PSY_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PSY.Z m256 k xmm
//	VCVTQQ2PSY.Z ymm  k xmm
//
// Construct and append a VCVTQQ2PSY.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PSY_Z(my, k, x operand.Op) { ctx.VCVTQQ2PSY_Z(my, k, x) }

// VCVTQQ2PS_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PS.BCST m64 k ymm
//	VCVTQQ2PS.BCST m64 ymm
//
// Construct and append a VCVTQQ2PS.BCST instruction to the active function.
func (c *Context) VCVTQQ2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_BCST(ops...))
}

// VCVTQQ2PS_BCST: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTQQ2PS.BCST m64 k ymm
//	VCVTQQ2PS.BCST m64 ymm
//
// Construct and append a VCVTQQ2PS.BCST instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_BCST(ops ...operand.Op) { ctx.VCVTQQ2PS_BCST(ops...) }

// VCVTQQ2PS_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTQQ2PS.BCST.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_BCST_Z(m, k, y))
}

// VCVTQQ2PS_BCST_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTQQ2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_BCST_Z(m, k, y operand.Op) { ctx.VCVTQQ2PS_BCST_Z(m, k, y) }

// VCVTQQ2PS_RD_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE zmm k ymm
//	VCVTQQ2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RD_SAE instruction to the active function.
func (c *Context) VCVTQQ2PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RD_SAE(ops...))
}

// VCVTQQ2PS_RD_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE zmm k ymm
//	VCVTQQ2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RD_SAE(ops ...operand.Op) { ctx.VCVTQQ2PS_RD_SAE(ops...) }

// VCVTQQ2PS_RD_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_RD_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RD_SAE_Z(z, k, y))
}

// VCVTQQ2PS_RD_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RD_SAE_Z(z, k, y operand.Op) { ctx.VCVTQQ2PS_RD_SAE_Z(z, k, y) }

// VCVTQQ2PS_RN_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE zmm k ymm
//	VCVTQQ2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RN_SAE instruction to the active function.
func (c *Context) VCVTQQ2PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RN_SAE(ops...))
}

// VCVTQQ2PS_RN_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE zmm k ymm
//	VCVTQQ2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RN_SAE(ops ...operand.Op) { ctx.VCVTQQ2PS_RN_SAE(ops...) }

// VCVTQQ2PS_RN_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_RN_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RN_SAE_Z(z, k, y))
}

// VCVTQQ2PS_RN_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RN_SAE_Z(z, k, y operand.Op) { ctx.VCVTQQ2PS_RN_SAE_Z(z, k, y) }

// VCVTQQ2PS_RU_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE zmm k ymm
//	VCVTQQ2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RU_SAE instruction to the active function.
func (c *Context) VCVTQQ2PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RU_SAE(ops...))
}

// VCVTQQ2PS_RU_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE zmm k ymm
//	VCVTQQ2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RU_SAE(ops ...operand.Op) { ctx.VCVTQQ2PS_RU_SAE(ops...) }

// VCVTQQ2PS_RU_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_RU_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RU_SAE_Z(z, k, y))
}

// VCVTQQ2PS_RU_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RU_SAE_Z(z, k, y operand.Op) { ctx.VCVTQQ2PS_RU_SAE_Z(z, k, y) }

// VCVTQQ2PS_RZ_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE zmm k ymm
//	VCVTQQ2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RZ_SAE instruction to the active function.
func (c *Context) VCVTQQ2PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RZ_SAE(ops...))
}

// VCVTQQ2PS_RZ_SAE: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE zmm k ymm
//	VCVTQQ2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTQQ2PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RZ_SAE(ops ...operand.Op) { ctx.VCVTQQ2PS_RZ_SAE(ops...) }

// VCVTQQ2PS_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_RZ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_RZ_SAE_Z(z, k, y))
}

// VCVTQQ2PS_RZ_SAE_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTQQ2PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_RZ_SAE_Z(z, k, y operand.Op) { ctx.VCVTQQ2PS_RZ_SAE_Z(z, k, y) }

// VCVTQQ2PS_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.Z m512 k ymm
//	VCVTQQ2PS.Z zmm  k ymm
//
// Construct and append a VCVTQQ2PS.Z instruction to the active function.
func (c *Context) VCVTQQ2PS_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTQQ2PS_Z(mz, k, y))
}

// VCVTQQ2PS_Z: Convert Packed Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTQQ2PS.Z m512 k ymm
//	VCVTQQ2PS.Z zmm  k ymm
//
// Construct and append a VCVTQQ2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTQQ2PS_Z(mz, k, y operand.Op) { ctx.VCVTQQ2PS_Z(mz, k, y) }

// VCVTSD2SI: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SI m64 r32
//	VCVTSD2SI xmm r32
//
// Construct and append a VCVTSD2SI instruction to the active function.
func (c *Context) VCVTSD2SI(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SI(mx, r))
}

// VCVTSD2SI: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SI m64 r32
//	VCVTSD2SI xmm r32
//
// Construct and append a VCVTSD2SI instruction to the active function.
// Operates on the global context.
func VCVTSD2SI(mx, r operand.Op) { ctx.VCVTSD2SI(mx, r) }

// VCVTSD2SIQ: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SIQ m64 r64
//	VCVTSD2SIQ xmm r64
//
// Construct and append a VCVTSD2SIQ instruction to the active function.
func (c *Context) VCVTSD2SIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SIQ(mx, r))
}

// VCVTSD2SIQ: Convert Scalar Double-Precision FP Value to Integer.
//
// Forms:
//
//	VCVTSD2SIQ m64 r64
//	VCVTSD2SIQ xmm r64
//
// Construct and append a VCVTSD2SIQ instruction to the active function.
// Operates on the global context.
func VCVTSD2SIQ(mx, r operand.Op) { ctx.VCVTSD2SIQ(mx, r) }

// VCVTSD2SIQ_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSD2SIQ_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SIQ_RD_SAE(x, r))
}

// VCVTSD2SIQ_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SIQ_RD_SAE(x, r operand.Op) { ctx.VCVTSD2SIQ_RD_SAE(x, r) }

// VCVTSD2SIQ_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSD2SIQ_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SIQ_RN_SAE(x, r))
}

// VCVTSD2SIQ_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SIQ_RN_SAE(x, r operand.Op) { ctx.VCVTSD2SIQ_RN_SAE(x, r) }

// VCVTSD2SIQ_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSD2SIQ_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SIQ_RU_SAE(x, r))
}

// VCVTSD2SIQ_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SIQ_RU_SAE(x, r operand.Op) { ctx.VCVTSD2SIQ_RU_SAE(x, r) }

// VCVTSD2SIQ_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSD2SIQ_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SIQ_RZ_SAE(x, r))
}

// VCVTSD2SIQ_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSD2SIQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SIQ_RZ_SAE(x, r operand.Op) { ctx.VCVTSD2SIQ_RZ_SAE(x, r) }

// VCVTSD2SI_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SI.RD_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RD_SAE instruction to the active function.
func (c *Context) VCVTSD2SI_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SI_RD_SAE(x, r))
}

// VCVTSD2SI_RD_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SI.RD_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SI_RD_SAE(x, r operand.Op) { ctx.VCVTSD2SI_RD_SAE(x, r) }

// VCVTSD2SI_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SI.RN_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RN_SAE instruction to the active function.
func (c *Context) VCVTSD2SI_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SI_RN_SAE(x, r))
}

// VCVTSD2SI_RN_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SI.RN_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SI_RN_SAE(x, r operand.Op) { ctx.VCVTSD2SI_RN_SAE(x, r) }

// VCVTSD2SI_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SI.RU_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RU_SAE instruction to the active function.
func (c *Context) VCVTSD2SI_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SI_RU_SAE(x, r))
}

// VCVTSD2SI_RU_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SI.RU_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SI_RU_SAE(x, r operand.Op) { ctx.VCVTSD2SI_RU_SAE(x, r) }

// VCVTSD2SI_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SI.RZ_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RZ_SAE instruction to the active function.
func (c *Context) VCVTSD2SI_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2SI_RZ_SAE(x, r))
}

// VCVTSD2SI_RZ_SAE: Convert Scalar Double-Precision FP Value to Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SI.RZ_SAE xmm r32
//
// Construct and append a VCVTSD2SI.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SI_RZ_SAE(x, r operand.Op) { ctx.VCVTSD2SI_RZ_SAE(x, r) }

// VCVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSD2SS m64 xmm xmm
//	VCVTSD2SS xmm xmm xmm
//	VCVTSD2SS m64 xmm k xmm
//	VCVTSD2SS xmm xmm k xmm
//
// Construct and append a VCVTSD2SS instruction to the active function.
func (c *Context) VCVTSD2SS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSD2SS(ops...))
}

// VCVTSD2SS: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSD2SS m64 xmm xmm
//	VCVTSD2SS xmm xmm xmm
//	VCVTSD2SS m64 xmm k xmm
//	VCVTSD2SS xmm xmm k xmm
//
// Construct and append a VCVTSD2SS instruction to the active function.
// Operates on the global context.
func VCVTSD2SS(ops ...operand.Op) { ctx.VCVTSD2SS(ops...) }

// VCVTSD2SS_RD_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE xmm xmm k xmm
//	VCVTSD2SS.RD_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RD_SAE instruction to the active function.
func (c *Context) VCVTSD2SS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RD_SAE(ops...))
}

// VCVTSD2SS_RD_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE xmm xmm k xmm
//	VCVTSD2SS.RD_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RD_SAE(ops ...operand.Op) { ctx.VCVTSD2SS_RD_SAE(ops...) }

// VCVTSD2SS_RD_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTSD2SS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RD_SAE_Z(x, x1, k, x2))
}

// VCVTSD2SS_RD_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VCVTSD2SS_RD_SAE_Z(x, x1, k, x2) }

// VCVTSD2SS_RN_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE xmm xmm k xmm
//	VCVTSD2SS.RN_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RN_SAE instruction to the active function.
func (c *Context) VCVTSD2SS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RN_SAE(ops...))
}

// VCVTSD2SS_RN_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE xmm xmm k xmm
//	VCVTSD2SS.RN_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RN_SAE(ops ...operand.Op) { ctx.VCVTSD2SS_RN_SAE(ops...) }

// VCVTSD2SS_RN_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTSD2SS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RN_SAE_Z(x, x1, k, x2))
}

// VCVTSD2SS_RN_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VCVTSD2SS_RN_SAE_Z(x, x1, k, x2) }

// VCVTSD2SS_RU_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE xmm xmm k xmm
//	VCVTSD2SS.RU_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RU_SAE instruction to the active function.
func (c *Context) VCVTSD2SS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RU_SAE(ops...))
}

// VCVTSD2SS_RU_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE xmm xmm k xmm
//	VCVTSD2SS.RU_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RU_SAE(ops ...operand.Op) { ctx.VCVTSD2SS_RU_SAE(ops...) }

// VCVTSD2SS_RU_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTSD2SS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RU_SAE_Z(x, x1, k, x2))
}

// VCVTSD2SS_RU_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VCVTSD2SS_RU_SAE_Z(x, x1, k, x2) }

// VCVTSD2SS_RZ_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE xmm xmm k xmm
//	VCVTSD2SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RZ_SAE instruction to the active function.
func (c *Context) VCVTSD2SS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RZ_SAE(ops...))
}

// VCVTSD2SS_RZ_SAE: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE xmm xmm k xmm
//	VCVTSD2SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VCVTSD2SS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RZ_SAE(ops ...operand.Op) { ctx.VCVTSD2SS_RZ_SAE(ops...) }

// VCVTSD2SS_RZ_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTSD2SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_RZ_SAE_Z(x, x1, k, x2))
}

// VCVTSD2SS_RZ_SAE_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VCVTSD2SS_RZ_SAE_Z(x, x1, k, x2) }

// VCVTSD2SS_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.Z m64 xmm k xmm
//	VCVTSD2SS.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.Z instruction to the active function.
func (c *Context) VCVTSD2SS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VCVTSD2SS_Z(mx, x, k, x1))
}

// VCVTSD2SS_Z: Convert Scalar Double-Precision FP Value to Scalar Single-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSD2SS.Z m64 xmm k xmm
//	VCVTSD2SS.Z xmm xmm k xmm
//
// Construct and append a VCVTSD2SS.Z instruction to the active function.
// Operates on the global context.
func VCVTSD2SS_Z(mx, x, k, x1 operand.Op) { ctx.VCVTSD2SS_Z(mx, x, k, x1) }

// VCVTSD2USIL: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIL m64 r32
//	VCVTSD2USIL xmm r32
//
// Construct and append a VCVTSD2USIL instruction to the active function.
func (c *Context) VCVTSD2USIL(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIL(mx, r))
}

// VCVTSD2USIL: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIL m64 r32
//	VCVTSD2USIL xmm r32
//
// Construct and append a VCVTSD2USIL instruction to the active function.
// Operates on the global context.
func VCVTSD2USIL(mx, r operand.Op) { ctx.VCVTSD2USIL(mx, r) }

// VCVTSD2USIL_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RD_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RD_SAE instruction to the active function.
func (c *Context) VCVTSD2USIL_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIL_RD_SAE(x, r))
}

// VCVTSD2USIL_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RD_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIL_RD_SAE(x, r operand.Op) { ctx.VCVTSD2USIL_RD_SAE(x, r) }

// VCVTSD2USIL_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIL.RN_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RN_SAE instruction to the active function.
func (c *Context) VCVTSD2USIL_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIL_RN_SAE(x, r))
}

// VCVTSD2USIL_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIL.RN_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIL_RN_SAE(x, r operand.Op) { ctx.VCVTSD2USIL_RN_SAE(x, r) }

// VCVTSD2USIL_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RU_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RU_SAE instruction to the active function.
func (c *Context) VCVTSD2USIL_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIL_RU_SAE(x, r))
}

// VCVTSD2USIL_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIL.RU_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIL_RU_SAE(x, r operand.Op) { ctx.VCVTSD2USIL_RU_SAE(x, r) }

// VCVTSD2USIL_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIL.RZ_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RZ_SAE instruction to the active function.
func (c *Context) VCVTSD2USIL_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIL_RZ_SAE(x, r))
}

// VCVTSD2USIL_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIL.RZ_SAE xmm r32
//
// Construct and append a VCVTSD2USIL.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIL_RZ_SAE(x, r operand.Op) { ctx.VCVTSD2USIL_RZ_SAE(x, r) }

// VCVTSD2USIQ: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIQ m64 r64
//	VCVTSD2USIQ xmm r64
//
// Construct and append a VCVTSD2USIQ instruction to the active function.
func (c *Context) VCVTSD2USIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIQ(mx, r))
}

// VCVTSD2USIQ: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSD2USIQ m64 r64
//	VCVTSD2USIQ xmm r64
//
// Construct and append a VCVTSD2USIQ instruction to the active function.
// Operates on the global context.
func VCVTSD2USIQ(mx, r operand.Op) { ctx.VCVTSD2USIQ(mx, r) }

// VCVTSD2USIQ_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSD2USIQ_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIQ_RD_SAE(x, r))
}

// VCVTSD2USIQ_RD_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIQ_RD_SAE(x, r operand.Op) { ctx.VCVTSD2USIQ_RD_SAE(x, r) }

// VCVTSD2USIQ_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSD2USIQ_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIQ_RN_SAE(x, r))
}

// VCVTSD2USIQ_RN_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSD2USIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIQ_RN_SAE(x, r operand.Op) { ctx.VCVTSD2USIQ_RN_SAE(x, r) }

// VCVTSD2USIQ_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSD2USIQ_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIQ_RU_SAE(x, r))
}

// VCVTSD2USIQ_RU_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSD2USIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIQ_RU_SAE(x, r operand.Op) { ctx.VCVTSD2USIQ_RU_SAE(x, r) }

// VCVTSD2USIQ_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSD2USIQ_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSD2USIQ_RZ_SAE(x, r))
}

// VCVTSD2USIQ_RZ_SAE: Convert Scalar Double-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSD2USIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSD2USIQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSD2USIQ_RZ_SAE(x, r operand.Op) { ctx.VCVTSD2USIQ_RZ_SAE(x, r) }

// VCVTSI2SDL: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDL m32 xmm xmm
//	VCVTSI2SDL r32 xmm xmm
//
// Construct and append a VCVTSI2SDL instruction to the active function.
func (c *Context) VCVTSI2SDL(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDL(mr, x, x1))
}

// VCVTSI2SDL: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDL m32 xmm xmm
//	VCVTSI2SDL r32 xmm xmm
//
// Construct and append a VCVTSI2SDL instruction to the active function.
// Operates on the global context.
func VCVTSI2SDL(mr, x, x1 operand.Op) { ctx.VCVTSI2SDL(mr, x, x1) }

// VCVTSI2SDQ: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDQ m64 xmm xmm
//	VCVTSI2SDQ r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ instruction to the active function.
func (c *Context) VCVTSI2SDQ(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDQ(mr, x, x1))
}

// VCVTSI2SDQ: Convert Dword Integer to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SDQ m64 xmm xmm
//	VCVTSI2SDQ r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ instruction to the active function.
// Operates on the global context.
func VCVTSI2SDQ(mr, x, x1 operand.Op) { ctx.VCVTSI2SDQ(mr, x, x1) }

// VCVTSI2SDQ_RD_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSI2SDQ_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDQ_RD_SAE(r, x, x1))
}

// VCVTSI2SDQ_RD_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SDQ_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SDQ_RD_SAE(r, x, x1) }

// VCVTSI2SDQ_RN_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SDQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSI2SDQ_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDQ_RN_SAE(r, x, x1))
}

// VCVTSI2SDQ_RN_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SDQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SDQ_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SDQ_RN_SAE(r, x, x1) }

// VCVTSI2SDQ_RU_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSI2SDQ_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDQ_RU_SAE(r, x, x1))
}

// VCVTSI2SDQ_RU_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SDQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SDQ_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SDQ_RU_SAE(r, x, x1) }

// VCVTSI2SDQ_RZ_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SDQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSI2SDQ_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SDQ_RZ_SAE(r, x, x1))
}

// VCVTSI2SDQ_RZ_SAE: Convert Dword Integer to Scalar Double-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SDQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SDQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SDQ_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SDQ_RZ_SAE(r, x, x1) }

// VCVTSI2SSL: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSL m32 xmm xmm
//	VCVTSI2SSL r32 xmm xmm
//
// Construct and append a VCVTSI2SSL instruction to the active function.
func (c *Context) VCVTSI2SSL(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSL(mr, x, x1))
}

// VCVTSI2SSL: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSL m32 xmm xmm
//	VCVTSI2SSL r32 xmm xmm
//
// Construct and append a VCVTSI2SSL instruction to the active function.
// Operates on the global context.
func VCVTSI2SSL(mr, x, x1 operand.Op) { ctx.VCVTSI2SSL(mr, x, x1) }

// VCVTSI2SSL_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RD_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RD_SAE instruction to the active function.
func (c *Context) VCVTSI2SSL_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSL_RD_SAE(r, x, x1))
}

// VCVTSI2SSL_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RD_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSL_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSL_RD_SAE(r, x, x1) }

// VCVTSI2SSL_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSL.RN_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RN_SAE instruction to the active function.
func (c *Context) VCVTSI2SSL_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSL_RN_SAE(r, x, x1))
}

// VCVTSI2SSL_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSL.RN_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSL_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSL_RN_SAE(r, x, x1) }

// VCVTSI2SSL_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RU_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RU_SAE instruction to the active function.
func (c *Context) VCVTSI2SSL_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSL_RU_SAE(r, x, x1))
}

// VCVTSI2SSL_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSL.RU_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSL_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSL_RU_SAE(r, x, x1) }

// VCVTSI2SSL_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSL.RZ_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RZ_SAE instruction to the active function.
func (c *Context) VCVTSI2SSL_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSL_RZ_SAE(r, x, x1))
}

// VCVTSI2SSL_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSL.RZ_SAE r32 xmm xmm
//
// Construct and append a VCVTSI2SSL.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSL_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSL_RZ_SAE(r, x, x1) }

// VCVTSI2SSQ: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSQ m64 xmm xmm
//	VCVTSI2SSQ r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ instruction to the active function.
func (c *Context) VCVTSI2SSQ(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSQ(mr, x, x1))
}

// VCVTSI2SSQ: Convert Dword Integer to Scalar Single-Precision FP Value.
//
// Forms:
//
//	VCVTSI2SSQ m64 xmm xmm
//	VCVTSI2SSQ r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ instruction to the active function.
// Operates on the global context.
func VCVTSI2SSQ(mr, x, x1 operand.Op) { ctx.VCVTSI2SSQ(mr, x, x1) }

// VCVTSI2SSQ_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSI2SSQ_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSQ_RD_SAE(r, x, x1))
}

// VCVTSI2SSQ_RD_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSQ_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSQ_RD_SAE(r, x, x1) }

// VCVTSI2SSQ_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSI2SSQ_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSQ_RN_SAE(r, x, x1))
}

// VCVTSI2SSQ_RN_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTSI2SSQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSQ_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSQ_RN_SAE(r, x, x1) }

// VCVTSI2SSQ_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSI2SSQ_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSQ_RU_SAE(r, x, x1))
}

// VCVTSI2SSQ_RU_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSI2SSQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSQ_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSQ_RU_SAE(r, x, x1) }

// VCVTSI2SSQ_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSI2SSQ_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTSI2SSQ_RZ_SAE(r, x, x1))
}

// VCVTSI2SSQ_RZ_SAE: Convert Dword Integer to Scalar Single-Precision FP Value (Round Towards Zero).
//
// Forms:
//
//	VCVTSI2SSQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTSI2SSQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSI2SSQ_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTSI2SSQ_RZ_SAE(r, x, x1) }

// VCVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSS2SD m32 xmm xmm
//	VCVTSS2SD xmm xmm xmm
//	VCVTSS2SD m32 xmm k xmm
//	VCVTSS2SD xmm xmm k xmm
//
// Construct and append a VCVTSS2SD instruction to the active function.
func (c *Context) VCVTSS2SD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSS2SD(ops...))
}

// VCVTSS2SD: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value.
//
// Forms:
//
//	VCVTSS2SD m32 xmm xmm
//	VCVTSS2SD xmm xmm xmm
//	VCVTSS2SD m32 xmm k xmm
//	VCVTSS2SD xmm xmm k xmm
//
// Construct and append a VCVTSS2SD instruction to the active function.
// Operates on the global context.
func VCVTSS2SD(ops ...operand.Op) { ctx.VCVTSS2SD(ops...) }

// VCVTSS2SD_SAE: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTSS2SD.SAE xmm xmm k xmm
//	VCVTSS2SD.SAE xmm xmm xmm
//
// Construct and append a VCVTSS2SD.SAE instruction to the active function.
func (c *Context) VCVTSS2SD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTSS2SD_SAE(ops...))
}

// VCVTSS2SD_SAE: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions).
//
// Forms:
//
//	VCVTSS2SD.SAE xmm xmm k xmm
//	VCVTSS2SD.SAE xmm xmm xmm
//
// Construct and append a VCVTSS2SD.SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SD_SAE(ops ...operand.Op) { ctx.VCVTSS2SD_SAE(ops...) }

// VCVTSS2SD_SAE_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSS2SD.SAE.Z instruction to the active function.
func (c *Context) VCVTSS2SD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VCVTSS2SD_SAE_Z(x, x1, k, x2))
}

// VCVTSS2SD_SAE_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.SAE.Z xmm xmm k xmm
//
// Construct and append a VCVTSS2SD.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTSS2SD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VCVTSS2SD_SAE_Z(x, x1, k, x2) }

// VCVTSS2SD_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.Z m32 xmm k xmm
//	VCVTSS2SD.Z xmm xmm k xmm
//
// Construct and append a VCVTSS2SD.Z instruction to the active function.
func (c *Context) VCVTSS2SD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VCVTSS2SD_Z(mx, x, k, x1))
}

// VCVTSS2SD_Z: Convert Scalar Single-Precision FP Value to Scalar Double-Precision FP Value (Zeroing Masking).
//
// Forms:
//
//	VCVTSS2SD.Z m32 xmm k xmm
//	VCVTSS2SD.Z xmm xmm k xmm
//
// Construct and append a VCVTSS2SD.Z instruction to the active function.
// Operates on the global context.
func VCVTSS2SD_Z(mx, x, k, x1 operand.Op) { ctx.VCVTSS2SD_Z(mx, x, k, x1) }

// VCVTSS2SI: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SI m32 r32
//	VCVTSS2SI xmm r32
//
// Construct and append a VCVTSS2SI instruction to the active function.
func (c *Context) VCVTSS2SI(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SI(mx, r))
}

// VCVTSS2SI: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SI m32 r32
//	VCVTSS2SI xmm r32
//
// Construct and append a VCVTSS2SI instruction to the active function.
// Operates on the global context.
func VCVTSS2SI(mx, r operand.Op) { ctx.VCVTSS2SI(mx, r) }

// VCVTSS2SIQ: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SIQ m32 r64
//	VCVTSS2SIQ xmm r64
//
// Construct and append a VCVTSS2SIQ instruction to the active function.
func (c *Context) VCVTSS2SIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SIQ(mx, r))
}

// VCVTSS2SIQ: Convert Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTSS2SIQ m32 r64
//	VCVTSS2SIQ xmm r64
//
// Construct and append a VCVTSS2SIQ instruction to the active function.
// Operates on the global context.
func VCVTSS2SIQ(mx, r operand.Op) { ctx.VCVTSS2SIQ(mx, r) }

// VCVTSS2SIQ_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSS2SIQ_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SIQ_RD_SAE(x, r))
}

// VCVTSS2SIQ_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SIQ_RD_SAE(x, r operand.Op) { ctx.VCVTSS2SIQ_RD_SAE(x, r) }

// VCVTSS2SIQ_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSS2SIQ_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SIQ_RN_SAE(x, r))
}

// VCVTSS2SIQ_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SIQ_RN_SAE(x, r operand.Op) { ctx.VCVTSS2SIQ_RN_SAE(x, r) }

// VCVTSS2SIQ_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSS2SIQ_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SIQ_RU_SAE(x, r))
}

// VCVTSS2SIQ_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SIQ_RU_SAE(x, r operand.Op) { ctx.VCVTSS2SIQ_RU_SAE(x, r) }

// VCVTSS2SIQ_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSS2SIQ_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SIQ_RZ_SAE(x, r))
}

// VCVTSS2SIQ_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSS2SIQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SIQ_RZ_SAE(x, r operand.Op) { ctx.VCVTSS2SIQ_RZ_SAE(x, r) }

// VCVTSS2SI_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SI.RD_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RD_SAE instruction to the active function.
func (c *Context) VCVTSS2SI_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SI_RD_SAE(x, r))
}

// VCVTSS2SI_RD_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2SI.RD_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SI_RD_SAE(x, r operand.Op) { ctx.VCVTSS2SI_RD_SAE(x, r) }

// VCVTSS2SI_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SI.RN_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RN_SAE instruction to the active function.
func (c *Context) VCVTSS2SI_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SI_RN_SAE(x, r))
}

// VCVTSS2SI_RN_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2SI.RN_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SI_RN_SAE(x, r operand.Op) { ctx.VCVTSS2SI_RN_SAE(x, r) }

// VCVTSS2SI_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SI.RU_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RU_SAE instruction to the active function.
func (c *Context) VCVTSS2SI_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SI_RU_SAE(x, r))
}

// VCVTSS2SI_RU_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2SI.RU_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SI_RU_SAE(x, r operand.Op) { ctx.VCVTSS2SI_RU_SAE(x, r) }

// VCVTSS2SI_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SI.RZ_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RZ_SAE instruction to the active function.
func (c *Context) VCVTSS2SI_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2SI_RZ_SAE(x, r))
}

// VCVTSS2SI_RZ_SAE: Convert Scalar Single-Precision FP Value to Dword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2SI.RZ_SAE xmm r32
//
// Construct and append a VCVTSS2SI.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2SI_RZ_SAE(x, r operand.Op) { ctx.VCVTSS2SI_RZ_SAE(x, r) }

// VCVTSS2USIL: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIL m32 r32
//	VCVTSS2USIL xmm r32
//
// Construct and append a VCVTSS2USIL instruction to the active function.
func (c *Context) VCVTSS2USIL(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIL(mx, r))
}

// VCVTSS2USIL: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIL m32 r32
//	VCVTSS2USIL xmm r32
//
// Construct and append a VCVTSS2USIL instruction to the active function.
// Operates on the global context.
func VCVTSS2USIL(mx, r operand.Op) { ctx.VCVTSS2USIL(mx, r) }

// VCVTSS2USIL_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RD_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RD_SAE instruction to the active function.
func (c *Context) VCVTSS2USIL_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIL_RD_SAE(x, r))
}

// VCVTSS2USIL_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RD_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIL_RD_SAE(x, r operand.Op) { ctx.VCVTSS2USIL_RD_SAE(x, r) }

// VCVTSS2USIL_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIL.RN_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RN_SAE instruction to the active function.
func (c *Context) VCVTSS2USIL_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIL_RN_SAE(x, r))
}

// VCVTSS2USIL_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIL.RN_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIL_RN_SAE(x, r operand.Op) { ctx.VCVTSS2USIL_RN_SAE(x, r) }

// VCVTSS2USIL_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RU_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RU_SAE instruction to the active function.
func (c *Context) VCVTSS2USIL_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIL_RU_SAE(x, r))
}

// VCVTSS2USIL_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIL.RU_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIL_RU_SAE(x, r operand.Op) { ctx.VCVTSS2USIL_RU_SAE(x, r) }

// VCVTSS2USIL_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIL.RZ_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RZ_SAE instruction to the active function.
func (c *Context) VCVTSS2USIL_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIL_RZ_SAE(x, r))
}

// VCVTSS2USIL_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIL.RZ_SAE xmm r32
//
// Construct and append a VCVTSS2USIL.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIL_RZ_SAE(x, r operand.Op) { ctx.VCVTSS2USIL_RZ_SAE(x, r) }

// VCVTSS2USIQ: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIQ m32 r64
//	VCVTSS2USIQ xmm r64
//
// Construct and append a VCVTSS2USIQ instruction to the active function.
func (c *Context) VCVTSS2USIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIQ(mx, r))
}

// VCVTSS2USIQ: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer.
//
// Forms:
//
//	VCVTSS2USIQ m32 r64
//	VCVTSS2USIQ xmm r64
//
// Construct and append a VCVTSS2USIQ instruction to the active function.
// Operates on the global context.
func VCVTSS2USIQ(mx, r operand.Op) { ctx.VCVTSS2USIQ(mx, r) }

// VCVTSS2USIQ_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RD_SAE instruction to the active function.
func (c *Context) VCVTSS2USIQ_RD_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIQ_RD_SAE(x, r))
}

// VCVTSS2USIQ_RD_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RD_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIQ_RD_SAE(x, r operand.Op) { ctx.VCVTSS2USIQ_RD_SAE(x, r) }

// VCVTSS2USIQ_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RN_SAE instruction to the active function.
func (c *Context) VCVTSS2USIQ_RN_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIQ_RN_SAE(x, r))
}

// VCVTSS2USIQ_RN_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Nearest).
//
// Forms:
//
//	VCVTSS2USIQ.RN_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIQ_RN_SAE(x, r operand.Op) { ctx.VCVTSS2USIQ_RN_SAE(x, r) }

// VCVTSS2USIQ_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RU_SAE instruction to the active function.
func (c *Context) VCVTSS2USIQ_RU_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIQ_RU_SAE(x, r))
}

// VCVTSS2USIQ_RU_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTSS2USIQ.RU_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIQ_RU_SAE(x, r operand.Op) { ctx.VCVTSS2USIQ_RU_SAE(x, r) }

// VCVTSS2USIQ_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTSS2USIQ_RZ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTSS2USIQ_RZ_SAE(x, r))
}

// VCVTSS2USIQ_RZ_SAE: Convert Scalar Single-Precision Floating-Point Value to Unsigned Doubleword Integer (Round Towards Zero).
//
// Forms:
//
//	VCVTSS2USIQ.RZ_SAE xmm r64
//
// Construct and append a VCVTSS2USIQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTSS2USIQ_RZ_SAE(x, r operand.Op) { ctx.VCVTSS2USIQ_RZ_SAE(x, r) }

// VCVTTPD2DQ: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQ m512 k ymm
//	VCVTTPD2DQ m512 ymm
//	VCVTTPD2DQ zmm  k ymm
//	VCVTTPD2DQ zmm  ymm
//
// Construct and append a VCVTTPD2DQ instruction to the active function.
func (c *Context) VCVTTPD2DQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ(ops...))
}

// VCVTTPD2DQ: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQ m512 k ymm
//	VCVTTPD2DQ m512 ymm
//	VCVTTPD2DQ zmm  k ymm
//	VCVTTPD2DQ zmm  ymm
//
// Construct and append a VCVTTPD2DQ instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ(ops ...operand.Op) { ctx.VCVTTPD2DQ(ops...) }

// VCVTTPD2DQX: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQX m128 xmm
//	VCVTTPD2DQX xmm  xmm
//	VCVTTPD2DQX m128 k xmm
//	VCVTTPD2DQX xmm  k xmm
//
// Construct and append a VCVTTPD2DQX instruction to the active function.
func (c *Context) VCVTTPD2DQX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQX(ops...))
}

// VCVTTPD2DQX: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQX m128 xmm
//	VCVTTPD2DQX xmm  xmm
//	VCVTTPD2DQX m128 k xmm
//	VCVTTPD2DQX xmm  k xmm
//
// Construct and append a VCVTTPD2DQX instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQX(ops ...operand.Op) { ctx.VCVTTPD2DQX(ops...) }

// VCVTTPD2DQX_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQX.BCST m64 k xmm
//	VCVTTPD2DQX.BCST m64 xmm
//
// Construct and append a VCVTTPD2DQX.BCST instruction to the active function.
func (c *Context) VCVTTPD2DQX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQX_BCST(ops...))
}

// VCVTTPD2DQX_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQX.BCST m64 k xmm
//	VCVTTPD2DQX.BCST m64 xmm
//
// Construct and append a VCVTTPD2DQX.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQX_BCST(ops ...operand.Op) { ctx.VCVTTPD2DQX_BCST(ops...) }

// VCVTTPD2DQX_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2DQX.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2DQX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQX_BCST_Z(m, k, x))
}

// VCVTTPD2DQX_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2DQX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQX_BCST_Z(m, k, x operand.Op) { ctx.VCVTTPD2DQX_BCST_Z(m, k, x) }

// VCVTTPD2DQX_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.Z m128 k xmm
//	VCVTTPD2DQX.Z xmm  k xmm
//
// Construct and append a VCVTTPD2DQX.Z instruction to the active function.
func (c *Context) VCVTTPD2DQX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQX_Z(mx, k, x))
}

// VCVTTPD2DQX_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQX.Z m128 k xmm
//	VCVTTPD2DQX.Z xmm  k xmm
//
// Construct and append a VCVTTPD2DQX.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQX_Z(mx, k, x operand.Op) { ctx.VCVTTPD2DQX_Z(mx, k, x) }

// VCVTTPD2DQY: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQY m256 xmm
//	VCVTTPD2DQY ymm  xmm
//	VCVTTPD2DQY m256 k xmm
//	VCVTTPD2DQY ymm  k xmm
//
// Construct and append a VCVTTPD2DQY instruction to the active function.
func (c *Context) VCVTTPD2DQY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQY(ops...))
}

// VCVTTPD2DQY: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPD2DQY m256 xmm
//	VCVTTPD2DQY ymm  xmm
//	VCVTTPD2DQY m256 k xmm
//	VCVTTPD2DQY ymm  k xmm
//
// Construct and append a VCVTTPD2DQY instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQY(ops ...operand.Op) { ctx.VCVTTPD2DQY(ops...) }

// VCVTTPD2DQY_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQY.BCST m64 k xmm
//	VCVTTPD2DQY.BCST m64 xmm
//
// Construct and append a VCVTTPD2DQY.BCST instruction to the active function.
func (c *Context) VCVTTPD2DQY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQY_BCST(ops...))
}

// VCVTTPD2DQY_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQY.BCST m64 k xmm
//	VCVTTPD2DQY.BCST m64 xmm
//
// Construct and append a VCVTTPD2DQY.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQY_BCST(ops ...operand.Op) { ctx.VCVTTPD2DQY_BCST(ops...) }

// VCVTTPD2DQY_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2DQY.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2DQY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQY_BCST_Z(m, k, x))
}

// VCVTTPD2DQY_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2DQY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQY_BCST_Z(m, k, x operand.Op) { ctx.VCVTTPD2DQY_BCST_Z(m, k, x) }

// VCVTTPD2DQY_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.Z m256 k xmm
//	VCVTTPD2DQY.Z ymm  k xmm
//
// Construct and append a VCVTTPD2DQY.Z instruction to the active function.
func (c *Context) VCVTTPD2DQY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQY_Z(my, k, x))
}

// VCVTTPD2DQY_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQY.Z m256 k xmm
//	VCVTTPD2DQY.Z ymm  k xmm
//
// Construct and append a VCVTTPD2DQY.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQY_Z(my, k, x operand.Op) { ctx.VCVTTPD2DQY_Z(my, k, x) }

// VCVTTPD2DQ_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQ.BCST m64 k ymm
//	VCVTTPD2DQ.BCST m64 ymm
//
// Construct and append a VCVTTPD2DQ.BCST instruction to the active function.
func (c *Context) VCVTTPD2DQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ_BCST(ops...))
}

// VCVTTPD2DQ_BCST: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2DQ.BCST m64 k ymm
//	VCVTTPD2DQ.BCST m64 ymm
//
// Construct and append a VCVTTPD2DQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ_BCST(ops ...operand.Op) { ctx.VCVTTPD2DQ_BCST(ops...) }

// VCVTTPD2DQ_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTTPD2DQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2DQ_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ_BCST_Z(m, k, y))
}

// VCVTTPD2DQ_BCST_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTTPD2DQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ_BCST_Z(m, k, y operand.Op) { ctx.VCVTTPD2DQ_BCST_Z(m, k, y) }

// VCVTTPD2DQ_SAE: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2DQ.SAE zmm k ymm
//	VCVTTPD2DQ.SAE zmm ymm
//
// Construct and append a VCVTTPD2DQ.SAE instruction to the active function.
func (c *Context) VCVTTPD2DQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ_SAE(ops...))
}

// VCVTTPD2DQ_SAE: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2DQ.SAE zmm k ymm
//	VCVTTPD2DQ.SAE zmm ymm
//
// Construct and append a VCVTTPD2DQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ_SAE(ops ...operand.Op) { ctx.VCVTTPD2DQ_SAE(ops...) }

// VCVTTPD2DQ_SAE_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.SAE.Z zmm k ymm
//
// Construct and append a VCVTTPD2DQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPD2DQ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ_SAE_Z(z, k, y))
}

// VCVTTPD2DQ_SAE_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.SAE.Z zmm k ymm
//
// Construct and append a VCVTTPD2DQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ_SAE_Z(z, k, y operand.Op) { ctx.VCVTTPD2DQ_SAE_Z(z, k, y) }

// VCVTTPD2DQ_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.Z m512 k ymm
//	VCVTTPD2DQ.Z zmm  k ymm
//
// Construct and append a VCVTTPD2DQ.Z instruction to the active function.
func (c *Context) VCVTTPD2DQ_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2DQ_Z(mz, k, y))
}

// VCVTTPD2DQ_Z: Convert with Truncation Packed Double-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2DQ.Z m512 k ymm
//	VCVTTPD2DQ.Z zmm  k ymm
//
// Construct and append a VCVTTPD2DQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2DQ_Z(mz, k, y operand.Op) { ctx.VCVTTPD2DQ_Z(mz, k, y) }

// VCVTTPD2QQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTTPD2QQ m128 k xmm
//	VCVTTPD2QQ m128 xmm
//	VCVTTPD2QQ m256 k ymm
//	VCVTTPD2QQ m256 ymm
//	VCVTTPD2QQ xmm  k xmm
//	VCVTTPD2QQ xmm  xmm
//	VCVTTPD2QQ ymm  k ymm
//	VCVTTPD2QQ ymm  ymm
//	VCVTTPD2QQ m512 k zmm
//	VCVTTPD2QQ m512 zmm
//	VCVTTPD2QQ zmm  k zmm
//	VCVTTPD2QQ zmm  zmm
//
// Construct and append a VCVTTPD2QQ instruction to the active function.
func (c *Context) VCVTTPD2QQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ(ops...))
}

// VCVTTPD2QQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers.
//
// Forms:
//
//	VCVTTPD2QQ m128 k xmm
//	VCVTTPD2QQ m128 xmm
//	VCVTTPD2QQ m256 k ymm
//	VCVTTPD2QQ m256 ymm
//	VCVTTPD2QQ xmm  k xmm
//	VCVTTPD2QQ xmm  xmm
//	VCVTTPD2QQ ymm  k ymm
//	VCVTTPD2QQ ymm  ymm
//	VCVTTPD2QQ m512 k zmm
//	VCVTTPD2QQ m512 zmm
//	VCVTTPD2QQ zmm  k zmm
//	VCVTTPD2QQ zmm  zmm
//
// Construct and append a VCVTTPD2QQ instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ(ops ...operand.Op) { ctx.VCVTTPD2QQ(ops...) }

// VCVTTPD2QQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2QQ.BCST m64 k xmm
//	VCVTTPD2QQ.BCST m64 k ymm
//	VCVTTPD2QQ.BCST m64 xmm
//	VCVTTPD2QQ.BCST m64 ymm
//	VCVTTPD2QQ.BCST m64 k zmm
//	VCVTTPD2QQ.BCST m64 zmm
//
// Construct and append a VCVTTPD2QQ.BCST instruction to the active function.
func (c *Context) VCVTTPD2QQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ_BCST(ops...))
}

// VCVTTPD2QQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2QQ.BCST m64 k xmm
//	VCVTTPD2QQ.BCST m64 k ymm
//	VCVTTPD2QQ.BCST m64 xmm
//	VCVTTPD2QQ.BCST m64 ymm
//	VCVTTPD2QQ.BCST m64 k zmm
//	VCVTTPD2QQ.BCST m64 zmm
//
// Construct and append a VCVTTPD2QQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ_BCST(ops ...operand.Op) { ctx.VCVTTPD2QQ_BCST(ops...) }

// VCVTTPD2QQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.BCST.Z m64 k xmm
//	VCVTTPD2QQ.BCST.Z m64 k ymm
//	VCVTTPD2QQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTTPD2QQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2QQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ_BCST_Z(m, k, xyz))
}

// VCVTTPD2QQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.BCST.Z m64 k xmm
//	VCVTTPD2QQ.BCST.Z m64 k ymm
//	VCVTTPD2QQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTTPD2QQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPD2QQ_BCST_Z(m, k, xyz) }

// VCVTTPD2QQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2QQ.SAE zmm k zmm
//	VCVTTPD2QQ.SAE zmm zmm
//
// Construct and append a VCVTTPD2QQ.SAE instruction to the active function.
func (c *Context) VCVTTPD2QQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ_SAE(ops...))
}

// VCVTTPD2QQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2QQ.SAE zmm k zmm
//	VCVTTPD2QQ.SAE zmm zmm
//
// Construct and append a VCVTTPD2QQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ_SAE(ops ...operand.Op) { ctx.VCVTTPD2QQ_SAE(ops...) }

// VCVTTPD2QQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPD2QQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPD2QQ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ_SAE_Z(z, k, z1))
}

// VCVTTPD2QQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPD2QQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTTPD2QQ_SAE_Z(z, k, z1) }

// VCVTTPD2QQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.Z m128 k xmm
//	VCVTTPD2QQ.Z m256 k ymm
//	VCVTTPD2QQ.Z xmm  k xmm
//	VCVTTPD2QQ.Z ymm  k ymm
//	VCVTTPD2QQ.Z m512 k zmm
//	VCVTTPD2QQ.Z zmm  k zmm
//
// Construct and append a VCVTTPD2QQ.Z instruction to the active function.
func (c *Context) VCVTTPD2QQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPD2QQ_Z(mxyz, k, xyz))
}

// VCVTTPD2QQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2QQ.Z m128 k xmm
//	VCVTTPD2QQ.Z m256 k ymm
//	VCVTTPD2QQ.Z xmm  k xmm
//	VCVTTPD2QQ.Z ymm  k ymm
//	VCVTTPD2QQ.Z m512 k zmm
//	VCVTTPD2QQ.Z zmm  k zmm
//
// Construct and append a VCVTTPD2QQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2QQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTTPD2QQ_Z(mxyz, k, xyz) }

// VCVTTPD2UDQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQ m512 k ymm
//	VCVTTPD2UDQ m512 ymm
//	VCVTTPD2UDQ zmm  k ymm
//	VCVTTPD2UDQ zmm  ymm
//
// Construct and append a VCVTTPD2UDQ instruction to the active function.
func (c *Context) VCVTTPD2UDQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ(ops...))
}

// VCVTTPD2UDQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQ m512 k ymm
//	VCVTTPD2UDQ m512 ymm
//	VCVTTPD2UDQ zmm  k ymm
//	VCVTTPD2UDQ zmm  ymm
//
// Construct and append a VCVTTPD2UDQ instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ(ops ...operand.Op) { ctx.VCVTTPD2UDQ(ops...) }

// VCVTTPD2UDQX: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQX m128 k xmm
//	VCVTTPD2UDQX m128 xmm
//	VCVTTPD2UDQX xmm  k xmm
//	VCVTTPD2UDQX xmm  xmm
//
// Construct and append a VCVTTPD2UDQX instruction to the active function.
func (c *Context) VCVTTPD2UDQX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQX(ops...))
}

// VCVTTPD2UDQX: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQX m128 k xmm
//	VCVTTPD2UDQX m128 xmm
//	VCVTTPD2UDQX xmm  k xmm
//	VCVTTPD2UDQX xmm  xmm
//
// Construct and append a VCVTTPD2UDQX instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQX(ops ...operand.Op) { ctx.VCVTTPD2UDQX(ops...) }

// VCVTTPD2UDQX_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST m64 k xmm
//	VCVTTPD2UDQX.BCST m64 xmm
//
// Construct and append a VCVTTPD2UDQX.BCST instruction to the active function.
func (c *Context) VCVTTPD2UDQX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQX_BCST(ops...))
}

// VCVTTPD2UDQX_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST m64 k xmm
//	VCVTTPD2UDQX.BCST m64 xmm
//
// Construct and append a VCVTTPD2UDQX.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQX_BCST(ops ...operand.Op) { ctx.VCVTTPD2UDQX_BCST(ops...) }

// VCVTTPD2UDQX_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2UDQX.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQX_BCST_Z(m, k, x))
}

// VCVTTPD2UDQX_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2UDQX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQX_BCST_Z(m, k, x operand.Op) { ctx.VCVTTPD2UDQX_BCST_Z(m, k, x) }

// VCVTTPD2UDQX_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.Z m128 k xmm
//	VCVTTPD2UDQX.Z xmm  k xmm
//
// Construct and append a VCVTTPD2UDQX.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQX_Z(mx, k, x))
}

// VCVTTPD2UDQX_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQX.Z m128 k xmm
//	VCVTTPD2UDQX.Z xmm  k xmm
//
// Construct and append a VCVTTPD2UDQX.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQX_Z(mx, k, x operand.Op) { ctx.VCVTTPD2UDQX_Z(mx, k, x) }

// VCVTTPD2UDQY: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQY m256 k xmm
//	VCVTTPD2UDQY m256 xmm
//	VCVTTPD2UDQY ymm  k xmm
//	VCVTTPD2UDQY ymm  xmm
//
// Construct and append a VCVTTPD2UDQY instruction to the active function.
func (c *Context) VCVTTPD2UDQY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQY(ops...))
}

// VCVTTPD2UDQY: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers.
//
// Forms:
//
//	VCVTTPD2UDQY m256 k xmm
//	VCVTTPD2UDQY m256 xmm
//	VCVTTPD2UDQY ymm  k xmm
//	VCVTTPD2UDQY ymm  xmm
//
// Construct and append a VCVTTPD2UDQY instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQY(ops ...operand.Op) { ctx.VCVTTPD2UDQY(ops...) }

// VCVTTPD2UDQY_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST m64 k xmm
//	VCVTTPD2UDQY.BCST m64 xmm
//
// Construct and append a VCVTTPD2UDQY.BCST instruction to the active function.
func (c *Context) VCVTTPD2UDQY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQY_BCST(ops...))
}

// VCVTTPD2UDQY_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST m64 k xmm
//	VCVTTPD2UDQY.BCST m64 xmm
//
// Construct and append a VCVTTPD2UDQY.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQY_BCST(ops ...operand.Op) { ctx.VCVTTPD2UDQY_BCST(ops...) }

// VCVTTPD2UDQY_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2UDQY.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQY_BCST_Z(m, k, x))
}

// VCVTTPD2UDQY_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.BCST.Z m64 k xmm
//
// Construct and append a VCVTTPD2UDQY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQY_BCST_Z(m, k, x operand.Op) { ctx.VCVTTPD2UDQY_BCST_Z(m, k, x) }

// VCVTTPD2UDQY_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.Z m256 k xmm
//	VCVTTPD2UDQY.Z ymm  k xmm
//
// Construct and append a VCVTTPD2UDQY.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQY_Z(my, k, x))
}

// VCVTTPD2UDQY_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQY.Z m256 k xmm
//	VCVTTPD2UDQY.Z ymm  k xmm
//
// Construct and append a VCVTTPD2UDQY.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQY_Z(my, k, x operand.Op) { ctx.VCVTTPD2UDQY_Z(my, k, x) }

// VCVTTPD2UDQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST m64 k ymm
//	VCVTTPD2UDQ.BCST m64 ymm
//
// Construct and append a VCVTTPD2UDQ.BCST instruction to the active function.
func (c *Context) VCVTTPD2UDQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ_BCST(ops...))
}

// VCVTTPD2UDQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST m64 k ymm
//	VCVTTPD2UDQ.BCST m64 ymm
//
// Construct and append a VCVTTPD2UDQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ_BCST(ops ...operand.Op) { ctx.VCVTTPD2UDQ_BCST(ops...) }

// VCVTTPD2UDQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTTPD2UDQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQ_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ_BCST_Z(m, k, y))
}

// VCVTTPD2UDQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.BCST.Z m64 k ymm
//
// Construct and append a VCVTTPD2UDQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ_BCST_Z(m, k, y operand.Op) { ctx.VCVTTPD2UDQ_BCST_Z(m, k, y) }

// VCVTTPD2UDQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE zmm k ymm
//	VCVTTPD2UDQ.SAE zmm ymm
//
// Construct and append a VCVTTPD2UDQ.SAE instruction to the active function.
func (c *Context) VCVTTPD2UDQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ_SAE(ops...))
}

// VCVTTPD2UDQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE zmm k ymm
//	VCVTTPD2UDQ.SAE zmm ymm
//
// Construct and append a VCVTTPD2UDQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ_SAE(ops ...operand.Op) { ctx.VCVTTPD2UDQ_SAE(ops...) }

// VCVTTPD2UDQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE.Z zmm k ymm
//
// Construct and append a VCVTTPD2UDQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ_SAE_Z(z, k, y))
}

// VCVTTPD2UDQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.SAE.Z zmm k ymm
//
// Construct and append a VCVTTPD2UDQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ_SAE_Z(z, k, y operand.Op) { ctx.VCVTTPD2UDQ_SAE_Z(z, k, y) }

// VCVTTPD2UDQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.Z m512 k ymm
//	VCVTTPD2UDQ.Z zmm  k ymm
//
// Construct and append a VCVTTPD2UDQ.Z instruction to the active function.
func (c *Context) VCVTTPD2UDQ_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTTPD2UDQ_Z(mz, k, y))
}

// VCVTTPD2UDQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Doubleword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UDQ.Z m512 k ymm
//	VCVTTPD2UDQ.Z zmm  k ymm
//
// Construct and append a VCVTTPD2UDQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UDQ_Z(mz, k, y operand.Op) { ctx.VCVTTPD2UDQ_Z(mz, k, y) }

// VCVTTPD2UQQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTTPD2UQQ m128 k xmm
//	VCVTTPD2UQQ m128 xmm
//	VCVTTPD2UQQ m256 k ymm
//	VCVTTPD2UQQ m256 ymm
//	VCVTTPD2UQQ xmm  k xmm
//	VCVTTPD2UQQ xmm  xmm
//	VCVTTPD2UQQ ymm  k ymm
//	VCVTTPD2UQQ ymm  ymm
//	VCVTTPD2UQQ m512 k zmm
//	VCVTTPD2UQQ m512 zmm
//	VCVTTPD2UQQ zmm  k zmm
//	VCVTTPD2UQQ zmm  zmm
//
// Construct and append a VCVTTPD2UQQ instruction to the active function.
func (c *Context) VCVTTPD2UQQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ(ops...))
}

// VCVTTPD2UQQ: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers.
//
// Forms:
//
//	VCVTTPD2UQQ m128 k xmm
//	VCVTTPD2UQQ m128 xmm
//	VCVTTPD2UQQ m256 k ymm
//	VCVTTPD2UQQ m256 ymm
//	VCVTTPD2UQQ xmm  k xmm
//	VCVTTPD2UQQ xmm  xmm
//	VCVTTPD2UQQ ymm  k ymm
//	VCVTTPD2UQQ ymm  ymm
//	VCVTTPD2UQQ m512 k zmm
//	VCVTTPD2UQQ m512 zmm
//	VCVTTPD2UQQ zmm  k zmm
//	VCVTTPD2UQQ zmm  zmm
//
// Construct and append a VCVTTPD2UQQ instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ(ops ...operand.Op) { ctx.VCVTTPD2UQQ(ops...) }

// VCVTTPD2UQQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST m64 k xmm
//	VCVTTPD2UQQ.BCST m64 k ymm
//	VCVTTPD2UQQ.BCST m64 xmm
//	VCVTTPD2UQQ.BCST m64 ymm
//	VCVTTPD2UQQ.BCST m64 k zmm
//	VCVTTPD2UQQ.BCST m64 zmm
//
// Construct and append a VCVTTPD2UQQ.BCST instruction to the active function.
func (c *Context) VCVTTPD2UQQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ_BCST(ops...))
}

// VCVTTPD2UQQ_BCST: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST m64 k xmm
//	VCVTTPD2UQQ.BCST m64 k ymm
//	VCVTTPD2UQQ.BCST m64 xmm
//	VCVTTPD2UQQ.BCST m64 ymm
//	VCVTTPD2UQQ.BCST m64 k zmm
//	VCVTTPD2UQQ.BCST m64 zmm
//
// Construct and append a VCVTTPD2UQQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ_BCST(ops ...operand.Op) { ctx.VCVTTPD2UQQ_BCST(ops...) }

// VCVTTPD2UQQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST.Z m64 k xmm
//	VCVTTPD2UQQ.BCST.Z m64 k ymm
//	VCVTTPD2UQQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTTPD2UQQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPD2UQQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ_BCST_Z(m, k, xyz))
}

// VCVTTPD2UQQ_BCST_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.BCST.Z m64 k xmm
//	VCVTTPD2UQQ.BCST.Z m64 k ymm
//	VCVTTPD2UQQ.BCST.Z m64 k zmm
//
// Construct and append a VCVTTPD2UQQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPD2UQQ_BCST_Z(m, k, xyz) }

// VCVTTPD2UQQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE zmm k zmm
//	VCVTTPD2UQQ.SAE zmm zmm
//
// Construct and append a VCVTTPD2UQQ.SAE instruction to the active function.
func (c *Context) VCVTTPD2UQQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ_SAE(ops...))
}

// VCVTTPD2UQQ_SAE: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE zmm k zmm
//	VCVTTPD2UQQ.SAE zmm zmm
//
// Construct and append a VCVTTPD2UQQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ_SAE(ops ...operand.Op) { ctx.VCVTTPD2UQQ_SAE(ops...) }

// VCVTTPD2UQQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPD2UQQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPD2UQQ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ_SAE_Z(z, k, z1))
}

// VCVTTPD2UQQ_SAE_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPD2UQQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTTPD2UQQ_SAE_Z(z, k, z1) }

// VCVTTPD2UQQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.Z m128 k xmm
//	VCVTTPD2UQQ.Z m256 k ymm
//	VCVTTPD2UQQ.Z xmm  k xmm
//	VCVTTPD2UQQ.Z ymm  k ymm
//	VCVTTPD2UQQ.Z m512 k zmm
//	VCVTTPD2UQQ.Z zmm  k zmm
//
// Construct and append a VCVTTPD2UQQ.Z instruction to the active function.
func (c *Context) VCVTTPD2UQQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPD2UQQ_Z(mxyz, k, xyz))
}

// VCVTTPD2UQQ_Z: Convert with Truncation Packed Double-Precision Floating-Point Values to Packed Unsigned Quadword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPD2UQQ.Z m128 k xmm
//	VCVTTPD2UQQ.Z m256 k ymm
//	VCVTTPD2UQQ.Z xmm  k xmm
//	VCVTTPD2UQQ.Z ymm  k ymm
//	VCVTTPD2UQQ.Z m512 k zmm
//	VCVTTPD2UQQ.Z zmm  k zmm
//
// Construct and append a VCVTTPD2UQQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPD2UQQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTTPD2UQQ_Z(mxyz, k, xyz) }

// VCVTTPS2DQ: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPS2DQ m128 xmm
//	VCVTTPS2DQ m256 ymm
//	VCVTTPS2DQ xmm  xmm
//	VCVTTPS2DQ ymm  ymm
//	VCVTTPS2DQ m128 k xmm
//	VCVTTPS2DQ m256 k ymm
//	VCVTTPS2DQ xmm  k xmm
//	VCVTTPS2DQ ymm  k ymm
//	VCVTTPS2DQ m512 k zmm
//	VCVTTPS2DQ m512 zmm
//	VCVTTPS2DQ zmm  k zmm
//	VCVTTPS2DQ zmm  zmm
//
// Construct and append a VCVTTPS2DQ instruction to the active function.
func (c *Context) VCVTTPS2DQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ(ops...))
}

// VCVTTPS2DQ: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers.
//
// Forms:
//
//	VCVTTPS2DQ m128 xmm
//	VCVTTPS2DQ m256 ymm
//	VCVTTPS2DQ xmm  xmm
//	VCVTTPS2DQ ymm  ymm
//	VCVTTPS2DQ m128 k xmm
//	VCVTTPS2DQ m256 k ymm
//	VCVTTPS2DQ xmm  k xmm
//	VCVTTPS2DQ ymm  k ymm
//	VCVTTPS2DQ m512 k zmm
//	VCVTTPS2DQ m512 zmm
//	VCVTTPS2DQ zmm  k zmm
//	VCVTTPS2DQ zmm  zmm
//
// Construct and append a VCVTTPS2DQ instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ(ops ...operand.Op) { ctx.VCVTTPS2DQ(ops...) }

// VCVTTPS2DQ_BCST: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPS2DQ.BCST m32 k xmm
//	VCVTTPS2DQ.BCST m32 k ymm
//	VCVTTPS2DQ.BCST m32 xmm
//	VCVTTPS2DQ.BCST m32 ymm
//	VCVTTPS2DQ.BCST m32 k zmm
//	VCVTTPS2DQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2DQ.BCST instruction to the active function.
func (c *Context) VCVTTPS2DQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ_BCST(ops...))
}

// VCVTTPS2DQ_BCST: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast).
//
// Forms:
//
//	VCVTTPS2DQ.BCST m32 k xmm
//	VCVTTPS2DQ.BCST m32 k ymm
//	VCVTTPS2DQ.BCST m32 xmm
//	VCVTTPS2DQ.BCST m32 ymm
//	VCVTTPS2DQ.BCST m32 k zmm
//	VCVTTPS2DQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2DQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ_BCST(ops ...operand.Op) { ctx.VCVTTPS2DQ_BCST(ops...) }

// VCVTTPS2DQ_BCST_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.BCST.Z m32 k xmm
//	VCVTTPS2DQ.BCST.Z m32 k ymm
//	VCVTTPS2DQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2DQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPS2DQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ_BCST_Z(m, k, xyz))
}

// VCVTTPS2DQ_BCST_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.BCST.Z m32 k xmm
//	VCVTTPS2DQ.BCST.Z m32 k ymm
//	VCVTTPS2DQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2DQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPS2DQ_BCST_Z(m, k, xyz) }

// VCVTTPS2DQ_SAE: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2DQ.SAE zmm k zmm
//	VCVTTPS2DQ.SAE zmm zmm
//
// Construct and append a VCVTTPS2DQ.SAE instruction to the active function.
func (c *Context) VCVTTPS2DQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ_SAE(ops...))
}

// VCVTTPS2DQ_SAE: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2DQ.SAE zmm k zmm
//	VCVTTPS2DQ.SAE zmm zmm
//
// Construct and append a VCVTTPS2DQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ_SAE(ops ...operand.Op) { ctx.VCVTTPS2DQ_SAE(ops...) }

// VCVTTPS2DQ_SAE_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPS2DQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPS2DQ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ_SAE_Z(z, k, z1))
}

// VCVTTPS2DQ_SAE_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPS2DQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTTPS2DQ_SAE_Z(z, k, z1) }

// VCVTTPS2DQ_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.Z m128 k xmm
//	VCVTTPS2DQ.Z m256 k ymm
//	VCVTTPS2DQ.Z xmm  k xmm
//	VCVTTPS2DQ.Z ymm  k ymm
//	VCVTTPS2DQ.Z m512 k zmm
//	VCVTTPS2DQ.Z zmm  k zmm
//
// Construct and append a VCVTTPS2DQ.Z instruction to the active function.
func (c *Context) VCVTTPS2DQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2DQ_Z(mxyz, k, xyz))
}

// VCVTTPS2DQ_Z: Convert with Truncation Packed Single-Precision FP Values to Packed Dword Integers (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2DQ.Z m128 k xmm
//	VCVTTPS2DQ.Z m256 k ymm
//	VCVTTPS2DQ.Z xmm  k xmm
//	VCVTTPS2DQ.Z ymm  k ymm
//	VCVTTPS2DQ.Z m512 k zmm
//	VCVTTPS2DQ.Z zmm  k zmm
//
// Construct and append a VCVTTPS2DQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2DQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTTPS2DQ_Z(mxyz, k, xyz) }

// VCVTTPS2QQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2QQ m128 k ymm
//	VCVTTPS2QQ m128 ymm
//	VCVTTPS2QQ m64  k xmm
//	VCVTTPS2QQ m64  xmm
//	VCVTTPS2QQ xmm  k xmm
//	VCVTTPS2QQ xmm  k ymm
//	VCVTTPS2QQ xmm  xmm
//	VCVTTPS2QQ xmm  ymm
//	VCVTTPS2QQ m256 k zmm
//	VCVTTPS2QQ m256 zmm
//	VCVTTPS2QQ ymm  k zmm
//	VCVTTPS2QQ ymm  zmm
//
// Construct and append a VCVTTPS2QQ instruction to the active function.
func (c *Context) VCVTTPS2QQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ(ops...))
}

// VCVTTPS2QQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2QQ m128 k ymm
//	VCVTTPS2QQ m128 ymm
//	VCVTTPS2QQ m64  k xmm
//	VCVTTPS2QQ m64  xmm
//	VCVTTPS2QQ xmm  k xmm
//	VCVTTPS2QQ xmm  k ymm
//	VCVTTPS2QQ xmm  xmm
//	VCVTTPS2QQ xmm  ymm
//	VCVTTPS2QQ m256 k zmm
//	VCVTTPS2QQ m256 zmm
//	VCVTTPS2QQ ymm  k zmm
//	VCVTTPS2QQ ymm  zmm
//
// Construct and append a VCVTTPS2QQ instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ(ops ...operand.Op) { ctx.VCVTTPS2QQ(ops...) }

// VCVTTPS2QQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2QQ.BCST m32 k xmm
//	VCVTTPS2QQ.BCST m32 k ymm
//	VCVTTPS2QQ.BCST m32 xmm
//	VCVTTPS2QQ.BCST m32 ymm
//	VCVTTPS2QQ.BCST m32 k zmm
//	VCVTTPS2QQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2QQ.BCST instruction to the active function.
func (c *Context) VCVTTPS2QQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ_BCST(ops...))
}

// VCVTTPS2QQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2QQ.BCST m32 k xmm
//	VCVTTPS2QQ.BCST m32 k ymm
//	VCVTTPS2QQ.BCST m32 xmm
//	VCVTTPS2QQ.BCST m32 ymm
//	VCVTTPS2QQ.BCST m32 k zmm
//	VCVTTPS2QQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2QQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ_BCST(ops ...operand.Op) { ctx.VCVTTPS2QQ_BCST(ops...) }

// VCVTTPS2QQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.BCST.Z m32 k xmm
//	VCVTTPS2QQ.BCST.Z m32 k ymm
//	VCVTTPS2QQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2QQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPS2QQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ_BCST_Z(m, k, xyz))
}

// VCVTTPS2QQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.BCST.Z m32 k xmm
//	VCVTTPS2QQ.BCST.Z m32 k ymm
//	VCVTTPS2QQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2QQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPS2QQ_BCST_Z(m, k, xyz) }

// VCVTTPS2QQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2QQ.SAE ymm k zmm
//	VCVTTPS2QQ.SAE ymm zmm
//
// Construct and append a VCVTTPS2QQ.SAE instruction to the active function.
func (c *Context) VCVTTPS2QQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ_SAE(ops...))
}

// VCVTTPS2QQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2QQ.SAE ymm k zmm
//	VCVTTPS2QQ.SAE ymm zmm
//
// Construct and append a VCVTTPS2QQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ_SAE(ops ...operand.Op) { ctx.VCVTTPS2QQ_SAE(ops...) }

// VCVTTPS2QQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.SAE.Z ymm k zmm
//
// Construct and append a VCVTTPS2QQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPS2QQ_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ_SAE_Z(y, k, z))
}

// VCVTTPS2QQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.SAE.Z ymm k zmm
//
// Construct and append a VCVTTPS2QQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ_SAE_Z(y, k, z operand.Op) { ctx.VCVTTPS2QQ_SAE_Z(y, k, z) }

// VCVTTPS2QQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.Z m128 k ymm
//	VCVTTPS2QQ.Z m64  k xmm
//	VCVTTPS2QQ.Z xmm  k xmm
//	VCVTTPS2QQ.Z xmm  k ymm
//	VCVTTPS2QQ.Z m256 k zmm
//	VCVTTPS2QQ.Z ymm  k zmm
//
// Construct and append a VCVTTPS2QQ.Z instruction to the active function.
func (c *Context) VCVTTPS2QQ_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2QQ_Z(mxy, k, xyz))
}

// VCVTTPS2QQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Singed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2QQ.Z m128 k ymm
//	VCVTTPS2QQ.Z m64  k xmm
//	VCVTTPS2QQ.Z xmm  k xmm
//	VCVTTPS2QQ.Z xmm  k ymm
//	VCVTTPS2QQ.Z m256 k zmm
//	VCVTTPS2QQ.Z ymm  k zmm
//
// Construct and append a VCVTTPS2QQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2QQ_Z(mxy, k, xyz operand.Op) { ctx.VCVTTPS2QQ_Z(mxy, k, xyz) }

// VCVTTPS2UDQ: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTTPS2UDQ m128 k xmm
//	VCVTTPS2UDQ m128 xmm
//	VCVTTPS2UDQ m256 k ymm
//	VCVTTPS2UDQ m256 ymm
//	VCVTTPS2UDQ xmm  k xmm
//	VCVTTPS2UDQ xmm  xmm
//	VCVTTPS2UDQ ymm  k ymm
//	VCVTTPS2UDQ ymm  ymm
//	VCVTTPS2UDQ m512 k zmm
//	VCVTTPS2UDQ m512 zmm
//	VCVTTPS2UDQ zmm  k zmm
//	VCVTTPS2UDQ zmm  zmm
//
// Construct and append a VCVTTPS2UDQ instruction to the active function.
func (c *Context) VCVTTPS2UDQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ(ops...))
}

// VCVTTPS2UDQ: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values.
//
// Forms:
//
//	VCVTTPS2UDQ m128 k xmm
//	VCVTTPS2UDQ m128 xmm
//	VCVTTPS2UDQ m256 k ymm
//	VCVTTPS2UDQ m256 ymm
//	VCVTTPS2UDQ xmm  k xmm
//	VCVTTPS2UDQ xmm  xmm
//	VCVTTPS2UDQ ymm  k ymm
//	VCVTTPS2UDQ ymm  ymm
//	VCVTTPS2UDQ m512 k zmm
//	VCVTTPS2UDQ m512 zmm
//	VCVTTPS2UDQ zmm  k zmm
//	VCVTTPS2UDQ zmm  zmm
//
// Construct and append a VCVTTPS2UDQ instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ(ops ...operand.Op) { ctx.VCVTTPS2UDQ(ops...) }

// VCVTTPS2UDQ_BCST: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST m32 k xmm
//	VCVTTPS2UDQ.BCST m32 k ymm
//	VCVTTPS2UDQ.BCST m32 xmm
//	VCVTTPS2UDQ.BCST m32 ymm
//	VCVTTPS2UDQ.BCST m32 k zmm
//	VCVTTPS2UDQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2UDQ.BCST instruction to the active function.
func (c *Context) VCVTTPS2UDQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ_BCST(ops...))
}

// VCVTTPS2UDQ_BCST: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST m32 k xmm
//	VCVTTPS2UDQ.BCST m32 k ymm
//	VCVTTPS2UDQ.BCST m32 xmm
//	VCVTTPS2UDQ.BCST m32 ymm
//	VCVTTPS2UDQ.BCST m32 k zmm
//	VCVTTPS2UDQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2UDQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ_BCST(ops ...operand.Op) { ctx.VCVTTPS2UDQ_BCST(ops...) }

// VCVTTPS2UDQ_BCST_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST.Z m32 k xmm
//	VCVTTPS2UDQ.BCST.Z m32 k ymm
//	VCVTTPS2UDQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2UDQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPS2UDQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ_BCST_Z(m, k, xyz))
}

// VCVTTPS2UDQ_BCST_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.BCST.Z m32 k xmm
//	VCVTTPS2UDQ.BCST.Z m32 k ymm
//	VCVTTPS2UDQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2UDQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPS2UDQ_BCST_Z(m, k, xyz) }

// VCVTTPS2UDQ_SAE: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE zmm k zmm
//	VCVTTPS2UDQ.SAE zmm zmm
//
// Construct and append a VCVTTPS2UDQ.SAE instruction to the active function.
func (c *Context) VCVTTPS2UDQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ_SAE(ops...))
}

// VCVTTPS2UDQ_SAE: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE zmm k zmm
//	VCVTTPS2UDQ.SAE zmm zmm
//
// Construct and append a VCVTTPS2UDQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ_SAE(ops ...operand.Op) { ctx.VCVTTPS2UDQ_SAE(ops...) }

// VCVTTPS2UDQ_SAE_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPS2UDQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPS2UDQ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ_SAE_Z(z, k, z1))
}

// VCVTTPS2UDQ_SAE_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.SAE.Z zmm k zmm
//
// Construct and append a VCVTTPS2UDQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTTPS2UDQ_SAE_Z(z, k, z1) }

// VCVTTPS2UDQ_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.Z m128 k xmm
//	VCVTTPS2UDQ.Z m256 k ymm
//	VCVTTPS2UDQ.Z xmm  k xmm
//	VCVTTPS2UDQ.Z ymm  k ymm
//	VCVTTPS2UDQ.Z m512 k zmm
//	VCVTTPS2UDQ.Z zmm  k zmm
//
// Construct and append a VCVTTPS2UDQ.Z instruction to the active function.
func (c *Context) VCVTTPS2UDQ_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2UDQ_Z(mxyz, k, xyz))
}

// VCVTTPS2UDQ_Z: Convert with Truncation Packed Single-Precision Floating-Point Values to Packed Unsigned Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UDQ.Z m128 k xmm
//	VCVTTPS2UDQ.Z m256 k ymm
//	VCVTTPS2UDQ.Z xmm  k xmm
//	VCVTTPS2UDQ.Z ymm  k ymm
//	VCVTTPS2UDQ.Z m512 k zmm
//	VCVTTPS2UDQ.Z zmm  k zmm
//
// Construct and append a VCVTTPS2UDQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UDQ_Z(mxyz, k, xyz operand.Op) { ctx.VCVTTPS2UDQ_Z(mxyz, k, xyz) }

// VCVTTPS2UQQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2UQQ m128 k ymm
//	VCVTTPS2UQQ m128 ymm
//	VCVTTPS2UQQ m64  k xmm
//	VCVTTPS2UQQ m64  xmm
//	VCVTTPS2UQQ xmm  k xmm
//	VCVTTPS2UQQ xmm  k ymm
//	VCVTTPS2UQQ xmm  xmm
//	VCVTTPS2UQQ xmm  ymm
//	VCVTTPS2UQQ m256 k zmm
//	VCVTTPS2UQQ m256 zmm
//	VCVTTPS2UQQ ymm  k zmm
//	VCVTTPS2UQQ ymm  zmm
//
// Construct and append a VCVTTPS2UQQ instruction to the active function.
func (c *Context) VCVTTPS2UQQ(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ(ops...))
}

// VCVTTPS2UQQ: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values.
//
// Forms:
//
//	VCVTTPS2UQQ m128 k ymm
//	VCVTTPS2UQQ m128 ymm
//	VCVTTPS2UQQ m64  k xmm
//	VCVTTPS2UQQ m64  xmm
//	VCVTTPS2UQQ xmm  k xmm
//	VCVTTPS2UQQ xmm  k ymm
//	VCVTTPS2UQQ xmm  xmm
//	VCVTTPS2UQQ xmm  ymm
//	VCVTTPS2UQQ m256 k zmm
//	VCVTTPS2UQQ m256 zmm
//	VCVTTPS2UQQ ymm  k zmm
//	VCVTTPS2UQQ ymm  zmm
//
// Construct and append a VCVTTPS2UQQ instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ(ops ...operand.Op) { ctx.VCVTTPS2UQQ(ops...) }

// VCVTTPS2UQQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST m32 k xmm
//	VCVTTPS2UQQ.BCST m32 k ymm
//	VCVTTPS2UQQ.BCST m32 xmm
//	VCVTTPS2UQQ.BCST m32 ymm
//	VCVTTPS2UQQ.BCST m32 k zmm
//	VCVTTPS2UQQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2UQQ.BCST instruction to the active function.
func (c *Context) VCVTTPS2UQQ_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ_BCST(ops...))
}

// VCVTTPS2UQQ_BCST: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST m32 k xmm
//	VCVTTPS2UQQ.BCST m32 k ymm
//	VCVTTPS2UQQ.BCST m32 xmm
//	VCVTTPS2UQQ.BCST m32 ymm
//	VCVTTPS2UQQ.BCST m32 k zmm
//	VCVTTPS2UQQ.BCST m32 zmm
//
// Construct and append a VCVTTPS2UQQ.BCST instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ_BCST(ops ...operand.Op) { ctx.VCVTTPS2UQQ_BCST(ops...) }

// VCVTTPS2UQQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST.Z m32 k xmm
//	VCVTTPS2UQQ.BCST.Z m32 k ymm
//	VCVTTPS2UQQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2UQQ.BCST.Z instruction to the active function.
func (c *Context) VCVTTPS2UQQ_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ_BCST_Z(m, k, xyz))
}

// VCVTTPS2UQQ_BCST_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.BCST.Z m32 k xmm
//	VCVTTPS2UQQ.BCST.Z m32 k ymm
//	VCVTTPS2UQQ.BCST.Z m32 k zmm
//
// Construct and append a VCVTTPS2UQQ.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTTPS2UQQ_BCST_Z(m, k, xyz) }

// VCVTTPS2UQQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE ymm k zmm
//	VCVTTPS2UQQ.SAE ymm zmm
//
// Construct and append a VCVTTPS2UQQ.SAE instruction to the active function.
func (c *Context) VCVTTPS2UQQ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ_SAE(ops...))
}

// VCVTTPS2UQQ_SAE: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE ymm k zmm
//	VCVTTPS2UQQ.SAE ymm zmm
//
// Construct and append a VCVTTPS2UQQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ_SAE(ops ...operand.Op) { ctx.VCVTTPS2UQQ_SAE(ops...) }

// VCVTTPS2UQQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE.Z ymm k zmm
//
// Construct and append a VCVTTPS2UQQ.SAE.Z instruction to the active function.
func (c *Context) VCVTTPS2UQQ_SAE_Z(y, k, z operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ_SAE_Z(y, k, z))
}

// VCVTTPS2UQQ_SAE_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.SAE.Z ymm k zmm
//
// Construct and append a VCVTTPS2UQQ.SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ_SAE_Z(y, k, z operand.Op) { ctx.VCVTTPS2UQQ_SAE_Z(y, k, z) }

// VCVTTPS2UQQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.Z m128 k ymm
//	VCVTTPS2UQQ.Z m64  k xmm
//	VCVTTPS2UQQ.Z xmm  k xmm
//	VCVTTPS2UQQ.Z xmm  k ymm
//	VCVTTPS2UQQ.Z m256 k zmm
//	VCVTTPS2UQQ.Z ymm  k zmm
//
// Construct and append a VCVTTPS2UQQ.Z instruction to the active function.
func (c *Context) VCVTTPS2UQQ_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTTPS2UQQ_Z(mxy, k, xyz))
}

// VCVTTPS2UQQ_Z: Convert with Truncation Packed Single Precision Floating-Point Values to Packed Unsigned Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VCVTTPS2UQQ.Z m128 k ymm
//	VCVTTPS2UQQ.Z m64  k xmm
//	VCVTTPS2UQQ.Z xmm  k xmm
//	VCVTTPS2UQQ.Z xmm  k ymm
//	VCVTTPS2UQQ.Z m256 k zmm
//	VCVTTPS2UQQ.Z ymm  k zmm
//
// Construct and append a VCVTTPS2UQQ.Z instruction to the active function.
// Operates on the global context.
func VCVTTPS2UQQ_Z(mxy, k, xyz operand.Op) { ctx.VCVTTPS2UQQ_Z(mxy, k, xyz) }

// VCVTTSD2SI: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SI m64 r32
//	VCVTTSD2SI xmm r32
//
// Construct and append a VCVTTSD2SI instruction to the active function.
func (c *Context) VCVTTSD2SI(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2SI(mx, r))
}

// VCVTTSD2SI: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SI m64 r32
//	VCVTTSD2SI xmm r32
//
// Construct and append a VCVTTSD2SI instruction to the active function.
// Operates on the global context.
func VCVTTSD2SI(mx, r operand.Op) { ctx.VCVTTSD2SI(mx, r) }

// VCVTTSD2SIQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SIQ m64 r64
//	VCVTTSD2SIQ xmm r64
//
// Construct and append a VCVTTSD2SIQ instruction to the active function.
func (c *Context) VCVTTSD2SIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2SIQ(mx, r))
}

// VCVTTSD2SIQ: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer.
//
// Forms:
//
//	VCVTTSD2SIQ m64 r64
//	VCVTTSD2SIQ xmm r64
//
// Construct and append a VCVTTSD2SIQ instruction to the active function.
// Operates on the global context.
func VCVTTSD2SIQ(mx, r operand.Op) { ctx.VCVTTSD2SIQ(mx, r) }

// VCVTTSD2SIQ_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SIQ.SAE xmm r64
//
// Construct and append a VCVTTSD2SIQ.SAE instruction to the active function.
func (c *Context) VCVTTSD2SIQ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2SIQ_SAE(x, r))
}

// VCVTTSD2SIQ_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SIQ.SAE xmm r64
//
// Construct and append a VCVTTSD2SIQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSD2SIQ_SAE(x, r operand.Op) { ctx.VCVTTSD2SIQ_SAE(x, r) }

// VCVTTSD2SI_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SI.SAE xmm r32
//
// Construct and append a VCVTTSD2SI.SAE instruction to the active function.
func (c *Context) VCVTTSD2SI_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2SI_SAE(x, r))
}

// VCVTTSD2SI_SAE: Convert with Truncation Scalar Double-Precision FP Value to Signed Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2SI.SAE xmm r32
//
// Construct and append a VCVTTSD2SI.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSD2SI_SAE(x, r operand.Op) { ctx.VCVTTSD2SI_SAE(x, r) }

// VCVTTSD2USIL: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIL m64 r32
//	VCVTTSD2USIL xmm r32
//
// Construct and append a VCVTTSD2USIL instruction to the active function.
func (c *Context) VCVTTSD2USIL(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2USIL(mx, r))
}

// VCVTTSD2USIL: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIL m64 r32
//	VCVTTSD2USIL xmm r32
//
// Construct and append a VCVTTSD2USIL instruction to the active function.
// Operates on the global context.
func VCVTTSD2USIL(mx, r operand.Op) { ctx.VCVTTSD2USIL(mx, r) }

// VCVTTSD2USIL_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIL.SAE xmm r32
//
// Construct and append a VCVTTSD2USIL.SAE instruction to the active function.
func (c *Context) VCVTTSD2USIL_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2USIL_SAE(x, r))
}

// VCVTTSD2USIL_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIL.SAE xmm r32
//
// Construct and append a VCVTTSD2USIL.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSD2USIL_SAE(x, r operand.Op) { ctx.VCVTTSD2USIL_SAE(x, r) }

// VCVTTSD2USIQ: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIQ m64 r64
//	VCVTTSD2USIQ xmm r64
//
// Construct and append a VCVTTSD2USIQ instruction to the active function.
func (c *Context) VCVTTSD2USIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2USIQ(mx, r))
}

// VCVTTSD2USIQ: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSD2USIQ m64 r64
//	VCVTTSD2USIQ xmm r64
//
// Construct and append a VCVTTSD2USIQ instruction to the active function.
// Operates on the global context.
func VCVTTSD2USIQ(mx, r operand.Op) { ctx.VCVTTSD2USIQ(mx, r) }

// VCVTTSD2USIQ_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIQ.SAE xmm r64
//
// Construct and append a VCVTTSD2USIQ.SAE instruction to the active function.
func (c *Context) VCVTTSD2USIQ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSD2USIQ_SAE(x, r))
}

// VCVTTSD2USIQ_SAE: Convert with Truncation Scalar Double-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSD2USIQ.SAE xmm r64
//
// Construct and append a VCVTTSD2USIQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSD2USIQ_SAE(x, r operand.Op) { ctx.VCVTTSD2USIQ_SAE(x, r) }

// VCVTTSS2SI: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SI m32 r32
//	VCVTTSS2SI xmm r32
//
// Construct and append a VCVTTSS2SI instruction to the active function.
func (c *Context) VCVTTSS2SI(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2SI(mx, r))
}

// VCVTTSS2SI: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SI m32 r32
//	VCVTTSS2SI xmm r32
//
// Construct and append a VCVTTSS2SI instruction to the active function.
// Operates on the global context.
func VCVTTSS2SI(mx, r operand.Op) { ctx.VCVTTSS2SI(mx, r) }

// VCVTTSS2SIQ: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SIQ m32 r64
//	VCVTTSS2SIQ xmm r64
//
// Construct and append a VCVTTSS2SIQ instruction to the active function.
func (c *Context) VCVTTSS2SIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2SIQ(mx, r))
}

// VCVTTSS2SIQ: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer.
//
// Forms:
//
//	VCVTTSS2SIQ m32 r64
//	VCVTTSS2SIQ xmm r64
//
// Construct and append a VCVTTSS2SIQ instruction to the active function.
// Operates on the global context.
func VCVTTSS2SIQ(mx, r operand.Op) { ctx.VCVTTSS2SIQ(mx, r) }

// VCVTTSS2SIQ_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SIQ.SAE xmm r64
//
// Construct and append a VCVTTSS2SIQ.SAE instruction to the active function.
func (c *Context) VCVTTSS2SIQ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2SIQ_SAE(x, r))
}

// VCVTTSS2SIQ_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SIQ.SAE xmm r64
//
// Construct and append a VCVTTSS2SIQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSS2SIQ_SAE(x, r operand.Op) { ctx.VCVTTSS2SIQ_SAE(x, r) }

// VCVTTSS2SI_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SI.SAE xmm r32
//
// Construct and append a VCVTTSS2SI.SAE instruction to the active function.
func (c *Context) VCVTTSS2SI_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2SI_SAE(x, r))
}

// VCVTTSS2SI_SAE: Convert with Truncation Scalar Single-Precision FP Value to Dword Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2SI.SAE xmm r32
//
// Construct and append a VCVTTSS2SI.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSS2SI_SAE(x, r operand.Op) { ctx.VCVTTSS2SI_SAE(x, r) }

// VCVTTSS2USIL: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIL m32 r32
//	VCVTTSS2USIL xmm r32
//
// Construct and append a VCVTTSS2USIL instruction to the active function.
func (c *Context) VCVTTSS2USIL(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2USIL(mx, r))
}

// VCVTTSS2USIL: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIL m32 r32
//	VCVTTSS2USIL xmm r32
//
// Construct and append a VCVTTSS2USIL instruction to the active function.
// Operates on the global context.
func VCVTTSS2USIL(mx, r operand.Op) { ctx.VCVTTSS2USIL(mx, r) }

// VCVTTSS2USIL_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIL.SAE xmm r32
//
// Construct and append a VCVTTSS2USIL.SAE instruction to the active function.
func (c *Context) VCVTTSS2USIL_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2USIL_SAE(x, r))
}

// VCVTTSS2USIL_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIL.SAE xmm r32
//
// Construct and append a VCVTTSS2USIL.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSS2USIL_SAE(x, r operand.Op) { ctx.VCVTTSS2USIL_SAE(x, r) }

// VCVTTSS2USIQ: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIQ m32 r64
//	VCVTTSS2USIQ xmm r64
//
// Construct and append a VCVTTSS2USIQ instruction to the active function.
func (c *Context) VCVTTSS2USIQ(mx, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2USIQ(mx, r))
}

// VCVTTSS2USIQ: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer.
//
// Forms:
//
//	VCVTTSS2USIQ m32 r64
//	VCVTTSS2USIQ xmm r64
//
// Construct and append a VCVTTSS2USIQ instruction to the active function.
// Operates on the global context.
func VCVTTSS2USIQ(mx, r operand.Op) { ctx.VCVTTSS2USIQ(mx, r) }

// VCVTTSS2USIQ_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIQ.SAE xmm r64
//
// Construct and append a VCVTTSS2USIQ.SAE instruction to the active function.
func (c *Context) VCVTTSS2USIQ_SAE(x, r operand.Op) {
	c.addinstruction(x86.VCVTTSS2USIQ_SAE(x, r))
}

// VCVTTSS2USIQ_SAE: Convert with Truncation Scalar Single-Precision Floating-Point Value to Unsigned Integer (Suppress All Exceptions).
//
// Forms:
//
//	VCVTTSS2USIQ.SAE xmm r64
//
// Construct and append a VCVTTSS2USIQ.SAE instruction to the active function.
// Operates on the global context.
func VCVTTSS2USIQ_SAE(x, r operand.Op) { ctx.VCVTTSS2USIQ_SAE(x, r) }

// VCVTUDQ2PD: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PD m128 k ymm
//	VCVTUDQ2PD m128 ymm
//	VCVTUDQ2PD m64  k xmm
//	VCVTUDQ2PD m64  xmm
//	VCVTUDQ2PD xmm  k xmm
//	VCVTUDQ2PD xmm  k ymm
//	VCVTUDQ2PD xmm  xmm
//	VCVTUDQ2PD xmm  ymm
//	VCVTUDQ2PD m256 k zmm
//	VCVTUDQ2PD m256 zmm
//	VCVTUDQ2PD ymm  k zmm
//	VCVTUDQ2PD ymm  zmm
//
// Construct and append a VCVTUDQ2PD instruction to the active function.
func (c *Context) VCVTUDQ2PD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PD(ops...))
}

// VCVTUDQ2PD: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PD m128 k ymm
//	VCVTUDQ2PD m128 ymm
//	VCVTUDQ2PD m64  k xmm
//	VCVTUDQ2PD m64  xmm
//	VCVTUDQ2PD xmm  k xmm
//	VCVTUDQ2PD xmm  k ymm
//	VCVTUDQ2PD xmm  xmm
//	VCVTUDQ2PD xmm  ymm
//	VCVTUDQ2PD m256 k zmm
//	VCVTUDQ2PD m256 zmm
//	VCVTUDQ2PD ymm  k zmm
//	VCVTUDQ2PD ymm  zmm
//
// Construct and append a VCVTUDQ2PD instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PD(ops ...operand.Op) { ctx.VCVTUDQ2PD(ops...) }

// VCVTUDQ2PD_BCST: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PD.BCST m32 k xmm
//	VCVTUDQ2PD.BCST m32 k ymm
//	VCVTUDQ2PD.BCST m32 xmm
//	VCVTUDQ2PD.BCST m32 ymm
//	VCVTUDQ2PD.BCST m32 k zmm
//	VCVTUDQ2PD.BCST m32 zmm
//
// Construct and append a VCVTUDQ2PD.BCST instruction to the active function.
func (c *Context) VCVTUDQ2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PD_BCST(ops...))
}

// VCVTUDQ2PD_BCST: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PD.BCST m32 k xmm
//	VCVTUDQ2PD.BCST m32 k ymm
//	VCVTUDQ2PD.BCST m32 xmm
//	VCVTUDQ2PD.BCST m32 ymm
//	VCVTUDQ2PD.BCST m32 k zmm
//	VCVTUDQ2PD.BCST m32 zmm
//
// Construct and append a VCVTUDQ2PD.BCST instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PD_BCST(ops ...operand.Op) { ctx.VCVTUDQ2PD_BCST(ops...) }

// VCVTUDQ2PD_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.BCST.Z m32 k xmm
//	VCVTUDQ2PD.BCST.Z m32 k ymm
//	VCVTUDQ2PD.BCST.Z m32 k zmm
//
// Construct and append a VCVTUDQ2PD.BCST.Z instruction to the active function.
func (c *Context) VCVTUDQ2PD_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PD_BCST_Z(m, k, xyz))
}

// VCVTUDQ2PD_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.BCST.Z m32 k xmm
//	VCVTUDQ2PD.BCST.Z m32 k ymm
//	VCVTUDQ2PD.BCST.Z m32 k zmm
//
// Construct and append a VCVTUDQ2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PD_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTUDQ2PD_BCST_Z(m, k, xyz) }

// VCVTUDQ2PD_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.Z m128 k ymm
//	VCVTUDQ2PD.Z m64  k xmm
//	VCVTUDQ2PD.Z xmm  k xmm
//	VCVTUDQ2PD.Z xmm  k ymm
//	VCVTUDQ2PD.Z m256 k zmm
//	VCVTUDQ2PD.Z ymm  k zmm
//
// Construct and append a VCVTUDQ2PD.Z instruction to the active function.
func (c *Context) VCVTUDQ2PD_Z(mxy, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PD_Z(mxy, k, xyz))
}

// VCVTUDQ2PD_Z: Convert Packed Unsigned Doubleword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PD.Z m128 k ymm
//	VCVTUDQ2PD.Z m64  k xmm
//	VCVTUDQ2PD.Z xmm  k xmm
//	VCVTUDQ2PD.Z xmm  k ymm
//	VCVTUDQ2PD.Z m256 k zmm
//	VCVTUDQ2PD.Z ymm  k zmm
//
// Construct and append a VCVTUDQ2PD.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PD_Z(mxy, k, xyz operand.Op) { ctx.VCVTUDQ2PD_Z(mxy, k, xyz) }

// VCVTUDQ2PS: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PS m128 k xmm
//	VCVTUDQ2PS m128 xmm
//	VCVTUDQ2PS m256 k ymm
//	VCVTUDQ2PS m256 ymm
//	VCVTUDQ2PS xmm  k xmm
//	VCVTUDQ2PS xmm  xmm
//	VCVTUDQ2PS ymm  k ymm
//	VCVTUDQ2PS ymm  ymm
//	VCVTUDQ2PS m512 k zmm
//	VCVTUDQ2PS m512 zmm
//	VCVTUDQ2PS zmm  k zmm
//	VCVTUDQ2PS zmm  zmm
//
// Construct and append a VCVTUDQ2PS instruction to the active function.
func (c *Context) VCVTUDQ2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS(ops...))
}

// VCVTUDQ2PS: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUDQ2PS m128 k xmm
//	VCVTUDQ2PS m128 xmm
//	VCVTUDQ2PS m256 k ymm
//	VCVTUDQ2PS m256 ymm
//	VCVTUDQ2PS xmm  k xmm
//	VCVTUDQ2PS xmm  xmm
//	VCVTUDQ2PS ymm  k ymm
//	VCVTUDQ2PS ymm  ymm
//	VCVTUDQ2PS m512 k zmm
//	VCVTUDQ2PS m512 zmm
//	VCVTUDQ2PS zmm  k zmm
//	VCVTUDQ2PS zmm  zmm
//
// Construct and append a VCVTUDQ2PS instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS(ops ...operand.Op) { ctx.VCVTUDQ2PS(ops...) }

// VCVTUDQ2PS_BCST: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PS.BCST m32 k xmm
//	VCVTUDQ2PS.BCST m32 k ymm
//	VCVTUDQ2PS.BCST m32 xmm
//	VCVTUDQ2PS.BCST m32 ymm
//	VCVTUDQ2PS.BCST m32 k zmm
//	VCVTUDQ2PS.BCST m32 zmm
//
// Construct and append a VCVTUDQ2PS.BCST instruction to the active function.
func (c *Context) VCVTUDQ2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_BCST(ops...))
}

// VCVTUDQ2PS_BCST: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUDQ2PS.BCST m32 k xmm
//	VCVTUDQ2PS.BCST m32 k ymm
//	VCVTUDQ2PS.BCST m32 xmm
//	VCVTUDQ2PS.BCST m32 ymm
//	VCVTUDQ2PS.BCST m32 k zmm
//	VCVTUDQ2PS.BCST m32 zmm
//
// Construct and append a VCVTUDQ2PS.BCST instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_BCST(ops ...operand.Op) { ctx.VCVTUDQ2PS_BCST(ops...) }

// VCVTUDQ2PS_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.BCST.Z m32 k xmm
//	VCVTUDQ2PS.BCST.Z m32 k ymm
//	VCVTUDQ2PS.BCST.Z m32 k zmm
//
// Construct and append a VCVTUDQ2PS.BCST.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_BCST_Z(m, k, xyz))
}

// VCVTUDQ2PS_BCST_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.BCST.Z m32 k xmm
//	VCVTUDQ2PS.BCST.Z m32 k ymm
//	VCVTUDQ2PS.BCST.Z m32 k zmm
//
// Construct and append a VCVTUDQ2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTUDQ2PS_BCST_Z(m, k, xyz) }

// VCVTUDQ2PS_RD_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE zmm k zmm
//	VCVTUDQ2PS.RD_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RD_SAE instruction to the active function.
func (c *Context) VCVTUDQ2PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RD_SAE(ops...))
}

// VCVTUDQ2PS_RD_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE zmm k zmm
//	VCVTUDQ2PS.RD_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RD_SAE(ops ...operand.Op) { ctx.VCVTUDQ2PS_RD_SAE(ops...) }

// VCVTUDQ2PS_RD_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RD_SAE_Z(z, k, z1))
}

// VCVTUDQ2PS_RD_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUDQ2PS_RD_SAE_Z(z, k, z1) }

// VCVTUDQ2PS_RN_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE zmm k zmm
//	VCVTUDQ2PS.RN_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RN_SAE instruction to the active function.
func (c *Context) VCVTUDQ2PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RN_SAE(ops...))
}

// VCVTUDQ2PS_RN_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE zmm k zmm
//	VCVTUDQ2PS.RN_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RN_SAE(ops ...operand.Op) { ctx.VCVTUDQ2PS_RN_SAE(ops...) }

// VCVTUDQ2PS_RN_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RN_SAE_Z(z, k, z1))
}

// VCVTUDQ2PS_RN_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUDQ2PS_RN_SAE_Z(z, k, z1) }

// VCVTUDQ2PS_RU_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE zmm k zmm
//	VCVTUDQ2PS.RU_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RU_SAE instruction to the active function.
func (c *Context) VCVTUDQ2PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RU_SAE(ops...))
}

// VCVTUDQ2PS_RU_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE zmm k zmm
//	VCVTUDQ2PS.RU_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RU_SAE(ops ...operand.Op) { ctx.VCVTUDQ2PS_RU_SAE(ops...) }

// VCVTUDQ2PS_RU_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RU_SAE_Z(z, k, z1))
}

// VCVTUDQ2PS_RU_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUDQ2PS_RU_SAE_Z(z, k, z1) }

// VCVTUDQ2PS_RZ_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE zmm k zmm
//	VCVTUDQ2PS.RZ_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RZ_SAE instruction to the active function.
func (c *Context) VCVTUDQ2PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RZ_SAE(ops...))
}

// VCVTUDQ2PS_RZ_SAE: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE zmm k zmm
//	VCVTUDQ2PS.RZ_SAE zmm zmm
//
// Construct and append a VCVTUDQ2PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RZ_SAE(ops ...operand.Op) { ctx.VCVTUDQ2PS_RZ_SAE(ops...) }

// VCVTUDQ2PS_RZ_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_RZ_SAE_Z(z, k, z1))
}

// VCVTUDQ2PS_RZ_SAE_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTUDQ2PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUDQ2PS_RZ_SAE_Z(z, k, z1) }

// VCVTUDQ2PS_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.Z m128 k xmm
//	VCVTUDQ2PS.Z m256 k ymm
//	VCVTUDQ2PS.Z xmm  k xmm
//	VCVTUDQ2PS.Z ymm  k ymm
//	VCVTUDQ2PS.Z m512 k zmm
//	VCVTUDQ2PS.Z zmm  k zmm
//
// Construct and append a VCVTUDQ2PS.Z instruction to the active function.
func (c *Context) VCVTUDQ2PS_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUDQ2PS_Z(mxyz, k, xyz))
}

// VCVTUDQ2PS_Z: Convert Packed Unsigned Doubleword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUDQ2PS.Z m128 k xmm
//	VCVTUDQ2PS.Z m256 k ymm
//	VCVTUDQ2PS.Z xmm  k xmm
//	VCVTUDQ2PS.Z ymm  k ymm
//	VCVTUDQ2PS.Z m512 k zmm
//	VCVTUDQ2PS.Z zmm  k zmm
//
// Construct and append a VCVTUDQ2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTUDQ2PS_Z(mxyz, k, xyz operand.Op) { ctx.VCVTUDQ2PS_Z(mxyz, k, xyz) }

// VCVTUQQ2PD: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PD m128 k xmm
//	VCVTUQQ2PD m128 xmm
//	VCVTUQQ2PD m256 k ymm
//	VCVTUQQ2PD m256 ymm
//	VCVTUQQ2PD xmm  k xmm
//	VCVTUQQ2PD xmm  xmm
//	VCVTUQQ2PD ymm  k ymm
//	VCVTUQQ2PD ymm  ymm
//	VCVTUQQ2PD m512 k zmm
//	VCVTUQQ2PD m512 zmm
//	VCVTUQQ2PD zmm  k zmm
//	VCVTUQQ2PD zmm  zmm
//
// Construct and append a VCVTUQQ2PD instruction to the active function.
func (c *Context) VCVTUQQ2PD(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD(ops...))
}

// VCVTUQQ2PD: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PD m128 k xmm
//	VCVTUQQ2PD m128 xmm
//	VCVTUQQ2PD m256 k ymm
//	VCVTUQQ2PD m256 ymm
//	VCVTUQQ2PD xmm  k xmm
//	VCVTUQQ2PD xmm  xmm
//	VCVTUQQ2PD ymm  k ymm
//	VCVTUQQ2PD ymm  ymm
//	VCVTUQQ2PD m512 k zmm
//	VCVTUQQ2PD m512 zmm
//	VCVTUQQ2PD zmm  k zmm
//	VCVTUQQ2PD zmm  zmm
//
// Construct and append a VCVTUQQ2PD instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD(ops ...operand.Op) { ctx.VCVTUQQ2PD(ops...) }

// VCVTUQQ2PD_BCST: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PD.BCST m64 k xmm
//	VCVTUQQ2PD.BCST m64 k ymm
//	VCVTUQQ2PD.BCST m64 xmm
//	VCVTUQQ2PD.BCST m64 ymm
//	VCVTUQQ2PD.BCST m64 k zmm
//	VCVTUQQ2PD.BCST m64 zmm
//
// Construct and append a VCVTUQQ2PD.BCST instruction to the active function.
func (c *Context) VCVTUQQ2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_BCST(ops...))
}

// VCVTUQQ2PD_BCST: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PD.BCST m64 k xmm
//	VCVTUQQ2PD.BCST m64 k ymm
//	VCVTUQQ2PD.BCST m64 xmm
//	VCVTUQQ2PD.BCST m64 ymm
//	VCVTUQQ2PD.BCST m64 k zmm
//	VCVTUQQ2PD.BCST m64 zmm
//
// Construct and append a VCVTUQQ2PD.BCST instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_BCST(ops ...operand.Op) { ctx.VCVTUQQ2PD_BCST(ops...) }

// VCVTUQQ2PD_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.BCST.Z m64 k xmm
//	VCVTUQQ2PD.BCST.Z m64 k ymm
//	VCVTUQQ2PD.BCST.Z m64 k zmm
//
// Construct and append a VCVTUQQ2PD.BCST.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_BCST_Z(m, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_BCST_Z(m, k, xyz))
}

// VCVTUQQ2PD_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.BCST.Z m64 k xmm
//	VCVTUQQ2PD.BCST.Z m64 k ymm
//	VCVTUQQ2PD.BCST.Z m64 k zmm
//
// Construct and append a VCVTUQQ2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_BCST_Z(m, k, xyz operand.Op) { ctx.VCVTUQQ2PD_BCST_Z(m, k, xyz) }

// VCVTUQQ2PD_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE zmm k zmm
//	VCVTUQQ2PD.RD_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RD_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RD_SAE(ops...))
}

// VCVTUQQ2PD_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE zmm k zmm
//	VCVTUQQ2PD.RD_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RD_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PD_RD_SAE(ops...) }

// VCVTUQQ2PD_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RD_SAE_Z(z, k, z1))
}

// VCVTUQQ2PD_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RD_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RD_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUQQ2PD_RD_SAE_Z(z, k, z1) }

// VCVTUQQ2PD_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE zmm k zmm
//	VCVTUQQ2PD.RN_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RN_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RN_SAE(ops...))
}

// VCVTUQQ2PD_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE zmm k zmm
//	VCVTUQQ2PD.RN_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RN_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PD_RN_SAE(ops...) }

// VCVTUQQ2PD_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RN_SAE_Z(z, k, z1))
}

// VCVTUQQ2PD_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RN_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RN_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUQQ2PD_RN_SAE_Z(z, k, z1) }

// VCVTUQQ2PD_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE zmm k zmm
//	VCVTUQQ2PD.RU_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RU_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RU_SAE(ops...))
}

// VCVTUQQ2PD_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE zmm k zmm
//	VCVTUQQ2PD.RU_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RU_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PD_RU_SAE(ops...) }

// VCVTUQQ2PD_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RU_SAE_Z(z, k, z1))
}

// VCVTUQQ2PD_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RU_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RU_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUQQ2PD_RU_SAE_Z(z, k, z1) }

// VCVTUQQ2PD_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE zmm k zmm
//	VCVTUQQ2PD.RZ_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RZ_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RZ_SAE(ops...))
}

// VCVTUQQ2PD_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE zmm k zmm
//	VCVTUQQ2PD.RZ_SAE zmm zmm
//
// Construct and append a VCVTUQQ2PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RZ_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PD_RZ_SAE(ops...) }

// VCVTUQQ2PD_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_RZ_SAE_Z(z, k, z1))
}

// VCVTUQQ2PD_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.RZ_SAE.Z zmm k zmm
//
// Construct and append a VCVTUQQ2PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_RZ_SAE_Z(z, k, z1 operand.Op) { ctx.VCVTUQQ2PD_RZ_SAE_Z(z, k, z1) }

// VCVTUQQ2PD_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.Z m128 k xmm
//	VCVTUQQ2PD.Z m256 k ymm
//	VCVTUQQ2PD.Z xmm  k xmm
//	VCVTUQQ2PD.Z ymm  k ymm
//	VCVTUQQ2PD.Z m512 k zmm
//	VCVTUQQ2PD.Z zmm  k zmm
//
// Construct and append a VCVTUQQ2PD.Z instruction to the active function.
func (c *Context) VCVTUQQ2PD_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PD_Z(mxyz, k, xyz))
}

// VCVTUQQ2PD_Z: Convert Packed Unsigned Quadword Integers to Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PD.Z m128 k xmm
//	VCVTUQQ2PD.Z m256 k ymm
//	VCVTUQQ2PD.Z xmm  k xmm
//	VCVTUQQ2PD.Z ymm  k ymm
//	VCVTUQQ2PD.Z m512 k zmm
//	VCVTUQQ2PD.Z zmm  k zmm
//
// Construct and append a VCVTUQQ2PD.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PD_Z(mxyz, k, xyz operand.Op) { ctx.VCVTUQQ2PD_Z(mxyz, k, xyz) }

// VCVTUQQ2PS: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PS m512 k ymm
//	VCVTUQQ2PS m512 ymm
//	VCVTUQQ2PS zmm  k ymm
//	VCVTUQQ2PS zmm  ymm
//
// Construct and append a VCVTUQQ2PS instruction to the active function.
func (c *Context) VCVTUQQ2PS(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS(ops...))
}

// VCVTUQQ2PS: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PS m512 k ymm
//	VCVTUQQ2PS m512 ymm
//	VCVTUQQ2PS zmm  k ymm
//	VCVTUQQ2PS zmm  ymm
//
// Construct and append a VCVTUQQ2PS instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS(ops ...operand.Op) { ctx.VCVTUQQ2PS(ops...) }

// VCVTUQQ2PSX: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSX m128 k xmm
//	VCVTUQQ2PSX m128 xmm
//	VCVTUQQ2PSX xmm  k xmm
//	VCVTUQQ2PSX xmm  xmm
//
// Construct and append a VCVTUQQ2PSX instruction to the active function.
func (c *Context) VCVTUQQ2PSX(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSX(ops...))
}

// VCVTUQQ2PSX: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSX m128 k xmm
//	VCVTUQQ2PSX m128 xmm
//	VCVTUQQ2PSX xmm  k xmm
//	VCVTUQQ2PSX xmm  xmm
//
// Construct and append a VCVTUQQ2PSX instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSX(ops ...operand.Op) { ctx.VCVTUQQ2PSX(ops...) }

// VCVTUQQ2PSX_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST m64 k xmm
//	VCVTUQQ2PSX.BCST m64 xmm
//
// Construct and append a VCVTUQQ2PSX.BCST instruction to the active function.
func (c *Context) VCVTUQQ2PSX_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSX_BCST(ops...))
}

// VCVTUQQ2PSX_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST m64 k xmm
//	VCVTUQQ2PSX.BCST m64 xmm
//
// Construct and append a VCVTUQQ2PSX.BCST instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSX_BCST(ops ...operand.Op) { ctx.VCVTUQQ2PSX_BCST(ops...) }

// VCVTUQQ2PSX_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTUQQ2PSX.BCST.Z instruction to the active function.
func (c *Context) VCVTUQQ2PSX_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSX_BCST_Z(m, k, x))
}

// VCVTUQQ2PSX_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.BCST.Z m64 k xmm
//
// Construct and append a VCVTUQQ2PSX.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSX_BCST_Z(m, k, x operand.Op) { ctx.VCVTUQQ2PSX_BCST_Z(m, k, x) }

// VCVTUQQ2PSX_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.Z m128 k xmm
//	VCVTUQQ2PSX.Z xmm  k xmm
//
// Construct and append a VCVTUQQ2PSX.Z instruction to the active function.
func (c *Context) VCVTUQQ2PSX_Z(mx, k, x operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSX_Z(mx, k, x))
}

// VCVTUQQ2PSX_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSX.Z m128 k xmm
//	VCVTUQQ2PSX.Z xmm  k xmm
//
// Construct and append a VCVTUQQ2PSX.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSX_Z(mx, k, x operand.Op) { ctx.VCVTUQQ2PSX_Z(mx, k, x) }

// VCVTUQQ2PSY: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSY m256 k xmm
//	VCVTUQQ2PSY m256 xmm
//	VCVTUQQ2PSY ymm  k xmm
//	VCVTUQQ2PSY ymm  xmm
//
// Construct and append a VCVTUQQ2PSY instruction to the active function.
func (c *Context) VCVTUQQ2PSY(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSY(ops...))
}

// VCVTUQQ2PSY: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VCVTUQQ2PSY m256 k xmm
//	VCVTUQQ2PSY m256 xmm
//	VCVTUQQ2PSY ymm  k xmm
//	VCVTUQQ2PSY ymm  xmm
//
// Construct and append a VCVTUQQ2PSY instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSY(ops ...operand.Op) { ctx.VCVTUQQ2PSY(ops...) }

// VCVTUQQ2PSY_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST m64 k xmm
//	VCVTUQQ2PSY.BCST m64 xmm
//
// Construct and append a VCVTUQQ2PSY.BCST instruction to the active function.
func (c *Context) VCVTUQQ2PSY_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSY_BCST(ops...))
}

// VCVTUQQ2PSY_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST m64 k xmm
//	VCVTUQQ2PSY.BCST m64 xmm
//
// Construct and append a VCVTUQQ2PSY.BCST instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSY_BCST(ops ...operand.Op) { ctx.VCVTUQQ2PSY_BCST(ops...) }

// VCVTUQQ2PSY_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTUQQ2PSY.BCST.Z instruction to the active function.
func (c *Context) VCVTUQQ2PSY_BCST_Z(m, k, x operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSY_BCST_Z(m, k, x))
}

// VCVTUQQ2PSY_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.BCST.Z m64 k xmm
//
// Construct and append a VCVTUQQ2PSY.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSY_BCST_Z(m, k, x operand.Op) { ctx.VCVTUQQ2PSY_BCST_Z(m, k, x) }

// VCVTUQQ2PSY_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.Z m256 k xmm
//	VCVTUQQ2PSY.Z ymm  k xmm
//
// Construct and append a VCVTUQQ2PSY.Z instruction to the active function.
func (c *Context) VCVTUQQ2PSY_Z(my, k, x operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PSY_Z(my, k, x))
}

// VCVTUQQ2PSY_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PSY.Z m256 k xmm
//	VCVTUQQ2PSY.Z ymm  k xmm
//
// Construct and append a VCVTUQQ2PSY.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PSY_Z(my, k, x operand.Op) { ctx.VCVTUQQ2PSY_Z(my, k, x) }

// VCVTUQQ2PS_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PS.BCST m64 k ymm
//	VCVTUQQ2PS.BCST m64 ymm
//
// Construct and append a VCVTUQQ2PS.BCST instruction to the active function.
func (c *Context) VCVTUQQ2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_BCST(ops...))
}

// VCVTUQQ2PS_BCST: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VCVTUQQ2PS.BCST m64 k ymm
//	VCVTUQQ2PS.BCST m64 ymm
//
// Construct and append a VCVTUQQ2PS.BCST instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_BCST(ops ...operand.Op) { ctx.VCVTUQQ2PS_BCST(ops...) }

// VCVTUQQ2PS_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTUQQ2PS.BCST.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_BCST_Z(m, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_BCST_Z(m, k, y))
}

// VCVTUQQ2PS_BCST_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.BCST.Z m64 k ymm
//
// Construct and append a VCVTUQQ2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_BCST_Z(m, k, y operand.Op) { ctx.VCVTUQQ2PS_BCST_Z(m, k, y) }

// VCVTUQQ2PS_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE zmm k ymm
//	VCVTUQQ2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RD_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RD_SAE(ops...))
}

// VCVTUQQ2PS_RD_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE zmm k ymm
//	VCVTUQQ2PS.RD_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RD_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PS_RD_SAE(ops...) }

// VCVTUQQ2PS_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RD_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_RD_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RD_SAE_Z(z, k, y))
}

// VCVTUQQ2PS_RD_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RD_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RD_SAE_Z(z, k, y operand.Op) { ctx.VCVTUQQ2PS_RD_SAE_Z(z, k, y) }

// VCVTUQQ2PS_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE zmm k ymm
//	VCVTUQQ2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RN_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RN_SAE(ops...))
}

// VCVTUQQ2PS_RN_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE zmm k ymm
//	VCVTUQQ2PS.RN_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RN_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PS_RN_SAE(ops...) }

// VCVTUQQ2PS_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RN_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_RN_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RN_SAE_Z(z, k, y))
}

// VCVTUQQ2PS_RN_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RN_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RN_SAE_Z(z, k, y operand.Op) { ctx.VCVTUQQ2PS_RN_SAE_Z(z, k, y) }

// VCVTUQQ2PS_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE zmm k ymm
//	VCVTUQQ2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RU_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RU_SAE(ops...))
}

// VCVTUQQ2PS_RU_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE zmm k ymm
//	VCVTUQQ2PS.RU_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RU_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PS_RU_SAE(ops...) }

// VCVTUQQ2PS_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RU_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_RU_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RU_SAE_Z(z, k, y))
}

// VCVTUQQ2PS_RU_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RU_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RU_SAE_Z(z, k, y operand.Op) { ctx.VCVTUQQ2PS_RU_SAE_Z(z, k, y) }

// VCVTUQQ2PS_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE zmm k ymm
//	VCVTUQQ2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RZ_SAE instruction to the active function.
func (c *Context) VCVTUQQ2PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RZ_SAE(ops...))
}

// VCVTUQQ2PS_RZ_SAE: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE zmm k ymm
//	VCVTUQQ2PS.RZ_SAE zmm ymm
//
// Construct and append a VCVTUQQ2PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RZ_SAE(ops ...operand.Op) { ctx.VCVTUQQ2PS_RZ_SAE(ops...) }

// VCVTUQQ2PS_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_RZ_SAE_Z(z, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_RZ_SAE_Z(z, k, y))
}

// VCVTUQQ2PS_RZ_SAE_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.RZ_SAE.Z zmm k ymm
//
// Construct and append a VCVTUQQ2PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_RZ_SAE_Z(z, k, y operand.Op) { ctx.VCVTUQQ2PS_RZ_SAE_Z(z, k, y) }

// VCVTUQQ2PS_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.Z m512 k ymm
//	VCVTUQQ2PS.Z zmm  k ymm
//
// Construct and append a VCVTUQQ2PS.Z instruction to the active function.
func (c *Context) VCVTUQQ2PS_Z(mz, k, y operand.Op) {
	c.addinstruction(x86.VCVTUQQ2PS_Z(mz, k, y))
}

// VCVTUQQ2PS_Z: Convert Packed Unsigned Quadword Integers to Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VCVTUQQ2PS.Z m512 k ymm
//	VCVTUQQ2PS.Z zmm  k ymm
//
// Construct and append a VCVTUQQ2PS.Z instruction to the active function.
// Operates on the global context.
func VCVTUQQ2PS_Z(mz, k, y operand.Op) { ctx.VCVTUQQ2PS_Z(mz, k, y) }

// VCVTUSI2SDL: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDL m32 xmm xmm
//	VCVTUSI2SDL r32 xmm xmm
//
// Construct and append a VCVTUSI2SDL instruction to the active function.
func (c *Context) VCVTUSI2SDL(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDL(mr, x, x1))
}

// VCVTUSI2SDL: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDL m32 xmm xmm
//	VCVTUSI2SDL r32 xmm xmm
//
// Construct and append a VCVTUSI2SDL instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDL(mr, x, x1 operand.Op) { ctx.VCVTUSI2SDL(mr, x, x1) }

// VCVTUSI2SDQ: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDQ m64 xmm xmm
//	VCVTUSI2SDQ r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ instruction to the active function.
func (c *Context) VCVTUSI2SDQ(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDQ(mr, x, x1))
}

// VCVTUSI2SDQ: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SDQ m64 xmm xmm
//	VCVTUSI2SDQ r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDQ(mr, x, x1 operand.Op) { ctx.VCVTUSI2SDQ(mr, x, x1) }

// VCVTUSI2SDQ_RD_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RD_SAE instruction to the active function.
func (c *Context) VCVTUSI2SDQ_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDQ_RD_SAE(r, x, x1))
}

// VCVTUSI2SDQ_RD_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDQ_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SDQ_RD_SAE(r, x, x1) }

// VCVTUSI2SDQ_RN_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SDQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RN_SAE instruction to the active function.
func (c *Context) VCVTUSI2SDQ_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDQ_RN_SAE(r, x, x1))
}

// VCVTUSI2SDQ_RN_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SDQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDQ_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SDQ_RN_SAE(r, x, x1) }

// VCVTUSI2SDQ_RU_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RU_SAE instruction to the active function.
func (c *Context) VCVTUSI2SDQ_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDQ_RU_SAE(r, x, x1))
}

// VCVTUSI2SDQ_RU_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SDQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDQ_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SDQ_RU_SAE(r, x, x1) }

// VCVTUSI2SDQ_RZ_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SDQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTUSI2SDQ_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SDQ_RZ_SAE(r, x, x1))
}

// VCVTUSI2SDQ_RZ_SAE: Convert Unsigned Integer to Scalar Double-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SDQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SDQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SDQ_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SDQ_RZ_SAE(r, x, x1) }

// VCVTUSI2SSL: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSL m32 xmm xmm
//	VCVTUSI2SSL r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL instruction to the active function.
func (c *Context) VCVTUSI2SSL(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSL(mr, x, x1))
}

// VCVTUSI2SSL: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSL m32 xmm xmm
//	VCVTUSI2SSL r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSL(mr, x, x1 operand.Op) { ctx.VCVTUSI2SSL(mr, x, x1) }

// VCVTUSI2SSL_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RD_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RD_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSL_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSL_RD_SAE(r, x, x1))
}

// VCVTUSI2SSL_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RD_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSL_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSL_RD_SAE(r, x, x1) }

// VCVTUSI2SSL_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSL.RN_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RN_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSL_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSL_RN_SAE(r, x, x1))
}

// VCVTUSI2SSL_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSL.RN_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSL_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSL_RN_SAE(r, x, x1) }

// VCVTUSI2SSL_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RU_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RU_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSL_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSL_RU_SAE(r, x, x1))
}

// VCVTUSI2SSL_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSL.RU_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSL_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSL_RU_SAE(r, x, x1) }

// VCVTUSI2SSL_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSL.RZ_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RZ_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSL_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSL_RZ_SAE(r, x, x1))
}

// VCVTUSI2SSL_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSL.RZ_SAE r32 xmm xmm
//
// Construct and append a VCVTUSI2SSL.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSL_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSL_RZ_SAE(r, x, x1) }

// VCVTUSI2SSQ: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSQ m64 xmm xmm
//	VCVTUSI2SSQ r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ instruction to the active function.
func (c *Context) VCVTUSI2SSQ(mr, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSQ(mr, x, x1))
}

// VCVTUSI2SSQ: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VCVTUSI2SSQ m64 xmm xmm
//	VCVTUSI2SSQ r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSQ(mr, x, x1 operand.Op) { ctx.VCVTUSI2SSQ(mr, x, x1) }

// VCVTUSI2SSQ_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RD_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSQ_RD_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSQ_RD_SAE(r, x, x1))
}

// VCVTUSI2SSQ_RD_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Negative Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RD_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RD_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSQ_RD_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSQ_RD_SAE(r, x, x1) }

// VCVTUSI2SSQ_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RN_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSQ_RN_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSQ_RN_SAE(r, x, x1))
}

// VCVTUSI2SSQ_RN_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Nearest).
//
// Forms:
//
//	VCVTUSI2SSQ.RN_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RN_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSQ_RN_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSQ_RN_SAE(r, x, x1) }

// VCVTUSI2SSQ_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RU_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSQ_RU_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSQ_RU_SAE(r, x, x1))
}

// VCVTUSI2SSQ_RU_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Positive Infinity).
//
// Forms:
//
//	VCVTUSI2SSQ.RU_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RU_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSQ_RU_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSQ_RU_SAE(r, x, x1) }

// VCVTUSI2SSQ_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RZ_SAE instruction to the active function.
func (c *Context) VCVTUSI2SSQ_RZ_SAE(r, x, x1 operand.Op) {
	c.addinstruction(x86.VCVTUSI2SSQ_RZ_SAE(r, x, x1))
}

// VCVTUSI2SSQ_RZ_SAE: Convert Unsigned Integer to Scalar Single-Precision Floating-Point Value (Round Towards Zero).
//
// Forms:
//
//	VCVTUSI2SSQ.RZ_SAE r64 xmm xmm
//
// Construct and append a VCVTUSI2SSQ.RZ_SAE instruction to the active function.
// Operates on the global context.
func VCVTUSI2SSQ_RZ_SAE(r, x, x1 operand.Op) { ctx.VCVTUSI2SSQ_RZ_SAE(r, x, x1) }

// VDBPSADBW: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes.
//
// Forms:
//
//	VDBPSADBW imm8 m128 xmm k xmm
//	VDBPSADBW imm8 m128 xmm xmm
//	VDBPSADBW imm8 m256 ymm k ymm
//	VDBPSADBW imm8 m256 ymm ymm
//	VDBPSADBW imm8 xmm  xmm k xmm
//	VDBPSADBW imm8 xmm  xmm xmm
//	VDBPSADBW imm8 ymm  ymm k ymm
//	VDBPSADBW imm8 ymm  ymm ymm
//	VDBPSADBW imm8 m512 zmm k zmm
//	VDBPSADBW imm8 m512 zmm zmm
//	VDBPSADBW imm8 zmm  zmm k zmm
//	VDBPSADBW imm8 zmm  zmm zmm
//
// Construct and append a VDBPSADBW instruction to the active function.
func (c *Context) VDBPSADBW(ops ...operand.Op) {
	c.addinstruction(x86.VDBPSADBW(ops...))
}

// VDBPSADBW: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes.
//
// Forms:
//
//	VDBPSADBW imm8 m128 xmm k xmm
//	VDBPSADBW imm8 m128 xmm xmm
//	VDBPSADBW imm8 m256 ymm k ymm
//	VDBPSADBW imm8 m256 ymm ymm
//	VDBPSADBW imm8 xmm  xmm k xmm
//	VDBPSADBW imm8 xmm  xmm xmm
//	VDBPSADBW imm8 ymm  ymm k ymm
//	VDBPSADBW imm8 ymm  ymm ymm
//	VDBPSADBW imm8 m512 zmm k zmm
//	VDBPSADBW imm8 m512 zmm zmm
//	VDBPSADBW imm8 zmm  zmm k zmm
//	VDBPSADBW imm8 zmm  zmm zmm
//
// Construct and append a VDBPSADBW instruction to the active function.
// Operates on the global context.
func VDBPSADBW(ops ...operand.Op) { ctx.VDBPSADBW(ops...) }

// VDBPSADBW_Z: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes (Zeroing Masking).
//
// Forms:
//
//	VDBPSADBW.Z imm8 m128 xmm k xmm
//	VDBPSADBW.Z imm8 m256 ymm k ymm
//	VDBPSADBW.Z imm8 xmm  xmm k xmm
//	VDBPSADBW.Z imm8 ymm  ymm k ymm
//	VDBPSADBW.Z imm8 m512 zmm k zmm
//	VDBPSADBW.Z imm8 zmm  zmm k zmm
//
// Construct and append a VDBPSADBW.Z instruction to the active function.
func (c *Context) VDBPSADBW_Z(i, mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VDBPSADBW_Z(i, mxyz, xyz, k, xyz1))
}

// VDBPSADBW_Z: Double Block Packed Sum-Absolute-Differences on Unsigned Bytes (Zeroing Masking).
//
// Forms:
//
//	VDBPSADBW.Z imm8 m128 xmm k xmm
//	VDBPSADBW.Z imm8 m256 ymm k ymm
//	VDBPSADBW.Z imm8 xmm  xmm k xmm
//	VDBPSADBW.Z imm8 ymm  ymm k ymm
//	VDBPSADBW.Z imm8 m512 zmm k zmm
//	VDBPSADBW.Z imm8 zmm  zmm k zmm
//
// Construct and append a VDBPSADBW.Z instruction to the active function.
// Operates on the global context.
func VDBPSADBW_Z(i, mxyz, xyz, k, xyz1 operand.Op) { ctx.VDBPSADBW_Z(i, mxyz, xyz, k, xyz1) }

// VDIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPD m128 xmm xmm
//	VDIVPD m256 ymm ymm
//	VDIVPD xmm  xmm xmm
//	VDIVPD ymm  ymm ymm
//	VDIVPD m128 xmm k xmm
//	VDIVPD m256 ymm k ymm
//	VDIVPD xmm  xmm k xmm
//	VDIVPD ymm  ymm k ymm
//	VDIVPD m512 zmm k zmm
//	VDIVPD m512 zmm zmm
//	VDIVPD zmm  zmm k zmm
//	VDIVPD zmm  zmm zmm
//
// Construct and append a VDIVPD instruction to the active function.
func (c *Context) VDIVPD(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD(ops...))
}

// VDIVPD: Divide Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPD m128 xmm xmm
//	VDIVPD m256 ymm ymm
//	VDIVPD xmm  xmm xmm
//	VDIVPD ymm  ymm ymm
//	VDIVPD m128 xmm k xmm
//	VDIVPD m256 ymm k ymm
//	VDIVPD xmm  xmm k xmm
//	VDIVPD ymm  ymm k ymm
//	VDIVPD m512 zmm k zmm
//	VDIVPD m512 zmm zmm
//	VDIVPD zmm  zmm k zmm
//	VDIVPD zmm  zmm zmm
//
// Construct and append a VDIVPD instruction to the active function.
// Operates on the global context.
func VDIVPD(ops ...operand.Op) { ctx.VDIVPD(ops...) }

// VDIVPD_BCST: Divide Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPD.BCST m64 xmm k xmm
//	VDIVPD.BCST m64 xmm xmm
//	VDIVPD.BCST m64 ymm k ymm
//	VDIVPD.BCST m64 ymm ymm
//	VDIVPD.BCST m64 zmm k zmm
//	VDIVPD.BCST m64 zmm zmm
//
// Construct and append a VDIVPD.BCST instruction to the active function.
func (c *Context) VDIVPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD_BCST(ops...))
}

// VDIVPD_BCST: Divide Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPD.BCST m64 xmm k xmm
//	VDIVPD.BCST m64 xmm xmm
//	VDIVPD.BCST m64 ymm k ymm
//	VDIVPD.BCST m64 ymm ymm
//	VDIVPD.BCST m64 zmm k zmm
//	VDIVPD.BCST m64 zmm zmm
//
// Construct and append a VDIVPD.BCST instruction to the active function.
// Operates on the global context.
func VDIVPD_BCST(ops ...operand.Op) { ctx.VDIVPD_BCST(ops...) }

// VDIVPD_BCST_Z: Divide Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.BCST.Z m64 xmm k xmm
//	VDIVPD.BCST.Z m64 ymm k ymm
//	VDIVPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VDIVPD.BCST.Z instruction to the active function.
func (c *Context) VDIVPD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VDIVPD_BCST_Z(m, xyz, k, xyz1))
}

// VDIVPD_BCST_Z: Divide Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.BCST.Z m64 xmm k xmm
//	VDIVPD.BCST.Z m64 ymm k ymm
//	VDIVPD.BCST.Z m64 zmm k zmm
//
// Construct and append a VDIVPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VDIVPD_BCST_Z(m, xyz, k, xyz1) }

// VDIVPD_RD_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPD.RD_SAE zmm zmm k zmm
//	VDIVPD.RD_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RD_SAE instruction to the active function.
func (c *Context) VDIVPD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD_RD_SAE(ops...))
}

// VDIVPD_RD_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPD.RD_SAE zmm zmm k zmm
//	VDIVPD.RD_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RD_SAE instruction to the active function.
// Operates on the global context.
func VDIVPD_RD_SAE(ops ...operand.Op) { ctx.VDIVPD_RD_SAE(ops...) }

// VDIVPD_RD_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RD_SAE.Z instruction to the active function.
func (c *Context) VDIVPD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPD_RD_SAE_Z(z, z1, k, z2))
}

// VDIVPD_RD_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPD_RD_SAE_Z(z, z1, k, z2) }

// VDIVPD_RN_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPD.RN_SAE zmm zmm k zmm
//	VDIVPD.RN_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RN_SAE instruction to the active function.
func (c *Context) VDIVPD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD_RN_SAE(ops...))
}

// VDIVPD_RN_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPD.RN_SAE zmm zmm k zmm
//	VDIVPD.RN_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RN_SAE instruction to the active function.
// Operates on the global context.
func VDIVPD_RN_SAE(ops ...operand.Op) { ctx.VDIVPD_RN_SAE(ops...) }

// VDIVPD_RN_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RN_SAE.Z instruction to the active function.
func (c *Context) VDIVPD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPD_RN_SAE_Z(z, z1, k, z2))
}

// VDIVPD_RN_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPD_RN_SAE_Z(z, z1, k, z2) }

// VDIVPD_RU_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPD.RU_SAE zmm zmm k zmm
//	VDIVPD.RU_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RU_SAE instruction to the active function.
func (c *Context) VDIVPD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD_RU_SAE(ops...))
}

// VDIVPD_RU_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPD.RU_SAE zmm zmm k zmm
//	VDIVPD.RU_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RU_SAE instruction to the active function.
// Operates on the global context.
func VDIVPD_RU_SAE(ops ...operand.Op) { ctx.VDIVPD_RU_SAE(ops...) }

// VDIVPD_RU_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RU_SAE.Z instruction to the active function.
func (c *Context) VDIVPD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPD_RU_SAE_Z(z, z1, k, z2))
}

// VDIVPD_RU_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPD_RU_SAE_Z(z, z1, k, z2) }

// VDIVPD_RZ_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPD.RZ_SAE zmm zmm k zmm
//	VDIVPD.RZ_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RZ_SAE instruction to the active function.
func (c *Context) VDIVPD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPD_RZ_SAE(ops...))
}

// VDIVPD_RZ_SAE: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPD.RZ_SAE zmm zmm k zmm
//	VDIVPD.RZ_SAE zmm zmm zmm
//
// Construct and append a VDIVPD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VDIVPD_RZ_SAE(ops ...operand.Op) { ctx.VDIVPD_RZ_SAE(ops...) }

// VDIVPD_RZ_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RZ_SAE.Z instruction to the active function.
func (c *Context) VDIVPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPD_RZ_SAE_Z(z, z1, k, z2))
}

// VDIVPD_RZ_SAE_Z: Divide Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPD_RZ_SAE_Z(z, z1, k, z2) }

// VDIVPD_Z: Divide Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPD.Z m128 xmm k xmm
//	VDIVPD.Z m256 ymm k ymm
//	VDIVPD.Z xmm  xmm k xmm
//	VDIVPD.Z ymm  ymm k ymm
//	VDIVPD.Z m512 zmm k zmm
//	VDIVPD.Z zmm  zmm k zmm
//
// Construct and append a VDIVPD.Z instruction to the active function.
func (c *Context) VDIVPD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VDIVPD_Z(mxyz, xyz, k, xyz1))
}

// VDIVPD_Z: Divide Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPD.Z m128 xmm k xmm
//	VDIVPD.Z m256 ymm k ymm
//	VDIVPD.Z xmm  xmm k xmm
//	VDIVPD.Z ymm  ymm k ymm
//	VDIVPD.Z m512 zmm k zmm
//	VDIVPD.Z zmm  zmm k zmm
//
// Construct and append a VDIVPD.Z instruction to the active function.
// Operates on the global context.
func VDIVPD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VDIVPD_Z(mxyz, xyz, k, xyz1) }

// VDIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPS m128 xmm xmm
//	VDIVPS m256 ymm ymm
//	VDIVPS xmm  xmm xmm
//	VDIVPS ymm  ymm ymm
//	VDIVPS m128 xmm k xmm
//	VDIVPS m256 ymm k ymm
//	VDIVPS xmm  xmm k xmm
//	VDIVPS ymm  ymm k ymm
//	VDIVPS m512 zmm k zmm
//	VDIVPS m512 zmm zmm
//	VDIVPS zmm  zmm k zmm
//	VDIVPS zmm  zmm zmm
//
// Construct and append a VDIVPS instruction to the active function.
func (c *Context) VDIVPS(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS(ops...))
}

// VDIVPS: Divide Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVPS m128 xmm xmm
//	VDIVPS m256 ymm ymm
//	VDIVPS xmm  xmm xmm
//	VDIVPS ymm  ymm ymm
//	VDIVPS m128 xmm k xmm
//	VDIVPS m256 ymm k ymm
//	VDIVPS xmm  xmm k xmm
//	VDIVPS ymm  ymm k ymm
//	VDIVPS m512 zmm k zmm
//	VDIVPS m512 zmm zmm
//	VDIVPS zmm  zmm k zmm
//	VDIVPS zmm  zmm zmm
//
// Construct and append a VDIVPS instruction to the active function.
// Operates on the global context.
func VDIVPS(ops ...operand.Op) { ctx.VDIVPS(ops...) }

// VDIVPS_BCST: Divide Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPS.BCST m32 xmm k xmm
//	VDIVPS.BCST m32 xmm xmm
//	VDIVPS.BCST m32 ymm k ymm
//	VDIVPS.BCST m32 ymm ymm
//	VDIVPS.BCST m32 zmm k zmm
//	VDIVPS.BCST m32 zmm zmm
//
// Construct and append a VDIVPS.BCST instruction to the active function.
func (c *Context) VDIVPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS_BCST(ops...))
}

// VDIVPS_BCST: Divide Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VDIVPS.BCST m32 xmm k xmm
//	VDIVPS.BCST m32 xmm xmm
//	VDIVPS.BCST m32 ymm k ymm
//	VDIVPS.BCST m32 ymm ymm
//	VDIVPS.BCST m32 zmm k zmm
//	VDIVPS.BCST m32 zmm zmm
//
// Construct and append a VDIVPS.BCST instruction to the active function.
// Operates on the global context.
func VDIVPS_BCST(ops ...operand.Op) { ctx.VDIVPS_BCST(ops...) }

// VDIVPS_BCST_Z: Divide Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.BCST.Z m32 xmm k xmm
//	VDIVPS.BCST.Z m32 ymm k ymm
//	VDIVPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VDIVPS.BCST.Z instruction to the active function.
func (c *Context) VDIVPS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VDIVPS_BCST_Z(m, xyz, k, xyz1))
}

// VDIVPS_BCST_Z: Divide Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.BCST.Z m32 xmm k xmm
//	VDIVPS.BCST.Z m32 ymm k ymm
//	VDIVPS.BCST.Z m32 zmm k zmm
//
// Construct and append a VDIVPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VDIVPS_BCST_Z(m, xyz, k, xyz1) }

// VDIVPS_RD_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPS.RD_SAE zmm zmm k zmm
//	VDIVPS.RD_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RD_SAE instruction to the active function.
func (c *Context) VDIVPS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS_RD_SAE(ops...))
}

// VDIVPS_RD_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVPS.RD_SAE zmm zmm k zmm
//	VDIVPS.RD_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RD_SAE instruction to the active function.
// Operates on the global context.
func VDIVPS_RD_SAE(ops ...operand.Op) { ctx.VDIVPS_RD_SAE(ops...) }

// VDIVPS_RD_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RD_SAE.Z instruction to the active function.
func (c *Context) VDIVPS_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPS_RD_SAE_Z(z, z1, k, z2))
}

// VDIVPS_RD_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPS_RD_SAE_Z(z, z1, k, z2) }

// VDIVPS_RN_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPS.RN_SAE zmm zmm k zmm
//	VDIVPS.RN_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RN_SAE instruction to the active function.
func (c *Context) VDIVPS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS_RN_SAE(ops...))
}

// VDIVPS_RN_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVPS.RN_SAE zmm zmm k zmm
//	VDIVPS.RN_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RN_SAE instruction to the active function.
// Operates on the global context.
func VDIVPS_RN_SAE(ops ...operand.Op) { ctx.VDIVPS_RN_SAE(ops...) }

// VDIVPS_RN_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RN_SAE.Z instruction to the active function.
func (c *Context) VDIVPS_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPS_RN_SAE_Z(z, z1, k, z2))
}

// VDIVPS_RN_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPS_RN_SAE_Z(z, z1, k, z2) }

// VDIVPS_RU_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPS.RU_SAE zmm zmm k zmm
//	VDIVPS.RU_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RU_SAE instruction to the active function.
func (c *Context) VDIVPS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS_RU_SAE(ops...))
}

// VDIVPS_RU_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVPS.RU_SAE zmm zmm k zmm
//	VDIVPS.RU_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RU_SAE instruction to the active function.
// Operates on the global context.
func VDIVPS_RU_SAE(ops ...operand.Op) { ctx.VDIVPS_RU_SAE(ops...) }

// VDIVPS_RU_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RU_SAE.Z instruction to the active function.
func (c *Context) VDIVPS_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPS_RU_SAE_Z(z, z1, k, z2))
}

// VDIVPS_RU_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPS_RU_SAE_Z(z, z1, k, z2) }

// VDIVPS_RZ_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPS.RZ_SAE zmm zmm k zmm
//	VDIVPS.RZ_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RZ_SAE instruction to the active function.
func (c *Context) VDIVPS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVPS_RZ_SAE(ops...))
}

// VDIVPS_RZ_SAE: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVPS.RZ_SAE zmm zmm k zmm
//	VDIVPS.RZ_SAE zmm zmm zmm
//
// Construct and append a VDIVPS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VDIVPS_RZ_SAE(ops ...operand.Op) { ctx.VDIVPS_RZ_SAE(ops...) }

// VDIVPS_RZ_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RZ_SAE.Z instruction to the active function.
func (c *Context) VDIVPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VDIVPS_RZ_SAE_Z(z, z1, k, z2))
}

// VDIVPS_RZ_SAE_Z: Divide Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVPS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VDIVPS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VDIVPS_RZ_SAE_Z(z, z1, k, z2) }

// VDIVPS_Z: Divide Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPS.Z m128 xmm k xmm
//	VDIVPS.Z m256 ymm k ymm
//	VDIVPS.Z xmm  xmm k xmm
//	VDIVPS.Z ymm  ymm k ymm
//	VDIVPS.Z m512 zmm k zmm
//	VDIVPS.Z zmm  zmm k zmm
//
// Construct and append a VDIVPS.Z instruction to the active function.
func (c *Context) VDIVPS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VDIVPS_Z(mxyz, xyz, k, xyz1))
}

// VDIVPS_Z: Divide Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVPS.Z m128 xmm k xmm
//	VDIVPS.Z m256 ymm k ymm
//	VDIVPS.Z xmm  xmm k xmm
//	VDIVPS.Z ymm  ymm k ymm
//	VDIVPS.Z m512 zmm k zmm
//	VDIVPS.Z zmm  zmm k zmm
//
// Construct and append a VDIVPS.Z instruction to the active function.
// Operates on the global context.
func VDIVPS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VDIVPS_Z(mxyz, xyz, k, xyz1) }

// VDIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSD m64 xmm xmm
//	VDIVSD xmm xmm xmm
//	VDIVSD m64 xmm k xmm
//	VDIVSD xmm xmm k xmm
//
// Construct and append a VDIVSD instruction to the active function.
func (c *Context) VDIVSD(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSD(ops...))
}

// VDIVSD: Divide Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSD m64 xmm xmm
//	VDIVSD xmm xmm xmm
//	VDIVSD m64 xmm k xmm
//	VDIVSD xmm xmm k xmm
//
// Construct and append a VDIVSD instruction to the active function.
// Operates on the global context.
func VDIVSD(ops ...operand.Op) { ctx.VDIVSD(ops...) }

// VDIVSD_RD_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSD.RD_SAE xmm xmm k xmm
//	VDIVSD.RD_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RD_SAE instruction to the active function.
func (c *Context) VDIVSD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSD_RD_SAE(ops...))
}

// VDIVSD_RD_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSD.RD_SAE xmm xmm k xmm
//	VDIVSD.RD_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RD_SAE instruction to the active function.
// Operates on the global context.
func VDIVSD_RD_SAE(ops ...operand.Op) { ctx.VDIVSD_RD_SAE(ops...) }

// VDIVSD_RD_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RD_SAE.Z instruction to the active function.
func (c *Context) VDIVSD_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSD_RD_SAE_Z(x, x1, k, x2))
}

// VDIVSD_RD_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSD_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSD_RD_SAE_Z(x, x1, k, x2) }

// VDIVSD_RN_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSD.RN_SAE xmm xmm k xmm
//	VDIVSD.RN_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RN_SAE instruction to the active function.
func (c *Context) VDIVSD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSD_RN_SAE(ops...))
}

// VDIVSD_RN_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSD.RN_SAE xmm xmm k xmm
//	VDIVSD.RN_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RN_SAE instruction to the active function.
// Operates on the global context.
func VDIVSD_RN_SAE(ops ...operand.Op) { ctx.VDIVSD_RN_SAE(ops...) }

// VDIVSD_RN_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RN_SAE.Z instruction to the active function.
func (c *Context) VDIVSD_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSD_RN_SAE_Z(x, x1, k, x2))
}

// VDIVSD_RN_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSD_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSD_RN_SAE_Z(x, x1, k, x2) }

// VDIVSD_RU_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSD.RU_SAE xmm xmm k xmm
//	VDIVSD.RU_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RU_SAE instruction to the active function.
func (c *Context) VDIVSD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSD_RU_SAE(ops...))
}

// VDIVSD_RU_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSD.RU_SAE xmm xmm k xmm
//	VDIVSD.RU_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RU_SAE instruction to the active function.
// Operates on the global context.
func VDIVSD_RU_SAE(ops ...operand.Op) { ctx.VDIVSD_RU_SAE(ops...) }

// VDIVSD_RU_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RU_SAE.Z instruction to the active function.
func (c *Context) VDIVSD_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSD_RU_SAE_Z(x, x1, k, x2))
}

// VDIVSD_RU_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSD_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSD_RU_SAE_Z(x, x1, k, x2) }

// VDIVSD_RZ_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSD.RZ_SAE xmm xmm k xmm
//	VDIVSD.RZ_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RZ_SAE instruction to the active function.
func (c *Context) VDIVSD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSD_RZ_SAE(ops...))
}

// VDIVSD_RZ_SAE: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSD.RZ_SAE xmm xmm k xmm
//	VDIVSD.RZ_SAE xmm xmm xmm
//
// Construct and append a VDIVSD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VDIVSD_RZ_SAE(ops ...operand.Op) { ctx.VDIVSD_RZ_SAE(ops...) }

// VDIVSD_RZ_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RZ_SAE.Z instruction to the active function.
func (c *Context) VDIVSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSD_RZ_SAE_Z(x, x1, k, x2))
}

// VDIVSD_RZ_SAE_Z: Divide Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSD_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSD_RZ_SAE_Z(x, x1, k, x2) }

// VDIVSD_Z: Divide Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSD.Z m64 xmm k xmm
//	VDIVSD.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.Z instruction to the active function.
func (c *Context) VDIVSD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VDIVSD_Z(mx, x, k, x1))
}

// VDIVSD_Z: Divide Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSD.Z m64 xmm k xmm
//	VDIVSD.Z xmm xmm k xmm
//
// Construct and append a VDIVSD.Z instruction to the active function.
// Operates on the global context.
func VDIVSD_Z(mx, x, k, x1 operand.Op) { ctx.VDIVSD_Z(mx, x, k, x1) }

// VDIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSS m32 xmm xmm
//	VDIVSS xmm xmm xmm
//	VDIVSS m32 xmm k xmm
//	VDIVSS xmm xmm k xmm
//
// Construct and append a VDIVSS instruction to the active function.
func (c *Context) VDIVSS(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSS(ops...))
}

// VDIVSS: Divide Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VDIVSS m32 xmm xmm
//	VDIVSS xmm xmm xmm
//	VDIVSS m32 xmm k xmm
//	VDIVSS xmm xmm k xmm
//
// Construct and append a VDIVSS instruction to the active function.
// Operates on the global context.
func VDIVSS(ops ...operand.Op) { ctx.VDIVSS(ops...) }

// VDIVSS_RD_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSS.RD_SAE xmm xmm k xmm
//	VDIVSS.RD_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RD_SAE instruction to the active function.
func (c *Context) VDIVSS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSS_RD_SAE(ops...))
}

// VDIVSS_RD_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VDIVSS.RD_SAE xmm xmm k xmm
//	VDIVSS.RD_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RD_SAE instruction to the active function.
// Operates on the global context.
func VDIVSS_RD_SAE(ops ...operand.Op) { ctx.VDIVSS_RD_SAE(ops...) }

// VDIVSS_RD_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RD_SAE.Z instruction to the active function.
func (c *Context) VDIVSS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSS_RD_SAE_Z(x, x1, k, x2))
}

// VDIVSS_RD_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSS_RD_SAE_Z(x, x1, k, x2) }

// VDIVSS_RN_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSS.RN_SAE xmm xmm k xmm
//	VDIVSS.RN_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RN_SAE instruction to the active function.
func (c *Context) VDIVSS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSS_RN_SAE(ops...))
}

// VDIVSS_RN_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VDIVSS.RN_SAE xmm xmm k xmm
//	VDIVSS.RN_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RN_SAE instruction to the active function.
// Operates on the global context.
func VDIVSS_RN_SAE(ops ...operand.Op) { ctx.VDIVSS_RN_SAE(ops...) }

// VDIVSS_RN_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RN_SAE.Z instruction to the active function.
func (c *Context) VDIVSS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSS_RN_SAE_Z(x, x1, k, x2))
}

// VDIVSS_RN_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSS_RN_SAE_Z(x, x1, k, x2) }

// VDIVSS_RU_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSS.RU_SAE xmm xmm k xmm
//	VDIVSS.RU_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RU_SAE instruction to the active function.
func (c *Context) VDIVSS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSS_RU_SAE(ops...))
}

// VDIVSS_RU_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VDIVSS.RU_SAE xmm xmm k xmm
//	VDIVSS.RU_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RU_SAE instruction to the active function.
// Operates on the global context.
func VDIVSS_RU_SAE(ops ...operand.Op) { ctx.VDIVSS_RU_SAE(ops...) }

// VDIVSS_RU_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RU_SAE.Z instruction to the active function.
func (c *Context) VDIVSS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSS_RU_SAE_Z(x, x1, k, x2))
}

// VDIVSS_RU_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSS_RU_SAE_Z(x, x1, k, x2) }

// VDIVSS_RZ_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSS.RZ_SAE xmm xmm k xmm
//	VDIVSS.RZ_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RZ_SAE instruction to the active function.
func (c *Context) VDIVSS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VDIVSS_RZ_SAE(ops...))
}

// VDIVSS_RZ_SAE: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VDIVSS.RZ_SAE xmm xmm k xmm
//	VDIVSS.RZ_SAE xmm xmm xmm
//
// Construct and append a VDIVSS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VDIVSS_RZ_SAE(ops ...operand.Op) { ctx.VDIVSS_RZ_SAE(ops...) }

// VDIVSS_RZ_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RZ_SAE.Z instruction to the active function.
func (c *Context) VDIVSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VDIVSS_RZ_SAE_Z(x, x1, k, x2))
}

// VDIVSS_RZ_SAE_Z: Divide Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VDIVSS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VDIVSS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VDIVSS_RZ_SAE_Z(x, x1, k, x2) }

// VDIVSS_Z: Divide Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSS.Z m32 xmm k xmm
//	VDIVSS.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.Z instruction to the active function.
func (c *Context) VDIVSS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VDIVSS_Z(mx, x, k, x1))
}

// VDIVSS_Z: Divide Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VDIVSS.Z m32 xmm k xmm
//	VDIVSS.Z xmm xmm k xmm
//
// Construct and append a VDIVSS.Z instruction to the active function.
// Operates on the global context.
func VDIVSS_Z(mx, x, k, x1 operand.Op) { ctx.VDIVSS_Z(mx, x, k, x1) }

// VDPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VDPPD imm8 m128 xmm xmm
//	VDPPD imm8 xmm  xmm xmm
//
// Construct and append a VDPPD instruction to the active function.
func (c *Context) VDPPD(i, mx, x, x1 operand.Op) {
	c.addinstruction(x86.VDPPD(i, mx, x, x1))
}

// VDPPD: Dot Product of Packed Double Precision Floating-Point Values.
//
// Forms:
//
//	VDPPD imm8 m128 xmm xmm
//	VDPPD imm8 xmm  xmm xmm
//
// Construct and append a VDPPD instruction to the active function.
// Operates on the global context.
func VDPPD(i, mx, x, x1 operand.Op) { ctx.VDPPD(i, mx, x, x1) }

// VDPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VDPPS imm8 m128 xmm xmm
//	VDPPS imm8 m256 ymm ymm
//	VDPPS imm8 xmm  xmm xmm
//	VDPPS imm8 ymm  ymm ymm
//
// Construct and append a VDPPS instruction to the active function.
func (c *Context) VDPPS(i, mxy, xy, xy1 operand.Op) {
	c.addinstruction(x86.VDPPS(i, mxy, xy, xy1))
}

// VDPPS: Dot Product of Packed Single Precision Floating-Point Values.
//
// Forms:
//
//	VDPPS imm8 m128 xmm xmm
//	VDPPS imm8 m256 ymm ymm
//	VDPPS imm8 xmm  xmm xmm
//	VDPPS imm8 ymm  ymm ymm
//
// Construct and append a VDPPS instruction to the active function.
// Operates on the global context.
func VDPPS(i, mxy, xy, xy1 operand.Op) { ctx.VDPPS(i, mxy, xy, xy1) }

// VEXP2PD: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PD m512 k zmm
//	VEXP2PD m512 zmm
//	VEXP2PD zmm  k zmm
//	VEXP2PD zmm  zmm
//
// Construct and append a VEXP2PD instruction to the active function.
func (c *Context) VEXP2PD(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PD(ops...))
}

// VEXP2PD: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PD m512 k zmm
//	VEXP2PD m512 zmm
//	VEXP2PD zmm  k zmm
//	VEXP2PD zmm  zmm
//
// Construct and append a VEXP2PD instruction to the active function.
// Operates on the global context.
func VEXP2PD(ops ...operand.Op) { ctx.VEXP2PD(ops...) }

// VEXP2PD_BCST: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PD.BCST m64 k zmm
//	VEXP2PD.BCST m64 zmm
//
// Construct and append a VEXP2PD.BCST instruction to the active function.
func (c *Context) VEXP2PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PD_BCST(ops...))
}

// VEXP2PD_BCST: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PD.BCST m64 k zmm
//	VEXP2PD.BCST m64 zmm
//
// Construct and append a VEXP2PD.BCST instruction to the active function.
// Operates on the global context.
func VEXP2PD_BCST(ops ...operand.Op) { ctx.VEXP2PD_BCST(ops...) }

// VEXP2PD_BCST_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.BCST.Z m64 k zmm
//
// Construct and append a VEXP2PD.BCST.Z instruction to the active function.
func (c *Context) VEXP2PD_BCST_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VEXP2PD_BCST_Z(m, k, z))
}

// VEXP2PD_BCST_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.BCST.Z m64 k zmm
//
// Construct and append a VEXP2PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VEXP2PD_BCST_Z(m, k, z operand.Op) { ctx.VEXP2PD_BCST_Z(m, k, z) }

// VEXP2PD_SAE: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PD.SAE zmm k zmm
//	VEXP2PD.SAE zmm zmm
//
// Construct and append a VEXP2PD.SAE instruction to the active function.
func (c *Context) VEXP2PD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PD_SAE(ops...))
}

// VEXP2PD_SAE: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PD.SAE zmm k zmm
//	VEXP2PD.SAE zmm zmm
//
// Construct and append a VEXP2PD.SAE instruction to the active function.
// Operates on the global context.
func VEXP2PD_SAE(ops ...operand.Op) { ctx.VEXP2PD_SAE(ops...) }

// VEXP2PD_SAE_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.SAE.Z zmm k zmm
//
// Construct and append a VEXP2PD.SAE.Z instruction to the active function.
func (c *Context) VEXP2PD_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VEXP2PD_SAE_Z(z, k, z1))
}

// VEXP2PD_SAE_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.SAE.Z zmm k zmm
//
// Construct and append a VEXP2PD.SAE.Z instruction to the active function.
// Operates on the global context.
func VEXP2PD_SAE_Z(z, k, z1 operand.Op) { ctx.VEXP2PD_SAE_Z(z, k, z1) }

// VEXP2PD_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.Z m512 k zmm
//	VEXP2PD.Z zmm  k zmm
//
// Construct and append a VEXP2PD.Z instruction to the active function.
func (c *Context) VEXP2PD_Z(mz, k, z operand.Op) {
	c.addinstruction(x86.VEXP2PD_Z(mz, k, z))
}

// VEXP2PD_Z: Approximation to the Exponential 2^x of Packed Double-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PD.Z m512 k zmm
//	VEXP2PD.Z zmm  k zmm
//
// Construct and append a VEXP2PD.Z instruction to the active function.
// Operates on the global context.
func VEXP2PD_Z(mz, k, z operand.Op) { ctx.VEXP2PD_Z(mz, k, z) }

// VEXP2PS: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PS m512 k zmm
//	VEXP2PS m512 zmm
//	VEXP2PS zmm  k zmm
//	VEXP2PS zmm  zmm
//
// Construct and append a VEXP2PS instruction to the active function.
func (c *Context) VEXP2PS(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PS(ops...))
}

// VEXP2PS: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error.
//
// Forms:
//
//	VEXP2PS m512 k zmm
//	VEXP2PS m512 zmm
//	VEXP2PS zmm  k zmm
//	VEXP2PS zmm  zmm
//
// Construct and append a VEXP2PS instruction to the active function.
// Operates on the global context.
func VEXP2PS(ops ...operand.Op) { ctx.VEXP2PS(ops...) }

// VEXP2PS_BCST: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PS.BCST m32 k zmm
//	VEXP2PS.BCST m32 zmm
//
// Construct and append a VEXP2PS.BCST instruction to the active function.
func (c *Context) VEXP2PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PS_BCST(ops...))
}

// VEXP2PS_BCST: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast).
//
// Forms:
//
//	VEXP2PS.BCST m32 k zmm
//	VEXP2PS.BCST m32 zmm
//
// Construct and append a VEXP2PS.BCST instruction to the active function.
// Operates on the global context.
func VEXP2PS_BCST(ops ...operand.Op) { ctx.VEXP2PS_BCST(ops...) }

// VEXP2PS_BCST_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.BCST.Z m32 k zmm
//
// Construct and append a VEXP2PS.BCST.Z instruction to the active function.
func (c *Context) VEXP2PS_BCST_Z(m, k, z operand.Op) {
	c.addinstruction(x86.VEXP2PS_BCST_Z(m, k, z))
}

// VEXP2PS_BCST_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.BCST.Z m32 k zmm
//
// Construct and append a VEXP2PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VEXP2PS_BCST_Z(m, k, z operand.Op) { ctx.VEXP2PS_BCST_Z(m, k, z) }

// VEXP2PS_SAE: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PS.SAE zmm k zmm
//	VEXP2PS.SAE zmm zmm
//
// Construct and append a VEXP2PS.SAE instruction to the active function.
func (c *Context) VEXP2PS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VEXP2PS_SAE(ops...))
}

// VEXP2PS_SAE: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions).
//
// Forms:
//
//	VEXP2PS.SAE zmm k zmm
//	VEXP2PS.SAE zmm zmm
//
// Construct and append a VEXP2PS.SAE instruction to the active function.
// Operates on the global context.
func VEXP2PS_SAE(ops ...operand.Op) { ctx.VEXP2PS_SAE(ops...) }

// VEXP2PS_SAE_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.SAE.Z zmm k zmm
//
// Construct and append a VEXP2PS.SAE.Z instruction to the active function.
func (c *Context) VEXP2PS_SAE_Z(z, k, z1 operand.Op) {
	c.addinstruction(x86.VEXP2PS_SAE_Z(z, k, z1))
}

// VEXP2PS_SAE_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.SAE.Z zmm k zmm
//
// Construct and append a VEXP2PS.SAE.Z instruction to the active function.
// Operates on the global context.
func VEXP2PS_SAE_Z(z, k, z1 operand.Op) { ctx.VEXP2PS_SAE_Z(z, k, z1) }

// VEXP2PS_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.Z m512 k zmm
//	VEXP2PS.Z zmm  k zmm
//
// Construct and append a VEXP2PS.Z instruction to the active function.
func (c *Context) VEXP2PS_Z(mz, k, z operand.Op) {
	c.addinstruction(x86.VEXP2PS_Z(mz, k, z))
}

// VEXP2PS_Z: Approximation to the Exponential 2^x of Packed Single-Precision Floating-Point Values with Less Than 2^-23 Relative Error (Zeroing Masking).
//
// Forms:
//
//	VEXP2PS.Z m512 k zmm
//	VEXP2PS.Z zmm  k zmm
//
// Construct and append a VEXP2PS.Z instruction to the active function.
// Operates on the global context.
func VEXP2PS_Z(mz, k, z operand.Op) { ctx.VEXP2PS_Z(mz, k, z) }

// VEXPANDPD: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPD m256 k ymm
//	VEXPANDPD m256 ymm
//	VEXPANDPD ymm  k ymm
//	VEXPANDPD ymm  ymm
//	VEXPANDPD m512 k zmm
//	VEXPANDPD m512 zmm
//	VEXPANDPD zmm  k zmm
//	VEXPANDPD zmm  zmm
//	VEXPANDPD m128 k xmm
//	VEXPANDPD m128 xmm
//	VEXPANDPD xmm  k xmm
//	VEXPANDPD xmm  xmm
//
// Construct and append a VEXPANDPD instruction to the active function.
func (c *Context) VEXPANDPD(ops ...operand.Op) {
	c.addinstruction(x86.VEXPANDPD(ops...))
}

// VEXPANDPD: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPD m256 k ymm
//	VEXPANDPD m256 ymm
//	VEXPANDPD ymm  k ymm
//	VEXPANDPD ymm  ymm
//	VEXPANDPD m512 k zmm
//	VEXPANDPD m512 zmm
//	VEXPANDPD zmm  k zmm
//	VEXPANDPD zmm  zmm
//	VEXPANDPD m128 k xmm
//	VEXPANDPD m128 xmm
//	VEXPANDPD xmm  k xmm
//	VEXPANDPD xmm  xmm
//
// Construct and append a VEXPANDPD instruction to the active function.
// Operates on the global context.
func VEXPANDPD(ops ...operand.Op) { ctx.VEXPANDPD(ops...) }

// VEXPANDPD_Z: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPD.Z m256 k ymm
//	VEXPANDPD.Z ymm  k ymm
//	VEXPANDPD.Z m512 k zmm
//	VEXPANDPD.Z zmm  k zmm
//	VEXPANDPD.Z m128 k xmm
//	VEXPANDPD.Z xmm  k xmm
//
// Construct and append a VEXPANDPD.Z instruction to the active function.
func (c *Context) VEXPANDPD_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VEXPANDPD_Z(mxyz, k, xyz))
}

// VEXPANDPD_Z: Load Sparse Packed Double-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPD.Z m256 k ymm
//	VEXPANDPD.Z ymm  k ymm
//	VEXPANDPD.Z m512 k zmm
//	VEXPANDPD.Z zmm  k zmm
//	VEXPANDPD.Z m128 k xmm
//	VEXPANDPD.Z xmm  k xmm
//
// Construct and append a VEXPANDPD.Z instruction to the active function.
// Operates on the global context.
func VEXPANDPD_Z(mxyz, k, xyz operand.Op) { ctx.VEXPANDPD_Z(mxyz, k, xyz) }

// VEXPANDPS: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPS m128 k xmm
//	VEXPANDPS m128 xmm
//	VEXPANDPS m256 k ymm
//	VEXPANDPS m256 ymm
//	VEXPANDPS xmm  k xmm
//	VEXPANDPS xmm  xmm
//	VEXPANDPS ymm  k ymm
//	VEXPANDPS ymm  ymm
//	VEXPANDPS m512 k zmm
//	VEXPANDPS m512 zmm
//	VEXPANDPS zmm  k zmm
//	VEXPANDPS zmm  zmm
//
// Construct and append a VEXPANDPS instruction to the active function.
func (c *Context) VEXPANDPS(ops ...operand.Op) {
	c.addinstruction(x86.VEXPANDPS(ops...))
}

// VEXPANDPS: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory.
//
// Forms:
//
//	VEXPANDPS m128 k xmm
//	VEXPANDPS m128 xmm
//	VEXPANDPS m256 k ymm
//	VEXPANDPS m256 ymm
//	VEXPANDPS xmm  k xmm
//	VEXPANDPS xmm  xmm
//	VEXPANDPS ymm  k ymm
//	VEXPANDPS ymm  ymm
//	VEXPANDPS m512 k zmm
//	VEXPANDPS m512 zmm
//	VEXPANDPS zmm  k zmm
//	VEXPANDPS zmm  zmm
//
// Construct and append a VEXPANDPS instruction to the active function.
// Operates on the global context.
func VEXPANDPS(ops ...operand.Op) { ctx.VEXPANDPS(ops...) }

// VEXPANDPS_Z: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPS.Z m128 k xmm
//	VEXPANDPS.Z m256 k ymm
//	VEXPANDPS.Z xmm  k xmm
//	VEXPANDPS.Z ymm  k ymm
//	VEXPANDPS.Z m512 k zmm
//	VEXPANDPS.Z zmm  k zmm
//
// Construct and append a VEXPANDPS.Z instruction to the active function.
func (c *Context) VEXPANDPS_Z(mxyz, k, xyz operand.Op) {
	c.addinstruction(x86.VEXPANDPS_Z(mxyz, k, xyz))
}

// VEXPANDPS_Z: Load Sparse Packed Single-Precision Floating-Point Values from Dense Memory (Zeroing Masking).
//
// Forms:
//
//	VEXPANDPS.Z m128 k xmm
//	VEXPANDPS.Z m256 k ymm
//	VEXPANDPS.Z xmm  k xmm
//	VEXPANDPS.Z ymm  k ymm
//	VEXPANDPS.Z m512 k zmm
//	VEXPANDPS.Z zmm  k zmm
//
// Construct and append a VEXPANDPS.Z instruction to the active function.
// Operates on the global context.
func VEXPANDPS_Z(mxyz, k, xyz operand.Op) { ctx.VEXPANDPS_Z(mxyz, k, xyz) }

// VEXTRACTF128: Extract Packed Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF128 imm8 ymm m128
//	VEXTRACTF128 imm8 ymm xmm
//
// Construct and append a VEXTRACTF128 instruction to the active function.
func (c *Context) VEXTRACTF128(i, y, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTF128(i, y, mx))
}

// VEXTRACTF128: Extract Packed Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF128 imm8 ymm m128
//	VEXTRACTF128 imm8 ymm xmm
//
// Construct and append a VEXTRACTF128 instruction to the active function.
// Operates on the global context.
func VEXTRACTF128(i, y, mx operand.Op) { ctx.VEXTRACTF128(i, y, mx) }

// VEXTRACTF32X4: Extract 128 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X4 imm8 ymm k m128
//	VEXTRACTF32X4 imm8 ymm k xmm
//	VEXTRACTF32X4 imm8 ymm m128
//	VEXTRACTF32X4 imm8 ymm xmm
//	VEXTRACTF32X4 imm8 zmm k m128
//	VEXTRACTF32X4 imm8 zmm k xmm
//	VEXTRACTF32X4 imm8 zmm m128
//	VEXTRACTF32X4 imm8 zmm xmm
//
// Construct and append a VEXTRACTF32X4 instruction to the active function.
func (c *Context) VEXTRACTF32X4(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTF32X4(ops...))
}

// VEXTRACTF32X4: Extract 128 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X4 imm8 ymm k m128
//	VEXTRACTF32X4 imm8 ymm k xmm
//	VEXTRACTF32X4 imm8 ymm m128
//	VEXTRACTF32X4 imm8 ymm xmm
//	VEXTRACTF32X4 imm8 zmm k m128
//	VEXTRACTF32X4 imm8 zmm k xmm
//	VEXTRACTF32X4 imm8 zmm m128
//	VEXTRACTF32X4 imm8 zmm xmm
//
// Construct and append a VEXTRACTF32X4 instruction to the active function.
// Operates on the global context.
func VEXTRACTF32X4(ops ...operand.Op) { ctx.VEXTRACTF32X4(ops...) }

// VEXTRACTF32X4_Z: Extract 128 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X4.Z imm8 ymm k m128
//	VEXTRACTF32X4.Z imm8 ymm k xmm
//	VEXTRACTF32X4.Z imm8 zmm k m128
//	VEXTRACTF32X4.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTF32X4.Z instruction to the active function.
func (c *Context) VEXTRACTF32X4_Z(i, yz, k, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTF32X4_Z(i, yz, k, mx))
}

// VEXTRACTF32X4_Z: Extract 128 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X4.Z imm8 ymm k m128
//	VEXTRACTF32X4.Z imm8 ymm k xmm
//	VEXTRACTF32X4.Z imm8 zmm k m128
//	VEXTRACTF32X4.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTF32X4.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTF32X4_Z(i, yz, k, mx operand.Op) { ctx.VEXTRACTF32X4_Z(i, yz, k, mx) }

// VEXTRACTF32X8: Extract 256 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X8 imm8 zmm k m256
//	VEXTRACTF32X8 imm8 zmm k ymm
//	VEXTRACTF32X8 imm8 zmm m256
//	VEXTRACTF32X8 imm8 zmm ymm
//
// Construct and append a VEXTRACTF32X8 instruction to the active function.
func (c *Context) VEXTRACTF32X8(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTF32X8(ops...))
}

// VEXTRACTF32X8: Extract 256 Bits of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF32X8 imm8 zmm k m256
//	VEXTRACTF32X8 imm8 zmm k ymm
//	VEXTRACTF32X8 imm8 zmm m256
//	VEXTRACTF32X8 imm8 zmm ymm
//
// Construct and append a VEXTRACTF32X8 instruction to the active function.
// Operates on the global context.
func VEXTRACTF32X8(ops ...operand.Op) { ctx.VEXTRACTF32X8(ops...) }

// VEXTRACTF32X8_Z: Extract 256 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X8.Z imm8 zmm k m256
//	VEXTRACTF32X8.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTF32X8.Z instruction to the active function.
func (c *Context) VEXTRACTF32X8_Z(i, z, k, my operand.Op) {
	c.addinstruction(x86.VEXTRACTF32X8_Z(i, z, k, my))
}

// VEXTRACTF32X8_Z: Extract 256 Bits of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF32X8.Z imm8 zmm k m256
//	VEXTRACTF32X8.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTF32X8.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTF32X8_Z(i, z, k, my operand.Op) { ctx.VEXTRACTF32X8_Z(i, z, k, my) }

// VEXTRACTF64X2: Extract 128 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X2 imm8 ymm k m128
//	VEXTRACTF64X2 imm8 ymm k xmm
//	VEXTRACTF64X2 imm8 ymm m128
//	VEXTRACTF64X2 imm8 ymm xmm
//	VEXTRACTF64X2 imm8 zmm k m128
//	VEXTRACTF64X2 imm8 zmm k xmm
//	VEXTRACTF64X2 imm8 zmm m128
//	VEXTRACTF64X2 imm8 zmm xmm
//
// Construct and append a VEXTRACTF64X2 instruction to the active function.
func (c *Context) VEXTRACTF64X2(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTF64X2(ops...))
}

// VEXTRACTF64X2: Extract 128 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X2 imm8 ymm k m128
//	VEXTRACTF64X2 imm8 ymm k xmm
//	VEXTRACTF64X2 imm8 ymm m128
//	VEXTRACTF64X2 imm8 ymm xmm
//	VEXTRACTF64X2 imm8 zmm k m128
//	VEXTRACTF64X2 imm8 zmm k xmm
//	VEXTRACTF64X2 imm8 zmm m128
//	VEXTRACTF64X2 imm8 zmm xmm
//
// Construct and append a VEXTRACTF64X2 instruction to the active function.
// Operates on the global context.
func VEXTRACTF64X2(ops ...operand.Op) { ctx.VEXTRACTF64X2(ops...) }

// VEXTRACTF64X2_Z: Extract 128 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X2.Z imm8 ymm k m128
//	VEXTRACTF64X2.Z imm8 ymm k xmm
//	VEXTRACTF64X2.Z imm8 zmm k m128
//	VEXTRACTF64X2.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTF64X2.Z instruction to the active function.
func (c *Context) VEXTRACTF64X2_Z(i, yz, k, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTF64X2_Z(i, yz, k, mx))
}

// VEXTRACTF64X2_Z: Extract 128 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X2.Z imm8 ymm k m128
//	VEXTRACTF64X2.Z imm8 ymm k xmm
//	VEXTRACTF64X2.Z imm8 zmm k m128
//	VEXTRACTF64X2.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTF64X2.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTF64X2_Z(i, yz, k, mx operand.Op) { ctx.VEXTRACTF64X2_Z(i, yz, k, mx) }

// VEXTRACTF64X4: Extract 256 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X4 imm8 zmm k m256
//	VEXTRACTF64X4 imm8 zmm k ymm
//	VEXTRACTF64X4 imm8 zmm m256
//	VEXTRACTF64X4 imm8 zmm ymm
//
// Construct and append a VEXTRACTF64X4 instruction to the active function.
func (c *Context) VEXTRACTF64X4(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTF64X4(ops...))
}

// VEXTRACTF64X4: Extract 256 Bits of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VEXTRACTF64X4 imm8 zmm k m256
//	VEXTRACTF64X4 imm8 zmm k ymm
//	VEXTRACTF64X4 imm8 zmm m256
//	VEXTRACTF64X4 imm8 zmm ymm
//
// Construct and append a VEXTRACTF64X4 instruction to the active function.
// Operates on the global context.
func VEXTRACTF64X4(ops ...operand.Op) { ctx.VEXTRACTF64X4(ops...) }

// VEXTRACTF64X4_Z: Extract 256 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X4.Z imm8 zmm k m256
//	VEXTRACTF64X4.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTF64X4.Z instruction to the active function.
func (c *Context) VEXTRACTF64X4_Z(i, z, k, my operand.Op) {
	c.addinstruction(x86.VEXTRACTF64X4_Z(i, z, k, my))
}

// VEXTRACTF64X4_Z: Extract 256 Bits of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTF64X4.Z imm8 zmm k m256
//	VEXTRACTF64X4.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTF64X4.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTF64X4_Z(i, z, k, my operand.Op) { ctx.VEXTRACTF64X4_Z(i, z, k, my) }

// VEXTRACTI128: Extract Packed Integer Values.
//
// Forms:
//
//	VEXTRACTI128 imm8 ymm m128
//	VEXTRACTI128 imm8 ymm xmm
//
// Construct and append a VEXTRACTI128 instruction to the active function.
func (c *Context) VEXTRACTI128(i, y, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTI128(i, y, mx))
}

// VEXTRACTI128: Extract Packed Integer Values.
//
// Forms:
//
//	VEXTRACTI128 imm8 ymm m128
//	VEXTRACTI128 imm8 ymm xmm
//
// Construct and append a VEXTRACTI128 instruction to the active function.
// Operates on the global context.
func VEXTRACTI128(i, y, mx operand.Op) { ctx.VEXTRACTI128(i, y, mx) }

// VEXTRACTI32X4: Extract 128 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X4 imm8 ymm k m128
//	VEXTRACTI32X4 imm8 ymm k xmm
//	VEXTRACTI32X4 imm8 ymm m128
//	VEXTRACTI32X4 imm8 ymm xmm
//	VEXTRACTI32X4 imm8 zmm k m128
//	VEXTRACTI32X4 imm8 zmm k xmm
//	VEXTRACTI32X4 imm8 zmm m128
//	VEXTRACTI32X4 imm8 zmm xmm
//
// Construct and append a VEXTRACTI32X4 instruction to the active function.
func (c *Context) VEXTRACTI32X4(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTI32X4(ops...))
}

// VEXTRACTI32X4: Extract 128 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X4 imm8 ymm k m128
//	VEXTRACTI32X4 imm8 ymm k xmm
//	VEXTRACTI32X4 imm8 ymm m128
//	VEXTRACTI32X4 imm8 ymm xmm
//	VEXTRACTI32X4 imm8 zmm k m128
//	VEXTRACTI32X4 imm8 zmm k xmm
//	VEXTRACTI32X4 imm8 zmm m128
//	VEXTRACTI32X4 imm8 zmm xmm
//
// Construct and append a VEXTRACTI32X4 instruction to the active function.
// Operates on the global context.
func VEXTRACTI32X4(ops ...operand.Op) { ctx.VEXTRACTI32X4(ops...) }

// VEXTRACTI32X4_Z: Extract 128 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X4.Z imm8 ymm k m128
//	VEXTRACTI32X4.Z imm8 ymm k xmm
//	VEXTRACTI32X4.Z imm8 zmm k m128
//	VEXTRACTI32X4.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTI32X4.Z instruction to the active function.
func (c *Context) VEXTRACTI32X4_Z(i, yz, k, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTI32X4_Z(i, yz, k, mx))
}

// VEXTRACTI32X4_Z: Extract 128 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X4.Z imm8 ymm k m128
//	VEXTRACTI32X4.Z imm8 ymm k xmm
//	VEXTRACTI32X4.Z imm8 zmm k m128
//	VEXTRACTI32X4.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTI32X4.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTI32X4_Z(i, yz, k, mx operand.Op) { ctx.VEXTRACTI32X4_Z(i, yz, k, mx) }

// VEXTRACTI32X8: Extract 256 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X8 imm8 zmm k m256
//	VEXTRACTI32X8 imm8 zmm k ymm
//	VEXTRACTI32X8 imm8 zmm m256
//	VEXTRACTI32X8 imm8 zmm ymm
//
// Construct and append a VEXTRACTI32X8 instruction to the active function.
func (c *Context) VEXTRACTI32X8(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTI32X8(ops...))
}

// VEXTRACTI32X8: Extract 256 Bits of Packed Doubleword Integer Values.
//
// Forms:
//
//	VEXTRACTI32X8 imm8 zmm k m256
//	VEXTRACTI32X8 imm8 zmm k ymm
//	VEXTRACTI32X8 imm8 zmm m256
//	VEXTRACTI32X8 imm8 zmm ymm
//
// Construct and append a VEXTRACTI32X8 instruction to the active function.
// Operates on the global context.
func VEXTRACTI32X8(ops ...operand.Op) { ctx.VEXTRACTI32X8(ops...) }

// VEXTRACTI32X8_Z: Extract 256 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X8.Z imm8 zmm k m256
//	VEXTRACTI32X8.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTI32X8.Z instruction to the active function.
func (c *Context) VEXTRACTI32X8_Z(i, z, k, my operand.Op) {
	c.addinstruction(x86.VEXTRACTI32X8_Z(i, z, k, my))
}

// VEXTRACTI32X8_Z: Extract 256 Bits of Packed Doubleword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI32X8.Z imm8 zmm k m256
//	VEXTRACTI32X8.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTI32X8.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTI32X8_Z(i, z, k, my operand.Op) { ctx.VEXTRACTI32X8_Z(i, z, k, my) }

// VEXTRACTI64X2: Extract 128 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X2 imm8 ymm k m128
//	VEXTRACTI64X2 imm8 ymm k xmm
//	VEXTRACTI64X2 imm8 ymm m128
//	VEXTRACTI64X2 imm8 ymm xmm
//	VEXTRACTI64X2 imm8 zmm k m128
//	VEXTRACTI64X2 imm8 zmm k xmm
//	VEXTRACTI64X2 imm8 zmm m128
//	VEXTRACTI64X2 imm8 zmm xmm
//
// Construct and append a VEXTRACTI64X2 instruction to the active function.
func (c *Context) VEXTRACTI64X2(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTI64X2(ops...))
}

// VEXTRACTI64X2: Extract 128 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X2 imm8 ymm k m128
//	VEXTRACTI64X2 imm8 ymm k xmm
//	VEXTRACTI64X2 imm8 ymm m128
//	VEXTRACTI64X2 imm8 ymm xmm
//	VEXTRACTI64X2 imm8 zmm k m128
//	VEXTRACTI64X2 imm8 zmm k xmm
//	VEXTRACTI64X2 imm8 zmm m128
//	VEXTRACTI64X2 imm8 zmm xmm
//
// Construct and append a VEXTRACTI64X2 instruction to the active function.
// Operates on the global context.
func VEXTRACTI64X2(ops ...operand.Op) { ctx.VEXTRACTI64X2(ops...) }

// VEXTRACTI64X2_Z: Extract 128 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X2.Z imm8 ymm k m128
//	VEXTRACTI64X2.Z imm8 ymm k xmm
//	VEXTRACTI64X2.Z imm8 zmm k m128
//	VEXTRACTI64X2.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTI64X2.Z instruction to the active function.
func (c *Context) VEXTRACTI64X2_Z(i, yz, k, mx operand.Op) {
	c.addinstruction(x86.VEXTRACTI64X2_Z(i, yz, k, mx))
}

// VEXTRACTI64X2_Z: Extract 128 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X2.Z imm8 ymm k m128
//	VEXTRACTI64X2.Z imm8 ymm k xmm
//	VEXTRACTI64X2.Z imm8 zmm k m128
//	VEXTRACTI64X2.Z imm8 zmm k xmm
//
// Construct and append a VEXTRACTI64X2.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTI64X2_Z(i, yz, k, mx operand.Op) { ctx.VEXTRACTI64X2_Z(i, yz, k, mx) }

// VEXTRACTI64X4: Extract 256 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X4 imm8 zmm k m256
//	VEXTRACTI64X4 imm8 zmm k ymm
//	VEXTRACTI64X4 imm8 zmm m256
//	VEXTRACTI64X4 imm8 zmm ymm
//
// Construct and append a VEXTRACTI64X4 instruction to the active function.
func (c *Context) VEXTRACTI64X4(ops ...operand.Op) {
	c.addinstruction(x86.VEXTRACTI64X4(ops...))
}

// VEXTRACTI64X4: Extract 256 Bits of Packed Quadword Integer Values.
//
// Forms:
//
//	VEXTRACTI64X4 imm8 zmm k m256
//	VEXTRACTI64X4 imm8 zmm k ymm
//	VEXTRACTI64X4 imm8 zmm m256
//	VEXTRACTI64X4 imm8 zmm ymm
//
// Construct and append a VEXTRACTI64X4 instruction to the active function.
// Operates on the global context.
func VEXTRACTI64X4(ops ...operand.Op) { ctx.VEXTRACTI64X4(ops...) }

// VEXTRACTI64X4_Z: Extract 256 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X4.Z imm8 zmm k m256
//	VEXTRACTI64X4.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTI64X4.Z instruction to the active function.
func (c *Context) VEXTRACTI64X4_Z(i, z, k, my operand.Op) {
	c.addinstruction(x86.VEXTRACTI64X4_Z(i, z, k, my))
}

// VEXTRACTI64X4_Z: Extract 256 Bits of Packed Quadword Integer Values (Zeroing Masking).
//
// Forms:
//
//	VEXTRACTI64X4.Z imm8 zmm k m256
//	VEXTRACTI64X4.Z imm8 zmm k ymm
//
// Construct and append a VEXTRACTI64X4.Z instruction to the active function.
// Operates on the global context.
func VEXTRACTI64X4_Z(i, z, k, my operand.Op) { ctx.VEXTRACTI64X4_Z(i, z, k, my) }

// VEXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	VEXTRACTPS imm8 xmm m32
//	VEXTRACTPS imm8 xmm r32
//
// Construct and append a VEXTRACTPS instruction to the active function.
func (c *Context) VEXTRACTPS(i, x, mr operand.Op) {
	c.addinstruction(x86.VEXTRACTPS(i, x, mr))
}

// VEXTRACTPS: Extract Packed Single Precision Floating-Point Value.
//
// Forms:
//
//	VEXTRACTPS imm8 xmm m32
//	VEXTRACTPS imm8 xmm r32
//
// Construct and append a VEXTRACTPS instruction to the active function.
// Operates on the global context.
func VEXTRACTPS(i, x, mr operand.Op) { ctx.VEXTRACTPS(i, x, mr) }

// VFIXUPIMMPD: Fix Up Special Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPD imm8 m128 xmm k xmm
//	VFIXUPIMMPD imm8 m128 xmm xmm
//	VFIXUPIMMPD imm8 m256 ymm k ymm
//	VFIXUPIMMPD imm8 m256 ymm ymm
//	VFIXUPIMMPD imm8 xmm  xmm k xmm
//	VFIXUPIMMPD imm8 xmm  xmm xmm
//	VFIXUPIMMPD imm8 ymm  ymm k ymm
//	VFIXUPIMMPD imm8 ymm  ymm ymm
//	VFIXUPIMMPD imm8 m512 zmm k zmm
//	VFIXUPIMMPD imm8 m512 zmm zmm
//	VFIXUPIMMPD imm8 zmm  zmm k zmm
//	VFIXUPIMMPD imm8 zmm  zmm zmm
//
// Construct and append a VFIXUPIMMPD instruction to the active function.
func (c *Context) VFIXUPIMMPD(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD(ops...))
}

// VFIXUPIMMPD: Fix Up Special Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPD imm8 m128 xmm k xmm
//	VFIXUPIMMPD imm8 m128 xmm xmm
//	VFIXUPIMMPD imm8 m256 ymm k ymm
//	VFIXUPIMMPD imm8 m256 ymm ymm
//	VFIXUPIMMPD imm8 xmm  xmm k xmm
//	VFIXUPIMMPD imm8 xmm  xmm xmm
//	VFIXUPIMMPD imm8 ymm  ymm k ymm
//	VFIXUPIMMPD imm8 ymm  ymm ymm
//	VFIXUPIMMPD imm8 m512 zmm k zmm
//	VFIXUPIMMPD imm8 m512 zmm zmm
//	VFIXUPIMMPD imm8 zmm  zmm k zmm
//	VFIXUPIMMPD imm8 zmm  zmm zmm
//
// Construct and append a VFIXUPIMMPD instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD(ops ...operand.Op) { ctx.VFIXUPIMMPD(ops...) }

// VFIXUPIMMPD_BCST: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPD.BCST imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST imm8 m64 xmm xmm
//	VFIXUPIMMPD.BCST imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST imm8 m64 ymm ymm
//	VFIXUPIMMPD.BCST imm8 m64 zmm k zmm
//	VFIXUPIMMPD.BCST imm8 m64 zmm zmm
//
// Construct and append a VFIXUPIMMPD.BCST instruction to the active function.
func (c *Context) VFIXUPIMMPD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD_BCST(ops...))
}

// VFIXUPIMMPD_BCST: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPD.BCST imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST imm8 m64 xmm xmm
//	VFIXUPIMMPD.BCST imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST imm8 m64 ymm ymm
//	VFIXUPIMMPD.BCST imm8 m64 zmm k zmm
//	VFIXUPIMMPD.BCST imm8 m64 zmm zmm
//
// Construct and append a VFIXUPIMMPD.BCST instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD_BCST(ops ...operand.Op) { ctx.VFIXUPIMMPD_BCST(ops...) }

// VFIXUPIMMPD_BCST_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.BCST.Z imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST.Z imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST.Z imm8 m64 zmm k zmm
//
// Construct and append a VFIXUPIMMPD.BCST.Z instruction to the active function.
func (c *Context) VFIXUPIMMPD_BCST_Z(i, m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD_BCST_Z(i, m, xyz, k, xyz1))
}

// VFIXUPIMMPD_BCST_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.BCST.Z imm8 m64 xmm k xmm
//	VFIXUPIMMPD.BCST.Z imm8 m64 ymm k ymm
//	VFIXUPIMMPD.BCST.Z imm8 m64 zmm k zmm
//
// Construct and append a VFIXUPIMMPD.BCST.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD_BCST_Z(i, m, xyz, k, xyz1 operand.Op) { ctx.VFIXUPIMMPD_BCST_Z(i, m, xyz, k, xyz1) }

// VFIXUPIMMPD_SAE: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPD.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPD.SAE imm8 zmm zmm zmm
//
// Construct and append a VFIXUPIMMPD.SAE instruction to the active function.
func (c *Context) VFIXUPIMMPD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD_SAE(ops...))
}

// VFIXUPIMMPD_SAE: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPD.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPD.SAE imm8 zmm zmm zmm
//
// Construct and append a VFIXUPIMMPD.SAE instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD_SAE(ops ...operand.Op) { ctx.VFIXUPIMMPD_SAE(ops...) }

// VFIXUPIMMPD_SAE_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.SAE.Z imm8 zmm zmm k zmm
//
// Construct and append a VFIXUPIMMPD.SAE.Z instruction to the active function.
func (c *Context) VFIXUPIMMPD_SAE_Z(i, z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD_SAE_Z(i, z, z1, k, z2))
}

// VFIXUPIMMPD_SAE_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.SAE.Z imm8 zmm zmm k zmm
//
// Construct and append a VFIXUPIMMPD.SAE.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD_SAE_Z(i, z, z1, k, z2 operand.Op) { ctx.VFIXUPIMMPD_SAE_Z(i, z, z1, k, z2) }

// VFIXUPIMMPD_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPD.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPD.Z imm8 xmm  xmm k xmm
//	VFIXUPIMMPD.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPD.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPD.Z imm8 zmm  zmm k zmm
//
// Construct and append a VFIXUPIMMPD.Z instruction to the active function.
func (c *Context) VFIXUPIMMPD_Z(i, mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPD_Z(i, mxyz, xyz, k, xyz1))
}

// VFIXUPIMMPD_Z: Fix Up Special Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPD.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPD.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPD.Z imm8 xmm  xmm k xmm
//	VFIXUPIMMPD.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPD.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPD.Z imm8 zmm  zmm k zmm
//
// Construct and append a VFIXUPIMMPD.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPD_Z(i, mxyz, xyz, k, xyz1 operand.Op) { ctx.VFIXUPIMMPD_Z(i, mxyz, xyz, k, xyz1) }

// VFIXUPIMMPS: Fix Up Special Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPS imm8 m256 ymm k ymm
//	VFIXUPIMMPS imm8 m256 ymm ymm
//	VFIXUPIMMPS imm8 ymm  ymm k ymm
//	VFIXUPIMMPS imm8 ymm  ymm ymm
//	VFIXUPIMMPS imm8 m512 zmm k zmm
//	VFIXUPIMMPS imm8 m512 zmm zmm
//	VFIXUPIMMPS imm8 zmm  zmm k zmm
//	VFIXUPIMMPS imm8 zmm  zmm zmm
//	VFIXUPIMMPS imm8 m128 xmm k xmm
//	VFIXUPIMMPS imm8 m128 xmm xmm
//	VFIXUPIMMPS imm8 xmm  xmm k xmm
//	VFIXUPIMMPS imm8 xmm  xmm xmm
//
// Construct and append a VFIXUPIMMPS instruction to the active function.
func (c *Context) VFIXUPIMMPS(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS(ops...))
}

// VFIXUPIMMPS: Fix Up Special Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFIXUPIMMPS imm8 m256 ymm k ymm
//	VFIXUPIMMPS imm8 m256 ymm ymm
//	VFIXUPIMMPS imm8 ymm  ymm k ymm
//	VFIXUPIMMPS imm8 ymm  ymm ymm
//	VFIXUPIMMPS imm8 m512 zmm k zmm
//	VFIXUPIMMPS imm8 m512 zmm zmm
//	VFIXUPIMMPS imm8 zmm  zmm k zmm
//	VFIXUPIMMPS imm8 zmm  zmm zmm
//	VFIXUPIMMPS imm8 m128 xmm k xmm
//	VFIXUPIMMPS imm8 m128 xmm xmm
//	VFIXUPIMMPS imm8 xmm  xmm k xmm
//	VFIXUPIMMPS imm8 xmm  xmm xmm
//
// Construct and append a VFIXUPIMMPS instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS(ops ...operand.Op) { ctx.VFIXUPIMMPS(ops...) }

// VFIXUPIMMPS_BCST: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPS.BCST imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST imm8 m32 ymm ymm
//	VFIXUPIMMPS.BCST imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST imm8 m32 zmm zmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm k xmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm xmm
//
// Construct and append a VFIXUPIMMPS.BCST instruction to the active function.
func (c *Context) VFIXUPIMMPS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS_BCST(ops...))
}

// VFIXUPIMMPS_BCST: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFIXUPIMMPS.BCST imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST imm8 m32 ymm ymm
//	VFIXUPIMMPS.BCST imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST imm8 m32 zmm zmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm k xmm
//	VFIXUPIMMPS.BCST imm8 m32 xmm xmm
//
// Construct and append a VFIXUPIMMPS.BCST instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS_BCST(ops ...operand.Op) { ctx.VFIXUPIMMPS_BCST(ops...) }

// VFIXUPIMMPS_BCST_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.BCST.Z imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST.Z imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST.Z imm8 m32 xmm k xmm
//
// Construct and append a VFIXUPIMMPS.BCST.Z instruction to the active function.
func (c *Context) VFIXUPIMMPS_BCST_Z(i, m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS_BCST_Z(i, m, xyz, k, xyz1))
}

// VFIXUPIMMPS_BCST_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.BCST.Z imm8 m32 ymm k ymm
//	VFIXUPIMMPS.BCST.Z imm8 m32 zmm k zmm
//	VFIXUPIMMPS.BCST.Z imm8 m32 xmm k xmm
//
// Construct and append a VFIXUPIMMPS.BCST.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS_BCST_Z(i, m, xyz, k, xyz1 operand.Op) { ctx.VFIXUPIMMPS_BCST_Z(i, m, xyz, k, xyz1) }

// VFIXUPIMMPS_SAE: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPS.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPS.SAE imm8 zmm zmm zmm
//
// Construct and append a VFIXUPIMMPS.SAE instruction to the active function.
func (c *Context) VFIXUPIMMPS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS_SAE(ops...))
}

// VFIXUPIMMPS_SAE: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMPS.SAE imm8 zmm zmm k zmm
//	VFIXUPIMMPS.SAE imm8 zmm zmm zmm
//
// Construct and append a VFIXUPIMMPS.SAE instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS_SAE(ops ...operand.Op) { ctx.VFIXUPIMMPS_SAE(ops...) }

// VFIXUPIMMPS_SAE_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.SAE.Z imm8 zmm zmm k zmm
//
// Construct and append a VFIXUPIMMPS.SAE.Z instruction to the active function.
func (c *Context) VFIXUPIMMPS_SAE_Z(i, z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS_SAE_Z(i, z, z1, k, z2))
}

// VFIXUPIMMPS_SAE_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.SAE.Z imm8 zmm zmm k zmm
//
// Construct and append a VFIXUPIMMPS.SAE.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS_SAE_Z(i, z, z1, k, z2 operand.Op) { ctx.VFIXUPIMMPS_SAE_Z(i, z, z1, k, z2) }

// VFIXUPIMMPS_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPS.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPS.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPS.Z imm8 zmm  zmm k zmm
//	VFIXUPIMMPS.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPS.Z imm8 xmm  xmm k xmm
//
// Construct and append a VFIXUPIMMPS.Z instruction to the active function.
func (c *Context) VFIXUPIMMPS_Z(i, mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMPS_Z(i, mxyz, xyz, k, xyz1))
}

// VFIXUPIMMPS_Z: Fix Up Special Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMPS.Z imm8 m256 ymm k ymm
//	VFIXUPIMMPS.Z imm8 ymm  ymm k ymm
//	VFIXUPIMMPS.Z imm8 m512 zmm k zmm
//	VFIXUPIMMPS.Z imm8 zmm  zmm k zmm
//	VFIXUPIMMPS.Z imm8 m128 xmm k xmm
//	VFIXUPIMMPS.Z imm8 xmm  xmm k xmm
//
// Construct and append a VFIXUPIMMPS.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMPS_Z(i, mxyz, xyz, k, xyz1 operand.Op) { ctx.VFIXUPIMMPS_Z(i, mxyz, xyz, k, xyz1) }

// VFIXUPIMMSD: Fix Up Special Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSD imm8 m64 xmm k xmm
//	VFIXUPIMMSD imm8 m64 xmm xmm
//	VFIXUPIMMSD imm8 xmm xmm k xmm
//	VFIXUPIMMSD imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSD instruction to the active function.
func (c *Context) VFIXUPIMMSD(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSD(ops...))
}

// VFIXUPIMMSD: Fix Up Special Scalar Double-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSD imm8 m64 xmm k xmm
//	VFIXUPIMMSD imm8 m64 xmm xmm
//	VFIXUPIMMSD imm8 xmm xmm k xmm
//	VFIXUPIMMSD imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSD instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSD(ops ...operand.Op) { ctx.VFIXUPIMMSD(ops...) }

// VFIXUPIMMSD_SAE: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSD.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSD.SAE imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSD.SAE instruction to the active function.
func (c *Context) VFIXUPIMMSD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSD_SAE(ops...))
}

// VFIXUPIMMSD_SAE: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSD.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSD.SAE imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSD.SAE instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSD_SAE(ops ...operand.Op) { ctx.VFIXUPIMMSD_SAE(ops...) }

// VFIXUPIMMSD_SAE_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.SAE.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSD.SAE.Z instruction to the active function.
func (c *Context) VFIXUPIMMSD_SAE_Z(i, x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSD_SAE_Z(i, x, x1, k, x2))
}

// VFIXUPIMMSD_SAE_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.SAE.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSD.SAE.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSD_SAE_Z(i, x, x1, k, x2 operand.Op) { ctx.VFIXUPIMMSD_SAE_Z(i, x, x1, k, x2) }

// VFIXUPIMMSD_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.Z imm8 m64 xmm k xmm
//	VFIXUPIMMSD.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSD.Z instruction to the active function.
func (c *Context) VFIXUPIMMSD_Z(i, mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSD_Z(i, mx, x, k, x1))
}

// VFIXUPIMMSD_Z: Fix Up Special Scalar Double-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSD.Z imm8 m64 xmm k xmm
//	VFIXUPIMMSD.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSD.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSD_Z(i, mx, x, k, x1 operand.Op) { ctx.VFIXUPIMMSD_Z(i, mx, x, k, x1) }

// VFIXUPIMMSS: Fix Up Special Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSS imm8 m32 xmm k xmm
//	VFIXUPIMMSS imm8 m32 xmm xmm
//	VFIXUPIMMSS imm8 xmm xmm k xmm
//	VFIXUPIMMSS imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSS instruction to the active function.
func (c *Context) VFIXUPIMMSS(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSS(ops...))
}

// VFIXUPIMMSS: Fix Up Special Scalar Single-Precision Floating-Point Value.
//
// Forms:
//
//	VFIXUPIMMSS imm8 m32 xmm k xmm
//	VFIXUPIMMSS imm8 m32 xmm xmm
//	VFIXUPIMMSS imm8 xmm xmm k xmm
//	VFIXUPIMMSS imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSS instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSS(ops ...operand.Op) { ctx.VFIXUPIMMSS(ops...) }

// VFIXUPIMMSS_SAE: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSS.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSS.SAE imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSS.SAE instruction to the active function.
func (c *Context) VFIXUPIMMSS_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSS_SAE(ops...))
}

// VFIXUPIMMSS_SAE: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions).
//
// Forms:
//
//	VFIXUPIMMSS.SAE imm8 xmm xmm k xmm
//	VFIXUPIMMSS.SAE imm8 xmm xmm xmm
//
// Construct and append a VFIXUPIMMSS.SAE instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSS_SAE(ops ...operand.Op) { ctx.VFIXUPIMMSS_SAE(ops...) }

// VFIXUPIMMSS_SAE_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.SAE.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSS.SAE.Z instruction to the active function.
func (c *Context) VFIXUPIMMSS_SAE_Z(i, x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSS_SAE_Z(i, x, x1, k, x2))
}

// VFIXUPIMMSS_SAE_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Suppress All Exceptions, Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.SAE.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSS.SAE.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSS_SAE_Z(i, x, x1, k, x2 operand.Op) { ctx.VFIXUPIMMSS_SAE_Z(i, x, x1, k, x2) }

// VFIXUPIMMSS_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.Z imm8 m32 xmm k xmm
//	VFIXUPIMMSS.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSS.Z instruction to the active function.
func (c *Context) VFIXUPIMMSS_Z(i, mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFIXUPIMMSS_Z(i, mx, x, k, x1))
}

// VFIXUPIMMSS_Z: Fix Up Special Scalar Single-Precision Floating-Point Value (Zeroing Masking).
//
// Forms:
//
//	VFIXUPIMMSS.Z imm8 m32 xmm k xmm
//	VFIXUPIMMSS.Z imm8 xmm xmm k xmm
//
// Construct and append a VFIXUPIMMSS.Z instruction to the active function.
// Operates on the global context.
func VFIXUPIMMSS_Z(i, mx, x, k, x1 operand.Op) { ctx.VFIXUPIMMSS_Z(i, mx, x, k, x1) }

// VFMADD132PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PD m128 xmm xmm
//	VFMADD132PD m256 ymm ymm
//	VFMADD132PD xmm  xmm xmm
//	VFMADD132PD ymm  ymm ymm
//	VFMADD132PD m128 xmm k xmm
//	VFMADD132PD m256 ymm k ymm
//	VFMADD132PD xmm  xmm k xmm
//	VFMADD132PD ymm  ymm k ymm
//	VFMADD132PD m512 zmm k zmm
//	VFMADD132PD m512 zmm zmm
//	VFMADD132PD zmm  zmm k zmm
//	VFMADD132PD zmm  zmm zmm
//
// Construct and append a VFMADD132PD instruction to the active function.
func (c *Context) VFMADD132PD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD(ops...))
}

// VFMADD132PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PD m128 xmm xmm
//	VFMADD132PD m256 ymm ymm
//	VFMADD132PD xmm  xmm xmm
//	VFMADD132PD ymm  ymm ymm
//	VFMADD132PD m128 xmm k xmm
//	VFMADD132PD m256 ymm k ymm
//	VFMADD132PD xmm  xmm k xmm
//	VFMADD132PD ymm  ymm k ymm
//	VFMADD132PD m512 zmm k zmm
//	VFMADD132PD m512 zmm zmm
//	VFMADD132PD zmm  zmm k zmm
//	VFMADD132PD zmm  zmm zmm
//
// Construct and append a VFMADD132PD instruction to the active function.
// Operates on the global context.
func VFMADD132PD(ops ...operand.Op) { ctx.VFMADD132PD(ops...) }

// VFMADD132PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PD.BCST m64 xmm k xmm
//	VFMADD132PD.BCST m64 xmm xmm
//	VFMADD132PD.BCST m64 ymm k ymm
//	VFMADD132PD.BCST m64 ymm ymm
//	VFMADD132PD.BCST m64 zmm k zmm
//	VFMADD132PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD132PD.BCST instruction to the active function.
func (c *Context) VFMADD132PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD_BCST(ops...))
}

// VFMADD132PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PD.BCST m64 xmm k xmm
//	VFMADD132PD.BCST m64 xmm xmm
//	VFMADD132PD.BCST m64 ymm k ymm
//	VFMADD132PD.BCST m64 ymm ymm
//	VFMADD132PD.BCST m64 zmm k zmm
//	VFMADD132PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD132PD.BCST instruction to the active function.
// Operates on the global context.
func VFMADD132PD_BCST(ops ...operand.Op) { ctx.VFMADD132PD_BCST(ops...) }

// VFMADD132PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.BCST.Z m64 xmm k xmm
//	VFMADD132PD.BCST.Z m64 ymm k ymm
//	VFMADD132PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD132PD.BCST.Z instruction to the active function.
func (c *Context) VFMADD132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD132PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.BCST.Z m64 xmm k xmm
//	VFMADD132PD.BCST.Z m64 ymm k ymm
//	VFMADD132PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD132PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD132PD_BCST_Z(m, xyz, k, xyz1) }

// VFMADD132PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PD.RD_SAE zmm zmm k zmm
//	VFMADD132PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RD_SAE instruction to the active function.
func (c *Context) VFMADD132PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RD_SAE(ops...))
}

// VFMADD132PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PD.RD_SAE zmm zmm k zmm
//	VFMADD132PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RD_SAE(ops ...operand.Op) { ctx.VFMADD132PD_RD_SAE(ops...) }

// VFMADD132PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD132PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PD_RD_SAE_Z(z, z1, k, z2) }

// VFMADD132PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PD.RN_SAE zmm zmm k zmm
//	VFMADD132PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RN_SAE instruction to the active function.
func (c *Context) VFMADD132PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RN_SAE(ops...))
}

// VFMADD132PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PD.RN_SAE zmm zmm k zmm
//	VFMADD132PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RN_SAE(ops ...operand.Op) { ctx.VFMADD132PD_RN_SAE(ops...) }

// VFMADD132PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD132PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PD_RN_SAE_Z(z, z1, k, z2) }

// VFMADD132PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PD.RU_SAE zmm zmm k zmm
//	VFMADD132PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RU_SAE instruction to the active function.
func (c *Context) VFMADD132PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RU_SAE(ops...))
}

// VFMADD132PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PD.RU_SAE zmm zmm k zmm
//	VFMADD132PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RU_SAE(ops ...operand.Op) { ctx.VFMADD132PD_RU_SAE(ops...) }

// VFMADD132PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD132PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PD_RU_SAE_Z(z, z1, k, z2) }

// VFMADD132PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE zmm zmm k zmm
//	VFMADD132PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD132PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RZ_SAE(ops...))
}

// VFMADD132PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE zmm zmm k zmm
//	VFMADD132PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD132PD_RZ_SAE(ops...) }

// VFMADD132PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD132PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PD_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD132PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.Z m128 xmm k xmm
//	VFMADD132PD.Z m256 ymm k ymm
//	VFMADD132PD.Z xmm  xmm k xmm
//	VFMADD132PD.Z ymm  ymm k ymm
//	VFMADD132PD.Z m512 zmm k zmm
//	VFMADD132PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD132PD.Z instruction to the active function.
func (c *Context) VFMADD132PD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD132PD_Z(mxyz, xyz, k, xyz1))
}

// VFMADD132PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PD.Z m128 xmm k xmm
//	VFMADD132PD.Z m256 ymm k ymm
//	VFMADD132PD.Z xmm  xmm k xmm
//	VFMADD132PD.Z ymm  ymm k ymm
//	VFMADD132PD.Z m512 zmm k zmm
//	VFMADD132PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD132PD.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD132PD_Z(mxyz, xyz, k, xyz1) }

// VFMADD132PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PS m128 xmm xmm
//	VFMADD132PS m256 ymm ymm
//	VFMADD132PS xmm  xmm xmm
//	VFMADD132PS ymm  ymm ymm
//	VFMADD132PS m128 xmm k xmm
//	VFMADD132PS m256 ymm k ymm
//	VFMADD132PS xmm  xmm k xmm
//	VFMADD132PS ymm  ymm k ymm
//	VFMADD132PS m512 zmm k zmm
//	VFMADD132PS m512 zmm zmm
//	VFMADD132PS zmm  zmm k zmm
//	VFMADD132PS zmm  zmm zmm
//
// Construct and append a VFMADD132PS instruction to the active function.
func (c *Context) VFMADD132PS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS(ops...))
}

// VFMADD132PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132PS m128 xmm xmm
//	VFMADD132PS m256 ymm ymm
//	VFMADD132PS xmm  xmm xmm
//	VFMADD132PS ymm  ymm ymm
//	VFMADD132PS m128 xmm k xmm
//	VFMADD132PS m256 ymm k ymm
//	VFMADD132PS xmm  xmm k xmm
//	VFMADD132PS ymm  ymm k ymm
//	VFMADD132PS m512 zmm k zmm
//	VFMADD132PS m512 zmm zmm
//	VFMADD132PS zmm  zmm k zmm
//	VFMADD132PS zmm  zmm zmm
//
// Construct and append a VFMADD132PS instruction to the active function.
// Operates on the global context.
func VFMADD132PS(ops ...operand.Op) { ctx.VFMADD132PS(ops...) }

// VFMADD132PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PS.BCST m32 xmm k xmm
//	VFMADD132PS.BCST m32 xmm xmm
//	VFMADD132PS.BCST m32 ymm k ymm
//	VFMADD132PS.BCST m32 ymm ymm
//	VFMADD132PS.BCST m32 zmm k zmm
//	VFMADD132PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD132PS.BCST instruction to the active function.
func (c *Context) VFMADD132PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS_BCST(ops...))
}

// VFMADD132PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD132PS.BCST m32 xmm k xmm
//	VFMADD132PS.BCST m32 xmm xmm
//	VFMADD132PS.BCST m32 ymm k ymm
//	VFMADD132PS.BCST m32 ymm ymm
//	VFMADD132PS.BCST m32 zmm k zmm
//	VFMADD132PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD132PS.BCST instruction to the active function.
// Operates on the global context.
func VFMADD132PS_BCST(ops ...operand.Op) { ctx.VFMADD132PS_BCST(ops...) }

// VFMADD132PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.BCST.Z m32 xmm k xmm
//	VFMADD132PS.BCST.Z m32 ymm k ymm
//	VFMADD132PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD132PS.BCST.Z instruction to the active function.
func (c *Context) VFMADD132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD132PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.BCST.Z m32 xmm k xmm
//	VFMADD132PS.BCST.Z m32 ymm k ymm
//	VFMADD132PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD132PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD132PS_BCST_Z(m, xyz, k, xyz1) }

// VFMADD132PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PS.RD_SAE zmm zmm k zmm
//	VFMADD132PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RD_SAE instruction to the active function.
func (c *Context) VFMADD132PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RD_SAE(ops...))
}

// VFMADD132PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132PS.RD_SAE zmm zmm k zmm
//	VFMADD132PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RD_SAE(ops ...operand.Op) { ctx.VFMADD132PS_RD_SAE(ops...) }

// VFMADD132PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD132PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PS_RD_SAE_Z(z, z1, k, z2) }

// VFMADD132PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PS.RN_SAE zmm zmm k zmm
//	VFMADD132PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RN_SAE instruction to the active function.
func (c *Context) VFMADD132PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RN_SAE(ops...))
}

// VFMADD132PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132PS.RN_SAE zmm zmm k zmm
//	VFMADD132PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RN_SAE(ops ...operand.Op) { ctx.VFMADD132PS_RN_SAE(ops...) }

// VFMADD132PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD132PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PS_RN_SAE_Z(z, z1, k, z2) }

// VFMADD132PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PS.RU_SAE zmm zmm k zmm
//	VFMADD132PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RU_SAE instruction to the active function.
func (c *Context) VFMADD132PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RU_SAE(ops...))
}

// VFMADD132PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132PS.RU_SAE zmm zmm k zmm
//	VFMADD132PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RU_SAE(ops ...operand.Op) { ctx.VFMADD132PS_RU_SAE(ops...) }

// VFMADD132PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD132PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PS_RU_SAE_Z(z, z1, k, z2) }

// VFMADD132PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE zmm zmm k zmm
//	VFMADD132PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD132PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RZ_SAE(ops...))
}

// VFMADD132PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE zmm zmm k zmm
//	VFMADD132PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD132PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD132PS_RZ_SAE(ops...) }

// VFMADD132PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD132PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD132PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD132PS_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD132PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.Z m128 xmm k xmm
//	VFMADD132PS.Z m256 ymm k ymm
//	VFMADD132PS.Z xmm  xmm k xmm
//	VFMADD132PS.Z ymm  ymm k ymm
//	VFMADD132PS.Z m512 zmm k zmm
//	VFMADD132PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD132PS.Z instruction to the active function.
func (c *Context) VFMADD132PS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD132PS_Z(mxyz, xyz, k, xyz1))
}

// VFMADD132PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132PS.Z m128 xmm k xmm
//	VFMADD132PS.Z m256 ymm k ymm
//	VFMADD132PS.Z xmm  xmm k xmm
//	VFMADD132PS.Z ymm  ymm k ymm
//	VFMADD132PS.Z m512 zmm k zmm
//	VFMADD132PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD132PS.Z instruction to the active function.
// Operates on the global context.
func VFMADD132PS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD132PS_Z(mxyz, xyz, k, xyz1) }

// VFMADD132SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SD m64 xmm xmm
//	VFMADD132SD xmm xmm xmm
//	VFMADD132SD m64 xmm k xmm
//	VFMADD132SD xmm xmm k xmm
//
// Construct and append a VFMADD132SD instruction to the active function.
func (c *Context) VFMADD132SD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SD(ops...))
}

// VFMADD132SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SD m64 xmm xmm
//	VFMADD132SD xmm xmm xmm
//	VFMADD132SD m64 xmm k xmm
//	VFMADD132SD xmm xmm k xmm
//
// Construct and append a VFMADD132SD instruction to the active function.
// Operates on the global context.
func VFMADD132SD(ops ...operand.Op) { ctx.VFMADD132SD(ops...) }

// VFMADD132SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SD.RD_SAE xmm xmm k xmm
//	VFMADD132SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RD_SAE instruction to the active function.
func (c *Context) VFMADD132SD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RD_SAE(ops...))
}

// VFMADD132SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SD.RD_SAE xmm xmm k xmm
//	VFMADD132SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RD_SAE(ops ...operand.Op) { ctx.VFMADD132SD_RD_SAE(ops...) }

// VFMADD132SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD132SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SD_RD_SAE_Z(x, x1, k, x2) }

// VFMADD132SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SD.RN_SAE xmm xmm k xmm
//	VFMADD132SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RN_SAE instruction to the active function.
func (c *Context) VFMADD132SD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RN_SAE(ops...))
}

// VFMADD132SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SD.RN_SAE xmm xmm k xmm
//	VFMADD132SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RN_SAE(ops ...operand.Op) { ctx.VFMADD132SD_RN_SAE(ops...) }

// VFMADD132SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD132SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SD_RN_SAE_Z(x, x1, k, x2) }

// VFMADD132SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SD.RU_SAE xmm xmm k xmm
//	VFMADD132SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RU_SAE instruction to the active function.
func (c *Context) VFMADD132SD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RU_SAE(ops...))
}

// VFMADD132SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SD.RU_SAE xmm xmm k xmm
//	VFMADD132SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RU_SAE(ops ...operand.Op) { ctx.VFMADD132SD_RU_SAE(ops...) }

// VFMADD132SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD132SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SD_RU_SAE_Z(x, x1, k, x2) }

// VFMADD132SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE xmm xmm k xmm
//	VFMADD132SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD132SD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RZ_SAE(ops...))
}

// VFMADD132SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE xmm xmm k xmm
//	VFMADD132SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD132SD_RZ_SAE(ops...) }

// VFMADD132SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SD_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD132SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SD_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD132SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.Z m64 xmm k xmm
//	VFMADD132SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.Z instruction to the active function.
func (c *Context) VFMADD132SD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD132SD_Z(mx, x, k, x1))
}

// VFMADD132SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SD.Z m64 xmm k xmm
//	VFMADD132SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SD.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SD_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD132SD_Z(mx, x, k, x1) }

// VFMADD132SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SS m32 xmm xmm
//	VFMADD132SS xmm xmm xmm
//	VFMADD132SS m32 xmm k xmm
//	VFMADD132SS xmm xmm k xmm
//
// Construct and append a VFMADD132SS instruction to the active function.
func (c *Context) VFMADD132SS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SS(ops...))
}

// VFMADD132SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD132SS m32 xmm xmm
//	VFMADD132SS xmm xmm xmm
//	VFMADD132SS m32 xmm k xmm
//	VFMADD132SS xmm xmm k xmm
//
// Construct and append a VFMADD132SS instruction to the active function.
// Operates on the global context.
func VFMADD132SS(ops ...operand.Op) { ctx.VFMADD132SS(ops...) }

// VFMADD132SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SS.RD_SAE xmm xmm k xmm
//	VFMADD132SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RD_SAE instruction to the active function.
func (c *Context) VFMADD132SS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RD_SAE(ops...))
}

// VFMADD132SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD132SS.RD_SAE xmm xmm k xmm
//	VFMADD132SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RD_SAE(ops ...operand.Op) { ctx.VFMADD132SS_RD_SAE(ops...) }

// VFMADD132SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD132SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SS_RD_SAE_Z(x, x1, k, x2) }

// VFMADD132SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SS.RN_SAE xmm xmm k xmm
//	VFMADD132SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RN_SAE instruction to the active function.
func (c *Context) VFMADD132SS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RN_SAE(ops...))
}

// VFMADD132SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD132SS.RN_SAE xmm xmm k xmm
//	VFMADD132SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RN_SAE(ops ...operand.Op) { ctx.VFMADD132SS_RN_SAE(ops...) }

// VFMADD132SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD132SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SS_RN_SAE_Z(x, x1, k, x2) }

// VFMADD132SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SS.RU_SAE xmm xmm k xmm
//	VFMADD132SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RU_SAE instruction to the active function.
func (c *Context) VFMADD132SS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RU_SAE(ops...))
}

// VFMADD132SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD132SS.RU_SAE xmm xmm k xmm
//	VFMADD132SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RU_SAE(ops ...operand.Op) { ctx.VFMADD132SS_RU_SAE(ops...) }

// VFMADD132SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD132SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SS_RU_SAE_Z(x, x1, k, x2) }

// VFMADD132SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE xmm xmm k xmm
//	VFMADD132SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD132SS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RZ_SAE(ops...))
}

// VFMADD132SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE xmm xmm k xmm
//	VFMADD132SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD132SS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD132SS_RZ_SAE(ops...) }

// VFMADD132SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD132SS_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD132SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD132SS_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD132SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.Z m32 xmm k xmm
//	VFMADD132SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.Z instruction to the active function.
func (c *Context) VFMADD132SS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD132SS_Z(mx, x, k, x1))
}

// VFMADD132SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD132SS.Z m32 xmm k xmm
//	VFMADD132SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD132SS.Z instruction to the active function.
// Operates on the global context.
func VFMADD132SS_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD132SS_Z(mx, x, k, x1) }

// VFMADD213PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PD m128 xmm xmm
//	VFMADD213PD m256 ymm ymm
//	VFMADD213PD xmm  xmm xmm
//	VFMADD213PD ymm  ymm ymm
//	VFMADD213PD m128 xmm k xmm
//	VFMADD213PD m256 ymm k ymm
//	VFMADD213PD xmm  xmm k xmm
//	VFMADD213PD ymm  ymm k ymm
//	VFMADD213PD m512 zmm k zmm
//	VFMADD213PD m512 zmm zmm
//	VFMADD213PD zmm  zmm k zmm
//	VFMADD213PD zmm  zmm zmm
//
// Construct and append a VFMADD213PD instruction to the active function.
func (c *Context) VFMADD213PD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD(ops...))
}

// VFMADD213PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PD m128 xmm xmm
//	VFMADD213PD m256 ymm ymm
//	VFMADD213PD xmm  xmm xmm
//	VFMADD213PD ymm  ymm ymm
//	VFMADD213PD m128 xmm k xmm
//	VFMADD213PD m256 ymm k ymm
//	VFMADD213PD xmm  xmm k xmm
//	VFMADD213PD ymm  ymm k ymm
//	VFMADD213PD m512 zmm k zmm
//	VFMADD213PD m512 zmm zmm
//	VFMADD213PD zmm  zmm k zmm
//	VFMADD213PD zmm  zmm zmm
//
// Construct and append a VFMADD213PD instruction to the active function.
// Operates on the global context.
func VFMADD213PD(ops ...operand.Op) { ctx.VFMADD213PD(ops...) }

// VFMADD213PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PD.BCST m64 xmm k xmm
//	VFMADD213PD.BCST m64 xmm xmm
//	VFMADD213PD.BCST m64 ymm k ymm
//	VFMADD213PD.BCST m64 ymm ymm
//	VFMADD213PD.BCST m64 zmm k zmm
//	VFMADD213PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD213PD.BCST instruction to the active function.
func (c *Context) VFMADD213PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD_BCST(ops...))
}

// VFMADD213PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PD.BCST m64 xmm k xmm
//	VFMADD213PD.BCST m64 xmm xmm
//	VFMADD213PD.BCST m64 ymm k ymm
//	VFMADD213PD.BCST m64 ymm ymm
//	VFMADD213PD.BCST m64 zmm k zmm
//	VFMADD213PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD213PD.BCST instruction to the active function.
// Operates on the global context.
func VFMADD213PD_BCST(ops ...operand.Op) { ctx.VFMADD213PD_BCST(ops...) }

// VFMADD213PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.BCST.Z m64 xmm k xmm
//	VFMADD213PD.BCST.Z m64 ymm k ymm
//	VFMADD213PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD213PD.BCST.Z instruction to the active function.
func (c *Context) VFMADD213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD213PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.BCST.Z m64 xmm k xmm
//	VFMADD213PD.BCST.Z m64 ymm k ymm
//	VFMADD213PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD213PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD213PD_BCST_Z(m, xyz, k, xyz1) }

// VFMADD213PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PD.RD_SAE zmm zmm k zmm
//	VFMADD213PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RD_SAE instruction to the active function.
func (c *Context) VFMADD213PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RD_SAE(ops...))
}

// VFMADD213PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PD.RD_SAE zmm zmm k zmm
//	VFMADD213PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RD_SAE(ops ...operand.Op) { ctx.VFMADD213PD_RD_SAE(ops...) }

// VFMADD213PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD213PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PD_RD_SAE_Z(z, z1, k, z2) }

// VFMADD213PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PD.RN_SAE zmm zmm k zmm
//	VFMADD213PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RN_SAE instruction to the active function.
func (c *Context) VFMADD213PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RN_SAE(ops...))
}

// VFMADD213PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PD.RN_SAE zmm zmm k zmm
//	VFMADD213PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RN_SAE(ops ...operand.Op) { ctx.VFMADD213PD_RN_SAE(ops...) }

// VFMADD213PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD213PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PD_RN_SAE_Z(z, z1, k, z2) }

// VFMADD213PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PD.RU_SAE zmm zmm k zmm
//	VFMADD213PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RU_SAE instruction to the active function.
func (c *Context) VFMADD213PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RU_SAE(ops...))
}

// VFMADD213PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PD.RU_SAE zmm zmm k zmm
//	VFMADD213PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RU_SAE(ops ...operand.Op) { ctx.VFMADD213PD_RU_SAE(ops...) }

// VFMADD213PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD213PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PD_RU_SAE_Z(z, z1, k, z2) }

// VFMADD213PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE zmm zmm k zmm
//	VFMADD213PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD213PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RZ_SAE(ops...))
}

// VFMADD213PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE zmm zmm k zmm
//	VFMADD213PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD213PD_RZ_SAE(ops...) }

// VFMADD213PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD213PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PD_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD213PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.Z m128 xmm k xmm
//	VFMADD213PD.Z m256 ymm k ymm
//	VFMADD213PD.Z xmm  xmm k xmm
//	VFMADD213PD.Z ymm  ymm k ymm
//	VFMADD213PD.Z m512 zmm k zmm
//	VFMADD213PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD213PD.Z instruction to the active function.
func (c *Context) VFMADD213PD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD213PD_Z(mxyz, xyz, k, xyz1))
}

// VFMADD213PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PD.Z m128 xmm k xmm
//	VFMADD213PD.Z m256 ymm k ymm
//	VFMADD213PD.Z xmm  xmm k xmm
//	VFMADD213PD.Z ymm  ymm k ymm
//	VFMADD213PD.Z m512 zmm k zmm
//	VFMADD213PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD213PD.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD213PD_Z(mxyz, xyz, k, xyz1) }

// VFMADD213PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PS m128 xmm xmm
//	VFMADD213PS m256 ymm ymm
//	VFMADD213PS xmm  xmm xmm
//	VFMADD213PS ymm  ymm ymm
//	VFMADD213PS m128 xmm k xmm
//	VFMADD213PS m256 ymm k ymm
//	VFMADD213PS xmm  xmm k xmm
//	VFMADD213PS ymm  ymm k ymm
//	VFMADD213PS m512 zmm k zmm
//	VFMADD213PS m512 zmm zmm
//	VFMADD213PS zmm  zmm k zmm
//	VFMADD213PS zmm  zmm zmm
//
// Construct and append a VFMADD213PS instruction to the active function.
func (c *Context) VFMADD213PS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS(ops...))
}

// VFMADD213PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213PS m128 xmm xmm
//	VFMADD213PS m256 ymm ymm
//	VFMADD213PS xmm  xmm xmm
//	VFMADD213PS ymm  ymm ymm
//	VFMADD213PS m128 xmm k xmm
//	VFMADD213PS m256 ymm k ymm
//	VFMADD213PS xmm  xmm k xmm
//	VFMADD213PS ymm  ymm k ymm
//	VFMADD213PS m512 zmm k zmm
//	VFMADD213PS m512 zmm zmm
//	VFMADD213PS zmm  zmm k zmm
//	VFMADD213PS zmm  zmm zmm
//
// Construct and append a VFMADD213PS instruction to the active function.
// Operates on the global context.
func VFMADD213PS(ops ...operand.Op) { ctx.VFMADD213PS(ops...) }

// VFMADD213PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PS.BCST m32 xmm k xmm
//	VFMADD213PS.BCST m32 xmm xmm
//	VFMADD213PS.BCST m32 ymm k ymm
//	VFMADD213PS.BCST m32 ymm ymm
//	VFMADD213PS.BCST m32 zmm k zmm
//	VFMADD213PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD213PS.BCST instruction to the active function.
func (c *Context) VFMADD213PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS_BCST(ops...))
}

// VFMADD213PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD213PS.BCST m32 xmm k xmm
//	VFMADD213PS.BCST m32 xmm xmm
//	VFMADD213PS.BCST m32 ymm k ymm
//	VFMADD213PS.BCST m32 ymm ymm
//	VFMADD213PS.BCST m32 zmm k zmm
//	VFMADD213PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD213PS.BCST instruction to the active function.
// Operates on the global context.
func VFMADD213PS_BCST(ops ...operand.Op) { ctx.VFMADD213PS_BCST(ops...) }

// VFMADD213PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.BCST.Z m32 xmm k xmm
//	VFMADD213PS.BCST.Z m32 ymm k ymm
//	VFMADD213PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD213PS.BCST.Z instruction to the active function.
func (c *Context) VFMADD213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD213PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.BCST.Z m32 xmm k xmm
//	VFMADD213PS.BCST.Z m32 ymm k ymm
//	VFMADD213PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD213PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD213PS_BCST_Z(m, xyz, k, xyz1) }

// VFMADD213PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PS.RD_SAE zmm zmm k zmm
//	VFMADD213PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RD_SAE instruction to the active function.
func (c *Context) VFMADD213PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RD_SAE(ops...))
}

// VFMADD213PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213PS.RD_SAE zmm zmm k zmm
//	VFMADD213PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RD_SAE(ops ...operand.Op) { ctx.VFMADD213PS_RD_SAE(ops...) }

// VFMADD213PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD213PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PS_RD_SAE_Z(z, z1, k, z2) }

// VFMADD213PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PS.RN_SAE zmm zmm k zmm
//	VFMADD213PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RN_SAE instruction to the active function.
func (c *Context) VFMADD213PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RN_SAE(ops...))
}

// VFMADD213PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213PS.RN_SAE zmm zmm k zmm
//	VFMADD213PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RN_SAE(ops ...operand.Op) { ctx.VFMADD213PS_RN_SAE(ops...) }

// VFMADD213PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD213PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PS_RN_SAE_Z(z, z1, k, z2) }

// VFMADD213PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PS.RU_SAE zmm zmm k zmm
//	VFMADD213PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RU_SAE instruction to the active function.
func (c *Context) VFMADD213PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RU_SAE(ops...))
}

// VFMADD213PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213PS.RU_SAE zmm zmm k zmm
//	VFMADD213PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RU_SAE(ops ...operand.Op) { ctx.VFMADD213PS_RU_SAE(ops...) }

// VFMADD213PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD213PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PS_RU_SAE_Z(z, z1, k, z2) }

// VFMADD213PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE zmm zmm k zmm
//	VFMADD213PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD213PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RZ_SAE(ops...))
}

// VFMADD213PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE zmm zmm k zmm
//	VFMADD213PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD213PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD213PS_RZ_SAE(ops...) }

// VFMADD213PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD213PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD213PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD213PS_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD213PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.Z m128 xmm k xmm
//	VFMADD213PS.Z m256 ymm k ymm
//	VFMADD213PS.Z xmm  xmm k xmm
//	VFMADD213PS.Z ymm  ymm k ymm
//	VFMADD213PS.Z m512 zmm k zmm
//	VFMADD213PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD213PS.Z instruction to the active function.
func (c *Context) VFMADD213PS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD213PS_Z(mxyz, xyz, k, xyz1))
}

// VFMADD213PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213PS.Z m128 xmm k xmm
//	VFMADD213PS.Z m256 ymm k ymm
//	VFMADD213PS.Z xmm  xmm k xmm
//	VFMADD213PS.Z ymm  ymm k ymm
//	VFMADD213PS.Z m512 zmm k zmm
//	VFMADD213PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD213PS.Z instruction to the active function.
// Operates on the global context.
func VFMADD213PS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD213PS_Z(mxyz, xyz, k, xyz1) }

// VFMADD213SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SD m64 xmm xmm
//	VFMADD213SD xmm xmm xmm
//	VFMADD213SD m64 xmm k xmm
//	VFMADD213SD xmm xmm k xmm
//
// Construct and append a VFMADD213SD instruction to the active function.
func (c *Context) VFMADD213SD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SD(ops...))
}

// VFMADD213SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SD m64 xmm xmm
//	VFMADD213SD xmm xmm xmm
//	VFMADD213SD m64 xmm k xmm
//	VFMADD213SD xmm xmm k xmm
//
// Construct and append a VFMADD213SD instruction to the active function.
// Operates on the global context.
func VFMADD213SD(ops ...operand.Op) { ctx.VFMADD213SD(ops...) }

// VFMADD213SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SD.RD_SAE xmm xmm k xmm
//	VFMADD213SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RD_SAE instruction to the active function.
func (c *Context) VFMADD213SD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RD_SAE(ops...))
}

// VFMADD213SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SD.RD_SAE xmm xmm k xmm
//	VFMADD213SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RD_SAE(ops ...operand.Op) { ctx.VFMADD213SD_RD_SAE(ops...) }

// VFMADD213SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD213SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SD_RD_SAE_Z(x, x1, k, x2) }

// VFMADD213SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SD.RN_SAE xmm xmm k xmm
//	VFMADD213SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RN_SAE instruction to the active function.
func (c *Context) VFMADD213SD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RN_SAE(ops...))
}

// VFMADD213SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SD.RN_SAE xmm xmm k xmm
//	VFMADD213SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RN_SAE(ops ...operand.Op) { ctx.VFMADD213SD_RN_SAE(ops...) }

// VFMADD213SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD213SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SD_RN_SAE_Z(x, x1, k, x2) }

// VFMADD213SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SD.RU_SAE xmm xmm k xmm
//	VFMADD213SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RU_SAE instruction to the active function.
func (c *Context) VFMADD213SD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RU_SAE(ops...))
}

// VFMADD213SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SD.RU_SAE xmm xmm k xmm
//	VFMADD213SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RU_SAE(ops ...operand.Op) { ctx.VFMADD213SD_RU_SAE(ops...) }

// VFMADD213SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD213SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SD_RU_SAE_Z(x, x1, k, x2) }

// VFMADD213SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE xmm xmm k xmm
//	VFMADD213SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD213SD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RZ_SAE(ops...))
}

// VFMADD213SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE xmm xmm k xmm
//	VFMADD213SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD213SD_RZ_SAE(ops...) }

// VFMADD213SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SD_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD213SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SD_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD213SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.Z m64 xmm k xmm
//	VFMADD213SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.Z instruction to the active function.
func (c *Context) VFMADD213SD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD213SD_Z(mx, x, k, x1))
}

// VFMADD213SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SD.Z m64 xmm k xmm
//	VFMADD213SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SD.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SD_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD213SD_Z(mx, x, k, x1) }

// VFMADD213SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SS m32 xmm xmm
//	VFMADD213SS xmm xmm xmm
//	VFMADD213SS m32 xmm k xmm
//	VFMADD213SS xmm xmm k xmm
//
// Construct and append a VFMADD213SS instruction to the active function.
func (c *Context) VFMADD213SS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SS(ops...))
}

// VFMADD213SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD213SS m32 xmm xmm
//	VFMADD213SS xmm xmm xmm
//	VFMADD213SS m32 xmm k xmm
//	VFMADD213SS xmm xmm k xmm
//
// Construct and append a VFMADD213SS instruction to the active function.
// Operates on the global context.
func VFMADD213SS(ops ...operand.Op) { ctx.VFMADD213SS(ops...) }

// VFMADD213SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SS.RD_SAE xmm xmm k xmm
//	VFMADD213SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RD_SAE instruction to the active function.
func (c *Context) VFMADD213SS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RD_SAE(ops...))
}

// VFMADD213SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD213SS.RD_SAE xmm xmm k xmm
//	VFMADD213SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RD_SAE(ops ...operand.Op) { ctx.VFMADD213SS_RD_SAE(ops...) }

// VFMADD213SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD213SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SS_RD_SAE_Z(x, x1, k, x2) }

// VFMADD213SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SS.RN_SAE xmm xmm k xmm
//	VFMADD213SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RN_SAE instruction to the active function.
func (c *Context) VFMADD213SS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RN_SAE(ops...))
}

// VFMADD213SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD213SS.RN_SAE xmm xmm k xmm
//	VFMADD213SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RN_SAE(ops ...operand.Op) { ctx.VFMADD213SS_RN_SAE(ops...) }

// VFMADD213SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD213SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SS_RN_SAE_Z(x, x1, k, x2) }

// VFMADD213SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SS.RU_SAE xmm xmm k xmm
//	VFMADD213SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RU_SAE instruction to the active function.
func (c *Context) VFMADD213SS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RU_SAE(ops...))
}

// VFMADD213SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD213SS.RU_SAE xmm xmm k xmm
//	VFMADD213SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RU_SAE(ops ...operand.Op) { ctx.VFMADD213SS_RU_SAE(ops...) }

// VFMADD213SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD213SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SS_RU_SAE_Z(x, x1, k, x2) }

// VFMADD213SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE xmm xmm k xmm
//	VFMADD213SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD213SS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RZ_SAE(ops...))
}

// VFMADD213SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE xmm xmm k xmm
//	VFMADD213SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD213SS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD213SS_RZ_SAE(ops...) }

// VFMADD213SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD213SS_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD213SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD213SS_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD213SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.Z m32 xmm k xmm
//	VFMADD213SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.Z instruction to the active function.
func (c *Context) VFMADD213SS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD213SS_Z(mx, x, k, x1))
}

// VFMADD213SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD213SS.Z m32 xmm k xmm
//	VFMADD213SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD213SS.Z instruction to the active function.
// Operates on the global context.
func VFMADD213SS_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD213SS_Z(mx, x, k, x1) }

// VFMADD231PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PD m128 xmm xmm
//	VFMADD231PD m256 ymm ymm
//	VFMADD231PD xmm  xmm xmm
//	VFMADD231PD ymm  ymm ymm
//	VFMADD231PD m128 xmm k xmm
//	VFMADD231PD m256 ymm k ymm
//	VFMADD231PD xmm  xmm k xmm
//	VFMADD231PD ymm  ymm k ymm
//	VFMADD231PD m512 zmm k zmm
//	VFMADD231PD m512 zmm zmm
//	VFMADD231PD zmm  zmm k zmm
//	VFMADD231PD zmm  zmm zmm
//
// Construct and append a VFMADD231PD instruction to the active function.
func (c *Context) VFMADD231PD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD(ops...))
}

// VFMADD231PD: Fused Multiply-Add of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PD m128 xmm xmm
//	VFMADD231PD m256 ymm ymm
//	VFMADD231PD xmm  xmm xmm
//	VFMADD231PD ymm  ymm ymm
//	VFMADD231PD m128 xmm k xmm
//	VFMADD231PD m256 ymm k ymm
//	VFMADD231PD xmm  xmm k xmm
//	VFMADD231PD ymm  ymm k ymm
//	VFMADD231PD m512 zmm k zmm
//	VFMADD231PD m512 zmm zmm
//	VFMADD231PD zmm  zmm k zmm
//	VFMADD231PD zmm  zmm zmm
//
// Construct and append a VFMADD231PD instruction to the active function.
// Operates on the global context.
func VFMADD231PD(ops ...operand.Op) { ctx.VFMADD231PD(ops...) }

// VFMADD231PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PD.BCST m64 xmm k xmm
//	VFMADD231PD.BCST m64 xmm xmm
//	VFMADD231PD.BCST m64 ymm k ymm
//	VFMADD231PD.BCST m64 ymm ymm
//	VFMADD231PD.BCST m64 zmm k zmm
//	VFMADD231PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD231PD.BCST instruction to the active function.
func (c *Context) VFMADD231PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD_BCST(ops...))
}

// VFMADD231PD_BCST: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PD.BCST m64 xmm k xmm
//	VFMADD231PD.BCST m64 xmm xmm
//	VFMADD231PD.BCST m64 ymm k ymm
//	VFMADD231PD.BCST m64 ymm ymm
//	VFMADD231PD.BCST m64 zmm k zmm
//	VFMADD231PD.BCST m64 zmm zmm
//
// Construct and append a VFMADD231PD.BCST instruction to the active function.
// Operates on the global context.
func VFMADD231PD_BCST(ops ...operand.Op) { ctx.VFMADD231PD_BCST(ops...) }

// VFMADD231PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.BCST.Z m64 xmm k xmm
//	VFMADD231PD.BCST.Z m64 ymm k ymm
//	VFMADD231PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD231PD.BCST.Z instruction to the active function.
func (c *Context) VFMADD231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD231PD_BCST_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.BCST.Z m64 xmm k xmm
//	VFMADD231PD.BCST.Z m64 ymm k ymm
//	VFMADD231PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADD231PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD231PD_BCST_Z(m, xyz, k, xyz1) }

// VFMADD231PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PD.RD_SAE zmm zmm k zmm
//	VFMADD231PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RD_SAE instruction to the active function.
func (c *Context) VFMADD231PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RD_SAE(ops...))
}

// VFMADD231PD_RD_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PD.RD_SAE zmm zmm k zmm
//	VFMADD231PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RD_SAE(ops ...operand.Op) { ctx.VFMADD231PD_RD_SAE(ops...) }

// VFMADD231PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD231PD_RD_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PD_RD_SAE_Z(z, z1, k, z2) }

// VFMADD231PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PD.RN_SAE zmm zmm k zmm
//	VFMADD231PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RN_SAE instruction to the active function.
func (c *Context) VFMADD231PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RN_SAE(ops...))
}

// VFMADD231PD_RN_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PD.RN_SAE zmm zmm k zmm
//	VFMADD231PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RN_SAE(ops ...operand.Op) { ctx.VFMADD231PD_RN_SAE(ops...) }

// VFMADD231PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD231PD_RN_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PD_RN_SAE_Z(z, z1, k, z2) }

// VFMADD231PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PD.RU_SAE zmm zmm k zmm
//	VFMADD231PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RU_SAE instruction to the active function.
func (c *Context) VFMADD231PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RU_SAE(ops...))
}

// VFMADD231PD_RU_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PD.RU_SAE zmm zmm k zmm
//	VFMADD231PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RU_SAE(ops ...operand.Op) { ctx.VFMADD231PD_RU_SAE(ops...) }

// VFMADD231PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD231PD_RU_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PD_RU_SAE_Z(z, z1, k, z2) }

// VFMADD231PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE zmm zmm k zmm
//	VFMADD231PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD231PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RZ_SAE(ops...))
}

// VFMADD231PD_RZ_SAE: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE zmm zmm k zmm
//	VFMADD231PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD231PD_RZ_SAE(ops...) }

// VFMADD231PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD231PD_RZ_SAE_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PD_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD231PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.Z m128 xmm k xmm
//	VFMADD231PD.Z m256 ymm k ymm
//	VFMADD231PD.Z xmm  xmm k xmm
//	VFMADD231PD.Z ymm  ymm k ymm
//	VFMADD231PD.Z m512 zmm k zmm
//	VFMADD231PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD231PD.Z instruction to the active function.
func (c *Context) VFMADD231PD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD231PD_Z(mxyz, xyz, k, xyz1))
}

// VFMADD231PD_Z: Fused Multiply-Add of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PD.Z m128 xmm k xmm
//	VFMADD231PD.Z m256 ymm k ymm
//	VFMADD231PD.Z xmm  xmm k xmm
//	VFMADD231PD.Z ymm  ymm k ymm
//	VFMADD231PD.Z m512 zmm k zmm
//	VFMADD231PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADD231PD.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD231PD_Z(mxyz, xyz, k, xyz1) }

// VFMADD231PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PS m128 xmm xmm
//	VFMADD231PS m256 ymm ymm
//	VFMADD231PS xmm  xmm xmm
//	VFMADD231PS ymm  ymm ymm
//	VFMADD231PS m128 xmm k xmm
//	VFMADD231PS m256 ymm k ymm
//	VFMADD231PS xmm  xmm k xmm
//	VFMADD231PS ymm  ymm k ymm
//	VFMADD231PS m512 zmm k zmm
//	VFMADD231PS m512 zmm zmm
//	VFMADD231PS zmm  zmm k zmm
//	VFMADD231PS zmm  zmm zmm
//
// Construct and append a VFMADD231PS instruction to the active function.
func (c *Context) VFMADD231PS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS(ops...))
}

// VFMADD231PS: Fused Multiply-Add of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231PS m128 xmm xmm
//	VFMADD231PS m256 ymm ymm
//	VFMADD231PS xmm  xmm xmm
//	VFMADD231PS ymm  ymm ymm
//	VFMADD231PS m128 xmm k xmm
//	VFMADD231PS m256 ymm k ymm
//	VFMADD231PS xmm  xmm k xmm
//	VFMADD231PS ymm  ymm k ymm
//	VFMADD231PS m512 zmm k zmm
//	VFMADD231PS m512 zmm zmm
//	VFMADD231PS zmm  zmm k zmm
//	VFMADD231PS zmm  zmm zmm
//
// Construct and append a VFMADD231PS instruction to the active function.
// Operates on the global context.
func VFMADD231PS(ops ...operand.Op) { ctx.VFMADD231PS(ops...) }

// VFMADD231PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PS.BCST m32 xmm k xmm
//	VFMADD231PS.BCST m32 xmm xmm
//	VFMADD231PS.BCST m32 ymm k ymm
//	VFMADD231PS.BCST m32 ymm ymm
//	VFMADD231PS.BCST m32 zmm k zmm
//	VFMADD231PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD231PS.BCST instruction to the active function.
func (c *Context) VFMADD231PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS_BCST(ops...))
}

// VFMADD231PS_BCST: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADD231PS.BCST m32 xmm k xmm
//	VFMADD231PS.BCST m32 xmm xmm
//	VFMADD231PS.BCST m32 ymm k ymm
//	VFMADD231PS.BCST m32 ymm ymm
//	VFMADD231PS.BCST m32 zmm k zmm
//	VFMADD231PS.BCST m32 zmm zmm
//
// Construct and append a VFMADD231PS.BCST instruction to the active function.
// Operates on the global context.
func VFMADD231PS_BCST(ops ...operand.Op) { ctx.VFMADD231PS_BCST(ops...) }

// VFMADD231PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.BCST.Z m32 xmm k xmm
//	VFMADD231PS.BCST.Z m32 ymm k ymm
//	VFMADD231PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD231PS.BCST.Z instruction to the active function.
func (c *Context) VFMADD231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_BCST_Z(m, xyz, k, xyz1))
}

// VFMADD231PS_BCST_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.BCST.Z m32 xmm k xmm
//	VFMADD231PS.BCST.Z m32 ymm k ymm
//	VFMADD231PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADD231PS.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADD231PS_BCST_Z(m, xyz, k, xyz1) }

// VFMADD231PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PS.RD_SAE zmm zmm k zmm
//	VFMADD231PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RD_SAE instruction to the active function.
func (c *Context) VFMADD231PS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RD_SAE(ops...))
}

// VFMADD231PS_RD_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231PS.RD_SAE zmm zmm k zmm
//	VFMADD231PS.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RD_SAE(ops ...operand.Op) { ctx.VFMADD231PS_RD_SAE(ops...) }

// VFMADD231PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RD_SAE_Z(z, z1, k, z2))
}

// VFMADD231PS_RD_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PS_RD_SAE_Z(z, z1, k, z2) }

// VFMADD231PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PS.RN_SAE zmm zmm k zmm
//	VFMADD231PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RN_SAE instruction to the active function.
func (c *Context) VFMADD231PS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RN_SAE(ops...))
}

// VFMADD231PS_RN_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231PS.RN_SAE zmm zmm k zmm
//	VFMADD231PS.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RN_SAE(ops ...operand.Op) { ctx.VFMADD231PS_RN_SAE(ops...) }

// VFMADD231PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RN_SAE_Z(z, z1, k, z2))
}

// VFMADD231PS_RN_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PS_RN_SAE_Z(z, z1, k, z2) }

// VFMADD231PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PS.RU_SAE zmm zmm k zmm
//	VFMADD231PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RU_SAE instruction to the active function.
func (c *Context) VFMADD231PS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RU_SAE(ops...))
}

// VFMADD231PS_RU_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231PS.RU_SAE zmm zmm k zmm
//	VFMADD231PS.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RU_SAE(ops ...operand.Op) { ctx.VFMADD231PS_RU_SAE(ops...) }

// VFMADD231PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RU_SAE_Z(z, z1, k, z2))
}

// VFMADD231PS_RU_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PS_RU_SAE_Z(z, z1, k, z2) }

// VFMADD231PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE zmm zmm k zmm
//	VFMADD231PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD231PS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RZ_SAE(ops...))
}

// VFMADD231PS_RZ_SAE: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE zmm zmm k zmm
//	VFMADD231PS.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADD231PS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD231PS_RZ_SAE(ops...) }

// VFMADD231PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADD231PS_RZ_SAE_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADD231PS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADD231PS_RZ_SAE_Z(z, z1, k, z2) }

// VFMADD231PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.Z m128 xmm k xmm
//	VFMADD231PS.Z m256 ymm k ymm
//	VFMADD231PS.Z xmm  xmm k xmm
//	VFMADD231PS.Z ymm  ymm k ymm
//	VFMADD231PS.Z m512 zmm k zmm
//	VFMADD231PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD231PS.Z instruction to the active function.
func (c *Context) VFMADD231PS_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADD231PS_Z(mxyz, xyz, k, xyz1))
}

// VFMADD231PS_Z: Fused Multiply-Add of Packed Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231PS.Z m128 xmm k xmm
//	VFMADD231PS.Z m256 ymm k ymm
//	VFMADD231PS.Z xmm  xmm k xmm
//	VFMADD231PS.Z ymm  ymm k ymm
//	VFMADD231PS.Z m512 zmm k zmm
//	VFMADD231PS.Z zmm  zmm k zmm
//
// Construct and append a VFMADD231PS.Z instruction to the active function.
// Operates on the global context.
func VFMADD231PS_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADD231PS_Z(mxyz, xyz, k, xyz1) }

// VFMADD231SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SD m64 xmm xmm
//	VFMADD231SD xmm xmm xmm
//	VFMADD231SD m64 xmm k xmm
//	VFMADD231SD xmm xmm k xmm
//
// Construct and append a VFMADD231SD instruction to the active function.
func (c *Context) VFMADD231SD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SD(ops...))
}

// VFMADD231SD: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SD m64 xmm xmm
//	VFMADD231SD xmm xmm xmm
//	VFMADD231SD m64 xmm k xmm
//	VFMADD231SD xmm xmm k xmm
//
// Construct and append a VFMADD231SD instruction to the active function.
// Operates on the global context.
func VFMADD231SD(ops ...operand.Op) { ctx.VFMADD231SD(ops...) }

// VFMADD231SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SD.RD_SAE xmm xmm k xmm
//	VFMADD231SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RD_SAE instruction to the active function.
func (c *Context) VFMADD231SD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RD_SAE(ops...))
}

// VFMADD231SD_RD_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SD.RD_SAE xmm xmm k xmm
//	VFMADD231SD.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RD_SAE(ops ...operand.Op) { ctx.VFMADD231SD_RD_SAE(ops...) }

// VFMADD231SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD231SD_RD_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SD_RD_SAE_Z(x, x1, k, x2) }

// VFMADD231SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SD.RN_SAE xmm xmm k xmm
//	VFMADD231SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RN_SAE instruction to the active function.
func (c *Context) VFMADD231SD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RN_SAE(ops...))
}

// VFMADD231SD_RN_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SD.RN_SAE xmm xmm k xmm
//	VFMADD231SD.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RN_SAE(ops ...operand.Op) { ctx.VFMADD231SD_RN_SAE(ops...) }

// VFMADD231SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD231SD_RN_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SD_RN_SAE_Z(x, x1, k, x2) }

// VFMADD231SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SD.RU_SAE xmm xmm k xmm
//	VFMADD231SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RU_SAE instruction to the active function.
func (c *Context) VFMADD231SD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RU_SAE(ops...))
}

// VFMADD231SD_RU_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SD.RU_SAE xmm xmm k xmm
//	VFMADD231SD.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RU_SAE(ops ...operand.Op) { ctx.VFMADD231SD_RU_SAE(ops...) }

// VFMADD231SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD231SD_RU_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SD_RU_SAE_Z(x, x1, k, x2) }

// VFMADD231SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE xmm xmm k xmm
//	VFMADD231SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RZ_SAE instruction to the active function.
func (c *Context) VFMADD231SD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RZ_SAE(ops...))
}

// VFMADD231SD_RZ_SAE: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE xmm xmm k xmm
//	VFMADD231SD.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RZ_SAE(ops ...operand.Op) { ctx.VFMADD231SD_RZ_SAE(ops...) }

// VFMADD231SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SD_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD231SD_RZ_SAE_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SD_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SD_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD231SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.Z m64 xmm k xmm
//	VFMADD231SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.Z instruction to the active function.
func (c *Context) VFMADD231SD_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD231SD_Z(mx, x, k, x1))
}

// VFMADD231SD_Z: Fused Multiply-Add of Scalar Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SD.Z m64 xmm k xmm
//	VFMADD231SD.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SD.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SD_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD231SD_Z(mx, x, k, x1) }

// VFMADD231SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SS m32 xmm xmm
//	VFMADD231SS xmm xmm xmm
//	VFMADD231SS m32 xmm k xmm
//	VFMADD231SS xmm xmm k xmm
//
// Construct and append a VFMADD231SS instruction to the active function.
func (c *Context) VFMADD231SS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SS(ops...))
}

// VFMADD231SS: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADD231SS m32 xmm xmm
//	VFMADD231SS xmm xmm xmm
//	VFMADD231SS m32 xmm k xmm
//	VFMADD231SS xmm xmm k xmm
//
// Construct and append a VFMADD231SS instruction to the active function.
// Operates on the global context.
func VFMADD231SS(ops ...operand.Op) { ctx.VFMADD231SS(ops...) }

// VFMADD231SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SS.RD_SAE xmm xmm k xmm
//	VFMADD231SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RD_SAE instruction to the active function.
func (c *Context) VFMADD231SS_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RD_SAE(ops...))
}

// VFMADD231SS_RD_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADD231SS.RD_SAE xmm xmm k xmm
//	VFMADD231SS.RD_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RD_SAE(ops ...operand.Op) { ctx.VFMADD231SS_RD_SAE(ops...) }

// VFMADD231SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RD_SAE_Z(x, x1, k, x2))
}

// VFMADD231SS_RD_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RD_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RD_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SS_RD_SAE_Z(x, x1, k, x2) }

// VFMADD231SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SS.RN_SAE xmm xmm k xmm
//	VFMADD231SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RN_SAE instruction to the active function.
func (c *Context) VFMADD231SS_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RN_SAE(ops...))
}

// VFMADD231SS_RN_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADD231SS.RN_SAE xmm xmm k xmm
//	VFMADD231SS.RN_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RN_SAE(ops ...operand.Op) { ctx.VFMADD231SS_RN_SAE(ops...) }

// VFMADD231SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RN_SAE_Z(x, x1, k, x2))
}

// VFMADD231SS_RN_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RN_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RN_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SS_RN_SAE_Z(x, x1, k, x2) }

// VFMADD231SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SS.RU_SAE xmm xmm k xmm
//	VFMADD231SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RU_SAE instruction to the active function.
func (c *Context) VFMADD231SS_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RU_SAE(ops...))
}

// VFMADD231SS_RU_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADD231SS.RU_SAE xmm xmm k xmm
//	VFMADD231SS.RU_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RU_SAE(ops ...operand.Op) { ctx.VFMADD231SS_RU_SAE(ops...) }

// VFMADD231SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RU_SAE_Z(x, x1, k, x2))
}

// VFMADD231SS_RU_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RU_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RU_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SS_RU_SAE_Z(x, x1, k, x2) }

// VFMADD231SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE xmm xmm k xmm
//	VFMADD231SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RZ_SAE instruction to the active function.
func (c *Context) VFMADD231SS_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RZ_SAE(ops...))
}

// VFMADD231SS_RZ_SAE: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE xmm xmm k xmm
//	VFMADD231SS.RZ_SAE xmm xmm xmm
//
// Construct and append a VFMADD231SS.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RZ_SAE(ops ...operand.Op) { ctx.VFMADD231SS_RZ_SAE(ops...) }

// VFMADD231SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADD231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) {
	c.addinstruction(x86.VFMADD231SS_RZ_SAE_Z(x, x1, k, x2))
}

// VFMADD231SS_RZ_SAE_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.RZ_SAE.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SS_RZ_SAE_Z(x, x1, k, x2 operand.Op) { ctx.VFMADD231SS_RZ_SAE_Z(x, x1, k, x2) }

// VFMADD231SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.Z m32 xmm k xmm
//	VFMADD231SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.Z instruction to the active function.
func (c *Context) VFMADD231SS_Z(mx, x, k, x1 operand.Op) {
	c.addinstruction(x86.VFMADD231SS_Z(mx, x, k, x1))
}

// VFMADD231SS_Z: Fused Multiply-Add of Scalar Single-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADD231SS.Z m32 xmm k xmm
//	VFMADD231SS.Z xmm xmm k xmm
//
// Construct and append a VFMADD231SS.Z instruction to the active function.
// Operates on the global context.
func VFMADD231SS_Z(mx, x, k, x1 operand.Op) { ctx.VFMADD231SS_Z(mx, x, k, x1) }

// VFMADDSUB132PD: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PD m128 xmm xmm
//	VFMADDSUB132PD m256 ymm ymm
//	VFMADDSUB132PD xmm  xmm xmm
//	VFMADDSUB132PD ymm  ymm ymm
//	VFMADDSUB132PD m128 xmm k xmm
//	VFMADDSUB132PD m256 ymm k ymm
//	VFMADDSUB132PD xmm  xmm k xmm
//	VFMADDSUB132PD ymm  ymm k ymm
//	VFMADDSUB132PD m512 zmm k zmm
//	VFMADDSUB132PD m512 zmm zmm
//	VFMADDSUB132PD zmm  zmm k zmm
//	VFMADDSUB132PD zmm  zmm zmm
//
// Construct and append a VFMADDSUB132PD instruction to the active function.
func (c *Context) VFMADDSUB132PD(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD(ops...))
}

// VFMADDSUB132PD: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PD m128 xmm xmm
//	VFMADDSUB132PD m256 ymm ymm
//	VFMADDSUB132PD xmm  xmm xmm
//	VFMADDSUB132PD ymm  ymm ymm
//	VFMADDSUB132PD m128 xmm k xmm
//	VFMADDSUB132PD m256 ymm k ymm
//	VFMADDSUB132PD xmm  xmm k xmm
//	VFMADDSUB132PD ymm  ymm k ymm
//	VFMADDSUB132PD m512 zmm k zmm
//	VFMADDSUB132PD m512 zmm zmm
//	VFMADDSUB132PD zmm  zmm k zmm
//	VFMADDSUB132PD zmm  zmm zmm
//
// Construct and append a VFMADDSUB132PD instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD(ops ...operand.Op) { ctx.VFMADDSUB132PD(ops...) }

// VFMADDSUB132PD_BCST: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PD.BCST m64 xmm k xmm
//	VFMADDSUB132PD.BCST m64 xmm xmm
//	VFMADDSUB132PD.BCST m64 ymm k ymm
//	VFMADDSUB132PD.BCST m64 ymm ymm
//	VFMADDSUB132PD.BCST m64 zmm k zmm
//	VFMADDSUB132PD.BCST m64 zmm zmm
//
// Construct and append a VFMADDSUB132PD.BCST instruction to the active function.
func (c *Context) VFMADDSUB132PD_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_BCST(ops...))
}

// VFMADDSUB132PD_BCST: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PD.BCST m64 xmm k xmm
//	VFMADDSUB132PD.BCST m64 xmm xmm
//	VFMADDSUB132PD.BCST m64 ymm k ymm
//	VFMADDSUB132PD.BCST m64 ymm ymm
//	VFMADDSUB132PD.BCST m64 zmm k zmm
//	VFMADDSUB132PD.BCST m64 zmm zmm
//
// Construct and append a VFMADDSUB132PD.BCST instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_BCST(ops ...operand.Op) { ctx.VFMADDSUB132PD_BCST(ops...) }

// VFMADDSUB132PD_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.BCST.Z m64 xmm k xmm
//	VFMADDSUB132PD.BCST.Z m64 ymm k ymm
//	VFMADDSUB132PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADDSUB132PD.BCST.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_BCST_Z(m, xyz, k, xyz1))
}

// VFMADDSUB132PD_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.BCST.Z m64 xmm k xmm
//	VFMADDSUB132PD.BCST.Z m64 ymm k ymm
//	VFMADDSUB132PD.BCST.Z m64 zmm k zmm
//
// Construct and append a VFMADDSUB132PD.BCST.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_BCST_Z(m, xyz, k, xyz1 operand.Op) { ctx.VFMADDSUB132PD_BCST_Z(m, xyz, k, xyz1) }

// VFMADDSUB132PD_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RD_SAE instruction to the active function.
func (c *Context) VFMADDSUB132PD_RD_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RD_SAE(ops...))
}

// VFMADDSUB132PD_RD_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RD_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RD_SAE instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RD_SAE(ops ...operand.Op) { ctx.VFMADDSUB132PD_RD_SAE(ops...) }

// VFMADDSUB132PD_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RD_SAE.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RD_SAE_Z(z, z1, k, z2))
}

// VFMADDSUB132PD_RD_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Negative Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RD_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RD_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RD_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADDSUB132PD_RD_SAE_Z(z, z1, k, z2) }

// VFMADDSUB132PD_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RN_SAE instruction to the active function.
func (c *Context) VFMADDSUB132PD_RN_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RN_SAE(ops...))
}

// VFMADDSUB132PD_RN_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RN_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RN_SAE instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RN_SAE(ops ...operand.Op) { ctx.VFMADDSUB132PD_RN_SAE(ops...) }

// VFMADDSUB132PD_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RN_SAE.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RN_SAE_Z(z, z1, k, z2))
}

// VFMADDSUB132PD_RN_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Nearest, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RN_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RN_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RN_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADDSUB132PD_RN_SAE_Z(z, z1, k, z2) }

// VFMADDSUB132PD_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RU_SAE instruction to the active function.
func (c *Context) VFMADDSUB132PD_RU_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RU_SAE(ops...))
}

// VFMADDSUB132PD_RU_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RU_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RU_SAE instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RU_SAE(ops ...operand.Op) { ctx.VFMADDSUB132PD_RU_SAE(ops...) }

// VFMADDSUB132PD_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RU_SAE.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RU_SAE_Z(z, z1, k, z2))
}

// VFMADDSUB132PD_RU_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Positive Infinity, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RU_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RU_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RU_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADDSUB132PD_RU_SAE_Z(z, z1, k, z2) }

// VFMADDSUB132PD_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RZ_SAE instruction to the active function.
func (c *Context) VFMADDSUB132PD_RZ_SAE(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RZ_SAE(ops...))
}

// VFMADDSUB132PD_RZ_SAE: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE zmm zmm k zmm
//	VFMADDSUB132PD.RZ_SAE zmm zmm zmm
//
// Construct and append a VFMADDSUB132PD.RZ_SAE instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RZ_SAE(ops ...operand.Op) { ctx.VFMADDSUB132PD_RZ_SAE(ops...) }

// VFMADDSUB132PD_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RZ_SAE.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_RZ_SAE_Z(z, z1, k, z2))
}

// VFMADDSUB132PD_RZ_SAE_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Round Towards Zero, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.RZ_SAE.Z zmm zmm k zmm
//
// Construct and append a VFMADDSUB132PD.RZ_SAE.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_RZ_SAE_Z(z, z1, k, z2 operand.Op) { ctx.VFMADDSUB132PD_RZ_SAE_Z(z, z1, k, z2) }

// VFMADDSUB132PD_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.Z m128 xmm k xmm
//	VFMADDSUB132PD.Z m256 ymm k ymm
//	VFMADDSUB132PD.Z xmm  xmm k xmm
//	VFMADDSUB132PD.Z ymm  ymm k ymm
//	VFMADDSUB132PD.Z m512 zmm k zmm
//	VFMADDSUB132PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADDSUB132PD.Z instruction to the active function.
func (c *Context) VFMADDSUB132PD_Z(mxyz, xyz, k, xyz1 operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PD_Z(mxyz, xyz, k, xyz1))
}

// VFMADDSUB132PD_Z: Fused Multiply-Alternating Add/Subtract of Packed Double-Precision Floating-Point Values (Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PD.Z m128 xmm k xmm
//	VFMADDSUB132PD.Z m256 ymm k ymm
//	VFMADDSUB132PD.Z xmm  xmm k xmm
//	VFMADDSUB132PD.Z ymm  ymm k ymm
//	VFMADDSUB132PD.Z m512 zmm k zmm
//	VFMADDSUB132PD.Z zmm  zmm k zmm
//
// Construct and append a VFMADDSUB132PD.Z instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PD_Z(mxyz, xyz, k, xyz1 operand.Op) { ctx.VFMADDSUB132PD_Z(mxyz, xyz, k, xyz1) }

// VFMADDSUB132PS: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PS m128 xmm xmm
//	VFMADDSUB132PS m256 ymm ymm
//	VFMADDSUB132PS xmm  xmm xmm
//	VFMADDSUB132PS ymm  ymm ymm
//	VFMADDSUB132PS m128 xmm k xmm
//	VFMADDSUB132PS m256 ymm k ymm
//	VFMADDSUB132PS xmm  xmm k xmm
//	VFMADDSUB132PS ymm  ymm k ymm
//	VFMADDSUB132PS m512 zmm k zmm
//	VFMADDSUB132PS m512 zmm zmm
//	VFMADDSUB132PS zmm  zmm k zmm
//	VFMADDSUB132PS zmm  zmm zmm
//
// Construct and append a VFMADDSUB132PS instruction to the active function.
func (c *Context) VFMADDSUB132PS(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PS(ops...))
}

// VFMADDSUB132PS: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values.
//
// Forms:
//
//	VFMADDSUB132PS m128 xmm xmm
//	VFMADDSUB132PS m256 ymm ymm
//	VFMADDSUB132PS xmm  xmm xmm
//	VFMADDSUB132PS ymm  ymm ymm
//	VFMADDSUB132PS m128 xmm k xmm
//	VFMADDSUB132PS m256 ymm k ymm
//	VFMADDSUB132PS xmm  xmm k xmm
//	VFMADDSUB132PS ymm  ymm k ymm
//	VFMADDSUB132PS m512 zmm k zmm
//	VFMADDSUB132PS m512 zmm zmm
//	VFMADDSUB132PS zmm  zmm k zmm
//	VFMADDSUB132PS zmm  zmm zmm
//
// Construct and append a VFMADDSUB132PS instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PS(ops ...operand.Op) { ctx.VFMADDSUB132PS(ops...) }

// VFMADDSUB132PS_BCST: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PS.BCST m32 xmm k xmm
//	VFMADDSUB132PS.BCST m32 xmm xmm
//	VFMADDSUB132PS.BCST m32 ymm k ymm
//	VFMADDSUB132PS.BCST m32 ymm ymm
//	VFMADDSUB132PS.BCST m32 zmm k zmm
//	VFMADDSUB132PS.BCST m32 zmm zmm
//
// Construct and append a VFMADDSUB132PS.BCST instruction to the active function.
func (c *Context) VFMADDSUB132PS_BCST(ops ...operand.Op) {
	c.addinstruction(x86.VFMADDSUB132PS_BCST(ops...))
}

// VFMADDSUB132PS_BCST: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast).
//
// Forms:
//
//	VFMADDSUB132PS.BCST m32 xmm k xmm
//	VFMADDSUB132PS.BCST m32 xmm xmm
//	VFMADDSUB132PS.BCST m32 ymm k ymm
//	VFMADDSUB132PS.BCST m32 ymm ymm
//	VFMADDSUB132PS.BCST m32 zmm k zmm
//	VFMADDSUB132PS.BCST m32 zmm zmm
//
// Construct and append a VFMADDSUB132PS.BCST instruction to the active function.
// Operates on the global context.
func VFMADDSUB132PS_BCST(ops ...operand.Op) { ctx.VFMADDSUB132PS_BCST(ops...) }

// VFMADDSUB132PS_BCST_Z: Fused Multiply-Alternating Add/Subtract of Packed Single-Precision Floating-Point Values (Broadcast, Zeroing Masking).
//
// Forms:
//
//	VFMADDSUB132PS.BCST.Z m32 xmm k xmm
//	VFMADDSUB132PS.BCST.Z m32 ymm k ymm
//	VFMADDSUB132PS.BCST.Z m32 zmm k zmm
//
// Construct and append a VFMADDSUB132PS.BCST.Z instruction to the active func