# Security Policy

## Reporting a Vulnerability

The go-httpbin project takes security issues seriously. We appreciate your
efforts to responsibly disclose your findings and will make every effort to
acknowledge your contributions.

To report a security vulnerability, please follow these steps:

1. **Do not** disclose the vulnerability publicly on GitHub issues,
   discussions, or elsewhere.

2. Submit your report via this repo's [New Security Issue][1] page, using
   GitHub's built-in security advisory feature

3. Please include the following information in your report:
   - A description of the vulnerability
   - Steps to reproduce the issue
   - Potential impact of the vulnerability
   - Any potential solutions you may have identified

## Response Process

- You will receive an acknowledgment of your report through GitHub's security
  advisory system.

- We will investigate the issue and provide updates on our progress through
  the advisory. We may ask for additional information or guidance.

- Once the issue is resolved, we will publicly acknowledge your contribution
  (unless you prefer to remain anonymous).

## Scope

This security policy applies to the [latest release][2] of go-httpbin. For
older versions, please consider upgrading to the latest release.

## Support

go-httpbin is a personal side project. While we take security seriously,
please understand that response times may vary based on the severity of the
reported issue and maintainer availability.

Thank you for helping keep go-httpbin and its users secure!

[1]: https://github.com/mccutchen/go-httpbin/security/advisories/new
[2]: https://github.com/mccutchen/go-httpbin/releases
