// Code generated by NodeGenerator. DO NOT EDIT.

// Package node is a generated by the generator.
package node

import (
	"sync/atomic"
	"unsafe"
)

// BR is a cache entry that provide the following features:
//
// 1. Base
//
// 2. Refresh
type BR[K comparable, V any] struct {
	key           K
	value         V
	refreshableAt atomic.Int64
}

// NewBR creates a new BR.
func NewBR[K comparable, V any](key K, value V, expiresAt, refreshableAt int64, weight uint32) Node[K, V] {
	n := &BR[K, V]{
		key:   key,
		value: value,
	}
	n.refreshableAt.Store(refreshableAt)

	return n
}

// CastPointerToBR casts a pointer to BR.
func CastPointerToBR[K comparable, V any](ptr unsafe.Pointer) Node[K, V] {
	return (*BR[K, V])(ptr)
}

func (n *BR[K, V]) Key() K {
	return n.key
}

func (n *BR[K, V]) Value() V {
	return n.value
}

func (n *BR[K, V]) AsPointer() unsafe.Pointer {
	return unsafe.Pointer(n)
}

func (n *BR[K, V]) Prev() Node[K, V] {
	panic("not implemented")
}

func (n *BR[K, V]) SetPrev(v Node[K, V]) {
	panic("not implemented")
}

func (n *BR[K, V]) Next() Node[K, V] {
	panic("not implemented")
}

func (n *BR[K, V]) SetNext(v Node[K, V]) {
	panic("not implemented")
}

func (n *BR[K, V]) PrevExp() Node[K, V] {
	panic("not implemented")
}

func (n *BR[K, V]) SetPrevExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BR[K, V]) NextExp() Node[K, V] {
	panic("not implemented")
}

func (n *BR[K, V]) SetNextExp(v Node[K, V]) {
	panic("not implemented")
}

func (n *BR[K, V]) HasExpired(now int64) bool {
	return false
}

func (n *BR[K, V]) ExpiresAt() int64 {
	panic("not implemented")
}

func (n *BR[K, V]) CASExpiresAt(old, new int64) bool {
	panic("not implemented")
}

func (n *BR[K, V]) SetExpiresAt(new int64) {
	panic("not implemented")
}

func (n *BR[K, V]) RefreshableAt() int64 {
	return n.refreshableAt.Load()
}

func (n *BR[K, V]) CASRefreshableAt(old, new int64) bool {
	return n.refreshableAt.CompareAndSwap(old, new)
}

func (n *BR[K, V]) SetRefreshableAt(new int64) {
	n.refreshableAt.Store(new)
}

func (n *BR[K, V]) IsFresh(now int64) bool {
	return n.IsAlive() && n.RefreshableAt() > now
}

func (n *BR[K, V]) Weight() uint32 {
	return 1
}

func (n *BR[K, V]) IsAlive() bool {
	return true
}

func (n *BR[K, V]) IsRetired() bool {
	panic("not implemented")
}

func (n *BR[K, V]) Retire() {
	panic("not implemented")
}

func (n *BR[K, V]) IsDead() bool {
	panic("not implemented")
}

func (n *BR[K, V]) Die() {
	panic("not implemented")
}

func (n *BR[K, V]) GetQueueType() uint8 {
	panic("not implemented")
}

func (n *BR[K, V]) SetQueueType(queueType uint8) {
	panic("not implemented")
}

func (n *BR[K, V]) InWindow() bool {
	return n.GetQueueType() == InWindowQueue
}

func (n *BR[K, V]) MakeWindow() {
	n.SetQueueType(InWindowQueue)
}

func (n *BR[K, V]) InMainProbation() bool {
	return n.GetQueueType() == InMainProbationQueue
}

func (n *BR[K, V]) MakeMainProbation() {
	n.SetQueueType(InMainProbationQueue)
}

func (n *BR[K, V]) InMainProtected() bool {
	return n.GetQueueType() == InMainProtectedQueue
}

func (n *BR[K, V]) MakeMainProtected() {
	n.SetQueueType(InMainProtectedQueue)
}
