# Swag [![Build Status](https://github.com/go-openapi/swag/actions/workflows/go-test.yml/badge.svg)](https://github.com/go-openapi/swag/actions?query=workflow%3A"go+test") [![codecov](https://codecov.io/gh/go-openapi/swag/branch/master/graph/badge.svg)](https://codecov.io/gh/go-openapi/swag)

[![Slack Status](https://slackin.goswagger.io/badge.svg)](https://slackin.goswagger.io)
[![license](https://img.shields.io/badge/license-Apache%20v2-orange.svg)](https://raw.githubusercontent.com/go-openapi/swag/master/LICENSE)
[![Go Reference](https://pkg.go.dev/badge/github.com/go-openapi/swag.svg)](https://pkg.go.dev/github.com/go-openapi/swag)
[![Go Report Card](https://goreportcard.com/badge/github.com/go-openapi/swag)](https://goreportcard.com/report/github.com/go-openapi/swag)

Package `swag` contains a bunch of helper functions for go-openapi and go-swagger projects.

You may also use it standalone for your projects.

> `swag` is one of the foundational building blocks of the go-openapi initiative.
>
> Most repositories in `github.com/go-openapi/...` depend on it in some way.
> So does the CLI tool `github.com/go-swagger/go-swagger`,
> and the code generated by this tool.

## Contents

`go-openapi/swag` now exposes a collection of relatively independent modules.

Here is what is inside:

*	Module `cmdutils`

  * [x] utilities to work with CLIs

*	Module `conv`

  * [x] convert between values and pointers for any types
  * [x] convert from string to builtin types (wraps `strconv`)
  * [x] require `./typeutils` (test dependency)

*	Module `fileutils`

  * [x] file upload type
  * [x] search in path (deprecated)

* Module `jsonname`

  * [x] infer JSON names from go properties

* Module `jsonutils`

  * [x] fast json concatenation
  * [x] read and write JSON from and to dynamic go data structures
  * [x] require `github.com/mailru/easyjson`

* Module `loading`

  * [x] load from file or http
  * [x] require `./yamlutils`

* Module `mangling`

  * [x] name mangling for go

* Module `netutils`

  * [x] host, port from address

*	Module `stringutils`

  * [x] search in slice (with case-insensitive)
  * [x] split/join query parameters as arrays

*	Module `typeutils`

  * [x] check the zero value for any type

* Module `yamlutils`

  * [x] converting YAML to JSON
  * [x] loading YAML into a dynamic YAML document
  * [x] require `./jsonutils`
  * [x] require `github.com/mailru/easyjson`
  * [x] require `gopkg.in/yaml.v3`

---

The root module `github.com/go-openapi/swag` at the repo level maintains a few 
dependencies outside of the standard library:

* YAML utilities depend on `gopkg.in/yaml.v3`
* JSON utilities `github.com/mailru/easyjson`

This is not necessarily the case for all sub-modules.

## Release notes

### v0.25.0 [draft, unreleased]

* v0.25.0 will remove the dependency to `mailru/easyjson` by default.
* users of JSON or YAML utility who want to use `easyjson` as their
  prefered JSON marshaler will be able to do so by registering it
  at runtime.

### v0.24.0

With this release, we have largely modernized the API of `swag`:

* The traditional `swag` API is still supported: code that imports `swag` will still
  compile and work the same.
* A deprecation notice is published to encourage consumers of this library to adopt
  the newer API
* **Deprecation notice** 
  * configuration through global variables is now deprecated, in favor of options passed as parameters
  * all helper functions are moved to more specialized packages, which are exposed as 
    go modules. Importing such a module would reduce the footprint of dependencies.
  * _all_ functions, variables, constants exposed by the deprecated API have now moved, so
    that consumers of the new API no longer need to import github.com/go-openapi/swag, but
    should import the desired sub-module(s).

**New with this release**:

* [x] type converters and pointer to value helpers now support generic types
* [x] name mangling now support pluralized initialisms (issue #46)
      Strings like "contact IDs" are now recognized as such a plural form and mangled as a linter would expect.
* [x] performance: small improvements to reduce the overhead of convert/format wrappers (see issues #110, or PR #108)
* [x] performance: name mangling utilities run ~ 10% faster (PR #115)

---

Moving forward, no additional feature will be added to the `swag` API directly.

However, child modules will continue to evolve or some new ones may be added in the future.


#### Note to contributors

The mono-repo structure comes with some unavoidable extra pains...

* Testing

> The usual `go test ./...` command, run from the root of this repo won't work any longer to test all submodules.
>
> Each module constitutes an independant unit of test. So you have to run `go test` inside each module.
> Or you may take a look at how this is achieved by CI
> [here] https://github.com/go-openapi/swag/blob/master/.github/workflows/go-test.yml).
>
> There are also some alternative tricks using `go work`, for local development, if you feel comfortable with
> go workspaces. Perhaps some day, we'll have a `go work test` to run all tests without any hack.

* Releasing

> Each module follows its own independant module versioning.
>
> So you have tags like `mangling/v0.24.0`, `fileutils/v0.24.0` etc that are used by `go mod` and `go get`
> to refer to the tagged version of each module specifically.
>
> This means we may release patches etc to each module independently.
>
> We'd like to adopt the rule that modules in this repo would only differ by a patch version
> (e.g. `v0.24.5` vs `v0.24.3`), and we'll level all modules whenever a minor version is introduced.
>
> A script in `./hack` is provided to tag all modules in one go at the same level in one go.

## Todos, suggestions and plans

All kinds of contributions are welcome.

A few ideas:

* [ ] Complete the split of dependencies to isolate easyjson from the rest
* [ ] Improve mangling utilities (improve readability, support for capitalized words,
      better word substitution for non-letter symbols...)
* [ ] Move back to this common shared pot a few of the technical features introduced by go-swagger independently
      (e.g. mangle go package names, search package with go modules support, ...)
* [ ] Apply a similar mono-repo approach to go-openapi/strfmt which suffer from similar woes: bloated API,
      imposed dependency to some database driver.

