// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"encoding/json"
	"fmt"
)

type ServiceScanTransportProtocol string

const (
	ServiceScanTransportProtocolUnknown ServiceScanTransportProtocol = ""
	ServiceScanTransportProtocolTCP     ServiceScanTransportProtocol = "tcp"
	ServiceScanTransportProtocolUDP     ServiceScanTransportProtocol = "udp"
	ServiceScanTransportProtocolIcmp    ServiceScanTransportProtocol = "icmp"
	ServiceScanTransportProtocolQuic    ServiceScanTransportProtocol = "quic"
)

func (e ServiceScanTransportProtocol) ToPointer() *ServiceScanTransportProtocol {
	return &e
}
func (e *ServiceScanTransportProtocol) UnmarshalJSON(data []byte) error {
	var v string
	if err := json.Unmarshal(data, &v); err != nil {
		return err
	}
	switch v {
	case "":
		fallthrough
	case "tcp":
		fallthrough
	case "udp":
		fallthrough
	case "icmp":
		fallthrough
	case "quic":
		*e = ServiceScanTransportProtocol(v)
		return nil
	default:
		return fmt.Errorf("invalid value for ServiceScanTransportProtocol: %v", v)
	}
}

type ServiceScan struct {
	Activemq           *Activemq                     `json:"activemq,omitempty"`
	Amqp               *Amqp                         `json:"amqp,omitempty"`
	AnyConnect         *AnyConnect                   `json:"any_connect,omitempty"`
	Bacnet             *Bacnet                       `json:"bacnet,omitempty"`
	Banner             *string                       `json:"banner,omitempty"`
	BannerHashSha256   *string                       `json:"banner_hash_sha256,omitempty"`
	CheckpointTopology *CheckpointTopology           `json:"checkpoint_topology,omitempty"`
	Chromecast         *Chromecast                   `json:"chromecast,omitempty"`
	CiscoIpsla         *CiscoIpsla                   `json:"cisco_ipsla,omitempty"`
	Cmore              *Cmore                        `json:"cmore,omitempty"`
	Coap               *Coap                         `json:"coap,omitempty"`
	CrestronCp3        *CrestronCp3                  `json:"crestron_cp3,omitempty"`
	CrestronDinAp2     *CrestronDinAp2               `json:"crestron_din_ap2,omitempty"`
	Cwmp               *Cwmp                         `json:"cwmp,omitempty"`
	Darkcomet          *Darkcomet                    `json:"darkcomet,omitempty"`
	Darkgate           *Darkgate                     `json:"darkgate,omitempty"`
	Dcerpc             *Dcerpc                       `json:"dcerpc,omitempty"`
	Dhcpdiscover       *Dhcpdiscover                 `json:"dhcpdiscover,omitempty"`
	Dnp3               *Dnp3                         `json:"dnp3,omitempty"`
	DNS                *DNS                          `json:"dns,omitempty"`
	Dtls               *Dtls                         `json:"dtls,omitempty"`
	DvrIP              *DvrIP                        `json:"dvr_ip,omitempty"`
	Eip                *Eip                          `json:"eip,omitempty"`
	ElfFile            *ElfFile                      `json:"elf_file,omitempty"`
	Epmd               *Epmd                         `json:"epmd,omitempty"`
	Etcd               *Etcd                         `json:"etcd,omitempty"`
	Ethereum           *Ethereum                     `json:"ethereum,omitempty"`
	Fox                *Fox                          `json:"fox,omitempty"`
	Ftp                *Ftp                          `json:"ftp,omitempty"`
	Gearman            *Gearman                      `json:"gearman,omitempty"`
	HidVertx           *HidVertx                     `json:"hid_vertx,omitempty"`
	Hikvision          *Hikvision                    `json:"hikvision,omitempty"`
	Ibmnje             *Ibmnje                       `json:"ibmnje,omitempty"`
	Ike                *Ike                          `json:"ike,omitempty"`
	Imap               *Imap                         `json:"imap,omitempty"`
	Iota               *Iota                         `json:"iota,omitempty"`
	IP                 *string                       `json:"ip,omitempty"`
	Ipmi               *Ipmi                         `json:"ipmi,omitempty"`
	Ipp                *Ipp                          `json:"ipp,omitempty"`
	IsSuccess          *bool                         `json:"is_success,omitempty"`
	Iscsi              *Iscsi                        `json:"iscsi,omitempty"`
	Krpc               *Krpc                         `json:"krpc,omitempty"`
	L2tp               *L2Tp                         `json:"l2tp,omitempty"`
	Ldap               *Ldap                         `json:"ldap,omitempty"`
	Lpd                *Lpd                          `json:"lpd,omitempty"`
	Mdns               *Mdns                         `json:"mdns,omitempty"`
	Memcached          *Memcached                    `json:"memcached,omitempty"`
	Minecraft          *Minecraft                    `json:"minecraft,omitempty"`
	Mms                *Mms                          `json:"mms,omitempty"`
	Modbus             *Modbus                       `json:"modbus,omitempty"`
	MoneroP2p          *MoneroP2P                    `json:"monero_p2p,omitempty"`
	Mongodb            *Mongodb                      `json:"mongodb,omitempty"`
	Mqtt               *Mqtt                         `json:"mqtt,omitempty"`
	Mssql              *Mssql                        `json:"mssql,omitempty"`
	Murmur             *Murmur                       `json:"murmur,omitempty"`
	Mysql              *Mysql                        `json:"mysql,omitempty"`
	NatsIo             *NatsIo                       `json:"nats_io,omitempty"`
	Nbd                *Nbd                          `json:"nbd,omitempty"`
	NfsMountd          *NfsMountd                    `json:"nfs_mountd,omitempty"`
	Nmea               *Nmea                         `json:"nmea,omitempty"`
	Ntp                *Ntp                          `json:"ntp,omitempty"`
	Ntrip              *Ntrip                        `json:"ntrip,omitempty"`
	Onc                *Onc                          `json:"onc,omitempty"`
	Onvif              *Onvif                        `json:"onvif,omitempty"`
	OpcUa              *OpcUa                        `json:"opc_ua,omitempty"`
	Openvpn            *Openvpn                      `json:"openvpn,omitempty"`
	Oracle             *Oracle                       `json:"oracle,omitempty"`
	PcAnywhere         *PcAnywhere                   `json:"pc_anywhere,omitempty"`
	Pgbouncer          *Pgbouncer                    `json:"pgbouncer,omitempty"`
	Pop3               *Pop3                         `json:"pop3,omitempty"`
	Port               *int                          `json:"port,omitempty"`
	Portmap            *Portmap                      `json:"portmap,omitempty"`
	Postgres           *Postgres                     `json:"postgres,omitempty"`
	Pptp               *Pptp                         `json:"pptp,omitempty"`
	ProfinetCm         *ProfinetCm                   `json:"profinet_cm,omitempty"`
	Protocol           *string                       `json:"protocol,omitempty"`
	Rdate              *Rdate                        `json:"rdate,omitempty"`
	Rdp                *Rdp                          `json:"rdp,omitempty"`
	Realport           *Realport                     `json:"realport,omitempty"`
	Redis              *Redis                        `json:"redis,omitempty"`
	Redline            *Redline                      `json:"redline,omitempty"`
	RedlionCrimson     *RedlionCrimson               `json:"redlion_crimson,omitempty"`
	RepresentativeInfo *RepresentativeInfo           `json:"representative_info,omitempty"`
	Rifatron           *Rifatron                     `json:"rifatron,omitempty"`
	Ripple             *Ripple                       `json:"ripple,omitempty"`
	Rlogin             *Rlogin                       `json:"rlogin,omitempty"`
	Rocketmq           *Rocketmq                     `json:"rocketmq,omitempty"`
	Rtsp               *Rtsp                         `json:"rtsp,omitempty"`
	S7                 *S7                           `json:"s7,omitempty"`
	SapRouter          *SapRouter                    `json:"sap_router,omitempty"`
	ScanTime           *string                       `json:"scan_time,omitempty"`
	Scpi               *Scpi                         `json:"scpi,omitempty"`
	Screenshots        []Screenshot                  `json:"screenshots,omitempty"`
	Ser2net            *Ser2Net                      `json:"ser2net,omitempty"`
	SevenDaysToDie     *SevenDaysToDie               `json:"seven_days_to_die,omitempty"`
	Sip                *Sip                          `json:"sip,omitempty"`
	Skinny             *Skinny                       `json:"skinny,omitempty"`
	Smb                *Smb                          `json:"smb,omitempty"`
	SMTP               *SMTP                         `json:"smtp,omitempty"`
	Snmp               *Snmp                         `json:"snmp,omitempty"`
	Socks              *Socks                        `json:"socks,omitempty"`
	Spice              *Spice                        `json:"spice,omitempty"`
	Ssdp               *Ssdp                         `json:"ssdp,omitempty"`
	SSH                *SSH                          `json:"ssh,omitempty"`
	Steam              *Steam                        `json:"steam,omitempty"`
	TacacsPlus         *TacacsPlus                   `json:"tacacs_plus,omitempty"`
	TeamViewer         *TeamViewer                   `json:"team_viewer,omitempty"`
	Telnet             *Telnet                       `json:"telnet,omitempty"`
	Tibia              *Tibia                        `json:"tibia,omitempty"`
	TLS                *TLS                          `json:"tls,omitempty"`
	TplinkKasa         *TplinkKasa                   `json:"tplink_kasa,omitempty"`
	TransportProtocol  *ServiceScanTransportProtocol `json:"transport_protocol,omitempty"`
	UnitronicsPcom     *UnitronicsPcom               `json:"unitronics_pcom,omitempty"`
	Upnp               *Upnp                         `json:"upnp,omitempty"`
	Ventrilo           *Ventrilo                     `json:"ventrilo,omitempty"`
	Vnc                *Vnc                          `json:"vnc,omitempty"`
	WeblogicT3         *WeblogicT3                   `json:"weblogic_t3,omitempty"`
	Winrm              *Winrm                        `json:"winrm,omitempty"`
	WsDiscovery        *WsDiscovery                  `json:"ws_discovery,omitempty"`
	X11                *X11                          `json:"x11,omitempty"`
	Zeromq             *Zeromq                       `json:"zeromq,omitempty"`
}

func (o *ServiceScan) GetActivemq() *Activemq {
	if o == nil {
		return nil
	}
	return o.Activemq
}

func (o *ServiceScan) GetAmqp() *Amqp {
	if o == nil {
		return nil
	}
	return o.Amqp
}

func (o *ServiceScan) GetAnyConnect() *AnyConnect {
	if o == nil {
		return nil
	}
	return o.AnyConnect
}

func (o *ServiceScan) GetBacnet() *Bacnet {
	if o == nil {
		return nil
	}
	return o.Bacnet
}

func (o *ServiceScan) GetBanner() *string {
	if o == nil {
		return nil
	}
	return o.Banner
}

func (o *ServiceScan) GetBannerHashSha256() *string {
	if o == nil {
		return nil
	}
	return o.BannerHashSha256
}

func (o *ServiceScan) GetCheckpointTopology() *CheckpointTopology {
	if o == nil {
		return nil
	}
	return o.CheckpointTopology
}

func (o *ServiceScan) GetChromecast() *Chromecast {
	if o == nil {
		return nil
	}
	return o.Chromecast
}

func (o *ServiceScan) GetCiscoIpsla() *CiscoIpsla {
	if o == nil {
		return nil
	}
	return o.CiscoIpsla
}

func (o *ServiceScan) GetCmore() *Cmore {
	if o == nil {
		return nil
	}
	return o.Cmore
}

func (o *ServiceScan) GetCoap() *Coap {
	if o == nil {
		return nil
	}
	return o.Coap
}

func (o *ServiceScan) GetCrestronCp3() *CrestronCp3 {
	if o == nil {
		return nil
	}
	return o.CrestronCp3
}

func (o *ServiceScan) GetCrestronDinAp2() *CrestronDinAp2 {
	if o == nil {
		return nil
	}
	return o.CrestronDinAp2
}

func (o *ServiceScan) GetCwmp() *Cwmp {
	if o == nil {
		return nil
	}
	return o.Cwmp
}

func (o *ServiceScan) GetDarkcomet() *Darkcomet {
	if o == nil {
		return nil
	}
	return o.Darkcomet
}

func (o *ServiceScan) GetDarkgate() *Darkgate {
	if o == nil {
		return nil
	}
	return o.Darkgate
}

func (o *ServiceScan) GetDcerpc() *Dcerpc {
	if o == nil {
		return nil
	}
	return o.Dcerpc
}

func (o *ServiceScan) GetDhcpdiscover() *Dhcpdiscover {
	if o == nil {
		return nil
	}
	return o.Dhcpdiscover
}

func (o *ServiceScan) GetDnp3() *Dnp3 {
	if o == nil {
		return nil
	}
	return o.Dnp3
}

func (o *ServiceScan) GetDNS() *DNS {
	if o == nil {
		return nil
	}
	return o.DNS
}

func (o *ServiceScan) GetDtls() *Dtls {
	if o == nil {
		return nil
	}
	return o.Dtls
}

func (o *ServiceScan) GetDvrIP() *DvrIP {
	if o == nil {
		return nil
	}
	return o.DvrIP
}

func (o *ServiceScan) GetEip() *Eip {
	if o == nil {
		return nil
	}
	return o.Eip
}

func (o *ServiceScan) GetElfFile() *ElfFile {
	if o == nil {
		return nil
	}
	return o.ElfFile
}

func (o *ServiceScan) GetEpmd() *Epmd {
	if o == nil {
		return nil
	}
	return o.Epmd
}

func (o *ServiceScan) GetEtcd() *Etcd {
	if o == nil {
		return nil
	}
	return o.Etcd
}

func (o *ServiceScan) GetEthereum() *Ethereum {
	if o == nil {
		return nil
	}
	return o.Ethereum
}

func (o *ServiceScan) GetFox() *Fox {
	if o == nil {
		return nil
	}
	return o.Fox
}

func (o *ServiceScan) GetFtp() *Ftp {
	if o == nil {
		return nil
	}
	return o.Ftp
}

func (o *ServiceScan) GetGearman() *Gearman {
	if o == nil {
		return nil
	}
	return o.Gearman
}

func (o *ServiceScan) GetHidVertx() *HidVertx {
	if o == nil {
		return nil
	}
	return o.HidVertx
}

func (o *ServiceScan) GetHikvision() *Hikvision {
	if o == nil {
		return nil
	}
	return o.Hikvision
}

func (o *ServiceScan) GetIbmnje() *Ibmnje {
	if o == nil {
		return nil
	}
	return o.Ibmnje
}

func (o *ServiceScan) GetIke() *Ike {
	if o == nil {
		return nil
	}
	return o.Ike
}

func (o *ServiceScan) GetImap() *Imap {
	if o == nil {
		return nil
	}
	return o.Imap
}

func (o *ServiceScan) GetIota() *Iota {
	if o == nil {
		return nil
	}
	return o.Iota
}

func (o *ServiceScan) GetIP() *string {
	if o == nil {
		return nil
	}
	return o.IP
}

func (o *ServiceScan) GetIpmi() *Ipmi {
	if o == nil {
		return nil
	}
	return o.Ipmi
}

func (o *ServiceScan) GetIpp() *Ipp {
	if o == nil {
		return nil
	}
	return o.Ipp
}

func (o *ServiceScan) GetIsSuccess() *bool {
	if o == nil {
		return nil
	}
	return o.IsSuccess
}

func (o *ServiceScan) GetIscsi() *Iscsi {
	if o == nil {
		return nil
	}
	return o.Iscsi
}

func (o *ServiceScan) GetKrpc() *Krpc {
	if o == nil {
		return nil
	}
	return o.Krpc
}

func (o *ServiceScan) GetL2tp() *L2Tp {
	if o == nil {
		return nil
	}
	return o.L2tp
}

func (o *ServiceScan) GetLdap() *Ldap {
	if o == nil {
		return nil
	}
	return o.Ldap
}

func (o *ServiceScan) GetLpd() *Lpd {
	if o == nil {
		return nil
	}
	return o.Lpd
}

func (o *ServiceScan) GetMdns() *Mdns {
	if o == nil {
		return nil
	}
	return o.Mdns
}

func (o *ServiceScan) GetMemcached() *Memcached {
	if o == nil {
		return nil
	}
	return o.Memcached
}

func (o *ServiceScan) GetMinecraft() *Minecraft {
	if o == nil {
		return nil
	}
	return o.Minecraft
}

func (o *ServiceScan) GetMms() *Mms {
	if o == nil {
		return nil
	}
	return o.Mms
}

func (o *ServiceScan) GetModbus() *Modbus {
	if o == nil {
		return nil
	}
	return o.Modbus
}

func (o *ServiceScan) GetMoneroP2p() *MoneroP2P {
	if o == nil {
		return nil
	}
	return o.MoneroP2p
}

func (o *ServiceScan) GetMongodb() *Mongodb {
	if o == nil {
		return nil
	}
	return o.Mongodb
}

func (o *ServiceScan) GetMqtt() *Mqtt {
	if o == nil {
		return nil
	}
	return o.Mqtt
}

func (o *ServiceScan) GetMssql() *Mssql {
	if o == nil {
		return nil
	}
	return o.Mssql
}

func (o *ServiceScan) GetMurmur() *Murmur {
	if o == nil {
		return nil
	}
	return o.Murmur
}

func (o *ServiceScan) GetMysql() *Mysql {
	if o == nil {
		return nil
	}
	return o.Mysql
}

func (o *ServiceScan) GetNatsIo() *NatsIo {
	if o == nil {
		return nil
	}
	return o.NatsIo
}

func (o *ServiceScan) GetNbd() *Nbd {
	if o == nil {
		return nil
	}
	return o.Nbd
}

func (o *ServiceScan) GetNfsMountd() *NfsMountd {
	if o == nil {
		return nil
	}
	return o.NfsMountd
}

func (o *ServiceScan) GetNmea() *Nmea {
	if o == nil {
		return nil
	}
	return o.Nmea
}

func (o *ServiceScan) GetNtp() *Ntp {
	if o == nil {
		return nil
	}
	return o.Ntp
}

func (o *ServiceScan) GetNtrip() *Ntrip {
	if o == nil {
		return nil
	}
	return o.Ntrip
}

func (o *ServiceScan) GetOnc() *Onc {
	if o == nil {
		return nil
	}
	return o.Onc
}

func (o *ServiceScan) GetOnvif() *Onvif {
	if o == nil {
		return nil
	}
	return o.Onvif
}

func (o *ServiceScan) GetOpcUa() *OpcUa {
	if o == nil {
		return nil
	}
	return o.OpcUa
}

func (o *ServiceScan) GetOpenvpn() *Openvpn {
	if o == nil {
		return nil
	}
	return o.Openvpn
}

func (o *ServiceScan) GetOracle() *Oracle {
	if o == nil {
		return nil
	}
	return o.Oracle
}

func (o *ServiceScan) GetPcAnywhere() *PcAnywhere {
	if o == nil {
		return nil
	}
	return o.PcAnywhere
}

func (o *ServiceScan) GetPgbouncer() *Pgbouncer {
	if o == nil {
		return nil
	}
	return o.Pgbouncer
}

func (o *ServiceScan) GetPop3() *Pop3 {
	if o == nil {
		return nil
	}
	return o.Pop3
}

func (o *ServiceScan) GetPort() *int {
	if o == nil {
		return nil
	}
	return o.Port
}

func (o *ServiceScan) GetPortmap() *Portmap {
	if o == nil {
		return nil
	}
	return o.Portmap
}

func (o *ServiceScan) GetPostgres() *Postgres {
	if o == nil {
		return nil
	}
	return o.Postgres
}

func (o *ServiceScan) GetPptp() *Pptp {
	if o == nil {
		return nil
	}
	return o.Pptp
}

func (o *ServiceScan) GetProfinetCm() *ProfinetCm {
	if o == nil {
		return nil
	}
	return o.ProfinetCm
}

func (o *ServiceScan) GetProtocol() *string {
	if o == nil {
		return nil
	}
	return o.Protocol
}

func (o *ServiceScan) GetRdate() *Rdate {
	if o == nil {
		return nil
	}
	return o.Rdate
}

func (o *ServiceScan) GetRdp() *Rdp {
	if o == nil {
		return nil
	}
	return o.Rdp
}

func (o *ServiceScan) GetRealport() *Realport {
	if o == nil {
		return nil
	}
	return o.Realport
}

func (o *ServiceScan) GetRedis() *Redis {
	if o == nil {
		return nil
	}
	return o.Redis
}

func (o *ServiceScan) GetRedline() *Redline {
	if o == nil {
		return nil
	}
	return o.Redline
}

func (o *ServiceScan) GetRedlionCrimson() *RedlionCrimson {
	if o == nil {
		return nil
	}
	return o.RedlionCrimson
}

func (o *ServiceScan) GetRepresentativeInfo() *RepresentativeInfo {
	if o == nil {
		return nil
	}
	return o.RepresentativeInfo
}

func (o *ServiceScan) GetRifatron() *Rifatron {
	if o == nil {
		return nil
	}
	return o.Rifatron
}

func (o *ServiceScan) GetRipple() *Ripple {
	if o == nil {
		return nil
	}
	return o.Ripple
}

func (o *ServiceScan) GetRlogin() *Rlogin {
	if o == nil {
		return nil
	}
	return o.Rlogin
}

func (o *ServiceScan) GetRocketmq() *Rocketmq {
	if o == nil {
		return nil
	}
	return o.Rocketmq
}

func (o *ServiceScan) GetRtsp() *Rtsp {
	if o == nil {
		return nil
	}
	return o.Rtsp
}

func (o *ServiceScan) GetS7() *S7 {
	if o == nil {
		return nil
	}
	return o.S7
}

func (o *ServiceScan) GetSapRouter() *SapRouter {
	if o == nil {
		return nil
	}
	return o.SapRouter
}

func (o *ServiceScan) GetScanTime() *string {
	if o == nil {
		return nil
	}
	return o.ScanTime
}

func (o *ServiceScan) GetScpi() *Scpi {
	if o == nil {
		return nil
	}
	return o.Scpi
}

func (o *ServiceScan) GetScreenshots() []Screenshot {
	if o == nil {
		return nil
	}
	return o.Screenshots
}

func (o *ServiceScan) GetSer2net() *Ser2Net {
	if o == nil {
		return nil
	}
	return o.Ser2net
}

func (o *ServiceScan) GetSevenDaysToDie() *SevenDaysToDie {
	if o == nil {
		return nil
	}
	return o.SevenDaysToDie
}

func (o *ServiceScan) GetSip() *Sip {
	if o == nil {
		return nil
	}
	return o.Sip
}

func (o *ServiceScan) GetSkinny() *Skinny {
	if o == nil {
		return nil
	}
	return o.Skinny
}

func (o *ServiceScan) GetSmb() *Smb {
	if o == nil {
		return nil
	}
	return o.Smb
}

func (o *ServiceScan) GetSMTP() *SMTP {
	if o == nil {
		return nil
	}
	return o.SMTP
}

func (o *ServiceScan) GetSnmp() *Snmp {
	if o == nil {
		return nil
	}
	return o.Snmp
}

func (o *ServiceScan) GetSocks() *Socks {
	if o == nil {
		return nil
	}
	return o.Socks
}

func (o *ServiceScan) GetSpice() *Spice {
	if o == nil {
		return nil
	}
	return o.Spice
}

func (o *ServiceScan) GetSsdp() *Ssdp {
	if o == nil {
		return nil
	}
	return o.Ssdp
}

func (o *ServiceScan) GetSSH() *SSH {
	if o == nil {
		return nil
	}
	return o.SSH
}

func (o *ServiceScan) GetSteam() *Steam {
	if o == nil {
		return nil
	}
	return o.Steam
}

func (o *ServiceScan) GetTacacsPlus() *TacacsPlus {
	if o == nil {
		return nil
	}
	return o.TacacsPlus
}

func (o *ServiceScan) GetTeamViewer() *TeamViewer {
	if o == nil {
		return nil
	}
	return o.TeamViewer
}

func (o *ServiceScan) GetTelnet() *Telnet {
	if o == nil {
		return nil
	}
	return o.Telnet
}

func (o *ServiceScan) GetTibia() *Tibia {
	if o == nil {
		return nil
	}
	return o.Tibia
}

func (o *ServiceScan) GetTLS() *TLS {
	if o == nil {
		return nil
	}
	return o.TLS
}

func (o *ServiceScan) GetTplinkKasa() *TplinkKasa {
	if o == nil {
		return nil
	}
	return o.TplinkKasa
}

func (o *ServiceScan) GetTransportProtocol() *ServiceScanTransportProtocol {
	if o == nil {
		return nil
	}
	return o.TransportProtocol
}

func (o *ServiceScan) GetUnitronicsPcom() *UnitronicsPcom {
	if o == nil {
		return nil
	}
	return o.UnitronicsPcom
}

func (o *ServiceScan) GetUpnp() *Upnp {
	if o == nil {
		return nil
	}
	return o.Upnp
}

func (o *ServiceScan) GetVentrilo() *Ventrilo {
	if o == nil {
		return nil
	}
	return o.Ventrilo
}

func (o *ServiceScan) GetVnc() *Vnc {
	if o == nil {
		return nil
	}
	return o.Vnc
}

func (o *ServiceScan) GetWeblogicT3() *WeblogicT3 {
	if o == nil {
		return nil
	}
	return o.WeblogicT3
}

func (o *ServiceScan) GetWinrm() *Winrm {
	if o == nil {
		return nil
	}
	return o.Winrm
}

func (o *ServiceScan) GetWsDiscovery() *WsDiscovery {
	if o == nil {
		return nil
	}
	return o.WsDiscovery
}

func (o *ServiceScan) GetX11() *X11 {
	if o == nil {
		return nil
	}
	return o.X11
}

func (o *ServiceScan) GetZeromq() *Zeromq {
	if o == nil {
		return nil
	}
	return o.Zeromq
}
