// Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.

package components

import (
	"github.com/censys/censys-sdk-go/internal/utils"
)

type SearchAggregateInputBody struct {
	// Specifies which document level's count is returned per term bucket, primarily for nested fields. This is the same functionality available in the Count By dropdown in the Report Builder UI. When aggregating on nested fields like 'host.services.port': empty string (default) counts documents at the deepest level containing the field; '.' counts root documents (e.g. counts matching 'host'); 'host.services' counts documents at the specified nested level.
	CountByLevel *string `json:"count_by_level,omitempty"`
	// field to aggregate by
	Field string `json:"field"`
	// Controls whether aggregation results are limited to values that match the query. When true, only field values that satisfy the query constraints are included in aggregation counts. When false, aggregation includes all field values from records that match the query, even if those specific field values don't match the query constraints. For example, if the query is 'host.services.protocol=SSH' and you are aggregating by 'host.services.port' - when true, only shows SSH ports; when false, shows all ports on hosts that have SSH services.
	FilterByQuery *bool `default:"false" json:"filter_by_query"`
	// number of buckets to split results into
	NumberOfBuckets int64 `json:"number_of_buckets"`
	// CenQL query string to search upon
	Query string `json:"query"`
}

func (s SearchAggregateInputBody) MarshalJSON() ([]byte, error) {
	return utils.MarshalJSON(s, "", false)
}

func (s *SearchAggregateInputBody) UnmarshalJSON(data []byte) error {
	if err := utils.UnmarshalJSON(data, &s, "", false, false); err != nil {
		return err
	}
	return nil
}

func (o *SearchAggregateInputBody) GetCountByLevel() *string {
	if o == nil {
		return nil
	}
	return o.CountByLevel
}

func (o *SearchAggregateInputBody) GetField() string {
	if o == nil {
		return ""
	}
	return o.Field
}

func (o *SearchAggregateInputBody) GetFilterByQuery() *bool {
	if o == nil {
		return nil
	}
	return o.FilterByQuery
}

func (o *SearchAggregateInputBody) GetNumberOfBuckets() int64 {
	if o == nil {
		return 0
	}
	return o.NumberOfBuckets
}

func (o *SearchAggregateInputBody) GetQuery() string {
	if o == nil {
		return ""
	}
	return o.Query
}
