# HTTP


## Fields

| Field                                                                                                                                 | Type                                                                                                                                  | Required                                                                                                                              | Description                                                                                                                           |
| ------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------- |
| `Body`                                                                                                                                | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | The body of the HTTP response. For hosts without a name, the first 64KB are available. For hosts with a name, only 6KB are available. |
| `BodyHashSha1`                                                                                                                        | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | N/A                                                                                                                                   |
| `BodyHashSha256`                                                                                                                      | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | N/A                                                                                                                                   |
| `BodyHashTlsh`                                                                                                                        | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | N/A                                                                                                                                   |
| `BodySize`                                                                                                                            | **int*                                                                                                                                | :heavy_minus_sign:                                                                                                                    | The length, in bytes, of services.http.response.body; at most, 64KB.                                                                  |
| `Favicons`                                                                                                                            | [][components.HTTPFavicon](../../models/components/httpfavicon.md)                                                                    | :heavy_minus_sign:                                                                                                                    | N/A                                                                                                                                   |
| `Headers`                                                                                                                             | map[string][components.HTTPRepeatedHeaders](../../models/components/httprepeatedheaders.md)                                           | :heavy_minus_sign:                                                                                                                    | The key-value header pairs included in the response.                                                                                  |
| `HTMLTags`                                                                                                                            | []*string*                                                                                                                            | :heavy_minus_sign:                                                                                                                    | A list of the <title> and <meta> tags from services.http.response.body.                                                               |
| `HTMLTitle`                                                                                                                           | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | The title of the HTML page: the inner contents of the <title> tag in the response body, if present.                                   |
| `Protocol`                                                                                                                            | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | The protocol field of the response, which includes the claimed HTTP version number.                                                   |
| `StatusCode`                                                                                                                          | **int*                                                                                                                                | :heavy_minus_sign:                                                                                                                    | A 3-digit integer result code indicating the result of the services.http.request.                                                     |
| `StatusReason`                                                                                                                        | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | A human-readable phrase describing the status code.                                                                                   |
| `SupportedVersions`                                                                                                                   | []*string*                                                                                                                            | :heavy_minus_sign:                                                                                                                    | N/A                                                                                                                                   |
| `URI`                                                                                                                                 | **string*                                                                                                                             | :heavy_minus_sign:                                                                                                                    | The full path used to make the request, which includes the scheme, host, port (when non-standard), and endpoint.                      |